/*
***************************************************************************************************
***---------------------------------------------------------------------------------------------***
***--  Scripted Global Function, Variable and Plugin Library for Autodesk Civil View          --***
***--  � Copyright 2011 Autodesk, Inc. All rights reserved.                                   --***
***---------------------------------------------------------------------------------------------***
***************************************************************************************************
*/

global DYNcivilViewStarted = GetINISetting (getMAXIniFile()) "CivilView" "CivilViewStarted"
global DYNcreatable = DYNcivilViewStarted != "0" and DYNcivilViewStarted != ""

-- This plugin should be permanently invisible to the UI
plugin shape CivilView_Alignment name:~PLUGIN_CIVILALIGNMENT_NAME~ category:~PLUGIN_CIVILALIGNMENT_CATEGORY~ classID:#(0x6aa2f1a5, 0x6303aed2) extends:splineshape invisible:true
(
  parameters main
  (
    /*
    ---------------------------------------------------
    StartStation and EndStation
    ---------------------------------------------------
    The linear design measurement recorded at the first and last point on the base
    alignment data.  Start and end stations of each profile may differ, but will never exceed these
    values.
    */
    StartStation         type:#float     animatable:false default:0.0          -- Start Station/Chainage
    EndStation           type:#float     animatable:false default:0.0          -- End Station/Chainage

    /*
    ---------------------------------------------------
    CurrentDataset
    ---------------------------------------------------
    Indicates whether (1) the basic alignment vertex dataset or (>1) which of the present profile vertex datasets is being
    used to produce the current spline solution.  A value of 0 indicates that this parameter has not been initialized.
    */
    CurrentDataset       type:#integer   animatable:false default:0

    /*
    ---------------------------------------------------
    DatasetNameArray
    ---------------------------------------------------
    DatasetNameArray is a list of profiles associated with this alignment.
    The first entry in this array will always be blank, and represents the raw alignment data
    without any profiles taken into consideration.

    For imported Civil 3D alignments, one or more profiles may be assigned to the alignment. In this case,
    additional entries will be present in this array - one name for each profile.

    The number of entries in DatasetNameArray and DatasetSizeArray are identical.
    */
    DatasetNameArray     type:#stringTab animatable:false tabSizeVariable:true -- Profile Name

    /*
    ---------------------------------------------------
    DatasetSizeArray
    ---------------------------------------------------
    DatasetSizeArray is the number of vertex datasets associated with this alignment.
    At least one vertex dataset will always exist - this is derived from the alignment itself.

    For imported Civil 3D alignments, one or more profiles may be assigned to the alignment. In this case,
    additional vertex datasets will be present - one for each profile.

    The number of entries in DatasetNameArray and DatasetSizeArray are identical and indicate the number
    of vertex datasets available. The value of each entry indicates the number of vertices associated with each dataset.
    */
    DatasetSizeArray     type:#intTab    animatable:false tabSizeVariable:true

    /*
    ---------------------------------------------------
    Various Tab Parameters
    ---------------------------------------------------
    These arrays hold the data associated with all the vertex datasets associated with this alignment
    and any associated profiles.  The values in DatasetSizeArray indicate the number of vertices (and therefore the
    start index) of each vertex dataset.
    */
    XYZStationArray      type:#point4Tab animatable:false tabSizeVariable:true -- X, Y, Z, Station/Chainage
    RadBearGradeArray    type:#point4Tab animatable:false tabSizeVariable:true -- AlignmentRadius, ALignmentBearing, ProfileRadius, ProfileGrade
    AlignEntTypeArray    type:#intTab    animatable:false tabSizeVariable:true -- AlignmentSubEntityType
    ProfileEntTypeArray  type:#intTab    animatable:false tabSizeVariable:true -- ProfileEntityType
    isAlignEntStartEnd   type:#boolTab   animatable:false tabSizeVariable:true -- isAlignmentEntStartOrEnd
    isProfileEntStartEnd type:#boolTab   animatable:false tabSizeVariable:true -- isProfileEntStartOrEnd

    /*
    ---------------------------------------------------
    Design Speed Related Parameters
    ---------------------------------------------------
    These parameters may be present on imported alignments from Civil 3D only
    */
    designSpeedComments  type:#stringTab animatable:false tabSizeVariable:true -- Array of Design Speed Comments
    designSpeedStations  type:#floatTab  animatable:false tabSizeVariable:true -- Array of Design Speed Start Stations
    designSpeedValues    type:#floatTab  animatable:false tabSizeVariable:true -- Array of Design Speed Values
  )
)
--
-- � Copyright 2011 Autodesk, Inc. All rights reserved.
--

plugin modifier DynBuilding name:~PLUGIN_CIVILBUILDING_NAME~ category:~PLUGIN_CIVILBUILDING_CATEGORY~ classID:#(0x1e0b2dec, 0x14475525) extends:extrude replaceUI:true invisible:(not DYNcreatable)
(
  parameters main rollout:params
  (
    Xamount           type:#float   animatable:false default:2.5  -- height of building
    Xsegs             type:#Integer animatable:false default:1    -- alias: segments
    XcapStart         type:#Boolean animatable:false default:false-- bottom of building
    XcapEnd           type:#Boolean animatable:false default:true -- top of building
    XcapType          type:#Integer animatable:false default:0    -- morph
    Xoutput           type:#Integer animatable:false default:1    -- mesh
    XmatIDs           type:#Boolean animatable:false default:true
    XuseShapeIDs      type:#Boolean animatable:false default:true -- use Mat IDs from shape segments
    Xsmooth           type:#Boolean animatable:false default:false
    XmapCoords        type:#Boolean animatable:false default:true -- generate map coords

    XrealWorldMapSize type:#Boolean animatable:false default:false

    -- Parameter Holders Only
    Xfloors           type:#integer animatable:false default:1    -- number of Floors
    XwallMatIDs       type:#integer animatable:false default:2    -- Material ID for walls
    XmapWidth         type:#float   animatable:false default:10.0 -- horizontal length of map
    XmapType          type:#integer animatable:false default:1    -- 1=Boxmapping-per-floor  ; 1=Boxmapping-per-building ; 3=face-mapping, 4=wrap-mapping


    on Xamount           set val do delegate.amount      = val
    on Xsegs             set val do delegate.segs        = val
    on XcapStart         set val do delegate.capStart    = val
    on XcapEnd           set val do delegate.capEnd      = val
    on XcapType          set val do delegate.capType     = val
    on Xoutput           set val do delegate.output      = val
    on XmatIDs           set val do delegate.matIDs      = val
    on XuseShapeIDs      set val do delegate.useShapeIDs = val
    on Xsmooth           set val do delegate.smooth      = val
    on XmapCoords        set val do delegate.mapCoords   = val
    on XrealWorldMapSize set val do if isProperty delegate #realWorldMapSize then delegate.realWorldMapSize = val
  )

  rollout params ~PLUGIN_CIVILBUILDING_ROLLOUT~
  (
    group ~PLUGIN_CIVILBUILDING_GROUP~
    (
      label LBtext01 ~PLUGIN_CIVILBUILDING_TEXT01~ align:#center
      label LBtext02 ~PLUGIN_CIVILBUILDING_TEXT02~ align:#center
    )
  )

  on attachedToNode node do
  (
    try
    (
      for i = 1 to numSplines node do
      (
        for ii = 1 to (numSegments node i) do (setMaterialID node i ii this.XwallMatIDs)
      )
    )
    catch ()
  )
)
/*
***************************************************************************************************
***---------------------------------------------------------------------------------------------***
***--  Scripted Function Library for Autodesk Civil View Transform/Position/Scale Controllers --***
***--  � Copyright 2011 Autodesk, Inc. All rights reserved.                                   --***
***---------------------------------------------------------------------------------------------***
***************************************************************************************************
*/


/*
DVSPxForm function was introduced in DVSP4 and used with path controller for placed objects
in conjunction with DYNXFCC/DYNXFCCV3/DYNXFCCM3. Deprecated, but required for opening
and updating legacy files.
*/
fn DVSPxForm FUNobj =
(
  local LOCq          = FUNobj.transform.controller
  local LOCpartMatrix = if LOCq.path != undefined then
  (
    LOCpartMatrix = DYNlxSplineInterp \          -- matrix3
                       LOCq.path \               -- <node>node
                       LOCq.spline \             -- <int>spline
                       LOCq.percent \            -- <float>distance
                       LOCq.hOffset \            -- <float>offset
                       LOCq.vOffset \            -- <float>zoffset
                       (LOCq.rotation - 180) \   -- <float>rotation
                       LOCq.followPath \         -- <BOOL>splineRotation
                       LOCq.aux2_bool \          -- <BOOL>slopeRotation
                       LOCq.aux1_bool \          -- <BOOL>loop
                       LOCq.surface \            -- <Node>surface
                       LOCq.followSurface        -- <BOOL>trackSurface
  )
  else matrix3 [1,0,0] [0,1,0] [0,0,1] [0,0,0]

  LOCq.row4 = LOCpartMatrix.row4
  LOCq.row3 = LOCpartMatrix.row3
  LOCq.row2 = LOCpartMatrix.row2
  LOCq.row1 = LOCpartMatrix.row1                 -- return value [Point3] - must be last line in function
)


/*
DVSPxFormCam function was introduced in DVSP4 and used with path controller for placed cameras
in conjunction with DYNXFCC/DYNXFCCV3/DYNXFCCM3. Deprecated, but required for opening
and updating legacy files.
*/
fn DVSPxFormCam FUNobj =
(
  local LOCq          = FUNobj.transform.controller
  local LOCpartMatrix = if LOCq.path != undefined then
  (
    LOCpartMatrix = DYNlxSplineInterpCam \
                       LOCq.path \               -- <node>node
                       LOCq.spline \             -- <int>spline
                       LOCq.percent \            -- <float>distance
                       LOCq.distance \           -- <Float>targetDistance
                       LOCq.hOffset \            -- <float>offset
                       LOCq.vOffset \            -- <float>zoffset
                       LOCq.rotation \           -- <float>rotation
                       LOCq.followPath \         -- <BOOL>splineRotation
                       LOCq.aux2_bool \          -- <BOOL>slopeRotation
  )
  else matrix3 [1,0,0] [0,1,0] [0,0,1] [0,0,0]

  LOCq.row4 = LOCpartMatrix.row4
  LOCq.row3 = LOCpartMatrix.row3
  LOCq.row2 = LOCpartMatrix.row2
  LOCq.row1 = LOCpartMatrix.row1                 -- return value [Point3] - must be last line in function
)


/*
DYNFUNmaxXForm function was deprecated in DVSP4 but previously used with path controller for placed objects
in conjunction with DYNXFCC/DYNXFCCV3/DYNXFCCM3. Required for opening and updating legacy files.
*/
fn DYNFUNmaxXForm FUNobj =
(
  local LOCpartMatrix = matrix3 [1,0,0] [0,1,0] [0,0,1] [0,0,0]         -- local Matrix3 return value
  if FUNobj != undefined then
  (
    local LOCq          = FUNobj.transform.controller

    try
    (
      if LOCq.path != undefined then
      (
        if LOCq.surface == undefined then dependsOn LOCq.path else dependsOn LOCq.path LOCq.surface -- Set Up Object Dependencies
        LOCpartMatrix = DYNlxSplineInterp \                                 -- matrix3
                           LOCq.path \               -- <node>node
                           LOCq.spline \             -- <int>spline
                           LOCq.percent \            -- <float>distance
                           LOCq.hOffset \            -- <float>offset
                           LOCq.vOffset \            -- <float>zoffset
                           (LOCq.rotation - 180) \   -- <float>rotation
                           LOCq.followPath \         -- <BOOL>splineRotation
                           LOCq.aux2_bool \          -- <BOOL>slopeRotation
                           LOCq.aux1_bool \          -- <BOOL>loop
                           LOCq.surface \            -- <Node>surface
                           LOCq.followSurface        -- <BOOL>trackSurface
      )
      LOCq.row1 = LOCpartMatrix.row1
      LOCq.row2 = LOCpartMatrix.row2
      LOCq.row3 = LOCpartMatrix.row3
      LOCq.row4 = LOCpartMatrix.row4
    )
    catch ()
  )
  LOCpartMatrix
)


/*
DYNFUNmaxXFormCam function was deprecated in DVSP4 but previously used with path controller for placed
cameras in conjunction with DYNXFCC/DYNXFCCV3/DYNXFCCM3. Required for opening and updating legacy files.
*/
fn DYNFUNmaxXformCam FUNobj =
(
  local LOCpartMatrix = matrix3 [1,0,0] [0,1,0] [0,0,1] [0,0,0]         -- local Matrix3 return value
  if FUNobj != undefined then
  (
    local LOCq          = FUNobj.transform.controller
    try
    (

      if LOCq.path != undefined then
      (
        dependsOn LOCq.path -- Set Up Object Dependencies
        LOCpartMatrix = DYNlxSplineInterpCam \
                           LOCq.path \               -- <node>node
                           LOCq.spline \             -- <int>spline
                           LOCq.percent \            -- <float>distance
                           LOCq.distance \           -- <Float>targetDistance
                           LOCq.hOffset \            -- <float>offset
                           LOCq.vOffset \            -- <float>zoffset
                           LOCq.rotation \           -- <float>rotation
                           LOCq.followPath \         -- <BOOL>splineRotation
                           LOCq.aux2_bool \          -- <BOOL>slopeRotation
      )
      LOCq.row1 = LOCpartMatrix.row1
      LOCq.row2 = LOCpartMatrix.row2
      LOCq.row3 = LOCpartMatrix.row3
      LOCq.row4 = LOCpartMatrix.row4
    )
    catch ()
  )
  LOCpartMatrix
)


/*
DYNFUNvizXform function was deprecated in DVSP4 but previously used with path controller for placed
objects in Autodesk VIZ specifically. Required for opening and updating legacy files which originate from VIZ.
*/
fn DYNFUNvizXform FUNobj =
(
  local LOCpartMatrix = matrix3 [1,0,0] [0,1,0] [0,0,1] [0,0,0]         -- local Matrix3 return value
  if FUNobj != undefined then
  (
    local LOCq          = FUNobj.transform.controller.scale.controller
    try
    (
      if LOCq.path != undefined then
      (
        if LOCq.surface == undefined then dependsOn LOCq.path else dependsOn LOCq.path LOCq.surface -- Set Up Object Dependencies
        LOCpartMatrix = DYNlxSplineInterp \                                 -- matrix3
                           LOCq.path \               -- <node>node
                           LOCq.spline \             -- <int>spline
                          (if (isController LOCq.percent.controller)  then  LOCq.percent.controller.value         else  LOCq.percent) \-- <float>distance [was... (try (LOCq.percent.controller.value) catch (LOCq.percent))]
                          (if (isController LOCq.hOffset.controller)  then  LOCq.hOffset.controller.value         else  LOCq.hOffset) \          -- <float>offset
                          (if (isController LOCq.vOffset.controller)  then  LOCq.vOffset.controller.value         else  LOCq.vOffset) \          -- <float>zoffset
                          (if (isController LOCq.rotation.controller) then (LOCq.rotation.controller.value - 180) else (LOCq.rotation - 180)) \  -- <float>rotation
                           LOCq.followPath \         -- <BOOL>splineRotation
                           LOCq.aux2_bool \          -- <BOOL>slopeRotation
                           LOCq.aux1_bool \          -- <BOOL>loop
                           LOCq.surface \            -- <Node>surface
                           LOCq.followSurface        -- <BOOL>trackSurface
      )
      FUNobj.transform.controller.rotation = LOCpartMatrix.rotationPart
    )
    catch ()
  )
  LOCpartMatrix.row4
)


/*
DYNFUNvizXformCam function was deprecated in DVSP4 but previously used with path controller for placed
cameras in Autodesk VIZ specifically. Required for opening and updating legacy files which originate from VIZ.
*/
fn DYNFUNvizXformCam FUNobj =
(
  local LOCpartMatrix = matrix3 [1,0,0] [0,1,0] [0,0,1] [0,0,0]         -- local Matrix3 return value
  if FUNobj != undefined then
  (
    local LOCq          = FUNobj.transform.controller.scale.controller
    try
    (
      if LOCq.path != undefined then
      (
        dependsOn LOCq.path -- Set Up Object Dependencies
        LOCpartMatrix = DYNlxSplineInterpCam \
                           LOCq.path \               -- <node>node
                           LOCq.spline \             -- <int>spline
                          (if (isController LOCq.percent.controller)  then LOCq.percent.controller.value  else  LOCq.percent) \-- <float>distance [was... (try (LOCq.percent.controller.value) catch (LOCq.percent))]
                           LOCq.distance \           -- <Float>targetDistance
                          (if (isController LOCq.hOffset.controller)  then LOCq.hOffset.controller.value  else  LOCq.hOffset) \          -- <float>offset
                          (if (isController LOCq.vOffset.controller)  then LOCq.vOffset.controller.value  else  LOCq.vOffset) \          -- <float>zoffset
                          (if (isController LOCq.rotation.controller) then LOCq.rotation.controller.value else LOCq.rotation) \  -- <float>rotation
                           LOCq.followPath \         -- <BOOL>splineRotation
                           LOCq.aux2_bool \          -- <BOOL>slopeRotation
      )
      FUNobj.transform.controller.rotation = LOCpartMatrix.rotationPart
    )
    catch ()
  )
  LOCpartMatrix.row4
)
/*
***************************************************************************************************
***---------------------------------------------------------------------------------------------***
***--  Scripted Root Node Custom Attribute Library for Autodesk Civil View                    --***
***--  � Copyright 2011 Autodesk, Inc. All rights reserved.                                   --***
***---------------------------------------------------------------------------------------------***
***************************************************************************************************
*/

global DYNrootNodeStore = attributes DYNrootNodeStore attribID:#(0x760b25e7, 0x31db789f) Version:3
(
  parameters main
  (
    --- General Scene Settings
    sceneVersion       type:#float   default:3.1     -- This version ID is stored in the scene to allow current and stored MAX versions to be compared.
    shiftX             type:#integer default:0       -- Used in DYNglobalShift X values
    shiftY             type:#integer default:0       -- Used in DYNglobalShift Y values

    --- Other Object Settings
    vehicleRes         type:#integer default:100
    bakeSwitch         type:#boolean default:false   -- Controls dynamic object position linking (pinning). Default false - optimised linking.
    signIllum          type:#integer default:25
    treeIllum          type:#integer default:0
    vehRayTrace        type:#boolean default:true
    vehRayAmount       type:#integer default:20

    --- Road Markings Specific
    markVshift         type:#float   default:0.025   -- Default vertical shift to be applied when creating road marking objects
    markFreeze         type:#boolean default:false
    markQuality        type:#float   default:0.25
    markBlur           type:#float   default:1.0

    --- Current Paths For Styles
    sosPath            type:#string  default:""
    rosPath            type:#string  default:""
    bosPath            type:#string  default:""
    opsPath            type:#string  default:""
    rmsPath            type:#string  default:""
    fisPath            type:#string  default:""
    genPath            type:#string  default:""
    mfwPath            type:#string  default:""
    xmlPath            type:#string  default:""
    twdPath            type:#string  default:""
    string01           type:#string  default:""    -- Civil 3D Default Path

    int01              type:#integer default:0     -- Last used host app (3ds max (1), Autodesk VIZ (2), or unknown (0) [meaning that scene was last opened prior to DVSP 3.0]

    bool01             type:#boolean default:false -- Determines whether warning should be displayed about extending scene animation length in OPS Editor
    bool02             type:#boolean default:false -- Determines whether warning should be displayed about applying Feature Interpretation warning in Import Panels

    string02           type:#string  default:""    -- Project Resource Kit Path

    --- Used in Dynamite SIM (Version 1.6 onwards)
    int04              type:#integer default:0     -- Civil View Traffic Import Shift X Value
    int05              type:#integer default:0     -- Civil View Traffic Import Shift Y Value
    float01            type:#float   default:0.0   -- Civil View Traffic Import Shift Z Value
    string03           type:#string  default:""    -- Civil View FZP Traffic File Traffic Import File Last Used Path
    string04           type:#string  default:""    -- Civil View SIM Traffic File Traffic Import File Last Used Path

    --- Spare Parameters (Not Yet In Use)
    countryKitPath     type:#string  default:""    -- not in use
    bool03             type:#boolean default:false
    bool04             type:#boolean default:false
    bool05             type:#boolean default:false
    float02            type:#float   default:0.0
    float03            type:#float   default:0.0
    float04            type:#float   default:0.0
    float05            type:#float   default:0.0

    string05           type:#string  default:""
    string06           type:#string  default:""
    string07           type:#string  default:""
    string08           type:#string  default:""
    string09           type:#string  default:""
    string10           type:#string  default:""

    --- Deprecated Parameters (No Longer In Use)
    int02              type:#integer default:0     -- Maximum number of items listed in Placed Object Manager
    int03              type:#integer default:0     -- Maximum number of items listed in Imported Object Manager
  )
)


/*
DYNglobalShiftCustomAttributes was deprecated in DVSP 2.0, but remains in order to allow the removal of
this custom attribute definition from legacy max files
*/
global DYNglobalShiftCustomAttributes = attributes DYNglobalShiftCustomAttributes attribID:#(0x4896af40, 0x77c8cf00) Version:2
(
  parameters main
  (
    shiftX             type:#integer default:0       -- Used in DYNglobalShift X values
    shiftY             type:#integer default:0       -- Used in DYNglobalShift Y values
  )
)

global DYNwheelRotationControllerAttributes = attributes DYNwheelRotationControllerAttributes
(
  parameters main
  (
    LastPosition       type:#point3 default:[0,0,0]  -- vehicle position at last key frame
    LastDistance       type:#float  default:0        -- distance from vehicle position at last keyframe to current keyframe
    LastBearing        type:#float  default:0        -- degrees
  )
)
--
-- � Copyright 2011 Autodesk, Inc. All rights reserved.
--

-- Now Updated to match RWS DWG Number: A118774 (Bouwdienst Zoetermeer)  Update: 30-07-2002 (BEH)

plugin simpleObject Vsp_Gantry name:~PLUGIN_CIVILGANTRYNL_NAME~ category:~PLUGIN_CIVILGANTRYNL_CATEGORY~ classID:#(0xb584d886, 0xc01e79a9) invisible:(not DYNcreatable)
(
  parameters main rollout:ROLLOUTparams
  (
    length          type:#worldunits animatable:true default:20.0
    height          type:#worldunits animatable:true default:8.0
    radius          type:#worldunits animatable:true default:3.0
    dia             type:#worldunits animatable:true default:0.45
    xfall           type:#float      animatable:true default:0
    matID           type:#integer    animatable:true default:2
    lStyle          type:#boolean    animatable:true default:false
    signals         type:#boolean    animatable:true default:false
    numberOfSignals type:#integer    animatable:true default:1
    SignalGap       type:#worldunits animatable:true default:3.6
    flipSignals     type:#boolean    animatable:true default:false
    SignalOffset    type:#worldunits animatable:true default:3
  )

  rollout ROLLOUTparams ~PLUGIN_CIVILGANTRYNL_ROLLOUT~
  (
    group ~PLUGIN_CIVILGANTRYNL_GROUP~
    (
      label LBtext01 ~PLUGIN_CIVILGANTRYNL_TEXT01~ align:#center
      label LBtext02 ~PLUGIN_CIVILGANTRYNL_TEXT02~ align:#center
    )
  )

  on create do
  (
    --- Set Default Values                                                                 ---
    --- When a new gantry is created, convert the defaults in Pmblock which use WorldUnits ---
    --- to equivilents in feet                                                             ---
    local LOCunitMult = 1.0
    case units.SystemType of
    (
      #Inches      : LOCunitMult = 39.3700787
      #Feet        : LOCunitMult = 3.2808399
      #Miles       : LOCunitMult = 0.000621371192
      #Millimeters : LOCunitMult = 1000.0
      #Centimeters : LOCunitMult = 100.0
      #Meters      : LOCunitMult = 1.0
      #Kilometers  : LOCunitMult = 0.001
    )
    length       = length       * LOCunitMult
    height       = height       * LOCunitMult
    Radius       = Radius       * LOCunitMult
    Dia          = Dia          * LOCunitMult
    SignalGap    = SignalGap    * LOCunitMult
    SignalOffset = SignalOffset * LOCunitMult
  )

  on buildMesh do
  (
    local LMSlength          = length
    local LMSheight          = height
    local LMSxfall           = xfall
    local LMSsignals         = signals
    local LMSnumberOfSignals = numberOfSignals
    local LMSSignalGap       = SignalGap
    local LMSflipSignals     = flipSignals
    local LMSSignalOffset    = SignalOffset
    local LMSmatID           = matID  --try (matID) catch (2)
    local LMSsignMatID       = (radius as integer); if LMSsignMatID <= 10 then LMSsignMatID = 3 -- (3 is black paint in CivilViewObjects)

    if not lStyle then
    (
      -- Vertices
      local LOCoffsets = #(0,LMSlength)
      local v = #()
      local f = #()
      local m = #()
      local LOCfacesAfterStruts = #()
      local LOCflipValue = 1
      if LMSflipSignals == true then LOCflipValue = LOCflipValue * -1
      -----------------------------------------------------------------------------------
      --Create posts at each end of gantry
      for i = 1 to 2 do
      (
        local LOCsign = (if i == 1 then 0.0 else 0.26)
        -- Top Triangle of Post
        append v [(LOCoffsets[i] + (LOCsign + -0.26)),-0.360,LMSheight - 1.675] --7.2
        append v [(LOCoffsets[i] + (LOCsign + -0.26)),-0.360,LMSheight - 1.175] --7.5
        append v [(LOCoffsets[i] + (LOCsign + -0.26)),-0.973,LMSheight] -- 8.875
        append v [(LOCoffsets[i] + (LOCsign + -0.26)),0.9730,LMSheight] --8.875
        append v [(LOCoffsets[i] + (LOCsign + -0.26)),0.3600,LMSheight - 1.175] --7.5
        append v [(LOCoffsets[i] + (LOCsign + 0.000)),-0.360,LMSheight - 1.175] --7.5
        append v [(LOCoffsets[i] + (LOCsign + 0.000)),-0.973,LMSheight] --8.875
        append v [(LOCoffsets[i] + (LOCsign + 0.000)),0.9730,LMSheight] --8.875
        append v [(LOCoffsets[i] + (LOCsign + 0.000)),0.3600,LMSheight - 1.175] --7.5
        -- Round Bar Top Left
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),-0.725,LMSheight - 0.100] --8.775            Vertex 10
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),-0.747,LMSheight - 0.047] --8.82803
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),-0.800,LMSheight - 0.025] --8.85
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),-0.853,LMSheight - 0.047] --8.82803
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),-0.875,LMSheight - 0.100] --8.775
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),-0.853,LMSheight - 0.153] --8.72197
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),-0.800,LMSheight - 0.175] --8.7
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),-0.747,LMSheight - 0.153] --8.72197
        -- Round Bar Top Right
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),-0.800,LMSheight - 0.100] --8.775 -- what is this line for?

        append v [(LOCoffsets[i] + (LOCsign + -0.13)),0.875,LMSheight - 0.100] --8.775
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),0.853,LMSheight - 0.047] --8.82803
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),0.800,LMSheight - 0.025] --8.85
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),0.747,LMSheight - 0.047] --8.82803
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),0.725,LMSheight - 0.100] --8.775
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),0.747,LMSheight - 0.153] --8.72197
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),0.800,LMSheight - 0.175] --8.7
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),0.853,LMSheight - 0.153] --8.72197

        append v [(LOCoffsets[i] + (LOCsign + -0.13)),0.800,LMSheight - 0.100] --8.775    -- what is this line for??
        -- Round Bar Bottom Centre
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),0.0750,LMSheight - 1.486] --7.4
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),0.0530,LMSheight - 1.433] --7.45303
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),0.0000,LMSheight - 1.411] --7.475
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),-0.053,LMSheight - 1.433] --7.45303
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),-0.075,LMSheight - 1.486] --7.4
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),-0.053,LMSheight - 1.539] --7.34697
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),-0.000,LMSheight - 1.561] --7.325
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),0.0530,LMSheight - 1.539] --7.34697
        append v [(LOCoffsets[i] + (LOCsign + -0.13)),0.0000,LMSheight - 1.486] --7.4            Vertex 36
        -- Legs of Post
        append v [(LOCoffsets[i] + (LOCsign + -0.26)),-0.360,LMSheight - 1.675] --7.2
        append v [(LOCoffsets[i] + (LOCsign + -0.26)),-0.360,LMSheight - 1.175] --7.5
        append v [(LOCoffsets[i] + (LOCsign + -0.26)),0.3600,LMSheight - 1.175] --7.5
        append v [(LOCoffsets[i] + (LOCsign + -0.26)),0.3600,LMSheight - 1.675] --7.2
        append v [(LOCoffsets[i] + (LOCsign + -0.26)),2.1890,((LOCoffsets[i] * LMSxfall) + 0.1)]
        append v [(LOCoffsets[i] + (LOCsign + -0.26)),1.8110,((LOCoffsets[i] * LMSxfall) + 0.1)]
        append v [(LOCoffsets[i] + (LOCsign + -0.26)),0.0000,LMSheight - 1.675] -- Crotchpoint 1
        append v [(LOCoffsets[i] + (LOCsign + -0.26)),-1.811,((LOCoffsets[i] * LMSxfall) + 0.1)]
        append v [(LOCoffsets[i] + (LOCsign + -0.26)),-2.189,((LOCoffsets[i] * LMSxfall) + 0.1)]
        append v [(LOCoffsets[i] + (LOCsign + 0.000)),-0.360,LMSheight - 1.675] --7.2
        append v [(LOCoffsets[i] + (LOCsign + 0.000)),-0.360,LMSheight - 1.175] --7.5
        append v [(LOCoffsets[i] + (LOCsign + 0.000)),0.3600,LMSheight - 1.175] --7.5
        append v [(LOCoffsets[i] + (LOCsign + 0.000)),0.3600,LMSheight - 1.675]--7.2
        append v [(LOCoffsets[i] + (LOCsign + 0.000)),2.1890,((LOCoffsets[i] * LMSxfall) + 0.1)]
        append v [(LOCoffsets[i] + (LOCsign + 0.000)),1.8110,((LOCoffsets[i] * LMSxfall) + 0.1)]
        append v [(LOCoffsets[i] + (LOCsign + 0.000)),0.0000,LMSheight - 1.675]-- Crotchpoint 2
        append v [(LOCoffsets[i] + (LOCsign + 0.000)),-1.811,((LOCoffsets[i] * LMSxfall) + 0.1)]
        append v [(LOCoffsets[i] + (LOCsign + 0.000)),-2.189,((LOCoffsets[i] * LMSxfall) + 0.1)]
        -- Feet
        append v [(LOCoffsets[i] + (LOCsign + 0.170)),1.60,((LOCoffsets[i] * LMSxfall) + 0.1)]  --    Vertex 55
        append v [(LOCoffsets[i] + (LOCsign + 0.170)),2.40,((LOCoffsets[i] * LMSxfall) + 0.1)]
        append v [(LOCoffsets[i] + (LOCsign + -0.43)),2.40,((LOCoffsets[i] * LMSxfall) + 0.1)]
        append v [(LOCoffsets[i] + (LOCsign + -0.43)),1.60,((LOCoffsets[i] * LMSxfall) + 0.1)]
        append v [(LOCoffsets[i] + (LOCsign + 0.170)),1.60,((LOCoffsets[i] * LMSxfall) + -0.35)]
        append v [(LOCoffsets[i] + (LOCsign + 0.170)),2.40,((LOCoffsets[i] * LMSxfall) + -0.35)]
        append v [(LOCoffsets[i] + (LOCsign + -0.43)),2.40,((LOCoffsets[i] * LMSxfall) + -0.35)]
        append v [(LOCoffsets[i] + (LOCsign + -0.43)),1.60,((LOCoffsets[i] * LMSxfall) + -0.35)]
        append v [(LOCoffsets[i] + (LOCsign + 0.170)),-2.4,((LOCoffsets[i] * LMSxfall) + 0.1)]
        append v [(LOCoffsets[i] + (LOCsign + 0.170)),-1.6,((LOCoffsets[i] * LMSxfall) + 0.1)]
        append v [(LOCoffsets[i] + (LOCsign + -0.43)),-1.6,((LOCoffsets[i] * LMSxfall) + 0.1)]
        append v [(LOCoffsets[i] + (LOCsign + -0.43)),-2.4,((LOCoffsets[i] * LMSxfall) + 0.1)]
        append v [(LOCoffsets[i] + (LOCsign + 0.170)),-2.4,((LOCoffsets[i] * LMSxfall) + -0.35)]
        append v [(LOCoffsets[i] + (LOCsign + 0.170)),-1.6,((LOCoffsets[i] * LMSxfall) + -0.35)]
        append v [(LOCoffsets[i] + (LOCsign + -0.43)),-1.6,((LOCoffsets[i] * LMSxfall) + -0.35)]
        append v [(LOCoffsets[i] + (LOCsign + -0.43)),-2.4,((LOCoffsets[i] * LMSxfall) + -0.35)]
      )

      local LOCvertIDS = #(0,(v.count/2))
      for i = 1 to 2 do
      (
        local ii = if i == 1 then 2 else 1
        -- Triangular Top of Post
        append f [LOCvertIDS[i] + 3,LOCvertIDS[i] + 4,LOCvertIDS[i] + 5] ; append m LMSmatID -- Face 1
        append f [LOCvertIDS[i] + 2,LOCvertIDS[i] + 3,LOCvertIDS[i] + 5] ; append m LMSmatID
        append f [LOCvertIDS[i] + 1,LOCvertIDS[i] + 2,LOCvertIDS[i] + 5] ; append m LMSmatID
        append f [LOCvertIDS[i] + 6,LOCvertIDS[i] + 2,LOCvertIDS[i] + 1] ; append m LMSmatID
        append f [LOCvertIDS[i] + 7,LOCvertIDS[i] + 3,LOCvertIDS[i] + 2] ; append m LMSmatID
        append f [LOCvertIDS[i] + 6,LOCvertIDS[i] + 7,LOCvertIDS[i] + 2] ; append m LMSmatID
        append f [LOCvertIDS[i] + 8,LOCvertIDS[i] + 4,LOCvertIDS[i] + 3] ; append m LMSmatID
        append f [LOCvertIDS[i] + 7,LOCvertIDS[i] + 8,LOCvertIDS[i] + 3] ; append m LMSmatID
        append f [LOCvertIDS[i] + 9,LOCvertIDS[i] + 5,LOCvertIDS[i] + 4] ; append m LMSmatID
        append f [LOCvertIDS[i] + 8,LOCvertIDS[i] + 9,LOCvertIDS[i] + 4] ; append m LMSmatID
        append f [LOCvertIDS[i] + 9,LOCvertIDS[i] + 8,LOCvertIDS[i] + 7] ; append m LMSmatID
        append f [LOCvertIDS[i] + 9,LOCvertIDS[i] + 7,LOCvertIDS[i] + 6] ; append m LMSmatID
        -- Horziontal Bars
        if i == 1 then
        (
          append f [LOCvertIDS[ii] + 11,LOCvertIDS[ii] + 10,LOCvertIDS[i] + 10] ; append m LMSmatID -- Face 13
          append f [LOCvertIDS[ii] + 12,LOCvertIDS[ii] + 11,LOCvertIDS[i] + 11] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 13,LOCvertIDS[ii] + 12,LOCvertIDS[i] + 12] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 14,LOCvertIDS[ii] + 13,LOCvertIDS[i] + 13] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 15,LOCvertIDS[ii] + 14,LOCvertIDS[i] + 14] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 16,LOCvertIDS[ii] + 15,LOCvertIDS[i] + 15] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 17,LOCvertIDS[ii] + 16,LOCvertIDS[i] + 16] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 10,LOCvertIDS[ii] + 17,LOCvertIDS[i] + 17] ; append m LMSmatID

          append f [LOCvertIDS[ii] + 20,LOCvertIDS[ii] + 19,LOCvertIDS[i] + 19] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 21,LOCvertIDS[ii] + 20,LOCvertIDS[i] + 20] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 22,LOCvertIDS[ii] + 21,LOCvertIDS[i] + 21] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 23,LOCvertIDS[ii] + 22,LOCvertIDS[i] + 22] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 24,LOCvertIDS[ii] + 23,LOCvertIDS[i] + 23] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 25,LOCvertIDS[ii] + 24,LOCvertIDS[i] + 24] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 26,LOCvertIDS[ii] + 25,LOCvertIDS[i] + 25] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 19,LOCvertIDS[ii] + 26,LOCvertIDS[i] + 26] ; append m LMSmatID

          append f [LOCvertIDS[ii] + 29,LOCvertIDS[ii] + 28,LOCvertIDS[i] + 28] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 30,LOCvertIDS[ii] + 29,LOCvertIDS[i] + 29] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 31,LOCvertIDS[ii] + 30,LOCvertIDS[i] + 30] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 32,LOCvertIDS[ii] + 31,LOCvertIDS[i] + 31] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 33,LOCvertIDS[ii] + 32,LOCvertIDS[i] + 32] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 34,LOCvertIDS[ii] + 33,LOCvertIDS[i] + 33] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 35,LOCvertIDS[ii] + 34,LOCvertIDS[i] + 34] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 28,LOCvertIDS[ii] + 35,LOCvertIDS[i] + 35] ; append m LMSmatID
        )
        else
        (
          append f [LOCvertIDS[ii] + 10,LOCvertIDS[ii] + 11,LOCvertIDS[i] + 11] ; append m LMSmatID -- Face 13
          append f [LOCvertIDS[ii] + 11,LOCvertIDS[ii] + 12,LOCvertIDS[i] + 12] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 12,LOCvertIDS[ii] + 13,LOCvertIDS[i] + 13] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 13,LOCvertIDS[ii] + 14,LOCvertIDS[i] + 14] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 14,LOCvertIDS[ii] + 15,LOCvertIDS[i] + 15] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 15,LOCvertIDS[ii] + 16,LOCvertIDS[i] + 16] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 16,LOCvertIDS[ii] + 17,LOCvertIDS[i] + 17] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 17,LOCvertIDS[ii] + 10,LOCvertIDS[i] + 10] ; append m LMSmatID

          append f [LOCvertIDS[ii] + 19,LOCvertIDS[ii] + 20,LOCvertIDS[i] + 20] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 20,LOCvertIDS[ii] + 21,LOCvertIDS[i] + 21] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 21,LOCvertIDS[ii] + 22,LOCvertIDS[i] + 22] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 22,LOCvertIDS[ii] + 23,LOCvertIDS[i] + 23] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 23,LOCvertIDS[ii] + 24,LOCvertIDS[i] + 24] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 24,LOCvertIDS[ii] + 25,LOCvertIDS[i] + 25] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 25,LOCvertIDS[ii] + 26,LOCvertIDS[i] + 26] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 26,LOCvertIDS[ii] + 19,LOCvertIDS[i] + 19] ; append m LMSmatID

          append f [LOCvertIDS[ii] + 28,LOCvertIDS[ii] + 29,LOCvertIDS[i] + 29] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 29,LOCvertIDS[ii] + 30,LOCvertIDS[i] + 30] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 30,LOCvertIDS[ii] + 31,LOCvertIDS[i] + 31] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 31,LOCvertIDS[ii] + 32,LOCvertIDS[i] + 32] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 32,LOCvertIDS[ii] + 33,LOCvertIDS[i] + 33] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 33,LOCvertIDS[ii] + 34,LOCvertIDS[i] + 34] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 34,LOCvertIDS[ii] + 35,LOCvertIDS[i] + 35] ; append m LMSmatID
          append f [LOCvertIDS[ii] + 35,LOCvertIDS[ii] + 28,LOCvertIDS[i] + 28] ; append m LMSmatID
        )
        -- Legs of each Post
        append f [LOCvertIDS[i] + 44,LOCvertIDS[i] + 45,LOCvertIDS[i] + 37] ; append m LMSmatID -- Face 37
        append f [LOCvertIDS[i] + 43,LOCvertIDS[i] + 44,LOCvertIDS[i] + 37] ; append m LMSmatID
        append f [LOCvertIDS[i] + 40,LOCvertIDS[i] + 41,LOCvertIDS[i] + 42] ; append m LMSmatID
        append f [LOCvertIDS[i] + 40,LOCvertIDS[i] + 42,LOCvertIDS[i] + 43] ; append m LMSmatID
        append f [LOCvertIDS[i] + 40,LOCvertIDS[i] + 43,LOCvertIDS[i] + 37] ; append m LMSmatID
        append f [LOCvertIDS[i] + 39,LOCvertIDS[i] + 40,LOCvertIDS[i] + 37] ; append m LMSmatID
        append f [LOCvertIDS[i] + 38,LOCvertIDS[i] + 39,LOCvertIDS[i] + 37] ; append m LMSmatID
        append f [LOCvertIDS[i] + 47,LOCvertIDS[i] + 38,LOCvertIDS[i] + 37] ; append m LMSmatID
        append f [LOCvertIDS[i] + 46,LOCvertIDS[i] + 47,LOCvertIDS[i] + 37] ; append m LMSmatID
        append f [LOCvertIDS[i] + 50,LOCvertIDS[i] + 41,LOCvertIDS[i] + 40] ; append m LMSmatID
        append f [LOCvertIDS[i] + 49,LOCvertIDS[i] + 50,LOCvertIDS[i] + 40] ; append m LMSmatID
        append f [LOCvertIDS[i] + 51,LOCvertIDS[i] + 42,LOCvertIDS[i] + 41] ; append m LMSmatID
        append f [LOCvertIDS[i] + 50,LOCvertIDS[i] + 51,LOCvertIDS[i] + 41] ; append m LMSmatID
        append f [LOCvertIDS[i] + 52,LOCvertIDS[i] + 43,LOCvertIDS[i] + 42] ; append m LMSmatID
        append f [LOCvertIDS[i] + 51,LOCvertIDS[i] + 52,LOCvertIDS[i] + 42] ; append m LMSmatID
        append f [LOCvertIDS[i] + 53,LOCvertIDS[i] + 44,LOCvertIDS[i] + 43] ; append m LMSmatID
        append f [LOCvertIDS[i] + 52,LOCvertIDS[i] + 53,LOCvertIDS[i] + 43] ; append m LMSmatID
        append f [LOCvertIDS[i] + 54,LOCvertIDS[i] + 45,LOCvertIDS[i] + 44] ; append m LMSmatID
        append f [LOCvertIDS[i] + 53,LOCvertIDS[i] + 54,LOCvertIDS[i] + 44] ; append m LMSmatID
        append f [LOCvertIDS[i] + 46,LOCvertIDS[i] + 37,LOCvertIDS[i] + 45] ; append m LMSmatID
        append f [LOCvertIDS[i] + 54,LOCvertIDS[i] + 46,LOCvertIDS[i] + 45] ; append m LMSmatID
        append f [LOCvertIDS[i] + 46,LOCvertIDS[i] + 54,LOCvertIDS[i] + 53] ; append m LMSmatID
        append f [LOCvertIDS[i] + 46,LOCvertIDS[i] + 53,LOCvertIDS[i] + 52] ; append m LMSmatID
        append f [LOCvertIDS[i] + 51,LOCvertIDS[i] + 50,LOCvertIDS[i] + 49] ; append m LMSmatID
        append f [LOCvertIDS[i] + 52,LOCvertIDS[i] + 51,LOCvertIDS[i] + 49] ; append m LMSmatID
        append f [LOCvertIDS[i] + 46,LOCvertIDS[i] + 52,LOCvertIDS[i] + 49] ; append m LMSmatID
        append f [LOCvertIDS[i] + 46,LOCvertIDS[i] + 49,LOCvertIDS[i] + 48] ; append m LMSmatID
        append f [LOCvertIDS[i] + 46,LOCvertIDS[i] + 48,LOCvertIDS[i] + 47] ; append m LMSmatID
        -- Underground Feet Faces
        append f [LOCvertIDS[i] + 55,LOCvertIDS[i] + 56,LOCvertIDS[i] + 57] ; append m 10 -- Face 65
        append f [LOCvertIDS[i] + 55,LOCvertIDS[i] + 57,LOCvertIDS[i] + 58] ; append m 10
        append f [LOCvertIDS[i] + 55,LOCvertIDS[i] + 59,LOCvertIDS[i] + 60] ; append m 10
        append f [LOCvertIDS[i] + 55,LOCvertIDS[i] + 60,LOCvertIDS[i] + 56] ; append m 10
        append f [LOCvertIDS[i] + 56,LOCvertIDS[i] + 60,LOCvertIDS[i] + 61] ; append m 10
        append f [LOCvertIDS[i] + 56,LOCvertIDS[i] + 61,LOCvertIDS[i] + 57] ; append m 10
        append f [LOCvertIDS[i] + 57,LOCvertIDS[i] + 61,LOCvertIDS[i] + 62] ; append m 10
        append f [LOCvertIDS[i] + 57,LOCvertIDS[i] + 62,LOCvertIDS[i] + 58] ; append m 10
        append f [LOCvertIDS[i] + 58,LOCvertIDS[i] + 62,LOCvertIDS[i] + 59] ; append m 10
        append f [LOCvertIDS[i] + 58,LOCvertIDS[i] + 59,LOCvertIDS[i] + 55] ; append m 10
        append f [LOCvertIDS[i] + 63,LOCvertIDS[i] + 64,LOCvertIDS[i] + 65] ; append m 10
        append f [LOCvertIDS[i] + 63,LOCvertIDS[i] + 65,LOCvertIDS[i] + 66] ; append m 10
        append f [LOCvertIDS[i] + 63,LOCvertIDS[i] + 67,LOCvertIDS[i] + 68] ; append m 10
        append f [LOCvertIDS[i] + 63,LOCvertIDS[i] + 68,LOCvertIDS[i] + 64] ; append m 10
        append f [LOCvertIDS[i] + 64,LOCvertIDS[i] + 68,LOCvertIDS[i] + 69] ; append m 10
        append f [LOCvertIDS[i] + 64,LOCvertIDS[i] + 69,LOCvertIDS[i] + 65] ; append m 10
        append f [LOCvertIDS[i] + 65,LOCvertIDS[i] + 69,LOCvertIDS[i] + 70] ; append m 10
        append f [LOCvertIDS[i] + 65,LOCvertIDS[i] + 70,LOCvertIDS[i] + 66] ; append m 10
        append f [LOCvertIDS[i] + 66,LOCvertIDS[i] + 70,LOCvertIDS[i] + 67] ; append m 10
        append f [LOCvertIDS[i] + 66,LOCvertIDS[i] + 67,LOCvertIDS[i] + 63] ; append m 10
        -- Unknown
        append f [LOCvertIDS[i] + 48,LOCvertIDS[i] + 49,LOCvertIDS[i] + 39] ; append m LMSmatID -- Face 85
        append f [LOCvertIDS[i] + 40,LOCvertIDS[i] + 39,LOCvertIDS[i] + 49] ; append m LMSmatID
      )

      local LOCfacesAfterPosts = f.count

      -------------------------------------------------------------------------
      --Create Trusses and Mesh between width
      for i = 1 to (LMSlength/2.000) do
      (
        local nv = v.count
        append v [(((i - 1) * 2.000) + 0.088),0.809696,LMSheight - 0.075] --8.8]           Truss Vertex 1
        append v [(((i - 1) * 2.000) + 0.988),-0.785304,LMSheight - 0.075] --8.8]
        append v [(((i - 1) * 2.000) + 1.013),-0.785304,LMSheight - 0.075] --8.8]
        append v [(((i - 1) * 2.000) + 1.913),0.809696,LMSheight - 0.075] --8.8]
        append v [(((i - 1) * 2.000) + 1.988),0.784696,LMSheight - 0.075] --8.8]
        append v [(((i - 1) * 2.000) + 1.088),-0.810304,LMSheight - 0.075] --8.8]
        append v [(((i - 1) * 2.000) + 0.913),-0.810304,LMSheight - 0.075] --8.8]
        append v [(((i - 1) * 2.000) + 0.013),0.784696,LMSheight - 0.075] --8.8]
        append v [(((i - 1) * 2.000) + 0.088),0.809696,LMSheight - 0.150] --8.725]
        append v [(((i - 1) * 2.000) + 0.988),-0.785304,LMSheight - 0.150] --8.725]
        append v [(((i - 1) * 2.000) + 1.013),-0.785304,LMSheight - 0.150] --8.725]        Truss Vertex 11
        append v [(((i - 1) * 2.000) + 1.913),0.809696,LMSheight - 0.150] --8.725]
        append v [(((i - 1) * 2.000) + 1.988),0.784696,LMSheight - 0.150] --8.725]
        append v [(((i - 1) * 2.000) + 1.088),-0.810304,LMSheight - 0.150] --8.725]
        append v [(((i - 1) * 2.000) + 0.913),-0.810304,LMSheight - 0.150] --8.725]
        append v [(((i - 1) * 2.000) + 0.013),0.784696,LMSheight - 0.150] --8.725]
        append v [(((i - 1) * 2.000) + 0.088),-0.850256,LMSheight - 0.12686] --8.74814]
        append v [(((i - 1) * 2.000) + 0.988),-0.0527554,LMSheight - 1.49085] --7.38415]
        append v [(((i - 1) * 2.000) + 1.013),-0.0527554,LMSheight - 1.49085] --7.38415]   Truss Vertex 19
        append v [(((i - 1) * 2.000) + 1.913),-0.850256,LMSheight - 0.12686] --8.74814]
        append v [(((i - 1) * 2.000) + 1.988),-0.837755,LMSheight - 0.14851] --8.72649]
        append v [(((i - 1) * 2.000) + 1.088),-0.0402555,LMSheight - 1.5125] --7.3625]h
        append v [(((i - 1) * 2.000) + 0.913),-0.0402555,LMSheight - 1.5125] --7.3625]h
        append v [(((i - 1) * 2.000) + 0.013),-0.837756,LMSheight - 0.14851] --8.72649]
        append v [(((i - 1) * 2.000) + 0.088),-0.785304,LMSheight - 0.08936] --8.78564]
        append v [(((i - 1) * 2.000) + 0.988),0.0121965,LMSheight - 1.45335] --7.42165]
        append v [(((i - 1) * 2.000) + 1.013),0.0121965,LMSheight - 1.45335] --7.42165]    Truss Vertex 27
        append v [(((i - 1) * 2.000) + 1.913),-0.785304,LMSheight - 0.08936] --8.78564]
        append v [(((i - 1) * 2.000) + 1.988),-0.772803,LMSheight - 0.11101] --8.76399]
        append v [(((i - 1) * 2.000) + 1.088),0.0246964,LMSheight - 1.475] --7.4]
        append v [(((i - 1) * 2.000) + 0.913),0.0246964,LMSheight - 1.475] --7.4]
        append v [(((i - 1) * 2.000) + 0.013),-0.772804,LMSheight - 0.11101] --8.76399]
        append v [(((i - 1) * 2.000) + 0.088),0.781356,LMSheight - 0.08763] --8.78737]
        append v [(((i - 1) * 2.000) + 0.988),-0.0101852,LMSheight - 1.45504] --7.41996]
        append v [(((i - 1) * 2.000) + 1.013),-0.0101852,LMSheight - 1.45504] --7.41996]   Truss Vertex 35
        append v [(((i - 1) * 2.000) + 1.913),0.781356,LMSheight - 0.08763] --8.78737]
        append v [(((i - 1) * 2.000) + 1.988),0.76895,LMSheight - 0.10934] --8.76566]
        append v [(((i - 1) * 2.000) + 1.088),-0.0225906,LMSheight - 1.47675] --7.39825]
        append v [(((i - 1) * 2.000) + 0.913),-0.0225906,LMSheight - 1.47675] --7.39825]
        append v [(((i - 1) * 2.000) + 0.013),0.76895,LMSheight - 0.10933] --8.76567]
        append v [(((i - 1) * 2.000) + 0.088),0.846471,LMSheight - 0.12485] --8.75015]
        append v [(((i - 1) * 2.000) + 0.988),0.0549297,LMSheight - 1.49226] --7.38274]
        append v [(((i - 1) * 2.000) + 1.013),0.0549297,LMSheight - 1.49226] --7.38274]    Truss Vertex 43
        append v [(((i - 1) * 2.000) + 1.913),0.846471,LMSheight - 0.12485] --8.75015]
        append v [(((i - 1) * 2.000) + 1.988),0.834065,LMSheight - 0.14655] --8.72845]
        append v [(((i - 1) * 2.000) + 1.088),0.0425243,LMSheight - 1.51396] --7.36104]
        append v [(((i - 1) * 2.000) + 0.913),0.0425243,LMSheight - 1.51396] --7.36104]
        append v [(((i - 1) * 2.000) + 0.013),0.834064,LMSheight - 0.14655] --8.72845]     Truss Vertex 48

        append f [nv + 1,nv + 8,nv + 7]       ; append m LMSmatID
        append f [nv + 2,nv + 1,nv + 7]       ; append m LMSmatID
        append f [nv + 4,nv + 3,nv + 6]       ; append m LMSmatID
        append f [nv + 4,nv + 6,nv + 5]       ; append m LMSmatID
        append f [nv + 1,nv + 2,nv + 10]      ; append m LMSmatID
        append f [nv + 1,nv + 10,nv + 9]      ; append m LMSmatID
        append f [nv + 3,nv + 4,nv + 12]      ; append m LMSmatID
        append f [nv + 3,nv + 12,nv + 11]     ; append m LMSmatID
        append f [nv + 5,nv + 6,nv + 14]      ; append m LMSmatID
        append f [nv + 5,nv + 14,nv + 13]     ; append m LMSmatID
        append f [nv + 7,nv + 8,nv + 16]      ; append m LMSmatID
        append f [nv + 7,nv + 16,nv + 15]     ; append m LMSmatID
        append f [nv + 15,nv + 16,nv + 9]     ; append m LMSmatID
        append f [nv + 15,nv + 9,nv + 10]     ; append m LMSmatID
        append f [nv + 14,nv + 11,nv + 12]    ; append m LMSmatID
        append f [nv + 13,nv + 14,nv + 12]    ; append m LMSmatID
        append f [nv + 17,nv + 24,nv + 23]    ; append m LMSmatID
        append f [nv + 18,nv + 17,nv + 23]    ; append m LMSmatID
        append f [nv + 20,nv + 19,nv + 22]    ; append m LMSmatID
        append f [nv + 20,nv + 22,nv + 21]    ; append m LMSmatID
        append f [nv + 17,nv + 18,nv + 26]    ; append m LMSmatID
        append f [nv + 17,nv + 26,nv + 25]    ; append m LMSmatID
        append f [nv + 19,nv + 20,nv + 28]    ; append m LMSmatID
        append f [nv + 19,nv + 28,nv + 27]    ; append m LMSmatID
        append f [nv + 21,nv + 22,nv + 30]    ; append m LMSmatID
        append f [nv + 21,nv + 30,nv + 29]    ; append m LMSmatID
        append f [nv + 23,nv + 24,nv + 32]    ; append m LMSmatID
        append f [nv + 23,nv + 32,nv + 31]    ; append m LMSmatID
        append f [nv + 31,nv + 32,nv + 25]    ; append m LMSmatID
        append f [nv + 31,nv + 25,nv + 26]    ; append m LMSmatID
        append f [nv + 30,nv + 27,nv + 28]    ; append m LMSmatID
        append f [nv + 29,nv + 30,nv + 28]    ; append m LMSmatID
        append f [nv + 33,nv + 40,nv + 39]    ; append m LMSmatID
        append f [nv + 34,nv + 33,nv + 39]    ; append m LMSmatID
        append f [nv + 36,nv + 35,nv + 38]    ; append m LMSmatID
        append f [nv + 36,nv + 38,nv + 37]    ; append m LMSmatID
        append f [nv + 33,nv + 34,nv + 42]    ; append m LMSmatID
        append f [nv + 33,nv + 42,nv + 41]    ; append m LMSmatID
        append f [nv + 35,nv + 36,nv + 44]    ; append m LMSmatID
        append f [nv + 35,nv + 44,nv + 43]    ; append m LMSmatID
        append f [nv + 37,nv + 38,nv + 46]    ; append m LMSmatID
        append f [nv + 37,nv + 46,nv + 45]    ; append m LMSmatID
        append f [nv + 39,nv + 40,nv + 48]    ; append m LMSmatID
        append f [nv + 39,nv + 48,nv + 47]    ; append m LMSmatID
        append f [nv + 47,nv + 48,nv + 41]    ; append m LMSmatID
        append f [nv + 47,nv + 41,nv + 42]    ; append m LMSmatID
        append f [nv + 46,nv + 43,nv + 44]    ; append m LMSmatID
        append f [nv + 45,nv + 46,nv + 44]    ; append m LMSmatID
      )

      append LOCfacesAfterStruts f.count

      if LMSsignals then
      (
        for i = 1 to LMSnumberOfSignals do
        (
          if i != 1 then append LOCfacesAfterStruts f.count
          LOCvCount = v.count
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.89781,(LOCflipValue * -1.027447),LMSheight + 0.01192]     -- 01  -- backplate start
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.89781,(LOCflipValue * -1.018767),LMSheight - 0.03732]     -- 02
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.97434,(LOCflipValue * -1.024807),LMSheight - 0.00307]     -- 03
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.03639,(LOCflipValue * -1.002687),LMSheight - 0.12851]     -- 04
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.00387,(LOCflipValue * -1.011137),LMSheight - 0.08059]     -- 05
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.04781,(LOCflipValue * -0.992717),LMSheight - 0.18504]     -- 06
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.09781,(LOCflipValue * -0.992717),LMSheight - 0.18504]     -- 07
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.09781,(LOCflipValue * -0.767515),LMSheight - 1.46225]     -- 08
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.03639,(LOCflipValue * -0.757547),LMSheight - 1.51878]     -- 09
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.03923,(LOCflipValue * -0.742957),LMSheight - 1.60153]     -- 10
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.00387,(LOCflipValue * -0.749096),LMSheight - 1.56671]     -- 11
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.97435,(LOCflipValue * -0.735428),LMSheight - 1.64422]     -- 12
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.89781,(LOCflipValue * -0.741467),LMSheight - 1.60997]     -- 13
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.29781,(LOCflipValue * -0.767515),LMSheight - 1.46225]     -- 14
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.29781,(LOCflipValue * -0.992717),LMSheight - 0.18504]     -- 15
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.34781,(LOCflipValue * -0.992717),LMSheight - 0.18504]     -- 16
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.35923,(LOCflipValue * -1.002687),LMSheight - 0.12851]     -- 17
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.44041,(LOCflipValue * -1.016787),LMSheight - 0.04857]     -- 18
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.35923,(LOCflipValue * -0.757547),LMSheight - 1.51878]     -- 19
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.35639,(LOCflipValue * -0.742957),LMSheight - 1.60153]     -- 20
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.31303,(LOCflipValue * -0.754224),LMSheight - 1.53763]     -- 21
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.42127,(LOCflipValue * -0.735428),LMSheight - 1.64422]     -- 22
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.49781,(LOCflipValue * -1.018767),LMSheight - 0.03732]     -- 23
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.89781,(LOCflipValue * -0.722937),LMSheight - 1.65748]     -- 24
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.89781,(LOCflipValue * -1.017607),LMSheight + 0.01366]     -- 25
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.95521,(LOCflipValue * -1.006937),LMSheight - 0.04683]     -- 26
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.00387,(LOCflipValue * -1.001287),LMSheight - 0.07885]     -- 27
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.08258,(LOCflipValue * -0.996167),LMSheight - 0.10793]     -- 28
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.09781,(LOCflipValue * -0.982877),LMSheight - 0.18331]     -- 29
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.04781,(LOCflipValue * -0.757666),LMSheight - 1.46052]     -- 30
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.00387,(LOCflipValue * -0.739248),LMSheight - 1.56497]     -- 31
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.03923,(LOCflipValue * -0.733109),LMSheight - 1.59979]     -- 32
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.89781,(LOCflipValue * -0.731619),LMSheight - 1.60824]     -- 33
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.97435,(LOCflipValue * -0.72558 ),LMSheight - 1.64249]     -- 34
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.34781,(LOCflipValue * -0.757666),LMSheight - 1.46052]     -- 35
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.34781,(LOCflipValue * -0.982877),LMSheight - 0.18331]     -- 36
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.35923,(LOCflipValue * -0.992837),LMSheight - 0.12678]     -- 37
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.29781,(LOCflipValue * -0.982877),LMSheight - 0.18331]     -- 38
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.39174,(LOCflipValue * -1.001287),LMSheight - 0.07885]     -- 39
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.31303,(LOCflipValue * -0.744376),LMSheight - 1.53589]     -- 40
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.35639,(LOCflipValue * -0.733109),LMSheight - 1.59979]     -- 41
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.39174,(LOCflipValue * -0.739248),LMSheight - 1.56497]     -- 42
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.42127,(LOCflipValue * -0.72558 ),LMSheight - 1.64249]     -- 43
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.49781,(LOCflipValue * -0.731619),LMSheight - 1.60824]     -- 44
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.35639,(LOCflipValue * -1.007427),LMSheight - 0.04403]     -- 45
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.49781,(LOCflipValue * -1.008917),LMSheight - 0.03559]     -- 46
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.42127,(LOCflipValue * -1.014957),LMSheight - 0.00134]     -- 47
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.49781,(LOCflipValue * -0.722937),LMSheight - 1.65748]     -- 48
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.97434,(LOCflipValue * -1.014957),LMSheight - 0.00134]     -- 49
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.03923,(LOCflipValue * -1.007427),LMSheight - 0.04403]     -- 50
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.08258,(LOCflipValue * -1.006007),LMSheight - 0.10967]     -- 51
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.03923,(LOCflipValue * -1.017277),LMSheight - 0.04577]     -- 52
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.49781,(LOCflipValue * -1.027447),LMSheight + 0.01192]     -- 53
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.31303,(LOCflipValue * -1.006007),LMSheight - 0.10967]     -- 54
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.35639,(LOCflipValue * -1.017277),LMSheight - 0.04577]     -- 55
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.31303,(LOCflipValue * -0.996167),LMSheight - 0.10793]     -- 56
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.49781,(LOCflipValue * -1.017607),LMSheight + 0.01366]     -- 57
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.42127,(LOCflipValue * -1.024807),LMSheight - 0.00307]     -- 58
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.29781,(LOCflipValue * -0.757666),LMSheight - 1.46052]     -- 59
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.49781,(LOCflipValue * -0.732785),LMSheight - 1.65922]     -- 60
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.89781,(LOCflipValue * -0.732785),LMSheight - 1.65922]     -- 61
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.09781,(LOCflipValue * -0.757666),LMSheight - 1.46052]     -- 62
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.08258,(LOCflipValue * -0.744376),LMSheight - 1.53589]     -- 63
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.08258,(LOCflipValue * -0.754224),LMSheight - 1.53763]     -- 64
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.34781,(LOCflipValue * -0.767515),LMSheight - 1.46225]     -- 65
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.49781,(LOCflipValue * -0.741467),LMSheight - 1.60997]     -- 66
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.44041,(LOCflipValue * -0.733602),LMSheight - 1.59699]     -- 67
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.44041,(LOCflipValue * -0.74345 ),LMSheight - 1.59873]     -- 68
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.35923,(LOCflipValue * -0.747699),LMSheight - 1.51705]     -- 69
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.39174,(LOCflipValue * -0.749096),LMSheight - 1.56671]     -- 70
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.04781,(LOCflipValue * -0.767515),LMSheight - 1.46225]     -- 71
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.03639,(LOCflipValue * -0.747699),LMSheight - 1.51705]     -- 72
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.95521,(LOCflipValue * -0.74345 ),LMSheight - 1.59873]     -- 73
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.95521,(LOCflipValue * -0.733602),LMSheight - 1.59699]     -- 74
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.04781,(LOCflipValue * -0.982877),LMSheight - 0.18331]     -- 75
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.89781,(LOCflipValue * -1.008917),LMSheight - 0.03559]     -- 76
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.95521,(LOCflipValue * -1.016787),LMSheight - 0.04857]     -- 77
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.03639,(LOCflipValue * -0.992837),LMSheight - 0.12678]     -- 78
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.39174,(LOCflipValue * -1.011137),LMSheight - 0.08059]     -- 79
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.44041,(LOCflipValue * -1.006937),LMSheight - 0.04683]     -- 80
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.35639,(LOCflipValue * -0.733109),LMSheight - 1.59979]     -- 81
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.49781,(LOCflipValue * -0.722937),LMSheight - 1.65748]     -- 82
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.97435,(LOCflipValue * -0.72558 ),LMSheight - 1.64249]     -- 83
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.49781,(LOCflipValue * -1.017607),LMSheight + 0.01366]     -- 84
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.89781,(LOCflipValue * -1.017607),LMSheight + 0.01366]     -- 85
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.09781,(LOCflipValue * -0.757666),LMSheight - 1.46052]     -- 86
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.09781,(LOCflipValue * -0.982877),LMSheight - 0.18331]     -- 87
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.97434,(LOCflipValue * -1.014957),LMSheight - 0.00134]     -- 88
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.03923,(LOCflipValue * -0.683868),LMSheight - 1.59111]     -- 89
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.09781,(LOCflipValue * -0.708426),LMSheight - 1.45184]     -- 90
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.89781,(LOCflipValue * -0.673696),LMSheight - 1.64880]     -- 91
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.49781,(LOCflipValue * -0.673696),LMSheight - 1.64880]     -- 92
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.35639,(LOCflipValue * -0.683868),LMSheight - 1.59111]     -- 93
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.42127,(LOCflipValue * -0.67634 ),LMSheight - 1.63380]     -- 94
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.29781,(LOCflipValue * -0.708426),LMSheight - 1.45184]     -- 95
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.03923,(LOCflipValue * -0.95819 ),LMSheight - 0.03535]     -- 96
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.08258,(LOCflipValue * -0.946923),LMSheight - 0.09925]     -- 97
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.42127,(LOCflipValue * -0.965718),LMSheight + 0.00735]     -- 98
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.89781,(LOCflipValue * -0.722937),LMSheight - 1.65748]     -- 99
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.31303,(LOCflipValue * -0.695136),LMSheight - 1.52721]     -- 100
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.31303,(LOCflipValue * -0.744376),LMSheight - 1.53589]     -- 101
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.42127,(LOCflipValue * -0.72558 ),LMSheight - 1.64249]     -- 102
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.29781,(LOCflipValue * -0.982877),LMSheight - 0.18331]     -- 103
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.29781,(LOCflipValue * -0.757666),LMSheight - 1.46052]     -- 104
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.35639,(LOCflipValue * -1.007427),LMSheight - 0.04403]     -- 105
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.42127,(LOCflipValue * -1.014957),LMSheight - 0.00134]     -- 106
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.35639,(LOCflipValue * -0.95819 ),LMSheight - 0.03535]     -- 107
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.31303,(LOCflipValue * -0.996167),LMSheight - 0.10793]     -- 108
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.29781,(LOCflipValue * -0.933632),LMSheight - 0.17462]     -- 109
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.31303,(LOCflipValue * -0.946923),LMSheight - 0.09925]     -- 110
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.49781,(LOCflipValue * -0.968362),LMSheight + 0.02234]     -- 111
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.89781,(LOCflipValue * -0.968362),LMSheight + 0.02234]     -- 112
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.09781,(LOCflipValue * -0.933632),LMSheight - 0.17462]     -- 113
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.08258,(LOCflipValue * -0.996167),LMSheight - 0.10793]     -- 114
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.03923,(LOCflipValue * -1.007427),LMSheight - 0.04403]     -- 115
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.97434,(LOCflipValue * -0.965718),LMSheight + 0.00734]     -- 116
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.97435,(LOCflipValue * -0.67634 ),LMSheight - 1.63380]     -- 117
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.03923,(LOCflipValue * -0.733109),LMSheight - 1.59979]     -- 118
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.08258,(LOCflipValue * -0.744376),LMSheight - 1.53589]     -- 119
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 2.08258,(LOCflipValue * -0.695136),LMSheight - 1.52721]     -- 120 -- backplate end

          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.7368,(LOCflipValue * -0.826147),LMSheight - 1.36008]      -- 121 -- square signal bulb background start
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.7368,(LOCflipValue * -0.81023),LMSheight - 1.16241]       -- 122
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.7368,(LOCflipValue * -0.776907),LMSheight - 1.3514]       -- 123
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.5449,(LOCflipValue * -0.81023),LMSheight - 1.16241]       -- 124
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.5449,(LOCflipValue * -0.826147),LMSheight - 1.36008]      -- 125
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.5449,(LOCflipValue * -0.776907),LMSheight - 1.3514]       -- 126
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.5449,(LOCflipValue * -0.859471),LMSheight - 1.17109]      -- 127
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.7368,(LOCflipValue * -0.859471),LMSheight - 1.17109]      -- 128
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.85071,(LOCflipValue * -0.826147),LMSheight - 1.36008]     -- 129
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.65881,(LOCflipValue * -0.859471),LMSheight - 1.17109]     -- 130
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.85071,(LOCflipValue * -0.776907),LMSheight - 1.3514]      -- 131
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.65881,(LOCflipValue * -0.81023),LMSheight - 1.16241]      -- 132
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.65881,(LOCflipValue * -0.776907),LMSheight - 1.3514]      -- 133
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.65881,(LOCflipValue * -0.826147),LMSheight - 1.36008]     -- 134
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.85071,(LOCflipValue * -0.859471),LMSheight - 1.17109]     -- 135
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.85071,(LOCflipValue * -0.81023),LMSheight - 1.16241]      -- 136
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.7368,(LOCflipValue * -0.979549),LMSheight - 0.4901]       -- 137
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.5449,(LOCflipValue * -0.963632),LMSheight - 0.29243]      -- 138
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.7368,(LOCflipValue * -0.963632),LMSheight - 0.29243]      -- 139
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.7368,(LOCflipValue * -1.01287),LMSheight - 0.30111]       -- 140
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.5449,(LOCflipValue * -1.01287),LMSheight - 0.30111]       -- 141
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.5449,(LOCflipValue * -0.979549),LMSheight - 0.4901]       -- 142
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.7368,(LOCflipValue * -0.930309),LMSheight - 0.48141]      -- 143
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.5449,(LOCflipValue * -0.930309),LMSheight - 0.48141]      -- 144
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.85071,(LOCflipValue * -1.01287),LMSheight - 0.30111]      -- 145
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.65881,(LOCflipValue * -1.01287),LMSheight - 0.30111]      -- 146
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.85071,(LOCflipValue * -0.930309),LMSheight - 0.48141]     -- 147
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.85071,(LOCflipValue * -0.963632),LMSheight - 0.29243]     -- 148
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.65881,(LOCflipValue * -0.979549),LMSheight - 0.49009]     -- 149
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.65881,(LOCflipValue * -0.963632),LMSheight - 0.29243]     -- 150
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.85071,(LOCflipValue * -0.979549),LMSheight - 0.4901]      -- 151
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.65881,(LOCflipValue * -0.930309),LMSheight - 0.48141]     -- 152 -- square signal bulb background end

          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.89781,(LOCflipValue * -1.042136),LMSheight - 0.13515]     -- 153 -- front main signal plate start (1.4 x 1.4)
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.49781,(LOCflipValue * -1.042136),LMSheight - 0.13515]     -- 154
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.49781,(LOCflipValue * -1.189862),LMSheight - 0.1612]      -- 155
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.49781,(LOCflipValue * -0.944608),LMSheight - 1.55208]     -- 156
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.49781,(LOCflipValue * -0.796883),LMSheight - 1.52604]     -- 157
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.89781,(LOCflipValue * -1.189862),LMSheight - 0.1612]      -- 158
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.89781,(LOCflipValue * -0.796883),LMSheight - 1.52604]     -- 159
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.89781,(LOCflipValue * -0.944608),LMSheight - 1.55208]     -- 160 -- front main signal plate end

          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.68255,(LOCflipValue * -0.845417),LMSheight - 1.30838]     -- 161 -- round lit signal bulbs start
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.64085,(LOCflipValue * -0.842419),LMSheight - 1.32539]     -- 162
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.64085,(LOCflipValue * -0.862896),LMSheight - 1.20926]     -- 163
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.69982,(LOCflipValue * -0.852657),LMSheight - 1.26732]     -- 164
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.59916,(LOCflipValue * -0.845417),LMSheight - 1.30838]     -- 165
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.58189,(LOCflipValue * -0.852657),LMSheight - 1.26732]     -- 166
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.59916,(LOCflipValue * -0.859897),LMSheight - 1.22626]     -- 167
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.68255,(LOCflipValue * -0.859897),LMSheight - 1.22626]     -- 168
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.79645,(LOCflipValue * -0.859897),LMSheight - 1.22626]     -- 169
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.71307,(LOCflipValue * -0.845417),LMSheight - 1.30838]     -- 170
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.71307,(LOCflipValue * -0.859897),LMSheight - 1.22626]     -- 171
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.81372,(LOCflipValue * -0.852657),LMSheight - 1.26732]     -- 172
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.79645,(LOCflipValue * -0.845417),LMSheight - 1.30838]     -- 173
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.75476,(LOCflipValue * -0.842419),LMSheight - 1.32539]     -- 174
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.6958,(LOCflipValue * -0.852657),LMSheight - 1.26732]      -- 175
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.75476,(LOCflipValue * -0.862896),LMSheight - 1.20926]     -- 176
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.68255,(LOCflipValue * -1.0133),LMSheight - 0.35628]       -- 177
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.68255,(LOCflipValue * -0.998819),LMSheight - 0.4384]      -- 178
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.64085,(LOCflipValue * -0.99582),LMSheight - 0.4554]       -- 179
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.64085,(LOCflipValue * -1.0163),LMSheight - 0.33927]       -- 180
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.59916,(LOCflipValue * -0.998819),LMSheight - 0.4384]      -- 181
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.58189,(LOCflipValue * -1.00606),LMSheight - 0.39734]      -- 182
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.69982,(LOCflipValue * -1.00606),LMSheight - 0.39734]      -- 183
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 0.59916,(LOCflipValue * -1.0133),LMSheight - 0.35628]       -- 184
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.71307,(LOCflipValue * -1.0133),LMSheight - 0.35628]       -- 185
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.6958,(LOCflipValue * -1.00606),LMSheight - 0.39734]       -- 186
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.79645,(LOCflipValue * -0.998819),LMSheight - 0.4384]      -- 187
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.75476,(LOCflipValue * -0.99582),LMSheight - 0.4554]       -- 188
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.71307,(LOCflipValue * -0.998819),LMSheight - 0.4384]      -- 189
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.75476,(LOCflipValue * -1.0163),LMSheight - 0.33927]       -- 190
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.81372,(LOCflipValue * -1.00606),LMSheight - 0.39734]      -- 191
          append v [(LMSsignalGap * (i - 1)) + LMSsignalOffset + 1.79645,(LOCflipValue * -1.0133),LMSheight - 0.35628]       -- 192 -- round lit signal bulbs end

          append f [LOCvCount + 66,LOCvCount + 60,LOCvCount + 13]       ; append m LMSmatID
          append f [LOCvCount + 60,LOCvCount + 61,LOCvCount + 13]       ; append m LMSmatID
          append f [LOCvCount + 53,LOCvCount + 23,LOCvCount + 1]        ; append m LMSmatID
          append f [LOCvCount + 23,LOCvCount + 2,LOCvCount + 1]         ; append m LMSmatID
          append f [LOCvCount + 2,LOCvCount + 77,LOCvCount + 1]         ; append m LMSmatID
          append f [LOCvCount + 77,LOCvCount + 3,LOCvCount + 1]         ; append m LMSmatID
          append f [LOCvCount + 77,LOCvCount + 5,LOCvCount + 3]         ; append m LMSmatID
          append f [LOCvCount + 5,LOCvCount + 52,LOCvCount + 3]         ; append m LMSmatID
          append f [LOCvCount + 5,LOCvCount + 4,LOCvCount + 52]         ; append m LMSmatID
          append f [LOCvCount + 4,LOCvCount + 51,LOCvCount + 52]        ; append m LMSmatID
          append f [LOCvCount + 4,LOCvCount + 6,LOCvCount + 51]         ; append m LMSmatID
          append f [LOCvCount + 6,LOCvCount + 7,LOCvCount + 51]         ; append m LMSmatID
          append f [LOCvCount + 6,LOCvCount + 71,LOCvCount + 7]         ; append m LMSmatID
          append f [LOCvCount + 71,LOCvCount + 8,LOCvCount + 7]         ; append m LMSmatID
          append f [LOCvCount + 71,LOCvCount + 9,LOCvCount + 8]         ; append m LMSmatID
          append f [LOCvCount + 9,LOCvCount + 64,LOCvCount + 8]         ; append m LMSmatID
          append f [LOCvCount + 9,LOCvCount + 11,LOCvCount + 64]        ; append m LMSmatID
          append f [LOCvCount + 11,LOCvCount + 10,LOCvCount + 64]       ; append m LMSmatID
          append f [LOCvCount + 11,LOCvCount + 73,LOCvCount + 10]       ; append m LMSmatID
          append f [LOCvCount + 73,LOCvCount + 12,LOCvCount + 10]       ; append m LMSmatID
          append f [LOCvCount + 73,LOCvCount + 13,LOCvCount + 12]       ; append m LMSmatID
          append f [LOCvCount + 13,LOCvCount + 61,LOCvCount + 12]       ; append m LMSmatID
          append f [LOCvCount + 14,LOCvCount + 65,LOCvCount + 15]       ; append m LMSmatID
          append f [LOCvCount + 65,LOCvCount + 16,LOCvCount + 15]       ; append m LMSmatID
          append f [LOCvCount + 16,LOCvCount + 17,LOCvCount + 15]       ; append m LMSmatID
          append f [LOCvCount + 17,LOCvCount + 54,LOCvCount + 15]       ; append m LMSmatID
          append f [LOCvCount + 17,LOCvCount + 79,LOCvCount + 54]       ; append m LMSmatID
          append f [LOCvCount + 79,LOCvCount + 55,LOCvCount + 54]       ; append m LMSmatID
          append f [LOCvCount + 79,LOCvCount + 18,LOCvCount + 55]       ; append m LMSmatID
          append f [LOCvCount + 14,LOCvCount + 19,LOCvCount + 65]       ; append m LMSmatID
          append f [LOCvCount + 14,LOCvCount + 21,LOCvCount + 19]       ; append m LMSmatID
          append f [LOCvCount + 21,LOCvCount + 70,LOCvCount + 19]       ; append m LMSmatID
          append f [LOCvCount + 21,LOCvCount + 20,LOCvCount + 70]       ; append m LMSmatID
          append f [LOCvCount + 20,LOCvCount + 68,LOCvCount + 70]       ; append m LMSmatID
          append f [LOCvCount + 20,LOCvCount + 22,LOCvCount + 68]       ; append m LMSmatID
          append f [LOCvCount + 22,LOCvCount + 66,LOCvCount + 68]       ; append m LMSmatID
          append f [LOCvCount + 18,LOCvCount + 58,LOCvCount + 55]       ; append m LMSmatID
          append f [LOCvCount + 18,LOCvCount + 23,LOCvCount + 58]       ; append m LMSmatID
          append f [LOCvCount + 23,LOCvCount + 53,LOCvCount + 58]       ; append m LMSmatID
          append f [LOCvCount + 22,LOCvCount + 60,LOCvCount + 66]       ; append m LMSmatID
          append f [LOCvCount + 33,LOCvCount + 48,LOCvCount + 44]       ; append m LMSmatID
          append f [LOCvCount + 33,LOCvCount + 24,LOCvCount + 48]       ; append m LMSmatID
          append f [LOCvCount + 25,LOCvCount + 46,LOCvCount + 57]       ; append m LMSmatID
          append f [LOCvCount + 25,LOCvCount + 76,LOCvCount + 46]       ; append m LMSmatID
          append f [LOCvCount + 25,LOCvCount + 26,LOCvCount + 76]       ; append m LMSmatID
          append f [LOCvCount + 25,LOCvCount + 49,LOCvCount + 26]       ; append m LMSmatID
          append f [LOCvCount + 49,LOCvCount + 27,LOCvCount + 26]       ; append m LMSmatID
          append f [LOCvCount + 49,LOCvCount + 50,LOCvCount + 27]       ; append m LMSmatID
          append f [LOCvCount + 50,LOCvCount + 78,LOCvCount + 27]       ; append m LMSmatID
          append f [LOCvCount + 50,LOCvCount + 28,LOCvCount + 78]       ; append m LMSmatID
          append f [LOCvCount + 28,LOCvCount + 75,LOCvCount + 78]       ; append m LMSmatID
          append f [LOCvCount + 28,LOCvCount + 29,LOCvCount + 75]       ; append m LMSmatID
          append f [LOCvCount + 29,LOCvCount + 30,LOCvCount + 75]       ; append m LMSmatID
          append f [LOCvCount + 29,LOCvCount + 62,LOCvCount + 30]       ; append m LMSmatID
          append f [LOCvCount + 62,LOCvCount + 72,LOCvCount + 30]       ; append m LMSmatID
          append f [LOCvCount + 62,LOCvCount + 63,LOCvCount + 72]       ; append m LMSmatID
          append f [LOCvCount + 63,LOCvCount + 31,LOCvCount + 72]       ; append m LMSmatID
          append f [LOCvCount + 63,LOCvCount + 32,LOCvCount + 31]       ; append m LMSmatID
          append f [LOCvCount + 32,LOCvCount + 74,LOCvCount + 31]       ; append m LMSmatID
          append f [LOCvCount + 32,LOCvCount + 34,LOCvCount + 74]       ; append m LMSmatID
          append f [LOCvCount + 34,LOCvCount + 33,LOCvCount + 74]       ; append m LMSmatID
          append f [LOCvCount + 34,LOCvCount + 24,LOCvCount + 33]       ; append m LMSmatID
          append f [LOCvCount + 38,LOCvCount + 35,LOCvCount + 59]       ; append m LMSmatID
          append f [LOCvCount + 38,LOCvCount + 36,LOCvCount + 35]       ; append m LMSmatID
          append f [LOCvCount + 38,LOCvCount + 37,LOCvCount + 36]       ; append m LMSmatID
          append f [LOCvCount + 38,LOCvCount + 56,LOCvCount + 37]       ; append m LMSmatID
          append f [LOCvCount + 56,LOCvCount + 39,LOCvCount + 37]       ; append m LMSmatID
          append f [LOCvCount + 56,LOCvCount + 45,LOCvCount + 39]       ; append m LMSmatID
          append f [LOCvCount + 45,LOCvCount + 80,LOCvCount + 39]       ; append m LMSmatID
          append f [LOCvCount + 35,LOCvCount + 69,LOCvCount + 59]       ; append m LMSmatID
          append f [LOCvCount + 69,LOCvCount + 40,LOCvCount + 59]       ; append m LMSmatID
          append f [LOCvCount + 69,LOCvCount + 42,LOCvCount + 40]       ; append m LMSmatID
          append f [LOCvCount + 42,LOCvCount + 41,LOCvCount + 40]       ; append m LMSmatID
          append f [LOCvCount + 42,LOCvCount + 67,LOCvCount + 41]       ; append m LMSmatID
          append f [LOCvCount + 67,LOCvCount + 43,LOCvCount + 41]       ; append m LMSmatID
          append f [LOCvCount + 67,LOCvCount + 44,LOCvCount + 43]       ; append m LMSmatID
          append f [LOCvCount + 45,LOCvCount + 47,LOCvCount + 80]       ; append m LMSmatID
          append f [LOCvCount + 47,LOCvCount + 46,LOCvCount + 80]       ; append m LMSmatID
          append f [LOCvCount + 47,LOCvCount + 57,LOCvCount + 46]       ; append m LMSmatID
          append f [LOCvCount + 44,LOCvCount + 48,LOCvCount + 43]       ; append m LMSmatID
          append f [LOCvCount + 29,LOCvCount + 8,LOCvCount + 62]        ; append m LMSmatID
          append f [LOCvCount + 29,LOCvCount + 7,LOCvCount + 8]         ; append m LMSmatID
          append f [LOCvCount + 3,LOCvCount + 49,LOCvCount + 1]         ; append m LMSmatID
          append f [LOCvCount + 49,LOCvCount + 25,LOCvCount + 1]        ; append m LMSmatID
          append f [LOCvCount + 3,LOCvCount + 52,LOCvCount + 49]        ; append m LMSmatID
          append f [LOCvCount + 52,LOCvCount + 50,LOCvCount + 49]       ; append m LMSmatID
          append f [LOCvCount + 28,LOCvCount + 50,LOCvCount + 51]       ; append m LMSmatID
          append f [LOCvCount + 50,LOCvCount + 52,LOCvCount + 51]       ; append m LMSmatID
          append f [LOCvCount + 29,LOCvCount + 28,LOCvCount + 7]        ; append m LMSmatID
          append f [LOCvCount + 28,LOCvCount + 51,LOCvCount + 7]        ; append m LMSmatID
          append f [LOCvCount + 25,LOCvCount + 53,LOCvCount + 1]        ; append m LMSmatID
          append f [LOCvCount + 25,LOCvCount + 57,LOCvCount + 53]       ; append m LMSmatID
          append f [LOCvCount + 15,LOCvCount + 54,LOCvCount + 38]       ; append m LMSmatID
          append f [LOCvCount + 54,LOCvCount + 56,LOCvCount + 38]       ; append m LMSmatID
          append f [LOCvCount + 45,LOCvCount + 56,LOCvCount + 55]       ; append m LMSmatID
          append f [LOCvCount + 56,LOCvCount + 54,LOCvCount + 55]       ; append m LMSmatID
          append f [LOCvCount + 45,LOCvCount + 55,LOCvCount + 47]       ; append m LMSmatID
          append f [LOCvCount + 55,LOCvCount + 58,LOCvCount + 47]       ; append m LMSmatID
          append f [LOCvCount + 53,LOCvCount + 57,LOCvCount + 58]       ; append m LMSmatID
          append f [LOCvCount + 57,LOCvCount + 47,LOCvCount + 58]       ; append m LMSmatID
          append f [LOCvCount + 14,LOCvCount + 38,LOCvCount + 59]       ; append m LMSmatID
          append f [LOCvCount + 14,LOCvCount + 15,LOCvCount + 38]       ; append m LMSmatID
          append f [LOCvCount + 43,LOCvCount + 48,LOCvCount + 22]       ; append m LMSmatID
          append f [LOCvCount + 48,LOCvCount + 60,LOCvCount + 22]       ; append m LMSmatID
          append f [LOCvCount + 20,LOCvCount + 41,LOCvCount + 22]       ; append m LMSmatID
          append f [LOCvCount + 41,LOCvCount + 43,LOCvCount + 22]       ; append m LMSmatID
          append f [LOCvCount + 21,LOCvCount + 40,LOCvCount + 20]       ; append m LMSmatID
          append f [LOCvCount + 40,LOCvCount + 41,LOCvCount + 20]       ; append m LMSmatID
          append f [LOCvCount + 40,LOCvCount + 21,LOCvCount + 59]       ; append m LMSmatID
          append f [LOCvCount + 21,LOCvCount + 14,LOCvCount + 59]       ; append m LMSmatID
          append f [LOCvCount + 61,LOCvCount + 48,LOCvCount + 24]       ; append m LMSmatID
          append f [LOCvCount + 61,LOCvCount + 60,LOCvCount + 48]       ; append m LMSmatID
          append f [LOCvCount + 64,LOCvCount + 63,LOCvCount + 8]        ; append m LMSmatID
          append f [LOCvCount + 63,LOCvCount + 62,LOCvCount + 8]        ; append m LMSmatID
          append f [LOCvCount + 63,LOCvCount + 64,LOCvCount + 32]       ; append m LMSmatID
          append f [LOCvCount + 64,LOCvCount + 10,LOCvCount + 32]       ; append m LMSmatID
          append f [LOCvCount + 12,LOCvCount + 34,LOCvCount + 10]       ; append m LMSmatID
          append f [LOCvCount + 34,LOCvCount + 32,LOCvCount + 10]       ; append m LMSmatID
          append f [LOCvCount + 34,LOCvCount + 12,LOCvCount + 24]       ; append m LMSmatID
          append f [LOCvCount + 12,LOCvCount + 61,LOCvCount + 24]       ; append m LMSmatID
          append f [LOCvCount + 35,LOCvCount + 36,LOCvCount + 65]       ; append m LMSmatID
          append f [LOCvCount + 36,LOCvCount + 16,LOCvCount + 65]       ; append m LMSmatID
          append f [LOCvCount + 44,LOCvCount + 68,LOCvCount + 66]       ; append m LMSmatID
          append f [LOCvCount + 44,LOCvCount + 67,LOCvCount + 68]       ; append m LMSmatID
          append f [LOCvCount + 70,LOCvCount + 67,LOCvCount + 42]       ; append m LMSmatID
          append f [LOCvCount + 70,LOCvCount + 68,LOCvCount + 67]       ; append m LMSmatID
          append f [LOCvCount + 19,LOCvCount + 42,LOCvCount + 69]       ; append m LMSmatID
          append f [LOCvCount + 19,LOCvCount + 70,LOCvCount + 42]       ; append m LMSmatID
          append f [LOCvCount + 35,LOCvCount + 19,LOCvCount + 69]       ; append m LMSmatID
          append f [LOCvCount + 35,LOCvCount + 65,LOCvCount + 19]       ; append m LMSmatID
          append f [LOCvCount + 33,LOCvCount + 44,LOCvCount + 13]       ; append m LMSmatID
          append f [LOCvCount + 44,LOCvCount + 66,LOCvCount + 13]       ; append m LMSmatID
          append f [LOCvCount + 71,LOCvCount + 72,LOCvCount + 9]        ; append m LMSmatID
          append f [LOCvCount + 71,LOCvCount + 30,LOCvCount + 72]       ; append m LMSmatID
          append f [LOCvCount + 11,LOCvCount + 72,LOCvCount + 31]       ; append m LMSmatID
          append f [LOCvCount + 11,LOCvCount + 9,LOCvCount + 72]        ; append m LMSmatID
          append f [LOCvCount + 73,LOCvCount + 31,LOCvCount + 74]       ; append m LMSmatID
          append f [LOCvCount + 73,LOCvCount + 11,LOCvCount + 31]       ; append m LMSmatID
          append f [LOCvCount + 74,LOCvCount + 13,LOCvCount + 73]       ; append m LMSmatID
          append f [LOCvCount + 74,LOCvCount + 33,LOCvCount + 13]       ; append m LMSmatID
          append f [LOCvCount + 30,LOCvCount + 71,LOCvCount + 75]       ; append m LMSmatID
          append f [LOCvCount + 71,LOCvCount + 6,LOCvCount + 75]        ; append m LMSmatID
          append f [LOCvCount + 26,LOCvCount + 2,LOCvCount + 76]        ; append m LMSmatID
          append f [LOCvCount + 26,LOCvCount + 77,LOCvCount + 2]        ; append m LMSmatID
          append f [LOCvCount + 77,LOCvCount + 27,LOCvCount + 5]        ; append m LMSmatID
          append f [LOCvCount + 77,LOCvCount + 26,LOCvCount + 27]       ; append m LMSmatID
          append f [LOCvCount + 78,LOCvCount + 5,LOCvCount + 27]        ; append m LMSmatID
          append f [LOCvCount + 78,LOCvCount + 4,LOCvCount + 5]         ; append m LMSmatID
          append f [LOCvCount + 78,LOCvCount + 6,LOCvCount + 4]         ; append m LMSmatID
          append f [LOCvCount + 78,LOCvCount + 75,LOCvCount + 6]        ; append m LMSmatID
          append f [LOCvCount + 2,LOCvCount + 23,LOCvCount + 76]        ; append m LMSmatID
          append f [LOCvCount + 23,LOCvCount + 46,LOCvCount + 76]       ; append m LMSmatID
          append f [LOCvCount + 36,LOCvCount + 17,LOCvCount + 16]       ; append m LMSmatID
          append f [LOCvCount + 36,LOCvCount + 37,LOCvCount + 17]       ; append m LMSmatID
          append f [LOCvCount + 79,LOCvCount + 37,LOCvCount + 39]       ; append m LMSmatID
          append f [LOCvCount + 79,LOCvCount + 17,LOCvCount + 37]       ; append m LMSmatID
          append f [LOCvCount + 18,LOCvCount + 39,LOCvCount + 80]       ; append m LMSmatID
          append f [LOCvCount + 18,LOCvCount + 79,LOCvCount + 39]       ; append m LMSmatID
          append f [LOCvCount + 18,LOCvCount + 46,LOCvCount + 23]       ; append m LMSmatID
          append f [LOCvCount + 18,LOCvCount + 80,LOCvCount + 46]       ; append m LMSmatID

          append f [LOCvCount + 81,LOCvCount + 104,LOCvCount + 101]     ; append m 3
          append f [LOCvCount + 81,LOCvCount + 102,LOCvCount + 104]     ; append m 3
          append f [LOCvCount + 102,LOCvCount + 82,LOCvCount + 104]     ; append m 3
          append f [LOCvCount + 82,LOCvCount + 99,LOCvCount + 104]      ; append m 3
          append f [LOCvCount + 99,LOCvCount + 86,LOCvCount + 104]      ; append m 3
          append f [LOCvCount + 99,LOCvCount + 119,LOCvCount + 86]      ; append m 3
          append f [LOCvCount + 99,LOCvCount + 118,LOCvCount + 119]     ; append m 3
          append f [LOCvCount + 99,LOCvCount + 83,LOCvCount + 118]      ; append m 3
          append f [LOCvCount + 86,LOCvCount + 103,LOCvCount + 104]     ; append m 3
          append f [LOCvCount + 86,LOCvCount + 84,LOCvCount + 103]      ; append m 3
          append f [LOCvCount + 84,LOCvCount + 106,LOCvCount + 103]     ; append m 3
          append f [LOCvCount + 106,LOCvCount + 105,LOCvCount + 103]    ; append m 3
          append f [LOCvCount + 105,LOCvCount + 108,LOCvCount + 103]    ; append m 3
          append f [LOCvCount + 86,LOCvCount + 85,LOCvCount + 84]       ; append m 3
          append f [LOCvCount + 86,LOCvCount + 87,LOCvCount + 85]       ; append m 3
          append f [LOCvCount + 87,LOCvCount + 114,LOCvCount + 85]      ; append m 3
          append f [LOCvCount + 114,LOCvCount + 115,LOCvCount + 85]     ; append m 3
          append f [LOCvCount + 115,LOCvCount + 88,LOCvCount + 85]      ; append m 3
          append f [LOCvCount + 120,LOCvCount + 89,LOCvCount + 90]      ; append m 3
          append f [LOCvCount + 89,LOCvCount + 117,LOCvCount + 90]      ; append m 3
          append f [LOCvCount + 117,LOCvCount + 91,LOCvCount + 90]      ; append m 3
          append f [LOCvCount + 91,LOCvCount + 92,LOCvCount + 90]       ; append m 3
          append f [LOCvCount + 92,LOCvCount + 95,LOCvCount + 90]       ; append m 3
          append f [LOCvCount + 92,LOCvCount + 94,LOCvCount + 95]       ; append m 3
          append f [LOCvCount + 94,LOCvCount + 100,LOCvCount + 95]      ; append m 3
          append f [LOCvCount + 94,LOCvCount + 93,LOCvCount + 100]      ; append m 3
          append f [LOCvCount + 95,LOCvCount + 113,LOCvCount + 90]      ; append m 3
          append f [LOCvCount + 95,LOCvCount + 112,LOCvCount + 113]     ; append m 3
          append f [LOCvCount + 112,LOCvCount + 116,LOCvCount + 113]    ; append m 3
          append f [LOCvCount + 116,LOCvCount + 96,LOCvCount + 113]     ; append m 3
          append f [LOCvCount + 96,LOCvCount + 97,LOCvCount + 113]      ; append m 3
          append f [LOCvCount + 95,LOCvCount + 111,LOCvCount + 112]     ; append m 3
          append f [LOCvCount + 95,LOCvCount + 109,LOCvCount + 111]     ; append m 3
          append f [LOCvCount + 109,LOCvCount + 98,LOCvCount + 111]     ; append m 3
          append f [LOCvCount + 109,LOCvCount + 107,LOCvCount + 98]     ; append m 3
          append f [LOCvCount + 109,LOCvCount + 110,LOCvCount + 107]    ; append m 3
          append f [LOCvCount + 82,LOCvCount + 91,LOCvCount + 99]       ; append m 3
          append f [LOCvCount + 82,LOCvCount + 92,LOCvCount + 91]       ; append m 3
          append f [LOCvCount + 101,LOCvCount + 104,LOCvCount + 100]    ; append m 3
          append f [LOCvCount + 104,LOCvCount + 95,LOCvCount + 100]     ; append m 3
          append f [LOCvCount + 100,LOCvCount + 93,LOCvCount + 101]     ; append m 3
          append f [LOCvCount + 93,LOCvCount + 81,LOCvCount + 101]      ; append m 3
          append f [LOCvCount + 102,LOCvCount + 81,LOCvCount + 94]      ; append m 3
          append f [LOCvCount + 81,LOCvCount + 93,LOCvCount + 94]       ; append m 3
          append f [LOCvCount + 94,LOCvCount + 92,LOCvCount + 102]      ; append m 3
          append f [LOCvCount + 92,LOCvCount + 82,LOCvCount + 102]      ; append m 3
          append f [LOCvCount + 95,LOCvCount + 103,LOCvCount + 109]     ; append m 3
          append f [LOCvCount + 95,LOCvCount + 104,LOCvCount + 103]     ; append m 3
          append f [LOCvCount + 98,LOCvCount + 106,LOCvCount + 111]     ; append m 3
          append f [LOCvCount + 106,LOCvCount + 84,LOCvCount + 111]     ; append m 3
          append f [LOCvCount + 105,LOCvCount + 106,LOCvCount + 107]    ; append m 3
          append f [LOCvCount + 106,LOCvCount + 98,LOCvCount + 107]     ; append m 3
          append f [LOCvCount + 108,LOCvCount + 105,LOCvCount + 110]    ; append m 3
          append f [LOCvCount + 105,LOCvCount + 107,LOCvCount + 110]    ; append m 3
          append f [LOCvCount + 110,LOCvCount + 109,LOCvCount + 108]    ; append m 3
          append f [LOCvCount + 109,LOCvCount + 103,LOCvCount + 108]    ; append m 3
          append f [LOCvCount + 112,LOCvCount + 84,LOCvCount + 85]      ; append m 3
          append f [LOCvCount + 112,LOCvCount + 111,LOCvCount + 84]     ; append m 3
          append f [LOCvCount + 87,LOCvCount + 113,LOCvCount + 114]     ; append m 3
          append f [LOCvCount + 113,LOCvCount + 97,LOCvCount + 114]     ; append m 3
          append f [LOCvCount + 115,LOCvCount + 114,LOCvCount + 96]     ; append m 3
          append f [LOCvCount + 114,LOCvCount + 97,LOCvCount + 96]      ; append m 3
          append f [LOCvCount + 115,LOCvCount + 96,LOCvCount + 88]      ; append m 3
          append f [LOCvCount + 96,LOCvCount + 116,LOCvCount + 88]      ; append m 3
          append f [LOCvCount + 116,LOCvCount + 112,LOCvCount + 88]     ; append m 3
          append f [LOCvCount + 112,LOCvCount + 85,LOCvCount + 88]      ; append m 3
          append f [LOCvCount + 87,LOCvCount + 90,LOCvCount + 113]      ; append m 3
          append f [LOCvCount + 87,LOCvCount + 86,LOCvCount + 90]       ; append m 3
          append f [LOCvCount + 99,LOCvCount + 91,LOCvCount + 83]       ; append m 3
          append f [LOCvCount + 91,LOCvCount + 117,LOCvCount + 83]      ; append m 3
          append f [LOCvCount + 83,LOCvCount + 117,LOCvCount + 118]     ; append m 3
          append f [LOCvCount + 117,LOCvCount + 89,LOCvCount + 118]     ; append m 3
          append f [LOCvCount + 120,LOCvCount + 119,LOCvCount + 89]     ; append m 3
          append f [LOCvCount + 119,LOCvCount + 118,LOCvCount + 89]     ; append m 3
          append f [LOCvCount + 119,LOCvCount + 120,LOCvCount + 86]     ; append m 3
          append f [LOCvCount + 120,LOCvCount + 90,LOCvCount + 86]      ; append m 3

          append f [LOCvCount + 127,LOCvCount + 125,LOCvCount + 128]    ; append m 5
          append f [LOCvCount + 125,LOCvCount + 121,LOCvCount + 128]    ; append m 5
          append f [LOCvCount + 122,LOCvCount + 126,LOCvCount + 124]    ; append m 5
          append f [LOCvCount + 122,LOCvCount + 123,LOCvCount + 126]    ; append m 5
          append f [LOCvCount + 127,LOCvCount + 122,LOCvCount + 124]    ; append m 5
          append f [LOCvCount + 127,LOCvCount + 128,LOCvCount + 122]    ; append m 5
          append f [LOCvCount + 127,LOCvCount + 126,LOCvCount + 125]    ; append m 5
          append f [LOCvCount + 127,LOCvCount + 124,LOCvCount + 126]    ; append m 5
          append f [LOCvCount + 125,LOCvCount + 123,LOCvCount + 121]    ; append m 5
          append f [LOCvCount + 125,LOCvCount + 126,LOCvCount + 123]    ; append m 5
          append f [LOCvCount + 123,LOCvCount + 128,LOCvCount + 121]    ; append m 5
          append f [LOCvCount + 123,LOCvCount + 122,LOCvCount + 128]    ; append m 5
          append f [LOCvCount + 130,LOCvCount + 129,LOCvCount + 135]    ; append m 5
          append f [LOCvCount + 130,LOCvCount + 134,LOCvCount + 129]    ; append m 5
          append f [LOCvCount + 136,LOCvCount + 131,LOCvCount + 132]    ; append m 5
          append f [LOCvCount + 131,LOCvCount + 133,LOCvCount + 132]    ; append m 5
          append f [LOCvCount + 130,LOCvCount + 136,LOCvCount + 132]    ; append m 5
          append f [LOCvCount + 130,LOCvCount + 135,LOCvCount + 136]    ; append m 5
          append f [LOCvCount + 130,LOCvCount + 133,LOCvCount + 134]    ; append m 5
          append f [LOCvCount + 130,LOCvCount + 132,LOCvCount + 133]    ; append m 5
          append f [LOCvCount + 134,LOCvCount + 131,LOCvCount + 129]    ; append m 5
          append f [LOCvCount + 134,LOCvCount + 133,LOCvCount + 131]    ; append m 5
          append f [LOCvCount + 131,LOCvCount + 135,LOCvCount + 129]    ; append m 5
          append f [LOCvCount + 131,LOCvCount + 136,LOCvCount + 135]    ; append m 5
          append f [LOCvCount + 141,LOCvCount + 142,LOCvCount + 140]    ; append m 5
          append f [LOCvCount + 142,LOCvCount + 137,LOCvCount + 140]    ; append m 5
          append f [LOCvCount + 139,LOCvCount + 144,LOCvCount + 138]    ; append m 5
          append f [LOCvCount + 139,LOCvCount + 143,LOCvCount + 144]    ; append m 5
          append f [LOCvCount + 141,LOCvCount + 139,LOCvCount + 138]    ; append m 5
          append f [LOCvCount + 141,LOCvCount + 140,LOCvCount + 139]    ; append m 5
          append f [LOCvCount + 141,LOCvCount + 144,LOCvCount + 142]    ; append m 5
          append f [LOCvCount + 141,LOCvCount + 138,LOCvCount + 144]    ; append m 5
          append f [LOCvCount + 142,LOCvCount + 143,LOCvCount + 137]    ; append m 5
          append f [LOCvCount + 142,LOCvCount + 144,LOCvCount + 143]    ; append m 5
          append f [LOCvCount + 143,LOCvCount + 140,LOCvCount + 137]    ; append m 5
          append f [LOCvCount + 143,LOCvCount + 139,LOCvCount + 140]    ; append m 5
          append f [LOCvCount + 146,LOCvCount + 151,LOCvCount + 145]    ; append m 5
          append f [LOCvCount + 146,LOCvCount + 149,LOCvCount + 151]    ; append m 5
          append f [LOCvCount + 148,LOCvCount + 147,LOCvCount + 150]    ; append m 5
          append f [LOCvCount + 147,LOCvCount + 152,LOCvCount + 150]    ; append m 5
          append f [LOCvCount + 146,LOCvCount + 148,LOCvCount + 150]    ; append m 5
          append f [LOCvCount + 146,LOCvCount + 145,LOCvCount + 148]    ; append m 5
          append f [LOCvCount + 146,LOCvCount + 152,LOCvCount + 149]    ; append m 5
          append f [LOCvCount + 146,LOCvCount + 150,LOCvCount + 152]    ; append m 5
          append f [LOCvCount + 149,LOCvCount + 147,LOCvCount + 151]    ; append m 5
          append f [LOCvCount + 149,LOCvCount + 152,LOCvCount + 147]    ; append m 5
          append f [LOCvCount + 147,LOCvCount + 145,LOCvCount + 151]    ; append m 5
          append f [LOCvCount + 147,LOCvCount + 148,LOCvCount + 145]    ; append m 5

          append f [LOCvCount + 155,LOCvCount + 156,LOCvCount + 158]    ; append m LMSsignMatID
          append f [LOCvCount + 156,LOCvCount + 160,LOCvCount + 158]    ; append m LMSsignMatID
          append f [LOCvCount + 154,LOCvCount + 159,LOCvCount + 157]    ; append m LMSsignMatID
          append f [LOCvCount + 154,LOCvCount + 153,LOCvCount + 159]    ; append m LMSsignMatID
          append f [LOCvCount + 155,LOCvCount + 153,LOCvCount + 154]    ; append m LMSsignMatID
          append f [LOCvCount + 155,LOCvCount + 158,LOCvCount + 153]    ; append m LMSsignMatID
          append f [LOCvCount + 157,LOCvCount + 155,LOCvCount + 154]    ; append m LMSsignMatID
          append f [LOCvCount + 157,LOCvCount + 156,LOCvCount + 155]    ; append m LMSsignMatID
          append f [LOCvCount + 159,LOCvCount + 156,LOCvCount + 157]    ; append m LMSsignMatID
          append f [LOCvCount + 159,LOCvCount + 160,LOCvCount + 156]    ; append m LMSsignMatID
          append f [LOCvCount + 158,LOCvCount + 159,LOCvCount + 153]    ; append m LMSsignMatID
          append f [LOCvCount + 158,LOCvCount + 160,LOCvCount + 159]    ; append m LMSsignMatID

          append f [LOCvCount + 168,LOCvCount + 161,LOCvCount + 164]    ; append m 3
          append f [LOCvCount + 168,LOCvCount + 163,LOCvCount + 161]    ; append m 3
          append f [LOCvCount + 163,LOCvCount + 162,LOCvCount + 161]    ; append m 3
          append f [LOCvCount + 163,LOCvCount + 165,LOCvCount + 162]    ; append m 3
          append f [LOCvCount + 163,LOCvCount + 167,LOCvCount + 165]    ; append m 3
          append f [LOCvCount + 167,LOCvCount + 166,LOCvCount + 165]    ; append m 3
          append f [LOCvCount + 176,LOCvCount + 172,LOCvCount + 169]    ; append m 3
          append f [LOCvCount + 176,LOCvCount + 171,LOCvCount + 172]    ; append m 3
          append f [LOCvCount + 171,LOCvCount + 173,LOCvCount + 172]    ; append m 3
          append f [LOCvCount + 171,LOCvCount + 174,LOCvCount + 173]    ; append m 3
          append f [LOCvCount + 171,LOCvCount + 170,LOCvCount + 174]    ; append m 3
          append f [LOCvCount + 171,LOCvCount + 175,LOCvCount + 170]    ; append m 3
          append f [LOCvCount + 177,LOCvCount + 178,LOCvCount + 183]    ; append m 3
          append f [LOCvCount + 177,LOCvCount + 180,LOCvCount + 178]    ; append m 3
          append f [LOCvCount + 180,LOCvCount + 179,LOCvCount + 178]    ; append m 3
          append f [LOCvCount + 180,LOCvCount + 181,LOCvCount + 179]    ; append m 3
          append f [LOCvCount + 180,LOCvCount + 184,LOCvCount + 181]    ; append m 3
          append f [LOCvCount + 184,LOCvCount + 182,LOCvCount + 181]    ; append m 3
          append f [LOCvCount + 190,LOCvCount + 191,LOCvCount + 192]    ; append m 3
          append f [LOCvCount + 190,LOCvCount + 185,LOCvCount + 191]    ; append m 3
          append f [LOCvCount + 185,LOCvCount + 187,LOCvCount + 191]    ; append m 3
          append f [LOCvCount + 185,LOCvCount + 188,LOCvCount + 187]    ; append m 3
          append f [LOCvCount + 185,LOCvCount + 189,LOCvCount + 188]    ; append m 3
          append f [LOCvCount + 185,LOCvCount + 186,LOCvCount + 189]    ; append m 3
        )
      ) -- End if


      ----------------------------------------------------------------------
      --Make Mesh Object from Previous Information
      setMesh mesh verts:v faces:f materialIDs:m

      --- Add TVertices
      local uvw_array = #()
      append uvw_array [0.0,0.0,0.0]
      append uvw_array [1.0,0.0,0.0]
      append uvw_array [1.0,1.0,0.0]
      append uvw_array [0.0,1.0,0.0]
      setNumTVerts mesh uvw_array.count --set the number of vertices
      for v = 1 to uvw_array.count do setTVert mesh v uvw_array[v] --set all tVertices
      buildTVFaces mesh false --build texture faces

      local LOCfaceIDs = #(0,(LOCfacesAfterPosts/2))

      for i = 1 to 2 do
      (
        for ii =  1 to 12 do (SetFaceSmoothGroup mesh (LOCfaceIDs[i] + ii) 0) -- Posts
        for ii = 13 to 36 do (SetFaceSmoothGroup mesh (LOCfaceIDs[i] + ii) 2) -- Horizontal Bars
        for ii = 37 to 86 do (SetFaceSmoothGroup mesh (LOCfaceIDs[i] + ii) 0) -- More Post Parts

        --- Posts
        SetEdgeVis mesh (LOCfaceIDs[i] + 1)  3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 2)  2 false  ; SetEdgeVis mesh (LOCfaceIDs[i] + 2) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 3)  2 false  ; SetEdgeVis mesh (LOCfaceIDs[i] + 3) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 4)  3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 5)  3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 6)  2 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 7)  3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 8)  2 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 9)  3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 10) 2 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 11) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 12) 1 false  ; SetEdgeVis mesh (LOCfaceIDs[i] + 12) 3 false

        --- Cross Bars
        for ii = 13 to 36 do (SetEdgeVis mesh (LOCfaceIDs[i] + ii) 3 false)

        --- Posts (More)
        SetEdgeVis mesh (LOCfaceIDs[i] + 37) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 38) 2 false ; SetEdgeVis mesh (LOCfaceIDs[i] + 38) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 39) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 40) 1 false ; SetEdgeVis mesh (LOCfaceIDs[i] + 40) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 41) 1 false ; SetEdgeVis mesh (LOCfaceIDs[i] + 41) 2 false ; SetEdgeVis mesh (LOCfaceIDs[i] + 41) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 42) 2 false ; SetEdgeVis mesh (LOCfaceIDs[i] + 42) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 43) 1 false ; SetEdgeVis mesh (LOCfaceIDs[i] + 43) 2 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 44) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 45) 2 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 46) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 47) 2 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 48) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 49) 2 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 50) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 51) 2 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 52) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 53) 2 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 54) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 55) 2 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 56) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 57) 2 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 58) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 59) 1 false ; SetEdgeVis mesh (LOCfaceIDs[i] + 59) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 60) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 61) 2 false ; SetEdgeVis mesh (LOCfaceIDs[i] + 61) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 62) 1 false ; SetEdgeVis mesh (LOCfaceIDs[i] + 62) 2 false ; SetEdgeVis mesh (LOCfaceIDs[i] + 62) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 63) 1 false ; SetEdgeVis mesh (LOCfaceIDs[i] + 63) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 64) 1 false ; SetEdgeVis mesh (LOCfaceIDs[i] + 64) 2 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 65) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 66) 1 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 67) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 68) 1 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 69) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 70) 1 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 71) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 72) 1 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 73) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 74) 1 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 75) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 76) 1 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 77) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 78) 1 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 79) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 80) 1 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 81) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 82) 1 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 83) 3 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 84) 1 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 85) 2 false
        SetEdgeVis mesh (LOCfaceIDs[i] + 86) 2 false
      )

      --- EDIT SIGNAL FACES
      for i in (LOCfacesAfterPosts + 1) to LOCfacesAfterStruts[1] do
      (
        setfacesmoothgroup mesh i 5
      )

      if LMSsignals then
      (
        for i = 1 to LMSnumberOfSignals do
        (
          --- Set Face Texture Coords
          if LMSflipSignals then
          (
            setTVFace mesh (LOCfacesAfterStruts[i] + 285) 3 2 4
            setTVFace mesh (LOCfacesAfterStruts[i] + 286) 2 1 4
          )
          else
          (
            setTVFace mesh (LOCfacesAfterStruts[i] + 285) 4 1 3
            setTVFace mesh (LOCfacesAfterStruts[i] + 286) 1 2 3
          )

          --- Set Edge Visibility
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 1) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 2) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 3) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 4) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 5) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 6) 1 false  ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 6) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 7) 2 false  ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 7) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 8) 1 false  ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 8) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 9) 2 false  ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 9) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 10) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 10) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 11) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 11) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 12) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 13) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 14) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 15) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 16) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 16) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 17) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 17) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 18) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 18) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 19) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 19) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 20) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 20) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 21) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 21) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 22) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 23) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 24) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 25) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 26) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 26) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 27) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 27) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 28) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 28) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 29) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 29) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 30) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 31) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 31) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 32) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 32) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 33) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 33) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 34) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 34) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 35) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 35) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 36) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 36) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 37) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 37) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 38) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 38) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 39) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 40) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 41) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 42) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 43) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 44) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 45) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 46) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 46) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 47) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 47) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 48) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 48) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 49) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 49) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 50) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 50) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 51) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 51) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 52) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 53) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 54) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 55) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 56) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 56) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 57) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 57) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 58) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 58) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 59) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 59) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 60) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 60) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 61) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 61) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 62) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 63) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 64) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 65) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 66) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 66) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 67) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 67) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 68) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 68) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 69) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 69) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 70) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 71) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 71) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 72) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 72) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 73) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 73) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 74) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 74) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 75) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 75) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 76) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 76) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 77) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 77) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 78) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 78) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 79) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 80) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 81) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 82) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 83) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 83) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 84) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 85) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 85) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 86) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 86) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 87) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 87) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 88) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 88) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 89) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 90) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 90) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 91) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 92) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 93) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 94) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 94) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 95) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 95) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 96) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 96) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 97) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 97) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 98) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 98) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 99) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 100) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 100) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 101) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 102) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 103) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 103) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 104) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 105) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 105) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 106) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 106) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 107) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 107) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 108) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 108) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 109) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 109) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 110) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 111) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 112) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 113) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 113) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 114) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 115) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 115) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 116) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 116) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 117) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 117) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 118) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 118) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 119) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 119) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 120) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 121) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 122) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 123) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 124) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 124) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 125) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 125) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 126) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 126) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 127) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 127) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 128) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 128) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 129) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 129) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 130) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 131) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 132) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 133) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 133) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 134) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 135) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 135) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 136) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 136) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 137) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 137) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 138) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 138) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 139) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 139) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 140) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 141) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 142) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 143) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 144) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 144) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 145) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 145) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 146) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 146) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 147) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 147) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 148) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 148) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 149) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 149) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 150) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 151) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 152) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 153) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 154) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 154) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 155) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 155) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 156) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 156) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 157) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 157) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 158) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 158) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 159) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 160) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 160) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 161) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 162) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 162) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 163) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 163) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 164) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 164) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 165) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 165) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 165) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 166) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 166) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 167) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 167) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 168) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 169) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 169) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 170) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 170) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 170) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 171) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 171) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 172) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 172) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 173) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 174) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 174) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 174) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 175) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 175) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 176) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 176) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 177) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 177) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 178) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 179) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 180) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 180) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 181) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 181) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 182) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 182) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 183) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 183) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 183) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 184) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 184) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 185) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 185) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 186) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 187) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 187) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 188) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 188) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 188) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 189) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 189) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 190) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 190) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 191) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 192) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 192) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 193) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 193) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 194) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 194) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 195) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 195) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 196) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 197) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 198) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 199) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 199) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 200) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 201) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 201) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 202) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 202) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 203) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 203) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 204) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 204) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 205) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 205) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 206) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 207) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 208) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 209) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 209) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 210) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 211) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 211) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 212) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 212) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 213) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 213) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 214) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 214) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 215) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 215) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 216) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 217) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 217) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 218) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 219) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 220) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 220) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 221) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 221) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 222) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 222) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 223) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 223) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 224) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 224) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 225) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 225) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 226) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 227) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 228) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 229) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 230) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 230) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 231) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 231) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 232) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 232) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 233) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 233) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 234) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 234) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 235) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 235) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 236) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 237) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 238) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 239) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 240) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 241) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 242) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 243) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 244) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 245) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 246) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 247) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 248) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 249) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 250) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 251) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 252) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 253) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 254) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 255) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 256) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 257) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 258) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 259) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 260) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 261) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 262) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 263) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 264) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 265) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 266) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 267) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 268) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 269) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 270) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 271) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 272) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 273) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 274) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 275) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 276) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 277) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 278) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 279) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 280) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 281) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 282) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 283) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 284) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 285) 2 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 286) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 287) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 288) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 289) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 290) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 291) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 292) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 293) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 294) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 295) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 296) 3 false

          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 297) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 298) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 298) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 299) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 299) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 300) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 300) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 301) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 301) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 302) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 303) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 304) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 304) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 305) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 305) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 306) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 306) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 307) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 307) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 308) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 309) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 310) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 310) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 311) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 311) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 312) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 312) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 313) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 313) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 314) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 315) 1 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 316) 2 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 316) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 317) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 317) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 318) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 318) 2 true ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 318) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 319) 1 false ; SetEdgeVis mesh (LOCfacesAfterStruts[i] + 319) 3 false
          SetEdgeVis mesh (LOCfacesAfterStruts[i] + 320) 3 false
        )

        --- EDIT SIGNAL FACES
        for ii = (LOCfacesAfterStruts[1] + 1) to (LOCfacesAfterStruts[LOCfacesAfterStruts.count] + 320) do
        (
          SetFaceSmoothGroup mesh ii 0
          if LMSflipSignals then meshop.flipNormals mesh ii
        )
      )
    )
    else
    (
      -- Vertex data (52 verts)-----------------------
      vp = #(
        [                 0.2,    0.2,     0.35],      [                 0.2,    0.2,  LMSheight-1.1],
        [       LMSlength+0.1,    0.2,  LMSheight-1.1],[       LMSlength+0.1,    0.2,  LMSheight],
        [                 0.2,    0.2,  LMSheight],    [                 0.2,    0.2,  LMSheight+0.4],
        [                -0.2,    0.2,  LMSheight+0.4],[                -0.2,    0.2,     0.35],
        [               -0.25,    0.2,     0.35],      [                -0.4,    0.2,     0.1],
        [                -0.4,    0.2,     0.0],       [                -0.5,    0.2,     0.0],
        [                -0.5,    0.2,    -0.25],      [                 0.5,    0.2,    -0.25],
        [                 0.5,    0.2,     0.0],       [                 0.4,    0.2,     0.0],
        [                 0.4,    0.2,     0.1],       [                0.25,    0.2,     0.35],
        [                 0.4,    0.2,  LMSheight-0.9],[                 0.4,    0.2,  LMSheight-0.2],
        [(LMSlength/2.0)+0.05,    0.2,  LMSheight-0.2],[(LMSlength/2.0)+0.05,    0.2,  LMSheight-0.9],
        [(LMSlength/2.0)+0.25,    0.2,  LMSheight-0.2],[       LMSlength-0.1,    0.2,  LMSheight-0.2],
        [       LMSlength-0.1,    0.2,  LMSheight-0.9],[(LMSlength/2.0)+0.25,    0.2,  LMSheight-0.9],
        [                 0.2,   -0.2,     0.35],      [                 0.2,   -0.2,  LMSheight-1.1],
        [       LMSlength+0.1,   -0.2,  LMSheight-1.1],[       LMSlength+0.1,   -0.2,  LMSheight],
        [                 0.2,   -0.2,  LMSheight],    [                 0.2,   -0.2,  LMSheight+0.4],
        [                -0.2,   -0.2,  LMSheight+0.4],[                -0.2,   -0.2,     0.35],
        [               -0.25,   -0.2,     0.35],      [                -0.4,   -0.2,     0.1],
        [                -0.4,   -0.2,     0.0],       [                -0.5,   -0.2,     0.0],
        [                -0.5,   -0.2,    -0.25],      [                 0.5,   -0.2,    -0.25],
        [                 0.5,   -0.2,     0.00],      [                 0.4,   -0.2,     0.00],
        [                 0.4,   -0.2,     0.1],       [                0.25,   -0.2,     0.35],
        [                 0.4,   -0.2,  LMSheight-0.9],[                 0.4,   -0.2,  LMSheight-0.2],
        [(LMSlength/2.0)+0.05,   -0.2,  LMSheight-0.2],[(LMSlength/2.0)+0.05,   -0.2,  LMSheight-0.9],
        [(LMSlength/2.0)+0.25,   -0.2,  LMSheight-0.2],[       LMSlength-0.1,   -0.2,  LMSheight-0.2],
        [       LMSlength-0.1,   -0.2,  LMSheight-0.9],[(LMSlength/2.0)+0.25,   -0.2,  LMSheight-0.9])
      -- Face data (108 faces) ---------------------------
      fl = #(        [3,2,25],      [26,25,2],     [23,26,21],    [22,21,26],    [22,26,2],     [19,22,2],
      [4,3,25],      [4,25,24],     [5,4,24],      [5,24,23],     [5,23,21],     [5,21,20],     [16,15,14],
      [16,14,13],    [13,12,11],    [16,13,11],    [16,11,10],    [16,10,9],     [16,9,8],      [17,16,8],
      [8,7,6],       [8,6,5],       [1,18,17],     [1,17,8],      [2,1,8],       [2,8,5],       [19,2,5],    [20,19,5],
      [1,2,28],      [1,28,27],     [2,3,29],      [2,29,28],     [3,4,30],      [3,30,29],     [4,5,31],    [4,31,30],
      [5,6,32],      [5,32,31],     [6,7,33],      [6,33,32],     [7,8,34],      [7,34,33],     [8,9,35],    [8,35,34],
      [9,10,36],     [9,36,35],     [10,11,37],    [10,37,36],    [11,12,38],    [11,38,37],    [12,13,39],  [12,39,38],
      [13,14,40],    [13,40,39],    [14,15,41],    [14,41,40],    [15,16,42],    [15,42,41],    [16,17,43],
      [16,43,42],    [17,18,44],    [17,44,43],    [18,1,27],     [18,27,44],    [19,20,46],    [19,46,45],
      [20,21,47],    [20,47,46],    [21,22,48],    [21,48,47],    [22,19,45],    [22,45,48],    [23,24,50],
      [23,50,49],    [24,25,51],    [24,51,50],    [25,26,52],    [25,52,51],    [26,23,49],    [26,49,52],
      [51,28,29],    [28,51,52],    [47,52,49],    [52,47,48],    [28,52,48],    [28,48,45],    [51,29,30],
      [50,51,30],    [50,30,31],    [49,50,31],    [47,49,31],    [46,47,31],    [40,41,42],    [39,40,42],
      [37,38,39],    [37,39,42],    [36,37,42],    [35,36,42],    [34,35,42],    [34,42,43],    [32,33,34],
      [31,32,34],    [43,44,27],    [34,43,27],    [34,27,28],    [31,34,28],    [31,28,45],    [31,45,46])


      -- Material ID data (108) ---------------------------
      fm = #(      LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,
      LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,
      LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,
      LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,          10,           10,         10,
            10,          10,          10,          10,          10,          10,          10,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,
      LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,
      LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,
      LMSmatID,    LMSmatID,          10,          10,          10,          10,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,
      LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID,    LMSmatID)
      -- Edge visibility data (108) ---------------------------
      fe = #(#(true, false, false),#(true, false, false),   #(true, false, false),   #(true, false, false),
      #(false, false, false),      #(true, false, false),   #(true, false, false),   #(false, true, false),
      #(true, false, false),       #(false, true, false),   #(false, false, false),  #(false, true, false),
      #(true, true, false),        #(false, true, false),   #(true, true, false),    #(false, false, false),
      #(false, true, false),       #(false, true, false),   #(false, true, false),   #(true, false, false),
      #(true, true, false),        #(false, true, false),   #(true, true, false),    #(false, false, false),
      #(true, false, false),       #(false, false, false)  ,#(false, false, false),  #(true, false, false),
      #(true, true, false),        #(false, true, true),    #(true, true, false),    #(false, true, true),
      #(true, true, false),        #(false, true, true),    #(true, true, false),    #(false, true, true),
      #(true, true, false),        #(false, true, true),    #(true, true, false),    #(false, true, true),
      #(true, true, false),        #(false, true, true),    #(true, true, false),    #(false, true, true),
      #(true, true, false),        #(false, true, true),    #(true, true, false),    #(false, true, true),
      #(true, true, false),        #(false, true, true),    #(true, true, false),    #(false, true, true),
      #(true, true, false),        #(false, true, true),    #(true, true, false),    #(false, true, true),
      #(true, true, false),        #(false, true, true),    #(true, true, false),    #(false, true, true),
      #(true, true, false),        #(false, true, true),    #(true, true, false),    #(false, true, true),
      #(true, true, false),        #(false, true, true),    #(true, true, false),    #(false, true, true),
      #(true, true, false),        #(false, true, true),    #(true, true, false),    #(false, true, true),
      #(true, true, false),        #(false, true, true),    #(true, true, false),    #(false, true, true),
      #(true, true, false),        #(false, true, true),    #(true, true, false),    #(false, true, true),
      #(false, true, false),       #(false, true, false),   #(false, true, false),   #(false, true, false),
      #(false, false, false),      #(false, true, false),   #(false, true, false),   #(true, false, false),
      #(false, true, false),       #(true, false, false),   #(false, false, false),  #(true, false, false),
      #(true, true, false),        #(true, false, false),   #(true, true, false),    #(false, false, false),
      #(true, false, false),       #(true, false, false),   #(true, false, false),   #(false, true, false),
      #(true, true, false),        #(true, false, false),   #(true, true, false),    #(false, false, false),
      #(false, true, false),       #(false, false, false),  #(false, false, false),  #(false, true, false))

      setMesh mesh vertices:vp faces:fl materialIDs:fm -- Create mesh for buildMesh
      for i = 1 to 108 do (for j = 1 to 3 do (setEdgeVis mesh i j fe[i][j])) -- Apply additional face data
      for i = 1 to 108 do (SetFaceSmoothGroup mesh i 0) -- Apply additional face data

      /*
      --- from larry minton on 18/01/2010
      The problem is that texture faces are created when lStyle == false,
      but the setMesh code isn�t clearing out those texture faces when lStyle == true,
      leaving things in an inconsistent state. Or something along those lines.
      Adding one of the following lines in the lStyle == true case gets around the problem:
      */
      --buildTVFaces mesh false --build texture faces
      meshop.setnumtverts mesh 0 -- clear texture faces
    )
	)

  tool create prompt:~PLUGIN_CIVILGANTRYNL_PROMPT~
  (
    on mousePoint click do
    (
      case click of
      (
        1: nodeTM.translation = gridPoint
        2: #stop
      )
    )
  )
)
--
-- � Copyright 2011 Autodesk, Inc. All rights reserved.
--

plugin simpleObject Vsp_GantryNZ name:~PLUGIN_CIVILGANTRYNZ_NAME~ category:~PLUGIN_CIVILGANTRYNZ_CATEGORY~ classID:#(1113565214, 1818545546) invisible:(not DYNcreatable)
(
  parameters main rollout:ROLLOUTparams
  (
    length          type:#worldunits animatable:true default:23.0
    height          type:#worldunits animatable:true default:7.0
    radius          type:#worldunits animatable:true default:3.0
    dia             type:#worldunits animatable:true default:0.45
    xfall           type:#float      animatable:true default:0
    matID           type:#integer    animatable:true default:2
    lStyle          type:#boolean    animatable:true default:false

    /* The following params are unique to the NL sign gantry and are included here as
       dummy params to ensure compatability between baseObject types in GantryParams panel */
    signals         type:#boolean    animatable:true default:false
    numberOfSignals type:#integer    animatable:true default:1
    SignalGap       type:#worldunits animatable:true default:3.6
    flipSignals     type:#boolean    animatable:true default:false
    SignalOffset    type:#worldunits animatable:true default:3
  )

  rollout ROLLOUTparams ~PLUGIN_CIVILGANTRYNZ_ROLLOUT~
  (
    group ~PLUGIN_CIVILGANTRYNZ_GROUP~
    (
      label LBtext01 ~PLUGIN_CIVILGANTRYNZ_TEXT01~ align:#center
      label LBtext02 ~PLUGIN_CIVILGANTRYNZ_TEXT02~ align:#center
    )
  )

  on create do
  (
    --- Set Default Values                                                                 ---
    --- When a new gantry is created, convert the defaults in Pmblock which use WorldUnits ---
    --- to equivilents in feet                                                             ---
    local LOCunitMult = 1.0
    case units.SystemType of
    (
      #Inches      : LOCunitMult = 39.3700787
      #Feet        : LOCunitMult = 3.2808399
      #Miles       : LOCunitMult = 0.000621371192
      #Millimeters : LOCunitMult = 1000.0
      #Centimeters : LOCunitMult = 100.0
      #Meters      : LOCunitMult = 1.0
      #Kilometers  : LOCunitMult = 0.001
    )
    length       = length       * LOCunitMult
    height       = height       * LOCunitMult
    Radius       = Radius       * LOCunitMult
    Dia          = Dia          * LOCunitMult
    SignalGap    = SignalGap    * LOCunitMult
    SignalOffset = SignalOffset * LOCunitMult
  )

  on buildMesh do
  (
    local LOCunitMult = 1.0
    case units.SystemType of
    (
      #Inches      : LOCunitMult = 39.3700787
      #Feet        : LOCunitMult = 3.2808399
      #Miles       : LOCunitMult = 0.000621371192
      #Millimeters : LOCunitMult = 1000.0
      #Centimeters : LOCunitMult = 100.0
      #Meters      : LOCunitMult = 1.0
      #Kilometers  : LOCunitMult = 0.001
    )

    local LMSlength  = length
    local LMSheight  = height
    local LMSRadius  = Radius
    local LMSDia     = Dia
    local LMSxfall   = xfall
    local LMSmatID   = matID
    local LMSlStyle  = lStyle

    vp = #()
    fl = #()
    fm = #()
    fs = #()
    fe = #()
    -- Vertex data ---------------------------
    local rad = LMSdia / 2.0
    local hpos
    local vpos

    --- First Post
    local vsetcnt = 0
    append vp [rad * -1.000 ,rad *  0.000 ,(LOCunitMult*0.040)]
    append vp [rad * -0.863 ,rad * -0.504 ,(LOCunitMult*0.040)]
    append vp [rad * -0.504 ,rad * -0.863 ,(LOCunitMult*0.040)]
    append vp [rad *  0.000 ,rad * -1.000 ,(LOCunitMult*0.040)]
    append vp [rad *  0.504 ,rad * -0.863 ,(LOCunitMult*0.040)]
    append vp [rad *  0.863 ,rad * -0.504 ,(LOCunitMult*0.040)]
    append vp [rad *  1.000 ,rad *  0.000 ,(LOCunitMult*0.040)]
    append vp [rad *  0.863 ,rad *  0.504 ,(LOCunitMult*0.040)]
    append vp [rad *  0.504 ,rad *  0.863 ,(LOCunitMult*0.040)]
    append vp [rad *  0.000 ,rad *  1.000 ,(LOCunitMult*0.040)]
    append vp [rad * -0.504 ,rad *  0.863 ,(LOCunitMult*0.040)]
    append vp [rad * -0.863 ,rad *  0.504 ,(LOCunitMult*0.040)]

    vsetcnt +=1
    append vp [rad * -1.000 ,rad *  0.000 ,LMSheight-LMSradius]
    append vp [rad * -0.863 ,rad * -0.504 ,LMSheight-LMSradius]
    append vp [rad * -0.504 ,rad * -0.863 ,LMSheight-LMSradius]
    append vp [rad *  0.000 ,rad * -1.000 ,LMSheight-LMSradius]
    append vp [rad *  0.504 ,rad * -0.863 ,LMSheight-LMSradius]
    append vp [rad *  0.863 ,rad * -0.504 ,LMSheight-LMSradius]
    append vp [rad *  1.000 ,rad *  0.000 ,LMSheight-LMSradius]
    append vp [rad *  0.863 ,rad *  0.504 ,LMSheight-LMSradius]
    append vp [rad *  0.504 ,rad *  0.863 ,LMSheight-LMSradius]
    append vp [rad *  0.000 ,rad *  1.000 ,LMSheight-LMSradius]
    append vp [rad * -0.504 ,rad *  0.863 ,LMSheight-LMSradius]
    append vp [rad * -0.863 ,rad *  0.504 ,LMSheight-LMSradius]
    --- Left LMSradius
    hpos = LMSradius - (LMSradius * (cos 10)) -- 0.046
    vpos = LMSradius - (LMSradius * (sin 10)) -- 2.478
    vsetcnt +=1
    append vp [(-0.988*rad)+hpos,rad *  0.000 ,LMSheight-((-0.174*rad)+vpos)]
    append vp [(-0.853*rad)+hpos,rad * -0.504 ,LMSheight-((-0.150*rad)+vpos)]
    append vp [(-0.498*rad)+hpos,rad * -0.863 ,LMSheight-((-0.088*rad)+vpos)]
    append vp [( 0.000*rad)+hpos,rad * -1.000 ,LMSheight-(( 0.000*rad)+vpos)]
    append vp [( 0.498*rad)+hpos,rad * -0.863 ,LMSheight-(( 0.088*rad)+vpos)]
    append vp [( 0.853*rad)+hpos,rad * -0.504 ,LMSheight-(( 0.150*rad)+vpos)]
    append vp [( 0.988*rad)+hpos,rad *  0.000 ,LMSheight-(( 0.174*rad)+vpos)]
    append vp [( 0.853*rad)+hpos,rad *  0.504 ,LMSheight-(( 0.150*rad)+vpos)]
    append vp [( 0.498*rad)+hpos,rad *  0.863 ,LMSheight-(( 0.088*rad)+vpos)]
    append vp [( 0.000*rad)+hpos,rad *  1.000 ,LMSheight-(( 0.000*rad)+vpos)]
    append vp [(-0.498*rad)+hpos,rad *  0.863 ,LMSheight-((-0.088*rad)+vpos)]
    append vp [(-0.853*rad)+hpos,rad *  0.504 ,LMSheight-((-0.150*rad)+vpos)]

    hpos = LMSradius - (LMSradius * (cos 20)) -- 0.181
    vpos = LMSradius - (LMSradius * (sin 20)) -- 1.975
    vsetcnt +=1
    append vp [(-0.944*rad)+hpos,rad *  0.000,LMSheight-((-0.343*rad)+vpos)]
    append vp [(-0.815*rad)+hpos,rad * -0.504,LMSheight-((-0.296*rad)+vpos)]
    append vp [(-0.476*rad)+hpos,rad * -0.863,LMSheight-((-0.173*rad)+vpos)]
    append vp [( 0.000*rad)+hpos,rad * -1.000,LMSheight-(( 0.000*rad)+vpos)]
    append vp [( 0.476*rad)+hpos,rad * -0.863,LMSheight-(( 0.173*rad)+vpos)]
    append vp [( 0.815*rad)+hpos,rad * -0.504,LMSheight-(( 0.296*rad)+vpos)]
    append vp [( 0.943*rad)+hpos,rad *  0.000,LMSheight-(( 0.343*rad)+vpos)]
    append vp [( 0.815*rad)+hpos,rad *  0.504,LMSheight-(( 0.296*rad)+vpos)]
    append vp [( 0.476*rad)+hpos,rad *  0.863,LMSheight-(( 0.173*rad)+vpos)]
    append vp [( 0.000*rad)+hpos,rad *  1.000,LMSheight-(( 0.000*rad)+vpos)]
    append vp [(-0.476*rad)+hpos,rad *  0.863,LMSheight-((-0.173*rad)+vpos)]
    append vp [(-0.815*rad)+hpos,rad *  0.504,LMSheight-((-0.296*rad)+vpos)]

    hpos = LMSradius - (LMSradius * (cos 30)) -- 0.402
    vpos = LMSradius - (LMSradius * (sin 30)) -- 1.500
    vsetcnt +=1
    append vp [(-0.869*rad)+hpos,rad *  0.000,LMSheight-((-0.502*rad)+vpos)]
    append vp [(-0.751*rad)+hpos,rad * -0.504,LMSheight-((-0.433*rad)+vpos)]
    append vp [(-0.439*rad)+hpos,rad * -0.863,LMSheight-((-0.253*rad)+vpos)]
    append vp [( 0.000*rad)+hpos,rad * -1.000,LMSheight-(( 0.000*rad)+vpos)]
    append vp [( 0.439*rad)+hpos,rad * -0.863,LMSheight-(( 0.253*rad)+vpos)]
    append vp [( 0.750*rad)+hpos,rad * -0.504,LMSheight-(( 0.433*rad)+vpos)]
    append vp [( 0.869*rad)+hpos,rad *  0.000,LMSheight-(( 0.502*rad)+vpos)]
    append vp [( 0.750*rad)+hpos,rad *  0.504,LMSheight-(( 0.433*rad)+vpos)]
    append vp [( 0.439*rad)+hpos,rad *  0.863,LMSheight-(( 0.253*rad)+vpos)]
    append vp [( 0.000*rad)+hpos,rad *  1.000,LMSheight-(( 0.000*rad)+vpos)]
    append vp [(-0.439*rad)+hpos,rad *  0.863,LMSheight-((-0.253*rad)+vpos)]
    append vp [(-0.751*rad)+hpos,rad *  0.504,LMSheight-((-0.433*rad)+vpos)]

    hpos = LMSradius - (LMSradius * (cos 40)) -- 0.702
    vpos = LMSradius - (LMSradius * (sin 40)) -- 1.071
    vsetcnt +=1
    append vp [(-0.768*rad)+hpos,rad *  0.000,LMSheight-((-0.645*rad)+vpos)]
    append vp [(-0.663*rad)+hpos,rad * -0.504,LMSheight-((-0.557*rad)+vpos)]
    append vp [(-0.388*rad)+hpos,rad * -0.863,LMSheight-((-0.325*rad)+vpos)]
    append vp [( 0.000*rad)+hpos,rad * -1.000,LMSheight-(( 0.000*rad)+vpos)]
    append vp [( 0.388*rad)+hpos,rad * -0.863,LMSheight-(( 0.326*rad)+vpos)]
    append vp [( 0.664*rad)+hpos,rad * -0.504,LMSheight-(( 0.557*rad)+vpos)]
    append vp [( 0.769*rad)+hpos,rad *  0.000,LMSheight-(( 0.646*rad)+vpos)]
    append vp [( 0.664*rad)+hpos,rad *  0.504,LMSheight-(( 0.557*rad)+vpos)]
    append vp [( 0.388*rad)+hpos,rad *  0.863,LMSheight-(( 0.326*rad)+vpos)]
    append vp [( 0.000*rad)+hpos,rad *  1.000,LMSheight-(( 0.000*rad)+vpos)]
    append vp [(-0.388*rad)+hpos,rad *  0.863,LMSheight-((-0.325*rad)+vpos)]
    append vp [(-0.663*rad)+hpos,rad *  0.504,LMSheight-((-0.557*rad)+vpos)]

    hpos = LMSradius - (LMSradius * (cos 50)) -- 1.071
    vpos = LMSradius - (LMSradius * (sin 50)) -- 0.702
    vsetcnt +=1
    append vp [(-0.645*rad)+hpos,rad *  0.000,LMSheight-((-0.769*rad)+vpos)]
    append vp [(-0.557*rad)+hpos,rad * -0.504,LMSheight-((-0.663*rad)+vpos)]
    append vp [(-0.325*rad)+hpos,rad * -0.863,LMSheight-((-0.388*rad)+vpos)]
    append vp [( 0.000*rad)+hpos,rad * -1.000,LMSheight-(( 0.000*rad)+vpos)]
    append vp [( 0.326*rad)+hpos,rad * -0.863,LMSheight-(( 0.388*rad)+vpos)]
    append vp [( 0.557*rad)+hpos,rad * -0.504,LMSheight-(( 0.664*rad)+vpos)]
    append vp [( 0.646*rad)+hpos,rad *  0.000,LMSheight-(( 0.769*rad)+vpos)]
    append vp [( 0.557*rad)+hpos,rad *  0.504,LMSheight-(( 0.664*rad)+vpos)]
    append vp [( 0.326*rad)+hpos,rad *  0.863,LMSheight-(( 0.388*rad)+vpos)]
    append vp [( 0.000*rad)+hpos,rad *  1.000,LMSheight-(( 0.000*rad)+vpos)]
    append vp [(-0.325*rad)+hpos,rad *  0.863,LMSheight-((-0.388*rad)+vpos)]
    append vp [(-0.557*rad)+hpos,rad *  0.504,LMSheight-((-0.663*rad)+vpos)]

    hpos = LMSradius - (LMSradius * (cos 60)) -- 1.500
    vpos = LMSradius - (LMSradius * (sin 60)) -- 0.402
    vsetcnt +=1
    append vp [(-0.502*rad)+hpos,rad *  0.000,LMSheight-((-0.869*rad)+vpos)]
    append vp [(-0.433*rad)+hpos,rad * -0.504,LMSheight-((-0.750*rad)+vpos)]
    append vp [(-0.253*rad)+hpos,rad * -0.863,LMSheight-((-0.439*rad)+vpos)]
    append vp [( 0.000*rad)+hpos,rad * -1.000,LMSheight-(( 0.000*rad)+vpos)]
    append vp [( 0.253*rad)+hpos,rad * -0.863,LMSheight-(( 0.439*rad)+vpos)]
    append vp [( 0.433*rad)+hpos,rad * -0.504,LMSheight-(( 0.750*rad)+vpos)]
    append vp [( 0.502*rad)+hpos,rad *  0.000,LMSheight-(( 0.869*rad)+vpos)]
    append vp [( 0.433*rad)+hpos,rad *  0.504,LMSheight-(( 0.750*rad)+vpos)]
    append vp [( 0.253*rad)+hpos,rad *  0.863,LMSheight-(( 0.439*rad)+vpos)]
    append vp [( 0.000*rad)+hpos,rad *  1.000,LMSheight-(( 0.000*rad)+vpos)]
    append vp [(-0.253*rad)+hpos,rad *  0.863,LMSheight-((-0.439*rad)+vpos)]
    append vp [(-0.433*rad)+hpos,rad *  0.504,LMSheight-((-0.750*rad)+vpos)]

    hpos = LMSradius - (LMSradius * (cos 70)) -- 1.975
    vpos = LMSradius - (LMSradius * (sin 70)) -- 0.181
    vsetcnt +=1
    append vp [(-0.344*rad)+hpos,rad *  0.000,LMSheight-((-0.943*rad)+vpos)]
    append vp [(-0.297*rad)+hpos,rad * -0.504,LMSheight-((-0.814*rad)+vpos)]
    append vp [(-0.174*rad)+hpos,rad * -0.863,LMSheight-((-0.476*rad)+vpos)]
    append vp [( 0.000*rad)+hpos,rad * -1.000,LMSheight-(( 0.000*rad)+vpos)]
    append vp [( 0.173*rad)+hpos,rad * -0.863,LMSheight-(( 0.476*rad)+vpos)]
    append vp [( 0.296*rad)+hpos,rad * -0.504,LMSheight-(( 0.814*rad)+vpos)]
    append vp [( 0.343*rad)+hpos,rad *  0.000,LMSheight-(( 0.943*rad)+vpos)]
    append vp [( 0.296*rad)+hpos,rad *  0.504,LMSheight-(( 0.814*rad)+vpos)]
    append vp [( 0.173*rad)+hpos,rad *  0.863,LMSheight-(( 0.476*rad)+vpos)]
    append vp [( 0.000*rad)+hpos,rad *  1.000,LMSheight-(( 0.000*rad)+vpos)]
    append vp [(-0.174*rad)+hpos,rad *  0.863,LMSheight-((-0.476*rad)+vpos)]
    append vp [(-0.297*rad)+hpos,rad *  0.504,LMSheight-((-0.814*rad)+vpos)]

    hpos = LMSradius - (LMSradius * (cos 80)) -- 2.478
    vpos = LMSradius - (LMSradius * (sin 80)) -- 0.046
    vsetcnt +=1
    append vp [(-0.174*rad)+hpos,rad *  0.000,LMSheight-((-0.988*rad)+vpos)]
    append vp [(-0.150*rad)+hpos,rad * -0.504,LMSheight-((-0.853*rad)+vpos)]
    append vp [(-0.088*rad)+hpos,rad * -0.863,LMSheight-((-0.498*rad)+vpos)]
    append vp [( 0.000*rad)+hpos,rad * -1.000,LMSheight-(( 0.000*rad)+vpos)]
    append vp [( 0.088*rad)+hpos,rad * -0.863,LMSheight-(( 0.498*rad)+vpos)]
    append vp [( 0.151*rad)+hpos,rad * -0.504,LMSheight-(( 0.853*rad)+vpos)]
    append vp [( 0.175*rad)+hpos,rad *  0.000,LMSheight-(( 0.988*rad)+vpos)]
    append vp [( 0.151*rad)+hpos,rad *  0.504,LMSheight-(( 0.853*rad)+vpos)]
    append vp [( 0.088*rad)+hpos,rad *  0.863,LMSheight-(( 0.498*rad)+vpos)]
    append vp [( 0.000*rad)+hpos,rad *  1.000,LMSheight-(( 0.000*rad)+vpos)]
    append vp [(-0.088*rad)+hpos,rad *  0.863,LMSheight-((-0.498*rad)+vpos)]
    append vp [(-0.150*rad)+hpos,rad *  0.504,LMSheight-((-0.853*rad)+vpos)]

    --- TOP BAR
    vsetcnt +=1
    append vp [LMSradius,rad *  0.000 ,LMSheight+(rad*1.000)]
    append vp [LMSradius,rad * -0.504 ,LMSheight+(rad*0.863)]
    append vp [LMSradius,rad * -0.863 ,LMSheight+(rad*0.504)]
    append vp [LMSradius,rad * -1.000 ,LMSheight+(rad*0.000)]
    append vp [LMSradius,rad * -0.863 ,LMSheight-(rad*0.504)]
    append vp [LMSradius,rad * -0.504 ,LMSheight-(rad*0.863)]
    append vp [LMSradius,rad *  0.000 ,LMSheight-(rad*1.000)]
    append vp [LMSradius,rad *  0.504 ,LMSheight-(rad*0.863)]
    append vp [LMSradius,rad *  0.863 ,LMSheight-(rad*0.504)]
    append vp [LMSradius,rad *  1.000 ,LMSheight+(rad*0.000)]
    append vp [LMSradius,rad *  0.863 ,LMSheight+(rad*0.504)]
    append vp [LMSradius,rad *  0.504 ,LMSheight+(rad*0.863)]

    if LMSlStyle then
    (
      vsetcnt +=1
      append vp [LMSlength,rad * 0.000 ,LMSheight+(rad*1.000)]
      append vp [LMSlength,rad * -0.504,LMSheight+(rad*0.863)]
      append vp [LMSlength,rad * -0.863,LMSheight+(rad*0.504)]
      append vp [LMSlength,rad * -1.000,LMSheight+(rad*0.000)]
      append vp [LMSlength,rad * -0.863,LMSheight-(rad*0.504)]
      append vp [LMSlength,rad * -0.504,LMSheight-(rad*0.863)]
      append vp [LMSlength,rad * 0.000 ,LMSheight-(rad*1.000)]
      append vp [LMSlength,rad * 0.504 ,LMSheight-(rad*0.863)]
      append vp [LMSlength,rad * 0.863 ,LMSheight-(rad*0.504)]
      append vp [LMSlength,rad * 1.000 ,LMSheight+(rad*0.000)]
      append vp [LMSlength,rad * 0.863 ,LMSheight+(rad*0.504)]
      append vp [LMSlength,rad * 0.504 ,LMSheight+(rad*0.863)]

      --- Right Top Ring (32 Vertices)
      append vp [LMSlength-0.025,(rad/2.0)*1.5* 0.000,LMSheight-((rad/2.0)*1.5*2.000)]
      append vp [LMSlength-0.025,(rad/2.0)*1.5* 0.778,LMSheight-((rad/2.0)*1.5*1.843)]
      append vp [LMSlength-0.025,(rad/2.0)*1.5* 1.414,LMSheight-((rad/2.0)*1.5*1.414)]
      append vp [LMSlength-0.025,(rad/2.0)*1.5* 1.843,LMSheight-((rad/2.0)*1.5*0.778)]
      append vp [LMSlength-0.025,(rad/2.0)*1.5* 2.000,LMSheight+((rad/2.0)*1.5*0.000)]
      append vp [LMSlength-0.025,(rad/2.0)*1.5* 1.843,LMSheight+((rad/2.0)*1.5*0.778)]
      append vp [LMSlength-0.025,(rad/2.0)*1.5* 1.414,LMSheight+((rad/2.0)*1.5*1.414)]
      append vp [LMSlength-0.025,(rad/2.0)*1.5* 0.778,LMSheight+((rad/2.0)*1.5*1.843)]
      append vp [LMSlength-0.025,(rad/2.0)*1.5* 0.000,LMSheight+((rad/2.0)*1.5*2.000)]
      append vp [LMSlength-0.025,(rad/2.0)*1.5*-0.778,LMSheight+((rad/2.0)*1.5*1.843)]
      append vp [LMSlength-0.025,(rad/2.0)*1.5*-1.414,LMSheight+((rad/2.0)*1.5*1.414)]
      append vp [LMSlength-0.025,(rad/2.0)*1.5*-1.843,LMSheight+((rad/2.0)*1.5*0.778)]
      append vp [LMSlength-0.025,(rad/2.0)*1.5*-2.000,LMSheight+((rad/2.0)*1.5*0.000)]
      append vp [LMSlength-0.025,(rad/2.0)*1.5*-1.843,LMSheight-((rad/2.0)*1.5*0.778)]
      append vp [LMSlength-0.025,(rad/2.0)*1.5*-1.414,LMSheight-((rad/2.0)*1.5*1.414)]
      append vp [LMSlength-0.025,(rad/2.0)*1.5*-0.778,LMSheight-((rad/2.0)*1.5*1.843)]
      append vp [LMSlength+0.025,(rad/2.0)*1.5* 0.000,LMSheight-((rad/2.0)*1.5*2.000)]
      append vp [LMSlength+0.025,(rad/2.0)*1.5* 0.778,LMSheight-((rad/2.0)*1.5*1.843)]
      append vp [LMSlength+0.025,(rad/2.0)*1.5* 1.414,LMSheight-((rad/2.0)*1.5*1.414)]
      append vp [LMSlength+0.025,(rad/2.0)*1.5* 1.843,LMSheight-((rad/2.0)*1.5*0.778)]
      append vp [LMSlength+0.025,(rad/2.0)*1.5* 2.000,LMSheight+((rad/2.0)*1.5*0.000)]
      append vp [LMSlength+0.025,(rad/2.0)*1.5* 1.843,LMSheight+((rad/2.0)*1.5*0.778)]
      append vp [LMSlength+0.025,(rad/2.0)*1.5* 1.414,LMSheight+((rad/2.0)*1.5*1.414)]
      append vp [LMSlength+0.025,(rad/2.0)*1.5* 0.778,LMSheight+((rad/2.0)*1.5*1.843)]
      append vp [LMSlength+0.025,(rad/2.0)*1.5* 0.000,LMSheight+((rad/2.0)*1.5*2.000)]
      append vp [LMSlength+0.025,(rad/2.0)*1.5*-0.778,LMSheight+((rad/2.0)*1.5*1.843)]
      append vp [LMSlength+0.025,(rad/2.0)*1.5*-1.414,LMSheight+((rad/2.0)*1.5*1.414)]
      append vp [LMSlength+0.025,(rad/2.0)*1.5*-1.843,LMSheight+((rad/2.0)*1.5*0.778)]
      append vp [LMSlength+0.025,(rad/2.0)*1.5*-2.000,LMSheight+((rad/2.0)*1.5*0.000)]
      append vp [LMSlength+0.025,(rad/2.0)*1.5*-1.843,LMSheight-((rad/2.0)*1.5*0.778)]
      append vp [LMSlength+0.025,(rad/2.0)*1.5*-1.414,LMSheight-((rad/2.0)*1.5*1.414)]
      append vp [LMSlength+0.025,(rad/2.0)*1.5*-0.778,LMSheight-((rad/2.0)*1.5*1.843)]
    )
    else
    (
      vsetcnt +=1
      append vp [LMSlength-LMSradius,rad * 0.000 ,LMSheight+(rad*1.000)]
      append vp [LMSlength-LMSradius,rad * -0.504,LMSheight+(rad*0.863)]
      append vp [LMSlength-LMSradius,rad * -0.863,LMSheight+(rad*0.504)]
      append vp [LMSlength-LMSradius,rad * -1.000,LMSheight+(rad*0.000)]
      append vp [LMSlength-LMSradius,rad * -0.863,LMSheight-(rad*0.504)]
      append vp [LMSlength-LMSradius,rad * -0.504,LMSheight-(rad*0.863)]
      append vp [LMSlength-LMSradius,rad * 0.000 ,LMSheight-(rad*1.000)]
      append vp [LMSlength-LMSradius,rad * 0.504 ,LMSheight-(rad*0.863)]
      append vp [LMSlength-LMSradius,rad * 0.863 ,LMSheight-(rad*0.504)]
      append vp [LMSlength-LMSradius,rad * 1.000 ,LMSheight+(rad*0.000)]
      append vp [LMSlength-LMSradius,rad * 0.863 ,LMSheight+(rad*0.504)]
      append vp [LMSlength-LMSradius,rad * 0.504 ,LMSheight+(rad*0.863)]

      --- Right LMSradius
      hpos = LMSradius - (LMSradius * (cos 80)) -- 12.478
      vpos = LMSradius - (LMSradius * (sin 80)) -- 00.046
      vsetcnt +=1
      append vp [LMSlength-((-0.174*rad)+hpos),rad *  0.000,LMSheight-((-0.988*rad)+vpos)]
      append vp [LMSlength-((-0.150*rad)+hpos),rad * -0.504,LMSheight-((-0.853*rad)+vpos)]
      append vp [LMSlength-((-0.088*rad)+hpos),rad * -0.863,LMSheight-((-0.498*rad)+vpos)]
      append vp [LMSlength-(( 0.000*rad)+hpos),rad * -1.000,LMSheight-(( 0.000*rad)+vpos)]
      append vp [LMSlength-(( 0.088*rad)+hpos),rad * -0.863,LMSheight-(( 0.498*rad)+vpos)]
      append vp [LMSlength-(( 0.151*rad)+hpos),rad * -0.504,LMSheight-(( 0.853*rad)+vpos)]
      append vp [LMSlength-(( 0.175*rad)+hpos),rad *  0.000,LMSheight-(( 0.988*rad)+vpos)]
      append vp [LMSlength-(( 0.151*rad)+hpos),rad *  0.504,LMSheight-(( 0.853*rad)+vpos)]
      append vp [LMSlength-(( 0.088*rad)+hpos),rad *  0.863,LMSheight-(( 0.498*rad)+vpos)]
      append vp [LMSlength-(( 0.000*rad)+hpos),rad *  1.000,LMSheight-(( 0.000*rad)+vpos)]
      append vp [LMSlength-((-0.088*rad)+hpos),rad *  0.863,LMSheight-((-0.498*rad)+vpos)]
      append vp [LMSlength-((-0.150*rad)+hpos),rad *  0.504,LMSheight-((-0.853*rad)+vpos)]

      hpos = LMSradius - (LMSradius * (cos 70)) -- 11.975
      vpos = LMSradius - (LMSradius * (sin 70)) -- 00.181
      vsetcnt +=1
      append vp [LMSlength-((-0.344*rad)+hpos),rad *  0.000,LMSheight-((-0.943*rad)+vpos)]
      append vp [LMSlength-((-0.297*rad)+hpos),rad * -0.504,LMSheight-((-0.814*rad)+vpos)]
      append vp [LMSlength-((-0.174*rad)+hpos),rad * -0.863,LMSheight-((-0.476*rad)+vpos)]
      append vp [LMSlength-(( 0.000*rad)+hpos),rad * -1.000,LMSheight-(( 0.000*rad)+vpos)]
      append vp [LMSlength-(( 0.173*rad)+hpos),rad * -0.863,LMSheight-(( 0.476*rad)+vpos)]
      append vp [LMSlength-(( 0.296*rad)+hpos),rad * -0.504,LMSheight-(( 0.814*rad)+vpos)]
      append vp [LMSlength-(( 0.343*rad)+hpos),rad *  0.000,LMSheight-(( 0.943*rad)+vpos)]
      append vp [LMSlength-(( 0.296*rad)+hpos),rad *  0.504,LMSheight-(( 0.814*rad)+vpos)]
      append vp [LMSlength-(( 0.173*rad)+hpos),rad *  0.863,LMSheight-(( 0.476*rad)+vpos)]
      append vp [LMSlength-(( 0.000*rad)+hpos),rad *  1.000,LMSheight-(( 0.000*rad)+vpos)]
      append vp [LMSlength-((-0.174*rad)+hpos),rad *  0.863,LMSheight-((-0.476*rad)+vpos)]
      append vp [LMSlength-((-0.297*rad)+hpos),rad *  0.504,LMSheight-((-0.814*rad)+vpos)]

      hpos = LMSradius - (LMSradius * (cos 60)) -- 11.500
      vpos = LMSradius - (LMSradius * (sin 60)) -- 00.402
      vsetcnt +=1
      append vp [LMSlength-((-0.502*rad)+hpos),rad *  0.000,LMSheight-((-0.869*rad)+vpos)]
      append vp [LMSlength-((-0.433*rad)+hpos),rad * -0.504,LMSheight-((-0.750*rad)+vpos)]
      append vp [LMSlength-((-0.253*rad)+hpos),rad * -0.863,LMSheight-((-0.439*rad)+vpos)]
      append vp [LMSlength-(( 0.000*rad)+hpos),rad * -1.000,LMSheight-(( 0.000*rad)+vpos)]
      append vp [LMSlength-(( 0.253*rad)+hpos),rad * -0.863,LMSheight-(( 0.439*rad)+vpos)]
      append vp [LMSlength-(( 0.433*rad)+hpos),rad * -0.504,LMSheight-(( 0.750*rad)+vpos)]
      append vp [LMSlength-(( 0.502*rad)+hpos),rad *  0.000,LMSheight-(( 0.869*rad)+vpos)]
      append vp [LMSlength-(( 0.433*rad)+hpos),rad *  0.504,LMSheight-(( 0.750*rad)+vpos)]
      append vp [LMSlength-(( 0.253*rad)+hpos),rad *  0.863,LMSheight-(( 0.439*rad)+vpos)]
      append vp [LMSlength-(( 0.000*rad)+hpos),rad *  1.000,LMSheight-(( 0.000*rad)+vpos)]
      append vp [LMSlength-((-0.253*rad)+hpos),rad *  0.863,LMSheight-((-0.439*rad)+vpos)]
      append vp [LMSlength-((-0.433*rad)+hpos),rad *  0.504,LMSheight-((-0.750*rad)+vpos)]

      hpos = LMSradius - (LMSradius * (cos 50)) -- 11.071
      vpos = LMSradius - (LMSradius * (sin 50)) -- 00.702
      vsetcnt +=1
      append vp [LMSlength-((-0.645*rad)+hpos),rad *  0.000,LMSheight-((-0.769*rad)+vpos)]
      append vp [LMSlength-((-0.557*rad)+hpos),rad * -0.504,LMSheight-((-0.663*rad)+vpos)]
      append vp [LMSlength-((-0.325*rad)+hpos),rad * -0.863,LMSheight-((-0.388*rad)+vpos)]
      append vp [LMSlength-(( 0.000*rad)+hpos),rad * -1.000,LMSheight-(( 0.000*rad)+vpos)]
      append vp [LMSlength-(( 0.326*rad)+hpos),rad * -0.863,LMSheight-(( 0.388*rad)+vpos)]
      append vp [LMSlength-(( 0.557*rad)+hpos),rad * -0.504,LMSheight-(( 0.664*rad)+vpos)]
      append vp [LMSlength-(( 0.646*rad)+hpos),rad *  0.000,LMSheight-(( 0.769*rad)+vpos)]
      append vp [LMSlength-(( 0.557*rad)+hpos),rad *  0.504,LMSheight-(( 0.664*rad)+vpos)]
      append vp [LMSlength-(( 0.326*rad)+hpos),rad *  0.863,LMSheight-(( 0.388*rad)+vpos)]
      append vp [LMSlength-(( 0.000*rad)+hpos),rad *  1.000,LMSheight-(( 0.000*rad)+vpos)]
      append vp [LMSlength-((-0.325*rad)+hpos),rad *  0.863,LMSheight-((-0.388*rad)+vpos)]
      append vp [LMSlength-((-0.557*rad)+hpos),rad *  0.504,LMSheight-((-0.663*rad)+vpos)]

      hpos = LMSradius - (LMSradius * (cos 40)) -- 10.702
      vpos = LMSradius - (LMSradius * (sin 40)) -- 01.071
      vsetcnt +=1
      append vp [LMSlength-((-0.769*rad)+hpos),rad *  0.000,LMSheight-((-0.645*rad)+vpos)]
      append vp [LMSlength-((-0.664*rad)+hpos),rad * -0.504,LMSheight-((-0.557*rad)+vpos)]
      append vp [LMSlength-((-0.388*rad)+hpos),rad * -0.863,LMSheight-((-0.325*rad)+vpos)]
      append vp [LMSlength-(( 0.000*rad)+hpos),rad * -1.000,LMSheight-(( 0.000*rad)+vpos)]
      append vp [LMSlength-(( 0.388*rad)+hpos),rad * -0.863,LMSheight-(( 0.326*rad)+vpos)]
      append vp [LMSlength-(( 0.664*rad)+hpos),rad * -0.504,LMSheight-(( 0.557*rad)+vpos)]
      append vp [LMSlength-(( 0.769*rad)+hpos),rad *  0.000,LMSheight-(( 0.646*rad)+vpos)]
      append vp [LMSlength-(( 0.664*rad)+hpos),rad *  0.504,LMSheight-(( 0.557*rad)+vpos)]
      append vp [LMSlength-(( 0.388*rad)+hpos),rad *  0.863,LMSheight-(( 0.326*rad)+vpos)]
      append vp [LMSlength-(( 0.000*rad)+hpos),rad *  1.000,LMSheight-(( 0.000*rad)+vpos)]
      append vp [LMSlength-((-0.388*rad)+hpos),rad *  0.863,LMSheight-((-0.325*rad)+vpos)]
      append vp [LMSlength-((-0.664*rad)+hpos),rad *  0.504,LMSheight-((-0.557*rad)+vpos)]

      hpos = LMSradius - (LMSradius * (cos 30)) -- 10.402
      vpos = LMSradius - (LMSradius * (sin 30)) -- 01.500
      vsetcnt +=1
      append vp [LMSlength-((-0.869*rad)+hpos),rad *  0.000,LMSheight-((-0.502*rad)+vpos)]
      append vp [LMSlength-((-0.751*rad)+hpos),rad * -0.504,LMSheight-((-0.433*rad)+vpos)]
      append vp [LMSlength-((-0.439*rad)+hpos),rad * -0.863,LMSheight-((-0.253*rad)+vpos)]
      append vp [LMSlength-(( 0.000*rad)+hpos),rad * -1.000,LMSheight-(( 0.000*rad)+vpos)]
      append vp [LMSlength-(( 0.439*rad)+hpos),rad * -0.863,LMSheight-(( 0.253*rad)+vpos)]
      append vp [LMSlength-(( 0.751*rad)+hpos),rad * -0.504,LMSheight-(( 0.433*rad)+vpos)]
      append vp [LMSlength-(( 0.869*rad)+hpos),rad *  0.000,LMSheight-(( 0.502*rad)+vpos)]
      append vp [LMSlength-(( 0.751*rad)+hpos),rad *  0.504,LMSheight-(( 0.433*rad)+vpos)]
      append vp [LMSlength-(( 0.439*rad)+hpos),rad *  0.863,LMSheight-(( 0.253*rad)+vpos)]
      append vp [LMSlength-(( 0.000*rad)+hpos),rad *  1.000,LMSheight-(( 0.000*rad)+vpos)]
      append vp [LMSlength-((-0.439*rad)+hpos),rad *  0.863,LMSheight-((-0.253*rad)+vpos)]
      append vp [LMSlength-((-0.751*rad)+hpos),rad *  0.504,LMSheight-((-0.433*rad)+vpos)]

      hpos = LMSradius - (LMSradius * (cos 20)) -- 10.181
      vpos = LMSradius - (LMSradius * (sin 20)) -- 01.975
      vsetcnt +=1
      append vp [LMSlength-((-0.943*rad)+hpos),rad *  0.000,LMSheight-((-0.344*rad)+vpos)]
      append vp [LMSlength-((-0.814*rad)+hpos),rad * -0.504,LMSheight-((-0.297*rad)+vpos)]
      append vp [LMSlength-((-0.476*rad)+hpos),rad * -0.863,LMSheight-((-0.174*rad)+vpos)]
      append vp [LMSlength-(( 0.000*rad)+hpos),rad * -1.000,LMSheight-(( 0.000*rad)+vpos)]
      append vp [LMSlength-(( 0.476*rad)+hpos),rad * -0.863,LMSheight-(( 0.173*rad)+vpos)]
      append vp [LMSlength-(( 0.814*rad)+hpos),rad * -0.504,LMSheight-(( 0.296*rad)+vpos)]
      append vp [LMSlength-(( 0.943*rad)+hpos),rad *  0.000,LMSheight-(( 0.343*rad)+vpos)]
      append vp [LMSlength-(( 0.814*rad)+hpos),rad *  0.504,LMSheight-(( 0.296*rad)+vpos)]
      append vp [LMSlength-(( 0.476*rad)+hpos),rad *  0.863,LMSheight-(( 0.173*rad)+vpos)]
      append vp [LMSlength-(( 0.000*rad)+hpos),rad *  1.000,LMSheight-(( 0.000*rad)+vpos)]
      append vp [LMSlength-((-0.476*rad)+hpos),rad *  0.863,LMSheight-((-0.174*rad)+vpos)]
      append vp [LMSlength-((-0.814*rad)+hpos),rad *  0.504,LMSheight-((-0.297*rad)+vpos)]

      hpos = LMSradius - (LMSradius * (cos 10)) -- 10.046
      vpos = LMSradius - (LMSradius * (sin 10)) -- 02.478
      vsetcnt +=1
      append vp [LMSlength-((-0.988*rad)+hpos),rad *  0.000,LMSheight-((-0.174*rad)+vpos)]
      append vp [LMSlength-((-0.853*rad)+hpos),rad * -0.504,LMSheight-((-0.150*rad)+vpos)]
      append vp [LMSlength-((-0.498*rad)+hpos),rad * -0.863,LMSheight-((-0.088*rad)+vpos)]
      append vp [LMSlength-(( 0.000*rad)+hpos),rad * -1.000,LMSheight-(( 0.000*rad)+vpos)]
      append vp [LMSlength-(( 0.498*rad)+hpos),rad * -0.863,LMSheight-(( 0.088*rad)+vpos)]
      append vp [LMSlength-(( 0.853*rad)+hpos),rad * -0.504,LMSheight-(( 0.151*rad)+vpos)]
      append vp [LMSlength-(( 0.988*rad)+hpos),rad *  0.000,LMSheight-(( 0.175*rad)+vpos)]
      append vp [LMSlength-(( 0.853*rad)+hpos),rad *  0.504,LMSheight-(( 0.151*rad)+vpos)]
      append vp [LMSlength-(( 0.498*rad)+hpos),rad *  0.863,LMSheight-(( 0.088*rad)+vpos)]
      append vp [LMSlength-(( 0.000*rad)+hpos),rad *  1.000,LMSheight-(( 0.000*rad)+vpos)]
      append vp [LMSlength-((-0.498*rad)+hpos),rad *  0.863,LMSheight-((-0.088*rad)+vpos)]
      append vp [LMSlength-((-0.853*rad)+hpos),rad *  0.504,LMSheight-((-0.150*rad)+vpos)]

      --- Right Post (24 Vertices)
      vsetcnt +=1
      append vp [LMSlength+(rad*1.000),rad* 0.000,LMSheight-LMSradius]
      append vp [LMSlength+(rad*0.863),rad*-0.504,LMSheight-LMSradius]
      append vp [LMSlength+(rad*0.504),rad*-0.863,LMSheight-LMSradius]
      append vp [LMSlength+(rad*0.000),rad*-1.000,LMSheight-LMSradius]
      append vp [LMSlength-(rad*0.504),rad*-0.863,LMSheight-LMSradius]
      append vp [LMSlength-(rad*0.863),rad*-0.504,LMSheight-LMSradius]
      append vp [LMSlength-(rad*1.000),rad* 0.000,LMSheight-LMSradius]
      append vp [LMSlength-(rad*0.863),rad* 0.504,LMSheight-LMSradius]
      append vp [LMSlength-(rad*0.504),rad* 0.863,LMSheight-LMSradius]
      append vp [LMSlength+(rad*0.000),rad* 1.000,LMSheight-LMSradius]
      append vp [LMSlength+(rad*0.504),rad* 0.863,LMSheight-LMSradius]
      append vp [LMSlength+(rad*0.863),rad* 0.504,LMSheight-LMSradius]

      vsetcnt +=1
      append vp [LMSlength+(rad*1.000),rad* 0.000,(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(rad*0.863),rad*-0.504,(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(rad*0.504),rad*-0.863,(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(rad*0.000),rad*-1.000,(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength-(rad*0.504),rad*-0.863,(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength-(rad*0.863),rad*-0.504,(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength-(rad*1.000),rad* 0.000,(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength-(rad*0.863),rad* 0.504,(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength-(rad*0.504),rad* 0.863,(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(rad*0.000),rad* 1.000,(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(rad*0.504),rad* 0.863,(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(rad*0.863),rad* 0.504,(LMSlength*LMSxfall)+(LOCunitMult*0.040)]

      --- Centre Top Ring (32 Vertices)
      append vp [(LMSlength/2)-0.025,(rad/2.0)*1.5* 0.000,LMSheight-((rad/2.0)*1.5*2.000)]
      append vp [(LMSlength/2)-0.025,(rad/2.0)*1.5* 0.778,LMSheight-((rad/2.0)*1.5*1.843)]
      append vp [(LMSlength/2)-0.025,(rad/2.0)*1.5* 1.414,LMSheight-((rad/2.0)*1.5*1.414)]
      append vp [(LMSlength/2)-0.025,(rad/2.0)*1.5* 1.843,LMSheight-((rad/2.0)*1.5*0.778)]
      append vp [(LMSlength/2)-0.025,(rad/2.0)*1.5* 2.000,LMSheight+((rad/2.0)*1.5*0.000)]
      append vp [(LMSlength/2)-0.025,(rad/2.0)*1.5* 1.843,LMSheight+((rad/2.0)*1.5*0.778)]
      append vp [(LMSlength/2)-0.025,(rad/2.0)*1.5* 1.414,LMSheight+((rad/2.0)*1.5*1.414)]
      append vp [(LMSlength/2)-0.025,(rad/2.0)*1.5* 0.778,LMSheight+((rad/2.0)*1.5*1.843)]
      append vp [(LMSlength/2)-0.025,(rad/2.0)*1.5* 0.000,LMSheight+((rad/2.0)*1.5*2.000)]
      append vp [(LMSlength/2)-0.025,(rad/2.0)*1.5*-0.778,LMSheight+((rad/2.0)*1.5*1.843)]
      append vp [(LMSlength/2)-0.025,(rad/2.0)*1.5*-1.414,LMSheight+((rad/2.0)*1.5*1.414)]
      append vp [(LMSlength/2)-0.025,(rad/2.0)*1.5*-1.843,LMSheight+((rad/2.0)*1.5*0.778)]
      append vp [(LMSlength/2)-0.025,(rad/2.0)*1.5*-2.000,LMSheight+((rad/2.0)*1.5*0.000)]
      append vp [(LMSlength/2)-0.025,(rad/2.0)*1.5*-1.843,LMSheight-((rad/2.0)*1.5*0.778)]
      append vp [(LMSlength/2)-0.025,(rad/2.0)*1.5*-1.414,LMSheight-((rad/2.0)*1.5*1.414)]
      append vp [(LMSlength/2)-0.025,(rad/2.0)*1.5*-0.778,LMSheight-((rad/2.0)*1.5*1.843)]
      append vp [(LMSlength/2)+0.025,(rad/2.0)*1.5* 0.000,LMSheight-((rad/2.0)*1.5*2.000)]
      append vp [(LMSlength/2)+0.025,(rad/2.0)*1.5* 0.778,LMSheight-((rad/2.0)*1.5*1.843)]
      append vp [(LMSlength/2)+0.025,(rad/2.0)*1.5* 1.414,LMSheight-((rad/2.0)*1.5*1.414)]
      append vp [(LMSlength/2)+0.025,(rad/2.0)*1.5* 1.843,LMSheight-((rad/2.0)*1.5*0.778)]
      append vp [(LMSlength/2)+0.025,(rad/2.0)*1.5* 2.000,LMSheight+((rad/2.0)*1.5*0.000)]
      append vp [(LMSlength/2)+0.025,(rad/2.0)*1.5* 1.843,LMSheight+((rad/2.0)*1.5*0.778)]
      append vp [(LMSlength/2)+0.025,(rad/2.0)*1.5* 1.414,LMSheight+((rad/2.0)*1.5*1.414)]
      append vp [(LMSlength/2)+0.025,(rad/2.0)*1.5* 0.778,LMSheight+((rad/2.0)*1.5*1.843)]
      append vp [(LMSlength/2)+0.025,(rad/2.0)*1.5* 0.000,LMSheight+((rad/2.0)*1.5*2.000)]
      append vp [(LMSlength/2)+0.025,(rad/2.0)*1.5*-0.778,LMSheight+((rad/2.0)*1.5*1.843)]
      append vp [(LMSlength/2)+0.025,(rad/2.0)*1.5*-1.414,LMSheight+((rad/2.0)*1.5*1.414)]
      append vp [(LMSlength/2)+0.025,(rad/2.0)*1.5*-1.843,LMSheight+((rad/2.0)*1.5*0.778)]
      append vp [(LMSlength/2)+0.025,(rad/2.0)*1.5*-2.000,LMSheight+((rad/2.0)*1.5*0.000)]
      append vp [(LMSlength/2)+0.025,(rad/2.0)*1.5*-1.843,LMSheight-((rad/2.0)*1.5*0.778)]
      append vp [(LMSlength/2)+0.025,(rad/2.0)*1.5*-1.414,LMSheight-((rad/2.0)*1.5*1.414)]
      append vp [(LMSlength/2)+0.025,(rad/2.0)*1.5*-0.778,LMSheight-((rad/2.0)*1.5*1.843)]

      --- Right Top Ring (32 Vertices)
      append vp [LMSlength-LMSradius-0.2-0.025,(rad/2.0)*1.5* 0.000,LMSheight-((rad/2.0)*1.5*2.000)]
      append vp [LMSlength-LMSradius-0.2-0.025,(rad/2.0)*1.5* 0.778,LMSheight-((rad/2.0)*1.5*1.843)]
      append vp [LMSlength-LMSradius-0.2-0.025,(rad/2.0)*1.5* 1.414,LMSheight-((rad/2.0)*1.5*1.414)]
      append vp [LMSlength-LMSradius-0.2-0.025,(rad/2.0)*1.5* 1.843,LMSheight-((rad/2.0)*1.5*0.778)]
      append vp [LMSlength-LMSradius-0.2-0.025,(rad/2.0)*1.5* 2.000,LMSheight+((rad/2.0)*1.5*0.000)]
      append vp [LMSlength-LMSradius-0.2-0.025,(rad/2.0)*1.5* 1.843,LMSheight+((rad/2.0)*1.5*0.778)]
      append vp [LMSlength-LMSradius-0.2-0.025,(rad/2.0)*1.5* 1.414,LMSheight+((rad/2.0)*1.5*1.414)]
      append vp [LMSlength-LMSradius-0.2-0.025,(rad/2.0)*1.5* 0.778,LMSheight+((rad/2.0)*1.5*1.843)]
      append vp [LMSlength-LMSradius-0.2-0.025,(rad/2.0)*1.5* 0.000,LMSheight+((rad/2.0)*1.5*2.000)]
      append vp [LMSlength-LMSradius-0.2-0.025,(rad/2.0)*1.5*-0.778,LMSheight+((rad/2.0)*1.5*1.843)]
      append vp [LMSlength-LMSradius-0.2-0.025,(rad/2.0)*1.5*-1.414,LMSheight+((rad/2.0)*1.5*1.414)]
      append vp [LMSlength-LMSradius-0.2-0.025,(rad/2.0)*1.5*-1.843,LMSheight+((rad/2.0)*1.5*0.778)]
      append vp [LMSlength-LMSradius-0.2-0.025,(rad/2.0)*1.5*-2.000,LMSheight+((rad/2.0)*1.5*0.000)]
      append vp [LMSlength-LMSradius-0.2-0.025,(rad/2.0)*1.5*-1.843,LMSheight-((rad/2.0)*1.5*0.778)]
      append vp [LMSlength-LMSradius-0.2-0.025,(rad/2.0)*1.5*-1.414,LMSheight-((rad/2.0)*1.5*1.414)]
      append vp [LMSlength-LMSradius-0.2-0.025,(rad/2.0)*1.5*-0.778,LMSheight-((rad/2.0)*1.5*1.843)]
      append vp [LMSlength-LMSradius-0.2+0.025,(rad/2.0)*1.5* 0.000,LMSheight-((rad/2.0)*1.5*2.000)]
      append vp [LMSlength-LMSradius-0.2+0.025,(rad/2.0)*1.5* 0.778,LMSheight-((rad/2.0)*1.5*1.843)]
      append vp [LMSlength-LMSradius-0.2+0.025,(rad/2.0)*1.5* 1.414,LMSheight-((rad/2.0)*1.5*1.414)]
      append vp [LMSlength-LMSradius-0.2+0.025,(rad/2.0)*1.5* 1.843,LMSheight-((rad/2.0)*1.5*0.778)]
      append vp [LMSlength-LMSradius-0.2+0.025,(rad/2.0)*1.5* 2.000,LMSheight+((rad/2.0)*1.5*0.000)]
      append vp [LMSlength-LMSradius-0.2+0.025,(rad/2.0)*1.5* 1.843,LMSheight+((rad/2.0)*1.5*0.778)]
      append vp [LMSlength-LMSradius-0.2+0.025,(rad/2.0)*1.5* 1.414,LMSheight+((rad/2.0)*1.5*1.414)]
      append vp [LMSlength-LMSradius-0.2+0.025,(rad/2.0)*1.5* 0.778,LMSheight+((rad/2.0)*1.5*1.843)]
      append vp [LMSlength-LMSradius-0.2+0.025,(rad/2.0)*1.5* 0.000,LMSheight+((rad/2.0)*1.5*2.000)]
      append vp [LMSlength-LMSradius-0.2+0.025,(rad/2.0)*1.5*-0.778,LMSheight+((rad/2.0)*1.5*1.843)]
      append vp [LMSlength-LMSradius-0.2+0.025,(rad/2.0)*1.5*-1.414,LMSheight+((rad/2.0)*1.5*1.414)]
      append vp [LMSlength-LMSradius-0.2+0.025,(rad/2.0)*1.5*-1.843,LMSheight+((rad/2.0)*1.5*0.778)]
      append vp [LMSlength-LMSradius-0.2+0.025,(rad/2.0)*1.5*-2.000,LMSheight+((rad/2.0)*1.5*0.000)]
      append vp [LMSlength-LMSradius-0.2+0.025,(rad/2.0)*1.5*-1.843,LMSheight-((rad/2.0)*1.5*0.778)]
      append vp [LMSlength-LMSradius-0.2+0.025,(rad/2.0)*1.5*-1.414,LMSheight-((rad/2.0)*1.5*1.414)]
      append vp [LMSlength-LMSradius-0.2+0.025,(rad/2.0)*1.5*-0.778,LMSheight-((rad/2.0)*1.5*1.843)]

      --- Right Flange Foot (32 Vertices) (Fixed diameter = 0.7 * SysUnit)
      append vp [LMSlength+(0.175 * 2.000 * LOCunitMult),(LOCunitMult * 0.175 * 0.000),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.175 * 1.843 * LOCunitMult),(LOCunitMult * 0.175 * 0.778),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.175 * 1.414 * LOCunitMult),(LOCunitMult * 0.175 * 1.414),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.175 * 0.778 * LOCunitMult),(LOCunitMult * 0.175 * 1.843),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.175 * 0.000 * LOCunitMult),(LOCunitMult * 0.175 * 2.000),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.175 *-0.778 * LOCunitMult),(LOCunitMult * 0.175 * 1.843),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.175 *-1.414 * LOCunitMult),(LOCunitMult * 0.175 * 1.414),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.175 *-1.843 * LOCunitMult),(LOCunitMult * 0.175 * 0.778),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.175 *-2.000 * LOCunitMult),(LOCunitMult * 0.175 * 0.000),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.175 *-1.843 * LOCunitMult),(LOCunitMult * 0.175 *-0.778),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.175 *-1.414 * LOCunitMult),(LOCunitMult * 0.175 *-1.414),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.175 *-0.778 * LOCunitMult),(LOCunitMult * 0.175 *-1.843),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.175 * 0.000 * LOCunitMult),(LOCunitMult * 0.175 *-2.000),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.175 * 0.778 * LOCunitMult),(LOCunitMult * 0.175 *-1.843),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.175 * 1.414 * LOCunitMult),(LOCunitMult * 0.175 *-1.414),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.175 * 1.843 * LOCunitMult),(LOCunitMult * 0.175 *-0.778),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.175 * 2.000 * LOCunitMult),(LOCunitMult * 0.175 * 0.000),(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(0.175 * 1.843 * LOCunitMult),(LOCunitMult * 0.175 * 0.778),(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(0.175 * 1.414 * LOCunitMult),(LOCunitMult * 0.175 * 1.414),(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(0.175 * 0.778 * LOCunitMult),(LOCunitMult * 0.175 * 1.843),(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(0.175 * 0.000 * LOCunitMult),(LOCunitMult * 0.175 * 2.000),(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(0.175 *-0.778 * LOCunitMult),(LOCunitMult * 0.175 * 1.843),(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(0.175 *-1.414 * LOCunitMult),(LOCunitMult * 0.175 * 1.414),(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(0.175 *-1.843 * LOCunitMult),(LOCunitMult * 0.175 * 0.778),(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(0.175 *-2.000 * LOCunitMult),(LOCunitMult * 0.175 * 0.000),(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(0.175 *-1.843 * LOCunitMult),(LOCunitMult * 0.175 *-0.778),(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(0.175 *-1.414 * LOCunitMult),(LOCunitMult * 0.175 *-1.414),(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(0.175 *-0.778 * LOCunitMult),(LOCunitMult * 0.175 *-1.843),(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(0.175 * 0.000 * LOCunitMult),(LOCunitMult * 0.175 *-2.000),(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(0.175 * 0.778 * LOCunitMult),(LOCunitMult * 0.175 *-1.843),(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(0.175 * 1.414 * LOCunitMult),(LOCunitMult * 0.175 *-1.414),(LMSlength*LMSxfall)+(LOCunitMult*0.040)]
      append vp [LMSlength+(0.175 * 1.843 * LOCunitMult),(LOCunitMult * 0.175 *-0.778),(LMSlength*LMSxfall)+(LOCunitMult*0.040)]

      --- Right Concrete Foot (32 Vertices) (Fixed diameter = 1.0 * SysUnit)
      append vp [LMSlength+(0.25 * 2.000 * LOCunitMult),(LOCunitMult * 0.25 * 0.000),(LMSlength*LMSxfall)-(LOCunitMult*1.000)]
      append vp [LMSlength+(0.25 * 1.843 * LOCunitMult),(LOCunitMult * 0.25 * 0.778),(LMSlength*LMSxfall)-(LOCunitMult*1.000)]
      append vp [LMSlength+(0.25 * 1.414 * LOCunitMult),(LOCunitMult * 0.25 * 1.414),(LMSlength*LMSxfall)-(LOCunitMult*1.000)]
      append vp [LMSlength+(0.25 * 0.778 * LOCunitMult),(LOCunitMult * 0.25 * 1.843),(LMSlength*LMSxfall)-(LOCunitMult*1.000)]
      append vp [LMSlength+(0.25 * 0.000 * LOCunitMult),(LOCunitMult * 0.25 * 2.000),(LMSlength*LMSxfall)-(LOCunitMult*1.000)]
      append vp [LMSlength+(0.25 *-0.778 * LOCunitMult),(LOCunitMult * 0.25 * 1.843),(LMSlength*LMSxfall)-(LOCunitMult*1.000)]
      append vp [LMSlength+(0.25 *-1.414 * LOCunitMult),(LOCunitMult * 0.25 * 1.414),(LMSlength*LMSxfall)-(LOCunitMult*1.000)]
      append vp [LMSlength+(0.25 *-1.843 * LOCunitMult),(LOCunitMult * 0.25 * 0.778),(LMSlength*LMSxfall)-(LOCunitMult*1.000)]
      append vp [LMSlength+(0.25 *-2.000 * LOCunitMult),(LOCunitMult * 0.25 * 0.000),(LMSlength*LMSxfall)-(LOCunitMult*1.000)]
      append vp [LMSlength+(0.25 *-1.843 * LOCunitMult),(LOCunitMult * 0.25 *-0.778),(LMSlength*LMSxfall)-(LOCunitMult*1.000)]
      append vp [LMSlength+(0.25 *-1.414 * LOCunitMult),(LOCunitMult * 0.25 *-1.414),(LMSlength*LMSxfall)-(LOCunitMult*1.000)]
      append vp [LMSlength+(0.25 *-0.778 * LOCunitMult),(LOCunitMult * 0.25 *-1.843),(LMSlength*LMSxfall)-(LOCunitMult*1.000)]
      append vp [LMSlength+(0.25 * 0.000 * LOCunitMult),(LOCunitMult * 0.25 *-2.000),(LMSlength*LMSxfall)-(LOCunitMult*1.000)]
      append vp [LMSlength+(0.25 * 0.778 * LOCunitMult),(LOCunitMult * 0.25 *-1.843),(LMSlength*LMSxfall)-(LOCunitMult*1.000)]
      append vp [LMSlength+(0.25 * 1.414 * LOCunitMult),(LOCunitMult * 0.25 *-1.414),(LMSlength*LMSxfall)-(LOCunitMult*1.000)]
      append vp [LMSlength+(0.25 * 1.843 * LOCunitMult),(LOCunitMult * 0.25 *-0.778),(LMSlength*LMSxfall)-(LOCunitMult*1.000)]
      append vp [LMSlength+(0.25 * 2.000 * LOCunitMult),(LOCunitMult * 0.25 * 0.000),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.25 * 1.843 * LOCunitMult),(LOCunitMult * 0.25 * 0.778),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.25 * 1.414 * LOCunitMult),(LOCunitMult * 0.25 * 1.414),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.25 * 0.778 * LOCunitMult),(LOCunitMult * 0.25 * 1.843),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.25 * 0.000 * LOCunitMult),(LOCunitMult * 0.25 * 2.000),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.25 *-0.778 * LOCunitMult),(LOCunitMult * 0.25 * 1.843),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.25 *-1.414 * LOCunitMult),(LOCunitMult * 0.25 * 1.414),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.25 *-1.843 * LOCunitMult),(LOCunitMult * 0.25 * 0.778),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.25 *-2.000 * LOCunitMult),(LOCunitMult * 0.25 * 0.000),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.25 *-1.843 * LOCunitMult),(LOCunitMult * 0.25 *-0.778),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.25 *-1.414 * LOCunitMult),(LOCunitMult * 0.25 *-1.414),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.25 *-0.778 * LOCunitMult),(LOCunitMult * 0.25 *-1.843),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.25 * 0.000 * LOCunitMult),(LOCunitMult * 0.25 *-2.000),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.25 * 0.778 * LOCunitMult),(LOCunitMult * 0.25 *-1.843),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.25 * 1.414 * LOCunitMult),(LOCunitMult * 0.25 *-1.414),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
      append vp [LMSlength+(0.25 * 1.843 * LOCunitMult),(LOCunitMult * 0.25 *-0.778),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
    )

    --- Left Top Ring (32 Vertices)
    append vp [LMSradius+0.2-0.025,(rad/2.0)*1.5* 0.000,LMSheight-((rad/2.0)*1.5*2.000)]
    append vp [LMSradius+0.2-0.025,(rad/2.0)*1.5* 0.778,LMSheight-((rad/2.0)*1.5*1.843)]
    append vp [LMSradius+0.2-0.025,(rad/2.0)*1.5* 1.414,LMSheight-((rad/2.0)*1.5*1.414)]
    append vp [LMSradius+0.2-0.025,(rad/2.0)*1.5* 1.843,LMSheight-((rad/2.0)*1.5*0.778)]
    append vp [LMSradius+0.2-0.025,(rad/2.0)*1.5* 2.000,LMSheight+((rad/2.0)*1.5*0.000)]
    append vp [LMSradius+0.2-0.025,(rad/2.0)*1.5* 1.843,LMSheight+((rad/2.0)*1.5*0.778)]
    append vp [LMSradius+0.2-0.025,(rad/2.0)*1.5* 1.414,LMSheight+((rad/2.0)*1.5*1.414)]
    append vp [LMSradius+0.2-0.025,(rad/2.0)*1.5* 0.778,LMSheight+((rad/2.0)*1.5*1.843)]
    append vp [LMSradius+0.2-0.025,(rad/2.0)*1.5* 0.000,LMSheight+((rad/2.0)*1.5*2.000)]
    append vp [LMSradius+0.2-0.025,(rad/2.0)*1.5*-0.778,LMSheight+((rad/2.0)*1.5*1.843)]
    append vp [LMSradius+0.2-0.025,(rad/2.0)*1.5*-1.414,LMSheight+((rad/2.0)*1.5*1.414)]
    append vp [LMSradius+0.2-0.025,(rad/2.0)*1.5*-1.843,LMSheight+((rad/2.0)*1.5*0.778)]
    append vp [LMSradius+0.2-0.025,(rad/2.0)*1.5*-2.000,LMSheight+((rad/2.0)*1.5*0.000)]
    append vp [LMSradius+0.2-0.025,(rad/2.0)*1.5*-1.843,LMSheight-((rad/2.0)*1.5*0.778)]
    append vp [LMSradius+0.2-0.025,(rad/2.0)*1.5*-1.414,LMSheight-((rad/2.0)*1.5*1.414)]
    append vp [LMSradius+0.2-0.025,(rad/2.0)*1.5*-0.778,LMSheight-((rad/2.0)*1.5*1.843)]
    append vp [LMSradius+0.2+0.025,(rad/2.0)*1.5* 0.000,LMSheight-((rad/2.0)*1.5*2.000)]
    append vp [LMSradius+0.2+0.025,(rad/2.0)*1.5* 0.778,LMSheight-((rad/2.0)*1.5*1.843)]
    append vp [LMSradius+0.2+0.025,(rad/2.0)*1.5* 1.414,LMSheight-((rad/2.0)*1.5*1.414)]
    append vp [LMSradius+0.2+0.025,(rad/2.0)*1.5* 1.843,LMSheight-((rad/2.0)*1.5*0.778)]
    append vp [LMSradius+0.2+0.025,(rad/2.0)*1.5* 2.000,LMSheight+((rad/2.0)*1.5*0.000)]
    append vp [LMSradius+0.2+0.025,(rad/2.0)*1.5* 1.843,LMSheight+((rad/2.0)*1.5*0.778)]
    append vp [LMSradius+0.2+0.025,(rad/2.0)*1.5* 1.414,LMSheight+((rad/2.0)*1.5*1.414)]
    append vp [LMSradius+0.2+0.025,(rad/2.0)*1.5* 0.778,LMSheight+((rad/2.0)*1.5*1.843)]
    append vp [LMSradius+0.2+0.025,(rad/2.0)*1.5* 0.000,LMSheight+((rad/2.0)*1.5*2.000)]
    append vp [LMSradius+0.2+0.025,(rad/2.0)*1.5*-0.778,LMSheight+((rad/2.0)*1.5*1.843)]
    append vp [LMSradius+0.2+0.025,(rad/2.0)*1.5*-1.414,LMSheight+((rad/2.0)*1.5*1.414)]
    append vp [LMSradius+0.2+0.025,(rad/2.0)*1.5*-1.843,LMSheight+((rad/2.0)*1.5*0.778)]
    append vp [LMSradius+0.2+0.025,(rad/2.0)*1.5*-2.000,LMSheight+((rad/2.0)*1.5*0.000)]
    append vp [LMSradius+0.2+0.025,(rad/2.0)*1.5*-1.843,LMSheight-((rad/2.0)*1.5*0.778)]
    append vp [LMSradius+0.2+0.025,(rad/2.0)*1.5*-1.414,LMSheight-((rad/2.0)*1.5*1.414)]
    append vp [LMSradius+0.2+0.025,(rad/2.0)*1.5*-0.778,LMSheight-((rad/2.0)*1.5*1.843)]

    --- Left Flange Foot (32 Vertices)  (Fixed diameter = 0.7)
---      append vp [LMSlength+(0.175 * 2.000 * LOCunitMult),(LOCunitMult * 0.175 * 0.000),(LMSlength*LMSxfall)+(LOCunitMult*0.000)]
    append vp [(0.175* 2.000 * LOCunitMult),(LOCunitMult * 0.175* 0.000),(LOCunitMult * 0.000)]
    append vp [(0.175* 1.843 * LOCunitMult),(LOCunitMult * 0.175* 0.778),(LOCunitMult * 0.000)]
    append vp [(0.175* 1.414 * LOCunitMult),(LOCunitMult * 0.175* 1.414),(LOCunitMult * 0.000)]
    append vp [(0.175* 0.778 * LOCunitMult),(LOCunitMult * 0.175* 1.843),(LOCunitMult * 0.000)]
    append vp [(0.175* 0.000 * LOCunitMult),(LOCunitMult * 0.175* 2.000),(LOCunitMult * 0.000)]
    append vp [(0.175*-0.778 * LOCunitMult),(LOCunitMult * 0.175* 1.843),(LOCunitMult * 0.000)]
    append vp [(0.175*-1.414 * LOCunitMult),(LOCunitMult * 0.175* 1.414),(LOCunitMult * 0.000)]
    append vp [(0.175*-1.843 * LOCunitMult),(LOCunitMult * 0.175* 0.778),(LOCunitMult * 0.000)]
    append vp [(0.175*-2.000 * LOCunitMult),(LOCunitMult * 0.175* 0.000),(LOCunitMult * 0.000)]
    append vp [(0.175*-1.843 * LOCunitMult),(LOCunitMult * 0.175*-0.778),(LOCunitMult * 0.000)]
    append vp [(0.175*-1.414 * LOCunitMult),(LOCunitMult * 0.175*-1.414),(LOCunitMult * 0.000)]
    append vp [(0.175*-0.778 * LOCunitMult),(LOCunitMult * 0.175*-1.843),(LOCunitMult * 0.000)]
    append vp [(0.175* 0.000 * LOCunitMult),(LOCunitMult * 0.175*-2.000),(LOCunitMult * 0.000)]
    append vp [(0.175* 0.778 * LOCunitMult),(LOCunitMult * 0.175*-1.843),(LOCunitMult * 0.000)]
    append vp [(0.175* 1.414 * LOCunitMult),(LOCunitMult * 0.175*-1.414),(LOCunitMult * 0.000)]
    append vp [(0.175* 1.843 * LOCunitMult),(LOCunitMult * 0.175*-0.778),(LOCunitMult * 0.000)]
    append vp [(0.175* 2.000 * LOCunitMult),(LOCunitMult * 0.175* 0.000),(LOCunitMult * 0.040)]
    append vp [(0.175* 1.843 * LOCunitMult),(LOCunitMult * 0.175* 0.778),(LOCunitMult * 0.040)]
    append vp [(0.175* 1.414 * LOCunitMult),(LOCunitMult * 0.175* 1.414),(LOCunitMult * 0.040)]
    append vp [(0.175* 0.778 * LOCunitMult),(LOCunitMult * 0.175* 1.843),(LOCunitMult * 0.040)]
    append vp [(0.175* 0.000 * LOCunitMult),(LOCunitMult * 0.175* 2.000),(LOCunitMult * 0.040)]
    append vp [(0.175*-0.778 * LOCunitMult),(LOCunitMult * 0.175* 1.843),(LOCunitMult * 0.040)]
    append vp [(0.175*-1.414 * LOCunitMult),(LOCunitMult * 0.175* 1.414),(LOCunitMult * 0.040)]
    append vp [(0.175*-1.843 * LOCunitMult),(LOCunitMult * 0.175* 0.778),(LOCunitMult * 0.040)]
    append vp [(0.175*-2.000 * LOCunitMult),(LOCunitMult * 0.175* 0.000),(LOCunitMult * 0.040)]
    append vp [(0.175*-1.843 * LOCunitMult),(LOCunitMult * 0.175*-0.778),(LOCunitMult * 0.040)]
    append vp [(0.175*-1.414 * LOCunitMult),(LOCunitMult * 0.175*-1.414),(LOCunitMult * 0.040)]
    append vp [(0.175*-0.778 * LOCunitMult),(LOCunitMult * 0.175*-1.843),(LOCunitMult * 0.040)]
    append vp [(0.175* 0.000 * LOCunitMult),(LOCunitMult * 0.175*-2.000),(LOCunitMult * 0.040)]
    append vp [(0.175* 0.778 * LOCunitMult),(LOCunitMult * 0.175*-1.843),(LOCunitMult * 0.040)]
    append vp [(0.175* 1.414 * LOCunitMult),(LOCunitMult * 0.175*-1.414),(LOCunitMult * 0.040)]
    append vp [(0.175* 1.843 * LOCunitMult),(LOCunitMult * 0.175*-0.778),(LOCunitMult * 0.040)]

    --- Left Concrete Foot (32 Vertices)  (Fixed diameter = 1.0)
    append vp [(0.25* 2.000 * LOCunitMult),(LOCunitMult * 0.25 * 0.000),(LOCunitMult * -1.000)]
    append vp [(0.25* 1.843 * LOCunitMult),(LOCunitMult * 0.25 * 0.778),(LOCunitMult * -1.000)]
    append vp [(0.25* 1.414 * LOCunitMult),(LOCunitMult * 0.25 * 1.414),(LOCunitMult * -1.000)]
    append vp [(0.25* 0.778 * LOCunitMult),(LOCunitMult * 0.25 * 1.843),(LOCunitMult * -1.000)]
    append vp [(0.25* 0.000 * LOCunitMult),(LOCunitMult * 0.25 * 2.000),(LOCunitMult * -1.000)]
    append vp [(0.25*-0.778 * LOCunitMult),(LOCunitMult * 0.25 * 1.843),(LOCunitMult * -1.000)]
    append vp [(0.25*-1.414 * LOCunitMult),(LOCunitMult * 0.25 * 1.414),(LOCunitMult * -1.000)]
    append vp [(0.25*-1.843 * LOCunitMult),(LOCunitMult * 0.25 * 0.778),(LOCunitMult * -1.000)]
    append vp [(0.25*-2.000 * LOCunitMult),(LOCunitMult * 0.25 * 0.000),(LOCunitMult * -1.000)]
    append vp [(0.25*-1.843 * LOCunitMult),(LOCunitMult * 0.25 *-0.778),(LOCunitMult * -1.000)]
    append vp [(0.25*-1.414 * LOCunitMult),(LOCunitMult * 0.25 *-1.414),(LOCunitMult * -1.000)]
    append vp [(0.25*-0.778 * LOCunitMult),(LOCunitMult * 0.25 *-1.843),(LOCunitMult * -1.000)]
    append vp [(0.25* 0.000 * LOCunitMult),(LOCunitMult * 0.25 *-2.000),(LOCunitMult * -1.000)]
    append vp [(0.25* 0.778 * LOCunitMult),(LOCunitMult * 0.25 *-1.843),(LOCunitMult * -1.000)]
    append vp [(0.25* 1.414 * LOCunitMult),(LOCunitMult * 0.25 *-1.414),(LOCunitMult * -1.000)]
    append vp [(0.25* 1.843 * LOCunitMult),(LOCunitMult * 0.25 *-0.778),(LOCunitMult * -1.000)]
    append vp [(0.25* 2.000 * LOCunitMult),(LOCunitMult * 0.25 * 0.000),(LOCunitMult *  0.000)]
    append vp [(0.25* 1.843 * LOCunitMult),(LOCunitMult * 0.25 * 0.778),(LOCunitMult *  0.000)]
    append vp [(0.25* 1.414 * LOCunitMult),(LOCunitMult * 0.25 * 1.414),(LOCunitMult *  0.000)]
    append vp [(0.25* 0.778 * LOCunitMult),(LOCunitMult * 0.25 * 1.843),(LOCunitMult *  0.000)]
    append vp [(0.25* 0.000 * LOCunitMult),(LOCunitMult * 0.25 * 2.000),(LOCunitMult *  0.000)]
    append vp [(0.25*-0.778 * LOCunitMult),(LOCunitMult * 0.25 * 1.843),(LOCunitMult *  0.000)]
    append vp [(0.25*-1.414 * LOCunitMult),(LOCunitMult * 0.25 * 1.414),(LOCunitMult *  0.000)]
    append vp [(0.25*-1.843 * LOCunitMult),(LOCunitMult * 0.25 * 0.778),(LOCunitMult *  0.000)]
    append vp [(0.25*-2.000 * LOCunitMult),(LOCunitMult * 0.25 * 0.000),(LOCunitMult *  0.000)]
    append vp [(0.25*-1.843 * LOCunitMult),(LOCunitMult * 0.25 *-0.778),(LOCunitMult *  0.000)]
    append vp [(0.25*-1.414 * LOCunitMult),(LOCunitMult * 0.25 *-1.414),(LOCunitMult *  0.000)]
    append vp [(0.25*-0.778 * LOCunitMult),(LOCunitMult * 0.25 *-1.843),(LOCunitMult *  0.000)]
    append vp [(0.25* 0.000 * LOCunitMult),(LOCunitMult * 0.25 *-2.000),(LOCunitMult *  0.000)]
    append vp [(0.25* 0.778 * LOCunitMult),(LOCunitMult * 0.25 *-1.843),(LOCunitMult *  0.000)]
    append vp [(0.25* 1.414 * LOCunitMult),(LOCunitMult * 0.25 *-1.414),(LOCunitMult *  0.000)]
    append vp [(0.25* 1.843 * LOCunitMult),(LOCunitMult * 0.25 *-0.778),(LOCunitMult *  0.000)]


    --- Face data ---------------------------
    local LOCv = 0
    for i = 1 to vsetcnt do
    (
      local LOCfsr = if LMSlstyle then (if i == 1 or i == vsetcnt then 1 else 2) else (if i == 1 or i == vsetcnt or i == ((vsetcnt/2)+1) then 1 else 2) -- only apply smoothing group to radius faces
      append fl [LOCv+1,LOCv+2,LOCv+14]    ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID -- 1
      append fl [LOCv+14,LOCv+13,LOCv+1]   ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+2,LOCv+3,LOCv+15]    ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+15,LOCv+14,LOCv+2]   ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+3,LOCv+4,LOCv+16]    ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+16,LOCv+15,LOCv+3]   ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+4,LOCv+5,LOCv+17]    ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+4,LOCv+5,LOCv+17]    ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+17,LOCv+16,LOCv+4]   ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+5, LOCv+6, LOCv+18]  ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+18,LOCv+17,LOCv+5]   ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+6, LOCv+7, LOCv+19]  ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+19,LOCv+18,LOCv+6]   ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+7, LOCv+8, LOCv+20]  ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+20,LOCv+19,LOCv+7]   ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+8, LOCv+9, LOCv+21]  ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+21,LOCv+20,LOCv+8]   ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+9, LOCv+10,LOCv+22]  ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+22,LOCv+21,LOCv+9]   ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+10,LOCv+11,LOCv+23]  ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+23,LOCv+22,LOCv+10]  ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+11,LOCv+12,LOCv+24]  ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+24,LOCv+23,LOCv+11]  ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+12,LOCv+1, LOCv+13]  ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      append fl [LOCv+13,LOCv+24,LOCv+12]  ; append fe #(true, true, false) ;   append fs LOCfsr       ; append fm LMSmatID
      LOCv += 12
    )
    LOCv += 12

    --- Face data ---------------------------
    local LOCq = #()
    local LOCm = #()
    if LMSlStyle then
    (
      LOCq = #(       0,       32,       64, 96)
      LOCm = #(LMSmatID, LMSmatID, LMSmatID, 10)
    )
    else
    (
      LOCq = #(       0,       32,       64,       96,      128,      160, 192)
      LOCm = #(LMSmatID, LMSmatID, LMSmatID,       10, LMSmatID, LMSmatID,  10)
    )

    --- Top rings and footings
    for i = 1 to LOCq.count do
    (
      append fl [LOCv+01+LOCq[i],LOCv+02+LOCq[i],LOCv+18+LOCq[i]] ; append fe #(true, true, false) ; append fs 1   ; append fm LOCm[i] -- 1
      append fl [LOCv+01+LOCq[i],LOCv+18+LOCq[i],LOCv+17+LOCq[i]] ; append fe #(false, true, true) ; append fs 1   ; append fm LOCm[i]
      append fl [LOCv+02+LOCq[i],LOCv+03+LOCq[i],LOCv+19+LOCq[i]] ; append fe #(true, true, false) ; append fs 3   ; append fm LOCm[i]
      append fl [LOCv+02+LOCq[i],LOCv+19+LOCq[i],LOCv+18+LOCq[i]] ; append fe #(false, true, true) ; append fs 3   ; append fm LOCm[i]
      append fl [LOCv+03+LOCq[i],LOCv+04+LOCq[i],LOCv+20+LOCq[i]] ; append fe #(true, true, false) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+03+LOCq[i],LOCv+20+LOCq[i],LOCv+19+LOCq[i]] ; append fe #(false, true, true) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+04+LOCq[i],LOCv+05+LOCq[i],LOCv+21+LOCq[i]] ; append fe #(true, true, false) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+04+LOCq[i],LOCv+21+LOCq[i],LOCv+20+LOCq[i]] ; append fe #(false, true, true) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+05+LOCq[i],LOCv+06+LOCq[i],LOCv+22+LOCq[i]] ; append fe #(true, true, false) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+05+LOCq[i],LOCv+22+LOCq[i],LOCv+21+LOCq[i]] ; append fe #(false, true, true) ; append fs 2   ; append fm LOCm[i] -- 10
      append fl [LOCv+06+LOCq[i],LOCv+07+LOCq[i],LOCv+23+LOCq[i]] ; append fe #(true, true, false) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+06+LOCq[i],LOCv+23+LOCq[i],LOCv+22+LOCq[i]] ; append fe #(false, true, true) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+07+LOCq[i],LOCv+08+LOCq[i],LOCv+24+LOCq[i]] ; append fe #(true, true, false) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+07+LOCq[i],LOCv+24+LOCq[i],LOCv+23+LOCq[i]] ; append fe #(false, true, true) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+08+LOCq[i],LOCv+09+LOCq[i],LOCv+25+LOCq[i]] ; append fe #(true, true, false) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+08+LOCq[i],LOCv+25+LOCq[i],LOCv+24+LOCq[i]] ; append fe #(false, true, true) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+09+LOCq[i],LOCv+10+LOCq[i],LOCv+26+LOCq[i]] ; append fe #(true, true, false) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+09+LOCq[i],LOCv+26+LOCq[i],LOCv+25+LOCq[i]] ; append fe #(false, true, true) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+10+LOCq[i],LOCv+11+LOCq[i],LOCv+27+LOCq[i]] ; append fe #(true, true, false) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+10+LOCq[i],LOCv+27+LOCq[i],LOCv+26+LOCq[i]] ; append fe #(false, true, true) ; append fs 2   ; append fm LOCm[i] -- 20
      append fl [LOCv+11+LOCq[i],LOCv+12+LOCq[i],LOCv+28+LOCq[i]] ; append fe #(true, true, false) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+11+LOCq[i],LOCv+28+LOCq[i],LOCv+27+LOCq[i]] ; append fe #(false, true, true) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+12+LOCq[i],LOCv+13+LOCq[i],LOCv+29+LOCq[i]] ; append fe #(true, true, false) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+12+LOCq[i],LOCv+29+LOCq[i],LOCv+28+LOCq[i]] ; append fe #(false, true, true) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+13+LOCq[i],LOCv+14+LOCq[i],LOCv+30+LOCq[i]] ; append fe #(true, true, false) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+13+LOCq[i],LOCv+30+LOCq[i],LOCv+29+LOCq[i]] ; append fe #(false, true, true) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+14+LOCq[i],LOCv+15+LOCq[i],LOCv+31+LOCq[i]] ; append fe #(true, true, false) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+14+LOCq[i],LOCv+31+LOCq[i],LOCv+30+LOCq[i]] ; append fe #(false, true, true) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+15+LOCq[i],LOCv+16+LOCq[i],LOCv+32+LOCq[i]] ; append fe #(true, true, false) ; append fs 2   ; append fm LOCm[i]
      append fl [LOCv+15+LOCq[i],LOCv+32+LOCq[i],LOCv+31+LOCq[i]] ; append fe #(false, true, true) ; append fs 2   ; append fm LOCm[i] -- 30
      append fl [LOCv+16+LOCq[i],LOCv+01+LOCq[i],LOCv+17+LOCq[i]] ; append fe #(true, true, false) ; append fs 3   ; append fm LOCm[i]
      append fl [LOCv+16+LOCq[i],LOCv+17+LOCq[i],LOCv+32+LOCq[i]] ; append fe #(false, true, true) ; append fs 3   ; append fm LOCm[i]
      append fl [LOCv+08+LOCq[i],LOCv+10+LOCq[i],LOCv+09+LOCq[i]] ; append fe #(false, true, true) ; append fs 16  ; append fm LOCm[i]
      append fl [LOCv+07+LOCq[i],LOCv+10+LOCq[i],LOCv+08+LOCq[i]] ; append fe #(false, false, true); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+07+LOCq[i],LOCv+11+LOCq[i],LOCv+10+LOCq[i]] ; append fe #(false, true, false); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+06+LOCq[i],LOCv+11+LOCq[i],LOCv+07+LOCq[i]] ; append fe #(false, false, true); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+05+LOCq[i],LOCv+11+LOCq[i],LOCv+06+LOCq[i]] ; append fe #(false, false, true); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+04+LOCq[i],LOCv+11+LOCq[i],LOCv+05+LOCq[i]] ; append fe #(false, false, true); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+03+LOCq[i],LOCv+11+LOCq[i],LOCv+04+LOCq[i]] ; append fe #(false, false, true); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+03+LOCq[i],LOCv+12+LOCq[i],LOCv+11+LOCq[i]] ; append fe #(false, true, false); append fs 16  ; append fm LOCm[i] -- 40
      append fl [LOCv+03+LOCq[i],LOCv+13+LOCq[i],LOCv+12+LOCq[i]] ; append fe #(false, true, false); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+03+LOCq[i],LOCv+14+LOCq[i],LOCv+13+LOCq[i]] ; append fe #(false, true, false); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+03+LOCq[i],LOCv+15+LOCq[i],LOCv+14+LOCq[i]] ; append fe #(false, true, false); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+02+LOCq[i],LOCv+15+LOCq[i],LOCv+03+LOCq[i]] ; append fe #(false, false, true); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+01+LOCq[i],LOCv+15+LOCq[i],LOCv+02+LOCq[i]] ; append fe #(false, false, true); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+16+LOCq[i],LOCv+15+LOCq[i],LOCv+01+LOCq[i]] ; append fe #(true, false, true) ; append fs 16  ; append fm LOCm[i]
      append fl [LOCv+24+LOCq[i],LOCv+25+LOCq[i],LOCv+26+LOCq[i]] ; append fe #(true, true, false) ; append fs 16  ; append fm LOCm[i]
      append fl [LOCv+23+LOCq[i],LOCv+24+LOCq[i],LOCv+26+LOCq[i]] ; append fe #(true, false, false); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+23+LOCq[i],LOCv+26+LOCq[i],LOCv+27+LOCq[i]] ; append fe #(false, true, false); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+22+LOCq[i],LOCv+23+LOCq[i],LOCv+27+LOCq[i]] ; append fe #(true, false, false); append fs 16  ; append fm LOCm[i] -- 50
      append fl [LOCv+21+LOCq[i],LOCv+22+LOCq[i],LOCv+27+LOCq[i]] ; append fe #(true, false, false); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+20+LOCq[i],LOCv+21+LOCq[i],LOCv+27+LOCq[i]] ; append fe #(true, false, false); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+19+LOCq[i],LOCv+20+LOCq[i],LOCv+27+LOCq[i]] ; append fe #(true, false, false); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+19+LOCq[i],LOCv+27+LOCq[i],LOCv+28+LOCq[i]] ; append fe #(false, true, false); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+19+LOCq[i],LOCv+28+LOCq[i],LOCv+29+LOCq[i]] ; append fe #(false, true, false); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+19+LOCq[i],LOCv+29+LOCq[i],LOCv+30+LOCq[i]] ; append fe #(false, true, false); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+19+LOCq[i],LOCv+30+LOCq[i],LOCv+31+LOCq[i]] ; append fe #(false, true, false); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+18+LOCq[i],LOCv+19+LOCq[i],LOCv+31+LOCq[i]] ; append fe #(true, false, false); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+17+LOCq[i],LOCv+18+LOCq[i],LOCv+31+LOCq[i]] ; append fe #(true, false, false); append fs 16  ; append fm LOCm[i]
      append fl [LOCv+32+LOCq[i],LOCv+17+LOCq[i],LOCv+31+LOCq[i]] ; append fe #(true, false, true) ; append fs 16  ; append fm LOCm[i] -- 60
    )

    setMesh mesh vertices:vp faces:fl materialIDs:fm
    for i = 1 to fl.count do setFaceSmoothGroup mesh i fs[i]
    for i = 1 to fl.count do (for j = 1 to 3 do (setEdgeVis mesh i j fe[i][j]))
  ) -- end on buildmesh

  tool create prompt:~PLUGIN_CIVILGANTRYNZ_PROMPT~
  (
    on mousePoint click do
    (
      case click of
      (
        1: nodeTM.translation = gridPoint
        2: #stop
      )
    )
  ) -- end create tool
) -- end plugin
--
-- � Copyright 2011 Autodesk, Inc. All rights reserved.
--

plugin simpleObject Vsp_GantrySA name:~PLUGIN_CIVILGANTRYSA_NAME~ category:~PLUGIN_CIVILGANTRYSA_CATEGORY~ classID:#(0x1039136c, 0x324396c5) invisible:(not DYNcreatable)
(
  parameters main rollout:ROLLOUTparams
  (
    length          type:#worldunits animatable:true default:20.0
    height          type:#worldunits animatable:true default:7.0
    radius          type:#worldunits animatable:true default:0.0
    dia             type:#worldunits animatable:true default:0.40
    xfall           type:#float      animatable:true default:0
    matID           type:#integer    animatable:true default:2
    lStyle          type:#boolean    animatable:true default:false

    /* The following params are unique to the NL sign gantry and are included here as
       dummy params to ensure compatability between baseObject types in GantryParams panel */
    signals         type:#boolean    animatable:true default:false
    numberOfSignals type:#integer    animatable:true default:1
    SignalGap       type:#worldunits animatable:true default:3.6
    flipSignals     type:#boolean    animatable:true default:false
    SignalOffset    type:#worldunits animatable:true default:3
  )

  rollout ROLLOUTparams ~PLUGIN_CIVILGANTRYSA_ROLLOUT~
  (
    group ~PLUGIN_CIVILGANTRYSA_GROUP~
    (
      label LBtext01 ~PLUGIN_CIVILGANTRYSA_TEXT01~ align:#center
      label LBtext02 ~PLUGIN_CIVILGANTRYSA_TEXT02~ align:#center
    )
  )

  on create do
  (
    --- Set Default Values                                                                 ---
    --- When a new gantry is created, convert the defaults in Pmblock which use WorldUnits ---
    --- to equivilents in feet                                                             ---
    local LOCunitMult = 1.0
    case units.SystemType of
    (
      #Inches      : LOCunitMult = 39.3700787
      #Feet        : LOCunitMult = 3.2808399
      #Miles       : LOCunitMult = 0.000621371192
      #Millimeters : LOCunitMult = 1000.0
      #Centimeters : LOCunitMult = 100.0
      #Meters      : LOCunitMult = 1.0
      #Kilometers  : LOCunitMult = 0.001
    )
    length       = length       * LOCunitMult
    height       = height       * LOCunitMult
    Radius       = Radius       * LOCunitMult
    Dia          = Dia          * LOCunitMult
    SignalGap    = SignalGap    * LOCunitMult
    SignalOffset = SignalOffset * LOCunitMult
  )

  on buildMesh do
  (
    local LMSlength  = length
    local LMSheight  = height
    local LMSRadius  = Radius
    local LMSDia     = Dia

    local LMSxfall   = xfall
    local LMSmatID   = matID
    local LMSlStyle  = lStyle

    vp = #()
    fl = #()
    fm = #()
    fs = #()
    fe = #()
    -- Vertex data ---------------------------
    local rad = LMSdia / 2.0
    local hpos
    local vpos

    --- First Post
    local vsetcnt = 0
    append vp [rad * -1.000 ,rad * -1.000 ,0.060]
    append vp [rad *  1.000 ,rad * -1.000 ,0.060]
    append vp [rad *  1.000 ,rad *  1.000 ,0.060]
    append vp [rad * -1.000 ,rad *  1.000 ,0.060]

    vsetcnt +=1
    append vp [rad * -1.000 ,rad * -1.000 ,LMSheight-LMSradius]
    append vp [rad *  1.000 ,rad * -1.000 ,LMSheight-LMSradius]
    append vp [rad *  1.000 ,rad *  1.000 ,LMSheight-LMSradius]
    append vp [rad * -1.000 ,rad *  1.000 ,LMSheight-LMSradius]

    --- Left LMSradius
    hpos = LMSradius - (LMSradius * (cos 10)) -- 0.046
    vpos = LMSradius - (LMSradius * (sin 10)) -- 2.478
    vsetcnt +=1
    append vp [(-0.988*rad)+hpos,rad * -1.000 ,LMSheight-((-0.174*rad)+vpos)]
    append vp [( 0.988*rad)+hpos,rad * -1.000 ,LMSheight-(( 0.174*rad)+vpos)]
    append vp [( 0.988*rad)+hpos,rad *  1.000 ,LMSheight-(( 0.174*rad)+vpos)]
    append vp [(-0.988*rad)+hpos,rad *  1.000 ,LMSheight-((-0.174*rad)+vpos)]

    vsetcnt +=1
    hpos = LMSradius - (LMSradius * (cos 20)) -- 0.181
    vpos = LMSradius - (LMSradius * (sin 20)) -- 1.975
    append vp [(-0.943*rad)+hpos,rad * -1.000,LMSheight-((-0.343*rad)+vpos)]
    append vp [( 0.943*rad)+hpos,rad * -1.000,LMSheight-(( 0.343*rad)+vpos)]
    append vp [( 0.943*rad)+hpos,rad *  1.000,LMSheight-(( 0.343*rad)+vpos)]
    append vp [(-0.943*rad)+hpos,rad *  1.000,LMSheight-((-0.343*rad)+vpos)]

    vsetcnt +=1
    hpos = LMSradius - (LMSradius * (cos 30)) -- 0.402
    vpos = LMSradius - (LMSradius * (sin 30)) -- 1.500
    append vp [(-0.869*rad)+hpos,rad * -1.000,LMSheight-((-0.502*rad)+vpos)]
    append vp [( 0.869*rad)+hpos,rad * -1.000,LMSheight-(( 0.502*rad)+vpos)]
    append vp [( 0.869*rad)+hpos,rad *  1.000,LMSheight-(( 0.502*rad)+vpos)]
    append vp [(-0.869*rad)+hpos,rad *  1.000,LMSheight-((-0.502*rad)+vpos)]

    vsetcnt +=1
    hpos = LMSradius - (LMSradius * (cos 40)) -- 0.702
    vpos = LMSradius - (LMSradius * (sin 40)) -- 1.071
    append vp [(-0.769*rad)+hpos,rad * -1.000,LMSheight-((-0.645*rad)+vpos)]
    append vp [( 0.769*rad)+hpos,rad * -1.000,LMSheight-(( 0.645*rad)+vpos)]
    append vp [( 0.769*rad)+hpos,rad *  1.000,LMSheight-(( 0.645*rad)+vpos)]
    append vp [(-0.769*rad)+hpos,rad *  1.000,LMSheight-((-0.645*rad)+vpos)]

    vsetcnt +=1
    hpos = LMSradius - (LMSradius * (cos 50)) -- 1.071
    vpos = LMSradius - (LMSradius * (sin 50)) -- 0.702
    append vp [(-0.645*rad)+hpos,rad * -1.000,LMSheight-((-0.769*rad)+vpos)]
    append vp [( 0.645*rad)+hpos,rad * -1.000,LMSheight-(( 0.769*rad)+vpos)]
    append vp [( 0.645*rad)+hpos,rad *  1.000,LMSheight-(( 0.769*rad)+vpos)]
    append vp [(-0.645*rad)+hpos,rad *  1.000,LMSheight-((-0.769*rad)+vpos)]

    vsetcnt +=1
    hpos = LMSradius - (LMSradius * (cos 60)) -- 1.500
    vpos = LMSradius - (LMSradius * (sin 60)) -- 0.402
    append vp [(-0.502*rad)+hpos,rad * -1.000,LMSheight-((-0.869*rad)+vpos)]
    append vp [( 0.502*rad)+hpos,rad * -1.000,LMSheight-(( 0.869*rad)+vpos)]
    append vp [( 0.502*rad)+hpos,rad *  1.000,LMSheight-(( 0.869*rad)+vpos)]
    append vp [(-0.502*rad)+hpos,rad *  1.000,LMSheight-((-0.869*rad)+vpos)]

    vsetcnt +=1
    hpos = LMSradius - (LMSradius * (cos 70)) -- 1.975
    vpos = LMSradius - (LMSradius * (sin 70)) -- 0.181
    append vp [(-0.343*rad)+hpos,rad * -1.000,LMSheight-((-0.943*rad)+vpos)]
    append vp [( 0.343*rad)+hpos,rad * -1.000,LMSheight-(( 0.943*rad)+vpos)]
    append vp [( 0.343*rad)+hpos,rad *  1.000,LMSheight-(( 0.943*rad)+vpos)]
    append vp [(-0.343*rad)+hpos,rad *  1.000,LMSheight-((-0.943*rad)+vpos)]

    vsetcnt +=1
    hpos = LMSradius - (LMSradius * (cos 80)) -- 2.478
    vpos = LMSradius - (LMSradius * (sin 80)) -- 0.046
    append vp [(-0.174*rad)+hpos,rad * -1.000,LMSheight-((-0.988*rad)+vpos)]
    append vp [( 0.174*rad)+hpos,rad * -1.000,LMSheight-(( 0.988*rad)+vpos)]
    append vp [( 0.174*rad)+hpos,rad *  1.000,LMSheight-(( 0.988*rad)+vpos)]
    append vp [(-0.174*rad)+hpos,rad *  1.000,LMSheight-((-0.988*rad)+vpos)]

    --- TOP BAR
    vsetcnt +=1
    append vp [LMSradius,rad * -1.000 ,LMSheight+(rad*1.001)]
    append vp [LMSradius,rad * -1.000 ,LMSheight-(rad*1.000)]
    append vp [LMSradius,rad *  1.000 ,LMSheight-(rad*1.001)]
    append vp [LMSradius,rad *  1.000 ,LMSheight+(rad*1.000)]

    if LMSlStyle then
    (
      vsetcnt +=1
      append vp [LMSlength,rad * -1.000,LMSheight+(rad*1.000)]
      append vp [LMSlength,rad * -1.000,LMSheight-(rad*1.000)]
      append vp [LMSlength,rad *  1.000,LMSheight-(rad*1.000)]
      append vp [LMSlength,rad *  1.000,LMSheight+(rad*1.000)]
    )
    else
    (
      vsetcnt +=1
      append vp [LMSlength-LMSradius,rad * -1.000,LMSheight+(rad*1.000)]
      append vp [LMSlength-LMSradius,rad * -1.000,LMSheight-(rad*1.000)]
      append vp [LMSlength-LMSradius,rad *  1.000,LMSheight-(rad*1.000)]
      append vp [LMSlength-LMSradius,rad *  1.000,LMSheight+(rad*1.000)]

      --- Right LMSradius
      hpos = LMSradius - (LMSradius * (cos 80)) -- 12.478
      vpos = LMSradius - (LMSradius * (sin 80)) -- 00.046
      vsetcnt +=1
      append vp [LMSlength-((-0.174*rad)+hpos),rad * -1.000,LMSheight-((-0.988*rad)+vpos)]
      append vp [LMSlength-(( 0.174*rad)+hpos),rad * -1.000,LMSheight-(( 0.988*rad)+vpos)]
      append vp [LMSlength-(( 0.174*rad)+hpos),rad *  1.000,LMSheight-(( 0.988*rad)+vpos)]
      append vp [LMSlength-((-0.174*rad)+hpos),rad *  1.000,LMSheight-((-0.988*rad)+vpos)]

      hpos = LMSradius - (LMSradius * (cos 70)) -- 11.975
      vpos = LMSradius - (LMSradius * (sin 70)) -- 00.181
      vsetcnt +=1
      append vp [LMSlength-((-0.343*rad)+hpos),rad * -1.000,LMSheight-((-0.943*rad)+vpos)]
      append vp [LMSlength-(( 0.343*rad)+hpos),rad * -1.000,LMSheight-(( 0.943*rad)+vpos)]
      append vp [LMSlength-(( 0.343*rad)+hpos),rad *  1.000,LMSheight-(( 0.943*rad)+vpos)]
      append vp [LMSlength-((-0.343*rad)+hpos),rad *  1.000,LMSheight-((-0.943*rad)+vpos)]

      hpos = LMSradius - (LMSradius * (cos 60)) -- 11.500
      vpos = LMSradius - (LMSradius * (sin 60)) -- 00.402
      vsetcnt +=1
      append vp [LMSlength-((-0.502*rad)+hpos),rad * -1.000,LMSheight-((-0.869*rad)+vpos)]
      append vp [LMSlength-(( 0.502*rad)+hpos),rad * -1.000,LMSheight-(( 0.869*rad)+vpos)]
      append vp [LMSlength-(( 0.502*rad)+hpos),rad *  1.000,LMSheight-(( 0.869*rad)+vpos)]
      append vp [LMSlength-((-0.502*rad)+hpos),rad *  1.000,LMSheight-((-0.869*rad)+vpos)]

      hpos = LMSradius - (LMSradius * (cos 50)) -- 11.071
      vpos = LMSradius - (LMSradius * (sin 50)) -- 00.702
      vsetcnt +=1
      append vp [LMSlength-((-0.645*rad)+hpos),rad * -1.000,LMSheight-((-0.769*rad)+vpos)]
      append vp [LMSlength-(( 0.645*rad)+hpos),rad * -1.000,LMSheight-(( 0.769*rad)+vpos)]
      append vp [LMSlength-(( 0.645*rad)+hpos),rad *  1.000,LMSheight-(( 0.769*rad)+vpos)]
      append vp [LMSlength-((-0.645*rad)+hpos),rad *  1.000,LMSheight-((-0.769*rad)+vpos)]

      hpos = LMSradius - (LMSradius * (cos 40)) -- 10.702
      vpos = LMSradius - (LMSradius * (sin 40)) -- 01.071
      vsetcnt +=1
      append vp [LMSlength-((-0.769*rad)+hpos),rad * -1.000,LMSheight-((-0.645*rad)+vpos)]
      append vp [LMSlength-(( 0.769*rad)+hpos),rad * -1.000,LMSheight-(( 0.645*rad)+vpos)]
      append vp [LMSlength-(( 0.769*rad)+hpos),rad *  1.000,LMSheight-(( 0.645*rad)+vpos)]
      append vp [LMSlength-((-0.769*rad)+hpos),rad *  1.000,LMSheight-((-0.645*rad)+vpos)]

      hpos = LMSradius - (LMSradius * (cos 30)) -- 10.402
      vpos = LMSradius - (LMSradius * (sin 30)) -- 01.500
      vsetcnt +=1
      append vp [LMSlength-((-0.869*rad)+hpos),rad * -1.000,LMSheight-((-0.502*rad)+vpos)]
      append vp [LMSlength-(( 0.869*rad)+hpos),rad * -1.000,LMSheight-(( 0.502*rad)+vpos)]
      append vp [LMSlength-(( 0.869*rad)+hpos),rad *  1.000,LMSheight-(( 0.502*rad)+vpos)]
      append vp [LMSlength-((-0.869*rad)+hpos),rad *  1.000,LMSheight-((-0.502*rad)+vpos)]

      hpos = LMSradius - (LMSradius * (cos 20)) -- 10.181
      vpos = LMSradius - (LMSradius * (sin 20)) -- 01.975
      vsetcnt +=1
      append vp [LMSlength-((-0.943*rad)+hpos),rad * -1.000,LMSheight-((-0.343*rad)+vpos)]
      append vp [LMSlength-(( 0.943*rad)+hpos),rad * -1.000,LMSheight-(( 0.343*rad)+vpos)]
      append vp [LMSlength-(( 0.943*rad)+hpos),rad *  1.000,LMSheight-(( 0.343*rad)+vpos)]
      append vp [LMSlength-((-0.943*rad)+hpos),rad *  1.000,LMSheight-((-0.343*rad)+vpos)]

      hpos = LMSradius - (LMSradius * (cos 10)) -- 10.046
      vpos = LMSradius - (LMSradius * (sin 10)) -- 02.478
      vsetcnt +=1
      append vp [LMSlength-((-0.988*rad)+hpos),rad * -1.000,LMSheight-((-0.174*rad)+vpos)]
      append vp [LMSlength-(( 0.988*rad)+hpos),rad * -1.000,LMSheight-(( 0.174*rad)+vpos)]
      append vp [LMSlength-(( 0.988*rad)+hpos),rad *  1.000,LMSheight-(( 0.174*rad)+vpos)]
      append vp [LMSlength-((-0.988*rad)+hpos),rad *  1.000,LMSheight-((-0.174*rad)+vpos)]

      --- Right Post (24 Vertices)
      vsetcnt +=1
      append vp [LMSlength+(rad*1.001),rad*-1.000,LMSheight-LMSradius]
      append vp [LMSlength-(rad*1.000),rad*-1.000,LMSheight-LMSradius]
      append vp [LMSlength-(rad*1.001),rad* 1.000,LMSheight-LMSradius]
      append vp [LMSlength+(rad*1.000),rad* 1.000,LMSheight-LMSradius]

      vsetcnt +=1
      append vp [LMSlength+(rad*1.000),rad*-1.000,(LMSlength*LMSxfall)+0.060]
      append vp [LMSlength-(rad*1.000),rad*-1.000,(LMSlength*LMSxfall)+0.060]
      append vp [LMSlength-(rad*1.000),rad* 1.000,(LMSlength*LMSxfall)+0.060]
      append vp [LMSlength+(rad*1.000),rad* 1.000,(LMSlength*LMSxfall)+0.060]
    )

    --- Gantry Bedding - Left
    append vp [rad *  2.000 ,rad * -2.000 ,0.060]
    append vp [rad * -2.000 ,rad * -2.000 ,0.060]
    append vp [rad * -2.000 ,rad *  2.000 ,0.060]
    append vp [rad *  2.000 ,rad *  2.000 ,0.060]
    append vp [rad *  2.000 ,rad * -2.000 ,0.000]
    append vp [rad * -2.000 ,rad * -2.000 ,0.000]
    append vp [rad * -2.000 ,rad *  2.000 ,0.000]
    append vp [rad *  2.000 ,rad *  2.000 ,0.000]

    --- Gantry Footings - Left
    append vp [rad *  2.500 ,rad * -2.500 ,0.000]
    append vp [rad * -2.500 ,rad * -2.500 ,0.000]
    append vp [rad * -2.500 ,rad *  2.500 ,0.000]
    append vp [rad *  2.500 ,rad *  2.500 ,0.000]
    append vp [rad *  2.500 ,rad * -2.500 ,-1.000]
    append vp [rad * -2.500 ,rad * -2.500 ,-1.000]
    append vp [rad * -2.500 ,rad *  2.500 ,-1.000]
    append vp [rad *  2.500 ,rad *  2.500 ,-1.000]

    if not LMSlStyle then
    (
      --- Gantry Bedding - Right
      append vp [LMSlength+(rad*2.000),rad*-2.000,(LMSlength*LMSxfall)+0.060]
      append vp [LMSlength-(rad*2.000),rad*-2.000,(LMSlength*LMSxfall)+0.060]
      append vp [LMSlength-(rad*2.000),rad* 2.000,(LMSlength*LMSxfall)+0.060]
      append vp [LMSlength+(rad*2.000),rad* 2.000,(LMSlength*LMSxfall)+0.060]
      append vp [LMSlength+(rad*2.000),rad*-2.000,(LMSlength*LMSxfall)]
      append vp [LMSlength-(rad*2.000),rad*-2.000,(LMSlength*LMSxfall)]
      append vp [LMSlength-(rad*2.000),rad* 2.000,(LMSlength*LMSxfall)]
      append vp [LMSlength+(rad*2.000),rad* 2.000,(LMSlength*LMSxfall)]

      --- Gantry Footings - Right
      append vp [LMSlength+(rad*2.500),rad*-2.500,(LMSlength*LMSxfall)]
      append vp [LMSlength-(rad*2.500),rad*-2.500,(LMSlength*LMSxfall)]
      append vp [LMSlength-(rad*2.500),rad* 2.500,(LMSlength*LMSxfall)]
      append vp [LMSlength+(rad*2.500),rad* 2.500,(LMSlength*LMSxfall)]
      append vp [LMSlength+(rad*2.500),rad*-2.500,(LMSlength*LMSxfall)-1.000]
      append vp [LMSlength-(rad*2.500),rad*-2.500,(LMSlength*LMSxfall)-1.000]
      append vp [LMSlength-(rad*2.500),rad* 2.500,(LMSlength*LMSxfall)-1.000]
      append vp [LMSlength+(rad*2.500),rad* 2.500,(LMSlength*LMSxfall)-1.000]
    )

    --- Face data ---------------------------
    local LOCv = 0
    for i = 1 to vsetcnt do
    (
      local LOCfsr = if LMSlstyle then (if i == 1 or i == vsetcnt then 0 else 3) else (if i == 1 or i == vsetcnt or i == ((vsetcnt/2)+1) then 0 else 3) -- only apply smoothing group to radius faces
      append fl [LOCv+1,LOCv+2,LOCv+5]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LMSmatID -- 1
      append fl [LOCv+6,LOCv+5,LOCv+2]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LMSmatID
      append fl [LOCv+2,LOCv+3,LOCv+6]   ; append fe #(true, false, true) ;   append fs LOCfsr      ; append fm LMSmatID
      append fl [LOCv+7,LOCv+6,LOCv+3]   ; append fe #(true, false, true) ;   append fs LOCfsr      ; append fm LMSmatID
      append fl [LOCv+3,LOCv+4,LOCv+7]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LMSmatID
      append fl [LOCv+8,LOCv+7,LOCv+4]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LMSmatID
      append fl [LOCv+4,LOCv+1,LOCv+8]   ; append fe #(true, false, true) ;   append fs LOCfsr      ; append fm LMSmatID
      append fl [LOCv+5,LOCv+8,LOCv+1]   ; append fe #(true, false, true) ;   append fs LOCfsr      ; append fm LMSmatID
      LOCv += 4
    )

    --- Cap end of horiz top bar if single post gantry
    if LMSlStyle then
    (
      append fl [LOCv+1,LOCv+2,LOCv+4]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LMSmatID
      append fl [LOCv+3,LOCv+4,LOCv+2]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LMSmatID
    )
    LOCv += 4

    --- Gantry Footings Left
    local LOCm = #(LMSmatID,  10)
    for i = 1 to 2 do
    (
      append fl [LOCv+1,LOCv+2,LOCv+5]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i] -- 1
      append fl [LOCv+6,LOCv+5,LOCv+2]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
      append fl [LOCv+2,LOCv+3,LOCv+6]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
      append fl [LOCv+7,LOCv+6,LOCv+3]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
      append fl [LOCv+3,LOCv+4,LOCv+7]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
      append fl [LOCv+8,LOCv+7,LOCv+4]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
      append fl [LOCv+4,LOCv+1,LOCv+8]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
      append fl [LOCv+5,LOCv+8,LOCv+1]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
      append fl [LOCv+2,LOCv+1,LOCv+3]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
      append fl [LOCv+4,LOCv+3,LOCv+1]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
      LOCv += 8
    )
    append fl [LOCv-3,LOCv-2,LOCv-1]     ; append fe #(true, true, false) ;   append fs 0           ; append fm 10
    append fl [LOCv-1,LOCv,LOCv-3]       ; append fe #(true, true, false) ;   append fs 0           ; append fm 10

    --- Gantry Footings Right
    if not LMSlStyle then
    (
      for i = 1 to 2 do
      (
        append fl [LOCv+1,LOCv+2,LOCv+5]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i] -- 1
        append fl [LOCv+6,LOCv+5,LOCv+2]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
        append fl [LOCv+2,LOCv+3,LOCv+6]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
        append fl [LOCv+7,LOCv+6,LOCv+3]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
        append fl [LOCv+3,LOCv+4,LOCv+7]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
        append fl [LOCv+8,LOCv+7,LOCv+4]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
        append fl [LOCv+4,LOCv+1,LOCv+8]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
        append fl [LOCv+5,LOCv+8,LOCv+1]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
        append fl [LOCv+2,LOCv+1,LOCv+3]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
        append fl [LOCv+4,LOCv+3,LOCv+1]   ; append fe #(true, false, true) ;   append fs 0           ; append fm LOCm[i]
        LOCv += 8
      )
      append fl [LOCv-3,LOCv-2,LOCv-1]     ; append fe #(true, true, false) ;   append fs 0           ; append fm 10
      append fl [LOCv-1,LOCv,LOCv-3]       ; append fe #(true, true, false) ;   append fs 0           ; append fm 10
    )

    setMesh mesh vertices:vp faces:fl materialIDs:fm
    for i = 1 to fl.count do setFaceSmoothGroup mesh i fs[i]
    for i = 1 to fl.count do (for j = 1 to 3 do (setEdgeVis mesh i j fe[i][j]))
  ) -- end on buildmesh

  tool create prompt:~PLUGIN_CIVILGANTRYSA_PROMPT~
  (
    on mousePoint click do
    (
      case click of
      (
        1: nodeTM.translation = gridPoint
        2: #stop
      )
    )
  ) -- end create tool
) -- end plugin
plugin simpleObject Vsp_Lamp name:~PLUGIN_CIVILLAMP_NAME~ category:~PLUGIN_CIVILLAMP_CATEGORY~ classID:#(905393364,2048113778) invisible:(not DYNcreatable)
(
  parameters main rollout:params
  (
    height     type:#worldunits   default:13.0
    depth      type:#worldunits   default:1.5
    kink1      type:#worldunits   default:5.75
    kink2      type:#worldunits   default:0.25
    matID      type:#integer      default:5
    onoff      type:#boolean      default:false
    dia1       type:#worldunits   default:0.16
    dia2       type:#worldunits   default:0.09
    radius     type:#worldunits   default:0.35
    armLen     type:#worldunits   default:1.100
    angle      type:#worldunits   default:80.0
    headScaleX type:#float        default:1.0
    headScaleY type:#float        default:1.0
    leftArm    type:#boolean      default:false
    rightArm   type:#boolean      default:true
	)

  rollout params ~PLUGIN_CIVILLAMP_ROLLOUT~
  (
    group ~PLUGIN_CIVILLAMP_GROUP~
    (
      label LBtext01 ~PLUGIN_CIVILLAMP_TEXT01~ align:#center
      label LBtext02 ~PLUGIN_CIVILLAMP_TEXT02~ align:#center
    )
	)

  on create do
  (
    --- Set Default Values                                                                 ---
    --- When a new gantry is created, convert the defaults in Pmblock which use WorldUnits ---
    --- to equivilents in feet                                                             ---
    local LOCunitMult = 1.0
    case units.SystemType of
    (
      #Inches      : LOCunitMult = 39.3700787
      #Feet        : LOCunitMult = 3.2808399
      #Miles       : LOCunitMult = 0.000621371192
      #Millimeters : LOCunitMult = 1000.0
      #Centimeters : LOCunitMult = 100.0
      #Meters      : LOCunitMult = 1.0
      #Kilometers  : LOCunitMult = 0.001
    )

    height     = height * LOCunitMult
    depth      = depth  * LOCunitMult
    kink1      = kink1  * LOCunitMult
    kink2      = kink2  * LOCunitMult
    dia1       = dia1   * LOCunitMult
    dia2       = dia2   * LOCunitMult
    radius     = radius * LOCunitMult
    armLen     = armLen * LOCunitMult
    headScaleX = headScaleX * LOCunitMult
    headScaleY = headScaleY * LOCunitMult
  )

	on buildMesh do
  (
    local LMSheight     = height
    local LMSdepth      = depth
    local LMSkink1      = kink1
    local LMSkink2      = kink2
    local LMSmatID      = matID
    local LMSonoff      = onoff
    local LMSdia1       = dia1
    local LMSdia2       = dia2
    local LMSradius     = radius
    local LMSarmLen     = armLen
    local LMSangle      = angle
    local LMSleftArm    = leftArm
    local LMSrightArm   = rightArm
    local LMSheadScaleX = headScaleX
    local LMSheadScaleY = headScaleY

    local vp = #()
    local fl = #()
    local fm = #()
    local fs = #()
    local fe = #()
    local he = LMSheight - 1.0
    local lgtID = (if LMSonoff then (4) else (7)) -- Whether lantern is on or off
    local rad1 = LMSdia1 / 2.0
    local rad2 = LMSdia2 / 2.0
    local hpos = LMSradius - (LMSradius * (cos LMSangle)) -- 2.478
    local vpos
    local cosArm = (cos (90 - LMSangle)) * LMSarmLen
    local sinArm = (sin (90 - LMSangle)) * LMSarmLen

    --- Index of last Vertex prior to double section
    local r = #()
    local x = #()
    local w = #()
    if LMSleftArm and LMSrightArm then
    (
      r = #(60,132) ; w = #(1.0,-1.0) ; x = #(204,301)
    )
    else
    (
      if LMSleftArm  then ((r = #(60) ; w = #(-1.0)) ; x = #(132))
      if LMSrightArm then ((r = #(60) ; w =  #(1.0)) ; x = #(132))
    )

    local LOCangleArray = #(0,LMSangle*0.25,LMSangle*0.5,LMSangle*0.75,LMSangle)                   -- Post Diameter for each section of vertices
    local mastVpos      = (sin LMSangle) * LMSradius

    --- Build Post Vertices
    local LOCvpZarray1 = #(-LMSdepth, 0.0, LMSkink1, (LMSkink1 + LMSkink2), (LMSheight - sinArm - mastVpos)) -- (he + 0.530)-- Post Section Height: Post in Ground, Ground, Post under Kink, Post above Kink
    local LOCvpZarray2 = #(rad1, rad1, rad1, rad2, rad2)                   -- Post Diameter for each section of vertices
    if w.count >= 1 then LOCvpZarray2 = #(rad1 * w[1], rad1 * w[1], rad1 * w[1], rad2 * w[1], rad2 * w[1]) else LOCvpZarray1[5] = LMSheight                  -- Post Diameter for each section of vertices
    for i = 1 to LOCvpZarray1.count do
    (
      append vp [(LOCvpZarray2[i] * -1.000),(LOCvpZarray2[i] *  0.000), LOCvpZarray1[i]] -- 114, 126, 138, 150
      append vp [(LOCvpZarray2[i] * -0.863),(LOCvpZarray2[i] *  0.504), LOCvpZarray1[i]]
      append vp [(LOCvpZarray2[i] * -0.504),(LOCvpZarray2[i] *  0.863), LOCvpZarray1[i]]
      append vp [(LOCvpZarray2[i] *  0.000),(LOCvpZarray2[i] *  1.000), LOCvpZarray1[i]]
      append vp [(LOCvpZarray2[i] *  0.504),(LOCvpZarray2[i] *  0.863), LOCvpZarray1[i]]
      append vp [(LOCvpZarray2[i] *  0.863),(LOCvpZarray2[i] *  0.504), LOCvpZarray1[i]]
      append vp [(LOCvpZarray2[i] *  1.000),(LOCvpZarray2[i] *  0.000), LOCvpZarray1[i]]
      append vp [(LOCvpZarray2[i] *  0.863),(LOCvpZarray2[i] * -0.504), LOCvpZarray1[i]]
      append vp [(LOCvpZarray2[i] *  0.504),(LOCvpZarray2[i] * -0.863), LOCvpZarray1[i]]
      append vp [(LOCvpZarray2[i] *  0.000),(LOCvpZarray2[i] * -1.000), LOCvpZarray1[i]]
      append vp [(LOCvpZarray2[i] * -0.504),(LOCvpZarray2[i] * -0.863), LOCvpZarray1[i]]
      append vp [(LOCvpZarray2[i] * -0.863),(LOCvpZarray2[i] * -0.504), LOCvpZarray1[i]]
    )

    --- Vertex data --Post Bend-------------------
    for ii = 1 to w.count do
    (
      for i = 1 to 5 do
      (
        local LOCcos = (cos (w[ii] * LOCangleArray[i])) * rad2
        local LOCsin = (sin (w[ii] * LOCangleArray[i])) * rad2
        hpos = (LMSradius - (LMSradius * (cos LOCangleArray[i]))) * w[ii]
        vpos = LMSheight - sinArm - mastVpos + ((sin LOCangleArray[i]) * LMSradius)
        append vp [hpos + (w[ii] * -1.000 * LOCcos), w[ii] * rad2 *  0.000, vpos - (w[ii] * -1.000 * LOCsin)]
        append vp [hpos + (w[ii] * -0.863 * LOCcos), w[ii] * rad2 *  0.504, vpos - (w[ii] * -0.863 * LOCsin)]
        append vp [hpos + (w[ii] * -0.504 * LOCcos), w[ii] * rad2 *  0.863, vpos - (w[ii] * -0.504 * LOCsin)]
        append vp [hpos + (w[ii] *  0.000 * LOCcos), w[ii] * rad2 *  1.000, vpos - (w[ii] *  0.000 * LOCsin)]
        append vp [hpos + (w[ii] *  0.504 * LOCcos), w[ii] * rad2 *  0.863, vpos - (w[ii] *  0.504 * LOCsin)]
        append vp [hpos + (w[ii] *  0.863 * LOCcos), w[ii] * rad2 *  0.504, vpos - (w[ii] *  0.863 * LOCsin)]
        append vp [hpos + (w[ii] *  1.000 * LOCcos), w[ii] * rad2 *  0.000, vpos - (w[ii] *  1.000 * LOCsin)]
        append vp [hpos + (w[ii] *  0.863 * LOCcos), w[ii] * rad2 * -0.504, vpos - (w[ii] *  0.863 * LOCsin)]
        append vp [hpos + (w[ii] *  0.504 * LOCcos), w[ii] * rad2 * -0.863, vpos - (w[ii] *  0.504 * LOCsin)]
        append vp [hpos + (w[ii] *  0.000 * LOCcos), w[ii] * rad2 * -1.000, vpos - (w[ii] *  0.000 * LOCsin)]
        append vp [hpos + (w[ii] * -0.504 * LOCcos), w[ii] * rad2 * -0.863, vpos - (w[ii] * -0.504 * LOCsin)]
        append vp [hpos + (w[ii] * -0.863 * LOCcos), w[ii] * rad2 * -0.504, vpos - (w[ii] * -0.863 * LOCsin)]
      )

      --- End of Horiz Arm -------------------------
      local LOCcos = (cos (w[ii] * LMSangle)) * rad2
      local LOCsin = (sin (w[ii] * LMSangle)) * rad2
      hpos = (LMSradius - (LMSradius * (cos LMSangle)) + cosArm) * w[ii]
      append vp [hpos + (w[ii] * -1.000 * LOCcos), w[ii] * rad2 *  0.000, LMSheight - (w[ii] * -1.000 * LOCsin)]
      append vp [hpos + (w[ii] * -0.863 * LOCcos), w[ii] * rad2 *  0.504, LMSheight - (w[ii] * -0.863 * LOCsin)]
      append vp [hpos + (w[ii] * -0.504 * LOCcos), w[ii] * rad2 *  0.863, LMSheight - (w[ii] * -0.504 * LOCsin)]
      append vp [hpos + (w[ii] *  0.000 * LOCcos), w[ii] * rad2 *  1.000, LMSheight - (w[ii] *  0.000 * LOCsin)]
      append vp [hpos + (w[ii] *  0.504 * LOCcos), w[ii] * rad2 *  0.863, LMSheight - (w[ii] *  0.504 * LOCsin)]
      append vp [hpos + (w[ii] *  0.863 * LOCcos), w[ii] * rad2 *  0.504, LMSheight - (w[ii] *  0.863 * LOCsin)]
      append vp [hpos + (w[ii] *  1.000 * LOCcos), w[ii] * rad2 *  0.000, LMSheight - (w[ii] *  1.000 * LOCsin)]
      append vp [hpos + (w[ii] *  0.863 * LOCcos), w[ii] * rad2 * -0.504, LMSheight - (w[ii] *  0.863 * LOCsin)]
      append vp [hpos + (w[ii] *  0.504 * LOCcos), w[ii] * rad2 * -0.863, LMSheight - (w[ii] *  0.504 * LOCsin)]
      append vp [hpos + (w[ii] *  0.000 * LOCcos), w[ii] * rad2 * -1.000, LMSheight - (w[ii] *  0.000 * LOCsin)]
      append vp [hpos + (w[ii] * -0.504 * LOCcos), w[ii] * rad2 * -0.863, LMSheight - (w[ii] * -0.504 * LOCsin)]
      append vp [hpos + (w[ii] * -0.863 * LOCcos), w[ii] * rad2 * -0.504, LMSheight - (w[ii] * -0.863 * LOCsin)]
    )

    for ii = 1 to w.count do
    (
      --- Head Vertex data ---------------------------
      hpos = LMSradius - (LMSradius * (cos LMSangle)) -- 2.478
      append vp [(hPos + cosArm + (1.01245 * LMSheadScaleX)) * w[ii],  (0.000243141  * LMSheadScaleY * w[ii]) , he + 1.0993  ] -- 1
      append vp [(hPos + cosArm + (0.98608 * LMSheadScaleX)) * w[ii],  (0.00024314   * LMSheadScaleY * w[ii]) , he + 1.1229  ]
      append vp [(hPos + cosArm + (0.98625 * LMSheadScaleX)) * w[ii],  (0.0203161    * LMSheadScaleY * w[ii]) , he + 1.1209  ]
      append vp [(hPos + cosArm + (0.98673 * LMSheadScaleX)) * w[ii],  (0.037322     * LMSheadScaleY * w[ii]) , he + 1.1154  ]
      append vp [(hPos + cosArm + (0.98747 * LMSheadScaleX)) * w[ii],  (0.0486898    * LMSheadScaleY * w[ii]) , he + 1.107   ]
      append vp [(hPos + cosArm + (1.00562 * LMSheadScaleX)) * w[ii],  (0.0526876    * LMSheadScaleY * w[ii]) , he + 1.0987  ]
      append vp [(hPos + cosArm + (1.00677 * LMSheadScaleX)) * w[ii],  (0.0486898    * LMSheadScaleY * w[ii]) , he + 1.0856  ]
      append vp [(hPos + cosArm + (1.00775 * LMSheadScaleX)) * w[ii],  (0.037322     * LMSheadScaleY * w[ii]) , he + 1.0745  ]
      append vp [(hPos + cosArm + (1.00839 * LMSheadScaleX)) * w[ii],  (0.0203161    * LMSheadScaleY * w[ii]) , he + 1.067   ]
      append vp [(hPos + cosArm + (1.00862 * LMSheadScaleX)) * w[ii],  (0.000243141  * LMSheadScaleY * w[ii]) , he + 1.0644  ]

      append vp [(hPos + cosArm + (1.00839 * LMSheadScaleX)) * w[ii],  (-0.0198222   * LMSheadScaleY * w[ii]) , he + 1.067   ] -- 11
      append vp [(hPos + cosArm + (1.00775 * LMSheadScaleX)) * w[ii],  (-0.0368281   * LMSheadScaleY * w[ii]) , he + 1.0745  ]
      append vp [(hPos + cosArm + (1.00677 * LMSheadScaleX)) * w[ii],  (-0.0481959   * LMSheadScaleY * w[ii]) , he + 1.0856  ]
      append vp [(hPos + cosArm + (1.00562 * LMSheadScaleX)) * w[ii],  (-0.0521937   * LMSheadScaleY * w[ii]) , he + 1.0987  ]
      append vp [(hPos + cosArm + (0.98747 * LMSheadScaleX)) * w[ii],  (-0.0481959   * LMSheadScaleY * w[ii]) , he + 1.107   ]
      append vp [(hPos + cosArm + (0.98673 * LMSheadScaleX)) * w[ii],  (-0.0368281   * LMSheadScaleY * w[ii]) , he + 1.1154  ]
      append vp [(hPos + cosArm + (0.98625 * LMSheadScaleX)) * w[ii],  (-0.0198222   * LMSheadScaleY * w[ii]) , he + 1.1209  ]
      append vp [(hPos + cosArm + (0.82275 * LMSheadScaleX)) * w[ii],  (0.000243129  * LMSheadScaleY * w[ii]) , he + 1.1286  ]
      append vp [(hPos + cosArm + (0.82307 * LMSheadScaleX)) * w[ii],  (0.037322     * LMSheadScaleY * w[ii]) , he + 1.125   ]
      append vp [(hPos + cosArm + (0.82395 * LMSheadScaleX)) * w[ii],  (0.0687627    * LMSheadScaleY * w[ii]) , he + 1.1147  ]

      append vp [(hPos + cosArm + (0.82531 * LMSheadScaleX)) * w[ii],  (0.0897665    * LMSheadScaleY * w[ii]) , he + 1.0993  ] -- 21
      append vp [(hPos + cosArm + (0.98619 * LMSheadScaleX)) * w[ii],  (0.0971365    * LMSheadScaleY * w[ii]) , he + 1.097   ]
      append vp [(hPos + cosArm + (0.98831 * LMSheadScaleX)) * w[ii],  (0.0897665    * LMSheadScaleY * w[ii]) , he + 1.0728  ]
      append vp [(hPos + cosArm + (0.99011 * LMSheadScaleX)) * w[ii],  (0.0687627    * LMSheadScaleY * w[ii]) , he + 1.0522  ]
      append vp [(hPos + cosArm + (0.99131 * LMSheadScaleX)) * w[ii],  (0.037322     * LMSheadScaleY * w[ii]) , he + 1.0385  ]
      append vp [(hPos + cosArm + (0.99172 * LMSheadScaleX)) * w[ii],  (0.00024314   * LMSheadScaleY * w[ii]) , he + 1.0336  ]
      append vp [(hPos + cosArm + (0.99131 * LMSheadScaleX)) * w[ii],  (-0.0368281   * LMSheadScaleY * w[ii]) , he + 1.0385  ]
      append vp [(hPos + cosArm + (0.99011 * LMSheadScaleX)) * w[ii],  (-0.0682688   * LMSheadScaleY * w[ii]) , he + 1.0522  ]
      append vp [(hPos + cosArm + (0.98831 * LMSheadScaleX)) * w[ii],  (-0.0892726   * LMSheadScaleY * w[ii]) , he + 1.0728  ]
      append vp [(hPos + cosArm + (0.98619 * LMSheadScaleX)) * w[ii],  (-0.0966426   * LMSheadScaleY * w[ii]) , he + 1.097   ]

      append vp [(hPos + cosArm + (0.82531 * LMSheadScaleX)) * w[ii],  (-0.0892726   * LMSheadScaleY * w[ii]) , he + 1.0993  ] -- 31
      append vp [(hPos + cosArm + (0.82395 * LMSheadScaleX)) * w[ii],  (-0.0682688   * LMSheadScaleY * w[ii]) , he + 1.1147  ]
      append vp [(hPos + cosArm + (0.82307 * LMSheadScaleX)) * w[ii],  (-0.0368281   * LMSheadScaleY * w[ii]) , he + 1.125   ]
      append vp [(hPos + cosArm + (0.60967 * LMSheadScaleX)) * w[ii],  (0.000243115  * LMSheadScaleY * w[ii]) , he + 1.133   ]
      append vp [(hPos + cosArm + (0.61015 * LMSheadScaleX)) * w[ii],  (0.0486898    * LMSheadScaleY * w[ii]) , he + 1.1275  ]
      append vp [(hPos + cosArm + (0.61152 * LMSheadScaleX)) * w[ii],  (0.0897664    * LMSheadScaleY * w[ii]) , he + 1.1119  ]
      append vp [(hPos + cosArm + (0.61357 * LMSheadScaleX)) * w[ii],  (0.117202     * LMSheadScaleY * w[ii]) , he + 1.0886  ]
      append vp [(hPos + cosArm + (0.9571  * LMSheadScaleX)) * w[ii],  ( 0.126838    * LMSheadScaleY * w[ii]) , he + 1.0945  ]
      append vp [(hPos + cosArm + (0.95986 * LMSheadScaleX)) * w[ii],  (0.117202     * LMSheadScaleY * w[ii]) , he + 1.0628  ]
      append vp [(hPos + cosArm + (0.96221 * LMSheadScaleX)) * w[ii],  (0.0897665    * LMSheadScaleY * w[ii]) , he + 1.0359  ]

      append vp [(hPos + cosArm + (0.96379 * LMSheadScaleX)) * w[ii],  (0.0486898    * LMSheadScaleY * w[ii]) , he + 1.018   ] -- 41
      append vp [(hPos + cosArm + (0.96435 * LMSheadScaleX)) * w[ii],  (0.000243138  * LMSheadScaleY * w[ii]) , he + 1.0117  ]
      append vp [(hPos + cosArm + (0.96379 * LMSheadScaleX)) * w[ii],  (-0.0481959   * LMSheadScaleY * w[ii]) , he + 1.018   ]
      append vp [(hPos + cosArm + (0.96221 * LMSheadScaleX)) * w[ii],  (-0.0892726   * LMSheadScaleY * w[ii]) , he + 1.0359  ]
      append vp [(hPos + cosArm + (0.95986 * LMSheadScaleX)) * w[ii],  (-0.116708    * LMSheadScaleY * w[ii]) , he + 1.0628  ]
      append vp [(hPos + cosArm + (0.9571  * LMSheadScaleX)) * w[ii],  ( -0.126351   * LMSheadScaleY * w[ii]) , he + 1.0945  ]
      append vp [(hPos + cosArm + (0.61357 * LMSheadScaleX)) * w[ii],  (-0.116708    * LMSheadScaleY * w[ii]) , he + 1.0886  ]
      append vp [(hPos + cosArm + (0.61152 * LMSheadScaleX)) * w[ii],  (-0.0892726   * LMSheadScaleY * w[ii]) , he + 1.1119  ]
      append vp [(hPos + cosArm + (0.61015 * LMSheadScaleX)) * w[ii],  (-0.0481959   * LMSheadScaleY * w[ii]) , he + 1.1275  ]
      append vp [(hPos + cosArm + (0.36888 * LMSheadScaleX)) * w[ii],  (0.000243098  * LMSheadScaleY * w[ii]) , he + 1.1152  ]

      append vp [(hPos + cosArm + (0.36939 * LMSheadScaleX)) * w[ii],  (0.0526876    * LMSheadScaleY * w[ii]) , he + 1.1093  ] -- 51
      append vp [(hPos + cosArm + (0.37087 * LMSheadScaleX)) * w[ii],  (0.0971364    * LMSheadScaleY * w[ii]) , he + 1.0924  ]
      append vp [(hPos + cosArm + (0.37309 * LMSheadScaleX)) * w[ii],  (0.126845     * LMSheadScaleY * w[ii]) , he + 1.0671  ]
      append vp [(hPos + cosArm + (0.92278 * LMSheadScaleX)) * w[ii],  (0.137275     * LMSheadScaleY * w[ii]) , he + 1.0915  ]
      append vp [(hPos + cosArm + (0.92579 * LMSheadScaleX)) * w[ii],  (0.126838     * LMSheadScaleY * w[ii]) , he + 1.0572  ]
      append vp [(hPos + cosArm + (0.92834 * LMSheadScaleX)) * w[ii],  (0.0971365    * LMSheadScaleY * w[ii]) , he + 1.0281  ]
      append vp [(hPos + cosArm + (0.93003 * LMSheadScaleX)) * w[ii],  (0.0526876    * LMSheadScaleY * w[ii]) , he + 1.0087  ]
      append vp [(hPos + cosArm + (0.93063 * LMSheadScaleX)) * w[ii],  (0.000243136  * LMSheadScaleY * w[ii]) , he + 1.0018  ]
      append vp [(hPos + cosArm + (0.93003 * LMSheadScaleX)) * w[ii],  (-0.0521937   * LMSheadScaleY * w[ii]) , he + 1.0087  ]
      append vp [(hPos + cosArm + (0.92834 * LMSheadScaleX)) * w[ii],  (-0.0966426   * LMSheadScaleY * w[ii]) , he + 1.0281  ]

      append vp [(hPos + cosArm + (0.92579  * LMSheadScaleX)) * w[ii], ( -0.126351   * LMSheadScaleY * w[ii]) , he + 1.0572  ] -- 61
      append vp [(hPos + cosArm + (0.92278  * LMSheadScaleX)) * w[ii], ( -0.136781   * LMSheadScaleY * w[ii]) , he + 1.0915  ]
      append vp [(hPos + cosArm + (0.37309  * LMSheadScaleX)) * w[ii], ( -0.126351   * LMSheadScaleY * w[ii]) , he + 1.0671  ]
      append vp [(hPos + cosArm + (0.37087  * LMSheadScaleX)) * w[ii], ( -0.0966426  * LMSheadScaleY * w[ii]) , he + 1.0924  ]
      append vp [(hPos + cosArm + (0.36939  * LMSheadScaleX)) * w[ii], ( -0.0521937  * LMSheadScaleY * w[ii]) , he + 1.1093  ]
      append vp [(hPos + cosArm + (0.1271   * LMSheadScaleX)) * w[ii], (0.000243082  * LMSheadScaleY * w[ii]) , he + 1.099   ]
      append vp [(hPos + cosArm + (0.127649 * LMSheadScaleX)) * w[ii], (0.0820455    * LMSheadScaleY * w[ii]) , he + 1.0927  ]
      append vp [(hPos + cosArm + (0.129221 * LMSheadScaleX)) * w[ii], (0.129928     * LMSheadScaleY * w[ii]) , he + 1.0747  ]
      append vp [(hPos + cosArm + (0.131571 * LMSheadScaleX)) * w[ii], (0.131682     * LMSheadScaleY * w[ii]) , he + 1.0478  ]
      append vp [(hPos + cosArm + (0.134348 * LMSheadScaleX)) * w[ii], (0.126845     * LMSheadScaleY * w[ii]) , he + 1.0161  ]

      append vp [(hPos + cosArm + (0.13711  * LMSheadScaleX)) * w[ii], ( 0.117202    * LMSheadScaleY * w[ii]) , he + 0.9844  ] -- 71
      append vp [(hPos + cosArm + (0.13946  * LMSheadScaleX)) * w[ii], ( 0.0897664   * LMSheadScaleY * w[ii]) , he + 0.9576  ]
      append vp [(hPos + cosArm + (0.141031 * LMSheadScaleX)) * w[ii], (0.0486897    * LMSheadScaleY * w[ii]) , he + 0.9396  ]
      append vp [(hPos + cosArm + (0.141596 * LMSheadScaleX)) * w[ii], (0.000243083  * LMSheadScaleY * w[ii]) , he + 0.9333  ]
      append vp [(hPos + cosArm + (0.141031 * LMSheadScaleX)) * w[ii], (-0.0481959   * LMSheadScaleY * w[ii]) , he + 0.9396  ]
      append vp [(hPos + cosArm + (0.13946  * LMSheadScaleX)) * w[ii], ( -0.0892726  * LMSheadScaleY * w[ii]) , he + 0.9576  ]
      append vp [(hPos + cosArm + (0.13711  * LMSheadScaleX)) * w[ii], ( -0.116708   * LMSheadScaleY * w[ii]) , he + 0.9844  ]
      append vp [(hPos + cosArm + (0.134348 * LMSheadScaleX)) * w[ii], (-0.126351    * LMSheadScaleY * w[ii]) , he + 1.0161  ]
      append vp [(hPos + cosArm + (0.131571 * LMSheadScaleX)) * w[ii], (-0.131189    * LMSheadScaleY * w[ii]) , he + 1.0478  ]
      append vp [(hPos + cosArm + (0.129221 * LMSheadScaleX)) * w[ii], (-0.129434    * LMSheadScaleY * w[ii]) , he + 1.0747  ]

      append vp [(hPos + cosArm + (0.127649 * LMSheadScaleX)) * w[ii], (-0.0815517   * LMSheadScaleY * w[ii]) , he + 1.0927  ] -- 81
      append vp [(hPos + cosArm + (0.097941 * LMSheadScaleX)) * w[ii], (0.00024308   * LMSheadScaleY * w[ii]) , he + 1.0971  ]
      append vp [(hPos + cosArm + (0.098505 * LMSheadScaleX)) * w[ii], (0.0821218    * LMSheadScaleY * w[ii]) , he + 1.0908  ]
      append vp [(hPos + cosArm + (0.100092 * LMSheadScaleX)) * w[ii], (0.129928     * LMSheadScaleY * w[ii]) , he + 1.0727  ]
      append vp [(hPos + cosArm + (0.102457 * LMSheadScaleX)) * w[ii], (0.131461     * LMSheadScaleY * w[ii]) , he + 1.0456  ]
      append vp [(hPos + cosArm + (0.106119 * LMSheadScaleX)) * w[ii], (0.126281     * LMSheadScaleY * w[ii]) , he + 1.0036  ]
      append vp [(hPos + cosArm + (0.108927 * LMSheadScaleX)) * w[ii], (0.116691     * LMSheadScaleY * w[ii]) , he + 0.9717  ]
      append vp [(hPos + cosArm + (0.111292 * LMSheadScaleX)) * w[ii], (0.0893697    * LMSheadScaleY * w[ii]) , he + 0.9446  ]
      append vp [(hPos + cosArm + (0.112223 * LMSheadScaleX)) * w[ii], (0.0484761    * LMSheadScaleY * w[ii]) , he + 0.9339  ]
      append vp [(hPos + cosArm + (0.112223 * LMSheadScaleX)) * w[ii], (0.000243081  * LMSheadScaleY * w[ii]) , he + 0.9339  ]

      append vp [(hPos + cosArm + (0.112223 * LMSheadScaleX)) * w[ii], (-0.0479823   * LMSheadScaleY * w[ii]) , he + 0.9339  ] -- 91
      append vp [(hPos + cosArm + (0.111292 * LMSheadScaleX)) * w[ii], (-0.0888759   * LMSheadScaleY * w[ii]) , he + 0.9446  ]
      append vp [(hPos + cosArm + (0.108927 * LMSheadScaleX)) * w[ii], (-0.116197    * LMSheadScaleY * w[ii]) , he + 0.9717  ]
      append vp [(hPos + cosArm + (0.106119 * LMSheadScaleX)) * w[ii], (-0.125787    * LMSheadScaleY * w[ii]) , he + 1.0036  ]
      append vp [(hPos + cosArm + (0.102457 * LMSheadScaleX)) * w[ii], (-0.130967    * LMSheadScaleY * w[ii]) , he + 1.0456  ]
      append vp [(hPos + cosArm + (0.100092 * LMSheadScaleX)) * w[ii], (-0.129434    * LMSheadScaleY * w[ii]) , he + 1.0727  ]
      append vp [(hPos + cosArm + (0.098505 * LMSheadScaleX)) * w[ii], (-0.081628    * LMSheadScaleY * w[ii]) , he + 1.0908  ] -- 97
    )
    -- Below Ground Level
    append fl [13,14, 1]  ; append fm 3     ; append fs 3    ; append fe #(true, false, false)
    append fl [14, 2, 1]  ; append fm 3     ; append fs 3    ; append fe #(false, true, false)
    append fl [14,15, 2]  ; append fm 3     ; append fs 3    ; append fe #(true, false, false)
    append fl [15, 3, 2]  ; append fm 3     ; append fs 3    ; append fe #(false, true, false)
    append fl [15,16, 3]  ; append fm 3     ; append fs 3    ; append fe #(true, false, false)
    append fl [16, 4, 3]  ; append fm 3     ; append fs 3    ; append fe #(false, true, false)
    append fl [16,17, 4]  ; append fm 3     ; append fs 3    ; append fe #(true, false, false)
    append fl [17, 5, 4]  ; append fm 3     ; append fs 3    ; append fe #(false, true, false)
    append fl [17,18, 5]  ; append fm 3     ; append fs 3    ; append fe #(true, false, false)
    append fl [18, 6, 5]  ; append fm 3     ; append fs 3    ; append fe #(false, true, false)
    append fl [18,19, 6]  ; append fm 3     ; append fs 3    ; append fe #(true, false, false)
    append fl [19, 7, 6]  ; append fm 3     ; append fs 3    ; append fe #(false, true, false) -- Depth Leg Edge One True/False
    append fl [19,20, 7]  ; append fm 3     ; append fs 3    ; append fe #(true, false, false)
    append fl [20, 8, 7]  ; append fm 3     ; append fs 3    ; append fe #(false, true, false)
    append fl [20,21, 8]  ; append fm 3     ; append fs 3    ; append fe #(true, false, false)
    append fl [21, 9, 8]  ; append fm 3     ; append fs 3    ; append fe #(false, true, false)
    append fl [21,22, 9]  ; append fm 3     ; append fs 3    ; append fe #(true, false, false)
    append fl [22,10, 9]  ; append fm 3     ; append fs 3    ; append fe #(false, true, false)
    append fl [22,23,10]  ; append fm 3     ; append fs 3    ; append fe #(true, false, false)
    append fl [23,11,10]  ; append fm 3     ; append fs 3    ; append fe #(false, true, false)
    append fl [23,24,11]  ; append fm 3     ; append fs 3    ; append fe #(true, false, false)
    append fl [24,12,11]  ; append fm 3     ; append fs 3    ; append fe #(false, true, false)
    append fl [24,13,12]  ; append fm 3     ; append fs 3    ; append fe #(true, false, false)
    append fl [13, 1,12]  ; append fm 3     ; append fs 3    ; append fe #(false, true, false) -- Depth Leg Edge One True/False
    -- Lower Ma
    append fl [25,26,13]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, false, true)
    append fl [26,14,13]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, true, false)
    append fl [26,27,14]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, false, true)
    append fl [27,15,14]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, true, false)
    append fl [27,28,15]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, false, true)
    append fl [28,16,15]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, true, false)
    append fl [28,29,16]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, false, true)
    append fl [29,17,16]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, true, false)
    append fl [29,30,17]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, false, true)
    append fl [30,18,17]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, true, false)
    append fl [30,31,18]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, false, true)
    append fl [31,19,18]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, true, false)
    append fl [31,32,19]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, false, true)
    append fl [32,20,19]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, true, false)
    append fl [32,33,20]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, false, true)
    append fl [33,21,20]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, true, false)
    append fl [33,34,21]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, false, true)
    append fl [34,22,21]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, true, false)
    append fl [34,35,22]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, false, true)
    append fl [35,23,22]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, true, false)
    append fl [35,36,23]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, false, true)
    append fl [36,24,23]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, true, false)
    append fl [36,25,24]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, false, true)
    append fl [25,13,24]  ; append fm LMSmatID ; append fs 4    ; append fe #(true, true, false)
    -- Taper Section
    append fl [37,38,25]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, false, true)
    append fl [38,26,25]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, true, false)
    append fl [38,39,26]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, false, true)
    append fl [39,27,26]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, true, false)
    append fl [39,40,27]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, false, true)
    append fl [40,28,27]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, true, false)
    append fl [40,41,28]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, false, true)
    append fl [41,29,28]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, true, false)
    append fl [41,42,29]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, false, true)
    append fl [42,30,29]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, true, false)
    append fl [42,43,30]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, false, true)
    append fl [43,31,30]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, true, false)
    append fl [43,44,31]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, false, true)
    append fl [44,32,31]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, true, false)
    append fl [44,45,32]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, false, true)
    append fl [45,33,32]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, true, false)
    append fl [45,46,33]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, false, true)
    append fl [46,34,33]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, true, false)
    append fl [46,47,34]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, false, true)
    append fl [47,35,34]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, true, false)
    append fl [47,48,35]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, false, true)
    append fl [48,36,35]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, true, false)
    append fl [48,37,36]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, false, true)
    append fl [37,25,36]  ; append fm LMSmatID ; append fs 16    ; append fe #(true, true, false)
    -- Upper St        ole Section
    append fl [49,50,37]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, false, true)
    append fl [50,38,37]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, true, false)
    append fl [50,51,38]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, false, true)
    append fl [51,39,38]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, true, false)
    append fl [51,52,39]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, false, true)
    append fl [52,40,39]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, true, false)
    append fl [52,53,40]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, false, true)
    append fl [53,41,40]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, true, false)
    append fl [53,54,41]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, false, true)
    append fl [54,42,41]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, true, false)
    append fl [54,55,42]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, false, true)
    append fl [55,43,42]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, true, false)
    append fl [55,56,43]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, false, true)
    append fl [56,44,43]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, true, false)
    append fl [56,57,44]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, false, true)
    append fl [57,45,44]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, true, false)
    append fl [57,58,45]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, false, true)
    append fl [58,46,45]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, true, false)
    append fl [58,59,46]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, false, true)
    append fl [59,47,46]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, true, false)
    append fl [59,60,47]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, false, true)
    append fl [60,48,47]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, true, false)
    append fl [60,49,48]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, false, true)
    append fl [49,37,48]  ; append fm LMSmatID ; append fs 6    ; append fe #(true, true, false)
    -- Next Section

    for i = 1 to r.count do
    (
      q = r[i]
      y = x[i]
      append fl [q + 13, q + 14, q +  1]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 14, q +  2, q +  1]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 14, q + 15, q +  2]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 15, q +  3, q +  2]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 15, q + 16, q +  3]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 16, q +  4, q +  3]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 16, q + 17, q +  4]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 17, q +  5, q +  4]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 17, q + 18, q +  5]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 18, q +  6, q +  5]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 18, q + 19, q +  6]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 19, q +  7, q +  6]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 19, q + 20, q +  7]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 20, q +  8, q +  7]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 20, q + 21, q +  8]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 21, q +  9, q +  8]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 21, q + 22, q +  9]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 22, q + 10, q +  9]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 22, q + 23, q + 10]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 23, q + 11, q + 10]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 23, q + 24, q + 11]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 24, q + 12, q + 11]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 24, q + 13, q + 12]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 13, q +  1, q + 12]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 25, q + 26, q + 13]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 26, q + 14, q + 13]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 26, q + 27, q + 14]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 27, q + 15, q + 14]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 27, q + 28, q + 15]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 28, q + 16, q + 15]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 28, q + 29, q + 16]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 29, q + 17, q + 16]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 29, q + 30, q + 17]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 30, q + 18, q + 17]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 30, q + 31, q + 18]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 31, q + 19, q + 18]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 31, q + 32, q + 19]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 32, q + 20, q + 19]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 32, q + 33, q + 20]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 33, q + 21, q + 20]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 33, q + 34, q + 21]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 34, q + 22, q + 21]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 34, q + 35, q + 22]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 35, q + 23, q + 22]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 35, q + 36, q + 23]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 36, q + 24, q + 23]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 36, q + 25, q + 24]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 25, q + 13, q + 24]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 37, q + 38, q + 25]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 38, q + 26, q + 25]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 38, q + 39, q + 26]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 39, q + 27, q + 26]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 39, q + 40, q + 27]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 40, q + 28, q + 27]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 40, q + 41, q + 28]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 41, q + 29, q + 28]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 41, q + 42, q + 29]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 42, q + 30, q + 29]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 42, q + 43, q + 30]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 43, q + 31, q + 30]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 43, q + 44, q + 31]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 44, q + 32, q + 31]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 44, q + 45, q + 32]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 45, q + 33, q + 32]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 45, q + 46, q + 33]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 46, q + 34, q + 33]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 46, q + 47, q + 34]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 47, q + 35, q + 34]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 47, q + 48, q + 35]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 48, q + 36, q + 35]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 48, q + 37, q + 36]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 37, q + 25, q + 36]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 49, q + 50, q + 37]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 50, q + 38, q + 37]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 50, q + 51, q + 38]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 51, q + 39, q + 38]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 51, q + 52, q + 39]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 52, q + 40, q + 39]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 52, q + 53, q + 40]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 53, q + 41, q + 40]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 53, q + 54, q + 41]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 54, q + 42, q + 41]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 54, q + 55, q + 42]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 55, q + 43, q + 42]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 55, q + 56, q + 43]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 56, q + 44, q + 43]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 56, q + 57, q + 44]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 57, q + 45, q + 44]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 57, q + 58, q + 45]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 58, q + 46, q + 45]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 58, q + 59, q + 46]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 59, q + 47, q + 46]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 59, q + 60, q + 47]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 60, q + 48, q + 47]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      append fl [q + 60, q + 49, q + 48]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, false, true)
      append fl [q + 49, q + 37, q + 48]  ; append fm LMSmatID ; append fs 8    ; append fe #(true, true, false)
      --- Arms
      append fl [q + 61, q + 62, q + 49]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, false, true)
      append fl [q + 62, q + 50, q + 49]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, true, false)
      append fl [q + 62, q + 63, q + 50]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, false, true)
      append fl [q + 63, q + 51, q + 50]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, true, false)
      append fl [q + 63, q + 64, q + 51]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, false, true)
      append fl [q + 64, q + 52, q + 51]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, true, false)
      append fl [q + 64, q + 65, q + 52]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, false, true)
      append fl [q + 65, q + 53, q + 52]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, true, false)
      append fl [q + 65, q + 66, q + 53]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, false, true)
      append fl [q + 66, q + 54, q + 53]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, true, false)
      append fl [q + 66, q + 67, q + 54]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, false, true)
      append fl [q + 67, q + 55, q + 54]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, true, false)
      append fl [q + 67, q + 68, q + 55]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, false, true)
      append fl [q + 68, q + 56, q + 55]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, true, false)
      append fl [q + 68, q + 69, q + 56]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, false, true)
      append fl [q + 69, q + 57, q + 56]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, true, false)
      append fl [q + 69, q + 70, q + 57]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, false, true)
      append fl [q + 70, q + 58, q + 57]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, true, false)
      append fl [q + 70, q + 71, q + 58]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, false, true)
      append fl [q + 71, q + 59, q + 58]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, true, false)
      append fl [q + 71, q + 72, q + 59]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, false, true)
      append fl [q + 72, q + 60, q + 59]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, true, false)
      append fl [q + 72, q + 61, q + 60]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, false, true)
      append fl [q + 61, q + 49, q + 60]  ; append fm LMSmatID ; append fs 10    ; append fe #(true, true, false)

      --- Head
      append fl [y +  3, y +  2, y +  1]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, true)
      append fl [y +  4, y +  3, y +  1]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, true)
      append fl [y +  5, y +  4, y +  1]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, true)
      append fl [y +  6, y +  5, y +  1]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, true)
      append fl [y +  7, y +  6, y +  1]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, true)
      append fl [y +  8, y +  7, y +  1]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, true)
      append fl [y +  9, y +  8, y +  1]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, true)
      append fl [y + 10, y +  9, y +  1]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, true)
      append fl [y + 11, y + 10, y +  1]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, true)
      append fl [y + 12, y + 11, y +  1]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, true)
      append fl [y + 13, y + 12, y +  1]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, true)
      append fl [y + 14, y + 13, y +  1]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, true)
      append fl [y + 15, y + 14, y +  1]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, true)
      append fl [y + 16, y + 15, y +  1]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, true)
      append fl [y + 17, y + 16, y +  1]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, true)
      append fl [y +  2, y + 17, y +  1]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, true)
      append fl [y + 19, y + 18, y +  2]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y +  3, y + 19, y +  2]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 20, y + 19, y +  3]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y +  4, y + 20, y +  3]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 21, y + 20, y +  4]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y +  5, y + 21, y +  4]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 22, y + 21, y +  5]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y +  6, y + 22, y +  5]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 23, y + 22, y +  6]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y +  7, y + 23, y +  6]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 24, y + 23, y +  7]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y +  8, y + 24, y +  7]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 25, y + 24, y +  8]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y +  9, y + 25, y +  8]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 26, y + 25, y +  9]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 10, y + 26, y +  9]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 27, y + 26, y + 10]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 11, y + 27, y + 10]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 28, y + 27, y + 11]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 12, y + 28, y + 11]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 29, y + 28, y + 12]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 13, y + 29, y + 12]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 30, y + 29, y + 13]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 14, y + 30, y + 13]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 31, y + 30, y + 14]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 15, y + 31, y + 14]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 32, y + 31, y + 15]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 16, y + 32, y + 15]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 33, y + 32, y + 16]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 17, y + 33, y + 16]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 18, y + 33, y + 17]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y +  2, y + 18, y + 17]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 35, y + 34, y + 18]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 19, y + 35, y + 18]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 36, y + 35, y + 19]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 20, y + 36, y + 19]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 37, y + 36, y + 20]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 21, y + 37, y + 20]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 38, y + 37, y + 21]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 22, y + 38, y + 21]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 39, y + 38, y + 22]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 23, y + 39, y + 22]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 40, y + 39, y + 23]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 24, y + 40, y + 23]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 41, y + 40, y + 24]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 25, y + 41, y + 24]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 42, y + 41, y + 25]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 26, y + 42, y + 25]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 43, y + 42, y + 26]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 27, y + 43, y + 26]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 44, y + 43, y + 27]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 28, y + 44, y + 27]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 45, y + 44, y + 28]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 29, y + 45, y + 28]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 46, y + 45, y + 29]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 30, y + 46, y + 29]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 47, y + 46, y + 30]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 31, y + 47, y + 30]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 48, y + 47, y + 31]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 32, y + 48, y + 31]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 49, y + 48, y + 32]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 33, y + 49, y + 32]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 34, y + 49, y + 33]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 18, y + 34, y + 33]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 51, y + 50, y + 34]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 35, y + 51, y + 34]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 52, y + 51, y + 35]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 36, y + 52, y + 35]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 53, y + 52, y + 36]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 37, y + 53, y + 36]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 54, y + 53, y + 37]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 38, y + 54, y + 37]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 55, y + 54, y + 38]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 39, y + 55, y + 38]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 56, y + 55, y + 39]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 40, y + 56, y + 39]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 57, y + 56, y + 40]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 41, y + 57, y + 40]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 58, y + 57, y + 41]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 42, y + 58, y + 41]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 59, y + 58, y + 42]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 43, y + 59, y + 42]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 60, y + 59, y + 43]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 44, y + 60, y + 43]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 61, y + 60, y + 44]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 45, y + 61, y + 44]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 62, y + 61, y + 45]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 46, y + 62, y + 45]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 63, y + 62, y + 46]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 47, y + 63, y + 46]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 64, y + 63, y + 47]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 48, y + 64, y + 47]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 65, y + 64, y + 48]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 49, y + 65, y + 48]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 50, y + 65, y + 49]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 34, y + 50, y + 49]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 67, y + 66, y + 50]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 51, y + 67, y + 50]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 68, y + 67, y + 51]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 52, y + 68, y + 51]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 69, y + 68, y + 52]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 53, y + 69, y + 52]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 70, y + 69, y + 53]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 54, y + 70, y + 53]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 71, y + 70, y + 54]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 55, y + 71, y + 54]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 72, y + 71, y + 55]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 56, y + 72, y + 55]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 73, y + 72, y + 56]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 57, y + 73, y + 56]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 74, y + 73, y + 57]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 58, y + 74, y + 57]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 75, y + 74, y + 58]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 59, y + 75, y + 58]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 76, y + 75, y + 59]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 60, y + 76, y + 59]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 77, y + 76, y + 60]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 61, y + 77, y + 60]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 78, y + 77, y + 61]     ; append fm lgtID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 62, y + 78, y + 61]     ; append fm lgtID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 79, y + 78, y + 62]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 63, y + 79, y + 62]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 80, y + 79, y + 63]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 64, y + 80, y + 63]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 81, y + 80, y + 64]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 65, y + 81, y + 64]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 66, y + 81, y + 65]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 50, y + 66, y + 65]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 83, y + 82, y + 66]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 67, y + 83, y + 66]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 84, y + 83, y + 67]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 68, y + 84, y + 67]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 85, y + 84, y + 68]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 69, y + 85, y + 68]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 86, y + 85, y + 69]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 70, y + 86, y + 69]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 87, y + 86, y + 70]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 71, y + 87, y + 70]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 88, y + 87, y + 71]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 72, y + 88, y + 71]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 89, y + 88, y + 72]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 73, y + 89, y + 72]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 90, y + 89, y + 73]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 74, y + 90, y + 73]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 91, y + 90, y + 74]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 75, y + 91, y + 74]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 92, y + 91, y + 75]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 76, y + 92, y + 75]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 93, y + 92, y + 76]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 77, y + 93, y + 76]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 94, y + 93, y + 77]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 78, y + 94, y + 77]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 95, y + 94, y + 78]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 79, y + 95, y + 78]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 96, y + 95, y + 79]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 80, y + 96, y + 79]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 97, y + 96, y + 80]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 81, y + 97, y + 80]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [y + 82, y + 97, y + 81]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 66, y + 82, y + 81]     ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)

      -- Back Ring of Head
      append fl [q + 62,q + 61,y + 82]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 83,q + 62,y + 82]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [q + 63,q + 62,y + 83]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 84,q + 63,y + 83]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [q + 64,q + 63,y + 84]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 85,q + 64,y + 84]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [q + 64,q + 64,y + 85]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 86,q + 64,y + 85]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [q + 65,q + 64,y + 86]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 87,q + 65,y + 86]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [q + 65,q + 65,y + 87]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 88,q + 65,y + 87]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [q + 66,q + 65,y + 88]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 89,q + 66,y + 88]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [q + 67,q + 66,y + 89]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 90,q + 67,y + 89]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)

      append fl [q + 68,q + 67,y + 91]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 91,q + 67,y + 90]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [q + 69,q + 68,y + 92]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 92,q + 68,y + 91]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [q + 69,q + 69,y + 93]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 93,q + 69,y + 92]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [q + 70,q + 69,y + 94]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 94,q + 69,y + 93]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [q + 70,q + 70,y + 95]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 95,q + 70,y + 94]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [q + 71,q + 70,y + 96]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 96,q + 70,y + 95]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [q + 72,q + 71,y + 97]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 97,q + 71,y + 96]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)
      append fl [q + 61,q + 72,y + 82]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, true, false)
      append fl [y + 82,q + 72,y + 97]   ; append fm LMSmatID ; append fs 1    ; append fe #(true, false, true)


    )

    setMesh mesh vertices:vp faces:fl materialIDs:fm
    for i = 1 to fl.count do
    (
      setFaceSmoothGroup mesh i fs[i]
      for j = 1 to 3 do (setEdgeVis mesh i j fe[i][j])
    )
  ) -- end on buildmesh

  tool create prompt:~PLUGIN_CIVILLAMP_PROMPT~
  (
    on mousePoint click do
    (
      case click of
      (
        1: nodeTM.translation = gridPoint
        2: #stop
      )
    )
  ) -- end create tool
) -- end plugin
-- This plugin should be permanently invisible to the UI
plugin shape CivilView_Pipe name:~PLUGIN_CIVILPIPE_NAME~ category:~PLUGIN_CIVILPIPE_CATEGORY~ classID:#(0x570b3e4f, 0x5d8cdb4a) extends:splineshape invisible:true
(
  parameters main
  (
    DisplayName            type:#string  animatable:false default:""
    Description            type:#string  animatable:false default:""
    PartDescription        type:#string  animatable:false default:""
    PartSizeName           type:#string  animatable:false default:""
    PartSubType            type:#string  animatable:false default:""
    StartStructureHandle   type:#string  animatable:false default:""
    EndStructureHandle     type:#string  animatable:false default:""

    HORType                type:#integer animatable:false default:0   -- (Centerline = 0; Crown = 1; Invert = 2)
    PSEType                type:#integer animatable:false default:0   -- (Curved = 0; Flex = 1; Segmented = 2; Straight = 3)
    FlowDirection          type:#integer animatable:false default:0   -- (Bidirectional = 0; EndToStart = 1; StartToEnd = 2;
    FlowDirectionMethod    type:#integer animatable:false default:0   -- (Bidirectional = 0; BySlope = 1; EndToStart = 2; StartToEnd = 3)
    CrossSectionalShape    type:#integer animatable:false default:0   -- (Undefined = 0; Arched = 1; Circular = 2; CustomShape = 3; EggShaped = 4; Elliptical = 5; HorizontalElliptical = 6; Rectangular = 7)

    Bearing                type:#float   animatable:false default:0.0
    Radius                 type:#float   animatable:false default:0.0
    Slope                  type:#float   animatable:false default:0.0
    InnerDiameterOrWidth   type:#float   animatable:false default:0.0
    InnerHeight            type:#float   animatable:false default:0.0
    OuterDiameterOrWidth   type:#float   animatable:false default:0.0
    OuterHeight            type:#float   animatable:false default:0.0
    MinimumCover           type:#float   animatable:false default:0.0
    MaximumCover           type:#float   animatable:false default:0.0
    Length2DCenterToCenter type:#float   animatable:false default:0.0
    Length3DCenterToCenter type:#float   animatable:false default:0.0
    Length2DToInsideEdge   type:#float   animatable:false default:0.0
    Length3DToInsideEdge   type:#float   animatable:false default:0.0
  )
)

-- infoOverlay v0.6
-- for 3ds max 8 - (c) 2006 by M. Breidt (martin@breidt.net)
--
-- New in 0.6: Image overlay
-- New in 0.5: Camera Name element, option for short filename
-- New in 0.4: some UI cosmetics; new text element: render time of last frame
-- New in 0.3: SMPTE support; additional text in top center
-- New in 0.2: Font Scale option; better error handling when font is missing
--
-- Useage: Apply the effect to your scene and render
--     Check/uncheck the individual overlay items to show/hide them:
--
--     Frame Number:      Displays the current frame number, padded with zeros
--          Padding:      Number of digits for the frame number
--          As SMPTE:     Display frame number in SMPTE format
--     File Name:         Displays the full path and filename
--     Date/Time:         Displays the system time at rendering time (affected by
--                        your machine's country/language settings)
--     User/Machine Name: Displays the Windows user and computer name
--     Render Time:       Displays the render time in seconds for the current frame
--     Camera Name:       Displays the name of the camera/view being rendered
--
--     Draw Frame:        Draw a rectangular frame (e.g. safe regions) using frame color
--       H/V:             Horizontal/vertical size of frame
--       L:               Lock vertical size to horizontal
--       Percent/Pixels:  Specifies whether the frame size H/V is a percentage of the image size or absolute pixels
--       Frame Color:     Line color of the frame
--       Mask Frame:      Darken image outside of frame (slow)
--       Draw Center:     Draw a center cross using the frame color
--
--     Bottom Text:       Displays any additional text you enter in the textbox next
--                        to the checkbox; if the "S" button at the end of the
--                        textbox is active, the entered text is evaluated as
--                        MAXScript and the result is displayed.
--                        Some useful MAXScript commands/expressions:
--                           frameRate      -- displays the current FPS
--                           rendOutputFilename -- displays the current render file name
--                           renderWidth        -- width of the rendered image in pixels
--                           renderHeight       -- height of the rendered image in pixels
--                           renderPixelAspect  -- pixel aspect of the rendered image
--                           objects.count      -- number of objects in the scene
--     Top Text:          Displays additional text
--
--     Font Scale:        Simple maginification factor for the font, useful for highres renderings
--     Dim Background:    Controls whether the text is on a darkened backgroud
--     Alpha Blend:       Controls whether the text has transparent background.
--
--     Use Image Overlay: Enables simple image compositing, e.g. for watermarking
--       Image:           Lets you select the image file
--       X/Y Pos:         Shift the image by x/y pixels to the right/down
--       Transfer Mode:   Compositing style as in Photoshop
--       Opacity:         Total opacity of the image overlay
--
-- Useful comment by scriptspot user dmmd123:
-- -- If you are doing a sun study and want to put the time of day on the frame paste this code into the Additional text, bottom field:
-- (int($Daylight01[3].object.value/3600.0)) as string + ":" + formattedPrint (int(($Daylight01[3].object.value - int($Daylight01[3].object.value/3600.0)*3600.0)/60.0)) format:"02.2d"
-- -- Change all the Daylight01's to whatever you have named your sun.

plugin renderEffect dSightRender name:~PLUGIN_CIVILSIGHTRENDER_NAME~ classID:#(0x78ad3df2, 0x2666d186) invisible:(not DYNcreatable)
(
  --- check whether font is present and load if not
  fn DYNFUNloadSightToolFont =
  (
    global DYNsightToolFont
    if DYNsightToolFont == undefined then
    (
      /*
       Generate letters (minChar = 32, maxChar = 127)
       Example: DYNsightToolFont.count = number of letters in this array
                DYNsightToolFont[65].count = number of lines in this character
                DYNsightToolFont[65][1].count = number of pixels in this character's first line
                * loading the font: DYNsightToolFont = fileIn fontFilename
                * writing the first pixel line: setPixels myBitmap [x,y] DYNsightToolFont[65][1]
      */

      DYNsightToolFont = #( \
        #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), #(), \
        -- letter 32 (' ') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 33 ('!') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 34 ('"') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 35 ('#') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 36 ('$') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 37 ('%') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 38 ('&') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 39 (''') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 40 ('(') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)) \
        ), \
        -- letter 41 (')') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)) \
        ), \
        -- letter 42 ('*') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 43 ('+') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 44 (',') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 45 ('-') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 46 ('.') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 47 ('/') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 48 ('0') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 49 ('1') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 50 ('2') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 51 ('3') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 52 ('4') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 53 ('5') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 54 ('6') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 55 ('7') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 56 ('8') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 57 ('9') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 58 (':') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 59 (';') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 60 ('<') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 61 ('=') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 62 ('>') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 63 ('?') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 64 ('@') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 65 ('A') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 66 ('B') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 67 ('C') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 68 ('D') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 69 ('E') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 70 ('F') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 71 ('G') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 72 ('H') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 73 ('I') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 74 ('J') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 75 ('K') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 76 ('L') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 77 ('M') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 78 ('N') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 79 ('O') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 80 ('P') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 81 ('Q') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 82 ('R') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 83 ('S') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 84 ('T') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 85 ('U') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 86 ('V') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 87 ('W') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 88 ('X') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 89 ('Y') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 90 ('Z') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 91 ('[') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255)) \
        ), \
        -- letter 92 ('\') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 93 (']') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255)) \
        ), \
        -- letter 94 ('^') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 95 ('_') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)) \
        ), \
        -- letter 96 ('`') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 97 ('a') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 98 ('b') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 99 ('c') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 100 ('d') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 101 ('e') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 102 ('f') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 103 ('g') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)) \
        ), \
        -- letter 104 ('h') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 105 ('i') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 106 ('j') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)) \
        ), \
        -- letter 107 ('k') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 108 ('l') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 109 ('m') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 110 ('n') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 111 ('o') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 112 ('p') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 113 ('q') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)) \
        ), \
        -- letter 114 ('r') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 115 ('s') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 116 ('t') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 117 ('u') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 118 ('v') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 119 ('w') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 120 ('x') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 121 ('y') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 122 ('z') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 123 ('{') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 124 ('|') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 125 ('}') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 126 ('~') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255)), \
        #((color 0 0 0 0), (color 255 255 255), (color 0 0 0 0), (color 0 0 0 0), (color 255 255 255), (color 255 255 255), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ), \
        -- letter 127 ('') \
        #( \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 255 255 255), (color 0 0 0 0), (color 255 255 255)), \
        #((color 255 255 255), (color 0 0 0 0), (color 255 255 255)), \
        #((color 255 255 255), (color 0 0 0 0), (color 255 255 255)), \
        #((color 255 255 255), (color 0 0 0 0), (color 255 255 255)), \
        #((color 255 255 255), (color 0 0 0 0), (color 255 255 255)), \
        #((color 255 255 255), (color 0 0 0 0), (color 255 255 255)), \
        #((color 255 255 255), (color 255 255 255), (color 255 255 255)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)), \
        #((color 0 0 0 0), (color 0 0 0 0), (color 0 0 0 0)) \
        ) \
        )

		)
		return true
	)

  fn DYNFUNcalculateChainage FUNpercent FUNpath FUNspline =
  (
    local LOCchainage    = 0.0
    if isValidNode FUNpath then
    (
      local LOCcurveLength = curveLength FUNpath FUNspline
      if FUNpercent > 0.0 then
      (
        LOCchainage = (FUNpercent - (floor FUNpercent)) * LOCcurveLength
      )
      if FUNpercent < 0.0 then
      (
        LOCchainage = (((floor FUNpercent) - FUNpercent) * -1) * LOCcurveLength
      )
    )
    LOCchainage -- return value
  )

  --- write letter 'ch' into bitmap 'FUNframe' at position 'chPos' and return [width, height] of char
  fn DYNFUNprintLetter FUNframe chPos ch FUNalpha FUNfontScale =
  (
    if not DYNFUNloadSightToolFont () then return [0,0]

    local LOCcharNum = bit.charAsInt ch
    if (LOCcharNum < 1) or (LOCcharNum > DYNsightToolFont.count) or (DYNsightToolFont[LOCcharNum].count == 0) then LOCcharNum = 127

    for i = 1 to DYNsightToolFont[LOCcharNum].count do
    (
      --- write letter line by line
      if FUNalpha then
      (
        --- perform alpha blending
        local LOCsl = getPixels FUNframe (chPos + ([0,i] * FUNfontScale)) (DYNsightToolFont[LOCcharNum][i].count * FUNfontScale)
        if LOCsl == undefined then
        (
          format (~PLUGIN_CIVILSIGHTRENDER_WARNING1~ + "\n")
        )
        else
        (
          for p = 1 to LOCsl.count do
          (
            local LOCpixl = ((p - 1) / FUNfontScale) + 1
            local LOCa = (DYNsightToolFont[LOCcharNum][i][LOCpixl].alpha) / 255.0
            LOCsl[p] = (1 - LOCa) * LOCsl[p] + LOCa * DYNsightToolFont[LOCcharNum][i][LOCpixl]
					)

          for l = 0 to (FUNfontScale - 1) do setPixels FUNframe (chPos + ([0,i] * FUNfontScale) + [0,l]) LOCsl -- write out scanline (repeat for multiple lines if needed by FUNfontScale)
				)
      )
      else
      (
        setPixels FUNframe (chPos+[0,i]) DYNsightToolFont[LOCcharNum][i] -- overwrite values; fast but no FUNfontScale
			)
		)
    return [DYNsightToolFont[LOCcharNum][1].count * FUNfontScale, DYNsightToolFont[LOCcharNum].count * FUNfontScale]
	)

  --- write entire string into bitmap
  fn DYNFUNprintString FUNframe FUNstrPos FUNstr FUNalpha FUNfontScale =
  (
    for i = 1 to FUNstr.count do
    (
      chSize = DYNFUNprintLetter FUNframe FUNstrPos FUNstr[i] FUNalpha FUNfontScale
      FUNstrPos += [chSize.x, 0]
		)
	)

  fn DYNFUNgetAlignedPos FUNframe FUNhAlign FUNvAlign FUNstr FUNfontScale =
  (
    if not DYNFUNloadSightToolFont() then return [0,0] -- return start position for aligned string

    local LOCmyPos = [0,0]
    if FUNstr.count > 0 then -- calculate dimensions of string
    (
      local LOCstrWidth = 0
			local cv = 127
      for c = 1 to FUNstr.count do
      (
        cv = bit.charAsInt FUNstr[c]
        if (cv < 1) or (cv > DYNsightToolFont.count) or (DYNsightToolFont[cv].count==0) then cv = DYNsightToolFont.count
        LOCstrWidth += DYNsightToolFont[cv][1].count
			)
      LOCstrWidth *= FUNfontScale
      local LOCstrHeight = (DYNsightToolFont[DYNsightToolFont.count].count * FUNfontScale)

      LOCmyPos.x = case FUNhAlign of -- calc aligned pos
      (
        #left: FUNfontScale
        #center: ((FUNframe.width / 2) - 1) - (LOCstrWidth / 2)
        #right: FUNframe.width - (1 * FUNfontScale) - LOCstrWidth
			)
      LOCmyPos.y = case FUNvAlign of
      (
        #top      : 0
        #center   : ((FUNframe.height / 2) - 1) - (LOCstrWidth / 2)
        #bottom   : FUNframe.height - 1 - LOCstrHeight
        /*#bottomAlt: FUNframe.height - 1 - LOCstrHeight - LOCstrHeight*/
			)
		)
    return LOCmyPos
	)

  --- dim down intensity
  fn DYNFUNdimBackground FUNbitmap FUNarea =
  (
    for i = FUNarea.top to FUNarea.bottom do
    (
      local LOCsl = getPixels FUNbitmap [FUNarea.left, i] (FUNarea.right - FUNarea.left)
      for ii = 1 to LOCsl.count do
      (
        local LOCa = LOCsl[ii].alpha
        LOCsl[ii].value *= 0.5  -- bug: alpha value lost
        LOCsl[ii].alpha = LOCa
			)
      setPixels FUNbitmap [FUNarea.left, i] LOCsl
		)
	)

  --- return num as string with zero padding
  fn DYNFUNpadNum FUNnum FUNpadlen =
  (
    local LOCzeros = 10^FUNpadlen
    substring ((LOCzeros+FUNnum) as string) 2 (FUNpadlen+1)
  )

  --- convert time value into SMPTE string (v0.9)
  fn DYNFUNconvertTime_SMTPE FUNtheTime =
  (
    local LOCtps    = 4800
    local LOCsecs   = FUNtheTime.ticks / LOCtps
    local LOCmins   = LOCsecs / 60
    local LOCframes = (mod FUNtheTime.frame frameRate) as integer
    ((DYNFUNpadNum LOCmins 2) + ":" + (DYNFUNpadNum LOCsecs 2) + ":" + (DYNFUNpadNum LOCframes 2))
  )

  --- convert time value into seconds string
  fn DYNFUNconvertTime_Seconds FUNtheTime numDecimals =
  (
    local LOCtps = 4800.0
    local LOCsecs = FUNtheTime.ticks / LOCtps

    -- round off extra decimals but keep seconds
    -- not using formattedPrint to stay compatible to 3ds Max 8
    local LOCdec     = LOCsecs - (floor LOCsecs)     -- just decimal places
    local LOCintSec  = (LOCsecs - LOCdec) as integer  -- just full seconds

    local LOCdivisor = 10^numDecimals
    local LOCdecStr  = ((ceil (LOCdec * LOCdivisor)) / LOCdivisor) as string -- round off extra digits from decimals, maximum 6 decimals

    -- add extra zeros if needed to decimals (taking the leading "0." into account
    if (LOCdecStr.count-2) < numDecimals then append LOCdecStr (subString "0000000000000000000000000" 1 (numDecimals - LOCdecStr.count + 2))

    ((LOCintSec as string) + (substring LOCdecStr 2 999) + " " + ~PLUGIN_CIVILSIGHTRENDER_UNIT_TIME_SECOND~)
  )

  --- get camera name for rendered view
  fn DYNFUNgetCameraName =
  (
		local t = viewport.getType()
    local str = case t of
    (
      #view_top: ~PLUGIN_CIVILSIGHTRENDER_VIEW_TOP~
      #view_bottom: ~PLUGIN_CIVILSIGHTRENDER_VIEW_BOTTOM~
      #view_right: ~PLUGIN_CIVILSIGHTRENDER_VIEW_RIGHT~
      #view_left: ~PLUGIN_CIVILSIGHTRENDER_VIEW_LEFT~
      #view_front: ~PLUGIN_CIVILSIGHTRENDER_VIEW_FRONT~
      #view_back: ~PLUGIN_CIVILSIGHTRENDER_VIEW_BACK~
      #view_persp_user: ~PLUGIN_CIVILSIGHTRENDER_VIEW_PERSPECTIVE~
      #view_iso_user: ~PLUGIN_CIVILSIGHTRENDER_VIEW_ISO_USER~
			#view_camera: (viewport.getcamera()).name
      #view_spot: ~PLUGIN_CIVILSIGHTRENDER_VIEW_SPOT~
      #view_shape: ~PLUGIN_CIVILSIGHTRENDER_VIEW_SHAPE~
      #view_grid: ~PLUGIN_CIVILSIGHTRENDER_VIEW_GRID~
      default: ~PLUGIN_CIVILSIGHTRENDER_UNDEFINED~
		)
	)

  --- ensure that each channel in color 'FUNc' is not larger than 'mx'
  fn DYNFUNclampColorMax FUNc FUNmx =
  (
    if FUNc.r > FUNmx then FUNc.r = FUNmx
    if FUNc.g > FUNmx then FUNc.g = FUNmx
    if FUNc.b > FUNmx then FUNc.b = FUNmx
    if FUNc.a > FUNmx then FUNc.a = FUNmx
    FUNc
	)

  --- ensure that each channel in color 'FUNc' is not smaller than 'FUNmn'
  fn DYNFUNclampColorMin FUNc FUNmn =
  (
    if FUNc.r < FUNmn then FUNc.r = FUNmn
    if FUNc.g < FUNmn then FUNc.g = FUNmn
    if FUNc.b < FUNmn then FUNc.b = FUNmn
    if FUNc.a < FUNmn then FUNc.a = FUNmn
    FUNc
	)

  --- composite image from file 'FUNfile' into bitmap 'FUNframe' at position 'FUNposX'/'FUNposY' using transfer mode 'FUNmode'
  fn DYNFUNoverlayImage FUNframe FUNfile FUNposX FUNposY FUNmode op =
  (
    local LOCproceedSwitch = true
    local LOCwMarkMap      = try (openBitmap FUNfile) catch (LOCproceedSwitch = false)  -- Try Opening Rendered Output

    if classOf LOCwMarkMap == BitMap and LOCproceedSwitch then
    (
      local LOClogoW = LOCwMarkMap.width - 1
      local LOClogoH = LOCwMarkMap.height - 1
      local LOCorigW = FUNframe.width - 1
      local LOCorigH = FUNframe.height - 1

      /*
      Note: pixel[0,0] is at the top-left of a bitmap
      */

      local LOClogoY      = (amax -FUNposY 0)                     -- ROW where to START reading pixels from logo bitmap
      local LOClogoYmax   = (amin (LOCorigH - FUNposY) LOClogoH)  -- row where to STOP reading pixels from logo bitmap
      local LOClogoX      = (amax -FUNposX 0)                     -- COLUMN where to start reading pixels from logo bitmap
      local LOClogoXmax   = (amin (LOCorigW - FUNposX) LOClogoW)
      local LOClogoXCount = LOClogoXmax - LOClogoX + 1                  -- Number of pixels to read from logo for each row

      if (LOClogoYmax - LOClogoY + 1) < 1 or LOClogoXCount < 1 then
      (
        format (~PLUGIN_CIVILSIGHTRENDER_WARNING2~ + "\n")
				return false
			)


      --- for each row in the logo bitmap that is visible ---
      local LOCorigX = (amax 0 FUNposX) -- Column where to start writing pixels to render bitmap
      for i = LOClogoY to LOClogoYmax do
      (
        local LOClogoPixels = getPixels LOCwMarkMap [LOClogoX, i] LOClogoXCount
        local LOCorigY      = FUNposY+i
        local LOCorigPixels = getPixels FUNframe [LOCorigX, LOCorigY] LOClogoXCount

        for ii = 1 to LOClogoXCount do
        (
          local LOCnewCol = LOCorigPixels[ii]
          case FUNmode of
          (
            1: (LOCnewCol = LOClogoPixels[ii])  -- Normal
            2: (LOCnewCol = LOCorigPixels[ii] * ((255 - LOClogoPixels[ii].alpha) / 255.0) + LOClogoPixels[ii] * (LOClogoPixels[ii].alpha / 255.0))  -- Alpha Compositing, wants un-pre-multiplied data
            3: (LOCnewCol = DYNFUNclampColorMax (LOCorigPixels[ii] + LOClogoPixels[ii]) 255)  -- Add
            4: (LOCnewCol = DYNFUNclampColorMin (LOCorigPixels[ii] - LOClogoPixels[ii]) 0)  -- Subtract
            5: (LOCnewCol = DYNFUNclampColorMax (LOCorigPixels[ii] * LOClogoPixels[ii]) 255)  -- Multiply (white = neutral)
            6: (LOCnewCol = white - (white - LOClogoPixels[ii]) * (white - LOCorigPixels[ii]))  -- Screen (black = neutral)
            7: (LOCnewCol = DYNFUNclampColorMax (LOCorigPixels[ii] + 2 * LOClogoPixels[ii] - white) 255)  -- Stamp (grey = neutral)
            8: (LOCnewCol = DYNFUNclampColorMax (DYNFUNclampColorMin (LOCorigPixels[ii] + (LOClogoPixels[ii] - (Color 128 128 128))) 0) 255)  -- Overlay
            9: (LOCnewCol.value = LOClogoPixels[ii].value)  -- Luminosity
          )
          LOCorigPixels[ii] = LOCorigPixels[ii] * (1.0 - (op / 100.0)) + LOCnewCol * (op / 100.0)
        )
        setPixels FUNframe [LOCorigX, LOCorigY] LOCorigPixels
      )
      close LOCwMarkMap -- check whether this is causing an error
    )
  )

  --- draw horizontal line with color 'c' into bitmap 'bm' from pixels x1/y1 to x2/y1
  fn drawHLine FUNbm FUNx1 FUNy1 FUNx2 FUNc =
  (
    local LOCcols = for i = 0 to (FUNx2 - FUNx1) collect FUNc
    setPixels FUNbm [FUNx1, FUNy1] LOCcols
  )

  --- draw vertical line with color 'c' into bitmap 'bm' from pixels x1/y1 to x1/y2
  fn drawVLine FUNbm FUNx1 FUNy1 FUNy2 FUNc =
  (
    for i = FUNy1 to FUNy2 do
    (
      setPixels FUNbm [FUNx1, i] #(FUNc)  -- set single pixel :(
    )
  )

	-----------------------------------------
  parameters main rollout:params
  (
    framePad       type:#integer default:4

    fontScale      type:#integer default:1
    dimBG          type:#boolean default:true
    alphaBlend     type:#boolean default:true

    reqdDistance   type:#integer default:300

    TypeTextTL     type:#integer default:1
    TypeTextTC     type:#integer default:19
    TypeTextTR     type:#integer default:1
    TypeTextBL     type:#integer default:1
    TypeTextBC     type:#integer default:3
    TypeTextBR     type:#integer default:1
    EditTextTL     type:#string  default:~PLUGIN_CIVILSIGHTRENDER_EDITTEXTTL~
    EditTextTC     type:#string  default:~PLUGIN_CIVILSIGHTRENDER_EDITTEXTTC~
    EditTextTR     type:#string  default:~PLUGIN_CIVILSIGHTRENDER_EDITTEXTTR~
    EditTextBL     type:#string  default:~PLUGIN_CIVILSIGHTRENDER_EDITTEXTBL~
    EditTextBC     type:#string  default:~PLUGIN_CIVILSIGHTRENDER_EDITTEXTBC~
    EditTextBR     type:#string  default:~PLUGIN_CIVILSIGHTRENDER_EDITTEXTBR~

    useImage       type:#boolean default:false
    imageFName     type:#string  default:~PLUGIN_CIVILSIGHTRENDER_IMAGEFNAME~
    image_x        type:#integer default:10
    image_y        type:#integer default:26
    imgOpacity     type:#integer default:65
    transfer_mode  type:#integer default:1
	)

  rollout params ~PLUGIN_CIVILSIGHTRENDER_ROLLOUT~
  (
    group ~PLUGIN_CIVILSIGHTRENDER_GROUP~
    (
      label LBDYN1 ~PLUGIN_CIVILSIGHTRENDER_TEXT01~
    )
	)

	------------------------------------------

  on create do
  (
    DYNFUNloadSightToolFont()
	)

  on load do
  (
    DYNFUNloadSightToolFont()
	)

  on apply arg do
  (
    --- Set Local Variables
    local LOCdSightPlugin
    local LOCdSightPluginFS
    local LOCcurrentCam
    local LOCcamController

    if not alphaBlend then fontScale = 1

    --- Check if Rendering a Camera View
    if (viewport.getType()) == #view_camera then
    (
      LOCcurrentCam    = viewport.getcamera()
      LOCcamController = try (LOCcurrentCam.transform.controller) catch ()
    )

    --- Check For Presence of Civil View Sight Checker Tool main Render Effect Plugin
    for i = 1 to numEffects do
    (
      if classof (getEffect i) == Civil_View_Sight_Checker__Calc then LOCdSightPlugin = (getEffect i)
    )

    if LOCdSightPlugin != undefined then
    (
      if LOCdSightPlugin.output != "" and doesFileExist LOCdSightPlugin.output and (classOf LOCcamController == DynXFCC or classOf LOCcamController == DynXFCCM3 or classOf LOCcamController == DynXFCCV3) then
      (
        LOCdSightPluginFS = openFile LOCdSightPlugin.output mode:"r+"
        seek LOCdSightPluginFS #eof
        seek LOCdSightPluginFS ((filepos LOCdSightPluginFS) - 2)
        format ";%;%;%;%;%\n" (DYNFUNcalculateChainage LOCcamController.percent LOCcamController.path LOCcamController.spline) LOCcamController.hOffset LOCcamController.vOffset LOCcurrentCam.transform.pos.z (try (LOCcamController.path.name) catch ("")) to:LOCdSightPluginFS
      )
    )

    --- darken background in top and bottom area
    if dimBG then
    (

      local w = (gw.getTextExtent "H")*fontScale
      DYNFUNdimBackground arg (box2 0 0 (arg.width+1) (w.y+2))
      DYNFUNdimBackground arg (box2 0 (arg.height-w.y-2) (arg.width+1) arg.height)
    )

    --- Set System Units
    local LOCsystemUnit = ""
    if units.systemType == #inches      then LOCsystemUnit += ~PLUGIN_CIVILSIGHTRENDER_UNIT_DIST_INCHES~
    if units.systemType == #feet        then LOCsystemUnit += ~PLUGIN_CIVILSIGHTRENDER_UNIT_DIST_FEET~
    if units.systemType == #miles       then LOCsystemUnit += ~PLUGIN_CIVILSIGHTRENDER_UNIT_DIST_MILES~
    if units.systemType == #millimeters then LOCsystemUnit += ~PLUGIN_CIVILSIGHTRENDER_UNIT_DIST_MM~
    if units.systemType == #centimeters then LOCsystemUnit += ~PLUGIN_CIVILSIGHTRENDER_UNIT_DIST_CM~
    if units.systemType == #meters      then LOCsystemUnit += ~PLUGIN_CIVILSIGHTRENDER_UNIT_DIST_METRES~
    if units.systemType == #kilometers  then LOCsystemUnit += ~PLUGIN_CIVILSIGHTRENDER_UNIT_DIST_KM~

    for i = 1 to 6 do
    (
      local LOCtxt = ~PLUGIN_CIVILSIGHTRENDER_UNDEFINED~
      local LOCselectedOption = 1
      local LOCselectedText   = ""
      if i == 1 then (LOCselectedOption = TypeTextTL; LOCselectedText = EditTextTL)
      if i == 2 then (LOCselectedOption = TypeTextTC; LOCselectedText = EditTextTC)
      if i == 3 then (LOCselectedOption = TypeTextTR; LOCselectedText = EditTextTR)
      if i == 4 then (LOCselectedOption = TypeTextBL; LOCselectedText = EditTextBL)
      if i == 5 then (LOCselectedOption = TypeTextBC; LOCselectedText = EditTextBC)
      if i == 6 then (LOCselectedOption = TypeTextBR; LOCselectedText = EditTextBR)

      --- Print Nothing
      if LOCselectedOption == 1 then
      (
        LOCtxt = ""
      )

      --- Print Object Distance (Min)
      if LOCselectedOption == 2 then
      (
        if LOCdSightPlugin != undefined then
        (
          LOCtxt = (LOCdSightPlugin.resultMin * -1) as string
        )
        LOCtxt = LOCselectedText + LOCtxt + LOCsystemUnit
      )

      --- Print Object Distance (Mid)
      if LOCselectedOption == 3 then
      (
        if LOCdSightPlugin != undefined then
        (
          LOCtxt = (LOCdSightPlugin.resultAvg * -1) as string
        )
        LOCtxt = LOCselectedText + LOCtxt + LOCsystemUnit
      )

      --- Print Object Percent (Max)
      if LOCselectedOption == 4 then
      (
        if LOCdSightPlugin != undefined then
        (
          LOCtxt = (LOCdSightPlugin.resultMax * -1) as string
        )
        LOCtxt = LOCselectedText + LOCtxt + LOCsystemUnit
      )

      --- print current frame
      if LOCselectedOption == 5 then
      (
        LOCtxt = LOCselectedText + ((DYNFUNpadNum (currentTime.frame as integer) framePad) as string)
      )

      --- print frame time in smpte
      if LOCselectedOption == 6 then
      (
        LOCtxt = LOCselectedText + ((DYNFUNconvertTime_SMTPE currentTime) as string)
      )

      --- print frame time in seconds
      if LOCselectedOption == 7 then
      (
        LOCtxt = LOCselectedText + ((DYNFUNconvertTime_seconds currentTime framePad) as string)
      )

      --- print scene file name only
      if LOCselectedOption == 8 then
      (
        LOCtxt = maxFilename
        if LOCtxt.count==0 then LOCtxt =~PLUGIN_CIVILSIGHTRENDER_UNDEFINED~
        LOCtxt = LOCselectedText + LOCtxt
      )

      --- print scene file name and path
      if LOCselectedOption == 9 then
      (
        LOCtxt = maxFilepath + maxFilename
        local dim = (gw.getTextExtent LOCtxt)*fontScale
        if dim.x>(200*fontScale) then LOCtxt = ("...\\" + maxFilename)
        if LOCtxt.count==0 then LOCtxt =~PLUGIN_CIVILSIGHTRENDER_UNDEFINED~
        LOCtxt = LOCselectedText + LOCtxt
      )

      --- Print User/Machine to frame (various combinations)
      if LOCselectedOption == 10 then (LOCtxt = (sysInfo.userName); LOCtxt = LOCselectedText + LOCtxt)                              -- Print User
      if LOCselectedOption == 11 then (LOCtxt = (sysInfo.computername); LOCtxt = LOCselectedText + LOCtxt)                          -- Print Machine Name

      --- Print current date/time to frame
      if LOCselectedOption == 12 then (LOCtxt = localTime; LOCtxt = LOCselectedText + LOCtxt) -- print date and time

      --- Print Camera Name to Frame
      if LOCselectedOption == 13 then (LOCtxt = DYNFUNgetCameraName(); LOCtxt = LOCselectedText + LOCtxt) -- print camera name

      --- Print Camera Elevation to Frame
      if LOCselectedOption == 14 then
      (
        if superClassOf LOCcurrentCam == camera then
        (
          LOCtxt = try (LOCcurrentCam.transform.pos.z as string) catch (~PLUGIN_CIVILSIGHTRENDER_UNDEFINED~)
          LOCtxt = LOCselectedText + LOCtxt + LOCsystemUnit
        )
      )

      --- Print Camera Chainage to Frame (Placed Objects Only)
      if LOCselectedOption == 15 then
      (
        if classOf LOCcamController == DynXFCC or classOf LOCcamController == DynXFCCM3 or classOf LOCcamController == DynXFCCV3 then
        (
          local LOCchainage = DYNFUNcalculateChainage LOCcamController.percent LOCcamController.path LOCcamController.spline
          LOCtxt = LOCselectedText + (LOCchainage as string) + LOCsystemUnit
        )
      )

      --- Print Camera Horizontal Offset to Frame (Placed Objects Only)
      if LOCselectedOption == 16 then
      (
        if classOf LOCcamController == DynXFCC or classOf LOCcamController == DynXFCCM3 or classOf LOCcamController == DynXFCCV3 then
        (
          LOCtxt = LOCselectedText + (LOCcamController.hOffset as string) + LOCsystemUnit
        )
      )

      --- Print Camera Vertical Offset to Frame (Placed Objects Only)
      if LOCselectedOption == 17 then
      (
        if classOf LOCcamController == DynXFCC or classOf LOCcamController == DynXFCCM3 or classOf LOCcamController == DynXFCCV3 then
        (
          LOCtxt = LOCselectedText + (LOCcamController.vOffset as string) + LOCsystemUnit
        )
      )

      --- Print Percentage of distance requirement achieved to frame
      if LOCselectedOption == 18 then
      (
        local LOCpctachieved = ""
        if LOCdSightPlugin != undefined then
        (
          LOCpctachieved = (floor (LOCdSightPlugin.resultMin * -1) / ((reqdDistance as float) / 100.0)) as integer
          if LOCpctachieved > 100 then LOCpctachieved = 100
          LOCtxt = "|"
          for i = 1 to LOCpctachieved do LOCtxt += "!"
          for i = (LOCpctachieved + 1) to 100 do LOCtxt += "."
          LOCtxt += "|"
          LOCtxt = LOCselectedText + " " + LOCtxt + " = " + (LOCpctachieved as string) + "% (" + ((LOCdSightPlugin.resultMin * -1) as string) + LOCsystemUnit + " / " + (reqdDistance as string) + LOCsystemUnit + ")"
        )
      )

      if LOCselectedOption == 19 then (LOCtxt = LOCselectedText)-- print user text
      if LOCselectedOption == 20 then (LOCtxt = LOCselectedText; try (LOCtxt = (execute LOCtxt) as string) catch (LOCtxt=~PLUGIN_CIVILSIGHTRENDER_ERROR~))-- print result of maxscript command

      --- Position Selected Text on frame
      if i == 1 then DYNFUNprintString arg (DYNFUNgetAlignedPos arg #left   #top    LOCtxt fontScale) LOCtxt alphaBlend fontScale
      if i == 2 then DYNFUNprintString arg (DYNFUNgetAlignedPos arg #center #top    LOCtxt fontScale) LOCtxt alphaBlend fontScale
      if i == 3 then DYNFUNprintString arg (DYNFUNgetAlignedPos arg #right  #top    LOCtxt fontScale) LOCtxt alphaBlend fontScale
      if i == 4 then DYNFUNprintString arg (DYNFUNgetAlignedPos arg #left   #bottom LOCtxt fontScale) LOCtxt alphaBlend fontScale
      if i == 5 then DYNFUNprintString arg (DYNFUNgetAlignedPos arg #center #bottom LOCtxt fontScale) LOCtxt alphaBlend fontScale
      if i == 6 then DYNFUNprintString arg (DYNFUNgetAlignedPos arg #right  #bottom LOCtxt fontScale) LOCtxt alphaBlend fontScale
    )

    --- Close File Output To CSV Output File
    if LOCdSightPluginFS != undefined then (close LOCdSightPluginFS)

    --- overlay image
    if useImage then
    (
      -- overlay image
      if imgOpacity > 0 then DYNFUNoverlayImage arg imageFName image_x image_y transfer_mode imgOpacity
    )
    gc()
	)
)
--
-- � Copyright 2011 Autodesk, Inc. All rights reserved.
--

plugin simpleObject Vsp_Sign name:~PLUGIN_CIVILSIGN_NAME~ category:~PLUGIN_CIVILSIGN_CATEGORY~ classID:#(432767853,2050311212) invisible:(not DYNcreatable)
(
  --- Parameter Block Definition
  parameters main rollout:params
  (
    width   type:#worldunits   default:3.0
    height  type:#worldunits   default:2.0
    type    type:#integer      default:11

    pHeight type:#worldunits   default:3.0
    depth   type:#worldunits   default:-1.0
    posts   type:#integer      default:2
    edgeoff type:#worldunits   default:0.1
	)

  --- Rollout Definition
  rollout params ~PLUGIN_CIVILSIGN_ROLLOUT~
  (
    group ~PLUGIN_CIVILSIGN_GROUP~
    (
      label LBtext01 ~PLUGIN_CIVILSIGN_TEXT01~ align:#center
      label LBtext02 ~PLUGIN_CIVILSIGN_TEXT02~ align:#center
    )
	)

  on create do
  (
    --- Set Default Values                                                                 ---
    --- When a new gantry is created, convert the defaults in Pmblock which use WorldUnits ---
    --- to equivilents in feet                                                             ---
    local LOCunitMult = 1.0
    case units.SystemType of
    (
      #Inches      : LOCunitMult = 39.3700787
      #Feet        : LOCunitMult = 3.2808399
      #Miles       : LOCunitMult = 0.000621371192
      #Millimeters : LOCunitMult = 1000.0
      #Centimeters : LOCunitMult = 100.0
      #Meters      : LOCunitMult = 1.0
      #Kilometers  : LOCunitMult = 0.001
    )

    width   = width   * LOCunitMult
    height  = height  * LOCunitMult
    pHeight = pHeight * LOCunitMult
    depth   = depth   * LOCunitMult
    edgeoff = edgeoff * LOCunitMult
  )

  on buildMesh do
  (
    local LMSWidth   = width
    local LMSHeight  = Height
    local LMSType    = Type
    local LMSPheight = Pheight
    local LMSDepth   = Depth
    local LMSPosts   = Posts
    local LMSEdgeoff = Edgeoff

    local LOCunitMult = 1.0
    case units.SystemType of
    (
      #Inches      : LOCunitMult = 39.3700787
      #Feet        : LOCunitMult = 3.2808399
      #Miles       : LOCunitMult = 0.000621371192
      #Millimeters : LOCunitMult = 1000.0
      #Centimeters : LOCunitMult = 100.0
      #Meters      : LOCunitMult = 1.0
      #Kilometers  : LOCunitMult = 0.001
    )

    --- Set Up Arrays
    VertPts = #() -- Vertex List Array
    FaceVertList = #() -- Face Vertex List Array
    faceMatIDs = #() -- Face Material ID Array
    FaceSmthGps = #() -- Face Smoothing Group Array
    FaceEdgeVis = #() -- Face Edge Visability Array

    --- Vertex data ---------------------------

    --- Sign Face Itself
    append VertPts [ (LMSwidth/2),(0.025 * LOCunitMult),(LMSpHeight) - (LMSheight)]
    append VertPts [-(LMSwidth/2),(0.025 * LOCunitMult),(LMSpHeight) - (LMSheight)]
    append VertPts [ (LMSwidth/2),(0.025 * LOCunitMult),(LMSpHeight)]
    append VertPts [-(LMSwidth/2),(0.025 * LOCunitMult),(LMSpHeight)]

    --- Posts (Upper Section)
    local LOCpostArray = #()
    local LOCuppArray = #()
    local LOClowArray = #()
    local LOCposOffset = ((LMSwidth/2.0) - LMSedgeoff) *  1.0
    if LMSposts == 1 then LOCpostArray = #(0.0)
    if LMSposts == 2 then LOCpostArray = #(-LOCposOffset,LOCposOffset)
    if LMSposts == 3 then LOCpostArray = #(-LOCposOffset,0.0,LOCposOffset)
    if LMSposts == 4 then LOCpostArray = #(-LOCposOffset,(0.333 * -LOCposOffset),(0.333 * LOCposOffset),LOCposOffset)
    if LMSposts == 5 then LOCpostArray = #(-LOCposOffset,(-LOCposOffset / 2),0.0,(LOCposOffset / 2),LOCposOffset)

    for i = 1 to LOCpostArray.count do
    (
      append LOCuppArray (VertPts.count)
      append VertPts [LOCpostArray[i] + (-0.050 * LOCunitMult),(-0.075 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + (-0.035 * LOCunitMult),(-0.040 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.000 * LOCunitMult),(-0.025 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.035 * LOCunitMult),(-0.040 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.050 * LOCunitMult),(-0.075 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.035 * LOCunitMult),(-0.110 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.000 * LOCunitMult),(-0.125 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + (-0.035 * LOCunitMult),(-0.110 * LOCunitMult),   0.0]

      append VertPts [LOCpostArray[i] + (-0.050 * LOCunitMult),(-0.075 * LOCunitMult),LMSpHeight]
      append VertPts [LOCpostArray[i] + (-0.035 * LOCunitMult),(-0.040 * LOCunitMult),LMSpHeight]
      append VertPts [LOCpostArray[i] + ( 0.000 * LOCunitMult),(-0.025 * LOCunitMult),LMSpHeight]
      append VertPts [LOCpostArray[i] + ( 0.035 * LOCunitMult),(-0.040 * LOCunitMult),LMSpHeight]
      append VertPts [LOCpostArray[i] + ( 0.050 * LOCunitMult),(-0.075 * LOCunitMult),LMSpHeight]
      append VertPts [LOCpostArray[i] + ( 0.035 * LOCunitMult),(-0.110 * LOCunitMult),LMSpHeight]
      append VertPts [LOCpostArray[i] + ( 0.000 * LOCunitMult),(-0.125 * LOCunitMult),LMSpHeight]
      append VertPts [LOCpostArray[i] + (-0.035 * LOCunitMult),(-0.110 * LOCunitMult),LMSpHeight]
    )
    --- Posts (Lower Section)
    for i = 1 to LOCpostArray.count do
    (
      append LOClowArray (VertPts.count)
      append VertPts [LOCpostArray[i] + (-0.050 * LOCunitMult),(-0.075 * LOCunitMult), LMSdepth]
      append VertPts [LOCpostArray[i] + (-0.035 * LOCunitMult),(-0.040 * LOCunitMult), LMSdepth]
      append VertPts [LOCpostArray[i] + ( 0.000 * LOCunitMult),(-0.025 * LOCunitMult), LMSdepth]
      append VertPts [LOCpostArray[i] + ( 0.035 * LOCunitMult),(-0.040 * LOCunitMult), LMSdepth]
      append VertPts [LOCpostArray[i] + ( 0.050 * LOCunitMult),(-0.075 * LOCunitMult), LMSdepth]
      append VertPts [LOCpostArray[i] + ( 0.035 * LOCunitMult),(-0.110 * LOCunitMult), LMSdepth]
      append VertPts [LOCpostArray[i] + ( 0.000 * LOCunitMult),(-0.125 * LOCunitMult), LMSdepth]
      append VertPts [LOCpostArray[i] + (-0.035 * LOCunitMult),(-0.110 * LOCunitMult), LMSdepth]

      append VertPts [LOCpostArray[i] + (-0.050 * LOCunitMult),(-0.075 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + (-0.035 * LOCunitMult),(-0.040 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.000 * LOCunitMult),(-0.025 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.035 * LOCunitMult),(-0.040 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.050 * LOCunitMult),(-0.075 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.035 * LOCunitMult),(-0.110 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.000 * LOCunitMult),(-0.125 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + (-0.035 * LOCunitMult),(-0.110 * LOCunitMult),   0.0]
    )

    --- Face data ---------------------------
    -- Sign Face
    -- Vertex Indexes -------- Mat ID ------ Smooth Group ---------- Edge Visability ----
    append FaceVertList [1,2,4]     ; append faceMatIDs LMStype ; append FaceSmthGps 0  ; append FaceEdgeVis #(true, true, false)
    append FaceVertList [4,3,1]     ; append faceMatIDs LMStype ; append FaceSmthGps 0  ; append FaceEdgeVis #(true, true, false)

    -- Posts (Upper Section)
    for i = 1 to LOCuppArray.count do
    (
      local bb = LOCuppArray[i]
      append FaceVertList [(bb + 1),(bb + 10),(bb + 2)]
      append faceMatIDs 5    ; append FaceSmthGps 1  ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 1),(bb + 9),(bb + 10)]
      append faceMatIDs 5    ; append FaceSmthGps 1  ; append FaceEdgeVis #(true, true, false)
      append FaceVertList [(bb + 2),(bb + 11),(bb + 3)]
      append faceMatIDs 5    ; append FaceSmthGps 3  ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 2),(bb + 10),(bb + 11)]
      append faceMatIDs 5    ; append FaceSmthGps 3  ; append FaceEdgeVis #(true, true, false)
      append FaceVertList [(bb + 3),(bb + 12),(bb + 4)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 3),(bb + 11),(bb + 12)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(true, true, false)
      append FaceVertList [(bb + 4),(bb + 13),(bb + 5)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 4),(bb + 12),(bb + 13)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(true, true, false)
      append FaceVertList [(bb + 5),(bb + 14),(bb + 6)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 5),(bb + 13),(bb + 14)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(true, true, false)
      append FaceVertList [(bb + 6),(bb + 15),(bb + 7)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 6),(bb + 14),(bb + 15)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(true, true, false)
      append FaceVertList [(bb + 7),(bb + 16),(bb + 8)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 7),(bb + 15),(bb + 16)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(true, true, false)
      append FaceVertList [(bb + 8),(bb + 9),(bb + 1)]
      append faceMatIDs 5    ; append FaceSmthGps 3  ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 8),(bb + 16),(bb + 9)]
      append faceMatIDs 5    ; append FaceSmthGps 3  ; append FaceEdgeVis #(true, true, false)

      append FaceVertList [(bb + 10),(bb + 12),(bb + 11)]
      append faceMatIDs 5    ; append FaceSmthGps 16 ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 9),(bb + 12),(bb + 10)]
      append faceMatIDs 5    ; append FaceSmthGps 16 ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 16),(bb + 12),(bb + 9)]
      append faceMatIDs 5    ; append FaceSmthGps 16 ; append FaceEdgeVis #(false, false, false)
      append FaceVertList [(bb + 15),(bb + 12),(bb + 16)]
      append faceMatIDs 5    ; append FaceSmthGps 16 ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 14),(bb + 12),(bb + 15)]
      append faceMatIDs 5    ; append FaceSmthGps 16 ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 14),(bb + 13),(bb + 12)]
      append faceMatIDs 5    ; append FaceSmthGps 16 ; append FaceEdgeVis #(true, true, false)
    )

    for i = 1 to LOClowArray.count do
    (
      local bb = LOClowArray[i]
      append FaceVertList [(bb + 1),(bb + 10),(bb + 2)]
      append faceMatIDs 3   ; append FaceSmthGps 1  ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 1),(bb + 9),(bb + 10)]
      append faceMatIDs 3   ; append FaceSmthGps 1  ; append FaceEdgeVis #(false, false, false)
      append FaceVertList [(bb + 2),(bb + 11),(bb + 3)]
      append faceMatIDs 3   ; append FaceSmthGps 3  ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 2),(bb + 10),(bb + 11)]
      append faceMatIDs 3   ; append FaceSmthGps 3  ; append FaceEdgeVis #(false, false, false)
      append FaceVertList [(bb + 3),(bb + 12),(bb + 4)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 3),(bb + 11),(bb + 12)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, false)
      append FaceVertList [(bb + 4),(bb + 13),(bb + 5)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 4),(bb + 12),(bb + 13)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, false)
      append FaceVertList [(bb + 5),(bb + 14),(bb + 6)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 5),(bb + 13),(bb + 14)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, false)
      append FaceVertList [(bb + 6),(bb + 15),(bb + 7)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 6),(bb + 14),(bb + 15)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, false)
      append FaceVertList [(bb + 7),(bb + 16),(bb + 8)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 7),(bb + 15),(bb + 16)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, false)
      append FaceVertList [(bb + 8),(bb + 9),(bb + 1)]
      append faceMatIDs 3   ; append FaceSmthGps 3  ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 8),(bb + 16),(bb + 9)]
      append faceMatIDs 3   ; append FaceSmthGps 3  ; append FaceEdgeVis #(false, false, false)
    )

    --- Create Mesh Object from above Arrays
    setMesh mesh vertices:VertPts faces:FaceVertList materialIDs:faceMatIDs

    ---Set Up Smoothing Groups
    for i = 1 to FaceSmthGps.count do setFaceSmoothGroup mesh i FaceSmthGps[i]

    --- Set Up Edge Visability
    for i = 1 to FaceEdgeVis.count do (for ii = 1 to 3 do (setEdgeVis mesh i ii FaceEdgeVis[i][ii]))

    --- Add UVW Coordinates
    local tv = #([0,0,0],[1,0,0],[0,1,0],[1,1,0])
    local tf = #([1,2,4],[4,3,1])
    setNumTverts mesh tv.count
    buildTVFaces mesh
    for i in 1 to tv.count do setTVert  mesh i tv[i]
    for i in 1 to tf.count do setTVFace mesh i tf[i]

  ) -- end on buildmesh

  tool create prompt:~PLUGIN_CIVILSIGN_PROMPT~
  (
    on mousePoint click do
    (
      case click of
      (
        1: nodeTM.translation = gridPoint
        2: #stop
      )
    )
  ) -- end create tool
) -- end plugin
--
-- � Copyright 2011 Autodesk, Inc. All rights reserved.
--

plugin simpleObject Vsp_Signal name:~PLUGIN_CIVILSIGNAL_NAME~ category:~PLUGIN_CIVILSIGNAL_CATEGORY~ classID:#(0x108c280f, 0xe03def7) invisible:(not DYNcreatable)
(
  --- Parameter Block Definition
  parameters main rollout:params
  (
    width     type:#worldunits   default:3.0
    height    type:#worldunits   default:2.0
    type      type:#integer      default:11

    pHeight   type:#worldunits   default:3.0
    depth     type:#worldunits   default:-1.0
    posts     type:#integer      default:1
    edgeoff   type:#worldunits   default:0.1

    numphases type:#integer      default:3
    curPhase  type:#integer      default:1
	)

  --- Rollout Definition
  rollout params ~PLUGIN_CIVILSIGNAL_ROLLOUT~
  (
    group ~PLUGIN_CIVILSIGNAL_GROUP~
    (
      label LBtext01 ~PLUGIN_CIVILSIGNAL_TEXT01~ align:#center
      label LBtext02 ~PLUGIN_CIVILSIGNAL_TEXT02~ align:#center
    )
	)

  on create do
  (
    --- Set Default Values                                                                 ---
    --- When a new gantry is created, convert the defaults in Pmblock which use WorldUnits ---
    --- to equivilents in feet                                                             ---
    local LOCunitMult = 1.0
    case units.SystemType of
    (
      #Inches      : LOCunitMult = 39.3700787
      #Feet        : LOCunitMult = 3.2808399
      #Miles       : LOCunitMult = 0.000621371192
      #Millimeters : LOCunitMult = 1000.0
      #Centimeters : LOCunitMult = 100.0
      #Meters      : LOCunitMult = 1.0
      #Kilometers  : LOCunitMult = 0.001
    )

    width   = width   * LOCunitMult
    height  = height  * LOCunitMult
    pHeight = pHeight * LOCunitMult
    depth   = depth   * LOCunitMult
    edgeoff = edgeoff * LOCunitMult
  )

  on buildMesh do
  (
    local LMSWidth   = width
    local LMSHeight  = Height
    local LMSType    = Type
    local LMSPheight = Pheight
    local LMSDepth   = Depth
    local LMSPosts   = Posts
    local LMSEdgeoff = Edgeoff

    local LOCunitMult = 1.0
    case units.SystemType of
    (
      #Inches      : LOCunitMult = 39.3700787
      #Feet        : LOCunitMult = 3.2808399
      #Miles       : LOCunitMult = 0.000621371192
      #Millimeters : LOCunitMult = 1000.0
      #Centimeters : LOCunitMult = 100.0
      #Meters      : LOCunitMult = 1.0
      #Kilometers  : LOCunitMult = 0.001
    )

    --- Set Up Arrays
    VertPts = #() -- Vertex List Array
    FaceVertList = #() -- Face Vertex List Array
    faceMatIDs = #() -- Face Material ID Array
    FaceSmthGps = #() -- Face Smoothing Group Array
    FaceEdgeVis = #() -- Face Edge Visability Array

    --- Vertex data ---------------------------

    --- Signal Face Itself
    append VertPts [ (LMSwidth/2),(0.025 * LOCunitMult),(LMSpHeight) - (LMSheight)]
    append VertPts [-(LMSwidth/2),(0.025 * LOCunitMult),(LMSpHeight) - (LMSheight)]
    append VertPts [ (LMSwidth/2),(0.025 * LOCunitMult),(LMSpHeight)]
    append VertPts [-(LMSwidth/2),(0.025 * LOCunitMult),(LMSpHeight)]

    --- Posts (Upper Section)
    local LOCpostArray = #()
    local LOCuppArray  = #()
    local LOClowArray  = #()
    local LOCposOffset = ((LMSwidth/2.0) - LMSedgeoff) *  1.0
    if LMSposts == 1 then LOCpostArray = #(0.0)
    if LMSposts == 2 then LOCpostArray = #(-LOCposOffset,LOCposOffset)
    if LMSposts == 3 then LOCpostArray = #(-LOCposOffset,0.0,LOCposOffset)
    if LMSposts == 4 then LOCpostArray = #(-LOCposOffset,(0.333 * -LOCposOffset),(0.333 * LOCposOffset),LOCposOffset)
    if LMSposts == 5 then LOCpostArray = #(-LOCposOffset,(-LOCposOffset / 2),0.0,(LOCposOffset / 2),LOCposOffset)

    for i = 1 to LOCpostArray.count do
    (
      append LOCuppArray (VertPts.count)
      append VertPts [LOCpostArray[i] + (-0.050 * LOCunitMult),(-0.075 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + (-0.035 * LOCunitMult),(-0.040 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.000 * LOCunitMult),(-0.025 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.035 * LOCunitMult),(-0.040 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.050 * LOCunitMult),(-0.075 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.035 * LOCunitMult),(-0.110 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.000 * LOCunitMult),(-0.125 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + (-0.035 * LOCunitMult),(-0.110 * LOCunitMult),   0.0]

      append VertPts [LOCpostArray[i] + (-0.050 * LOCunitMult),(-0.075 * LOCunitMult),LMSpHeight]
      append VertPts [LOCpostArray[i] + (-0.035 * LOCunitMult),(-0.040 * LOCunitMult),LMSpHeight]
      append VertPts [LOCpostArray[i] + ( 0.000 * LOCunitMult),(-0.025 * LOCunitMult),LMSpHeight]
      append VertPts [LOCpostArray[i] + ( 0.035 * LOCunitMult),(-0.040 * LOCunitMult),LMSpHeight]
      append VertPts [LOCpostArray[i] + ( 0.050 * LOCunitMult),(-0.075 * LOCunitMult),LMSpHeight]
      append VertPts [LOCpostArray[i] + ( 0.035 * LOCunitMult),(-0.110 * LOCunitMult),LMSpHeight]
      append VertPts [LOCpostArray[i] + ( 0.000 * LOCunitMult),(-0.125 * LOCunitMult),LMSpHeight]
      append VertPts [LOCpostArray[i] + (-0.035 * LOCunitMult),(-0.110 * LOCunitMult),LMSpHeight]
    )
    --- Posts (Lower Section)
    for i = 1 to LOCpostArray.count do
    (
      append LOClowArray (VertPts.count)
      append VertPts [LOCpostArray[i] + (-0.050 * LOCunitMult),(-0.075 * LOCunitMult), LMSdepth]
      append VertPts [LOCpostArray[i] + (-0.035 * LOCunitMult),(-0.040 * LOCunitMult), LMSdepth]
      append VertPts [LOCpostArray[i] + ( 0.000 * LOCunitMult),(-0.025 * LOCunitMult), LMSdepth]
      append VertPts [LOCpostArray[i] + ( 0.035 * LOCunitMult),(-0.040 * LOCunitMult), LMSdepth]
      append VertPts [LOCpostArray[i] + ( 0.050 * LOCunitMult),(-0.075 * LOCunitMult), LMSdepth]
      append VertPts [LOCpostArray[i] + ( 0.035 * LOCunitMult),(-0.110 * LOCunitMult), LMSdepth]
      append VertPts [LOCpostArray[i] + ( 0.000 * LOCunitMult),(-0.125 * LOCunitMult), LMSdepth]
      append VertPts [LOCpostArray[i] + (-0.035 * LOCunitMult),(-0.110 * LOCunitMult), LMSdepth]

      append VertPts [LOCpostArray[i] + (-0.050 * LOCunitMult),(-0.075 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + (-0.035 * LOCunitMult),(-0.040 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.000 * LOCunitMult),(-0.025 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.035 * LOCunitMult),(-0.040 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.050 * LOCunitMult),(-0.075 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.035 * LOCunitMult),(-0.110 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + ( 0.000 * LOCunitMult),(-0.125 * LOCunitMult),   0.0]
      append VertPts [LOCpostArray[i] + (-0.035 * LOCunitMult),(-0.110 * LOCunitMult),   0.0]
    )

    --- Face data ---------------------------
    -- Sign Face
    -- Vertex Indexes -------- Mat ID ------ Smooth Group ---------- Edge Visability ----
    append FaceVertList [1,2,4]     ; append faceMatIDs LMStype ; append FaceSmthGps 0  ; append FaceEdgeVis #(true, true, false)
    append FaceVertList [4,3,1]     ; append faceMatIDs LMStype ; append FaceSmthGps 0  ; append FaceEdgeVis #(true, true, false)

    -- Posts (Upper Section)
    for i = 1 to LOCuppArray.count do
    (
      local bb = LOCuppArray[i]
      append FaceVertList [(bb + 1),(bb + 10),(bb + 2)]
      append faceMatIDs 5    ; append FaceSmthGps 1  ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 1),(bb + 9),(bb + 10)]
      append faceMatIDs 5    ; append FaceSmthGps 1  ; append FaceEdgeVis #(true, true, false)
      append FaceVertList [(bb + 2),(bb + 11),(bb + 3)]
      append faceMatIDs 5    ; append FaceSmthGps 3  ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 2),(bb + 10),(bb + 11)]
      append faceMatIDs 5    ; append FaceSmthGps 3  ; append FaceEdgeVis #(true, true, false)
      append FaceVertList [(bb + 3),(bb + 12),(bb + 4)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 3),(bb + 11),(bb + 12)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(true, true, false)
      append FaceVertList [(bb + 4),(bb + 13),(bb + 5)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 4),(bb + 12),(bb + 13)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(true, true, false)
      append FaceVertList [(bb + 5),(bb + 14),(bb + 6)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 5),(bb + 13),(bb + 14)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(true, true, false)
      append FaceVertList [(bb + 6),(bb + 15),(bb + 7)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 6),(bb + 14),(bb + 15)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(true, true, false)
      append FaceVertList [(bb + 7),(bb + 16),(bb + 8)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 7),(bb + 15),(bb + 16)]
      append faceMatIDs 5    ; append FaceSmthGps 2  ; append FaceEdgeVis #(true, true, false)
      append FaceVertList [(bb + 8),(bb + 9),(bb + 1)]
      append faceMatIDs 5    ; append FaceSmthGps 3  ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 8),(bb + 16),(bb + 9)]
      append faceMatIDs 5    ; append FaceSmthGps 3  ; append FaceEdgeVis #(true, true, false)

      append FaceVertList [(bb + 10),(bb + 12),(bb + 11)]
      append faceMatIDs 5    ; append FaceSmthGps 16 ; append FaceEdgeVis #(false, true, true)
      append FaceVertList [(bb + 9),(bb + 12),(bb + 10)]
      append faceMatIDs 5    ; append FaceSmthGps 16 ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 16),(bb + 12),(bb + 9)]
      append faceMatIDs 5    ; append FaceSmthGps 16 ; append FaceEdgeVis #(false, false, false)
      append FaceVertList [(bb + 15),(bb + 12),(bb + 16)]
      append faceMatIDs 5    ; append FaceSmthGps 16 ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 14),(bb + 12),(bb + 15)]
      append faceMatIDs 5    ; append FaceSmthGps 16 ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 14),(bb + 13),(bb + 12)]
      append faceMatIDs 5    ; append FaceSmthGps 16 ; append FaceEdgeVis #(true, true, false)
    )

    for i = 1 to LOClowArray.count do
    (
      local bb = LOClowArray[i]
      append FaceVertList [(bb + 1),(bb + 10),(bb + 2)]
      append faceMatIDs 3   ; append FaceSmthGps 1  ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 1),(bb + 9),(bb + 10)]
      append faceMatIDs 3   ; append FaceSmthGps 1  ; append FaceEdgeVis #(false, false, false)
      append FaceVertList [(bb + 2),(bb + 11),(bb + 3)]
      append faceMatIDs 3   ; append FaceSmthGps 3  ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 2),(bb + 10),(bb + 11)]
      append faceMatIDs 3   ; append FaceSmthGps 3  ; append FaceEdgeVis #(false, false, false)
      append FaceVertList [(bb + 3),(bb + 12),(bb + 4)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 3),(bb + 11),(bb + 12)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, false)
      append FaceVertList [(bb + 4),(bb + 13),(bb + 5)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 4),(bb + 12),(bb + 13)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, false)
      append FaceVertList [(bb + 5),(bb + 14),(bb + 6)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 5),(bb + 13),(bb + 14)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, false)
      append FaceVertList [(bb + 6),(bb + 15),(bb + 7)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 6),(bb + 14),(bb + 15)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, false)
      append FaceVertList [(bb + 7),(bb + 16),(bb + 8)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 7),(bb + 15),(bb + 16)]
      append faceMatIDs 3   ; append FaceSmthGps 2  ; append FaceEdgeVis #(false, false, false)
      append FaceVertList [(bb + 8),(bb + 9),(bb + 1)]
      append faceMatIDs 3   ; append FaceSmthGps 3  ; append FaceEdgeVis #(false, false, true)
      append FaceVertList [(bb + 8),(bb + 16),(bb + 9)]
      append faceMatIDs 3   ; append FaceSmthGps 3  ; append FaceEdgeVis #(false, false, false)
    )

    --- Create Mesh Object from above Arrays
    setMesh mesh vertices:VertPts faces:FaceVertList materialIDs:faceMatIDs

    ---Set Up Smoothing Groups
    for i = 1 to FaceSmthGps.count do setFaceSmoothGroup mesh i FaceSmthGps[i]

    --- Set Up Edge Visability
    for i = 1 to FaceEdgeVis.count do (for ii = 1 to 3 do (setEdgeVis mesh i ii FaceEdgeVis[i][ii]))

    --- Add UVW Coordinates
    --local tv = #([0,0,0],[1,0,0],[0,1,0],[1,1,0])
    --local tf = #([1,2,4],[4,3,1])

    local LOChStart = (1.0 / numPhases) * (curPhase - 1)
    local LOChEnd   = (1.0 / numPhases) * (curPhase)

    local tv = #([LOChStart,0,0],[LOChEnd,0,0],[LOChStart,1,0],[LOChEnd,1,0])
    local tf = #([1,2,4],[4,3,1])


    setNumTverts mesh tv.count
    buildTVFaces mesh
    for i in 1 to tv.count do setTVert  mesh i tv[i]
    for i in 1 to tf.count do setTVFace mesh i tf[i]

  ) -- end on buildmesh

  tool create prompt:~PLUGIN_CIVILSIGNAL_PROMPT~
  (
    on mousePoint click do
    (
      case click of
      (
        1: nodeTM.translation = gridPoint
        2: #stop
      )
    )
  ) -- end create tool
) -- end plugin
plugin simpleObject Civil_Structure name:~PLUGIN_CIVILSTRUCTURE_NAME~ category:~PLUGIN_CIVILSTRUCTURE_CATEGORY~ classID:#(1981431105,1644630215) invisible:(not DYNcreatable)
(
  parameters params -- rollout:params_rollout
  (
    type                 type:#integer default:1    -- ui:type  -- (1:rectangular; 2:cylindrical)
    frame_type           type:#integer default:1    -- ui:type  -- (1:rectangular; 2:cylindrical) NOT YET USED

    structure_widthOrDia type:#float   default:1.2  -- ui:structure_widthOrDia
    structure_length     type:#float   default:1.5  -- ui:structure_length
    structure_height     type:#float   default:0.9  -- ui:structure_height

    frame_widthOrDia     type:#float   default:0.4  -- ui:frame_widthOrDia
    frame_length         type:#float   default:0.6  -- ui:frame_length
    frame_height         type:#float   default:0.1  -- ui:frame_height

    cone_widthOrDia      type:#float   default:0.6  -- ui:cone_widthOrDia
    cone_length          type:#float   default:0.75 -- ui:cone_length
    cone_height          type:#float   default:0.3  -- ui:cone_height

    floor_thickness      type:#float   default:0.15 -- ui:floor_thickness
    wall_thickness       type:#float   default:0.05 -- ui:wall_thickness
    rim_thickness        type:#float   default:0.05 -- ui:rim_thickness

    concentric_offset_x  type:#float   default:0.0  -- ui:concentric_offset_x
    concentric_offset_y  type:#float   default:0.0  -- ui:concentric_offset_y
  )

  parameters mapping_params
  (
    use_matid            type:#boolean default:true -- ui:check_matid
    mapcoords            type:#boolean default:true -- ui:check_uv
  )

  parameters attribs
  (
    displayName          type:#string
    networkName          type:#string
    networkID            type:#string
    cover                type:#string
    frame                type:#string
    grate                type:#string
    materialName         type:#string
    partDefId            type:#string
    partDesc             type:#string
    partSizeName         type:#string
    partSubType          type:#string
    connectedPartCount   type:#integer default:0
    connectedPipesCount  type:#integer default:0
    partType             type:#integer default:0
    barrelPipeClearance  type:#float
  )

  --- User Interface
  -- rollout params_rollout ~PLUGIN_CIVILSTRUCTURE_ROLLOUT~
  -- (
  --   group ~PLUGIN_CIVILSTRUCTURE_STRUCTURE_DIMENSIONS~
  --   (
  --     radiobuttons type labels:#(~PLUGIN_CIVILSTRUCTURE_RECTANGULAR~, ~PLUGIN_CIVILSTRUCTURE_CYLINDRICAL~)
  --     spinner structure_length ~PLUGIN_CIVILSTRUCTURE_LENGTH~ range:[0,10000,300.0] align:#right fieldwidth:60
  --     spinner structure_widthOrDia ~PLUGIN_CIVILSTRUCTURE_WIDTH~ range:[0,10000,400.0] align:#right fieldwidth:60
  --     spinner structure_height ~PLUGIN_CIVILSTRUCTURE_HEIGHT~ range:[0,10000,120.0] align:#right fieldwidth:60
  --     spinner floor_thickness ~PLUGIN_CIVILSTRUCTURE_FLOOR_DEPTH~ range:[0,10000,120.0] align:#right fieldwidth:60
  --     spinner wall_thickness ~PLUGIN_CIVILSTRUCTURE_WALL_WIDTH~ range:[0,10000,120.0] align:#right fieldwidth:60
  --   )
  --   group ~PLUGIN_CIVILSTRUCTURE_FRAME_DIMENSIONS~
  --   (
  --     spinner frame_length ~PLUGIN_CIVILSTRUCTURE_LENGTH~ range:[0,10000,120.0] align:#right fieldwidth:60
  --     spinner frame_widthOrDia ~PLUGIN_CIVILSTRUCTURE_WIDTH~ range:[0,10000,120.0] align:#right fieldwidth:60
  --     spinner frame_height ~PLUGIN_CIVILSTRUCTURE_HEIGHT~ range:[0,10000,120.0] align:#right fieldwidth:60
  --     spinner rim_thickness ~PLUGIN_CIVILSTRUCTURE_RIM_WIDTH~ range:[0,10000,120.0] align:#right fieldwidth:60
  --   )
  --   group ~PLUGIN_CIVILSTRUCTURE_CONE_DIMENSIONS~
  --   (
  --     spinner cone_length ~PLUGIN_CIVILSTRUCTURE_LENGTH~ range:[0,10000,120.0] align:#right fieldwidth:60
  --     spinner cone_widthOrDia ~PLUGIN_CIVILSTRUCTURE_WIDTH~ range:[0,10000,120.0] align:#right fieldwidth:60
  --     spinner cone_height ~PLUGIN_CIVILSTRUCTURE_HEIGHT~ range:[0,10000,120.0] align:#right fieldwidth:60
  --   )
  --   group ~PLUGIN_CIVILSTRUCTURE_FRAME_OFFSET~
  --   (
  --     spinner concentric_offset_x ~PLUGIN_CIVILSTRUCTURE_X_OFFSET~ range:[-10000,10000,0.0] align:#right fieldwidth:60
  --     spinner concentric_offset_y ~PLUGIN_CIVILSTRUCTURE_Y_OFFSET~ range:[-10000,10000,0.0] align:#right fieldwidth:60
  --   )
  -- )

  rollout about_rollout ~PLUGIN_CIVILSTRUCTURE_ROLLOUT~
  (
    group ~PLUGIN_CIVILSTRUCTURE_GROUP~
    (
      label LBtext01 ~PLUGIN_CIVILSTRUCTURE_TEXT01~ align:#center
      label LBtext02 ~PLUGIN_CIVILSTRUCTURE_TEXT02~ align:#center
    )
  )

  on buildMesh do
  (
    --- Calculate Radii
    local LOCstructure_widthOrDia = structure_widthOrDia * 0.5
    local LOCframe_widthOrDia  = frame_widthOrDia * 0.5
    local LOCcone_widthOrDia   = cone_widthOrDia * 0.5
    local LOCstructure_length     = structure_length * 0.5
    local LOCframe_length      = frame_length * 0.5
    local LOCcone_length       = cone_length * 0.5

    if type == 1 then
    (
      --- Build Rectangular Structure ---
      -- Vertex data (40 verts)-----------------------
      vp = #(   [-LOCstructure_widthOrDia,-LOCstructure_length,-structure_height], -- 1
      [LOCstructure_widthOrDia,-LOCstructure_length,-structure_height],
      [-LOCstructure_widthOrDia,LOCstructure_length,-structure_height],
      [LOCstructure_widthOrDia,LOCstructure_length,-structure_height],

      [-LOCframe_widthOrDia,-LOCframe_length,0.0], -- 5
      [LOCframe_widthOrDia,-LOCframe_length,0.0],
      [-LOCframe_widthOrDia,LOCframe_length,0.0],
      [LOCframe_widthOrDia,LOCframe_length,0.0],

      [-LOCstructure_widthOrDia+wall_thickness,-LOCstructure_length+wall_thickness,-structure_height+floor_thickness], -- 9
      [LOCstructure_widthOrDia-wall_thickness,-LOCstructure_length+wall_thickness,-structure_height+floor_thickness],
      [-LOCstructure_widthOrDia+wall_thickness,LOCstructure_length-wall_thickness,-structure_height+floor_thickness],
      [LOCstructure_widthOrDia-wall_thickness,LOCstructure_length-wall_thickness,-structure_height+floor_thickness],

      [-LOCstructure_widthOrDia+wall_thickness,-LOCstructure_length+wall_thickness,-cone_height-frame_height-wall_thickness], -- 13
      [LOCstructure_widthOrDia-wall_thickness,-LOCstructure_length+wall_thickness,-cone_height-frame_height-wall_thickness],
      [-LOCstructure_widthOrDia+wall_thickness,LOCstructure_length-wall_thickness,-cone_height-frame_height-wall_thickness],
      [LOCstructure_widthOrDia-wall_thickness,LOCstructure_length-wall_thickness,-cone_height-frame_height-wall_thickness],

      [LOCstructure_widthOrDia,-LOCstructure_length,-cone_height-frame_height], -- 17
      [-LOCstructure_widthOrDia,-LOCstructure_length,-cone_height-frame_height],
      [LOCstructure_widthOrDia,LOCstructure_length,-cone_height-frame_height],
      [-LOCstructure_widthOrDia,LOCstructure_length,-cone_height-frame_height],

      [LOCframe_widthOrDia,-LOCframe_length,-frame_height],  -- 21
      [-LOCframe_widthOrDia,-LOCframe_length,-frame_height],
      [LOCframe_widthOrDia,LOCframe_length,-frame_height],
      [-LOCframe_widthOrDia,LOCframe_length,-frame_height],

      [LOCcone_widthOrDia,-LOCcone_length,-frame_height],  -- 25
      [-LOCcone_widthOrDia,-LOCcone_length,-frame_height],
      [LOCcone_widthOrDia,LOCcone_length,-frame_height],
      [-LOCcone_widthOrDia,LOCcone_length,-frame_height],

      [-LOCcone_widthOrDia+wall_thickness,-LOCcone_length+wall_thickness,-frame_height-wall_thickness], -- 29
      [LOCcone_widthOrDia-wall_thickness,-LOCcone_length+wall_thickness,-frame_height-wall_thickness],
      [LOCframe_widthOrDia-rim_thickness,-LOCframe_length+rim_thickness,0.0],
      [-LOCframe_widthOrDia+rim_thickness,-LOCframe_length+rim_thickness,0.0],

      [LOCcone_widthOrDia-wall_thickness,LOCcone_length-wall_thickness,-frame_height-wall_thickness], -- 33
      [LOCframe_widthOrDia-rim_thickness,LOCframe_length-rim_thickness,0.0],
      [-LOCcone_widthOrDia+wall_thickness,LOCcone_length-wall_thickness,-frame_height-wall_thickness],
      [-LOCframe_widthOrDia+rim_thickness,LOCframe_length-rim_thickness,0.0],

      [LOCframe_widthOrDia-rim_thickness,-LOCframe_length+rim_thickness,-frame_height-wall_thickness], -- 37
      [LOCframe_widthOrDia-rim_thickness,LOCframe_length-rim_thickness,-frame_height-wall_thickness],
      [-LOCframe_widthOrDia+rim_thickness,LOCframe_length-rim_thickness,-frame_height-wall_thickness],
      [-LOCframe_widthOrDia+rim_thickness,-LOCframe_length+rim_thickness,-frame_height-wall_thickness])
      -- Face data (76 faces) ---------------------------
      fl = #(   [1,3,4],
      [4,2,1],
      [2,17,18],
      [18,1,2],
      [4,19,17],
      [17,2,4],
      [3,20,19],
      [19,4,3],
      [1,18,20],
      [20,3,1],
      [9,10,12],
      [12,11,9],
      [9,13,14],
      [14,10,9],
      [10,14,16],
      [16,12,10],
      [12,16,15],
      [15,11,12],
      [11,15,13],
      [13,9,11],
      [25,26,18],
      [18,17,25],
      [27,25,17],
      [17,19,27],
      [28,27,19],
      [19,20,28],
      [26,28,20],
      [20,18,26],
      [5,22,21],
      [21,6,5],
      [6,21,23],
      [23,8,6],
      [8,23,24],
      [24,7,8],
      [7,24,22],
      [22,5,7],
      [25,21,22],
      [22,26,25],
      [27,23,21],
      [21,25,27],
      [28,24,23],
      [23,27,28],
      [26,22,24],
      [24,28,26],
      [32,36,7],
      [32,7,5],
      [31,32,5],
      [31,5,6],
      [31,6,8],
      [34,31,8],
      [34,8,7],
      [34,7,36],
      [35,15,16],
      [33,35,16],
      [30,33,16],
      [30,16,14],
      [29,30,14],
      [29,14,13],
      [29,13,15],
      [29,15,35],
      [33,38,39],
      [39,35,33],
      [32,40,39],
      [39,36,32],
      [31,37,40],
      [40,32,31],
      [34,38,37],
      [37,31,34],
      [34,36,39],
      [39,38,34],
      [29,35,39],
      [39,40,29],
      [30,29,40],
      [40,37,30],
      [33,30,37],
      [37,38,33])
      -- Material ID data (76) ---------------------------
      fm = #(   1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      1,
      1,
      1,
      1,
      1,
      1)
      -- Smoothing data (76) ---------------------------
      fs = #(   0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0)

      -- Edge visibility data (76) ---------------------------
      fe = #(   #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, false, false),
      #(false, true, false),
      #(true, false, false),
      #(false, true, false),
      #(false, true, false),
      #(true, false, false),
      #(false, true, false),
      #(false, false, true),
      #(false, true, false),
      #(true, false, false),
      #(true, false, false),
      #(false, true, false),
      #(true, false, false),
      #(false, true, false),
      #(false, true, false),
      #(false, false, true),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false),
      #(true, true, false))
      -- Texture coordinate vertices (116) ---------------------------
      tv = #(   [0.999501,0.000499874,0.000499517],
      [0.000499606,0.000499636,0.000499517],
      [0.9995,0.9995,0.000499517],
      [0.000499487,0.9995,0.000499517],
      [0.187812,0.999501,0.25025],
      [0.812188,0.999501,0.25025],
      [0.812188,0.999501,0.74975],
      [0.74975,0.999501,0.812188],
      [0.127985,0.244427,0.189385],
      [0.872015,0.244427,0.189385],
      [0.127985,0.755573,0.189385],
      [0.872015,0.755573,0.189385],
      [0.872015,0.5,0.244427],
      [0.127985,0.5,0.244427],
      [0.127985,0.5,0.755573],
      [0.244427,0.5,0.872015],
      [0.9995,0.624875,0.000499576],
      [0.000499517,0.624875,0.000499874],
      [0.9995,0.624875,0.999501],
      [0.9995,0.624875,0.9995],
      [0.812188,0.824675,0.25025],
      [0.187812,0.824675,0.25025],
      [0.74975,0.824675,0.812188],
      [0.812188,0.824675,0.74975],
      [0.874625,0.167,0.824675],
      [0.125375,0.167,0.824675],
      [0.874625,0.833,0.824675],
      [0.125375,0.833,0.824675],
      [0.793244,0.304504,0.74975],
      [0.206756,0.304504,0.74975],
      [0.74975,0.3335,0.999501],
      [0.25025,0.3335,0.999501],
      [0.206756,0.695496,0.74975],
      [0.74975,0.6665,0.999501],
      [0.793244,0.695496,0.74975],
      [0.25025,0.6665,0.999501],
      [0.25025,0.74975,0.3335],
      [0.25025,0.6665,0.74975],
      [0.74975,0.6665,0.74975],
      [0.3335,0.74975,0.25025],
      [0.000499517,0.000499517,0.000499874],
      [0.9995,0.000499517,0.000499636],
      [0.000499636,0.000499517,0.9995],
      [0.9995,0.000499517,0.999501],
      [0.000499576,0.624875,0.9995],
      [0.000499487,0.000499517,0.9995],
      [0.9995,0.000499517,0.9995],
      [0.000499487,0.624875,0.9995],
      [0.000499606,0.000499517,0.000499636],
      [0.9995,0.000499517,0.000499517],
      [0.9995,0.624875,0.000499517],
      [0.000499606,0.624875,0.000499636],
      [0.872015,0.189385,0.244427],
      [0.127985,0.189385,0.244427],
      [0.755573,0.189385,0.872015],
      [0.755573,0.5,0.872015],
      [0.244427,0.189385,0.872015],
      [0.872015,0.189385,0.755573],
      [0.872015,0.5,0.755573],
      [0.127985,0.189385,0.755573],
      [0.755573,0.189385,0.127985],
      [0.755573,0.5,0.127985],
      [0.244427,0.5,0.127985],
      [0.244427,0.189385,0.127985],
      [0.9995,0.000499576,0.624875],
      [0.000499517,0.000499874,0.624875],
      [0.999501,0.9995,0.624875],
      [0.9995,0.000499576,0.624875],
      [0.000499636,0.9995,0.624875],
      [0.999501,0.9995,0.624875],
      [0.000499517,0.000499874,0.624875],
      [0.000499636,0.9995,0.624875],
      [0.25025,0.999501,0.812188],
      [0.25025,0.824675,0.812188],
      [0.187812,0.999501,0.74975],
      [0.187812,0.824675,0.74975],
      [0.74975,0.824675,0.187812],
      [0.74975,0.999501,0.187812],
      [0.25025,0.999501,0.187812],
      [0.25025,0.824675,0.187812],
      [0.812188,0.25025,0.824675],
      [0.187812,0.25025,0.824675],
      [0.812188,0.74975,0.824675],
      [0.812188,0.25025,0.824675],
      [0.187812,0.74975,0.824675],
      [0.812188,0.74975,0.824675],
      [0.187812,0.25025,0.824675],
      [0.187812,0.74975,0.824675],
      [0.187812,0.74975,0.999501],
      [0.187812,0.25025,0.999501],
      [0.812188,0.25025,0.999501],
      [0.812188,0.74975,0.999501],
      [0.187812,0.74975,0.999501],
      [0.872015,0.755573,0.5],
      [0.127985,0.755573,0.5],
      [0.127985,0.244427,0.5],
      [0.872015,0.244427,0.5],
      [0.872015,0.755573,0.5],
      [0.6665,0.999501,0.25025],
      [0.3335,0.999501,0.25025],
      [0.6665,0.74975,0.25025],
      [0.74975,0.999501,0.3335],
      [0.25025,0.999501,0.3335],
      [0.74975,0.74975,0.3335],
      [0.6665,0.999501,0.74975],
      [0.3335,0.999501,0.74975],
      [0.3335,0.74975,0.74975],
      [0.6665,0.74975,0.74975],
      [0.74975,0.74975,0.6665],
      [0.74975,0.999501,0.6665],
      [0.25025,0.999501,0.6665],
      [0.25025,0.74975,0.6665],
      [0.74975,0.3335,0.74975],
      [0.25025,0.3335,0.74975],
      [0.74975,0.3335,0.74975],
      [0.25025,0.3335,0.74975])
      -- Texture coordinate faces (76) ---------------------------
      tf = #(   [1,3,4],
      [4,2,1],
      [42,17,18],
      [18,41,42],
      [44,19,45],
      [45,43,44],
      [47,20,48],
      [48,46,47],
      [50,51,52],
      [52,49,50],
      [9,10,12],
      [12,11,9],
      [53,13,14],
      [14,54,53],
      [55,56,16],
      [16,57,55],
      [58,59,15],
      [15,60,58],
      [61,62,63],
      [63,64,61],
      [25,26,66],
      [66,65,25],
      [27,25,68],
      [68,67,27],
      [28,27,70],
      [70,69,28],
      [26,28,72],
      [72,71,26],
      [5,22,21],
      [21,6,5],
      [73,74,23],
      [23,8,73],
      [75,76,24],
      [24,7,75],
      [79,80,77],
      [77,78,79],
      [25,81,82],
      [82,26,25],
      [27,83,84],
      [84,25,27],
      [28,85,86],
      [86,27,28],
      [26,87,88],
      [88,28,26],
      [32,36,89],
      [32,89,90],
      [31,32,90],
      [31,90,91],
      [31,91,92],
      [34,31,92],
      [34,92,93],
      [34,93,36],
      [35,94,95],
      [33,35,95],
      [30,33,95],
      [30,95,96],
      [29,30,96],
      [29,96,97],
      [29,97,98],
      [29,98,35],
      [33,38,39],
      [39,35,33],
      [100,40,101],
      [101,99,100],
      [103,37,104],
      [104,102,103],
      [106,107,108],
      [108,105,106],
      [110,111,112],
      [112,109,110],
      [29,35,39],
      [39,113,29],
      [30,29,115],
      [115,114,30],
      [33,30,116],
      [116,38,33])

      -- Offset Concentric Rim
      for i = 5 to 8 do
      (
        oldpos = vp[i]
        vp[i].x = (oldpos.x + concentric_offset_x)
        vp[i].y = (oldpos.y + concentric_offset_y)
      )
      for i = 21 to 40 do
      (
        oldpos = vp[i]
        vp[i].x = (oldpos.x + concentric_offset_x)
        vp[i].y = (oldpos.y + concentric_offset_y)
      )

      -- Create mesh for buildMesh
      if use_matid then
      (
        setMesh mesh vertices:vp faces:fl materialIDs:fm
      )
      else
      (
        setMesh mesh vertices:vp faces:fl
      )

      if mapcoords then
      (
        -- Create texture coordinates
        meshOp.setMapSupport mesh 1 true
        meshOp.setNumMapVerts mesh 1 116
        for i=1 to 116 do
        (
          meshOp.setMapVert mesh 1 i tv[i]
        )
      )
      else
      (
        -- Delete any texture coordinates
        meshOp.setMapSupport mesh 1 false
      )
      -- Apply additional face data
      for i = 1 to 76 do
      (
        setFaceSmoothGroup mesh i fs[i]
        for j = 1 to 3 do (setEdgeVis mesh i j fe[i][j])
        if mapcoords then meshOp.setMapFace mesh 1 i tf[i]
      )
    )
    else
    (
      --- Build Cylindrical Structure ---
      -- Vertex data (120 verts)-----------------------
      vp = #(  \
      [0.996088,0,-structure_height+floor_thickness], -- 1
      [0.859648,0.50318,-structure_height+floor_thickness],
      [0.50318,0.859648,-structure_height+floor_thickness],
      [0,0.996088,-structure_height+floor_thickness],
      [-0.50318,0.859648,-structure_height+floor_thickness],
      [-0.859648,0.50318,-structure_height+floor_thickness],
      [-0.996088,0,-structure_height+floor_thickness],
      [-0.859648,-0.50318,-structure_height+floor_thickness],
      [-0.50318,-0.859648,-structure_height+floor_thickness],
      [0,-0.996088,-structure_height+floor_thickness],
      [0.50318,-0.859648,-structure_height+floor_thickness],
      [0.859648,-0.50318,-structure_height+floor_thickness],

      [0,-1,-structure_height], -- 2
      [0.504591,-0.863359,-structure_height],
      [0.863359,-0.504591,-structure_height],
      [1,0,-structure_height],
      [0.863359,0.504591,-structure_height],
      [0.504591,0.863359,-structure_height],
      [0,1,-structure_height],
      [-0.504591,0.863359,-structure_height],
      [-0.863359,0.50459,-structure_height],
      [-1,0,-structure_height],
      [-0.863359,-0.504591,-structure_height],
      [-0.504591,-0.863359,-structure_height],

      [0,-0.967636,-frame_height], -- 3
      [0.4882,-0.835448,-frame_height],
      [0.835448,-0.4882,-frame_height],
      [0.967636,0,-frame_height],
      [0.835448,0.4882,-frame_height],
      [0.4882,0.835448,-frame_height],
      [0,0.967636,-frame_height],
      [-0.4882,0.835448,-frame_height],
      [-0.835448,0.4882,-frame_height],
      [-0.967636,0,-frame_height],
      [-0.835448,-0.4882,-frame_height],
      [-0.4882,-0.835448,-frame_height],

      [0,-0.964048,-frame_height],  -- 4
      [0.486572,-0.832236,-frame_height],
      [0.832236,-0.486572,-frame_height],
      [0.964048,0,-frame_height],
      [0.832236,0.486572,-frame_height],
      [0.486572,0.832236,-frame_height],
      [0,0.964048,-frame_height],
      [-0.486572,0.832236,-frame_height],
      [-0.832237,0.486571,-frame_height],
      [-0.964048,0,-frame_height],
      [-0.832236,-0.486572,-frame_height],
      [-0.486572,-0.832236,-frame_height],

      [0,-0.946757,0.0], -- 5
      [0.477976,-0.817233,0.0],
      [0.817233,-0.477976,0.0],
      [0.946757,0,0.0],
      [0.817233,0.477976,0.0],
      [0.477976,0.817233,0.0],
      [0,0.946757,0.0],
      [-0.477976,0.817233,0.0],
      [-0.817233,0.477976,0.0],
      [-0.946757,0,0.0],
      [-0.817233,-0.477976,0.0],
      [-0.477976,-0.817233,0.0],

      [0,-0.94072,0.0],  -- 6
      [0.475004,-0.811971,0.0],
      [0.811972,-0.475004,0.0],
      [0.94072,0,0.0],
      [0.811971,0.475004,0.0],
      [0.475004,0.811972,0.0],
      [0,0.94072,0.0],
      [-0.475004,0.811971,0.0],
      [-0.811972,0.475004,0.0],
      [-0.94072,0,0.0],
      [-0.811971,-0.475004,0.0],
      [-0.475004,-0.811972,0.0],

      [0,-0.965311,-frame_height-wall_thickness], -- 7
      [0.487548,-0.83313,-frame_height-wall_thickness],
      [0.83313,-0.487548,-frame_height-wall_thickness],
      [0.965311,0,-frame_height-wall_thickness],
      [0.83313,0.487548,-frame_height-wall_thickness],
      [0.487548,0.83313,-frame_height-wall_thickness],
      [0,0.965311,-frame_height-wall_thickness],
      [-0.487548,0.83313,-frame_height-wall_thickness],
      [-0.833131,0.487548,-frame_height-wall_thickness],
      [-0.965311,0,-frame_height-wall_thickness],
      [-0.83313,-0.487548,-frame_height-wall_thickness],
      [-0.487548,-0.83313,-frame_height-wall_thickness],

      [0,-0.966236,-frame_height-wall_thickness], -- 8
      [0.487945,-0.833967,-frame_height-wall_thickness],
      [0.833967,-0.487945,-frame_height-wall_thickness],
      [0.966236,0,-frame_height-wall_thickness],
      [0.833967,0.487945,-frame_height-wall_thickness],
      [0.487945,0.833967,-frame_height-wall_thickness],
      [0,0.966236,-frame_height-wall_thickness],
      [-0.487945,0.833967,-frame_height-wall_thickness],
      [-0.833967,0.487945,-frame_height-wall_thickness],
      [-0.966236,0,-frame_height-wall_thickness],
      [-0.833967,-0.487945,-frame_height-wall_thickness],
      [-0.487945,-0.833967,-frame_height-wall_thickness],

      [0,-0.991825,-cone_height-frame_height],  -- 9
      [0.500433,-0.85632,-cone_height-frame_height],
      [0.85632,-0.500432,-cone_height-frame_height],
      [0.991825,0,-cone_height-frame_height],
      [0.85632,0.500433,-cone_height-frame_height],
      [0.500432,0.85632,-cone_height-frame_height],
      [-0.500433,0.85632,-cone_height-frame_height],
      [-0.85632,-0.500433,-cone_height-frame_height],
      [-0.500432,-0.85632,-cone_height-frame_height],
      [0,0.991825,-cone_height-frame_height],
      [-0.85632,0.500432,-cone_height-frame_height],
      [-0.991825,0,-cone_height-frame_height],

      [0,-0.987135,-cone_height-frame_height-wall_thickness], -- 10
      [0.498417,-0.852061,-cone_height-frame_height-wall_thickness],
      [0.852061,-0.498417,-cone_height-frame_height-wall_thickness],
      [0.987135,0,-cone_height-frame_height-wall_thickness],
      [0.852061,0.498417,-cone_height-frame_height-wall_thickness],
      [0.498417,0.852061,-cone_height-frame_height-wall_thickness],
      [0,0.987135,-cone_height-frame_height-wall_thickness],
      [-0.498417,0.852061,-cone_height-frame_height-wall_thickness],
      [-0.852061,0.498417,-cone_height-frame_height-wall_thickness],
      [-0.987135,0,-cone_height-frame_height-wall_thickness],
      [-0.852061,-0.498417,-cone_height-frame_height-wall_thickness],
      [-0.498417,-0.852061,-cone_height-frame_height-wall_thickness])

      -- Face data (236 faces) ---------------------------
      fl = #(   [13,24,14],
      [15,14,16],
      [16,14,17],
      [17,14,18],
      [18,14,19],
      [19,14,20],
      [20,14,21],
      [21,14,22],
      [22,14,23],
      [14,24,23],
      [97,105,13],
      [24,13,105],
      [98,97,14],
      [13,14,97],
      [99,98,15],
      [14,15,98],
      [100,99,16],
      [15,16,99],
      [101,100,17],
      [16,17,100],
      [102,101,18],
      [17,18,101],
      [106,102,19],
      [18,19,102],
      [103,106,20],
      [19,20,106],
      [107,103,21],
      [20,21,103],
      [108,107,22],
      [21,22,107],
      [104,108,23],
      [22,23,108],
      [105,104,24],
      [23,24,104],
      [37,48,25],
      [36,25,48],
      [38,37,26],
      [25,26,37],
      [39,38,27],
      [26,27,38],
      [40,39,28],
      [27,28,39],
      [41,40,29],
      [28,29,40],
      [42,41,30],
      [29,30,41],
      [43,42,31],
      [30,31,42],
      [44,43,32],
      [31,32,43],
      [45,44,33],
      [32,33,44],
      [46,45,34],
      [33,34,45],
      [47,46,35],
      [34,35,46],
      [48,47,36],
      [35,36,47],
      [49,60,37],
      [48,37,60],
      [50,49,38],
      [37,38,49],
      [51,50,39],
      [38,39,50],
      [52,51,40],
      [39,40,51],
      [53,52,41],
      [40,41,52],
      [54,53,42],
      [41,42,53],
      [55,54,43],
      [42,43,54],
      [56,55,44],
      [43,44,55],
      [57,56,45],
      [44,45,56],
      [58,57,46],
      [45,46,57],
      [59,58,47],
      [46,47,58],
      [60,59,48],
      [47,48,59],
      [61,72,49],
      [60,49,72],
      [62,61,50],
      [49,50,61],
      [63,62,51],
      [50,51,62],
      [64,63,52],
      [51,52,63],
      [65,64,53],
      [52,53,64],
      [66,65,54],
      [53,54,65],
      [67,66,55],
      [54,55,66],
      [68,67,56],
      [55,56,67],
      [69,68,57],
      [56,57,68],
      [70,69,58],
      [57,58,69],
      [71,70,59],
      [58,59,70],
      [72,71,60],
      [59,60,71],
      [73,84,61],
      [72,61,84],
      [74,73,62],
      [61,62,73],
      [75,74,63],
      [62,63,74],
      [76,75,64],
      [63,64,75],
      [77,76,65],
      [64,65,76],
      [78,77,66],
      [65,66,77],
      [79,78,67],
      [66,67,78],
      [80,79,68],
      [67,68,79],
      [81,80,69],
      [68,69,80],
      [82,81,70],
      [69,70,81],
      [83,82,71],
      [70,71,82],
      [84,83,72],
      [71,72,83],
      [85,96,73],
      [84,73,96],
      [86,85,74],
      [73,74,85],
      [87,86,75],
      [74,75,86],
      [88,87,76],
      [75,76,87],
      [89,88,77],
      [76,77,88],
      [90,89,78],
      [77,78,89],
      [91,90,79],
      [78,79,90],
      [92,91,80],
      [79,80,91],
      [93,92,81],
      [80,81,92],
      [94,93,82],
      [81,82,93],
      [95,94,83],
      [82,83,94],
      [96,95,84],
      [83,84,95],
      [109,120,85],
      [96,85,120],
      [110,109,86],
      [85,86,109],
      [111,110,87],
      [86,87,110],
      [112,111,88],
      [87,88,111],
      [113,112,89],
      [88,89,112],
      [114,113,90],
      [89,90,113],
      [115,114,91],
      [90,91,114],
      [116,115,92],
      [91,92,115],
      [117,116,93],
      [92,93,116],
      [118,117,94],
      [93,94,117],
      [119,118,95],
      [94,95,118],
      [120,119,96],
      [95,96,119],
      [25,36,97],
      [105,97,36],
      [26,25,98],
      [97,98,25],
      [27,26,99],
      [98,99,26],
      [28,27,100],
      [99,100,27],
      [29,28,101],
      [100,101,28],
      [30,29,102],
      [101,102,29],
      [31,30,106],
      [102,106,30],
      [32,31,103],
      [106,103,31],
      [33,32,107],
      [103,107,32],
      [34,33,108],
      [107,108,33],
      [35,34,104],
      [108,104,34],
      [36,35,105],
      [104,105,35],
      [109,10,120],
      [9,120,10],
      [110,11,109],
      [10,109,11],
      [111,12,110],
      [11,110,12],
      [112,1,111],
      [12,111,1],
      [113,2,112],
      [1,112,2],
      [114,3,113],
      [2,113,3],
      [115,4,114],
      [3,114,4],
      [116,5,115],
      [4,115,5],
      [117,6,116],
      [5,116,6],
      [118,7,117],
      [6,117,7],
      [119,8,118],
      [7,118,8],
      [120,9,119],
      [8,119,9],
      [7,8,6],
      [5,6,4],
      [3,4,2],
      [4,6,2],
      [1,2,12],
      [11,12,10],
      [12,2,10],
      [2,6,10],
      [6,8,10],
      [8,9,10])
      -- Material ID data (236) ---------------------------
      fm = #(   1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2)
      -- Smoothing data (236) ---------------------------
      fs = #(   1024,
      1024,
      1024,
      1024,
      1024,
      1024,
      1024,
      1024,
      1024,
      1024,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      1,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      8,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      16,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      32,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      64,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      128,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      2,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      256,
      512,
      512,
      512,
      512,
      512,
      512,
      512,
      512,
      512,
      512)
      -- Edge visibility data (236) ---------------------------
      fe = #(   #(true, false, true),
      #(true, false, true),
      #(false, false, true),
      #(false, false, true),
      #(false, false, true),
      #(false, false, true),
      #(false, false, true),
      #(false, false, true),
      #(false, false, true),
      #(false, true, false),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(true, false, true),
      #(false, false, false),
      #(true, false, true),
      #(true, false, true),
      #(false, false, false),
      #(false, false, false),
      #(false, false, false),
      #(true, true, false))
      -- Texture coordinate vertices (152) ---------------------------
      tv = #(   [0.75,0.0627714,0.851105],
      [0.834283,0.0627714,0.851102],
      [0.915717,0.0627714,0.851102],
      [1,0.0627714,0.851105],
      [0.0842829,0.0627714,0.851102],
      [0.165717,0.0627714,0.851102],
      [0.25,0.0627714,0.851105],
      [0.334283,0.0627714,0.851102],
      [0.415717,0.0627714,0.851102],
      [0.5,0.0627714,0.851105],
      [0.584283,0.0627714,0.851102],
      [0.665717,0.0627714,0.851102],
      [0.5,0.000499517,0.999001],
      [0.584178,0.000499517,0.999001],
      [0.665822,0.000499517,0.999001],
      [0.75,0.000499517,0.999001],
      [0.834178,0.000499517,0.999001],
      [0.915822,0.000499517,0.999001],
      [1,0.000499517,0.999001],
      [0.0841783,0.000499517,0.999001],
      [0.165822,0.000499517,0.999001],
      [0.25,0.000499517,0.999001],
      [0.334178,0.000499517,0.999001],
      [0.415822,0.000499517,0.999001],
      [0.516952,0.933254,0.642588],
      [0.605045,0.933254,0.687706],
      [0.684855,0.933254,0.733576],
      [0.762683,0.933254,0.771096],
      [0.837899,0.933254,0.790502],
      [0.910176,0.933254,0.788295],
      [0.985764,0.933254,0.764775],
      [0.0643543,0.933254,0.724468],
      [0.145243,0.933254,0.677983],
      [0.23459,0.933254,0.63499],
      [0.329336,0.933254,0.610656],
      [0.423102,0.933254,0.613502],
      [0.520644,0.933254,0.528156],
      [0.609263,0.933254,0.573684],
      [0.688353,0.933254,0.619301],
      [0.764908,0.933254,0.656298],
      [0.838566,0.933254,0.675312],
      [0.909177,0.933254,0.673155],
      [0.983244,0.933254,0.65009],
      [0.0606564,0.933254,0.610278],
      [0.14101,0.933254,0.563931],
      [0.231183,0.933254,0.520422],
      [0.328255,0.933254,0.495486],
      [0.424741,0.933254,0.498412],
      [0.521062,0.999501,0.517752],
      [0.609754,0.999501,0.563337],
      [0.688716,0.999501,0.608901],
      [0.76515,0.999501,0.645851],
      [0.838657,0.999501,0.664824],
      [0.90905,0.999501,0.662674],
      [0.982969,0.999501,0.639655],
      [0.0602701,0.999501,0.599887],
      [0.140516,0.999501,0.553581],
      [0.230797,0.999501,0.510002],
      [0.328156,0.999501,0.484996],
      [0.424903,0.999501,0.48793],
      [0.526701,0.999501,0.409126],
      [0.615903,0.999501,0.455248],
      [0.693722,0.999501,0.500437],
      [0.768247,0.999501,0.536606],
      [0.839546,0.999501,0.555032],
      [0.907702,0.999501,0.552949],
      [0.97945,0.999501,0.53057],
      [0.05495,0.999501,0.491552],
      [0.134297,0.999501,0.445464],
      [0.225551,0.999501,0.401175],
      [0.326399,0.999501,0.375252],
      [0.427534,0.999501,0.378315],
      [0.525934,0.836533,0.421109],
      [0.615109,0.836533,0.467181],
      [0.69304,0.836533,0.512394],
      [0.767843,0.836533,0.548678],
      [0.839453,0.836533,0.56718],
      [0.907855,0.836533,0.56509],
      [0.979909,0.836533,0.54262],
      [0.055675,0.836533,0.503491],
      [0.135103,0.836533,0.457399],
      [0.226267,0.836533,0.413186],
      [0.326674,0.836533,0.387387],
      [0.427139,0.836533,0.39043],
      [0.520593,0.836533,0.529473],
      [0.609257,0.836533,0.575024],
      [0.688257,0.836533,0.620589],
      [0.764878,0.836533,0.657621],
      [0.838602,0.836533,0.676644],
      [0.909145,0.836533,0.674489],
      [0.983278,0.836533,0.651411],
      [0.060756,0.836533,0.611563],
      [0.141015,0.836533,0.565272],
      [0.231231,0.836533,0.521741],
      [0.328331,0.836533,0.496806],
      [0.424657,0.836533,0.499727],
      [0.5,0.575521,0.990834],
      [0.584172,0.575521,0.990834],
      [0.665828,0.575521,0.990834],
      [0.75,0.575521,0.990834],
      [0.834172,0.575521,0.990834],
      [0.915828,0.575521,0.990834],
      [0.0841722,0.575521,0.990834],
      [0.334172,0.575521,0.990834],
      [0.415828,0.575521,0.990834],
      [1,0.575521,0.990834],
      [0.165828,0.575521,0.990834],
      [0.25,0.575521,0.990834],
      [0.5,0.478801,0.843455],
      [0.584238,0.478801,0.843452],
      [0.665762,0.478801,0.843452],
      [0.75,0.478801,0.843455],
      [0.834238,0.478801,0.843452],
      [0.915762,0.478801,0.843452],
      [1,0.478801,0.843455],
      [0.0842381,0.478801,0.843452],
      [0.165762,0.478801,0.843452],
      [0.25,0.478801,0.843455],
      [0.334238,0.478801,0.843452],
      [0.415762,0.478801,0.843452],
      [0,0.000499517,0.999001],
      [0,0.575521,0.990834],
      [0,0.000499517,0.999001],
      [0,0.575521,0.990834],
      [-0.0167561,0.933254,0.65009],
      [-0.0142361,0.933254,0.764775],
      [-0.0167561,0.933254,0.65009],
      [-0.0170305,0.999501,0.639655],
      [-0.0167561,0.933254,0.65009],
      [-0.0170305,0.999501,0.639655],
      [-0.0205499,0.999501,0.53057],
      [-0.0170305,0.999501,0.639655],
      [-0.0205499,0.999501,0.53057],
      [-0.0200911,0.836533,0.54262],
      [-0.0205499,0.999501,0.53057],
      [-0.0200911,0.836533,0.54262],
      [-0.016722,0.836533,0.651411],
      [-0.0200911,0.836533,0.54262],
      [-0.016722,0.836533,0.651411],
      [0,0.478801,0.843455],
      [-0.016722,0.836533,0.651411],
      [0,0.478801,0.843455],
      [-0.0142361,0.933254,0.764775],
      [0,0.575521,0.990834],
      [-0.0142361,0.933254,0.764775],
      [0,0.478801,0.843455],
      [0,0.0627714,0.851105],
      [0,0.478801,0.843455],
      [0,0.0627714,0.851105],
      [0,0.0627714,0.851105],
      [-0.165717,0.0627714,0.851102],
      [-0.165717,0.0627714,0.851102])
      -- Texture coordinate faces (236) ---------------------------
      tf = #(   [13,24,14],
      [15,14,16],
      [16,14,17],
      [17,14,18],
      [18,14,19],
      [121,14,20],
      [20,14,21],
      [21,14,22],
      [22,14,23],
      [14,24,23],
      [97,105,13],
      [24,13,105],
      [98,97,14],
      [13,14,97],
      [99,98,15],
      [14,15,98],
      [100,99,16],
      [15,16,99],
      [101,100,17],
      [16,17,100],
      [102,101,18],
      [17,18,101],
      [106,102,19],
      [18,19,102],
      [103,122,20],
      [123,20,124],
      [107,103,21],
      [20,21,103],
      [108,107,22],
      [21,22,107],
      [104,108,23],
      [22,23,108],
      [105,104,24],
      [23,24,104],
      [37,48,25],
      [36,25,48],
      [38,37,26],
      [25,26,37],
      [39,38,27],
      [26,27,38],
      [40,39,28],
      [27,28,39],
      [41,40,29],
      [28,29,40],
      [42,41,30],
      [29,30,41],
      [43,42,31],
      [30,31,42],
      [44,125,32],
      [126,32,127],
      [45,44,33],
      [32,33,44],
      [46,45,34],
      [33,34,45],
      [47,46,35],
      [34,35,46],
      [48,47,36],
      [35,36,47],
      [49,60,37],
      [48,37,60],
      [50,49,38],
      [37,38,49],
      [51,50,39],
      [38,39,50],
      [52,51,40],
      [39,40,51],
      [53,52,41],
      [40,41,52],
      [54,53,42],
      [41,42,53],
      [55,54,43],
      [42,43,54],
      [56,128,44],
      [129,44,130],
      [57,56,45],
      [44,45,56],
      [58,57,46],
      [45,46,57],
      [59,58,47],
      [46,47,58],
      [60,59,48],
      [47,48,59],
      [61,72,49],
      [60,49,72],
      [62,61,50],
      [49,50,61],
      [63,62,51],
      [50,51,62],
      [64,63,52],
      [51,52,63],
      [65,64,53],
      [52,53,64],
      [66,65,54],
      [53,54,65],
      [67,66,55],
      [54,55,66],
      [68,131,56],
      [132,56,133],
      [69,68,57],
      [56,57,68],
      [70,69,58],
      [57,58,69],
      [71,70,59],
      [58,59,70],
      [72,71,60],
      [59,60,71],
      [73,84,61],
      [72,61,84],
      [74,73,62],
      [61,62,73],
      [75,74,63],
      [62,63,74],
      [76,75,64],
      [63,64,75],
      [77,76,65],
      [64,65,76],
      [78,77,66],
      [65,66,77],
      [79,78,67],
      [66,67,78],
      [80,134,68],
      [135,68,136],
      [81,80,69],
      [68,69,80],
      [82,81,70],
      [69,70,81],
      [83,82,71],
      [70,71,82],
      [84,83,72],
      [71,72,83],
      [85,96,73],
      [84,73,96],
      [86,85,74],
      [73,74,85],
      [87,86,75],
      [74,75,86],
      [88,87,76],
      [75,76,87],
      [89,88,77],
      [76,77,88],
      [90,89,78],
      [77,78,89],
      [91,90,79],
      [78,79,90],
      [92,137,80],
      [138,80,139],
      [93,92,81],
      [80,81,92],
      [94,93,82],
      [81,82,93],
      [95,94,83],
      [82,83,94],
      [96,95,84],
      [83,84,95],
      [109,120,85],
      [96,85,120],
      [110,109,86],
      [85,86,109],
      [111,110,87],
      [86,87,110],
      [112,111,88],
      [87,88,111],
      [113,112,89],
      [88,89,112],
      [114,113,90],
      [89,90,113],
      [115,114,91],
      [90,91,114],
      [116,140,92],
      [141,92,142],
      [117,116,93],
      [92,93,116],
      [118,117,94],
      [93,94,117],
      [119,118,95],
      [94,95,118],
      [120,119,96],
      [95,96,119],
      [25,36,97],
      [105,97,36],
      [26,25,98],
      [97,98,25],
      [27,26,99],
      [98,99,26],
      [28,27,100],
      [99,100,27],
      [29,28,101],
      [100,101,28],
      [30,29,102],
      [101,102,29],
      [31,30,106],
      [102,106,30],
      [32,143,103],
      [144,103,145],
      [33,32,107],
      [103,107,32],
      [34,33,108],
      [107,108,33],
      [35,34,104],
      [108,104,34],
      [36,35,105],
      [104,105,35],
      [109,10,120],
      [9,120,10],
      [110,11,109],
      [10,109,11],
      [111,12,110],
      [11,110,12],
      [112,1,111],
      [12,111,1],
      [113,2,112],
      [1,112,2],
      [114,3,113],
      [2,113,3],
      [115,4,114],
      [3,114,4],
      [116,5,146],
      [147,148,5],
      [117,6,116],
      [5,116,6],
      [118,7,117],
      [6,117,7],
      [119,8,118],
      [7,118,8],
      [120,9,119],
      [8,119,9],
      [7,8,6],
      [5,6,149],
      [3,4,2],
      [150,6,151],
      [1,2,12],
      [11,12,10],
      [12,2,10],
      [152,6,10],
      [6,8,10],
      [8,9,10])

      --- scaling vertex positions
      for i = 1 to 12 do -- 1
      (
        oldpos = vp[i]
        vp[i].x = (oldpos.x * (LOCstructure_widthOrDia - wall_thickness))
        vp[i].y = (oldpos.y * (LOCstructure_widthOrDia - wall_thickness))
      )

      for i = 13 to 24 do -- 2
      (
        oldpos = vp[i]
        vp[i].x = (oldpos.x * LOCstructure_widthOrDia)
        vp[i].y = (oldpos.y * LOCstructure_widthOrDia)
      )

      for i = 25 to 36 do -- 3
      (
        oldpos = vp[i]
        vp[i].x = (oldpos.x * LOCcone_widthOrDia)
        vp[i].y = (oldpos.y * LOCcone_widthOrDia)
      )

      for i = 37 to 48 do -- 4
      (
        oldpos = vp[i]
        vp[i].x = (oldpos.x * LOCframe_widthOrDia)
        vp[i].y = (oldpos.y * LOCframe_widthOrDia)
      )

      for i = 49 to 60 do -- 5
      (
        oldpos = vp[i]
        vp[i].x = (oldpos.x * LOCframe_widthOrDia)
        vp[i].y = (oldpos.y * LOCframe_widthOrDia)
      )

      for i = 61 to 72 do -- 6
      (
        oldpos = vp[i]
        vp[i].x = (oldpos.x  * (LOCframe_widthOrDia-rim_thickness))
        vp[i].y = (oldpos.y  * (LOCframe_widthOrDia-rim_thickness))
      )

      for i = 73 to 84 do -- 7
      (
        oldpos = vp[i]
        vp[i].x = (oldpos.x  * (LOCframe_widthOrDia-rim_thickness))
        vp[i].y = (oldpos.y  * (LOCframe_widthOrDia-rim_thickness))
      )

      for i = 85 to 96 do -- 8
      (
        oldpos = vp[i]
        vp[i].x = (oldpos.x * (LOCcone_widthOrDia - wall_thickness))
        vp[i].y = (oldpos.y * (LOCcone_widthOrDia - wall_thickness))
      )

      for i = 97 to 108 do -- 9
      (
        oldpos = vp[i]
        vp[i].x = (oldpos.x * LOCstructure_widthOrDia)
        vp[i].y = (oldpos.y * LOCstructure_widthOrDia)
      )

      for i = 109 to 120 do
      (
        oldpos = vp[i]
        vp[i].x = (oldpos.x * (LOCstructure_widthOrDia - wall_thickness))
        vp[i].y = (oldpos.y * (LOCstructure_widthOrDia - wall_thickness))
      )

      -- Offset Concentric Rim
      for i = 25 to 96 do
      (
        oldpos = vp[i]
        vp[i].x = (oldpos.x + concentric_offset_x)
        vp[i].y = (oldpos.y + concentric_offset_y)
      )

      -- Create mesh for buildMesh
      if use_matid then
      (
        setMesh mesh vertices:vp faces:fl materialIDs:fm
      )
      else
      (
        setMesh mesh vertices:vp faces:fl
      )

      if mapcoords then
      (
        -- Create texture coordinates
        meshOp.setMapSupport mesh 1 true
        meshOp.setNumMapVerts mesh 1 152
        for i=1 to 152 do
        (
          meshOp.setMapVert mesh 1 i tv[i]
        )
      )
      else
      (
        -- Delete any texture coordinates
        meshOp.setMapSupport mesh 1 false
      )

      -- Apply additional face data
      for i = 1 to 236 do
      (
        setFaceSmoothGroup mesh i fs[i]
        for j = 1 to 3 do (setEdgeVis mesh i j fe[i][j])
        if mapcoords then meshOp.setMapFace mesh 1 i tf[i]
      )

    )
  ) -- end on buildmesh

  tool create prompt:~PLUGIN_CIVILSTRUCTURE_PROMPT~
  (
    on mousePoint click do
    (
      case click of
      (
        1: nodeTM.translation = gridPoint
        2: #stop
      )
    )
  ) -- end create tool
) -- end Plug-O-Matic plugin
plugin simpleObject Vsp_Symb name:~PLUGIN_CIVILSYMB_NAME~ category:~PLUGIN_CIVILSYMB_CATEGORY~ classID:#(1518226055,503265357) invisible:(not DYNcreatable)
(
  parameters main rollout:params
  (
    width  type:#float   default:5.0
    height type:#float   default:5.0
    type   type:#integer default:1
	)

  rollout params ~PLUGIN_CIVILSYMB_ROLLOUT~
  (
    group ~PLUGIN_CIVILSYMB_GROUP~
    (
      label LBtext01 ~PLUGIN_CIVILSYMB_TEXT01~ align:#center
      label LBtext02 ~PLUGIN_CIVILSYMB_TEXT02~ align:#center
    )
	)

	on buildMesh do
  (
    local LMSwidth   = width
    local LMSheight  = height
    local LMStype    = type

    local vp = #()
    local fl = #()
    local fm = #()
    local fs = #()
    local fe = #()

    --- Vertex data ---------------------------
    local halfHeight = LMSheight / 2
    local halfWidth  = LMSwidth / 2

    append vp [-halfWidth,-halfHeight,0]
    append vp [ halfWidth,-halfHeight,0]
    append vp [-halfWidth, halfHeight,0]
    append vp [ halfWidth, halfHeight,0]

    --- Face data ---------------------------
    append fl [1,2,4]
    append fm LMStype
    append fs 0
    append fe #(true, true, false)
    append fl [4,3,1]
    append fm LMStype
    append fs 0
    append fe #(true, true, false)

		setMesh mesh vertices:vp faces:fl materialIDs:fm
    for i = 1 to 2 do (setFaceSmoothGroup mesh i fs[i])
    for i = 1 to 2 do (for j = 1 to 3 do (setEdgeVis mesh i j fe[i][j]))

    --- Add UVW Coordinates
    local tv = #([0,0,0],[1,0,0],[0,1,0],[1,1,0])
    local tf = #([1,2,4],[4,3,1])
    setNumTverts mesh tv.count
    buildTVFaces mesh
    for i in 1 to tv.count do setTVert  mesh i tv[i]
    for i in 1 to tf.count do setTVFace mesh i tf[i]

  ) -- end on buildmesh

  tool create prompt:~PLUGIN_CIVILSYMB_PROMPT~
  (
    on mousePoint click do
    (
      case click of
      (
        1: nodeTM.translation = gridPoint
        2: #stop
      )
    )
  ) -- end create tool
) -- end plugin
--
-- � Copyright 2011 Autodesk, Inc. All rights reserved.
--

plugin simpleobject Vsp_Tree name:~PLUGIN_CIVILTREE_NAME~ category:~PLUGIN_CIVILTREE_CATEGORY~ classID:#(0x8591779b, 0x7b1394bf) invisible:(not DYNcreatable)
(
  --- Parameter Block Definition
  parameters main rollout:params
	(
    NFaces type:#integer    default:1  animatable:true --ui:r_Faces
    Height type:#worldunits default:11 animatable:true --ui:r_Height
    Width  type:#worldunits default:6  animatable:true --ui:r_Width
    matID  type:#integer    default:1  animatable:true --ui:r_matid
	)

  local GenUVWs, RemoveUVWs

  --- Rollout Definition
  rollout params ~PLUGIN_CIVILTREE_ROLLOUT~
	(
    local LOCswitch = true

    group ~PLUGIN_CIVILTREE_GROUP~
    (
      label LBtext01 ~PLUGIN_CIVILTREE_TEXT01~ align:#center
      label LBtext02 ~PLUGIN_CIVILTREE_TEXT02~ align:#center
    )

    on params open do
    (
    )

    on params close do
    (
    )
	)

  fn GenUVWs FUNNFaces =
	(
    local LOCtv = #()
    local LOCtf = #()
    for i in 1 to FUNNFaces do
    (
      append LOCtv [0,0,0]
      append LOCtv [1,0,0]
      append LOCtv [0,1,0]
      append LOCtv [1,1,0]
      local LOCj = (i * 4) - 3
      append LOCtf [LOCj, LOCj + 1, LOCj + 3]
      append LOCtf [LOCj + 3, LOCj + 2, LOCj]
    )
    setNumTverts mesh LOCtv.count
    buildTVFaces mesh
    for i in 1 to LOCtv.count do setTVert  mesh i LOCtv[i]
    for i in 1 to LOCtf.count do setTVFace mesh i LOCtf[i]
	)

	fn RemoveUVWs =
	(
    buildTVFaces mesh false
	)

  on buildmesh do
	(
    local LMSnFaces = nFaces
    local LMSheight = height
    local LMSwidth  = width
    local LMSmatID  = matID

    local LOCverts = #()
    local LOCfaces = #()
    local LOCfcVis = #()
    local LOCwidth = LMSwidth / 2
    for i in 1 to LMSNFaces do
    (
      local LOCang    = 180 / LMSNFaces * (i - 1)
      append LOCverts [(-LOCwidth+0*LOCwidth)*cos(LOCang),(-LOCwidth+0*LOCwidth)*sin(LOCang),0]
      append LOCverts [(LOCwidth+0*LOCwidth)*cos(LOCang) ,(LOCwidth+0*LOCwidth)*sin(LOCang) ,0]
      append LOCverts [(-LOCwidth+0*LOCwidth)*cos(LOCang),(-LOCwidth+0*LOCwidth)*sin(LOCang),LMSHeight]
      append LOCverts [(LOCwidth+0*LOCwidth)*cos(LOCang) ,(LOCwidth+0*LOCwidth)*sin(LOCang) ,LMSHeight]
      local LOCj      = (i * 4) - 3
      append LOCfaces [LOCj,LOCj+1,LOCj+3]
      append LOCfaces [LOCj+3,LOCj+2,LOCj]
      append LOCfcVis #(true, true, false)
      append LOCfcVis #(true, true, false)
    )
    setmesh mesh verts:LOCverts faces:LOCfaces
    for i in 1 to LMSNFaces do (setfacematID mesh (i * 2 - 1) LMSmatID;setfacematID mesh (i * 2) LMSmatID)
    for i = 1 to LOCfcVis.count do (for ii = 1 to 3 do (setEdgeVis mesh i ii LOCfcVis[i][ii]))
    GenUVWs LMSNFaces
	)

  tool create prompt:~PLUGIN_CIVILTREE_PROMPT~
  (
    on mousePoint click do
      case click of
      (
        1: (nodeTM.translation = gridPoint)
        2: #stop
      )
  )
)
/*
***************************************************************************************************
***---------------------------------------------------------------------------------------------***
***--  Scripted Global Variables and Functions for Autodesk Civil View                        --***
***--  � Copyright 2011 Autodesk, Inc. All rights reserved.                                   --***
***---------------------------------------------------------------------------------------------***
***************************************************************************************************
*/

--- SET UP GLOBAL Functions as VERY first operation in startup of MAX
global DYNcivilViewProductName      = "Civil &View"
global DYNcivilViewVersion          = 7.0  -- This verion ID is used in all info panels
global DYNmaxMajorVersionString     = "2019"
global DYNcivilViewCategoryCount    = 16   -- The number of object categories in the product. Each category is identified by AppData applied to each Civil View generated node
global DYNimportCatsArray           = #(     7,        8,       14,       15,     16)
global DYNimportSuperClassArray     = #(shapes, geometry, geometry, geometry, shapes)

--- ---------------------------------------------------------
global DYNuiResourcesObjClasses = #( \
            ~GLOB_OBJCLASS_01_VEHICLES~, \            -- 01
            ~GLOB_OBJCLASS_02_FURNITURE~, \           -- 02
            ~GLOB_OBJCLASS_03_TREES_PLANTS~, \        -- 03
            ~GLOB_OBJCLASS_04_SIGNS~, \               -- 04
            ~GLOB_OBJCLASS_05_CAMERAS~, \             -- 05
            ~GLOB_OBJCLASS_06_PRIMITIVES~, \          -- 06
            ~GLOB_OBJCLASS_07_IMPORTED_SHAPES~, \     -- 07
            ~GLOB_OBJCLASS_08_IMPORTED_SURFACES~, \   -- 08
            ~GLOB_OBJCLASS_09_SWEPT_OBJECTS~, \       -- 09
            ~GLOB_OBJCLASS_10_MARKINGS~, \            -- 10
            ~GLOB_OBJCLASS_11_FORESTS~, \             -- 11
            ~GLOB_OBJCLASS_12_RAILS~, \               -- 12
            ~GLOB_OBJCLASS_13_BUILDINGS~, \           -- 13
            ~GLOB_OBJCLASS_14_IMPORTED_POINTS~, \     -- 14
            ~GLOB_OBJCLASS_15_PIPE_NETWORKS~, \       -- 15
            ~GLOB_OBJCLASS_16_ALIGNMENTS~, \          -- 16
            ~GLOB_OBJCLASS_17_SHAPES~, \              -- 17
            ~GLOB_OBJCLASS_18_GEOMETRY~, \            -- 18
            ~GLOB_OBJCLASS_19_CAMERAS~, \             -- 19
            ~GLOB_OBJCLASS_20_HELPERS~ \              -- 20
          )

global DYNuiResourcesCvExplorer = #( \
            ~CV_EXPLORER_ENVIRONMENT_LIGHTING~, \     -- 01
            ~CV_EXPLORER_FOG~, \                      -- 02
            ~CV_EXPLORER_OTHER_LIGHTS~, \             -- 03
            ~CV_EXPLORER_ENVIRONMENT_MAP~, \          -- 04
            ~CV_EXPLORER_EXPOSURE~, \                 -- 05
            ~CV_EXPLORER_MATERIALS~, \                -- 06
            ~CV_EXPLORER_OBJECTS~, \                  -- 07
            ~CV_EXPLORER_EXPLORER~, \                 -- 08
            ~CV_EXPLORER_OTHER_OBJECTS~, \            -- 09
            ~CV_EXPLORER_SCENE_SETTINGS~, \           -- 10
            ~CV_EXPLORER_SUN_DAYLIGHT~, \             -- 11
            ~CV_EXPLORER_INDIRECT_ILLUM~, \           -- 12
            ~CV_EXPLORER_VEHICLE_LIBRARY~, \          -- 13
            ~CV_EXPLORER_OBJECT_LIBRARY~, \           -- 14
            ~CV_EXPLORER_STYLES~, \                   -- 15
            ~CV_EXPLORER_BOS~, \                      -- 16
            ~CV_EXPLORER_OPS~, \                      -- 17
            ~CV_EXPLORER_ROS~, \                      -- 18
            ~CV_EXPLORER_RMS~, \                      -- 19
            ~CV_EXPLORER_SOS~, \                      -- 20
            ~CV_EXPLORER_SELECTED_COUNT~, \           -- 21
            ~CV_EXPLORER_TAB_EXPLORER~, \             -- 22
            ~CV_EXPLORER_TAB_RESOURCES~, \            -- 23
            ~CV_EXPLORER_TAB_TOOLS~, \                -- 24
            ~CV_EXPLORER_TOOLS_CIVILVIEW~, \          -- 25
            ~CV_EXPLORER_TOOLS_RENDERING~, \          -- 26
            ~CV_EXPLORER_TOOLS_BONUS~, \              -- 27
            ~CV_EXPLORER_TOOLS_OTHER~, \              -- 28
            ~CV_EXPLORER_COUNTRY_KIT~, \              -- 29
            ~CV_EXPLORER_PROJECT_KIT~, \              -- 30
            ~CV_EXPLORER_PRIVATE_KIT~, \              -- 31
            ~CV_EXPLORER_IMPORTED_OBJECTS~, \         -- 32
            ~CV_EXPLORER_PLACED_OBJECTS~, \           -- 33
            ~CV_EXPLORER_OTHER_OBJECTS~ \             -- 34
          )

global DYNuiResourcesCivilViewGlobal = #( \
            ~GLOB_CIVILVIEW_BUTTON_OK~, \             -- 01
            ~GLOB_CIVILVIEW_BUTTON_CANCEL~, \         -- 02
            ~GLOB_CIVILVIEW_BUTTON_TITLEBAR_3~, \     -- 03
            ~GLOB_CIVILVIEW_BUTTON_TITLEBAR_55~, \    -- 04
            ~GLOB_CIVILVIEW_STATUS_62~, \             -- 05
            ~GLOB_CIVILVIEW_QUERY_7~, \               -- 06
            ~GLOB_CIVILVIEW_QUERY_83~, \              -- 07
            ~GLOB_CIVILVIEW_LABEL_505~, \             -- 08
            ~GLOB_CIVILVIEW_FOLDERNAME_1~ \           -- 09
)

--- Define *** NON-LOCALIZABLE *** strings as GLOBAL variables
global DYNstringRMSfolderName       = "Road Marking Styles"
global DYNstringFISfolderName       = "Feature Interpretation Styles"
global DYNstringROSfolderName       = "Rail Object Styles"
global DYNstringOPSfolderName       = "Object Placement Styles"
global DYNstringSOSfolderName       = "Swept Object Styles"
global DYNstringBOSfolderName       = "Building Object Styles"

global DYNfolderSeperator           = "\\"

global DYNcountryKitFolderSeedName  = "Country Kit"
global DYNfolderNameMatLibs         = "MatLibs"
global DYNfolderNameBuildingMaps    = "BuildingMaps"
global DYNfolderNameFurnitureMaps   = "FurnitureMaps"
global DYNfolderNameMarkingMaps     = "MarkingMaps"
global DYNfolderNameRailMaps        = "RailMaps"
global DYNfolderNameSignMaps        = "SignMaps"
global DYNfolderNameSurfaceMaps     = "SurfaceMaps"
global DYNfolderNameTreeMaps        = "TreeMaps"
global DYNfolderNameVehicleMaps     = "VehicleMaps"
global DYNfolderNameObjLibs         = "ObjLibs"
global DYNfolderNameCameras         = "Cameras"
global DYNfolderNameFurniture       = "Furniture"
global DYNfolderNamePreviews        = "Previews"
global DYNfolderNamePrimitives      = "Primitives"
global DYNfolderNameSigns           = "Signs"
global DYNfolderNameTrees           = "Trees"
global DYNfolderNameVehicles        = "Vehicles"

global DYNmatNameBuildings          = "CivilViewBuildings"
global DYNmatNameMarkings           = "CivilViewMarkings"
global DYNmatNameObjects            = "CivilViewObjects"
global DYNmatNameRails              = "CivilViewRails"
global DYNmatNameSurfaces           = "CivilViewSurfaces"
global DYNmatNameTrees              = "CivilViewTrees"
global DYNmatNameVehicles           = "CivilViewVehicles"

global DYNoldMatNameEnvironment     = "DynamiteBackground"
global DYNoldMatNameBuildings       = "DynamiteBuildings"
global DYNoldMatNameMarkings        = "DynamiteMarkings"
global DYNoldMatNameObjects         = "DynamiteObjects"
global DYNoldMatNameRails           = "DynamiteRails"
global DYNoldMatNameSurfaces        = "DynamiteSurfaces"
global DYNoldMatNameTrees           = "DynamiteTrees"
global DYNoldMatNameVehicles        = "DynamiteVehicles"

global DYNfogName                   = "Dynamite Fog"

global DYNimageTypes                = "JPEG Image File (*.jpg)|*.jpg|GIF Image File (*.gif)|*.gif|PNG Image File (*.png)|*.png|Bitmap Image File (*.bmp)|*.bmp|Targa Image File (*.tga)|*.tga|TIFF Image File (*.tif)|*.tif|"

--- Define Other Global Variables
global DYNforceManualStart          = false

/* DVSP Related DotNET Global Variables */
global DYNdotNetCountryINIbase             -- Used to store reference to DVSP extensions iniBase dotNetObject for Country Resource Kit
global DYNdotNetProjectINIbase             -- Used to store reference to DVSP extensions iniBase dotNetObject for Country Resource Kit
global DYNdotNetPrivateINIbase             -- Used to store reference to DVSP extensions iniBase dotNetObject for Country Resource Kit

global DYNdnColorClass
global DYNdnSmImageList


/* Set Global Variables for System Paths */
global DYNtempPath                  = ""         -- Path for all temporary files generated by Civil View
global DYNskyMapPath                = ""         -- Path for global sky maps folder
global DYNcountryPath               = ""         -- Path for currently loaded Country Kit
global DYNglobalMapsPath               = ""         -- Path for global maps used in all country kits
global DYNscriptsPath               = ""         -- Path for startup script
global DYNbinPath                   = ""         -- Path for APC rollouts and Souce Files
global DYNiconsPath               = ""         -- Path for general DVSP icons

/* Globals set by main INI file settings (set global values now, but won't actually be used because set by Main INI file keys in vsp.ms) */
global DYNINIt                      = "t"
global DYNINIvehNr                  = "VehNr"
global DYNINIvehTypeName            = "VehTypeName"
global DYNINIworldX                 = "WorldX"
global DYNINIworldY                 = "WorldY"
global DYNINIworldZ                 = "WorldZ"
global DYNINIrWorldX                = "RWorldX"
global DYNINIrWorldY                = "RWorldY"
global DYNINIrWorldZ                = "RWorldZ"
global DYNINItype                   = "Type"
global DYNINIcountry                = ""         -- current country kit (i.e. NL/UK)
global DYNINIexplorerWidth          = 208        -- Drive on left or Drive on Right Switch
global DYNINIcomPanel               = "1"        -- 3dsmax Command Panel Display Switch
global DYNINImarkerSize             = 1          -- Marker Object Size
global DYNINIframeRate              = 25         -- Default Frame Rate
global DYNINIspeedValue             = [1,1]      -- Speed Units
global DYNINIungpMatChan            = 27         -- Material Channel applied to Ungrouped or unrecognised triangle groups on GENIO import
global DYNINImatIDlimit             = 500        -- Limit for MatID spinners in all DVSP panels
global DYNINIresetMaxMenu           = "1"        -- 3dsmax pulldown menu reload switch on startup.
global DYNINIdisableGrid            = "0"        -- Grid Disable Switch on Civil View startup.
global DYNINIoverhangCorrect        = "1"        --
global DYNINIhideDiagonals          = "1"        --
global DYNINIshadowSaver            = "0"        -- Use Vehicle Shadow Saver By Default
global DYNINIchainageLoop           = "1"        -- Whether chainage looping is activated by default when DVSP starts up
global DYNINIautoStart              = "0"        -- Whether DVSP should be started automatically when 3ds Max Design starts (user specific setting)
global DYNINIprivateKit             = "0"        -- Whether Private Resource Kit function is currently active
global DYNINIprivateKitPath         = ""         -- The path of the current Private Resource Kit
global DYNINIprojectKit             = "0"        -- Whether Private Resource Kit function is currently active
global DYNINIprojectKitPath         = ""         -- The path of the current Project Resource Kit
global DYNINIretainOPSmat           = false      -- Whether materials are always overridden in MAX files during placement from OPS Editor
global DYNINIshowUnitsWarning       = true       -- Whether to show warning about system units not being in metres (this is ignored if units are already metres, but prevents persistent warnings if user wants to stay in inches)
global DYNINIshowResourceKitWarning = true       -- Whether to show warning about multiple country kits existing during first start up
global DYNINIallowMultMarks         = false      -- Whether multiple road marking objects can be aplied to a single shape object
global DYNINIallowMultRails         = false      -- Whether multiple road marking objects can be aplied to a single shape object
global DYNINIrotateWheels           = "1"        -- Whether rotation should automatically be applied to the wheels of animated vehicles
global DYNINIenableFog              = "0"        -- Whether fog effect is enabled by default when DVSP starts up
global DYNINIdockExplorer           = "0"        -- Civil View Explorer is docked by default when this value is set to "1"
global DYNINIshowIcons              = true       -- Civil View Explorer shows icons in panel if this is set to true
global DYNINItreeVariation          = 15         -- Percentage Variation in Height of Tree Objects
global DYNINIfaceSmoothing          = 9.0        --

/* Set Up Color Variables, (eventually set from Main INI file keys) */
global DYNINIhighlightColor         = (color 0 0 0) -- Panel Item Highlight Color (this value is never actually used, just initialises it as a color value)
global DYNINIgreyedOutColor         = (color 0 0 0) -- Panel text GreyedOut Color (this value is never actually used, just initialises it as a color value)
global DYNINIstartMarkerColor       = green         -- Start Marker Obj Color (this value is never actually used, just initialises it as a color value)
global DYNINIendMarkerColor         = red           -- End   Marker Obj Color (this value is never actually used, just initialises it as a color value)
global DYNINImarkingColor           = (color 245 245 245) -- Default Road Markings Color REM: Eventually needs to be settable per line.

/* Make additional optimisation settings for marking lines */
global DYNINImarkingSpacing         = 2.0
global DYNINImarkingThreshold       = 0.5
global DYNINImarkingMaxDistance     = 25.0
/* Make additional settings for data import memory size */
global DYNINIminHeapSize            = 50
global DYNINImemPrecent             = 20
global DYNINIreadMethod             = 0
global DYNINIstepThreshold          = 2

global DYNmainFloater                       -- Main Explorer Floater
global DynDVSPmenuMain                      -- Main Pulldown Menu
global DynDVSPmenuImport                    -- Import Pulldown Menu
global DynDSIMmenuMain                      -- Main DSIM Menu
global DynDSIMmenuTools                     -- DSIM Tools Menu

/* Make global ROLLOUT Definitions */
global DYNsplashPanel                       -- Splash Panel on startup
global DYNamite                             -- Civil View Explorer Panel
global DYNdxfImport                         -- DXF Import Panel
global DYNproperties                        -- Object Properties Panel
global DYNsweptObjects                      -- SOS Style Editor
global DYNgRailObjects                      -- Rail Object Style Editor
global DYNbuildingObjects                   -- Building Object Style Editor
global DYNobjectPlacer                      -- OPS Style Editor
global DYNresourceMan                       -- Resource Kit Manager Panel
global DYNimportMan                         -- Imported Object Manager Panel
global DYNplacedMan                         -- Placed Object Manager Panel
global DYNpreferences                       -- Preferences Panel
global DYNsightTool                         -- Sight Distance Panel
global DYNsplineMapper                      --
global DYNdrapeSpline                       --
global DYNpointBasedPlace                   --
global DYNchainageText                      --

global DYNmrPhysicalSky                     -- Sky Editor CSP Panel For MrPhysicalSky
global DYNatmosphere                        -- Fog Editor CSP Panel
global DYNexposure                          -- Exposure Control CSP Panel
global DYNworldStatistics                   -- World Statisitcs CSP Panel
global DYNpathObjectList                    -- Path Object List CSP Panel
global DYNresourceList                      -- Resource List CSP Panel
global DYNlightList                         -- Light Lister CSP Panel
global DYNsunLight                          -- Light Manager CSP Panel
global DYNmrSunLight                        -- Light Manager CSP Panel
global DYNstdLight                          -- Light Manager CSP Panel
global DYNsignParams                        -- Sign Parameters CSP Panel
global DYNsignalParams                      -- Traffic Signal Parameters CSP Panel
global DYNvehicleParams                     -- Vehicle Parameters CSP Panel
global DYNmarkingParams                     -- Road Marking Parameters CSP Panel
global DYNgantryParams                      -- Gantry Parameters CSP Panel
global DYNlampParams                        -- Lamp Column Parameters CSP Panel
global DYNprimitiveParams                   -- Primitives Parameters CSP Panel
global DYNtreeParams                        -- Tree Parameters CSP Panel
global DYNcamParams                         -- Camera Parameters CSP Panel
global DYNgRailParams                       -- Gaurd Rail Parameters CSP Panel
global DYNbuildingParams                    -- Building Parameters CSP Panel
global DYNalignmentParams                   -- Shape Parameters CSP Panel
global DYNshapeParams                       -- Shape Parameters CSP Panel
global DYNsurfaceParams                     -- Surface Parameters CSP Panel
global DYNforestParams                      -- Forest Editor CSP Panel
global DYNuserInterface                     -- Scene Settings CSP Panel
global DYNpositionControl                   -- Object Position Controller CSP Panel
global DYNattachParams                      -- Object Attachment Position Controller CSP Panel
global DYNsosParams                         -- Object Swept Object Parameters CSP Panel
global DYNmatEditor                         -- Material Editor Panel
global DYNroadMarkings                      -- Road Markings Style Editor Panel
global DYNfeatureInterp                     -- Feature Interpretation Style Editor Panel
global DYNcveImport                         -- MX Model File Import Panel
global DYNpSystemParams                     -- Point System Parameters
global DYNpNetworkParams                    -- Pipe Network Parameters
global DYNc3dImport                         -- Civil 3D File Import Panel

global DYNmessageRollout                    -- Panel used in DYNFUNdisplayMessage function
global DYNbuildShape                        -- SOS shape building panel

global DYNdsimImport                        -- Rollout for FZP Import
global DYNdsimSubstitute                    -- Rollout for Vehicle Substitution
global DYNdsimSurface                       -- Rollout for Surface Tracking
global DYNqparImport                        -- Rollout for SIM3D Import
global DYNfileSelector

global DYNremovePOLrefreshEnable    = true  -- This is used as a switch for enabling or disabling the removal of the PathObjectList rollout when DYNFUNremoveCSProllouts() is called -- Added Feb
global DYNobjHandles                = #(#(),#(),#(),#(),#(),#(),#(),#(),#(),#(),#(),#(),#(),#(),#(),#(),#(),#(),#(),#(),#())              -- Array of sorted objects used for updating Explorer View using object HANDLES!


/*
*************************************************************
-------------------------------------------------------------
--             Load dummy function libraries               --
-------------------------------------------------------------
*************************************************************
*/

fn DYNFUNmakeCivilViewSurfaces FUNpath = (print "Dummy function called - DYNFUNmakeCivilViewSurfaces!")
fn DYNFUNmakeCivilViewVehicles FUNpath = (print "Dummy function called - DYNFUNmakeCivilViewVehicles!")


/*
*************************************************************
-------------------------------------------------------------
--           Start Civil View Function Library             --
-------------------------------------------------------------
*************************************************************
*/


--- Function to get global shift values (double get to get over previous problem with disappearing values
fn DYNFUNsetupRootNode =
(
  --- Get Persistent Values (legacy from Version 1.x) ------------------------------------------------------------------------
  local LOCshiftX = DYNshiftX
  local LOCshiftY = DYNshiftY

  --- See if a value is stored in rootNode CA def exists, and if so override persistent value ----------------
  local LOCcurrentAttribArray = custAttributes.getDefs RootNode                       -- will return undefined if no custom attributes exist on root node
  local LOCcustAttribDefFound = false

  --- Cycle through Existing Custom Attribute Definitions to see if standard DVSP custAttribs are found
  if classOf LOCcurrentAttribArray == Array then
  (
    for i in LOCcurrentAttribArray do (if i.name == #DYNrootNodeStore then LOCcustAttribDefFound = true)
  )

  --- If CA Definition Was Not Found, Mek New Definition Now ------------
  if not LOCcustAttribDefFound then
  (
    /* See if old DVSP V2 cust Attrib definition can be found. If so, grab old shift values from it */
    if classOf LOCcurrentAttribArray == Array then
    (
      for i in LOCcurrentAttribArray do -- Cycle through Existing Custom Attribute Definitions until we find the correct one
      (
        if i.name == #DYNglobalShiftCustomAttributes then -- search for old pre-v3 attrib definition
        (
          LOCshiftX = rootNode.DYNglobalShiftCustomAttributes.shiftX
          LOCshiftY = rootNode.DYNglobalShiftCustomAttributes.shiftY

          --- Remove Old Custom Attribute Definition - it is no longer required in Version 3.0
          /* -- THIS CODE USEFUL FOR INFORMATIONAL PURPOSES
            local sds = custAttributes.getSceneDefs()
            for s in sds do try (custAttributes.deleteDef s) catch()
            custAttributes.getSceneDefs() -- return value

            This next code commented out because deletion of this custAtt from rootnode foudn not always to be successful,
            resulting in an error when saving file because custAtt def can no longer be found
          custAttributes.delete rootNode DYNglobalShiftCustomAttributes -- Remove CustAttrib from scene RootNode
          custAttributes.deleteDef DYNglobalShiftCustomAttributes -- Delete Definition From Scene
          */
        )
      )
    )

    /* If it doesn't already exist, add V3 Custom Attribute Definition to RootNode and Set Values from curent persistent variables */
    custAttributes.add rootNode DYNrootNodeStore
    rootNode.DYNrootNodeStore.sceneVersion   = DYNcivilViewVersion                                      --  type:#float   default:3.0     -- This version ID is actually stored in the scene to allow us to compare current and stored versions later.
    rootNode.DYNrootNodeStore.shiftX         = 0                                                        --  type:#integer default:0       -- Used in DYNglobalShift X values
    rootNode.DYNrootNodeStore.shiftY         = 0                                                        --  type:#integer default:0       -- Used in DYNglobalShift Y values
    rootNode.DYNrootNodeStore.vehicleRes     = 100                                                      --  type:#integer default:100
    rootNode.DYNrootNodeStore.bakeSwitch     = false                                                    --  type:#boolean default:false   -- Controls dynamic object position linking (pinning). Default false - optimised linking.
    rootNode.DYNrootNodeStore.signIllum      = 0                                                        --  type:#integer default:0  (deprecated in Civil View 2012)
    rootNode.DYNrootNodeStore.treeIllum      = 0                                                        --  type:#integer default:0  (deprecated in Civil View 2012)
    rootNode.DYNrootNodeStore.vehRayTrace    = true                                                     --  type:#boolean default:true
    rootNode.DYNrootNodeStore.vehRayAmount   = 14                                                       --  type:#integer default:20
    rootNode.DYNrootNodeStore.markVshift     = 0.025                                                    --  type:#float   default:0.025   -- Default vertical shift to be applied when creating road marking objects
    rootNode.DYNrootNodeStore.markFreeze     = false                                                    --  type:#boolean default:false
    rootNode.DYNrootNodeStore.markQuality    = 0.25                                                     --  type:#float   default:0.25
    rootNode.DYNrootNodeStore.markBlur       = 1.0                                                      --  type:#float   default:1.0
    rootNode.DYNrootNodeStore.sosPath        = ""                                                       --  type:#string  default:""  NO LONGER USED
    rootNode.DYNrootNodeStore.rosPath        = ""                                                       --  type:#string  default:""  NO LONGER USED
    rootNode.DYNrootNodeStore.bosPath        = ""                                                       --  type:#string  default:""  NO LONGER USED
    rootNode.DYNrootNodeStore.opsPath        = ""                                                       --  type:#string  default:""  NO LONGER USED
    rootNode.DYNrootNodeStore.rmsPath        = ""                                                       --  type:#string  default:""  NO LONGER USED
    rootNode.DYNrootNodeStore.fisPath        = ""                                                       --  type:#string  default:""  NO LONGER USED
    rootNode.DYNrootNodeStore.genPath        = (getdir #import) + "\\*.txt"                              --  type:#string  default:""
    rootNode.DYNrootNodeStore.mfwPath        = (getdir #import) + "\\*.fil"                              --  type:#string  default:""
    rootNode.DYNrootNodeStore.xmlPath        = (getdir #import) + "\\*.xml"                              --  type:#string  default:""
    rootNode.DYNrootNodeStore.twdPath        = (getdir #import) + "\\*.12da"                             --  type:#string  default:""

    rootNode.DYNrootNodeStore.string01       = (getdir #import) + "\\*.vsp3d"                            --  type:#string  default:""
    rootNode.DYNrootNodeStore.string02       = ""                                                       --  type:#string  default:""  Project Resource Kit Path

    rootNode.DYNrootNodeStore.int01          = 0                                                        --  type:#integer default:?
    rootNode.DYNrootNodeStore.int02          = 2500                                                     --  type:#integer default:2500 Max number of objects in Placed Object Manager
    rootNode.DYNrootNodeStore.int03          = 2500                                                     --  type:#integer default:2500 Max number of objects in Imported Object Manager
    rootNode.DYNrootNodeStore.bool01         = false                                                    --  type:#boolean default:false
    rootNode.DYNrootNodeStore.bool02         = false                                                    --  type:#boolean default:false

    rootNode.DYNrootNodeStore.int04          = 0                                                        --  type:#integer default:0
    rootNode.DYNrootNodeStore.int05          = 0                                                        --  type:#integer default:0
    rootNode.DYNrootNodeStore.float01        = 0.0                                                      --  type:#float   default:0.0
    rootNode.DYNrootNodeStore.string03       = (getdir #import) + "\\*.fzp"                              --  type:#string  default:""
    rootNode.DYNrootNodeStore.string04       = (getdir #import) + "\\*.sim"                              --  type:#string  default:""

    /*
    rootNode.DYNrootNodeStore.countryKitPath =         --  type:#string  default:"" -- not yet in use
    rootNode.DYNrootNodeStore.bool03         =         --  type:#boolean default:false
    rootNode.DYNrootNodeStore.bool04         =         --  type:#boolean default:false
    rootNode.DYNrootNodeStore.bool05         =         --  type:#boolean default:false
    rootNode.DYNrootNodeStore.float02        =         --  type:#float   default:0.0
    rootNode.DYNrootNodeStore.float03        =         --  type:#float   default:0.0
    rootNode.DYNrootNodeStore.float04        =         --  type:#float   default:0.0
    rootNode.DYNrootNodeStore.float05        =         --  type:#float   default:0.0
    rootNode.DYNrootNodeStore.string05       =         --  type:#string  default:""
    rootNode.DYNrootNodeStore.string06       =         --  type:#string  default:""
    rootNode.DYNrootNodeStore.string07       =         --  type:#string  default:""
    rootNode.DYNrootNodeStore.string08       =         --  type:#string  default:""
    rootNode.DYNrootNodeStore.string09       =         --  type:#string  default:""
    rootNode.DYNrootNodeStore.string10       =         --  type:#string  default:""
    */
  )
)


--- Checks if a folder exists, but will not working if a trailing "\" is included in folder name. No way around this!
fn DYNFUNdoesFolderExist FUNfolder =
(
  local LOCresult = false
  if FUNfolder != "" then
  (
    local LOCfolder = FUNfolder
    if (subString LOCfolder LOCfolder.count -1) == "\\" then LOCfolder = subString LOCfolder 1 (LOCfolder.count - 1)
    LOCresult = if (getDirectories LOCfolder).count > 0 and LOCfolder != "." then true else false
  )
  LOCresult -- retrun value
)

--- Makes a Standard Resource Kit Folder Structure
fn DYNFUNmakeResourceKitStructure FUNparentFolder FUNname =
(
  local LOCsuccess      = true
  local LOCparentFolder = if (subString FUNparentFolder FUNparentFolder.count -1) == "\\" then subString FUNparentFolder 1 (FUNparentFolder.count - 1) else FUNparentFolder
  local LOCrootFolder   = LOCparentFolder + "\\" + FUNname

  if not (DYNFUNdoesFolderExist LOCrootFolder) then (LOCsuccess = makeDir LOCrootFolder all:true)

  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNstringBOSfolderName) )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNstringBOSfolderName) all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNstringFISfolderName) )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNstringFISfolderName) all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNstringOPSfolderName) )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNstringOPSfolderName) all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNstringROSfolderName) )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNstringROSfolderName) all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNstringRMSfolderName) )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNstringRMSfolderName) all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNstringSOSfolderName) )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNstringSOSfolderName) all:false)

  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameMatLibs)                                    )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameMatLibs) all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameMatLibs + "\\" + DYNfolderNameBuildingMaps) )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameMatLibs + "\\" + DYNfolderNameBuildingMaps)  all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameMatLibs + "\\" + DYNfolderNameFurnitureMaps))) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameMatLibs + "\\" + DYNfolderNameFurnitureMaps) all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameMatLibs + "\\" + DYNfolderNameMarkingMaps)  )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameMatLibs + "\\" + DYNfolderNameMarkingMaps)   all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameMatLibs + "\\" + DYNfolderNameRailMaps)     )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameMatLibs + "\\" + DYNfolderNameRailMaps)      all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameMatLibs + "\\" + DYNfolderNameSignMaps)     )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameMatLibs + "\\" + DYNfolderNameSignMaps)      all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameMatLibs + "\\" + DYNfolderNameSurfaceMaps)  )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameMatLibs + "\\" + DYNfolderNameSurfaceMaps)   all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameMatLibs + "\\" + DYNfolderNameTreeMaps)     )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameMatLibs + "\\" + DYNfolderNameTreeMaps)      all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameMatLibs + "\\" + DYNfolderNameVehicleMaps)  )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameMatLibs + "\\" + DYNfolderNameVehicleMaps)   all:false)

  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameObjLibs)                                    )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameObjLibs) all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameObjLibs + "\\" + DYNfolderNameCameras)      )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameObjLibs + "\\" + DYNfolderNameCameras)       all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameObjLibs + "\\" + DYNfolderNameFurniture)    )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameObjLibs + "\\" + DYNfolderNameFurniture)     all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameObjLibs + "\\" + DYNfolderNamePreviews)     )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameObjLibs + "\\" + DYNfolderNamePreviews)      all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameObjLibs + "\\" + DYNfolderNamePrimitives)   )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameObjLibs + "\\" + DYNfolderNamePrimitives)    all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameObjLibs + "\\" + DYNfolderNameSigns)        )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameObjLibs + "\\" + DYNfolderNameSigns)         all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameObjLibs + "\\" + DYNfolderNameTrees)        )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameObjLibs + "\\" + DYNfolderNameTrees)         all:false)
  if not (DYNFUNdoesFolderExist ((LOCrootFolder + "\\" + DYNfolderNameObjLibs + "\\" + DYNfolderNameVehicles)     )) then (if LOCsuccess then LOCsuccess = makeDir (LOCrootFolder + "\\" + DYNfolderNameObjLibs + "\\" + DYNfolderNameVehicles)      all:false)
  LOCsuccess -- rerurn value
)

---Function for listing all the MAX files in a particular Directory
fn DYNFUNgetfiles FUNpath FUNsufSwitch FUNfileType =
(
   local LOCfiles = getfiles (FUNpath + FUNfileType)
   for i = 1 to LOCfiles.count do LOCfiles[i] = filenamefrompath LOCfiles[i]
   if FUNsufSwitch == 1 then
   (
     for i = 1 to LOCfiles.count do LOCfiles[i] = getfilenamefile LOCfiles[i]
   )
   LOCfiles -- return value
)

--- Function to make list of BMPs in a material library directory
fn DYNFUNlistLibraryMaps FUNpath =
(
  local LOCimageArray = #()

  --- Make the Array of Library Image Files
  LOCimageArray += DYNFUNgetFiles FUNpath 0 "*.bmp"
  LOCimageArray += DYNFUNgetFiles FUNpath 0 "*.gif"
  LOCimageArray += DYNFUNgetFiles FUNpath 0 "*.jpg"
  LOCimageArray += DYNFUNgetFiles FUNpath 0 "*.png"
  LOCimageArray += DYNFUNgetFiles FUNpath 0 "*.tga"
  LOCimageArray += DYNFUNgetFiles FUNpath 0 "*.tif"

  --- Finish Off Routine
  sort LOCimageArray

  LOCimageArray -- return value
)

fn DYNFUNiniBaseClear FUNmode =
(
  LOCresult
  if FUNmode != 2 and FUNmode != 3 then
  (
    LOCresult = DYNdotNetCountryINIbase.clear()
  )
  else
  (
    if FUNmode == 2 then LOCresult = DYNdotNetProjectINIbase.clear()
    if FUNmode == 3 then LOCresult = DYNdotNetPrivateINIbase.clear()
  )
  LOCresult
)

fn DYNFUNiniReadFromFolder FUNPath FUNrecursiveFlag FUNmode =
(
  local LOCresult = -2
  if classOf FUNpath == string then
  (
    if FUNmode != 2 and FUNmode != 3 then
    (
      LOCresult = DYNdotNetCountryINIbase.ReadFromFolder FUNPath "*.ini" "/*%!@" "|*&[]" ",:;" ".ini" FUNrecursiveFlag
    )
    else
    (
      if FUNmode == 2 then LOCresult = DYNdotNetProjectINIbase.ReadFromFolder FUNPath "*.ini" "/*%!@" "|*&[]" ",:;" ".ini" FUNrecursiveFlag
      if FUNmode == 3 then LOCresult = DYNdotNetPrivateINIbase.ReadFromFolder FUNPath "*.ini" "/*%!@" "|*&[]" ",:;" ".ini" FUNrecursiveFlag
    )
  )
  LOCresult -- return file count [integer]
)

---Function to convert strings between upper and lower case
fn DYNFUNupperCase FUNinString FUNcaseSwitch =
(
  /*
    FUNcaseSwitch == 0 for "STRING"
    FUNcaseSwitch == 1 for "String"
    FUNcaseSwitch == 2 for "StrinG"
  */

  local LOCoutString
  local LOCupper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ "
  local LOClower = "abcdefghijklmnopqrstuvwxyz_"
  LOCoutString = copy FUNinString
  if FUNcaseSwitch == 0 then
  (
    for i = 1 to LOCoutString.count do
    (
      local LOCchar = findString LOClower LOCoutString[i]
      if (LOCchar != undefined) do LOCoutString[i] = LOCupper[LOCchar]
    )
  )
  else
  (
    local LOCchar = findString LOClower LOCoutString[1]
    if (LOCchar != undefined) do LOCoutString[1] = LOCupper[LOCchar]
    if FUNcaseSwitch == 2 then -- Capitalise last character in string
    (
      local LOCendChar = findString LOClower LOCoutString[LOCoutString.count]
      if (LOCendChar != undefined) do LOCoutString[LOCoutString.count] = LOCupper[LOCendChar]
    )
  )
  LOCoutString -- return value as result of function
)


---Function to check which Country Kits exist on system
fn DYNFUNgetcountrykits FUNdefPath =
(
  if (subString FUNdefPath FUNdefPath.count -1) != "\\" then FUNdefPath += "\\"
  local LOCcountryKits = getdirectories (FUNdefpath + DYNcountryKitFolderSeedName + " *")
  for i = 1 to LOCcountrykits.count do
  (
    LOCcountrykits[i] = DYNFUNupperCase (substring ((filterstring LOCcountrykits[i] "\\")[(filterstring LOCcountrykits[i] "\\").count]) 13 -1) 0
  )
  LOCcountryKits -- return value
)

--- Function to apply transformation script to an array of objects depending on object linking optimisation setting
fn DYNFUNmaxBakingControl FUNobjects FUNswitch =
(
  for i = 1 to FUNobjects.count do
  (
    if (classof FUNobjects[i].transform.controller) == DYNXFCC or (classof FUNobjects[i].transform.controller) == DYNXFCCM3 then
    (
      if superClassOf FUNobjects[i] == Camera then
      (
        FUNobjects[i].transform.controller.Aux4_bool = (superClassOf FUNobjects[i] == Camera) -- should be true if object is camera, and otherwise false
      )

      if FUNswitch == false then
      (
        local LOCisNotAnimated = true -- Test to see if object has been animated
        if FUNobjects[i].transform.controller.percent.keys       != undefined then LOCisNotAnimated = false
        if FUNobjects[i].transform.controller.hOffset.keys       != undefined then LOCisNotAnimated = false
        if FUNobjects[i].transform.controller.vOffset.keys       != undefined then LOCisNotAnimated = false
        if FUNobjects[i].transform.controller.rotation.keys      != undefined then LOCisNotAnimated = false
        if FUNobjects[i].transform.controller.distance.keys      != undefined then LOCisNotAnimated = false
        if FUNobjects[i].transform.controller.followPath.keys    != undefined then LOCisNotAnimated = false
        if FUNobjects[i].transform.controller.followSurface.keys != undefined then LOCisNotAnimated = false
        if FUNobjects[i].transform.controller.spline.keys        != undefined then LOCisNotAnimated = false

        if LOCisNotAnimated then
        (
          FUNobjects[i].transform.controller.Aux5_bool = false   -- Turn off static transform override
          --- Store Last Known Position Of Object
          FUNobjects[i].transform.controller.row1 = FUNobjects[i].transform.row1
          FUNobjects[i].transform.controller.row2 = FUNobjects[i].transform.row2
          FUNobjects[i].transform.controller.row3 = FUNobjects[i].transform.row3
          FUNobjects[i].transform.controller.row4 = FUNobjects[i].transform.row4
          FUNobjects[i].transform.controller.Aux5_bool = true  -- Turn On static transform override
        )
        else
        (
          FUNobjects[i].transform.controller.Aux5_bool = false   -- Turn off static transform override
        )
      )
      else
      (
        FUNobjects[i].transform.controller.Aux5_bool = false   -- Turn off static transform override
      )
    )
  )
)

fn DYNFUNgetCivilViewCategorizedNodeArrays FUNreturnType FUNgroupedResultSwitch =
(
  /* FUNreturnType may be "handles", "names", or "nodes" */

  --- Get Nested Array of Civil View Scene Nodes, from CivilView.ImportExport.dlx based method
  local LOCmasterArray = DynLXGetDVSPNodeArraysNoPF FUNreturnType

  --- If Grouped Results have been requested, always remove all pipes and structures from Nested Array 15 (Pipe Networks)
  --- If Grouped Results have NOT been requested, only remove pipes and structures from Nested Array 15 (Pipe Networks) for CLOSED groups
  if FUNgroupedResultSwitch then
  (
    LOCmasterArray[15] = #()
  )
  else
  (
    for i = LOCmasterArray[15].count to 1 by -1 do
    (
      local LOCnode
      if stricmp FUNreturnType "handles" == 0 then LOCnode = maxOps.getNodeByHandle LOCmasterArray[15][i]
      if stricmp FUNreturnType "names"   == 0 then LOCnode = GetNodeByName LOCmasterArray[15][i] exact:true ignoreCase:false
      if stricmp FUNreturnType "nodes"   == 0 then LOCnode = LOCmasterArray[15][i]

      if isGroupMember LOCnode and not (isOpenGroupMember LOCnode) then deleteItem LOCmasterArray[15] i
    )
  )

  --- Always put Pipe Network groupHeads into Nested Array 15 (Pipe Networks) and always remove them from Nested Array 20 (Helpers)
  --- Always remove Pipe Network groupHeads from Nested Array 20 (Helpers), and add them to Nested Array 15 (Pipe Networks) *if* pipe network group is not open
  for i = LOCmasterArray[20].count to 1 by -1 do
  (
    local LOCnode
    if stricmp FUNreturnType "handles" == 0 then LOCnode = maxOps.getNodeByHandle LOCmasterArray[20][i]
    if stricmp FUNreturnType "names"   == 0 then LOCnode = GetNodeByName LOCmasterArray[20][i] exact:true ignoreCase:false
    if stricmp FUNreturnType "nodes"   == 0 then LOCnode = LOCmasterArray[20][i]

    if getAppData LOCnode 422 == "15" then
    (
      if FUNgroupedResultSwitch or (not (isOpenGroupHead LOCnode)) then append LOCmasterArray[15] LOCmasterArray[20][i]
      deleteItem LOCmasterArray[20] i
    )
  )

  --- If any non-Civil View geometry items are members of groups, remove them from Array 18 (Non-CivilView Geometry)
  for i = LOCmasterArray[18].count to 1 by -1 do
  (
    local LOCgroupedNode
    if stricmp FUNreturnType "handles" == 0 then LOCgroupedNode = maxOps.getNodeByHandle LOCmasterArray[18][i]
    if stricmp FUNreturnType "names"   == 0 then LOCgroupedNode = GetNodeByName LOCmasterArray[18][i] exact:true ignoreCase:false
    if stricmp FUNreturnType "nodes"   == 0 then LOCgroupedNode = LOCmasterArray[18][i]

    if isValidNode LOCgroupedNode then
    (
      if isGroupMember LOCgroupedNode then deleteItem LOCmasterArray[18] i
    )
  )

  LOCmasterArray -- return value
)

--- Get A List of LIGHT Object Handles Which Form Part of Daylight Assemblies
fn DYNFUNgetDaylightMembers FUNstring =
(
  local LOCoutLightNodes = #()
  local LOChelpers = (DYNFUNgetCivilViewCategorizedNodeArrays FUNstring false)[20]
  local LOClights = (DYNFUNgetCivilViewCategorizedNodeArrays FUNstring false)[21]

  if FUNstring == "nodes" then
  (
    for i in LOClights do
    (
      if classOf i == Sun_Positioner then append LOCoutLightNodes i
    )

    for i in LOChelpers do
    (
      local LOClightNodes = #()
      if classOf i == DaylightAssemblyHead then
      (
        if isValidNode i then assemblyMgr.FilterAssembly i Light &LOClightNodes
        for ii in LOClightNodes do append LOCoutLightNodes ii
      )
    )
  )

  if FUNstring == "handles" then
  (
    for i in LOClights do
    (
      local LOCnode = maxOps.getNodeByHandle i
      if classOf LOCnode == Sun_Positioner then append LOCoutLightNodes LOCnode.inode.handle
    )
  
    for i in LOChelpers do
    (
      local LOClightNodes = #()
      local LOCnode = maxOps.getNodeByHandle i
      if classOf LOCnode == DaylightAssemblyHead then
      (
        if isValidNode LOCnode then assemblyMgr.FilterAssembly LOCnode Light &LOClightNodes
        for ii in LOClightNodes do append LOCoutLightNodes ii.inode.handle
      )
    )
  )

  LOCoutLightNodes -- return value
)

fn DYNFUNisVueOrScanlineProductionRenderer =
(
  classof renderers.production == VUE_File_Renderer or classof renderers.production == Default_Scanline_Renderer
)

--- Function to create or refresh Civil View Explorer Tree
fn DYNFUNrebuildExplorerTreeNodes FUNuiResourcesObjClasses FUNuiResourcesCvExplorer =
(
  if DYNmainFloater != undefined and DYNamite.dnTabCtrl.selectedIndex == 0 then
  (
    local LOCdnMatNodes = DYNamite.LOCdnMatNodes = #() ; LOCdnMatNodes[07] = undefined
    local LOCdnVspNodes = DYNamite.LOCdnVspNodes = #() ; LOCdnVspNodes[20] = undefined

    --- Get Expanded State of all root nodes
    local LOCmainNodeStatus = #() ; LOCmainNodeStatus[9] = undefined
    LOCmainNodeStatus[1] = false
    LOCmainNodeStatus[2] = if DYNamite.dnEnvRootNode  != undefined then DYNamite.dnEnvRootNode.isExpanded else false
    LOCmainNodeStatus[3] = if DYNamite.dnMatRootNode  != undefined then DYNamite.dnMatRootNode.isExpanded else false
    LOCmainNodeStatus[4] = if DYNamite.dnVspRootNode  != undefined then DYNamite.dnVspRootNode.isExpanded else true
    LOCmainNodeStatus[5] = if DYNamite.dnNonRootNode  != undefined then DYNamite.dnNonRootNode.isExpanded else false
    LOCmainNodeStatus[6] = if DYNamite.dnDaylightNode != undefined then DYNamite.dnDaylightNode.isExpanded else true
    LOCmainNodeStatus[7] = if DYNamite.dnImportedNode != undefined then DYNamite.dnImportedNode.isExpanded else true
    LOCmainNodeStatus[8] = if DYNamite.dnPlacedNode   != undefined then DYNamite.dnPlacedNode.isExpanded else true
    LOCmainNodeStatus[9] = if DYNamite.dnOtherNode    != undefined then DYNamite.dnOtherNode.isExpanded else true

    DYNamite.dnExplorer.nodes.clear()

    --- Update IMAGELIST Control
    DYNamite.dnExplorer.imageList  = if DYNINIshowIcons then DYNdnSmImageList else undefined

    --- Create WORLD Branch
    DYNamite.dnWorldNode           = DYNamite.dnExplorer.Nodes.add  "#01VSPID" FUNuiResourcesCvExplorer[8] 44 44

    --- Create SETTINGS Branch
    DYNamite.dnSettingsNode        = DYNamite.dnWorldNode.Nodes.add "#02VSPID" FUNuiResourcesCvExplorer[10] 21 21

    --- Create ENVIRONMENT Branch (dotNet)
    DYNamite.dnEnvRootNode         = DYNamite.dnWorldNode.Nodes.add "#03VSPID" FUNuiResourcesCvExplorer[1] 37 37
    DYNamite.dnDaylightNode        = DYNamite.dnEnvRootNode.nodes.add ("&" + FUNuiResourcesCvExplorer[11]) FUNuiResourcesCvExplorer[11] 27 27
    DYNamite.dnSkyNode             = DYNamite.dnEnvRootNode.nodes.add ("&" + FUNuiResourcesCvExplorer[4])  FUNuiResourcesCvExplorer[4]  24 24
    DYNamite.dnExposeNode          = DYNamite.dnEnvRootNode.nodes.add ("&" + FUNuiResourcesCvExplorer[5])  FUNuiResourcesCvExplorer[5]  29 29
    DYNamite.dnLgtNode             = DYNamite.dnEnvRootNode.nodes.add ("&" + FUNuiResourcesCvExplorer[3])  FUNuiResourcesCvExplorer[3] 25 25
    DYNamite.dnAtmosNode           = DYNamite.dnEnvRootNode.nodes.add ("&" + FUNuiResourcesCvExplorer[2])  FUNuiResourcesCvExplorer[2] 30 30

    --- Create MATERIALS Branch
    DYNamite.dnMatRootNode         = DYNamite.dnWorldNode.Nodes.add   "#04VSPID" FUNuiResourcesCvExplorer[6] 37 37

    LOCdnMatNodes[01]              = DYNamite.dnMatRootNode.nodes.add ("!" + DYNmatNameSurfaces)  (DYNmatNameSurfaces  + " (0)") 23 23
    LOCdnMatNodes[02]              = DYNamite.dnMatRootNode.nodes.add ("!" + DYNmatNameVehicles)  (DYNmatNameVehicles  + " (0)") 23 23
    LOCdnMatNodes[03]              = DYNamite.dnMatRootNode.nodes.add ("!" + DYNmatNameObjects)   (DYNmatNameObjects   + " (0)") 23 23
    LOCdnMatNodes[04]              = DYNamite.dnMatRootNode.nodes.add ("!" + DYNmatNameTrees)     (DYNmatNameTrees     + " (0)") 23 23
    LOCdnMatNodes[05]              = DYNamite.dnMatRootNode.nodes.add ("!" + DYNmatNameMarkings)  (DYNmatNameMarkings  + " (0)") 23 23
    LOCdnMatNodes[06]              = DYNamite.dnMatRootNode.nodes.add ("!" + DYNmatNameRails)     (DYNmatNameRails     + " (0)") 23 23
    LOCdnMatNodes[07]              = DYNamite.dnMatRootNode.nodes.add ("!" + DYNmatNameBuildings) (DYNmatNameBuildings + " (0)") 23 23
    for i = 1 to LOCdnMatNodes.count do LOCdnMatNodes[i].tag = i as string

    --- Create Civil View Generated Objects Branch
    DYNamite.dnvspRootNode         = DYNamite.dnWorldNode.Nodes.add   "#05VSPID"  (FUNuiResourcesCvExplorer[7]  + " (0)") 37 37

    --- Create Imported Civil View Objects Branch
    DYNamite.dnImportedNode        = DYNamite.dnvspRootNode.Nodes.add  "#07VSPID"  (FUNuiResourcesCvExplorer[32] + " (0)") 37 37
    LOCdnvspNodes[16]              = DYNamite.dnImportedNode.nodes.add "#VSPCAT16" (FUNuiResourcesObjClasses[16] + " (0)") 16 16
    LOCdnvspNodes[07]              = DYNamite.dnImportedNode.nodes.add "#VSPCAT7"  (FUNuiResourcesObjClasses[07] + " (0)")  7  7
    LOCdnvspNodes[08]              = DYNamite.dnImportedNode.nodes.add "#VSPCAT8"  (FUNuiResourcesObjClasses[08] + " (0)")  8  8
    LOCdnvspNodes[15]              = DYNamite.dnImportedNode.nodes.add "#VSPCAT15" (FUNuiResourcesObjClasses[15] + " (0)") 15 15
    LOCdnvspNodes[14]              = DYNamite.dnImportedNode.nodes.add "#VSPCAT14" (FUNuiResourcesObjClasses[14] + " (0)") 14 14

    --- Create Placed Civil View Objects Branch
    DYNamite.dnPlacedNode          = DYNamite.dnvspRootNode.Nodes.add "#08VSPID"  (FUNuiResourcesCvExplorer[33] + " (0)") 37 37
    LOCdnvspNodes[01]              = DYNamite.dnPlacedNode.nodes.add "#VSPCAT1"  (FUNuiResourcesObjClasses[01] + " (0)")  1  1
    LOCdnvspNodes[02]              = DYNamite.dnPlacedNode.nodes.add "#VSPCAT2"  (FUNuiResourcesObjClasses[02] + " (0)")  2  2
    LOCdnvspNodes[03]              = DYNamite.dnPlacedNode.nodes.add "#VSPCAT3"  (FUNuiResourcesObjClasses[03] + " (0)")  3  3
    LOCdnvspNodes[04]              = DYNamite.dnPlacedNode.nodes.add "#VSPCAT4"  (FUNuiResourcesObjClasses[04] + " (0)")  4  4
    LOCdnvspNodes[05]              = DYNamite.dnPlacedNode.nodes.add "#VSPCAT5"  (FUNuiResourcesObjClasses[05] + " (0)")  5  5
    LOCdnvspNodes[06]              = DYNamite.dnPlacedNode.nodes.add "#VSPCAT6"  (FUNuiResourcesObjClasses[06] + " (0)")  6  6

    --- Create Civil View Other Objects Branch
    DYNamite.dnOtherNode           = DYNamite.dnvspRootNode.Nodes.add "#09VSPID"  (FUNuiResourcesCvExplorer[34] + " (0)") 37 37
    LOCdnvspNodes[09]              = DYNamite.dnOtherNode.nodes.add "#VSPCAT9"  (FUNuiResourcesObjClasses[09] + " (0)")  9  9
    LOCdnvspNodes[10]              = DYNamite.dnOtherNode.nodes.add "#VSPCAT10" (FUNuiResourcesObjClasses[10] + " (0)") 10 10
    LOCdnvspNodes[12]              = DYNamite.dnOtherNode.nodes.add "#VSPCAT12" (FUNuiResourcesObjClasses[12] + " (0)") 12 12
    LOCdnvspNodes[13]              = DYNamite.dnOtherNode.nodes.add "#VSPCAT13" (FUNuiResourcesObjClasses[13] + " (0)") 13 13
    LOCdnvspNodes[11]              = DYNamite.dnOtherNode.nodes.add "#VSPCAT11" (FUNuiResourcesObjClasses[11] + " (0)") 11 11

    --- Create NON-VSP OBJECTS Branch
    DYNamite.dnNonRootNode         = DYNamite.dnWorldNode.Nodes.add   "#06VSPID"  (FUNuiResourcesCvExplorer[9]  + " (0)") 37 37
    LOCdnvspNodes[17]              = DYNamite.dnNonRootNode.nodes.add "#NONCAT17" (FUNuiResourcesObjClasses[17] + " (0)") 17 17
    LOCdnvspNodes[18]              = DYNamite.dnNonRootNode.nodes.add "#NONCAT18" (FUNuiResourcesObjClasses[18] + " (0)") 18 18
    LOCdnvspNodes[19]              = DYNamite.dnNonRootNode.nodes.add "#NONCAT19" (FUNuiResourcesObjClasses[19] + " (0)") 19 19
    LOCdnvspNodes[20]              = DYNamite.dnNonRootNode.nodes.add "#NONCAT20" (FUNuiResourcesObjClasses[20] + " (0)") 20 20

    --- Expand Some Nodes
    DYNamite.dnWorldNode.expand()
    if LOCmainNodeStatus[2] then DYNamite.dnEnvRootNode.expand()
    if LOCmainNodeStatus[3] then DYNamite.dnMatRootNode.expand()
    if LOCmainNodeStatus[4] then DYNamite.dnvspRootNode.expand()
    if LOCmainNodeStatus[5] then DYNamite.dnnonRootNode.expand()
    if LOCmainNodeStatus[6] then DYNamite.dnDaylightNode.expand()
    if LOCmainNodeStatus[7] then DYNamite.dnImportedNode.expand()
    if LOCmainNodeStatus[8] then DYNamite.dnPlacedNode.expand()
    if LOCmainNodeStatus[9] then DYNamite.dnOtherNode.expand()
  )
)

fn DYNFUNdnColor FUNcolor =
(
  DYNdnColorClass.FromArgb FUNcolor.r FUNcolor.g FUNcolor.b
)

--- Function to update values of all Explorer Nodes inc materials, objects, and environment nodes
fn DYNFUNupdateExplorer FUNuiResourcesObjClasses FUNuiResourcesCvExplorer =
(
  local LOCtextColor = ((colorMan.getColor #text) as color) * 255
  DYNobjHandles      = DYNFUNgetCivilViewCategorizedNodeArrays "handles" true -- rebuild main DVSP object arrays

  --- GATHER SUN AND DAYLIGHT OBJECTS BEFORE WE REMOVE THESE FROM THE LIGHTS ARRAY
  local LOCdaylightHandle           = ""
  local LOCdaylightCount            = 0
  for i in DYNobjHandles[20] do if classOf (maxOps.getNodebyHandle i) == DaylightAssemblyHead then (LOCdaylightCount += 1; LOCdaylightHandle = i as string)
  for i in DYNobjHandles[21] do if classOf (maxOps.getNodebyHandle i) == Sun_Positioner then (LOCdaylightCount += 1; LOCdaylightHandle = i as string)

  --- Remove lights from array which are referenced by daylight assemblies
  local LOCexcludeList = DYNFUNgetDaylightMembers "handles"
  for i in LOCexcludeList do (if findItem DYNobjHandles[21] i > 0 then deleteItem DYNobjHandles[21] (findItem DYNobjHandles[21] i))

  --- Update Explorer Panel Nodes If Explorer Panel Is Open
  if DYNmainFloater != undefined and DYNamite.dnTabCtrl.selectedIndex == 0 then
  (
    ---- UPDATE ENVIRONMENT NODE
    DYNamite.dnSkyNode.forecolor      = DYNFUNdnColor (if useEnvironmentMap and classOf environmentMap == Physical_Sun___Sky_Environment then LOCtextColor else DYNINIgreyedOutColor)
    DYNamite.dnAtmosNode.forecolor    = DYNFUNdnColor (if numAtmospherics > 0         then (if (isActive (getAtmospheric 1)) == false then DYNINIgreyedOutColor else LOCtextColor) else DYNINIgreyedOutColor)
    DYNamite.dnExposeNode.forecolor   = DYNFUNdnColor (if SceneExposureControl.exposureControl == undefined then DYNINIgreyedOutColor else if not SceneExposureControl.exposureControl.active then DYNINIgreyedOutColor else LOCtextColor)

    --- UPDATE DAYLIGHT NODES
    DYNamite.dnDaylightNode.text      = FUNuiResourcesCvExplorer[11] + " (" + (LOCdaylightCount as string) + ")"
    DYNamite.dnDaylightNode.forecolor = DYNFUNdnColor (if LOCdaylightCount > 0 then LOCtextColor else DYNINIgreyedOutColor)
    DYNamite.dnDaylightNode.tag       = LOCdaylightHandle

    -- UPDATE GENERAL LIGHT MODE
    DYNamite.dnLgtNode.forecolor      = DYNFUNdnColor (if DYNobjHandles[21].count > 0 then LOCtextColor else DYNINIgreyedOutColor)
    DYNamite.dnLgtNode.text           = FUNuiResourcesCvExplorer[3] + " (" + (DYNobjHandles[21].count as string) + ")"

    ---- UPDATE MATERIAL NODES
    local LOCmatChannelCount = 0
    local LOCdvspMatArray = #(DYNmatNameSurfaces, DYNmatNameVehicles, DYNmatNameObjects, DYNmatNameTrees, DYNmatNameMarkings, DYNmatNameRails, DYNmatNameBuildings)
    for i = 1 to LOCdvspMatArray.count do
    (
      local LOCmatNameArray = try (sceneMaterials[LOCdvspMatArray[i]].names) catch (#())
      DYNamite.LOCdnmatNodes[i].forecolor = DYNFUNdnColor (if LOCmatNameArray.count == 0 then DYNINIgreyedOutColor else LOCtextColor)
      DYNamite.LOCdnmatNodes[i].text      = LOCdvspMatArray[i] + " (" + (LOCmatNameArray.count as string) + ")"

      if LOCmatNameArray.count > 0 then LOCmatChannelCount += 1
    )
    DYNamite.dnmatRootNode.text = FUNuiResourcesCvExplorer[6] + " (" + (LOCmatChannelCount as string) + ")"

    ---- UPDATE Civil View Generated Object Nodes
    local LOCcnt  = 0
    for i = 1 to DYNcivilViewCategoryCount do
    (
      LOCcnt += DYNobjHandles[i].count
      DYNamite.LOCdnvspNodes[i].text = FUNuiResourcesObjClasses[i] + " (" + (DYNobjHandles[i].count as string) + ")"
      DYNamite.LOCdnvspNodes[i].forecolor = DYNFUNdnColor (if DYNobjHandles[i].count > 0 then LOCtextColor else DYNINIgreyedOutColor)
    )
    DYNamite.dnVspRootNode.text = FUNuiResourcesCvExplorer[7] + " (" + (LOCcnt as string) + ")"

    --- Update Civil View Placed Object Parent Node
    local LOCcnt = 0
    for i = 1 to 6 do LOCcnt += DYNobjHandles[i].count
    DYNamite.dnPlacedNode.text = FUNuiResourcesCvExplorer[33] + " (" + (LOCcnt as string) + ")"
    DYNamite.dnPlacedNode.forecolor = DYNFUNdnColor (if LOCcnt > 0 then LOCtextColor else DYNINIgreyedOutColor)

    --- Update Civil View Other Object Parent Node
    local LOCcnt = 0
    for i = 9 to 13 do LOCcnt += DYNobjHandles[i].count
    DYNamite.dnOtherNode.text = FUNuiResourcesCvExplorer[34] + " (" + (LOCcnt as string) + ")"
    DYNamite.dnOtherNode.forecolor = DYNFUNdnColor (if LOCcnt > 0 then LOCtextColor else DYNINIgreyedOutColor)

    ---- UPDATE Civil View Imported Object Parent Node
    local LOCcnt = 0
    for i in DYNimportCatsArray do LOCcnt += DYNobjHandles[i].count
    DYNamite.dnImportedNode.text = FUNuiResourcesCvExplorer[32] + " (" + (LOCcnt as string) + ")"
    DYNamite.dnImportedNode.forecolor = DYNFUNdnColor (if LOCcnt > 0 then LOCtextColor else DYNINIgreyedOutColor)

    ---- UPDATE Non-CivilView OBJECT NODES
    local LOCcnt  = 0
    for i = 17 to 20 do
    (
      LOCcnt += DYNobjHandles[i].count
      DYNamite.LOCdnVspNodes[i].text = FUNuiResourcesObjClasses[i] + " (" + (DYNobjHandles[i].count as string) + ")"
      DYNamite.LOCdnVspNodes[i].forecolor = DYNFUNdnColor (if DYNobjHandles[i].count > 0 then LOCtextColor else DYNINIgreyedOutColor)
    )
    DYNamite.dnNonRootNode.text = FUNuiResourcesCvExplorer[9] + " (" + (LOCcnt as string) + ")"
  )
)

fn DYNFUNinitializeCivilView =
(
    DYNforceManualStart = true
    fileIn ((getdir #maxroot) + "stdplugs\\(CivilView)\\CivilViewStartup.ms")
)

---Function to reset FOG parameters to Default settings
fn DYNFUNresetFogParams FUNfog =
(
  FUNfog.fog_color      = (color 155 200 225)
  FUNfog.fog_background = 0
  FUNfog.fog_type       = 0
  FUNfog.near           = 0.0
  FUNfog.far            = 45.0
  FUNfog.exponential    = 1
  FUNfog.name           = DYNfogName

  setActive FUNfog true
)

---Function to reset Sky to Defult EnvironmentMap settings
fn DYNFUNresetEnvironmentMap =
(
  --- CivilView Environment 
  if classOf environmentMap == Physical_Sun___Sky_Environment then
  (
    --environmentMap.sun_position_object                =    -- : node

    environmentMap.global_intensity                     = 1.0     -- : float
    environmentMap.haze                                 = 0.0     -- : float
    environmentMap.sun_enabled                          = true    -- : boolean
    environmentMap.sun_disc_intensity                   = 1.0     -- : float
    environmentMap.sun_glow_intensity                   = 1.0     -- : float
    environmentMap.sun_disc_scale                       = 1.0     -- : float
    environmentMap.sun_disc_scale_percent               = 100.0   -- : float
    environmentMap.sky_intensity                        = 1.0     -- : float
    environmentMap.night_color                          = (color 255 255 255) -- : fRGBA color
    environmentMap.night_intensity                      = 1.0     -- : float
    environmentMap.horizon_height_deg                   = 0.0     -- : float
    environmentMap.horizon_blur_deg                     = 0.1     -- : float
    environmentMap.ground_color                         = (color 51 51 51)    -- : fRGBA color
    environmentMap.saturation                           = 1.0     -- : float
    environmentMap.tint                                 = (color 255 255 255) -- : fRGBA color
    environmentMap.illuminance_model                    = 0       -- : integer
    environmentMap.perez_diffuse_horizontal_illuminance = 10000.0 -- : float
    environmentMap.perez_direct_normal_illuminance      = 50000.0 -- : float
  )
)


--- Function for setting viewports to default layout
fn DYNFUNviewportSetup =
(
  /*
  --- Viewport Options Disabled for Autodesk 2012 release - considered too invasive for general use
  viewport.setLayout #layout_1
  viewport.setType   #view_top
  gw.setRndLimits    #(#wireframe)
  */
  if DYNINIdisableGrid != "0" then (viewport.setGridVisibility #all false)
  redrawViews()
)

--- Function to either load or unload map paths
fn DYNFUNloadMapPaths FUNswitch =
(
  local LOCmapPathsArray = #(DYNfolderNameVehicleMaps, DYNfolderNameSurfaceMaps, DYNfolderNameFurnitureMaps, DYNfolderNameSignMaps, DYNfolderNameTreeMaps, DYNfolderNameMarkingMaps, DYNfolderNameRailMaps, DYNfolderNameBuildingMaps)
  for i = 1 to LOCmapPathsArray.count do LOCmapPathsArray[i] = (DYNcountryPath + DYNfolderNameMatLibs + "\\" + LOCmapPathsArray[i] + "\\")
  append LOCmapPathsArray (DYNSkyMapPath)
  append LOCmapPathsArray (DYNglobalMapsPath + DYNfolderNameSurfaceMaps + "\\")
  append LOCmapPathsArray (DYNglobalMapsPath + DYNfolderNameVehicleMaps + "\\")

  if FUNswitch == true then
  (
    for i = 1 to LOCmapPathsArray.count do mapPaths.add LOCmapPathsArray[i]
  )
  else
  (
    for i = mapPaths.count() to 1 by -1 do (if findItem LOCmapPathsArray (mapPaths.get i) > 0 then mapPaths.delete i)
  )
)


---Function to set up material libraries when dynamite is started and when reset or new file is called
fn DYNFUNsetUpMaterialLibraries =
(
  --- Ensure that materials are placed into 3dsmax Material Editor
  local LOCsceneMats = scenematerials

  -- if environmentMap == undefined then
  -- (
  --   if objects.count == 0 then
  --   (
  --     environmentMap = Physical_Sun___Sky_Environment()
  --     UseEnvironmentMap = true
  --     DYNFUNresetEnvironmentMap()
  --   )
  -- )

  --- Set Up Default Fog Atmospheric Effect
  local LOCfog
  if numAtmospherics > 0 then
  (
    for i = 1 to numAtmospherics do (if (getAtmospheric i).name == DYNfogName then LOCfog = getAtmospheric i)
  )
  if LOCfog == undefined then
  (
    LOCfog = fog()
    addAtmospheric LOCfog
    DYNFUNresetFogParams LOCfog
    if DYNINIenableFog == "0" then setActive LOCfog false
  )

  --- Set Up Other Scene Specific Defaults
  if objects.count == 0 and (xrefs.getXRefFileCount()) == 0 then
  (
    DYNFUNviewportSetup()
    frameRate      = DYNINIframeRate
    animationRange = (interval (0 as time) (1000 as time))
    ambientcolor   = (color 12 12 12)
  )
)

--- Function to set CivilView file paths which are affected by country kit choice
fn DYNFUNsetCountryPaths FUNcountry FUNcountryRootPath =
(
  local LOColdPlace = DYNINIcountry
  DYNINIcountry     = FUNcountry
  DYNcountrypath    = FUNcountryRootPath + DYNcountryKitFolderSeedName + " " + FUNcountry + "\\"

  --- Plus, if new country kit was selected, reset Style Default Diectories
  if DYNINIcountry != LOColdPlace then
  (
    rootNode.DYNrootNodeStore.genPath  = (getdir #import) + "\\*.txt"
    rootNode.DYNrootNodeStore.mfwPath  = (getdir #import) + "\\*.fil"
    rootNode.DYNrootNodeStore.xmlPath  = (getdir #import) + "\\*.xml"
    rootNode.DYNrootNodeStore.twdPath  = (getdir #import) + "\\*.12da"
    rootNode.DYNrootNodeStore.string01 = (getdir #import) + "\\*.vsp3d"
  )

  --- If paths contain null value, insert a default
  if rootNode.DYNrootNodeStore.genPath  == "" then rootNode.DYNrootNodeStore.genPath  = (getdir #import) + "\\*.txt"
  if rootNode.DYNrootNodeStore.mfwPath  == "" then rootNode.DYNrootNodeStore.mfwPath  = (getdir #import) + "\\*.fil"
  if rootNode.DYNrootNodeStore.xmlPath  == "" then rootNode.DYNrootNodeStore.xmlPath  = (getdir #import) + "\\*.xml"
  if rootNode.DYNrootNodeStore.twdPath  == "" then rootNode.DYNrootNodeStore.twdPath  = (getdir #import) + "\\*.12da"
  if rootNode.DYNrootNodeStore.string01 == "" then rootNode.DYNrootNodeStore.string01 = (getdir #import) + "\\*.vsp3d"

  --- If paths contain links to directories which don't exist, change to a default
  if (doesFileExist (substring (getFilenamePath rootNode.DYNrootNodeStore.genPath)  1 ((getFilenamePath rootNode.DYNrootNodeStore.genPath).count  - 1))) == false then rootNode.DYNrootNodeStore.genPath  = (getdir #import) + "\\*.txt"
  if (doesFileExist (substring (getFilenamePath rootNode.DYNrootNodeStore.mfwPath)  1 ((getFilenamePath rootNode.DYNrootNodeStore.mfwPath).count  - 1))) == false then rootNode.DYNrootNodeStore.mfwPath  = (getdir #import) + "\\*.fil"
  if (doesFileExist (substring (getFilenamePath rootNode.DYNrootNodeStore.xmlPath)  1 ((getFilenamePath rootNode.DYNrootNodeStore.xmlPath).count  - 1))) == false then rootNode.DYNrootNodeStore.xmlPath  = (getdir #import) + "\\*.xml"
  if (doesFileExist (substring (getFilenamePath rootNode.DYNrootNodeStore.twdPath)  1 ((getFilenamePath rootNode.DYNrootNodeStore.twdPath).count  - 1))) == false then rootNode.DYNrootNodeStore.twdPath  = (getdir #import) + "\\*.12da"
  if (doesFileExist (substring (getFilenamePath rootNode.DYNrootNodeStore.string01) 1 ((getFilenamePath rootNode.DYNrootNodeStore.string01).count - 1))) == false then rootNode.DYNrootNodeStore.string01 = (getdir #import) + "\\*.vsp3d"
)

--- Function to display a rollout with an EditText control in it
fn DYNFUNdisplayEditText FUNcaption1 FUNcaption2 FUNtext =
(
  ExeStr=("rollout DYNrollout \"" + FUNcaption1 + "\"\n")
  ExeStr+=("(\n")
  ExeStr+=(" local LOCresult")
  ExeStr+=(" label    LBDYNtext pos:[30,20] width:232\n")
  ExeStr+=(" editText EDDYNtext pos:[26,38] width:236\n")
  ExeStr+=(" button BUDYNokok DYNuiResourcesCivilViewGlobal[1] width:84 across:2\n")
  ExeStr+=(" button BUDYNcanc DYNuiResourcesCivilViewGlobal[2] width:84 \n")
  ExeStr+=(" on DYNrollout open do\n")
  ExeStr+="  (\n"
  ExeStr+=("   LBDYNtext.text = \"" + FUNcaption2 + "\"\n")
  ExeStr+=("   EDDYNtext.text = \"" + FUNtext + "\"\n")
  ExeStr+=("   BUDYNokok.pos.y = 77\n")
  ExeStr+=("   BUDYNcanc.pos.y = 77\n")
  ExeStr+=("   setFocus DYNrollout.EDDYNtext\n")
  ExeStr+="  )\n"
  ExeStr+="  on BUDYNokok pressed do (LOCresult = EDDYNtext.text ; destroyDialog DYNrollout)\n"
  ExeStr+="  on BUDYNcanc pressed do (LOCresult = undefined      ; destroyDialog DYNrollout)\n"
  ExeStr+=")\n"

  local DYNrollout = Execute ExeStr

  createDialog DYNrollout width:294 height:117 modal:true
  return DYNrollout.LOCresult
)

--- Function to display a progress bar panel on screen
fn DYNFUNdisplayProgressPanel =
(
  local ExeStr=("rollout DYNprogressPanel \"" + DYNuiResourcesCivilViewGlobal[3] + "\"\n")
  ExeStr+=("(\n")
  ExeStr+=("  label LBDYNstatus1 width:598 height:18\n")
  ExeStr+=("  dotNetControl  dnProgress \"System.Windows.Forms.ProgressBar\" width:600 height:14\n")
  ExeStr+=("  label LBDYNstatus2 width:598 height:18\n")
  ExeStr+=("\n")
  ExeStr+=("  on DYNprogressPanel open do\n")
  ExeStr+=("  (\n")
  ExeStr+=("    dnProgress.value    = 0\n")
  ExeStr+=("    LBDYNstatus1.pos.x += 5\n")
  ExeStr+=("    LBDYNstatus2.pos.x += 5\n")
  ExeStr+=("  )\n")
  ExeStr+=(")\n")

  Execute ExeStr
)

--- Function to remove DYNXFCC/DYNXFCCV3/DYNXFCCM3 controller and revert to standard PRS controller
fn DYNFUNbakeXFCCtoPRS FUNobj =
(
/*
  -- OLD FUNCTION FROM V3.1 (PRE V3.5)
  local LOCswitch = try (FUNobj.transform.controller.category == #Civil_View) catch (false)
  if LOCswitch then (FUNobj.transform.controller = prs())
*/

  local LOCctrl
  local LOCswitch = false

  LOCswitch = try (FUNobj.transform.controller.category == #Civil_View) catch (false)
  if LOCswitch then LOCctrl = FUNobj.transform.controller

  if LOCswitch and LOCctrl != undefined then
  (
    local LOCxformArray = #()
    local LOCrange
    if LOCctrl.percent.keys != undefined then
    (
      LOCrange         = getTimeRange LOCctrl.percent.controller
      local LOCrangeH  = if LOCctrl.hOffset.keys  != undefined then (getTimeRange LOCctrl.hOffset.controller)  else LOCrange
      local LOCrangeV  = if LOCctrl.vOffset.keys  != undefined then (getTimeRange LOCctrl.vOffset.controller)  else LOCrange
      local LOCrangeR  = if LOCctrl.rotation.keys != undefined then (getTimeRange LOCctrl.rotation.controller) else LOCrange

      if LOCrangeH.start < LOCrange.start then LOCrange.start = LOCrangeH.start
      if LOCrangeV.start < LOCrange.start then LOCrange.start = LOCrangeV.start
      if LOCrangeR.start < LOCrange.start then LOCrange.start = LOCrangeR.start
      if LOCrangeH.end   > LOCrange.end   then LOCrange.end   = LOCrangeH.end
      if LOCrangeV.end   > LOCrange.end   then LOCrange.end   = LOCrangeV.end
      if LOCrangeR.end   > LOCrange.end   then LOCrange.end   = LOCrangeR.end

      local LOCcnt = 0
      LOCxformArray.count = ((LOCrange.end - LOCrange.Start) as integer) / ticksPerFrame
      for i = LOCrange.start to LOCrange.end do (LOCcnt += 1; LOCxformArray[LOCcnt] = (at time i (FUNobj.transform)))
    )

    --- Reset Transform Controller
    FUNobj.transform.controller = prs()

    if LOCxformArray.count > 0 then
    (
      --- Create New Controller (borrow technique from Traffic Functionality)
      local LOCctrlP = FUNobj.pos.controller      = bezier_position()
      local LOCctrlR = FUNobj.rotation.controller = bezier_rotation()

      local LOCctrlPkeys  = LOCctrlP.keys
      local LOCctrlRkeys  = LOCctrlR.keys

      local LOCcnt = 0

      for i = LOCrange.start to LOCrange.end do
      (
        LOCcnt += 1
        local LOCnewKeyP  = addNewKey LOCctrlPkeys (i); LOCnewKeyP.value = LOCxformArray[LOCcnt].row4
        local LOCnewKeyR  = addNewKey LOCctrlRkeys (i); LOCnewKeyR.value= (inverse LOCxformArray[LOCcnt]).rotationPart
      )
    )
  )
)

--- Function to check if a parent shape is being deleted, to ensure that objects stay in same position.
fn DYNFUNresetXformControllers FUNobjArray =
(
  --- Filter Objects To an array of only shape objects
  local LOCshapeArray = #()
  for i in FUNobjArray do (if superclassof i == shape then append LOCshapeArray i)

  --- Get all placed objects from the scene
  local LOCfullNodesArray   = DYNFUNgetCivilViewCategorizedNodeArrays "nodes" false
  local LOCplacedNodesArray = LOCfullNodesArray[1] + LOCfullNodesArray[2] + LOCfullNodesArray[3] + LOCfullNodesArray[4] + LOCfullNodesArray[5] + LOCfullNodesArray[6]

  --- Remove DYNXFCC/DYNXFCCV3/DYNXFCCM3 controllers which use any of the shapes which are about to be deleted
  for i in LOCplacedNodesArray do
  (
    local LOCpath = try (i.transform.controller.path) catch ()
    if (findItem LOCshapeArray LOCpath) > 0 then
    (
      i.transform.controller = prs()
    )
  )
)

fn DYNFUNdnTreeViewStyle FUNdnTree =
(
  FUNdnTree.showRootLines  = false
  FUNdnTree.indent         = 19
  FUNdnTree.hideselection  = false
  FUNdnTree.hotTracking    = true
  FUNdnTree.backColor      = DYNFUNdnColor (((colorMan.getColor #window) as color) * 255)
  FUNdnTree.foreColor      = DYNFUNdnColor (((colorMan.getColor #text) as color) * 255)
)

-----------------------------------------------------------------------
---- CALLBACK related functions start here ----------------------------
-----------------------------------------------------------------------

fn DYNFUNremoveCSProllouts =
(
  if DYNmainFloater != undefined then
  (
    try (removeRollout DYNmrPhysicalSky    DYNmainFloater) catch ()
    try (removeRollout DYNatmosphere       DYNmainFloater) catch ()
    try (removeRollout DYNexposure         DYNmainFloater) catch ()
    try (removeRollout DYNworldStatistics  DYNmainFloater) catch ()
    try (removeRollout DYNforestParams     DYNmainFloater) catch ()
    try (removeRollout DYNuserInterface    DYNmainFloater) catch ()
    try (removeRollout DYNpositionControl  DYNmainFloater) catch ()
    try (removeRollout DYNattachParams     DYNmainFloater) catch ()
    try (removeRollout DYNsosParams        DYNmainFloater) catch ()
    try (removeRollout DYNsignParams       DYNmainFloater) catch ()
    try (removeRollout DYNsignalParams     DYNmainFloater) catch ()
    try (removeRollout DYNvehicleParams    DYNmainFloater) catch ()
    try (removeRollout DYNpSystemParams    DYNmainFloater) catch ()
    try (removeRollout DYNpNetworkParams   DYNmainFloater) catch ()
    try (removeRollout DYNmarkingParams    DYNmainFloater) catch ()
    try (removeRollout DYNgantryParams     DYNmainFloater) catch ()
    try (removeRollout DYNlampParams       DYNmainFloater) catch ()
    try (removeRollout DYNprimitiveParams  DYNmainFloater) catch ()
    try (removeRollout DYNtreeParams       DYNmainFloater) catch ()
    try (removeRollout DYNcamParams        DYNmainFloater) catch ()
    try (removeRollout DYNgRailParams      DYNmainFloater) catch ()
    try (removeRollout DYNbuildingParams   DYNmainFloater) catch ()
    try (removeRollout DYNalignmentParams  DYNmainFloater) catch ()
    try (removeRollout DYNshapeParams      DYNmainFloater) catch ()
    try (removeRollout DYNsurfaceParams    DYNmainFloater) catch ()
    try (removeRollout DYNmatEditor        DYNmainFloater) catch ()

    try (removeRollout DYNsunLight         DYNmainFloater) catch ()
    try (removeRollout DYNmrSunLight       DYNmainFloater) catch ()
    try (removeRollout DYNstdLight         DYNmainFloater) catch ()
    try (removeRollout DYNresourceList     DYNmainFloater) catch ()

    if DYNremovePOLrefreshEnable == true then
    (
      try (removeRollout DYNpathObjectList DYNmainFloater) catch ()
      try (removeRollout DYNlightList      DYNmainFloater) catch ()
    )
  )
)

fn DYNFUNnormalizeMenuName nameToNormalize =
(
  local normalizedName = ToUpper nameToNormalize
  normalizedName = substituteString normalizedName "&" ""
  normalizedName
)

fn DYNFUNremoveCivilViewFromMainMenu =
(
  local LOCmainMenuBar  = menuMan.getMainMenuBar() -- Get the main menu bar into a variable

  local LOCmenuIndex4 -- Index of Menu Item to Remove
  local CVTitleUp = DYNFUNnormalizeMenuName DYNcivilViewProductName
  for i = 1 to (LOCmainMenuBar.numItems()) do (
	  local menuTile = (LOCmainMenuBar.getItem i).getTitle()
	  menuTile = DYNFUNnormalizeMenuName menuTile
	  local foundTitle = findString menuTile CVTitleUp
	  if  foundTitle != undefined then LOCmenuIndex4 = i
  ) -- Find old Civil View Menu
  if LOCmenuIndex4 != undefined then LOCmainMenuBar.removeItemByPosition LOCmenuIndex4 -- Remove Old Menu if it was found

  menuMan.updateMenuBar()

  LOCmainMenuBar -- return value
)

fn DYNFUNpreSystemShutdownCallback =
(
  --- Empty Buffers in Extensions control
  DYNFUNiniBaseClear 1
  if DYNINIprojectKit != "0" and (DYNFUNdoesFolderExist rootNode.DYNrootNodeStore.string02) then (DYNFUNiniBaseClear 2)
  if DYNINIprivateKit == "1" and (DYNFUNdoesFolderExist DYNINIprivateKitPath) then (DYNFUNiniBaseClear 3)

  --- Close Civil View Explorer Panel
  if DYNmainFloater != undefined then
  (
    try (if DYNmainFloater.dialogBar then cui.UnRegisterDialogBar DYNmainFloater) catch () -- Unregister Dockable State of Explorer Rollout FLoater
    closerolloutfloater DYNmainFloater; DYNmainFloater = undefined                         -- Close and Reset Rollout Floater if it exists
  )

  --- Destroy and Reset all DVSP Dialogs and Rollouts
  DYNsplashPanel     = undefined
  DYNamite           = undefined          -- Needs to be undefined AFTER removal of callbacks below

  --- Destroy Civil View Dialogs
  try (if DYNdxfImport       != undefined do destroyDialog DYNdxfImport      ) catch (); DYNdxfImport       = undefined
  try (if DYNproperties      != undefined do destroyDialog DYNproperties     ) catch (); DYNproperties      = undefined
  try (if DYNsweptObjects    != undefined do destroyDialog DYNsweptObjects   ) catch (); DYNsweptObjects    = undefined
  try (if DYNgRailObjects    != undefined do destroyDialog DYNgRailObjects   ) catch (); DYNgRailObjects    = undefined
  try (if DYNbuildingObjects != undefined do destroyDialog DYNbuildingObjects) catch (); DYNbuildingObjects = undefined
  try (if DYNobjectPlacer    != undefined do destroyDialog DYNobjectPlacer   ) catch (); DYNobjectPlacer    = undefined
  try (if DYNresourceMan     != undefined do destroyDialog DYNresourceMan    ) catch (); DYNresourceMan     = undefined
  try (if DYNimportMan       != undefined do destroyDialog DYNimportMan      ) catch (); DYNimportMan       = undefined
  try (if DYNplacedMan       != undefined do destroyDialog DYNplacedMan      ) catch (); DYNplacedMan       = undefined
  try (if DYNfileSelector    != undefined do destroyDialog DYNfileSelector   ) catch (); DYNfileSelector    = undefined
  try (if DYNpreferences     != undefined do destroyDialog DYNpreferences    ) catch (); DYNpreferences     = undefined
  try (if DYNsightTool       != undefined do destroyDialog DYNsightTool      ) catch (); DYNsightTool       = undefined
  try (if DYNsplineMapper    != undefined do destroyDialog DYNsplineMapper   ) catch (); DYNsplineMapper    = undefined
  try (if DYNchainageText    != undefined do destroyDialog DYNchainageText   ) catch (); DYNchainageText    = undefined
  try (if DYNdrapeSpline     != undefined do destroyDialog DYNdrapeSpline    ) catch (); DYNdrapeSpline     = undefined
  try (if DYNpointBasedPlace != undefined do destroyDialog DYNpointBasedPlace) catch (); DYNpointBasedPlace = undefined
  try (if DYNroadMarkings    != undefined do destroyDialog DYNroadMarkings   ) catch (); DYNroadMarkings    = undefined
  try (if DYNfeatureInterp   != undefined do destroyDialog DYNfeatureInterp  ) catch (); DYNfeatureInterp   = undefined
  try (if DYNcveImport       != undefined do destroyDialog DYNcveImport      ) catch (); DYNcveImport       = undefined
  try (if DYNc3dImport       != undefined do destroyDialog DYNc3dImport      ) catch (); DYNc3dImport       = undefined
  try (if DYNdsimImport      != undefined do destroyDialog DYNdsimImport     ) catch (); DYNdsimImport      = undefined
  try (if DYNdsimSubstitute  != undefined do destroyDialog DYNdsimSubstitute ) catch (); DYNdsimSubstitute  = undefined
  try (if DYNdsimSurface     != undefined do destroyDialog DYNdsimSurface    ) catch (); DYNdsimSurface     = undefined
  try (if DYNqparImport      != undefined do destroyDialog DYNqparImport     ) catch (); DYNqparImport      = undefined

  --- Destroy Civil View Explorer Rollouts
  DYNmrPhysicalSky   = undefined
  DYNatmosphere      = undefined
  DYNexposure        = undefined
  DYNworldStatistics = undefined
  DYNpathObjectList  = undefined
  DYNresourceList    = undefined
  DYNlightList       = undefined
  DYNsunLight        = undefined
  DYNmrSunLight      = undefined
  DYNstdLight        = undefined
  DYNsignParams      = undefined
  DYNsignalParams    = undefined
  DYNvehicleParams   = undefined
  DYNmarkingParams   = undefined
  DYNgantryParams    = undefined
  DYNlampParams      = undefined
  DYNprimitiveParams = undefined
  DYNtreeParams      = undefined
  DYNcamParams       = undefined
  DYNgRailParams     = undefined
  DYNbuildingParams  = undefined
  DYNalignmentParams = undefined
  DYNshapeParams     = undefined
  DYNsurfaceParams   = undefined
  DYNforestParams    = undefined
  DYNsunLight        = undefined
  DYNmrSunLight      = undefined
  DYNuserInterface   = undefined
  DYNpositionControl = undefined
  DYNattachParams    = undefined
  DYNsosParams       = undefined
  DYNmatEditor       = undefined

  --- Restore Command Panel and floating Toolbars
  if cui.commandPanelOpen == false then cui.commandPanelOpen = true

  --- Unregister Dynamite Menus
  /*
  local LOCmainMenuBar = DYNFUNremoveCivilViewFromMainMenu()
  */

  if DynDVSPmenuImport != undefined then menuman.unregistermenu DynDVSPmenuImport
  if DynDSIMmenuTools  != undefined then menuman.unregistermenu DynDSIMmenuTools
  if DynDSIMmenuMain   != undefined then menuman.unregistermenu DynDSIMmenuMain
  if DynDVSPmenuMain   != undefined then menuman.unregistermenu DynDVSPmenuMain
  menuMan.updateMenuBar()

  DynDVSPmenuImport = undefined
  DynDVSPmenuMain   = undefined
  DynDSIMmenuMain   = undefined
  DynDSIMmenuTools  = undefined

  --- Put The Original Initialize Menu Back In Place
  /*
  local LOCmainMenuBar = menuMan.getMainMenuBar()
  DynDVSPmenuMain      = menuMan.createMenu (DYNcivilViewProductName)
  local DYNmenuItem1   = menuMan.createActionItem  "MCRinitialize" "Civil View"
  DynDVSPmenuMain.addItem DYNmenuItem1 -1

  local DynDVSPmenuMainPosition = LOCmainMenuBar.numItems() - 3
  local DynDVSPmenuMainItem = menuMan.createSubMenuItem (DYNcivilViewProductName) DynDVSPmenuMain
  DynDVSPmenuMainItem.setUseCustomTitle true
  DynDVSPmenuMainItem.setTitle (DYNcivilViewProductName)
  LOCmainMenuBar.addItem DynDVSPmenuMainItem DynDVSPmenuMainPosition

  menuMan.updateMenuBar()
  */

  --- Unload DVSP Callbacks Execute required because these functions have yet to be defined when this function is loaded
  execute ("DYNFUNloadVSPnodeCallBacks  false") -- Remove callback functions (must be last command in this function)
  execute ("DYNFUNloadVSPsceneCallBacks false") -- Remove callback functions (must be last command in this function)
)

fn DYNFUNfilePostOpenCallback =
(
  try
  (
    destroyDialog DYNsweptObjects
    destroyDialog DYNgRailObjects
    destroyDialog DYNbuildingObjects
    destroyDialog DYNobjectPlacer
    destroyDialog DYNroadMarkings
    destroyDialog DYNimportMan
    destroyDialog DYNplacedMan
    destroyDialog DYNsightTool
    destroyDialog DYNsplineMapper
    destroyDialog DYNchainageText
    destroyDialog DYNdrapeSpline
    destroyDialog DYNpointBasedPlace
    destroyDialog DYNdsimImport
    destroyDialog DYNdsimSubstitute
    destroyDialog DYNdsimSurface
    destroyDialog DYNqparImport
  )
  catch ()

  --- Rename old DVSP SceneMaterials
  if sceneMaterials[DYNoldMatNameBuildings]   != undefined then sceneMaterials[DYNoldMatNameBuildings].name   = DYNmatNameBuildings
  if sceneMaterials[DYNoldMatNameMarkings]    != undefined then sceneMaterials[DYNoldMatNameMarkings].name    = DYNmatNameMarkings
  if sceneMaterials[DYNoldMatNameObjects]     != undefined then sceneMaterials[DYNoldMatNameObjects].name     = DYNmatNameObjects
  if sceneMaterials[DYNoldMatNameRails]       != undefined then sceneMaterials[DYNoldMatNameRails].name       = DYNmatNameRails
  if sceneMaterials[DYNoldMatNameSurfaces]    != undefined then sceneMaterials[DYNoldMatNameSurfaces].name    = DYNmatNameSurfaces
  if sceneMaterials[DYNoldMatNameTrees]       != undefined then sceneMaterials[DYNoldMatNameTrees].name       = DYNmatNameTrees
  if sceneMaterials[DYNoldMatNameVehicles]    != undefined then sceneMaterials[DYNoldMatNameVehicles].name    = DYNmatNameVehicles

  --- Continue
  DYNFUNsetUpMaterialLibraries()
  if DYNamite.open do (if DYNamite.dnTabCtrl.selectedIndex != 0 then DYNamite.dnTabCtrl.selectTab 0)
  DYNFUNupdateExplorer DYNuiResourcesObjClasses DYNuiResourcesCvExplorer
  DYNFUNsetupRootNode()
  clearSelection()

  --- Set Max number of objects in Placed and Imported Object Manager if not previously set ---------
  if rootNode.DYNrootNodeStore.int02 == 0 then rootNode.DYNrootNodeStore.int02 = 2500
  if rootNode.DYNrootNodeStore.int03 == 0 then rootNode.DYNrootNodeStore.int03 = 2500

  --- Get Last Used and Current Version of DVSP -----------------------------------------------------
  local LOClastUsedVersionDVSP = try (rootNode.DYNrootNodeStore.sceneVersion) catch (0.0)
  local LOCcurrentVersionDVSP  = DYNcivilViewVersion

  --- Section Which Converts existing DynXFCC position controllers from MAX to VIZ and vice versa ---
  local LOCsavedHost = try (rootNode.DYNrootNodeStore.int01) catch (0)
  local LOCcurrHost  = 1

  --- Only enter next if loop if scene was last opened in differnt host app, or if host app ---------
  --- is not known, or if last opened in an earlier version of DVSP                         ---------
  if (LOCsavedHost != LOCcurrHost) or (LOClastUsedVersionDVSP != LOCcurrentVersionDVSP) then
  (
    local LOCplacedObjs = DYNFUNgetCivilViewCategorizedNodeArrays "nodes" false

    --- Set Up Progress Bar
    local LOCminCnt    = 0
    local LOCmaxCnt    = 0; for i = 1 to 6 do LOCmaxCnt += LOCplacedObjs[i].count

    local LOCprogressPanel = DYNFUNdisplayProgressPanel()
    createDialog LOCprogressPanel width:619 height:70 modal:false
    LOCprogressPanel.LBDYNstatus1.text = DYNuiResourcesCivilViewGlobal[5]

    local LOCprogressBar   = LOCprogressPanel.dnProgress
    local LOCprogressLabel = LOCprogressPanel.LBDYNstatus2

    for i = 1 to 6 do
    (
      for ii in LOCplacedObjs[i] do
      (
        LOCprogressBar.value = ((LOCminCnt as float) / (LOCmaxCnt as float) * 100.0)                    -- update progress

        local LOCnewCtrl = (DynXFCCM3())                                                                -- Initialise local variables
        local LOCmaxCtrl = try (copy ii.transform.controller) catch ()                                  -- attempt to get controller from object that was created in MAX
        local LOCvizCtrl = try (copy ii.transform.controller.scale.controller) catch ()                 -- attempt to get controller from object that was created in VIZ

        --- Match Properties Of New Controller To Old VIZ controller, then replace old controller with new one
        if (classOf LOCvizCtrl == DynXFCCV3) or (classOf LOCvizCtrl == DynXFCC) then
        (
          local LOCprops = getPropNames LOCvizCtrl                                                 -- Get a list of standard XFCC proprties to cycle through
          for iii in LOCprops do setProperty LOCnewCtrl iii (getProperty LOCvizCtrl iii)
          for iii in LOCprops do
          (
            local LOCctrl = getPropertyController LOCvizCtrl iii
            if LOCctrl != undefined then setPropertyController LOCnewCtrl iii LOCctrl -- Set Controller if there is one.
          )

          --- remove old DynXFCC/DynXFCCM3/DynXFCCV3 controller
          if (try (ii.transform.controller.scale.controller.category == #Civil_View) catch (false)) then (ii.transform.controller.position.controller = position_xyz(); ii.transform.controller.scale.controller = bezier_scale())
          ii.transform.controller                 = LOCnewCtrl
          ii.transform.controller.row1.controller = bezier_point3()
          DYNFUNmaxBakingControl #(ii) true
          if not rootNode.DYNrootNodeStore.bakeSwitch then DYNFUNmaxBakingControl #(ii) false
        )

        --- Match Properties Of New Controller To Old MAX controller, then replace old controller with new one
        if classOf LOCmaxCtrl == DynXFCCM3 or classOf LOCmaxCtrl == DynXFCC then
        (
          local LOCprops = getPropNames LOCmaxCtrl                                                 -- Get a list of standard XFCC proprties to cycle through later
          for iii in LOCprops do setProperty LOCnewCtrl iii (getProperty LOCmaxCtrl iii)
          for iii in LOCprops do
          (
            local LOCctrl = getPropertyController LOCmaxCtrl iii
            if LOCctrl != undefined then setPropertyController LOCnewCtrl iii LOCctrl -- Set Controller if there is one.
          )

          --- remove old DynXFCC/DynXFCCM3/DynXFCCV3 controller
          if (try (ii.transform.controller.category == #Civil_View) catch (false)) then (ii.transform.controller = prs())
          ii.transform.controller                 = LOCnewCtrl
          ii.transform.controller.row1.controller = bezier_point3()
          DYNFUNmaxBakingControl #(ii) true
          if not rootNode.DYNrootNodeStore.bakeSwitch then DYNFUNmaxBakingControl #(ii) false
        )

        LOCminCnt += 1
      )
    )
    if LOCprogressPanel != undefined then destroyDialog LOCprogressPanel -- Close Progress Bar Dialog

    /*
      The following line added at Version 4.1 because "upate Controllers" was being called every
      time a file was opened in v4.0 regardless of what the last used version of DVSP was.
    */
    try (rootNode.DYNrootNodeStore.sceneVersion = DYNcivilViewVersion) catch ()
    try (rootNode.DYNrootNodeStore.int01 = 1) catch () -- try to set rootnode to valid value which prevents this loop from being called again  (1 = max; 2 = viz)
  )

  --- Section Which Prevents Problems With Double Sided Materials in 3ds Max 2009 and upwards
  for i in sceneMaterials do
  (
    if classOf i == Multimaterial then
    (
      for ii in i do
      (
        if classof ii == DoubleSided then
        (
          try (showTextureMap ii ii.material1 off) catch ()
          try (showTextureMap ii ii.material1.diffuseMap on) catch ()
        )
      )
    )
  )
  setSaveRequired false
)

fn DYNFUNsystemPostNewCallback =
(
  try
  (
    destroyDialog DYNsweptObjects
    destroyDialog DYNgRailObjects
    destroyDialog DYNbuildingObjects
    destroyDialog DYNobjectPlacer
    destroyDialog DYNroadMarkings
    destroyDialog DYNimportMan
    destroyDialog DYNplacedMan
    destroyDialog DYNsightTool
    destroyDialog DYNsplineMapper
    destroyDialog DYNchainageText
    destroyDialog DYNdrapeSpline
    destroyDialog DYNpointBasedPlace
    destroyDialog DYNdsimImport
    destroyDialog DYNdsimSubstitute
    destroyDialog DYNdsimSurface
    destroyDialog DYNqparImport
  )
  catch ()
  DYNFUNsetUpMaterialLibraries()
  DYNFUNsetupRootNode()
  DYNFUNupdateExplorer DYNuiResourcesObjClasses DYNuiResourcesCvExplorer
  clearSelection() -- triggers DYNFUNremoveCSProllouts to be called.
)

fn DYNFUNsystemPostResetCallback = -- when reseting a scene, post open callback is also called [before reset callback] (but only if maxstart scene exists!)
(
  try
  (
    destroyDialog DYNsweptObjects
    destroyDialog DYNgRailObjects
    destroyDialog DYNbuildingObjects
    destroyDialog DYNobjectPlacer
    destroyDialog DYNroadMarkings
    destroyDialog DYNimportMan
    destroyDialog DYNplacedMan
    destroyDialog DYNsightTool
    destroyDialog DYNsplineMapper
    destroyDialog DYNchainageText
    destroyDialog DYNdrapeSpline
    destroyDialog DYNpointBasedPlace
    destroyDialog DYNdsimImport
    destroyDialog DYNdsimSubstitute
    destroyDialog DYNdsimSurface
    destroyDialog DYNqparImport
  )
  catch ()
  DYNFUNsetUpMaterialLibraries()
  DYNFUNsetupRootNode()
  DYNFUNupdateExplorer DYNuiResourcesObjClasses DYNuiResourcesCvExplorer
  clearSelection() -- triggers DYNFUNremoveCSProllouts to be called.
)

fn DYNFUNfilePostMergeCallback =
(
  DYNFUNupdateExplorer DYNuiResourcesObjClasses DYNuiResourcesCvExplorer
  DYNimportMan.DYNFUNregatherImportedObjects()
  DYNplacedMan.DYNFUNregatherPlacedObjects()
)

fn DYNFUNpostRendererChangeCallback =
(
  DYNFUNrebuildExplorerTreeNodes DYNuiResourcesObjClasses DYNuiResourcesCvExplorer
  DYNFUNupdateExplorer DYNuiResourcesObjClasses DYNuiResourcesCvExplorer
  clearSelection() -- triggers DYNFUNremoveCSProllouts to be called.
)

fn DYNFUNpostImportCallback =
(
  DYNFUNupdateExplorer DYNuiResourcesObjClasses DYNuiResourcesCvExplorer
  DYNFUNsetupRootNode()
  DYNimportMan.DYNFUNregatherImportedObjects()
  DYNplacedMan.DYNFUNregatherPlacedObjects()
)

fn DYNFUNnodeRenamedCallback = -- called whether object is selected or not
(
  local LOCnotifyParam = callbacks.notificationParam() -- 2 element array #(oldName, newName)

  --- Only if object is currently selected is the Properties panel going to be interested in the new name
  if LOCnotifyParam != undefined and selection.count == 1 and DYNproperties.open then
  (
    if selection[1] == DYNproperties.LOCselectionArray[1] then
    (
      DYNproperties.EDDYNobjectName.text = LOCnotifyParam[2]
      DYNproperties.MLDYNobjectList.items[(DYNproperties.MLDYNobjectList.selection as array)[1]] = LOCnotifyParam[2]
      DYNproperties.MLDYNobjectList.items = DYNproperties.MLDYNobjectList.items
    )
  )
  --- Worth renewing panel contents whether object is curently selected or not
  if (DYNmainFloater != undefined) and (try (DYNpathObjectList.open) catch (false)) then
  (
    DYNpathObjectList.DYNFUNgetPathObjectList()
  )
)

--- This function Mirrors above callback but always called from a broadcasted callback, so it is a good time to check for invalid nodes in the main object handle array
fn DYNFUNnodeCreatedCallback =
(
  DYNFUNupdateExplorer DYNuiResourcesObjClasses DYNuiResourcesCvExplorer
  DYNimportMan.DYNFUNregatherImportedObjects()
  DYNplacedMan.DYNFUNregatherPlacedObjects()
)

fn DYNFUNselectedNodesPreDeleteCallback = -- only called if object is currently selected, and only called once if more than one node is selected
(
  local LOCnotifyParam = callbacks.notificationParam() -- array of nodes about to be deleted, or undefined if callback broadcasted
  if classOf LOCnotifyParam == array then DYNFUNresetXformControllers LOCnotifyParam
)

fn DYNFUNselectedNodesPostDeleteCallback = -- only called if object is currently selected, and only called once if more than one object is selected
(
  DYNFUNupdateExplorer DYNuiResourcesObjClasses DYNuiResourcesCvExplorer
)

fn DYNFUNsceneUndoCallback =
(
  DYNFUNupdateExplorer DYNuiResourcesObjClasses DYNuiResourcesCvExplorer
  DYNimportMan.DYNFUNregatherImportedObjects()
  DYNplacedMan.DYNFUNregatherPlacedObjects()
)

fn DYNFUNsceneRedoCallback =
(
  DYNFUNupdateExplorer DYNuiResourcesObjClasses DYNuiResourcesCvExplorer
  DYNimportMan.DYNFUNregatherImportedObjects()
  DYNplacedMan.DYNFUNregatherPlacedObjects()
)

fn DYNFUNcolorChangedCallback =
(
  --- Update TreeView Colors
  if try (DYNamite.open) catch (false)         then (DYNFUNdnTreeViewStyle DYNamite.dnExplorer             ; DYNamite.dnExplorer.refresh() )
  if try (DYNc3dImport.open) catch (false)     then (DYNFUNdnTreeViewStyle DYNc3dImport.dnTree             ; DYNc3dImport.dnTree.refresh() )
  if try (DYNobjectPlacer.open) catch (false)  then (DYNFUNdnTreeViewStyle DYNobjectPlacer.dnIniTree       ; DYNobjectPlacer.dnIniTree.refresh() )
  if try (DYNresourceMan.open) catch (false)   then (DYNFUNdnTreeViewStyle DYNresourceMan.DNDYNiniFileTree ; DYNresourceMan.DNDYNiniFileTree.refresh() )
  if try (DYNsurfaceParams.open) catch (false) then (DYNFUNdnTreeViewStyle DYNsurfaceParams.dnStats        ; DYNsurfaceParams.dnStats.refresh() )
)

fn DYNFUNfilePostSaveCallback =
(
  local LOCnotifyParam = callbacks.notificationParam()

  --- Set Up Project Resource Kit
  if (DYNINIprojectKit as integer) > 0 and rootNode.DYNrootNodeStore.string02 == "" then
  (
    --- Use Scene Folder For Parent Path For Project Resource Kit
    if DYNINIprojectKit == "1" and DoesFileExist LOCnotifyParam then
    (
      if querybox (DYNuiResourcesCivilViewGlobal[7] + "\n\n" + (getFilenamePath LOCnotifyParam)) title:DYNuiResourcesCivilViewGlobal[3] then
      (
        local LOCprojectKitName = DYNFUNdisplayEditText DYNuiResourcesCivilViewGlobal[4] DYNuiResourcesCivilViewGlobal[8] DYNuiResourcesCivilViewGlobal[9]
        if LOCprojectKitName != undefined then
        (
          if querybox (DYNuiResourcesCivilViewGlobal[6] + "\n\n" + ((getFilenamePath LOCnotifyParam) + LOCprojectKitName + "\\")) title:DYNuiResourcesCivilViewGlobal[3] then
          (
            if (DYNFUNmakeResourceKitStructure (getFilenamePath LOCnotifyParam) LOCprojectKitName) then
            (
              rootNode.DYNrootNodeStore.string02 = (getFilenamePath LOCnotifyParam) + LOCprojectKitName + "\\"
            )
          )
        )
      )
    )

    --- Use Specific Folder For Parent Path For Project Resource Kit
    if DYNINIprojectKit == "2" then
    (
      if querybox (DYNuiResourcesCivilViewGlobal[7] + "\n\n" + DYNINIprojectKitPath) title:DYNuiResourcesCivilViewGlobal[3] then
      (
        local LOCprojectKitName = DYNFUNdisplayEditText DYNuiResourcesCivilViewGlobal[4] DYNuiResourcesCivilViewGlobal[8] (DYNFUNupperCase (getFilenameFile LOCnotifyParam) 1)
        if LOCprojectKitName != undefined then
        (
          if querybox (DYNuiResourcesCivilViewGlobal[6] + "\n\n" + (DYNINIprojectKitPath + LOCprojectKitName + "\\")) title:DYNuiResourcesCivilViewGlobal[3] then
          (
            if (DYNFUNmakeResourceKitStructure DYNINIprojectKitPath LOCprojectKitName) then
            (
              rootNode.DYNrootNodeStore.string02 = DYNINIprojectKitPath + LOCprojectKitName + "\\"
            )
          )
        )
      )
    )
  )
)

fn DYNFUNloadVSPsceneCallBacks FUNsceneSwitch =
(
  --- Scene Related Callbacks
  if FUNsceneSwitch == true then
  (
    callbacks.removescripts id:#UpdDynScene -- remove all current callbacks (just in case already exist)

    callbacks.addscript #filePostSave            "DYNFUNfilePostSaveCallback()"                 id:#UpdDynScene
    callbacks.addscript #filePostOpen            "DYNFUNfilePostOpenCallback()"                 id:#UpdDynScene
    callbacks.addscript #systemPostNew           "DYNFUNsystemPostNewCallback()"                id:#UpdDynScene
    callbacks.addscript #systemPostReset         "DYNFUNsystemPostResetCallback()"              id:#UpdDynScene
    callbacks.addscript #preSystemShutdown       "DYNFUNpreSystemShutdownCallback()"            id:#UpdDynScene

    callbacks.addscript #sceneUndo               "DYNFUNsceneUndoCallback()"                    id:#UpdDynScene
    callbacks.addscript #sceneRedo               "DYNFUNsceneRedoCallback()"                    id:#UpdDynScene
    callbacks.addscript #postRendererChange      "DYNFUNpostRendererChangeCallback()"           id:#UpdDynScene

    callbacks.addscript #colorChanged            "DYNFUNcolorChangedCallback()"                 id:#UpdDynScene
  )
  else
  (
    callbacks.removescripts id:#UpdDynScene
  )
)

fn DYNFUNloadVSPnodeCallBacks FUNnodeSwitch =
(
  --- Node related Callbacks
  if FUNnodeSwitch == true then
  (
    callbacks.removescripts id:#UpdDynNodes -- remove all current callbacks (just in case already exist)

    callbacks.addscript #filePostMerge           "DYNFUNfilePostMergeCallback()"                id:#UpdDynNodes -- should be in this section, because will be called by OPS editor
    callbacks.addscript #postImport              "DYNFUNpostImportCallback()"                   id:#UpdDynNodes -- should be in this section, because will be called by DXF import panel

    callbacks.addscript #nodeRenamed             "DYNFUNnodeRenamedCallback()"                  id:#UpdDynNodes
    callbacks.addscript #nodeCreated             "DYNFUNnodeCreatedCallback()"                  id:#UpdDynNodes

    callbacks.addscript #selectedNodesPreDelete  "DYNFUNselectedNodesPreDeleteCallback()"       id:#UpdDynNodes
    callbacks.addscript #selectedNodesPostDelete "DYNFUNselectedNodesPostDeleteCallback()"      id:#UpdDynNodes

    callbacks.addscript #fileLinkPostAttach      "DYNFUNnodeCreatedCallback()"                  id:#UpdDynNodes -- Sent just after a file link attach.
    callbacks.addscript #fileLinkPostBind        "DYNFUNnodeCreatedCallback()"                  id:#UpdDynNodes -- Sent just after a file link bind.
    callbacks.addscript #fileLinkPostDetatch     "DYNFUNnodeCreatedCallback()"                  id:#UpdDynNodes -- Sent just after a file link detach.
    callbacks.addscript #fileLinkPostReload      "DYNFUNnodeCreatedCallback()"                  id:#UpdDynNodes -- Sent just after a file link reload.

    callbacks.addscript #selectionSetChanged     "DYNamite.DYNFUNselectionSetChangedCallback()" id:#UpdDynNodes /* NOTE!!! = THis function MUST remain in the DYNamite rollout otherwise calls to VSP_???? object classes don't work when loaded from DYNfunctions */
  )
  else
  (
    callbacks.removescripts id:#UpdDynNodes
  )
)

--- Function to initialise Dynamite whenever it is started or Preferences are changed (affecting language and country most importantly)
fn DYNFUNdynamiteInitialise FUNstatusMessage FUNcountry FUNExplorerWidth FUNprogressText FUNcolor1 FUNcolor2 FUNcolor3 FUNcolor4 FUNframeRate FUNmarkerSize FUNcomPanel FUNspeedValue FUNtreeVariation FUNresetMaxMenu FUNdisableGrid FUNungpMatChan FUNcolor5 FUNdockExplorer FUNshowIcons FUNenableFog FUNchainageLoop FUNretainOPSmat FUNallowMultMarks FUNallowMultRails FUNshadowSaver FUNprivateKit FUNprojectKit FUNprivateKitPath FUNprojectKitPath FUNoverhangCorrect FUNhideDiagonals FUNfaceSmoothing FUNmatIDlimit FUNautoStart FUNrotateWheels FUNcountryRootPath =
(
  FUNprogressText.text   = FUNstatusMessage

  ---Set Up Global Variables Affected By Country Kit Choice
  DYNFUNsetCountryPaths FUNcountry FUNcountryRootPath

  ---Set Up Global Variables
  DYNINIhighlightColor   = FUNcolor1
  DYNINIgreyedOutColor   = FUNcolor2
  DYNINIstartMarkerColor = FUNcolor3
  DYNINIendMarkerColor   = FUNcolor4
  DYNINImarkingColor     = FUNcolor5
  DYNINIframeRate        = FUNframeRate
  DYNINImarkerSize       = FUNmarkerSize
  DYNINIexplorerWidth    = FUNexplorerWidth
  DYNINIcomPanel         = FUNcomPanel
  DYNINIspeedValue       = FUNspeedValue
  DYNINItreeVariation    = FUNtreeVariation
  DYNINIfaceSmoothing    = FUNfaceSmoothing
  DYNINIresetMaxMenu     = FUNresetMaxMenu
  DYNINIdisableGrid      = FUNdisableGrid
  DYNINIoverhangCorrect  = FUNoverhangCorrect
  DYNINIhideDiagonals    = FUNhideDiagonals
  DYNINIchainageLoop     = FUNchainageLoop
  DYNINIautoStart        = FUNautoStart
  DYNINIprivateKit       = FUNprivateKit
  DYNINIprojectKit       = FUNprojectKit
  DYNINIprivateKitPath   = FUNprivateKitPath ; if DYNINIprivateKitPath.count > 0 then (if (subString DYNINIprivateKitPath DYNINIprivateKitPath.count -1) != "\\" then DYNINIprivateKitPath += "\\")
  DYNINIprojectKitPath   = FUNprojectKitPath ; if DYNINIprojectKitPath.count > 0 then (if (subString DYNINIprojectKitPath DYNINIprojectKitPath.count -1) != "\\" then DYNINIprojectKitPath += "\\")
  DYNINIshadowSaver      = FUNshadowSaver
  DYNINIretainOPSmat     = FUNretainOPSmat
  DYNINIallowMultMarks   = FUNallowMultMarks
  DYNINIallowMultRails   = FUNallowMultRails
  DYNINIenableFog        = FUNenableFog
  DYNINIrotateWheels     = FUNrotateWheels
  DYNINIdockExplorer     = FUNdockExplorer
  DYNINIshowIcons        = FUNshowIcons
  DYNINIungpMatChan      = FUNungpMatChan
  DYNINImatIDlimit       = FUNmatIDlimit

  --- Make User Interface Changes
  if DYNINIcomPanel == "0" then cui.commandPanelOpen = false
  if DYNINIcomPanel == "1" then cui.commandPanelOpen = true
  preferences.constantReferenceSystem = true
  setRefCoordSys #world

  --- Increase MaxScript Heap Size To Required Minimum
  local LOCminHeap = DYNINIminHeapSize * 1024 * 1024
  if heapsize < LOCminHeap then heapsize = LOCminHeap

  --- Setting Up Callbacks
  DYNFUNloadVSPsceneCallBacks true
  DYNFUNloadVSPnodeCallBacks true

  --- The following five lines MUST stay in this function, because they are affected by the Country Kit setting
  DYNFUNloadMapPaths true  -- Always try to LOAD map paths, because it will be ignored anyway if the paths already exist.

  DYNFUNiniBaseClear 1
  DYNFUNiniReadFromFolder DYNcountryPath false 1

  if DYNINIprojectKit != "0" and (DYNFUNdoesFolderExist rootNode.DYNrootNodeStore.string02) then
  (
    DYNFUNiniBaseClear 2
    DYNFUNiniReadFromFolder rootNode.DYNrootNodeStore.string02 false 2
  )

  if DYNINIprivateKit == "1" and (DYNFUNdoesFolderExist DYNINIprivateKitPath) then
  (
    DYNFUNiniBaseClear 3
    DYNFUNiniReadFromFolder DYNINIprivateKitPath false 3
  )

  DYNFUNfilePostOpenCallback()
  gc()
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBA9hfcqmbFhTu/N+B0tvTWBmkY+Nlb+fgc
-- GHyo0l0JjtI0BQsG0kRoSn2WZSao6NDE1pK6G9OTB68vvpXrPM5GzERW6fj8D81M
-- 2oK3O2wWfaB3zas+I+r2gKec6BzjXtqvBSekxDIROb6V3fq3jT5zgJLh4jGMfOwZ
-- ZQ299+5hIuCaJZC7XpAviqo2KhMmA5IGvSlCmkCWGDvzQanoQFc6lCPViPCCN3+p
-- sdvdYYX1tToqurEg0NEhZiojLfMup2ojEfhe3AUQtzaDn/YcpHFJdfjE4eGL1/Qs
-- hPVBQd4RD9kBytd7ZKso8pNLVDBY74EESJc6O4hcUcHfqT05IRTp
-- -----END-SIGNATURE-----