--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNuserInterface ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---


  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---


  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupbox GBDYNgroup01 width:(DYNiniExplorerWidth - 21) pos:[4,7]   height:62

  label LBDYNshiftX width:100 pos:[11,26]
  label LBDYNshiftY width:100 pos:[11,47]
  spinner SPDYNshiftX "" fieldwidth:60 type:#integer range:[-100000000,100000000,0] scale:100 pos:[(DYNiniExplorerWidth - 96),26]
  spinner SPDYNshiftY "" fieldwidth:60 type:#integer range:[-100000000,100000000,0] scale:100 pos:[(DYNiniExplorerWidth - 96),47]

  groupbox GBDYNgroup02 width:(DYNiniExplorerWidth - 21) pos:[4,74]  height:61

  checkbox CKPREmarkFreeze align:#left pos:[13,93]
  label    LBDYNmarkShift width:100 pos:[13,113]
  spinner  SPDYNmarkShift "" fieldwidth:60 type:#worldunits range:[-10,10,0] scale:0.001 pos:[(DYNiniExplorerWidth - 96),113]

  groupbox GBDYNgroup03 width:(DYNiniExplorerWidth - 21) pos:[4,140] height:38
  label LBDYNmatLib align:#center pos:[13,159]

  groupbox GBDYNgroup04 width:(DYNiniExplorerWidth - 21) pos:[4,183] height:46
  button BUDYNprojectKit align:#center width:(DYNINIexplorerWidth - 35) pos:[13,202]

  groupbox GBDYNgroup05 width:(DYNiniExplorerWidth - 21) pos:[4,234] height:66
  radiobuttons RBDYNlinking labels:#(DYNuiResourcesLabels[88],DYNuiResourcesLabels[89]) pos:[13,253]
  button  BUDYNupdate align:#center width:(DYNINIexplorerWidth - 35) pos:[13,273]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNuserInterface open do
  (
    DYNuserInterface.title  = DYNuiRolloutNames[3]
    GBDYNgroup01.text       = DYNuiResourcesGroups[23]
    GBDYNgroup02.text       = DYNuiResourcesGroups[24]
    GBDYNgroup03.text       = DYNuiResourcesGroups[25]
    GBDYNgroup04.text       = DYNuiResourcesGroups[26]
    GBDYNgroup05.text       = DYNuiResourcesGroups[27]
    BUDYNupdate.text        = DYNuiResourcesButtons[14]
    LBDYNshiftX.text        = DYNuiResourcesLabels[90]
    LBDYNshiftY.text        = DYNuiResourcesLabels[91]
    LBDYNmarkShift.text     = DYNuiResourcesLabels[92]
    SPDYNshiftX.value       = rootNode.DYNrootNodeStore.shiftX
    SPDYNshiftY.value       = rootNode.DYNrootNodeStore.shiftY
    if DYNobjHandles[7].count > 0 or DYNobjHandles[8].count > 0 then
    (
      SPDYNshiftX.enabled   = false
      SPDYNshiftY.enabled   = false
    )
    LBDYNmatLib.text        = filenameFromPath (getMatLibFileName())
    CKPREmarkFreeze.text    = DYNuiResourcesLabels[87]
    CKPREmarkFreeze.checked = rootNode.DYNrootNodeStore.markFreeze
    SPDYNmarkShift.value    = rootNode.DYNrootNodeStore.markVshift

    if DYNINIprojectKit == "0" then
    (
      BUDYNprojectKit.text    = DYNuiResourcesButtons[43]
      BUDYNprojectKit.enabled = false
    )
    else
    (
      BUDYNprojectKit.text    = if rootNode.DYNrootNodeStore.string02 == "" then DYNuiResourcesButtons[15] else (DYNFUNtrimPathName rootNode.DYNrootNodeStore.string02 (DYNINIexplorerWidth - 24))
      BUDYNprojectKit.enabled = if rootNode.DYNrootNodeStore.string02 == "" then false else true
    )

    if rootNode.DYNrootNodeStore.bakeSwitch then
    (
      RBDYNlinking.state = 1
      BUDYNupdate.enabled = false
    )
    else
    (
      RBDYNlinking.state = 2
      BUDYNupdate.enabled = true
    )
  )

  on DYNuserInterface close do
  (
  )

  on BUDYNprojectKit pressed do
  (
    if not (DYNFUNdoesFolderExist rootNode.DYNrootNodeStore.string02) then
    (
      messagebox (rootNode.DYNrootNodeStore.string02 + "\n\n" + DYNuiResourcesErrorsWarnings[24]) title:DYNuiResourcesTitlebars[2]
    )

    --- Provide option for user to point to new Project Resource Kit Location
    local LOCckPath = getSavePath caption:DYNuiResourcesTitlebars[12]
    if LOCckPath != undefined then
    (
      local LOCProjectKitPath = getFilenamePath LOCckPath
      local LOCProjectKitName = filenamefromPath LOCckPath
      if querybox (DYNuiResourcesQueries[7] + "\n\n" + (LOCProjectKitPath + LOCprojectKitName + "\\")) title:DYNuiResourcesTitlebars[3] then
      (
        if (DYNFUNmakeResourceKitStructure LOCProjectKitPath LOCprojectKitName) then
        (
          rootNode.DYNrootNodeStore.string02 = LOCProjectKitPath + LOCprojectKitName + "\\"
          BUDYNprojectKit.text    = if rootNode.DYNrootNodeStore.string02 == "" then DYNuiResourcesButtons[15] else (DYNFUNtrimPathName rootNode.DYNrootNodeStore.string02 (DYNINIexplorerWidth - 24))
        )
      )
    )
  )

  on RBDYNlinking changed arg do
  (
    if arg == 1 then rootNode.DYNrootNodeStore.bakeSwitch = true else rootNode.DYNrootNodeStore.bakeSwitch = false
    local LOCobjHandles = #()
    local LOCobjects = #()
    LOCobjHandles = DYNobjHandles[1] + DYNobjHandles[2] + DYNobjHandles[3] + DYNobjHandles[4] + DYNobjHandles[5] + DYNobjHandles[6]
    for i in LOCobjHandles do append LOCobjects (maxOps.getNodeByHandle i)
    DYNFUNmaxBakingControl LOCobjects rootNode.DYNrootNodeStore.bakeSwitch
  )

  on BUDYNupdate pressed do
  (
    local LOCobjHandles = #()
    local LOCobjects = #()
    LOCobjHandles = DYNobjHandles[1] + DYNobjHandles[2] + DYNobjHandles[3] + DYNobjHandles[4] + DYNobjHandles[5] + DYNobjHandles[6]
    for i in LOCobjHandles do append LOCobjects (maxOps.getNodeByHandle i)
    DYNFUNmaxBakingControl LOCobjects true
    if not rootNode.DYNrootNodeStore.bakeSwitch then DYNFUNmaxBakingControl LOCobjects false
  )

  on SPDYNshiftX changed val do
  (
    rootNode.DYNrootNodeStore.shiftX = val
  )
  on SPDYNshiftX entered do
  (
    if SPDYNshiftX.value > 0 then (messagebox (DYNuiResourcesErrorsWarnings[22] + "\n\n" + DYNuiResourcesErrorsWarnings[23]) title:DYNuiResourcesTitlebars[2])
  )

  on SPDYNshiftY changed val do
  (
    rootNode.DYNrootNodeStore.shiftY = val
  )
  on SPDYNshiftY entered do
  (
    if SPDYNshiftY.value > 0 then (messagebox (DYNuiResourcesErrorsWarnings[22] + "\n\n" + DYNuiResourcesErrorsWarnings[23]) title:DYNuiResourcesTitlebars[2])
  )

  on SPDYNmarkShift entered do
  (
    --- Update All Road Marking Lines (VSPobjCat 10)
    for i = 1 to DYNobjHandles[10].count do
    (
      local LOCmarkNode = maxOps.getNodeByHandle DYNobjHandles[10][i]
      if isValidNode LOCmarkNode then
      (
        local LOCoverrideState = try ((getAppData LOCmarkNode 428) as float) catch (0.0)
        if LOCoverrideState >= 0.0 then (DYNFUNapplyShift LOCmarkNode rootNode.DYNrootNodeStore.markVshift SPDYNmarkShift.value)
      )
    )

    --- Update All Road Marking Symbols (VSPobjCat 4)
    for i = 1 to DYNobjHandles[4].count do
    (
      local LOCmarkNode = maxOps.getNodeByHandle DYNobjHandles[4][i]
      local LOCcontroller = LOCmarkNode.transform.controller
      if classof LOCmarkNode == VSP_Symb then
      (
        LOCcontroller.vOffset = LOCcontroller.vOffset + (SPDYNmarkShift.value - rootNode.DYNrootNodeStore.markVshift)
        DYNFUNmaxBakingControl #(LOCmarkNode) true
        if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCmarkNode) false
      )
    )

    --- Update Global Variable - LAST!!
    rootNode.DYNrootNodeStore.markVshift = SPDYNmarkShift.value
  )

  on CKPREmarkFreeze changed arg do
  (
    rootNode.DYNrootNodeStore.markFreeze = arg
    for i = 1 to DYNobjHandles[10].count do (maxOps.getNodeByHandle DYNobjHandles[10][i]).isFrozen = arg
  )
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQADsUrJC8UChJKthLqrXNUxtKgcD5ZNUbBA
-- s3LDJoAnbFuXXiM9nNritVyQAlSv0d0hk/W62WTp4IPaEbOW/DAbEQc+Rda5Afoj
-- j+xhwxjI0u8OZkBFNXNrMP8tZGufZ2UgeMtN5apmzJVcw7OAwhjRTDcj6mgkXK1C
-- mON6bs1tbqB7V8Z45Thtg47+3oktmyH9VqhsDbbcyyis7bEeCSoNW5+ZBlYig3PK
-- gw9dU2cKuOM+wIK0GnBTOEvaEp4udQDmkknHchcZgnGHw25COy1DjBZ3H59XdN/S
-- G3qRH+p1PL5P0NMNYhGXrBiyFPeuJfFJ5KNBWAC/tWTG+/W+2LVl
-- -----END-SIGNATURE-----