--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNstdLight ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj
  local LOCshadowList    = #(shadowMap, raytraceShadow)
  local LOCshadowCreate  = #(shadowMap(), raytraceShadow())

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNdisableConeControls =
  (
    DYNstdLight.CKDYNshowCone.enabled  = false
    DYNstdLight.CKDYNoverShoot.enabled = false
    DYNstdLight.LBDYNhotspot.enabled   = false
    DYNstdLight.LBDYNfalloff.enabled   = false
    DYNstdLight.LBDYNaspect.enabled    = false
    DYNstdLight.SPDYNhotspot.enabled   = false
    DYNstdLight.SPDYNfalloff.enabled   = false
    DYNstdLight.SPDYNaspect.enabled    = false
    DYNstdLight.DDDYNconeShape.enabled = false
  )

  fn DYNFUNlightParams FUNlight =
  (
    DYNstdLight.LOCobj                    = FUNlight
    DYNstdLight.LBDYNlightName.text       = FUNlight.name

    if classOf FUNlight != IES_Sun then
    (
      DYNstdLight.LBDYNtype.text            = DYNuiResourcesLabels[209] + "  " + (DYNFUNupperCase (FUNLight.type as string) 1)
    )
    else
    (
      DYNstdLight.LBDYNtype.text            = DYNuiResourcesLabels[209] + "  " + DYNuiResourcesLabels[210]
    )

    DYNstdLight.CKDYNlightOn.checked      = FUNlight.enabled
    DYNstdLight.CODYNcolor.color          = FUNlight.rgb
    if classOf FUNlight != IES_Sun then
    (
      DYNstdLight.SPDYNlightMult.range      = [-10000,10000,FUNlight.multiplier]
    )
    else
    (
      DYNstdLight.SPDYNlightMult.range      = [0,1000000,FUNlight.multiplier]
    )

    --- If Light Has Cone, then...
    if classof FUNlight == freeSpot or classOf FUNlight == Directionallight or classOf FUNlight == TargetDirectionallight or classOf FUNlight == targetSpot then
    (
      DYNstdLight.CKDYNshowCone.checked     = FUNlight.showCone  ; DYNstdLight.CKDYNshowCone.enabled  = true
      DYNstdLight.CKDYNoverShoot.checked    = FUNlight.overShoot ; DYNstdLight.CKDYNoverShoot.enabled = true
      DYNstdLight.SPDYNaspect.value         = FUNlight.aspect    ; DYNstdLight.SPDYNaspect.enabled    = true; DYNstdLight.LBDYNaspect.enabled    = true
      DYNstdLight.SPDYNfalloff.value        = FUNlight.falloff   ; DYNstdLight.SPDYNfalloff.enabled   = true; DYNstdLight.LBDYNfalloff.enabled   = true
      DYNstdLight.SPDYNhotspot.value        = FUNlight.hotspot   ; DYNstdLight.SPDYNhotspot.enabled   = true; DYNstdLight.LBDYNhotspot.enabled   = true
      DYNstdLight.DDDYNconeShape.selection  = FUNlight.coneShape ; DYNstdLight.DDDYNconeShape.enabled = true
      DYNstdLight.LBDYNaspect.enabled = DYNstdLight.SPDYNaspect.enabled = if FUNlight.coneShape == 1 then false else true
      if classof FUNlight == freeSpot or classOf FUNlight == targetSpot then
      (
        DYNstdLight.SPDYNfalloff.range.y = 179.5
        DYNstdLight.SPDYNhotspot.range.y = 179.5
      )
      else
      (
        DYNstdLight.SPDYNfalloff.range.y = 10000000
        DYNstdLight.SPDYNhotspot.range.y = 10000000
      )
    )
    else
    (
      DYNstdLight.CKDYNshowCone.checked     = false  ; DYNstdLight.CKDYNshowCone.enabled  = false
      DYNstdLight.CKDYNoverShoot.checked    = false  ; DYNstdLight.CKDYNoverShoot.enabled = false
      DYNstdLight.SPDYNaspect.value         = 1.0    ; DYNstdLight.SPDYNaspect.enabled    = false; DYNstdLight.LBDYNaspect.enabled    = false
      DYNstdLight.SPDYNfalloff.value        = 0.0    ; DYNstdLight.SPDYNfalloff.enabled   = false; DYNstdLight.LBDYNfalloff.enabled   = false
      DYNstdLight.SPDYNhotspot.value        = 0.0    ; DYNstdLight.SPDYNhotspot.enabled   = false; DYNstdLight.LBDYNhotspot.enabled   = false
      DYNstdLight.DDDYNconeShape.selection  = 0      ; DYNstdLight.DDDYNconeShape.enabled = false
    )

    --- Check whether other instances exist
    DYNFUNgatherInstancesOfNode DYNstdLight FUNlight

    --- Shadow Parametees
    DYNstdLight.DYNFUNupdateShadowParams FUNlight
  )

  fn DYNFUNupdateShadowParams FUNlight =
  (
    --- Shadow Parametees
    DYNstdLight.CKDYNshadowOn.checked     = FUNlight.baseObject.castShadows
    DYNstdLight.DDDYNshadowType.selection = findItem LOCshadowList (classOf FUNLight.shadowGenerator)

    if classOf FUNlight.shadowGenerator == shadowMap then
    (
      DYNstdLight.SPDYNmapSize.range      = [1,10000,FUNlight.shadowGenerator.mapSize]; DYNstdLight.SPDYNmapSize.enabled   = true
      DYNstdLight.SPDYNmapBias.range      = [0,10000,FUNlight.shadowGenerator.mapBias]; DYNstdLight.SPDYNmapBias.enabled   = true
      DYNstdLight.SPDYNsampRange.range    = [0.01,50.0,FUNlight.shadowGenerator.SampleRange]; DYNstdLight.SPDYNsampRange.enabled = true
      DYNstdLight.CKDYNabsolute.checked   = FUNlight.shadowGenerator.absoluteMapBias; DYNstdLight.CKDYNabsolute.enabled  = true
      DYNstdLight.LBDYNmapSize.enabled    = true
      DYNstdLight.LBDYNmapBias.enabled    = true
      DYNstdLight.LBDYNsampRange.enabled  = true
      DYNstdLight.LBDYNmapSize.text       = DYNuiResourcesLabels[211]
      DYNstdLight.LBDYNmapBias.text       = DYNuiResourcesLabels[212]
      DYNstdLight.CKDYNabsolute.enabled   = true
      DYNstdLight.LBDYNshadMult.enabled   = true
      DYNstdLight.SPDYNshadMult.enabled   = true; DYNstdLight.SPDYNshadMult.value       = FUNLight.shadowMultiplier
      DYNstdLight.LBDYNshadMult.enabled   = true
      DYNstdLight.DDDYNshadowType.enabled = true
    )
    if classOf FUNlight.shadowGenerator == rayTraceShadow then
    (
      DYNstdLight.SPDYNmapSize.range      = [1,10,FUNlight.shadowGenerator.maxDepth]; DYNstdLight.SPDYNmapSize.enabled   = true
      DYNstdLight.SPDYNmapBias.range      = [0,10000,FUNlight.shadowGenerator.rayTraceBias]; DYNstdLight.SPDYNmapBias.enabled   = true
      DYNstdLight.SPDYNsampRange.enabled  = false
      DYNstdLight.CKDYNabsolute.enabled   = false
      DYNstdLight.LBDYNmapSize.enabled    = true
      DYNstdLight.LBDYNmapSize.text       = DYNuiResourcesLabels[213]
      DYNstdLight.LBDYNmapBias.text       = DYNuiResourcesLabels[133]
      DYNstdLight.LBDYNmapBias.enabled    = true
      DYNstdLight.LBDYNsampRange.enabled  = false
      DYNstdLight.CKDYNabsolute.enabled   = false
      DYNstdLight.SPDYNshadMult.enabled   = true
      DYNstdLight.SPDYNshadMult.enabled   = true; DYNstdLight.SPDYNshadMult.value       = FUNLight.shadowMultiplier
      DYNstdLight.LBDYNshadMult.enabled   = true
      DYNstdLight.DDDYNshadowType.enabled = true
    )
    if DYNstdLight.DDDYNshadowType.selection == 0 or not FUNlight.baseObject.castShadows then
    (
      DYNstdLight.SPDYNmapSize.enabled    = false
      DYNstdLight.SPDYNmapBias.enabled    = false
      DYNstdLight.SPDYNsampRange.enabled  = false
      DYNstdLight.CKDYNabsolute.enabled   = false
      DYNstdLight.LBDYNmapSize.enabled    = false
      DYNstdLight.LBDYNmapBias.enabled    = false
      DYNstdLight.LBDYNsampRange.enabled  = false
      DYNstdLight.LBDYNmapSize.text       = DYNuiResourcesLabels[211]
      DYNstdLight.LBDYNmapBias.text       = DYNuiResourcesLabels[212]

      DYNstdLight.CKDYNabsolute.enabled   = false
      DYNstdLight.LBDYNshadMult.enabled   = false
      DYNstdLight.SPDYNshadMult.enabled   = false
      DYNstdLight.LBDYNshadMult.enabled   = false
      DYNstdLight.DDDYNshadowType.enabled = false
    )

    if FUNlight.baseObject.castShadows then DYNstdLight.DDDYNshadowType.enabled = true
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  label LBDYNlightName align:#center
  groupbox GBDYNgroup01 pos:[4,24] width:(DYNiniExplorerWidth - 21) height:86
  checkbox CKDYNlightOn align:#left pos:[13,45] width:50
  label LBDYNlightMult width:50 pos:[65,46]
  spinner SPDYNlightMult "" align:#right fieldwidth:60 range:[-10000,10000,1.0] type:#float pos:[(DYNiniExplorerWidth - 96),46]
  label LBDYNcolor align:#left pos:[13,66]
  colorPicker CODYNcolor width:72 pos:[(DYNiniExplorerWidth - 98),66] height:16
  label LBDYNtype align:#left pos:[13,89]

  groupbox GBDYNgroup02 pos:[4,116] width:(DYNiniExplorerWidth - 21) height:128
  checkbox CKDYNshowCone pos:[13,134] align:#left width:87
  checkbox CKDYNoverShoot pos:[100,134] align:#left width:75
  label LBDYNhotspot align:#left pos:[13,154]
  label LBDYNfalloff align:#left pos:[13,174]
  label LBDYNaspect  align:#left pos:[13,194]
  spinner SPDYNhotspot align:#right fieldwidth:60 type:#float pos:[(DYNiniExplorerWidth - 96),154] range:[0.5,179.5,43.0]
  spinner SPDYNfalloff align:#right fieldwidth:60 type:#float pos:[(DYNiniExplorerWidth - 96),174] range:[0.5,179.5,45.0]
  spinner SPDYNaspect  align:#right fieldwidth:60 type:#float pos:[(DYNiniExplorerWidth - 96),194] range:[0.001,100.0,1.0] scale:0.01
  dropDownList DDDYNconeShape "" pos:[13,214] width:(DYNiniExplorerWidth - 38)

  groupbox GBDYNgroup08  pos:[4,250] width:(DYNiniExplorerWidth - 21) height:173
  checkBox CKDYNshadowOn pos:[13,268] align:#left
  dropDownList DDDYNshadowType "" pos:[13,288] width:(DYNiniExplorerWidth - 38)
  label LBDYNshadMult    align:#left pos:[13,318]
  label LBDYNmapSize     align:#left pos:[13,338]
  label LBDYNmapBias     align:#left pos:[13,358]
  label LBDYNsampRange   align:#left pos:[13,378]
  spinner SPDYNshadMult  align:#right fieldwidth:60 type:#float   pos:[(DYNiniExplorerWidth - 96),318] range:[-10000,10000,1.0] scale:0.01
  spinner SPDYNmapSize   align:#right fieldwidth:60 type:#integer pos:[(DYNiniExplorerWidth - 96),338] range:[0.5,179.5,512]
  spinner SPDYNmapBias   align:#right fieldwidth:60 type:#float   pos:[(DYNiniExplorerWidth - 96),358] range:[0.5,179.5,0.5] scale:0.01
  spinner SPDYNsampRange align:#right fieldwidth:60 type:#float   pos:[(DYNiniExplorerWidth - 96),378] range:[0.001,100.0,4.0] scale:0.1
  checkbox CKDYNabsolute pos:[13,399] align:#left

  groupbox GBDYNgroup06  pos:[4,426]   width:(DYNiniExplorerWidth - 21) height:72
  checkbutton CBDYNlinked pos:[13,445] width:(DYNiniExplorerWidth - 38) highlightColor:DYNINIhighlightColor
  pickbutton PKDYNlink   pos:[13,471]  width:(DYNiniExplorerWidth - 38) highlightColor:DYNINIhighlightColor filter:DYNFUNlightFilter

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNstdLight open do
  (
    DYNstdLight.title      = DYNuiRolloutNames[23]

    GBDYNgroup01.text      = DYNuiResourcesGroups[67]
    GBDYNgroup02.text      = DYNuiResourcesGroups[68]
    GBDYNgroup08.text      = DYNuiResourcesGroups[38]
    GBDYNgroup06.text      = DYNuiResourcesGroups[66]

    DDDYNshadowType.items  = #(DYNuiResourcesLabels[223], DYNuiResourcesLabels[224])
    DDDYNconeShape.items   = #(DYNuiResourcesLabels[225], DYNuiResourcesLabels[226])

    LBDYNlightMult.text    = DYNuiResourcesLabels[131]
    LBDYNcolor.text        = DYNuiResourcesLabels[214]
    LBDYNaspect.text       = DYNuiResourcesLabels[215]
    LBDYNfalloff.text      = DYNuiResourcesLabels[216]
    LBDYNhotspot.text      = DYNuiResourcesLabels[217]
    LBDYNshadMult.text     = DYNuiResourcesLabels[218]
    LBDYNsampRange.text    = DYNuiResourcesLabels[219]

    CKDYNshowCone.text     = DYNuiResourcesLabels[220]
    CKDYNoverShoot.text    = DYNuiResourcesLabels[221]
    CKDYNlightOn.text      = DYNuiResourcesLabels[22]
    CKDYNshadowOn.text     = DYNuiResourcesLabels[20]
    CKDYNabsolute.text     = DYNuiResourcesLabels[222]

    CBDYNlinked.text       = DYNuiResourcesButtons[37]
    PKDYNlink.text         = DYNuiResourcesButtons[24]
  )

  on DYNstdLight close do
  (
  )

  on CKDYNlightOn changed arg do
  (
    LOCobj.enabled = arg
    if DYNLightList.open then
    (
      DYNlightList.DYNFUNupdateLightInstances LOCobj
    )
  )

  on SPDYNlightMult changed arg do LOCobj.multiplier = arg
  on SPDYNlightMult entered do
  (
    if DYNLightList.open then
    (
      DYNlightList.DYNFUNupdateLightInstances LOCobj

      local LOCitem = DYNFUNfindListViewItemByTag DYNlightList.dnLights (LOCobj.inode.handle as string)
      if LOCitem != undefined then LOCitem.SubItems.item[1].text = SPDYNlightMult.value as string
    )
  )

  on CODYNcolor changed arg do LOCobj.rgb = arg

  --- COne Params
  on CKDYNshowCone changed arg   do if classof LOCobj != Omnilight then (LOCobj.showCone  = arg) else (DYNFUNdisableConeControls())
  on CKDYNoverShoot changed arg  do if classof LOCobj != Omnilight then (LOCobj.overShoot = arg) else (DYNFUNdisableConeControls())
  on SPDYNaspect changed arg     do if classof LOCobj != Omnilight then (LOCobj.aspect    = arg) else (DYNFUNdisableConeControls())
  on DDDYNconeShape selected arg do
  (
    if classof LOCobj != Omnilight then
    (
      LOCobj.coneShape = arg
      LBDYNaspect.enabled = SPDYNaspect.enabled = if arg == 1 then false else true
    )
    else
    (
      DYNFUNdisableConeControls()
    )
  )

  on SPDYNfalloff changed arg    do
  (
    if classof LOCobj != Omnilight then
    (
      LOCobj.falloff   = arg
      if (arg - 2) < LOCobj.hotspot then (SPDYNhotspot.value = LOCobj.hotspot = arg - 2)
    )
    else
    (
      DYNFUNdisableConeControls()
    )
  )

  on SPDYNhotspot changed arg    do
  (
    if classof LOCobj != Omnilight then
    (
      LOCobj.hotspot   = arg
      if (arg + 2) > LOCobj.fallOff then (SPDYNfalloff.value = LOCobj.fallOff = arg + 2)
    )
    else
    (
      DYNFUNdisableConeControls()
    )
  )

  on CKDYNshadowOn changed arg do
  (
    LOCobj.baseObject.castShadows = arg
    if DYNLightList.open then
    (
      DYNlightList.DYNFUNupdateLightInstances LOCobj

      local LOCitem = DYNFUNfindListViewItemByTag DYNlightList.dnLights (LOCobj.inode.handle as string)
      if LOCitem != undefined then LOCitem.SubItems.item[2].text = arg as string
    )
    DYNFUNupdateShadowParams LOCobj
  )

  on DDDYNshadowType selected arg do
  (
    LOCobj.shadowGenerator = LOCshadowCreate[arg]
    DYNFUNupdateShadowParams LOCobj
  )

  on SPDYNshadMult changed arg     do LOCobj.shadowMultiplier = arg

  on SPDYNmapSize  changed arg  do
  (
    if classOf LOCobj.shadowGenerator == shadowMap      then LOCobj.shadowGenerator.mapsize = arg
    if classOf LOCobj.shadowGenerator == raytraceShadow then LOCobj.shadowGenerator.maxDepth = arg
  )

  on SPDYNmapBias  changed arg  do
  (
    if classOf LOCobj.shadowGenerator == shadowMap      then LOCobj.shadowGenerator.mapbias = arg
    if classOf LOCobj.shadowGenerator == raytraceShadow then LOCobj.shadowGenerator.rayTraceBias = arg
  )

  on SPDYNsampRange changed arg do LOCobj.shadowGenerator.samplerange = arg
  on CKDYNabsolute changed arg  do LOCobj.shadowGenerator.absoluteMapBias = arg

  on CBDYNlinked changed arg do
  (
    if arg == false then
    (
      LOCobj = DYNFUNunlinkNodeInstance DYNstdLight LOCobj 2 false
      select LOCobj
    )
  )

  on PKDYNlink picked arg do
  (
    if arg != LOCobj then
    (
      LOCobj = DYNFUNunlinkNodeInstance DYNstdLight LOCobj 2 true
      instanceReplace LOCobj arg
      select LOCobj
    )
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCex+THUdKh7D8m4IXQvo6EUctRpoHiZMs0
-- dGd39shaPiNKk/Il/ZOBAuSwFGw1MkPYD4V03URO4EqxQulseP7ml7/ospFvhJ3l
-- IhXVOz+nOSjGTqBy4+4UkOERPJCF17+Z+MLPAekXg2yoSkNJtfs5HLnOuyztdkKk
-- bul/CWQZYs/cuJaJg7rWlKWW4D1bVYy6ct2/3o1SQ0M1Dk4gkec0AgVXJ3Yanwt4
-- jRoOcDMB9/AFd99XhymlUYtwe0RGem//PDfTx8uRkXFrrZGjhtnGj41/aFImahPx
-- 90evW8ymGXzxUM8A5q7fSu5PVOa2uYQRU/o4tz9G75DVQmNutciP
-- -----END-SIGNATURE-----