--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNsplineMapper ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCsurface
  local LOCshapes = #()
  local LOCsurfaceSelectedFaces = #{}
  local LOCrm
  local LOCuvwRollout

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNuvwRollout FUNcaption1 FUNcaption2 FUNcaption3 FUNcaption4 FUNcaption5 FUNuvwValue =
  (
    ExeStr=("rollout LOCuvwRollout \"" + FUNcaption1 + "\"\n")
    ExeStr+=("(\n")
    ExeStr+=(" group \"" + FUNcaption2 + "\"\n")
    ExeStr+=(" (\n")
    ExeStr+=("   spinner SPDYNx \"" + FUNcaption5 + " (x):\" range:[0.1,100000," + (FUNuvwValue.X as string) + "]\n")
    ExeStr+=("   spinner SPDYNy \"" + FUNcaption5 + " (y):\" range:[0.1,100000," + (FUNuvwValue.Y as string) + "]\n")
    ExeStr+=("   spinner SPDYNr \"" + FUNcaption3 + "\" range:[-360.0,360.0," + (FUNuvwValue.Z as string) + "]\n")
    ExeStr+=(" )\n")
    ExeStr+=(" button BUDYNclose \"" + FUNcaption4 + "\" align:#center\n")

    ExeStr+=(" on LOCuvwRollout open do\n")
    ExeStr+=(" (\n")
    ExeStr+=("  modPanel.addModToSelection (UVW_xform())\n")
    ExeStr+=(" )\n")

    ExeStr+=(" on LOCuvwRollout close do\n")
    ExeStr+=(" (\n")
    ExeStr+=("  collapseStack DYNsplineMapper.LOCsurface\n")
    ExeStr+=("  DYNsplineMapper.LOCsurfaceSelectedFaces = DYNsplineMapper.LOCsurface.selectedFaces as bitArray\n")
    ExeStr+=("  subObjectLevel = if classof DYNsplineMapper.LOCsurface == Editable_Poly then 4 else 3\n")
    ExeStr+=(" )\n")

    ExeStr+=(" on SPDYNx changed arg do\n")
    ExeStr+=(" (\n")
    ExeStr+=("   ((CVGetMod DYNsplineMapper.LOCsurface UVW_XForm).U_Tile         = arg)\n")
    ExeStr+=(" )\n")

    ExeStr+=(" on SPDYNy changed arg do\n")
    ExeStr+=(" (\n")
    ExeStr+=("   ((CVGetMod DYNsplineMapper.LOCsurface UVW_XForm).V_Tile         = arg)\n")
    ExeStr+=(" )\n")

    ExeStr+=(" on SPDYNr changed arg do\n")
    ExeStr+=(" (\n")
    ExeStr+=("   ((CVGetMod DYNsplineMapper.LOCsurface UVW_XForm).Rotation_Angle = arg)\n")
    ExeStr+=(" )\n")

    ExeStr+=(" on BUDYNclose pressed do destroyDialog LOCuvwRollout\n")
    ExeStr+=(")\n")
    DYNsplineMapper.LOCuvwRollout = Execute ExeStr
    createDialog DYNsplineMapper.LOCuvwRollout width:200 height:120 modal:true
  )

  fn DYNFUNinitialiseSplineMapper FUNsurface FUNswitch =
  (
    if isValidNode FUNsurface then
    (
      DYNsplineMapper.LOCsurface = FUNsurface; DYNsplineMapper.EDDYNsurface.text = FUNsurface.name

      --- Create Ray Mesh Grid
      DYNsplineMapper.LOCrm = RayMeshGridIntersect()
      DYNsplineMapper.LOCrm.initialize 10
      DYNsplineMapper.LOCrm.addNode FUNsurface
      DYNsplineMapper.LOCrm.buildGrid()
    )
    else
    (
      DYNsplineMapper.LOCsurface = undefined; DYNsplineMapper.EDDYNsurface.text = ""
      DYNsplineMapper.LOCshapes = #()
      DYNsplineMapper.MLDYNobjectList.items = #()
      DYNsplineMapper.LOCsurfaceSelectedFaces = #{}
      FUNswitch = false
      DYNsplineMapper.LOCrm = undefined
    )

    DYNsplineMapper.PKDYNshapes.enabled          = FUNswitch
    DYNsplineMapper.BUDYNshapes.enabled          = FUNswitch
    DYNsplineMapper.BUDYNclear.enabled           = FUNswitch
    DYNsplineMapper.BUDYNchangeMatID.enabled     = FUNswitch
    DYNsplineMapper.BUDYNsplineMapping.enabled   = FUNswitch
    DYNsplineMapper.BUDYNresample.enabled        = FUNswitch
    DYNsplineMapper.BUDYNadjustTiling.enabled    = FUNswitch
    DYNsplineMapper.BUDYNrestrictToID.enabled = FUNswitch
  )

  fn DYNFUNselectFaces FUNmesh FUNshape FUNshapeStepDist =
  (
    local LOCbitArray = #{}; LOCbitArray.count = FUNmesh.faces.count; for i = 1 to LOCbitArray.count do LOCbitArray[i] = DYNsplineMapper.LOCsurfaceSelectedFaces[i]

    --- Remove Existing Modifiers From Selected Mesh
    if FUNmesh.modifiers.count > 0 then collapseStack FUNmesh

    --- Nominate Shape
    local LOCnumSplines = numSplines FUNshape
    for a = 1 to LOCnumSplines do
    (
      local LOClength = curveLength FUNshape a
      local LOCcnt    = LOClength / FUNshapeStepDist

      for i = 1 to LOCcnt do
      (
        DYNsplineMapper.dnProgress.value = ((i as float) / LOCcnt * 100.0)
        local LOCinterp = (1.0 / LOCcnt) * i ; if LOCinterp > 1.0 then LOCinterp = 1.0
        local LOCxyz = lengthInterp FUNshape a LOCinterp

        local LOChitsCount = DYNsplineMapper.LOCrm.intersectray [LOCxyz.x,LOCxyz.y,999] [0,0,-1] true
        if LOChitsCount > 0 then
        (
          local LOCfaceHit = DYNsplineMapper.LOCrm.getHitFace 1
          LOCbitArray[LOCfaceHit] = true
        )
      )
    )

    DYNsplineMapper.dnProgress.value = 0

    --- Select Faces and Enter Face Sub-Object Mode
    max Modify Mode
    select FUNmesh
    FUNmesh.selectedFaces = LOCbitArray
    subObjectLevel = if classof FUNmesh == Editable_Poly then 4 else 3

    LOCbitArray
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupBox GBDYNgroup01        pos:[11,7]    width:258 height:75
  pickbutton PKDYNsurface      pos:[20,27]   width:239 filter:DYNFUNgeometryFilter
  edittext EDDYNsurface ""     pos:[20,52]   width:239

  groupBox GBDYNgroup02        pos:[11,90]   width:258 height:265
  multilistBox MLDYNobjectList pos:[20,107]  width:239 height:8

  spinner SPDYNdivide ""       pos:[187,224] type:#float scale:0.01 range:[0.01,1000.0,0.5] fieldwidth:60

  label LBDYNdivide            pos:[20,224]  width:150
  pickbutton PKDYNshapes       pos:[20,249]  width:239 filter:DYNFUNsplineShapeFilter
  button BUDYNshapes           pos:[20,274]  width:239
  button BUDYNresample         pos:[20,299]  width:239
  button BUDYNclear            pos:[20,324]  width:239

  groupBox GBDYNgroup03        pos:[11,363]  width:258 height:56
  button BUDYNrestrictToID     pos:[20,386]  width:239

  groupBox GBDYNgroup04        pos:[11,427]  width:258 height:103
  button BUDYNchangeMatID      pos:[20,450]  width:239
  button BUDYNsplineMapping    pos:[20,474]  width:239
  button BUDYNadjustTiling     pos:[20,498]  width:239

  button BUDYNokok             pos:[11,548]  width:72  height:22
  button BUDYNapply            pos:[197,548] width:72  height:22

  dotNetControl  dnProgress "System.Windows.Forms.ProgressBar" pos:[11,578] width:258 height:12

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNsplineMapper open do
  (
    DYNsplineMapper.title   = DYNuiRolloutNames[34]

    GBDYNgroup01.text       = DYNuiResourcesGroups[100]
    GBDYNgroup02.text       = DYNuiResourcesGroups[95]
    GBDYNgroup03.text       = DYNuiResourcesGroups[96]
    GBDYNgroup04.text       = DYNuiResourcesGroups[97]

    LBDYNdivide.text        = DYNuiResourcesLabels[328]

    BUDYNokok.text          = DYNuiResourcesButtons[1]
    BUDYNapply.text         = DYNuiResourcesButtons[13]
    PKDYNsurface.text       = DYNuiResourcesButtons[63]
    PKDYNshapes.text        = DYNuiResourcesButtons[64]
    BUDYNshapes.text        = DYNuiResourcesButtons[65]
    BUDYNresample.text      = DYNuiResourcesButtons[66]
    BUDYNclear.text         = DYNuiResourcesButtons[67]
    BUDYNrestrictToID.text  = DYNuiResourcesButtons[68]
    BUDYNchangeMatID.text   = DYNuiResourcesButtons[69]
    BUDYNsplineMapping.text = DYNuiResourcesButtons[70]
    BUDYNadjustTiling.text  = DYNuiResourcesButtons[71]

    EDDYNsurface.readOnly   = true
  )

  on DYNsplineMapper close do
  (
    if LOCrm != undefined then LOCrm.free()
    LOCrm = undefined
    subObjectLevel = 0
    if isValidNode LOCsurface then deselect LOCsurface.faces
    DYNFUNonDialogClose()
  )

  on BUDYNresample pressed do
  (
    if DYNsplineMapper.MLDYNobjectList.selection.numberSet > 0 then
    (
      for i = 1 to LOCshapes.count do
      (
        if DYNsplineMapper.MLDYNobjectList.selection[i] then
        (
          LOCsurfaceSelectedFaces = DYNFUNselectFaces LOCsurface LOCshapes[i] SPDYNdivide.value
        )
      )
    )
    else
    (
      messagebox (DYNuiResourcesErrorsWarnings[40]) title:DYNuiResourcesTitlebars[3]
    )
  )

  on BUDYNclear pressed do
  (
    MLDYNobjectList.items = LOCshapes = #()
    LOCsurfaceSelectedFaces = LOCsurface.selectedFaces = #{}
    subObjectLevel = 0
  )

  on BUDYNchangeMatID pressed do
  (
    if isValidNode LOCsurface then
    (
      if classOf LOCsurface.material == Multimaterial then
      (
        LOCsurfaceSelectedFaces = LOCsurface.selectedFaces as bitArray
        local LOCnewMatID   = DYNFUNdisplayCivilViewSurfacesListBox DYNuiResourcesTitlebars[15] DYNuiResourcesLabels[162] LOCsurface.material 1

        --- Change selected faces to new material ID
        if classOf LOCnewMatID == Integer then
        (
          DYNFUNchangeMatIDforSubObj LOCsurface 0 LOCnewMatID LOCsurfaceSelectedFaces
          LOCsurface.selectedFaces = LOCsurfaceSelectedFaces
          subObjectLevel = if classof LOCsurface == Editable_Poly then 4 else 3
        )
      )
      else
      (
        messagebox (DYNuiResourcesErrorsWarnings[41]) title:DYNuiResourcesTitlebars[1]
      )
    )
  )

  on BUDYNrestrictToID pressed do
  (
    if classOf LOCsurface.material == Multimaterial then
    (
      local LOCnewMatID   = DYNFUNdisplayCivilViewSurfacesListBox DYNuiResourcesTitlebars[15] DYNuiResourcesLabels[162] LOCsurface.material 1
      if classOf LOCnewMatID == Integer then
      (
        for i = 1 to LOCsurface.faces.count do
        (
          if getfaceMatID LOCsurface i != LOCnewMatID then LOCsurfaceSelectedFaces[i] = false
        )
        LOCsurface.selectedFaces = LOCsurfaceSelectedFaces
        subObjectLevel = if classof LOCsurface == Editable_Poly then 4 else 3
      )
    )
    else
    (
      messagebox (DYNuiResourcesErrorsWarnings[41]) title:DYNuiResourcesTitlebars[1]
    )

  )

  on BUDYNsplineMapping pressed do
  (
    if isValidNode LOCsurface then
    (
      local LOCproceed = true
      if LOCshapes.count > 1 then
      (
        LOCproceed = querybox (DYNuiResourcesErrorsWarnings[42]) title:DYNuiResourcesTitlebars[3]
      )

      if LOCproceed then
      (
        LOCsurfaceSelectedFaces = LOCsurface.selectedFaces as bitArray

        local LOCcnt1 = 0
        for i in LOCshapes do
        (
          LOCcnt1 += 1
          dnProgress.value = ((LOCcnt1 as float) / LOCshapes.count * 100.0)

          --- Appply UVW_UnWrap Modifier
          modPanel.addModToSelection (unwrap_UVW())
          (CVGetMod LOCsurface Unwrap_UVW).splinemap_node = i
          (CVGetMod LOCsurface Unwrap_UVW).splinemap_projectiontype = 1

          --- Apply UVW_XForm Modifier
          modPanel.addModToSelection (UVW_xform())
          (CVGetMod LOCsurface UVW_Xform).rotation_Angle  = 90.0
          (CVGetMod LOCsurface UVW_Xform).U_Tile          = (curveLength i 1) / 10.0
          (CVGetMod LOCsurface UVW_Xform).V_Tile          = 2.0

          collapseStack LOCsurface
        )

        dnProgress.value = 0

        --- Collapse to Mesh
        LOCsurface.selectedFaces = LOCsurfaceSelectedFaces
        subObjectLevel = if classof LOCsurface == Editable_Poly then 4 else 3
      )
    )
  )

  on BUDYNadjustTiling pressed do
  (
    if isValidNode LOCsurface then
    (
      LOCsurfaceSelectedFaces = LOCsurface.selectedFaces as bitArray
      DYNFUNuvwRollout DYNuiResourcesTitlebars[17] DYNuiResourcesGroups[44] DYNuiResourcesLabels[177] DYNuiResourcesButtons[1] DYNuiResourcesLabels[165] [1.0, 1.0, 0.0]
      LOCsurface.selectedFaces = LOCsurfaceSelectedFaces
    )
  )

  on BUDYNshapes pressed do
  (
    local LOCselArray = selectByName title:DYNuiResourcesTitlebars[29] buttonText:DYNuiResourcesButtons[72] filter:DYNFUNsplineShapeFilter showHidden:false single:false

    if LOCselArray != undefined then
    (
      for i in LOCselArray do
      (
        if isValidNode i then
        (
          LOCsurfaceSelectedFaces = DYNFUNselectFaces LOCsurface i SPDYNdivide.value
          append LOCshapes i
        )
      )

      local LOCshapeNames = #()
      if LOCshapes.count > 0 then
      (
        for i in LOCshapes do
        (
          append LOCshapeNames i.name
        )
        MLDYNobjectList.items = LOCshapeNames
      )
    )
  )

  on PKDYNshapes picked arg do
  (
    if isValidNode arg then
    (
      LOCsurfaceSelectedFaces = DYNFUNselectFaces LOCsurface arg SPDYNdivide.value

      append LOCshapes arg
      local LOCshapeNames = #()
      for i in LOCshapes do
      (
        append LOCshapeNames i.name
      )
      MLDYNobjectList.items = LOCshapeNames
    )
  )

  on PKDYNsurface picked arg do
  (
    DYNFUNinitialiseSplineMapper arg true
  )

  on BUDYNokok  pressed do (destroyDialog DYNsplineMapper)
  on BUDYNapply pressed do
  (
    DYNFUNinitialiseSplineMapper undefined false
    subObjectLevel = 0
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAOuQGWh/j2k/mvM/FnCoovO58rbGHUJ16w
-- IT91ek6na4zsXlyfdSRYJTg4TrFRTRcsWcMkBe/60ebZn++y2Blz6lL4PsUJ8U9v
-- BQiOtZNekg3FUZHRJgU4uwNHPCvSDnO2gqPJlchX3t9XSuWrTgXs9xKUH0aOogKW
-- feqqJFda3c7n8b+pSYXFya6bHjZXUno882pn4JAa+4ges8Psj97tUyahV7rd/oD2
-- E85pMmk0SujBXyMiw6eGg5iE9TnLKHTNI8Qn6EvI292MUfJ6ed+nPszCPuVVhwK2
-- 29ILi6REny2mHV1gkvgWGtSgUK+lqOKSK1lfaziihWsGB+wl2HSa
-- -----END-SIGNATURE-----