--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNPrimitiveParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj
  local LOCspinStartValue
  local LOCundoState = on

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNvspPrimitiveFilter FUNobj =
  (
    classOf FUNobj.baseObject == box       or \
    classOf FUNobj.baseObject == cylinder  or \
    classOf FUNobj.baseObject == pyramid   or \
    classOf FUNobj.baseObject == sphere    or \
    classOf FUNobj.baseObject == teapot    or \
    classOf FUNobj.baseObject == geosphere or \
    classOf FUNobj.baseObject == plane
  )

  fn DYNFUNPrimitiveParams FUNobj =
  (
    DYNPrimitiveParams.LOCobj               = FUNobj

    if (try (FUNobj.baseObject.width) catch ()) != undefined then
    (
      DYNPrimitiveParams.SPDYNwidth.enabled    = true
      DYNPrimitiveParams.SPDYNwidth.value      = FUNobj.baseObject.width
    )
    else
    (
      DYNPrimitiveParams.SPDYNwidth.enabled    = false
      DYNPrimitiveParams.SPDYNwidth.value      = 0
    )
    if (try (FUNobj.baseObject.length) catch ()) != undefined then
    (
      DYNPrimitiveParams.SPDYNlength.enabled   = true
      DYNPrimitiveParams.SPDYNlength.value     = FUNobj.baseObject.length
    )
    else
    (
      DYNPrimitiveParams.SPDYNlength.enabled   = false
      DYNPrimitiveParams.SPDYNlength.value     = 0
    )
    if (try (FUNobj.baseObject.height) catch ()) != undefined then
    (
      DYNPrimitiveParams.SPDYNheight.enabled   = true
      DYNPrimitiveParams.SPDYNheight.value     = FUNobj.baseObject.height
    )
    else
    (
      DYNPrimitiveParams.SPDYNheight.enabled   = false
      DYNPrimitiveParams.SPDYNheight.value     = 0
    )
    if (try (FUNobj.baseObject.depth) catch ()) != undefined then
    (
      DYNPrimitiveParams.SPDYNdepth.enabled    = true
      DYNPrimitiveParams.SPDYNdepth.value      = FUNobj.baseObject.depth
    )
    else
    (
      DYNPrimitiveParams.SPDYNdepth.enabled    = false
      DYNPrimitiveParams.SPDYNdepth.value      = 0
    )
    if (try (FUNobj.baseObject.radius) catch ()) != undefined then
    (
      DYNPrimitiveParams.SPDYNradius.enabled   = true
      DYNPrimitiveParams.SPDYNradius.value     = FUNobj.baseObject.radius
    )
    else
    (
      DYNPrimitiveParams.SPDYNradius.enabled   = false
      DYNPrimitiveParams.SPDYNradius.value     = 0
    )

    if (try (FUNobj.baseObject.segments) catch ()) != undefined then
    (
      DYNPrimitiveParams.SPDYNsegments.enabled = true
      DYNPrimitiveParams.SPDYNsegments.value   = FUNobj.baseObject.segments
    )
    else
    (
      DYNPrimitiveParams.SPDYNsegments.enabled = false
      DYNPrimitiveParams.SPDYNsegments.value   = 0
    )
    if (try (FUNobj.baseObject.widthSegs) catch ()) != undefined then
    (
      DYNPrimitiveParams.SPDYNwidthSegs.enabled= true
      DYNPrimitiveParams.SPDYNwidthSegs.value  = FUNobj.baseObject.widthSegs
    )
    else
    (
      DYNPrimitiveParams.SPDYNwidthSegs.enabled= false
      DYNPrimitiveParams.SPDYNwidthSegs.value  = 0
    )

    if (try (FUNobj.baseObject.lengthSegs) catch ()) != undefined then
    (
      DYNPrimitiveParams.SPDYNlengthSegs.enabled= true
      DYNPrimitiveParams.SPDYNlengthSegs.value = FUNobj.baseObject.lengthSegs
    )
    else
    (
      DYNPrimitiveParams.SPDYNlengthSegs.enabled= false
      DYNPrimitiveParams.SPDYNlengthSegs.value  = 0
    )
    if (try (FUNobj.baseObject.heightSegs) catch ()) != undefined then
    (
      DYNPrimitiveParams.SPDYNheightSegs.enabled= true
      DYNPrimitiveParams.SPDYNheightSegs.value  = FUNobj.baseObject.heightSegs
    )
    else
    (
      DYNPrimitiveParams.SPDYNheightSegs.enabled= false
      DYNPrimitiveParams.SPDYNheightSegs.value  = 0
    )
    if (try (FUNobj.baseObject.depthSegs) catch ()) != undefined then
    (
      DYNPrimitiveParams.SPDYNdepthSegs.enabled = true
      DYNPrimitiveParams.SPDYNdepthSegs.value   = FUNobj.baseObject.depthSegs
    )
    else
    (
      DYNPrimitiveParams.SPDYNdepthSegs.enabled = false
      DYNPrimitiveParams.SPDYNdepthSegs.value   = 0
    )

    local LOCmatNames = DYNFUNgetMatChannelNames FUNobj.material true true DYNINImatIDlimit
    DYNPrimitiveParams.DDDYNmat.items = LOCmatNames

    if (try (FUNobj.modifiers[DYNmatModName]) catch ()) != undefined then
    (
      local LOCmatID = FUNobj.modifiers[DYNmatModName].materialID
      if LOCmatID > DYNPrimitiveParams.DDDYNmat.items.count then
      (
        DYNPrimitiveParams.DDDYNmat.enabled   = false
        DYNPrimitiveParams.DDDYNmat.selection = 0
      )
      else
      (
        DYNPrimitiveParams.DDDYNmat.enabled   = true
        DYNPrimitiveParams.DDDYNmat.selection = LOCmatID
      )
    )
    else
    (
      DYNPrimitiveParams.DDDYNmat.enabled   = false
      DYNPrimitiveParams.DDDYNmat.selection = 0
    )

    --- Check whether other instances exist
    DYNFUNgatherInstancesOfNode DYNprimitiveParams FUNobj

  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupbox GBDYN01 width:(DYNiniExplorerWidth - 21) height:47  pos:[4,7]
  dropdownlist DDDYNmat "" pos:[13,26] width:(DYNiniExplorerWidth - 39)

  groupbox GBDYN02 width:(DYNiniExplorerWidth - 21) height:125 pos:[4,59]
  label LBDYNlength width:105 pos:[13,78]
  label LBDYNwidth  width:105 pos:[13,99]
  label LBDYNheight width:105 pos:[13,120]
  label LBDYNdepth  width:105 pos:[13,141]
  label LBDYNradius width:105 pos:[13,162]
  spinner SPDYNlength "" fieldwidth:60 type:#worldunits range:[0,999999,0] scale:0.1 pos:[(DYNiniExplorerWidth - 96),78]
  spinner SPDYNwidth  "" fieldwidth:60 type:#worldunits range:[0,999999,0] scale:0.1 pos:[(DYNiniExplorerWidth - 96),99]
  spinner SPDYNheight "" fieldwidth:60 type:#worldunits range:[-999999,999999,0] scale:0.1 pos:[(DYNiniExplorerWidth - 96),120]
  spinner SPDYNdepth  "" fieldwidth:60 type:#worldunits range:[0,999999,0] scale:0.1 pos:[(DYNiniExplorerWidth - 96),141]
  spinner SPDYNradius "" fieldwidth:60 type:#worldunits range:[0,999999,0] scale:0.1 pos:[(DYNiniExplorerWidth - 96),162]

  groupbox GBDYN03 width:(DYNiniExplorerWidth - 21) height:125 pos:[4,189]
  label LBDYNsegments   width:105 pos:[13,208]
  label LBDYNheightSegs width:105 pos:[13,229]
  label LBDYNwidthSegs  width:105 pos:[13,250]
  label LBDYNlengthSegs width:105 pos:[13,271]
  label LBDYNdepthSegs  width:105 pos:[13,292]
  spinner  SPDYNsegments   "" fieldwidth:60 type:#integer range:[4,200,12] pos:[(DYNiniExplorerWidth - 96),208]
  spinner  SPDYNheightSegs "" fieldwidth:60 type:#integer range:[1,200,1]  pos:[(DYNiniExplorerWidth - 96),229]
  spinner  SPDYNwidthSegs  "" fieldwidth:60 type:#integer range:[1,200,1]  pos:[(DYNiniExplorerWidth - 96),250]
  spinner  SPDYNlengthSegs "" fieldwidth:60 type:#integer range:[1,200,1]  pos:[(DYNiniExplorerWidth - 96),271]
  spinner  SPDYNdepthSegs  "" fieldwidth:60 type:#integer range:[1,200,1]  pos:[(DYNiniExplorerWidth - 96),292]

  groupbox GBDYN04 width:(DYNiniExplorerWidth - 21) height:72  pos:[4,319]
  checkbutton CBDYNlinked width:(DYNiniExplorerWidth - 39) highlightColor:DYNINIhighlightColor pos:[13,338]
  pickbutton PKDYNlink    width:(DYNiniExplorerWidth - 39) highlightColor:DYNINIhighlightColor pos:[13,364] filter:DYNFUNvspPrimitiveFilter

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNPrimitiveParams open do
  (
    DYNPrimitiveParams.title = DYNuiRolloutNames[6]

    GBDYN01.text         = DYNuiResourcesGroups[52]
    GBDYN02.text         = DYNuiResourcesGroups[53]
    GBDYN03.text         = DYNuiResourcesGroups[54]
    GBDYN04.text         = DYNuiResourcesGroups[1]
    PKDYNlink.text       = DYNuiResourcesButtons[24]
    LBDYNlength.text     = DYNuiResourcesLabels[28]
    LBDYNwidth.text      = DYNuiResourcesLabels[29]
    LBDYNheight.text     = DYNuiResourcesLabels[30]
    LBDYNdepth.text      = DYNuiResourcesLabels[185]
    LBDYNradius.text     = DYNuiResourcesLabels[186]
    LBDYNsegments.text   = DYNuiResourcesLabels[187]
    LBDYNheightSegs.text = DYNuiResourcesLabels[188]
    LBDYNwidthSegs.text  = DYNuiResourcesLabels[189]
    LBDYNlengthSegs.text = DYNuiResourcesLabels[190]
    LBDYNdepthSegs.text  = DYNuiResourcesLabels[191]
  )

  on DYNPrimitiveParams close do
  (
    LOCobj = undefined
  )

  --- Width Spinner Controls
  on SPDYNwidth      changed arg do LOCobj.baseObject.width      = arg
  on SPDYNwidth changed arg do (with undo label:(DYNuiResourcesUndoLabels[11]) LOCundoState LOCobj.baseObject.width = arg)
  on SPDYNwidth buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNwidth.value)  -- store current spinner value
  on SPDYNwidth buttonUp    do
  (
    if LOCspinStartValue != SPDYNwidth.value then -- don't apply value if spinner value hasn't changed between buttonDown' and 'buttonUp' events
    (
      with undo off LOCobj.baseObject.width = LOCspinStartValue -- set to original spinner value with undo disabled
      with undo label:(DYNuiResourcesUndoLabels[11]) on LOCobj.baseObject.width = SPDYNwidth.value -- set to current value with undo enabled
    )
    LOCundoState    = on -- turn undo back on
  )


  --- Length Spinner Controls
  on SPDYNlength     changed arg do LOCobj.baseObject.length     = arg
  on SPDYNlength changed arg do (with undo label:(DYNuiResourcesUndoLabels[11]) LOCundoState LOCobj.baseObject.length = arg)
  on SPDYNlength buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNlength.value)  -- store current spinner value
  on SPDYNlength buttonUp    do
  (
    if LOCspinStartValue != SPDYNlength.value then -- don't apply value if spinner value hasn't changed between buttonDown' and 'buttonUp' events
    (
      with undo off LOCobj.baseObject.length = LOCspinStartValue -- set to original spinner value with undo disabled
      with undo label:(DYNuiResourcesUndoLabels[11]) on LOCobj.baseObject.length = SPDYNlength.value -- set to current value with undo enabled
    )
    LOCundoState    = on -- turn undo back on
  )

  --- Height Spinner Controls
  on SPDYNheight     changed arg do LOCobj.baseObject.height     = arg
  on SPDYNheight changed arg do (with undo label:(DYNuiResourcesUndoLabels[11]) LOCundoState LOCobj.baseObject.height = arg)
  on SPDYNheight buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNheight.value)  -- store current spinner value
  on SPDYNheight buttonUp    do
  (
    if LOCspinStartValue != SPDYNheight.value then -- don't apply value if spinner value hasn't changed between buttonDown' and 'buttonUp' events
    (
      with undo off LOCobj.baseObject.height = LOCspinStartValue -- set to original spinner value with undo disabled
      with undo label:(DYNuiResourcesUndoLabels[11]) on LOCobj.baseObject.height = SPDYNheight.value -- set to current value with undo enabled
    )
    LOCundoState    = on -- turn undo back on
  )

  --- Depth Spinner Controls
  on SPDYNdepth      changed arg do LOCobj.baseObject.depth      = arg
  on SPDYNdepth changed arg do (with undo label:(DYNuiResourcesUndoLabels[11]) LOCundoState LOCobj.baseObject.depth = arg)
  on SPDYNdepth buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNdepth.value)  -- store current spinner value
  on SPDYNdepth buttonUp    do
  (
    if LOCspinStartValue != SPDYNdepth.value then -- don't apply value if spinner value hasn't changed between buttonDown' and 'buttonUp' events
    (
      with undo off LOCobj.baseObject.depth = LOCspinStartValue -- set to original spinner value with undo disabled
      with undo label:(DYNuiResourcesUndoLabels[11]) on LOCobj.baseObject.depth = SPDYNdepth.value -- set to current value with undo enabled
    )
    LOCundoState    = on -- turn undo back on
  )

  --- Radius Spinner Controls
  on SPDYNradius     changed arg do LOCobj.baseObject.radius     = arg
  on SPDYNradius changed arg do (with undo label:(DYNuiResourcesUndoLabels[11]) LOCundoState LOCobj.baseObject.radius = arg)
  on SPDYNradius buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNradius.value)  -- store current spinner value
  on SPDYNradius buttonUp    do
  (
    if LOCspinStartValue != SPDYNradius.value then -- don't apply value if spinner value hasn't changed between buttonDown' and 'buttonUp' events
    (
      with undo off LOCobj.baseObject.radius = LOCspinStartValue -- set to original spinner value with undo disabled
      with undo label:(DYNuiResourcesUndoLabels[11]) on LOCobj.baseObject.radius = SPDYNradius.value -- set to current value with undo enabled
    )
    LOCundoState    = on -- turn undo back on
  )

  --- Segment Spinner Controls
  on SPDYNsegments   changed arg do LOCobj.baseObject.segments   = arg
  on SPDYNsegments changed arg do (with undo label:(DYNuiResourcesUndoLabels[11]) LOCundoState LOCobj.baseObject.segments = arg)
  on SPDYNsegments buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNsegments.value)  -- store current spinner value
  on SPDYNsegments buttonUp    do
  (
    if LOCspinStartValue != SPDYNsegments.value then -- don't apply value if spinner value hasn't changed between buttonDown' and 'buttonUp' events
    (
      with undo off LOCobj.baseObject.segments = LOCspinStartValue -- set to original spinner value with undo disabled
      with undo label:(DYNuiResourcesUndoLabels[11]) on LOCobj.baseObject.segments = SPDYNsegments.value -- set to current value with undo enabled
    )
    LOCundoState    = on -- turn undo back on
  )

  --- Width Seg Spinner Controls
  on SPDYNwidthSegs changed arg do LOCobj.baseObject.widthSegs  = arg
  on SPDYNwidthSegs changed arg do (with undo label:(DYNuiResourcesUndoLabels[11]) LOCundoState LOCobj.baseObject.widthSegs = arg)
  on SPDYNwidthSegs buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNwidthSegs.value)  -- store current spinner value
  on SPDYNwidthSegs buttonUp    do
  (
    if LOCspinStartValue != SPDYNwidthSegs.value then -- don't apply value if spinner value hasn't changed between buttonDown' and 'buttonUp' events
    (
      with undo off LOCobj.baseObject.widthSegs = LOCspinStartValue -- set to original spinner value with undo disabled
      with undo label:(DYNuiResourcesUndoLabels[11]) on LOCobj.baseObject.widthSegs = SPDYNwidthSegs.value -- set to current value with undo enabled
    )
    LOCundoState    = on -- turn undo back on
  )

  --- Length Seg Spinner Controls
  on SPDYNlengthSegs changed arg do LOCobj.baseObject.lengthSegs = arg
  on SPDYNlengthSegs changed arg do (with undo label:(DYNuiResourcesUndoLabels[11]) LOCundoState LOCobj.baseObject.lengthSegs = arg)
  on SPDYNlengthSegs buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNlengthSegs.value)  -- store current spinner value
  on SPDYNlengthSegs buttonUp    do
  (
    if LOCspinStartValue != SPDYNlengthSegs.value then -- don't apply value if spinner value hasn't changed between buttonDown' and 'buttonUp' events
    (
      with undo off LOCobj.baseObject.lengthSegs = LOCspinStartValue -- set to original spinner value with undo disabled
      with undo label:(DYNuiResourcesUndoLabels[11]) on LOCobj.baseObject.lengthSegs = SPDYNlengthSegs.value -- set to current value with undo enabled
    )
    LOCundoState    = on -- turn undo back on
  )

  --- Height Seg Spinner Controls
  on SPDYNheightSegs changed arg do LOCobj.baseObject.heightSegs = arg
  on SPDYNheightSegs changed arg do (with undo label:(DYNuiResourcesUndoLabels[11]) LOCundoState LOCobj.baseObject.heightSegs = arg)
  on SPDYNheightSegs buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNheightSegs.value)  -- store current spinner value
  on SPDYNheightSegs buttonUp    do
  (
    if LOCspinStartValue != SPDYNheightSegs.value then -- don't apply value if spinner value hasn't changed between buttonDown' and 'buttonUp' events
    (
      with undo off LOCobj.baseObject.heightSegs = LOCspinStartValue -- set to original spinner value with undo disabled
      with undo label:(DYNuiResourcesUndoLabels[11]) on LOCobj.baseObject.heightSegs = SPDYNheightSegs.value -- set to current value with undo enabled
    )
    LOCundoState    = on -- turn undo back on
  )

  --- Depth Seg Spinner Controls
  on SPDYNdepthSegs  changed arg do LOCobj.baseObject.depthSegs  = arg
  on SPDYNdepthSegs changed arg do (with undo label:(DYNuiResourcesUndoLabels[11]) LOCundoState LOCobj.baseObject.depthSegs = arg)
  on SPDYNdepthSegs buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNdepthSegs.value)  -- store current spinner value
  on SPDYNdepthSegs buttonUp    do
  (
    if LOCspinStartValue != SPDYNdepthSegs.value then -- don't apply value if spinner value hasn't changed between buttonDown' and 'buttonUp' events
    (
      with undo off LOCobj.baseObject.depthSegs = LOCspinStartValue -- set to original spinner value with undo disabled
      with undo label:(DYNuiResourcesUndoLabels[11]) on LOCobj.baseObject.depthSegs = SPDYNdepthSegs.value -- set to current value with undo enabled
    )
    LOCundoState    = on -- turn undo back on
  )

  --- Others
  on DDDYNmat selected arg do
  (
    undo off
    (
      if LOCobj.modifiers[DYNmatModName] != undefined then LOCobj.modifiers[DYNmatModName].materialID = arg
      setAppData LOCobj 423 (arg as string)
      DYNproperties.DYNFUNupdPropertiesPanel()
    )
  )

  on CBDYNlinked changed arg do
  (
    if arg == false then
    (
      LOCobj = DYNFUNunlinkNodeInstance DYNprimitiveParams LOCobj 6 false
      select LOCobj
    )
  )

  on PKDYNlink picked arg do
  (
    if arg != LOCobj then
    (
      LOCobj = DYNFUNunlinkNodeInstance DYNprimitiveParams LOCobj 6 true
      instanceReplace LOCobj arg
      select LOCobj
    )
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCiNr5yZP41pb3uQs7NY4bSMnfcwHc5d9y+
-- bpGQul2s7QAFC2cgcExEcbN11pQVVNnzO9V4id+WKJKk5DoNFQF/qEwHL9L5sb17
-- qb3p1k47QAiRKL8ON/M4qngoO9lf8o4ESEgdC6vrK60l3qUWKxziV3X7dObwoeSb
-- Vy3A0c7NTa2qKOPDNe4JZ5s/iws+NTfTppayEKLxjWAAf+eCi+7tPBLy71t3ufq8
-- 5sMr3x6U1vBSIs2XiSDUsrsRNh+ZUAMg2b4e1eSU8Fk6+KT6h5tTUMSvf5Ll/cde
-- MUpHH5ITOG+aU5FT3fEWqHM475ZP6d6g1bIpPQt35bM/ZU48606Z
-- -----END-SIGNATURE-----