--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNpositionControl ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobject
  local LOCobjectController
  local LOCobjLen = 0
  local LOCobjSpl = 0
  local LOCspinStartValue
  local LOCundoState = on
  local LOCattachedSwitch = false
  local LOCmode = 1
  local LOCtrackView
  local LOCparentStartStation = 0.0

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNpopulateTrackView FUNobjController =
  (
    if DYNpositionControl.LOCtrackView != undefined then
    (
      if not (isDeleted DYNpositionControl.LOCtrackView) then
      (
        --- deselect all DYNXFCC/DYNXFCCV3/DYNXFCCM3 tracks by selecting root node!
        DYNPositionControl.LOCtrackView.selectTrackByIndex 1 true

        if isController FUNobjController.percent.controller  and DYNpositionControl.BUDYNposAnim.checked then DYNPositionControl.LOCtrackView.selectTrack FUNobjController.percent.controller  false
        if isController FUNobjController.hOffset.controller  and DYNpositionControl.BUDYNhofAnim.checked then DYNPositionControl.LOCtrackView.selectTrack FUNobjController.hOffset.controller  false
        if isController FUNobjController.vOffset.controller  and DYNpositionControl.BUDYNvofAnim.checked then DYNPositionControl.LOCtrackView.selectTrack FUNobjController.vOffset.controller  false
        if isController FUNobjController.rotation.controller and DYNpositionControl.BUDYNrotAnim.checked then DYNPositionControl.LOCtrackView.selectTrack FUNobjController.rotation.controller false
      )
    )
  )

  fn DYNFUNopenTrackView FUNobj FUNobjController =
  (
    if isValidNode FUNobj then
    (
      if DYNpositionControl.LOCtrackView == undefined then
      (
        trackViews.open (DYNuiRolloutNames[32] + " - " + FUNobj.name) layoutName:(FUNobj.inode.handle as string) pos:[6,100] width:800 height:400
        DYNpositionControl.LOCtrackView = trackViews.current

        --- Decide Which Tracks To Show
        DYNpositionControl.LOCtrackView.autoscrolltoroot = false
        DYNpositionControl.LOCtrackView.rootTrack = FUNobjController
        DYNpositionControl.LOCtrackView.setFilter #animatedTracks
        DYNpositionControl.LOCtrackView.setFilter #keyableTracks

        --- Set Up TrackView Window Display Preferences
        DYNpositionControl.LOCtrackView.ui.showTrackWindow = false
        DYNpositionControl.LOCtrackView.ui.showKeyWindow   = true
        DYNpositionControl.LOCtrackView.ui.showScrollBars  = false

        --- Toolbars
        DYNPositionControl.LOCtrackView.ui.hideAllToolBars() -- First Hide All 13 ToolBars (I assume there is always 13 toolbars in all versions of MAX)

        local LOCnumToolBars = DYNPositionControl.LOCtrackView.ui.toolbarCount()
        for i = 1 to LOCnumToolBars do
        (
          local LOCname  = try ((filterString (DYNPositionControl.LOCtrackView.ui.getToolBarName i) ":")[1]) catch (":")
          local LOCindex = findItem #("Navigation ", "Key Stats ", "Key Tangents ", "Keys ", "Curves ") LOCname -- list of toolbars that we want
          if LOCindex > 0 then
          (
            DYNPositionControl.LOCtrackView.ui.showToolBar (DYNPositionControl.LOCtrackView.ui.getToolBarName i)
          )
        )

        --- Menu
        DYNpositionControl.LOCtrackView.ui.showMenuBar = if LOCnumToolBars == 0 then true else false
      )

      --- Decide which tracks (curves) to show
      if not (isDeleted DYNpositionControl.LOCtrackView) then
      (
        DYNFUNpopulateTrackView FUNobjController
      )
      else
      (
        DYNpositionControl.BUDYNposAnim.checked = false
        DYNpositionControl.BUDYNhofAnim.checked = false
        DYNpositionControl.BUDYNvofAnim.checked = false
        DYNpositionControl.BUDYNrotAnim.checked = false
        DYNPositionControl.LOCtrackView = undefined
      )
    )
  )

  fn DYNFUNchangePosControlTab FUNtab =
  (
    local LOCoffset1, LOCoffset2, LOCoffset3
    LOCoffset1 = LOCoffset2 = LOCoffset3 = 0
    if FUNtab == 1 then (LOCoffset1 = 0; LOCoffset2 = LOCoffset3 = -2000)
    if FUNtab == 2 then (LOCoffset2 = 0; LOCoffset1 = LOCoffset3 = -2000)
    if FUNtab == 3 then (LOCoffset3 = 0; LOCoffset1 = LOCoffset2 = -2000)

    --- Tracking Params
    DYNpositionControl.GBDYNpart1.pos.x   = LOCoffset1 + 13
    DYNpositionControl.PKDYNpar.pos.x     = LOCoffset1 + 19
    DYNpositionControl.BUDYNnoPath.pos.x  = LOCoffset1 + (DYNiniExplorerWidth - 47)
    DYNpositionControl.CKDYNfoll.pos.x    = LOCoffset1 + 19
    DYNpositionControl.CKDYNlong.pos.x    = LOCoffset1 + 19
    DYNpositionControl.CKDYNloop.pos.x    = LOCoffset1 + 19
    DYNpositionControl.GBDYNpart2.pos.x   = LOCoffset1 + 13
    DYNpositionControl.PKDYNsur.pos.x     = LOCoffset1 + 19
    DYNpositionControl.BUDYNnoSur.pos.x   = LOCoffset1 + (DYNiniExplorerWidth - 47)
    DYNpositionControl.CKDYNori.pos.x     = LOCoffset1 + 19
    --- Position Params
    DYNpositionControl.GBDYNpart4.pos.x   = LOCoffset2 + 13
    DYNpositionControl.SLDYNpos.pos.x     = LOCoffset2 + 14
    DYNpositionControl.SPDYNpos.pos.x     = LOCoffset2 + (DYNiniExplorerWidth - 72)
    DYNpositionControl.GBDYNpart5.pos.x   = LOCoffset2 + 13
    DYNpositionControl.LBDYNhOff.pos.x    = LOCoffset2 + 17
    DYNpositionControl.LBDYNvOff.pos.x    = LOCoffset2 + 17
    DYNpositionControl.LBDYNrot.pos.x     = LOCoffset2 + 17
    DYNpositionControl.LBDYNspl.pos.x     = LOCoffset2 + 17
    DYNpositionControl.SPDYNhOff.pos.x    = LOCoffset2 + (DYNiniExplorerWidth - 72)
    DYNpositionControl.SPDYNvOff.pos.x    = LOCoffset2 + (DYNiniExplorerWidth - 72)
    DYNpositionControl.SPDYNrot.pos.x     = LOCoffset2 + (DYNiniExplorerWidth - 72)
    DYNpositionControl.SPDYNspl.pos.x     = LOCoffset2 + (DYNiniExplorerWidth - 43)
    DYNpositionControl.CBDYNposAnim.pos.x = LOCoffset2 + (DYNiniExplorerWidth - 58)
    DYNpositionControl.BUDYNposAnim.pos.x = LOCoffset2 + (DYNiniExplorerWidth - 44)
    DYNpositionControl.CBDYNhofAnim.pos.x = LOCoffset2 + (DYNiniExplorerWidth - 58)
    DYNpositionControl.BUDYNhofAnim.pos.x = LOCoffset2 + (DYNiniExplorerWidth - 44)
    DYNpositionControl.CBDYNvofAnim.pos.x = LOCoffset2 + (DYNiniExplorerWidth - 58)
    DYNpositionControl.BUDYNvofAnim.pos.x = LOCoffset2 + (DYNiniExplorerWidth - 44)
    DYNpositionControl.CBDYNrotAnim.pos.x = LOCoffset2 + (DYNiniExplorerWidth - 58)
    DYNpositionControl.BUDYNrotAnim.pos.x = LOCoffset2 + (DYNiniExplorerWidth - 44)
  )


  --- Function to recalculate animation strart and end key to position at start and end of current animation for looping purposes
  fn DYNFUNreCalcKeys FUNobjectController =
  (
    local LOCnewKeyArray = #()

    if FUNobjectController.percent.keys.count == 2 then
    (
      local LOCkey1 = FUNobjectController.percent.keys[1]
      local LOCkey2 = FUNobjectController.percent.keys[2]

      --- New Start Key Value ---
      if FUNobjectController.percent.keys[1].time > animationRange.start then
      (
        local LOCnewValue = (((LOCkey2.value - LOCkey1.value) / (LOCkey2.time - LOCkey1.time)) * (animationRange.start - LOCkey2.time)) + LOCkey2.value
        append LOCnewKeyArray animationRange.start
        append LOCnewKeyArray LOCnewValue
      )
      else
      (
        if FUNobjectController.percent.keys[1].time == animationRange.start then
        (
          append LOCnewKeyArray animationRange.start
          append LOCnewKeyArray FUNobjectController.percent.keys[1].value
        )
      )

      --- New End Key Value ---
      if FUNobjectController.percent.keys[2].time < animationRange.end then
      (
        local LOCnewValue = (((LOCkey2.value - LOCkey1.value) / (LOCkey2.time - LOCkey1.time)) * (animationRange.end - LOCkey1.time)) + LOCkey1.value
        append LOCnewKeyArray animationRange.end
        append LOCnewKeyArray LOCnewValue
      )
      else
      (
        if FUNobjectController.percent.keys[2].time == animationRange.end then
        (
          append LOCnewKeyArray animationRange.end
          append LOCnewKeyArray FUNobjectController.percent.keys[2].value
        )
      )
    )

    LOCnewKeyArray -- return value, will only be used in rest of code if four values were generated above
  )

  fn DYNFUNanimStateOff =
  (
    try (deleteKeys DYNpositionControl.LOCobject.transform.controller.row2.keys) catch ()    -- Force deletion of any transform keys created by manual movement of timeSlider
    try (deleteKeys DYNpositionControl.LOCobject.transform.controller.row3.keys) catch ()    -- Force deletion of any transform keys created by manual movement of timeSlider
    try (deleteKeys DYNpositionControl.LOCobject.transform.controller.row4.keys) catch ()    -- Force deletion of any transform keys created by manual movement of timeSlider
    DYNpositionControl.DYNFUNnewControlObj DYNpositionControl.LOCobject
  )

  fn DYNFUNspeedCalculator = -- Function to measure speed of object when animated
  (
    if DYNpositionControl.LOCobject != undefined then
    (
      --- General CallBacks for Panel Controls
      local LOCcont = DYNpositionControl.LOCobjectController
      DYNpositionControl.SLDYNpos.value   = DYNpositionControl.SPDYNpos.value = LOCparentStartStation + (DYNpositionControl.LOCobjLen * (if isController LOCcont.percent.controller then LOCcont.percent.controller.value else LOCcont.percent))
      DYNpositionControl.SPDYNhOff.value  = if isController LOCcont.hOffset.controller  then LOCcont.hOffset.controller.value  else LOCcont.hOffset
      DYNpositionControl.SPDYNvOff.value  = if isController LOCcont.vOffset.controller  then LOCcont.vOffset.controller.value  else LOCcont.vOffset
      DYNpositionControl.SPDYNrot.value   = if isController LOCcont.rotation.controller then LOCcont.rotation.controller.value else LOCcont.rotation
      DYNpositionControl.SPDYNspl.value   = LOCcont.spline
    )
  )   --end function

  fn DYNFUNnewControlObj FUNobject =
  (
    if DYNpositionControl.open then
    (
      DYNpositionControl.LOCobject = FUNobject
      DYNpositionControl.LOCobjectController = FUNobject.transform.controller
      DYNFUNmaxBakingControl #(FUNobject) true
      DYNpositionControl.LOCobjLen = (try (curveLength DYNpositionControl.LOCobjectController.path DYNpositionControl.LOCobjectController.spline) catch (0)) as float
      DYNpositionControl.LOCobjSpl = try (numSplines  DYNpositionControl.LOCobjectController.path) catch (0)

      if FUNobject == undefined then
      (
        for i in DYNpositionControl.controls do i.enabled = false
      )
      else
      (
        flagforeground FUNobject true
        for i in DYNpositionControl.controls do i.enabled = true
        if classOf FUNobject == Vsp_symb then DYNpositionControl.SPDYNvOff.enabled = false else DYNpositionControl.SPDYNvOff.enabled = true

        if DYNpositionControl.LOCobjectController.path == undefined then
        (
          DYNpositionControl.PKDYNpar.text       = DYNuiResourcesButtons[15]
          DYNpositionControl.LOCparentStartStation = 0.0
        )
        else
        (
          DYNpositionControl.PKDYNpar.text       = DYNpositionControl.LOCobjectController.path.name

          --- Determine Actual Parent Shape Start Station from AppData
          local LOCstartStation = getAppData DYNpositionControl.LOCobjectController.path 426
          if classOf LOCstartStation == string then LOCstartStation = LOCstartStation as float
          if classOf LOCstartStation == float  then (DYNpositionControl.LOCparentStartStation = LOCstartStation)

        )
        if DYNpositionControl.LOCobjectController.surface == undefined then
        (
          DYNpositionControl.PKDYNsur.text   = DYNuiResourcesButtons[15]
        )
        else
        (
          DYNpositionControl.PKDYNsur.text    = DYNpositionControl.LOCobjectController.surface.name
        )
        DYNpositionControl.CKDYNori.checked   = DYNpositionControl.LOCobjectController.followSurface
        DYNpositionControl.CKDYNfoll.checked  = DYNpositionControl.LOCobjectController.followPath
        DYNpositionControl.CKDYNlong.checked  = DYNpositionControl.LOCobjectController.aux2_bool
        DYNpositionControl.CKDYNloop.checked  = DYNpositionControl.LOCobjectController.aux1_bool
        DYNpositionControl.SPDYNhOff.value    = DYNpositionControl.LOCobjectController.hOffset
        DYNpositionControl.SPDYNvOff.value    = DYNpositionControl.LOCobjectController.vOffset
        DYNpositionControl.SPDYNrot.value     = DYNpositionControl.LOCobjectController.rotation

        if superClassOf FUNobject == Camera then
        (
          DYNpositionControl.PKDYNsur.enabled   = false
          DYNpositionControl.BUDYNnoSur.enabled = false
          DYNpositionControl.CKDYNori.enabled   = false
          DYNpositionControl.CKDYNloop.enabled  = false
        )
        else
        (
          DYNpositionControl.PKDYNsur.enabled   = true
          DYNpositionControl.BUDYNnoSur.enabled = true
          DYNpositionControl.CKDYNori.enabled   = true
          DYNpositionControl.CKDYNloop.enabled  = true
        )

        --- Set Up Chainage Spinner
        DYNpositionControl.SPDYNpos.range     = [DYNpositionControl.LOCparentStartStation, DYNpositionControl.LOCobjLen + DYNpositionControl.LOCparentStartStation, (DYNpositionControl.LOCobjLen * DYNpositionControl.LOCobjectController.percent) + DYNpositionControl.LOCparentStartStation]
        DYNpositionControl.SLDYNpos.range     = [DYNpositionControl.LOCparentStartStation, floor (DYNpositionControl.LOCobjLen + DYNpositionControl.LOCparentStartStation), (DYNpositionControl.LOCobjLen * DYNpositionControl.LOCobjectController.percent) + DYNpositionControl.LOCparentStartStation]
        DYNpositionControl.SLDYNpos.ticks     = 5

        if DYNpositionControl.LOCobjLen == 0 then
        (
          DYNpositionControl.SPDYNpos.enabled = DYNpositionControl.SLDYNpos.enabled = false
        )
        else
        (
          DYNpositionControl.SPDYNpos.enabled = DYNpositionControl.SLDYNpos.enabled = true
        )

        --- Set Up Number of Splines Spinner
        DYNpositionControl.SPDYNspl.range.y   = DYNpositionControl.LOCobjSpl
        DYNpositionControl.SPDYNspl.value     = DYNpositionControl.LOCobjectController.spline
        if DYNpositionControl.SPDYNspl.range.y == 1 or DYNpositionControl.SPDYNspl.range.y == 0 then
        (
          DYNpositionControl.SPDYNspl.enabled = false
        )
        else DYNpositionControl.SPDYNspl.enabled = true

        --- Show whether animated or not
        if (try (DYNpositionControl.LOCobjectController.percent.keys.count) catch (0))  != 0 then
        (
          DYNpositionControl.CBDYNposAnim.checked = true
          DYNpositionControl.BUDYNposAnim.enabled = true
        )
        else
        (
          DYNpositionControl.CBDYNposAnim.checked = false
          DYNpositionControl.BUDYNposAnim.enabled = false
        )
        if (try (DYNpositionControl.LOCobjectController.hOffset.keys.count) catch (0))  != 0 then
        (
          DYNpositionControl.CBDYNhofAnim.checked = true
          DYNpositionControl.BUDYNhofAnim.enabled = true
        )
        else
        (
          DYNpositionControl.CBDYNhofAnim.checked = false
          DYNpositionControl.BUDYNhofAnim.enabled = false
        )
        if (try (DYNpositionControl.LOCobjectController.vOffset.keys.count) catch (0))  != 0 then
        (
          DYNpositionControl.CBDYNvofAnim.checked = true
          DYNpositionControl.BUDYNvofAnim.enabled = true
        )
        else
        (
          DYNpositionControl.CBDYNvofAnim.checked = false
          DYNpositionControl.BUDYNvofAnim.enabled = false
        )
        if (try (DYNpositionControl.LOCobjectController.rotation.keys.count) catch (0)) != 0 then
        (
          DYNpositionControl.CBDYNrotAnim.checked = true
          DYNpositionControl.BUDYNrotAnim.enabled = true
        )
        else
        (
          DYNpositionControl.CBDYNrotAnim.checked = false
          DYNpositionControl.BUDYNrotAnim.enabled = false
        )
      )
      DYNpositionControl.PKDYNattach.enabled = if (SuperClassOf DYNpositionControl.LOCobject != camera) then true else false
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupBox GBDYNtab pos:[4,26] width:(DYNiniExplorerWidth - 21) height:228
  dotNetControl dnTabCtrl "System.Windows.Forms.TabControl" height:23  width:(DYNiniExplorerWidth - 21) pos:[4,10]

  groupbox GBDYNpart1  pos:[13,39]  width:(DYNiniExplorerWidth - 39) height:104
  pickbutton PKDYNpar width:(DYNiniExplorerWidth - 67) align:#center filter:DYNFUNshapeFilter pos:[19,59]
  button BUDYNnoPath DYNuiResourcesButtons[22] width:15 pos:[(DYNiniExplorerWidth - 47),59]
  checkbox CKDYNfoll enabled:true pos:[19,86]
  checkbox CKDYNlong enabled:true pos:[19,104]
  checkbox CKDYNloop enabled:true pos:[19,122] width:150

  groupbox GBDYNpart2  pos:[13,148] width:(DYNiniExplorerWidth - 39) height:69
  pickbutton PKDYNsur width:(DYNiniExplorerWidth - 67) align:#center filter:DYNFUNgeometryFilter pos:[19,169]
  button BUDYNnoSur DYNuiResourcesButtons[22] width:15 pos:[(DYNiniExplorerWidth - 47),169]
  checkbox CKDYNori enabled:true pos:[19,196]

  pickbutton PKDYNattach  width:(DYNiniExplorerWidth - 39) pos:[13,226] filter:DYNFUNgeometryLightFilter

  groupbox GBDYNpart4  pos:[13,39] width:(DYNiniExplorerWidth - 39) height:74
  slider  SLDYNpos orient:#horizontal type:#integer ticks:5 range:[0,100,0] pos:[14,54] width:(DYNiniExplorerWidth - 43)
  spinner SPDYNpos "" type:#worldunits range:[0.0,99999.0,0.0] scale:1.0 fieldwidth:110 pos:[(DYNiniExplorerWidth - 72),91]

  groupbox GBDYNpart5  pos:[13,118] width:(DYNiniExplorerWidth - 39) height:103
  label   LBDYNhOff  pos:[17,137]  align:#left
  label   LBDYNvOff  pos:[17,158]  align:#left
  label   LBDYNrot   pos:[17,179]  align:#left
  label   LBDYNspl   pos:[17,200]  align:#left
  spinner SPDYNhOff  pos:[(DYNiniExplorerWidth - 72),137] type:#worldunits   range:[-9999.0,9999.0,0.0] scale:0.1 fieldwidth:48
  spinner SPDYNvOff  pos:[(DYNiniExplorerWidth - 72),158] type:#worldunits   range:[-9999.0,9999.0,0.0] scale:0.1 fieldwidth:48
  spinner SPDYNrot   pos:[(DYNiniExplorerWidth - 72),179] type:#float   range:[-360.0,360.0,0.0] scale:1.0 fieldwidth:48
  spinner SPDYNspl   pos:[(DYNiniExplorerWidth - 43),200] type:#integer range:[1,1,1] scale:1 fieldwidth:77

  checkbutton CBDYNposAnim DYNuiResourcesButtons[41] width:13 height:16 pos:[(DYNiniExplorerWidth - 58), 91] highlightColor:red
  checkbutton CBDYNhofAnim DYNuiResourcesButtons[41] width:13 height:16 pos:[(DYNiniExplorerWidth - 58),137] highlightColor:red
  checkbutton CBDYNvofAnim DYNuiResourcesButtons[41] width:13 height:16 pos:[(DYNiniExplorerWidth - 58),158] highlightColor:red
  checkbutton CBDYNrotAnim DYNuiResourcesButtons[41] width:13 height:16 pos:[(DYNiniExplorerWidth - 58),179] highlightColor:red
  checkbutton BUDYNposAnim DYNuiResourcesButtons[40] width:13 height:16 pos:[(DYNiniExplorerWidth - 44), 91] highlightColor:DYNINIhighlightColor enabled:false
  checkbutton BUDYNhofAnim DYNuiResourcesButtons[40] width:13 height:16 pos:[(DYNiniExplorerWidth - 44),137] highlightColor:DYNINIhighlightColor enabled:false
  checkbutton BUDYNvofAnim DYNuiResourcesButtons[40] width:13 height:16 pos:[(DYNiniExplorerWidth - 44),158] highlightColor:DYNINIhighlightColor enabled:false
  checkbutton BUDYNrotAnim DYNuiResourcesButtons[40] width:13 height:16 pos:[(DYNiniExplorerWidth - 44),179] highlightColor:DYNINIhighlightColor enabled:false

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNpositionControl open do
  (
    DYNpositionControl.title = DYNuiRolloutNames[31]

    --- Set Up TAB Control
    dntabctrl.tabpages.add DYNuiResourcesLabels[279]
    dntabctrl.tabpages.add DYNuiResourcesLabels[280]
    dnTabCtrl.selectedIndex = 2-1
    DYNFUNchangePosControlTab 2

    --- Set Up Other UI Items
    GBDYNpart1.text  = DYNuiResourcesGroups[14]
    GBDYNpart2.text  = DYNuiResourcesGroups[88]
    GBDYNpart4.text  = DYNuiResourcesGroups[89]
    GBDYNpart5.text  = DYNuiResourcesGroups[19]

    CKDYNfoll.text   = DYNuiResourcesLabels[273]
    CKDYNlong.text   = DYNuiResourcesLabels[274]
    CKDYNori.text    = DYNuiResourcesLabels[275]
    CKDYNloop.text   = DYNuiResourcesLabels[278]
    LBDYNhOff.text   = DYNuiResourcesLabels[1]
    LBDYNvOff.text   = DYNuiResourcesLabels[2]
    LBDYNrot.text    = DYNuiResourcesLabels[12]
    LBDYNspl.text    = DYNuiResourcesLabels[192]

    PKDYNattach.text = DYNuiResourcesButtons[61]

    unregisterTimeCallback DYNFUNspeedCalculator
    registerTimeCallback   DYNFUNspeedCalculator
    callbacks.removescripts id:#DYNpositionControl
    callbacks.addscript #animateOff "DYNpositionControl.DYNFUNanimStateOff()" id:#DYNpositionControl

    LOCattachedSwitch = false
  )

  on DYNpositionControl close do
  (
    unregisterTimeCallback DYNFUNspeedCalculator
    callbacks.removescripts id:#DYNpositionControl
    if not LOCattachedSwitch then
    (
      if not rootNode.DYNrootNodeStore.bakeSwitch then DYNFUNmaxBakingControl #(LOCobject) false
      LOCobject.transform.controller.orientation   = LOCobject.transform.row4
    )
    if LOCtrackView != undefined then (try (trackviews.close (LOCtrackView.getName())) catch ())
  )

  on PKDYNpar picked arg do
  (
    if DYNpositionControl.open do  -- "if open" required to ensure that pickbutton is not still "picking" after panel closes
    (
      if arg != undefined and classof arg.baseObject != LinkLeafshape then
      (
        undo off
        (
          --- Update Spline Number checking how many splines are in new shape selection
          LOCobjSpl             = numSplines arg
          SPDYNspl.range.y      = LOCobjSpl
          if SPDYNspl.value > LOCobjSpl then (SPDYNspl.value = LOCobjSpl; LOCobjectController.spline = LOCobjSpl)
          if LOCobjSpl == 1 then SPDYNspl.enabled = false else SPDYNspl.enabled = true

          --- Set New Parent Object based on Pick Selection
          DYNFUNmaxBakingControl #(LOCobject) true

          LOCobjectController.path   = arg

          --- Update DYNposition, calculating new Chainage whilst taking into account length of new Parent Shape
          LOCobjLen             = curveLength arg LOCobjectController.spline
          if (SPDYNpos.value - LOCparentStartStation) > LOCobjLen then SPDYNpos.value = LOCobjLen + LOCparentStartStation
          if (SLDYNpos.value - LOCparentStartStation) > LOCobjLen then SLDYNpos.value = LOCobjLen + LOCparentStartStation
          SPDYNpos.range.y = LOCobjLen + LOCparentStartStation
          LOCobjectController.percent = (SPDYNpos.value - LOCparentStartStation) / LOCobjLen
          SLDYNpos.range.y      = floor (LOCobjLen + LOCparentStartStation); SLDYNpos.ticks        = 5

          --- Update Other Controls in Panel
          DYNFUNnewControlObj LOCobject
        )
      )
    )
    DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined
  )

  on BUDYNnoPath pressed do
  (
    local LOCmessage = (DYNuiResourcesQueries[25])
    if LOCobjectController.path != undefined then
    (
      LOCmessage += "\n\n"
      LOCmessage += DYNuiResourcesErrorsWarnings[35]
      LOCmessage += "\n\n"
      LOCmessage += DYNuiResourcesLabels[46] + " " + PKDYNPar.text
      if LOCobjectController.surface != undefined then
      (
        LOCmessage += "\n"
        LOCmessage += DYNuiResourcesLabels[47] + " " + PKDYNsur.text
      )
      else (LOCmessage += ".")
    )

    if (querybox LOCmessage title:DYNuiResourcesTitlebars[3] beep:false) then
    (
      LOCattachedSwitch = true -- Used on panel close to ensure that certain functions should not be carried out
      DYNamite.DYNFUNbakeArrayXFCCtoPRS #(LOCobject)
      DYNplacedMan.DYNFUNregatherPlacedObjects()
      select LOCobject
    )
  )

  on PKDYNattach picked arg do
  (
    if DYNpositionControl.open do  -- "if open" required to ensure that pickbutton is not still "picking" after panel closes
    (
      if LOCobject.children.count == 0 then
      (
        if isValidNode arg and arg != LOCobject then
        (
          local LOCparentController = arg.transform.controller
          if classOf LOCparentController == DynXFCC or classOf LOCparentController == DynXFCCM3 or classOf LOCparentController == DynXFCCV3 then
          (
            LOCattachedSwitch = DYNFUNattachObject arg LOCobject [LOCobjectController.hOffset,0.0,LOCobjectController.vOffset] 0.0
            DYNplacedMan.DYNFUNregatherPlacedObjects()
            select LOCobject
          )
          else
          (
            messagebox (DYNuiResourcesErrorsWarnings[33]) title:DYNuiResourcesTitlebars[1]
          )
        )
        else
        (
          messagebox (DYNuiResourcesErrorsWarnings[32]) title:DYNuiResourcesTitlebars[1]
        )
      )
      else
      (
        messagebox (DYNuiResourcesErrorsWarnings[34]) title:DYNuiResourcesTitlebars[1]
      )
    )
  )

  on PKDYNsur picked arg do
  (
    if DYNpositionControl.open do  -- "if open" required to ensure that pickbutton is not still "picking" after panel closes
    (
      if arg != undefined then
      (
        DYNFUNmaxBakingControl #(LOCobject) true
        undo off LOCobjectController.surface = arg
        PKDYNsur.text        = arg.name
      )
    )
    DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined
  )

  on BUDYNnoSur pressed do
  (
    undo off LOCobjectController.surface = undefined
    PKDYNsur.text        = DYNuiResourcesButtons[15]
    DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined
  )

  on CKDYNori  changed arg do (undo off LOCobjectController.followSurface = arg; DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined)
  on CKDYNfoll changed arg do (undo off LOCobjectController.followPath    = arg; DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined)
  on CKDYNlong changed arg do (undo off LOCobjectController.aux2_bool     = arg; DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined)
  on CKDYNloop changed arg do
  (
    --- Turn on chainage looping facility
    undo off LOCobjectController.aux1_bool     = arg

    --- Force Animation Keys to Start and End of current Animation Range, otherwise looping would be pointless
    --- Will only have any effect if >>2<< animation keys exist - (standard DVSP generated animation)
    if arg and (LOCobjectController.percent.keys != undefined) then
    (
      local LOCnewKey = DYNFUNrecalcKeys LOCobjectController
      if LOCnewKey.count == 4 then
      (
        LOCobjectController.percent.keys[1].time  = LOCnewKey[1]
        LOCobjectController.percent.keys[1].value = LOCnewKey[2]
        LOCobjectController.percent.keys[2].time  = LOCnewKey[3]
        LOCobjectController.percent.keys[2].value = LOCnewKey[4]
      )
    )
    DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined
  )

  --- Horizontal Offset Spinner Control
  on SPDYNhOff changed arg do (with undo label:DYNuiResourcesUndoLabels[3] LOCundoState LOCobjectController.hOffset = arg)
  on SPDYNhOff entered  do (BUDYNhofAnim.checked = false; DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined)
  on SPDYNhOff buttonDown  do
  (
    BUDYNhofAnim.checked = false
    LOCundoState = off; LOCspinStartValue = SPDYNhOff.value
  )
  on SPDYNhOff buttonUp    do
  (
    if LOCspinStartValue != SPDYNhOff.value then
    (
      with undo off LOCobjectController.hOffset = LOCspinStartValue
      with undo label:DYNuiResourcesUndoLabels[3] on LOCobjectController.hOffset = SPDYNhOff.value
    )
    LOCundoState    = on
  )

  --- Vertical Offset Spinner Control
  on SPDYNvOff changed arg do (with undo label:DYNuiResourcesUndoLabels[4] LOCundoState LOCobjectController.vOffset = arg)
  on SPDYNvOff entered  do (BUDYNvofAnim.checked = false; DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined)
  on SPDYNvOff buttonDown  do
  (
    BUDYNvofAnim.checked = false
    LOCundoState = off; LOCspinStartValue = SPDYNvOff.value
  )
  on SPDYNvOff buttonUp    do
  (
    if LOCspinStartValue != SPDYNvOff.value then
    (
      with undo off LOCobjectController.vOffset = LOCspinStartValue
      with undo label:DYNuiResourcesUndoLabels[4] on LOCobjectController.vOffset = SPDYNvOff.value
    )
    LOCundoState    = on
  )

  --- Rotation Spinner Control
  on SPDYNrot  changed arg do (with undo label:DYNuiResourcesUndoLabels[5] LOCundoState LOCobjectController.rotation = arg)
  on SPDYNrot  entered  do (BUDYNrotAnim.checked = false; DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined)
  on SPDYNrot  buttonDown  do
  (
    BUDYNrotAnim.checked = false
    LOCundoState = off; LOCspinStartValue = SPDYNrot.value
  )
  on SPDYNrot  buttonUp    do
  (
    if LOCspinStartValue != SPDYNrot.value then
    (
      with undo off LOCobjectController.rotation = LOCspinStartValue
      with undo label:DYNuiResourcesUndoLabels[5] on LOCobjectController.rotation = SPDYNrot.value
    )
    LOCundoState    = on
  )

  --- Chainage Spinner Control
  on SPDYNpos  changed arg do
  (
    with undo label:DYNuiResourcesUndoLabels[2] LOCundoState (LOCobjectController.percent = (arg - LOCparentStartStation) / LOCobjLen; SLDYNpos.value = arg)
  )
  on SPDYNpos  entered  do (BUDYNposAnim.checked = false; DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined)
  on SPDYNpos  buttonDown  do
  (
    BUDYNposAnim.checked = false
    LOCundoState = off; LOCspinStartValue = SPDYNpos.value
  )
  on SPDYNpos  buttonUp    do
  (
    if LOCspinStartValue != SPDYNpos.value then
    (
      with undo off (LOCobjectController.percent = ((LOCspinStartValue - LOCparentStartStation) / LOCobjLen) ; SLDYNpos.value = LOCspinStartValue)
      with undo label:DYNuiResourcesUndoLabels[2] on (LOCobjectController.percent = (SPDYNpos.value - LOCparentStartStation) / LOCobjLen ; SLDYNpos.value = SPDYNpos.value)
    )
    LOCundoState    = on
  )

  --- Chainage Slider
  on SLDYNpos  changed arg do
  (
    local LOCnewPos = (arg - LOCparentStartStation) ; if arg == SLDYNpos.range.y then LOCnewPos = LOCobjLen
    with undo label:DYNuiResourcesUndoLabels[2] LOCundoState (LOCobjectController.percent = LOCnewPos / LOCobjLen; SPDYNpos.value = LOCnewPos + LOCparentStartStation)
  )
  on SLDYNpos buttonDown do
  (
    BUDYNposAnim.checked = false
    LOCundoState = off; LOCspinStartValue = SLDYNpos.value
  )
  on SLDYNpos buttonUp   do
  (
    local LOCnewPos = (SLDYNpos.value - LOCparentStartStation) ; if SLDYNpos.value == SLDYNpos.range.y then LOCnewPos = LOCobjLen
    if LOCspinStartValue != LOCnewPos then
    (
      with undo off (LOCobjectController.percent = ((LOCspinStartValue - LOCparentStartStation) / LOCobjLen) ; SPDYNpos.value = LOCspinStartValue)
      with undo label:DYNuiResourcesUndoLabels[2] on (LOCobjectController.percent = LOCnewPos / LOCobjLen ; SPDYNpos.value = LOCnewPos + LOCparentStartStation)
    )
    DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined
    LOCundoState    = on
  )

  --- Checkbuttons
  on CBDYNposAnim changed arg do
  (
    if arg == false then
    (
      if (queryBox (DYNuiResourcesQueries[24]) title:DYNuiResourcesTitlebars[2]) then
      (
        undo label:(DYNuiResourcesUndoLabels[15]) on
        (
          if LOCobjectController.percent.keys != undefined then deleteKeys LOCobjectController.percent.keys
        )
        if LOCmode == 1 then (BUDYNposAnim.checked = false)
        BUDYNposAnim.enabled = false
      )
      else (CBDYNposAnim.checked = true)
    )
    else
    (
      if (queryBox (DYNuiResourcesQueries[23]) title:DYNuiResourcesTitlebars[2]) then
      (
        local LOCspeed = DYNFUNdisplaySpinner DYNuiResourcesTitlebars[22] (DYNuiResourcesLabels[269] + " (" + DYNuiResourcesUnitsDistance[DYNINIspeedValue.x] + "/" + DYNuiResourcesUnitsTime[DYNINIspeedValue.y] + ")") [-999.9,999.9,0.0] "float"
        if LOCspeed == undefined or LOCspeed == 0.0 then
        (
          CBDYNposAnim.checked = false
          BUDYNposAnim.enabled = false
        )
        else
        (
          local LOCspeedParamArray = #(0.0,0f)
          local LOCpathLen = curveLength LOCobjectController.path LOCobjectController.spline
          local LOCtempPos = SPDYNpos.value - LOCparentStartStation
          if LOCspeed > 0.0 then (LOCspeedParamArray = DYNFUNspeedKeys (LOCpathLen - LOCtempPos) LOCspeed LOCobject)
          if LOCspeed < 0.0 then (LOCspeedParamArray = DYNFUNspeedKeys LOCtempPos LOCspeed LOCobject)
          LOCobjectController.percent.controller = bezier_float()
          local LOCnewKey1 = addNewKey LOCobjectController.percent.controller animationRange.start
          LOCnewKey1.value          = LOCobjectController.percent
          LOCnewKey1.inTangentType  = #smooth ; LOCnewKey1.outTangentType = #smooth
          local LOCnewKey2 = addNewKey LOCobjectController.percent.controller LOCspeedParamArray[2]
          LOCnewKey2.value          = if LOCspeed > 0.0 then ((LOCtempPos + LOCspeedParamArray[1]) / LOCpathLen) else ((LOCtempPos - LOCspeedParamArray[1]) / LOCpathLen)
          LOCnewKey2.inTangentType  = #smooth ; LOCnewKey2.outTangentType = #smooth
          BUDYNposAnim.enabled = true

          SLDYNpos.value = SPDYNpos.value = LOCparentStartStation + (LOCobjLen * (if isController LOCobjectController.percent.controller then LOCobjectController.percent.controller.value else LOCobjectController.percent))

          if (try (trackviews.isOpen (DYNpositionControl.LOCtrackView.getName())) catch (false)) then BUDYNposAnim.checked = true
          DYNFUNpopulateTrackView LOCobjectController
        )
      )
      else
      (
        CBDYNposAnim.checked = false
        BUDYNposAnim.enabled = false
      )
    )
    DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined
  )

  on CBDYNhofAnim changed arg do
  (
    if arg == false then
    (
      if (queryBox (DYNuiResourcesQueries[22]) title:DYNuiResourcesTitlebars[2]) then
      (
        undo label:(DYNuiResourcesUndoLabels[15]) on
        (
          if LOCobjectController.hOffset.keys != undefined then deleteKeys LOCobjectController.hOffset.keys
        )
        if LOCmode == 2 then (BUDYNhofAnim.checked = false)
        BUDYNhofAnim.checked = false
        BUDYNhofAnim.enabled = false
      )
      else CBDYNhofAnim.checked = true
    )
    else
    (
      if (queryBox (DYNuiResourcesQueries[21]) title:DYNuiResourcesTitlebars[2]) then
      (
        local LOCoffset = DYNFUNdisplaySpinner DYNuiResourcesTitlebars[22] (DYNuiResourcesLabels[270]) [-999.9,999.9,SPDYNhOff.value] "float"
        if LOCoffset == undefined then
        (
          CBDYNhofAnim.checked = false
          BUDYNhofAnim.enabled = false
        )
        else
        (
          LOCobjectController.hOffset = LOCoffset

          LOCobjectController.hOffset.controller = bezier_float()
          local LOCnewKey1 = addNewKey LOCobjectController.hOffset.controller animationRange.start
          LOCnewKey1.value          = LOCobjectController.hOffset
          LOCnewKey1.inTangentType  = #smooth ; LOCnewKey1.outTangentType = #smooth

          local LOCnewKey2 = addNewKey LOCobjectController.hOffset.controller animationRange.end
          LOCnewKey2.value          = LOCobjectController.hOffset
          LOCnewKey2.inTangentType  = #smooth ; LOCnewKey2.outTangentType = #smooth
          BUDYNhofAnim.enabled = true

          SPDYNhOff.value = if isController LOCobjectController.hOffset.controller  then LOCobjectController.hOffset.controller.value  else LOCobjectController.hOffset

          if (try (trackviews.isOpen (DYNpositionControl.LOCtrackView.getName())) catch (false)) then BUDYNhofAnim.checked = true
          DYNFUNpopulateTrackView LOCobjectController
        )
      )
      else
      (
        CBDYNhofAnim.checked = false
        BUDYNhofAnim.enabled = false
      )
    )
    DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined
  )
  on CBDYNvofAnim changed arg do
  (
    if arg == false then
    (
      if (queryBox (DYNuiResourcesQueries[20]) title:DYNuiResourcesTitlebars[2]) then
      (
        undo label:(DYNuiResourcesUndoLabels[15]) on
        (
          if LOCobjectController.vOffset.keys != undefined then deleteKeys LOCobjectController.vOffset.keys
        )
        if LOCmode == 3 then (BUDYNvofAnim.checked = false)
        BUDYNvofAnim.checked = false
        BUDYNvofAnim.enabled = false
      )
      else CBDYNvofAnim.checked = true
    )
    else
    (
      if (queryBox (DYNuiResourcesQueries[19]) title:DYNuiResourcesTitlebars[2]) then
      (
        local LOCoffset = DYNFUNdisplaySpinner DYNuiResourcesTitlebars[22] (DYNuiResourcesLabels[271]) [-99.9,99.9,SPDYNvOff.value] "float"
        if LOCoffset == undefined then
        (
          CBDYNvofAnim.checked = false
          BUDYNvofAnim.enabled = false
        )
        else
        (
          LOCobjectController.vOffset = LOCoffset

          LOCobjectController.vOffset.controller = bezier_float()
          local LOCnewKey1 = addNewKey LOCobjectController.vOffset.controller animationRange.start
          LOCnewKey1.value          = LOCobjectController.vOffset
          LOCnewKey1.inTangentType  = #smooth ; LOCnewKey1.outTangentType = #smooth

          local LOCnewKey2 = addNewKey LOCobjectController.vOffset.controller animationRange.end
          LOCnewKey2.value          = LOCobjectController.vOffset
          LOCnewKey2.inTangentType  = #smooth ; LOCnewKey2.outTangentType = #smooth
          BUDYNvofAnim.enabled = true

          SPDYNvOff.value  = if isController LOCobjectController.vOffset.controller  then LOCobjectController.vOffset.controller.value  else LOCobjectController.vOffset

          if (try (trackviews.isOpen (DYNpositionControl.LOCtrackView.getName())) catch (false)) then BUDYNvofAnim.checked = true
          DYNFUNpopulateTrackView LOCobjectController
        )
      )
      else
      (
        CBDYNvofAnim.checked = false
        BUDYNvofAnim.enabled = false
      )
    )
    DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined
  )
  on CBDYNrotAnim changed arg do
  (
    if arg == false then
    (
      if (queryBox (DYNuiResourcesQueries[18]) title:DYNuiResourcesTitlebars[2]) then
      (
        undo label:(DYNuiResourcesUndoLabels[15]) on
        (
          if LOCobjectController.rotation.keys != undefined then deleteKeys LOCobjectController.rotation.keys
        )
        if LOCmode == 4 then (BUDYNrotAnim.checked = false)
        BUDYNrotAnim.checked = false
        BUDYNrotAnim.enabled = false
      )
      else CBDYNrotAnim.checked = true
    )
    else
    (
      if (queryBox (DYNuiResourcesQueries[17]) title:DYNuiResourcesTitlebars[2]) then
      (
        local LOCoffset = DYNFUNdisplaySpinner DYNuiResourcesTitlebars[22] (DYNuiResourcesLabels[272]) [-360.0,360.0,SPDYNrot.value] "float"
        if LOCoffset == undefined then
        (
          CBDYNrotAnim.checked = false
          BUDYNrotAnim.enabled = false
        )
        else
        (
          LOCobjectController.rotation = LOCoffset

          LOCobjectController.rotation.controller = bezier_float()
          local LOCnewKey1 = addNewKey LOCobjectController.rotation.controller animationRange.start
          LOCnewKey1.value          = LOCobjectController.rotation
          LOCnewKey1.inTangentType  = #smooth ; LOCnewKey1.outTangentType = #smooth

          local LOCnewKey2 = addNewKey LOCobjectController.rotation.controller animationRange.end
          LOCnewKey2.value          = LOCobjectController.rotation
          LOCnewKey2.inTangentType  = #smooth ; LOCnewKey2.outTangentType = #smooth
          BUDYNrotAnim.enabled = true

          SPDYNrot.value = if isController LOCobjectController.rotation.controller then LOCobjectController.rotation.controller.value else LOCobjectController.rotation

          if (try (trackviews.isOpen (DYNpositionControl.LOCtrackView.getName())) catch (false)) then BUDYNrotAnim.checked = true
          DYNFUNpopulateTrackView LOCobjectController
        )
      )
      else
      (
        CBDYNrotAnim.checked = false
        BUDYNrotAnim.enabled = false
      )
    )
    DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined
  )

  on BUDYNposAnim changed arg do
  (
    if (try (LOCobjectController.percent.keys.count) catch (0)) > 0 then DYNFUNopenTrackView LOCobject LOCobjectController
  )
  on BUDYNhofAnim changed arg do
  (
    if (try (LOCobjectController.hOffset.keys.count) catch (0)) > 0 then DYNFUNopenTrackView LOCobject LOCobjectController
  )
  on BUDYNvofAnim changed arg do
  (
    if (try (LOCobjectController.vOffset.keys.count) catch (0)) > 0 then DYNFUNopenTrackView LOCobject LOCobjectController
  )
  on BUDYNrotAnim changed arg do
  (
    if (try (LOCobjectController.rotation.keys.count) catch (0)) > 0 then DYNFUNopenTrackView LOCobject LOCobjectController
  )

  on SPDYNspl  changed arg do
  (
    undo off
    (
      --- Update DYNposition, taking into account the length of the new spline selection
      LOCobjectController.spline   = arg
      LOCobjLen             = curveLength LOCobjectController.path arg
      if (SPDYNpos.value - LOCparentStartStation) > LOCobjLen then SPDYNpos.value = LOCobjLen + LOCparentStartStation
      SPDYNpos.range.y      = LOCobjLen + LOCparentStartStation
      LOCobjectController.percent = (SPDYNpos.value - LOCparentStartStation) / LOCobjLen

      if (SLDYNpos.value - LOCparentStartStation) > LOCobjLen then SLDYNpos.value = LOCobjLen + LOCparentStartStation
      SLDYNpos.range.y      = floor (LOCobjLen + LOCparentStartStation)
      SLDYNpos.ticks        = 5
    )
    DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCobjectController undefined
  )

  on dnTabCtrl mouseUp arg do
  (
    DYNFUNchangePosControlTab (dnTabCtrl.selectedTab.TabIndex + 1)
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCHE3n+nPpsvSr4Q3S6AsfvqgURHruzERsm
-- 3y6obl8EPmXxWmFo/fswi3PjkKcs+IclZAsthbdwSQFuI50bgTZvXy4pLPHOfqJu
-- SkVNL5eyL2yd/bcJ2b/xBUi7hYsJJ0w9d5ZIMsN+B/dEaozVcdjl6A71JIuPmz23
-- awCEpyym8ow899WAx4Xhz8kF8p5+VtCG8x7w47Pwpy3SSEJAkfpuTU7LJnaXmzL4
-- hLWySpq2b335g0G8ZQwrEthmNL7RQVSxGmt1DI3hmtB5bsZzMS0F0BpzIeJ8dUzD
-- Iptl88++i3kEUhMdKBZiPh0DSduuoyqLcxuHTnvUieP+caOS8KFX
-- -----END-SIGNATURE-----