--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNpointBasedPlace ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobjects = #()
  local LOCobjectController
  local LOCbaseObj
  local LOCbaseShape
  local LOCnewObjArray = #()

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNcloneObjectByPercent FUNsourceObj FUNobjNewName FUNobjNewPercent FUNobjNewOffsets FUNcloneType FUNsourceController FUNlocalTime FUNcloneChildren =
  (
    local LOCnewObject
    local LOCnewObjCtrlr

    if isValidNode FUNsourceObj and classOf FUNobjNewName == string and classOf FUNobjNewPercent == float and (classOf FUNsourceController == DynXFCC or classOf FUNsourceController == DynXFCCM3 or classOf FUNsourceController == DynXFCCV3) then
    (
      --- Basic Cloning Parameters
      LOCnewObject              = if FUNcloneType == 1 then instance FUNsourceObj else copy FUNsourceObj
      LOCnewObject.name         = FUNobjNewName
      LOCnewObject.wireColor    = FUNsourceObj.wireColor
      LOCnewObject.parent       = FUNsourceObj.parent
      LOCnewObject.castShadows  = FUNsourceObj.castShadows
      try (LOCnewObject.isGIoccluder = FUNsourceObj.isGIoccluder) catch ()

      --- Apply Transform Controller and Position Object
      LOCnewObjCtrlr = LOCnewObject.transform.controller = copy FUNsourceController
      DYNFUNmaxBakingControl #(LOCnewObject) true
      LOCnewObjCtrlr.percent  = try (FUNobjNewPercent) catch (0.0)
      LOCnewObjCtrlr.hOffset  = try (FUNobjNewOffsets.x) catch (0.0)
      LOCnewObjCtrlr.vOffset  = try (FUNobjNewOffsets.y) catch (0.0)
      LOCnewObjCtrlr.rotation = try (FUNobjNewOffsets.z) catch (0.0)

      --- Apply AppData
      DYNFUNgenObjAppData LOCnewObject (getAppData FUNsourceObj 422) (getAppData FUNsourceObj 423) (getAppData FUNsourceObj 424) FUNlocalTime (getAppData FUNsourceObj 426) (getAppData FUNsourceObj 427) (getAppData FUNsourceObj 428)

      --- Clone Children (Dependent Objects such as signs etc)
      if FUNcloneChildren then
      (
        for i = 1 to FUNsourceObj.children.count do
        (
          local LOColdChild       = FUNsourceObj.children[i]
          local LOCnewChild       = if FUNcloneType == 1 then instance LOColdChild else copy LOColdChild
          LOCnewChild.name        = uniqueName LOColdChild.name
          LOCnewChild.wireColor   = LOColdChild.wireColor
          LOCnewChild.castShadows = LOColdChild.castShadows
          try (LOCnewChild.isGIoccluder = LOColdChild.isGIoccluder) catch ()

          --- Apply Attach PRS Transform Controller
          DYNFUNattachObject LOCnewObject LOCnewChild [LOColdChild.objectOffsetPos.x * -1, LOColdChild.objectOffsetPos.y, LOColdChild.objectOffsetPos.z] (in coordSys parent (LOColdChild.rotation.z_rotation))

          --- Apply AppData
          local LOCchildObjSwitch = (getAppData LOColdChild 422) as integer
          DYNFUNgenObjAppData LOCnewChild (LOCchildObjSwitch as string) (getAppData LOColdChild 423) (getAppData LOColdChild 424) FUNlocalTime (getAppData LOColdChild 426) (getAppData LOColdChild 427) (getAppData LOColdChild 428)
        )
      )
    )
    LOCnewObject -- return value
  )

  fn DYNFUNplaceNow =
  (
    DYNpointBasedPlace.dnProgress.value = 0
    DYNpointBasedPlace.LBDYNstatus.text = DYNuiResourcesStatusMessages[24]

    --- count Place Objects
    max create mode
    DYNFUNremoveCSProllouts()
    DYNFUNloadVSPnodeCallBacks false
    (
      --- Remove Old Objects If There Were Any
      clearUndoBuffer()
      undo off
      (
        if DYNpointBasedPlace.LOCnewObjArray.count != 0 then
        (
          for i in DYNpointBasedPlace.LOCnewObjArray do (if isValidNode i then delete i)
        )
        DYNpointBasedPlace.LOCnewObjArray = #()
      )

      --- Build New Objects
      local LOCobjectSwitch = (getAppData DYNpointBasedPlace.LOCbaseObj 422) as integer
      local LOCcnt = 1

      for i = 1 to (numSplines DYNpointBasedPlace.LOCbaseShape) do
      (
        local LOCstartKnotID = if DYNpointBasedPlace.CKDYNexclude.checked and i == 1 then 2 else 1
        for ii = LOCstartKnotID to (numKnots DYNpointBasedPlace.LOCbaseShape i) by DYNpointBasedPlace.SPDYNnthPoint.value do
        (
          DYNpointBasedPlace.dnProgress.value = (LOCcnt as float) / (numKnots DYNpointBasedPlace.LOCbaseShape) * 100.0
          --- Calculate Nearest Percent Point
          local LOCpercent = nearestPathParam DYNpointBasedPlace.LOCbaseShape i (getKnotPoint DYNpointBasedPlace.LOCbaseShape i ii) steps:10000
          LOCpercent = pathToLengthParam DYNpointBasedPlace.LOCbaseShape i LOCpercent steps:10000

          --- Grab Reference to existing controller
          local LOCobjectCtrl = DYNpointBasedPlace.LOCbaseObj.transform.controller

          --- Clone object
          local LOCnewObj = DYNFUNcloneObjectByPercent DYNpointBasedPlace.LOCbaseObj (uniqueName DYNpointBasedPlace.EDDYNname.text) LOCpercent [LOCobjectCtrl.hOffset,LOCobjectCtrl.vOffset,LOCobjectCtrl.rotation] DYNpointBasedPlace.RBDYNcloneType.state LOCobjectCtrl (DYNFUNgetlocalTime()) DYNpointBasedPlace.CKDYNchildren.checked
          if DYNpointBasedPlace.CKDYNrotation.checked then LOCobjectCtrl.rotation = random 0.0 360.0

          --- Finish Off Function Routines
          append DYNpointBasedPlace.LOCnewObjArray LOCnewObj
          LOCcnt += (1 * DYNpointBasedPlace.SPDYNnthPoint.value)
        )
      )
    )
    DYNFUNloadVSPnodeCallBacks true
    DYNFUNnodeCreatedCallback()

    DYNpointBasedPlace.dnProgress.value = 0
    DYNpointBasedPlace.LBDYNstatus.text = DYNuiResourcesStatusMessages[25]
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  pickbutton PKDYNobject  pos:[11,7]  width:308
  groupbox GBDYN00        pos:[11,37] width:308 height:150
  label LBDYNoldName1     pos:[20,59]   align:#left
  label LBDYNoldName2     pos:[138,59]  align:#left
  label LBDYNattachedTo1  pos:[20,80]   align:#left
  label LBDYNattachedTo2  pos:[138,80]  align:#left
  label LBDYNsplines1     pos:[20,101]  align:#left
  label LBDYNsplines2     pos:[138,101] align:#left
  label LBDYNknots1       pos:[20,122]  align:#left
  label LBDYNknots2       pos:[138,122] align:#left
  label LBDYNname         pos:[20,143]  align:#left
  editText EDDYNname      pos:[131,143] fieldwidth:176 enabled:false

  checkbox CKDYNchildren  pos:[20,165]  enabled:false align:#left

  groupbox GBDYN01        pos:[11,194]  height:104 width:308
  label LBDYNsteps        pos:[19,212]  align:#left
  spinner SPDYNsteps      pos:[226,211] type:#integer range:[100,999999,10000] align:#right fieldwidth:74
  label LBDYNnthPoint     pos:[19,233]  align:#left
  spinner SPDYNnthPoint   pos:[226,232] type:#integer range:[1,999999,1] align:#right fieldwidth:74
  checkbox CKDYNexclude   pos:[20,252]  enabled:true checked:true align:#left
  checkbox CKDYNrotation  pos:[20,272]  enabled:true align:#left

  groupbox GBDYN02        pos:[11,305]  width:308 height:55

  button BUDYNokok        pos:[11,373]  width:72  height:22 enabled:false
  button BUDYNapply       pos:[129,373] width:72  height:22 enabled:false
  button BUDYNcanc        pos:[247,373] width:72  height:22

  radiobuttons RBDYNcloneType columns:1 labels:#(DYNuiResourcesLabels[354],DYNuiResourcesLabels[355]) pos:[20,322]
  dotNetControl  dnProgress "System.Windows.Forms.ProgressBar" pos:[11,403] width:308 height:14

  label LBDYNstatus              pos:[11,423]   width:308 height:18

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNpointBasedPlace open do
  (
    DYNpointBasedPlace.title = DYNuiRolloutNames[38]
    GBDYN00.text             = DYNuiResourcesGroups[106]
    GBDYN01.text             = DYNuiResourcesGroups[102]
    GBDYN02.text             = DYNuiResourcesGroups[105]

    LBDYNstatus.text         = DYNuiResourcesStatusMessages[25]
    LBDYNattachedTo1.text    = DYNuiResourcesLabels[46]
    LBDYNsplines1.text       = DYNuiResourcesLabels[196]
    LBDYNname.text           = DYNuiResourcesLabels[356]
    LBDYNoldName1.text       = DYNuiResourcesLabels[357]
    LBDYNknots1.text         = DYNuiResourcesLabels[358]
    LBDYNsteps.text          = DYNuiResourcesLabels[359]
    LBDYNnthPoint.text       = DYNuiResourcesLabels[360]
    CKDYNexclude.text        = DYNuiResourcesLabels[361]
    CKDYNrotation.text       = DYNuiResourcesLabels[362]
    CKDYNchildren.text       = DYNuiResourcesLabels[363]

    PKDYNobject.text         = DYNuiResourcesButtons[76]
    BUDYNokok.text           = DYNuiResourcesButtons[1]
    BUDYNapply.text          = DYNuiResourcesButtons[2]
    BUDYNcanc.text           = DYNuiResourcesButtons[3]
  )

  on DYNpointBasedPlace close do
  (
    LOCnewObjArray = #()
    DYNFUNonDialogClose()
  )

  on PKDYNobject picked arg do
  (
    local LOCtempCtrl = arg.transform.controller
    if classOf LOCtempCtrl == DynXFCC or classOf LOCtempCtrl == DynXFCCM3 or classOf LOCtempCtrl == DynXFCCV3 then
    (
      if isValidNode LOCtempCtrl.path then
      (
        LOCobjectController   = LOCtempCtrl
        LOCbaseObj            = arg
        EDDYNname.text        = LOCbaseObj.name
        LBDYNoldName2.text    = LOCbaseObj.name
        EDDYNname.enabled     = true
        setFocus EDDYNname
        CKDYNchildren.enabled = (if LOCbaseObj.children.count > 0 then true else false)
        CKDYNchildren.checked = (if LOCbaseObj.children.count > 0 then true else false)
        LBDYNattachedTo2.text = LOCobjectController.path.name
        LOCbaseShape          = LOCobjectController.path
        LBDYNsplines2.text    = (numSplines LOCobjectController.path) as string
        LBDYNknots2.text      = (numKnots LOCobjectController.path) as string
        BUDYNokok.enabled     = true
        BUDYNapply.enabled    = true
      )
      else
      (
        messagebox (DYNuiResourcesErrorsWarnings[47]) title:DYNuiResourcesTitlebars[2]
      )
    )
    else
    (
      messagebox (DYNuiResourcesErrorsWarnings[48]) title:DYNuiResourcesTitlebars[2]
    )
  )

  on BUDYNokok  pressed do (DYNFUNplaceNow(); destroyDialog DYNpointBasedPlace)
  on BUDYNapply pressed do (DYNFUNplaceNow())
  on BUDYNcanc  pressed do
  (
    if (queryBox (DYNuiResourcesQueries[30]) title:DYNuiResourcesTitlebars[3]) then
    (
      if LOCnewObjArray.count != 0 then
      (
        DYNFUNremoveCSProllouts()
        DYNFUNloadVSPnodeCallBacks false
        (
          for i in LOCnewObjArray do (if isValidNode i then delete i)
        )
        DYNFUNloadVSPnodeCallBacks true
        DYNFUNnodeCreatedCallback()
      )
    )
    destroyDialog DYNpointBasedPlace
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCUO9w1JpJJE8C+7gQAgZgxZ+NTL9McTaVX
-- 4J2ge9oho3H3jvvYrDHY51/kssifWxbXzLHDomPV96H3Ky1/TV3JFjDgXYsDHkBJ
-- Jj8g5X90jgFCzte3kIVtSEIvB81sJDB4JZgs5rqq1D/00JNUKxS2EP0ohgGqjtvU
-- BPYLnJxfGYDFMId9W+GeqN9qXl6al5l5zqO0jSni0BtAxV8amKTtxW7NAcmzl3rS
-- k8ErKjIdFjahb0bz9PiqxmI/sw7PRdZT035LSL2mPdO9bhQao7QaQC39jpr2Q8mp
-- a/AMNVgzJIsF3P1+/XtSpR0Rb+PKznpC8TtE3wJm6gcPJ5LZwz7n
-- -----END-SIGNATURE-----