rollout DYNmrSunLight ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNsunParams FUNsun =
  (
    DYNmrSunLight.LOCobj = FUNsun

    if classOf FUNsun == Sun_Positioner then
    (
      DYNmrSunLight.LBDYNlightName.text       = FUNsun.name
      DYNmrSunLight.LOCobj                    = FUNsun
      DYNmrSunLight.CKDYNshowCompass.checked  = FUNsun.show_compass
      DYNmrSunLight.SPDYNsunRadius.value      = FUNsun.compass_radius
      DYNmrSunLight.SPDYNdistance.value       = FUNsun.north_direction_deg
      DYNmrSunLight.SPDYNnorthOffset.value    = FUNsun.baseObject.north_direction_deg

      if classOf environmentMap == Physical_Sun___Sky_Environment then 
      (
        DYNmrSunLight.BUDYNinstallEnv.text  = DYNuiResourcesButtons[120]
        DYNmrSunLight.BUDYNinstallEnv.enabled = false
      )
      else 
      (
        DYNmrSunLight.BUDYNinstallEnv.text  = DYNuiResourcesButtons[119]
        DYNmrSunLight.BUDYNinstallEnv.enabled = true
      )
    )
    else
    (
      for i in DYNmrSunLight.controls do i.enabled = false
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  label LBDYNlightName      align:#center

  groupbox GBDYNgroup01     pos:[4,24] width:(DYNiniExplorerWidth - 21) height:87
  checkbox CKDYNshowCompass align:#left pos:[13,45]
  label   LBDYNsunRadius    align:#left pos:[13,67]
  spinner  SPDYNsunRadius   align:#left pos:[(DYNiniExplorerWidth - 96),65] range:[-999999.0,999999.0,1.0] type:#float   fieldwidth:60 scale:1.0
  label   LBDYNnorthOffset  align:#left pos:[13,87]
  spinner SPDYNnorthOffset  align:#left pos:[(DYNiniExplorerWidth - 96),85] range:[-359.99,359.99,0.0] type:#float fieldwidth:60 scale:0.1

  groupbox GBDYNgroup02     pos:[4,116] width:(DYNiniExplorerWidth - 21) height:43
  label   LBDYNdistance     align:#left pos:[13,135]
  spinner SPDYNdistance     align:#left pos:[(DYNiniExplorerWidth - 96),133] range:[-999999.0,999999.0,1.0] type:#float fieldwidth:60 scale:0.1

  button BUDYNinstallEnv    width:(DYNiniExplorerWidth - 21) align:#center pos:[4,164]
  button BUDYNtimeDate      width:(DYNiniExplorerWidth - 21) align:#center pos:[4,188]

  on DYNmrSunLight open do
  (
    DYNmrSunLight.title   = DYNuiRolloutNames[68]
    GBDYNgroup01.text     = DYNuiResourcesGroups[67]
    GBDYNgroup02.text     = DYNuiResourcesGroups[83]

    CKDYNshowCompass.text = DYNuiResourcesLabels[22]
    LBDYNsunRadius.text   = DYNuiResourcesLabels[186]
    LBDYNdistance.text    = DYNuiResourcesLabels[663]
    LBDYNnorthOffset.text = DYNuiResourcesLabels[265]
    BUDYNtimeDate.text    = DYNuiResourcesButtons[60]
    BUDYNinstallEnv.text  = DYNuiResourcesButtons[119]
  )

  on BUDYNtimeDate pressed do
  (
    cui.commandPanelOpen = true
    max modify mode
    messagebox (DYNuiResourcesErrorsWarnings[31]) title:DYNuiResourcesTitlebars[3]
  )

  on BUDYNinstallEnv pressed do 
  (
    if classOf environmentMap != Physical_Sun___Sky_Environment then
    (
      environmentMap = Physical_Sun___Sky_Environment()
    )

    if classOf environmentMap == Physical_Sun___Sky_Environment then 
    (
      environmentMap.sun_position_object = LOCobj

      DYNmrSunLight.BUDYNinstallEnv.text  = DYNuiResourcesButtons[120]
      DYNmrSunLight.BUDYNinstallEnv.enabled = false
    )
    else 
    (
      DYNmrSunLight.BUDYNinstallEnv.text  = DYNuiResourcesButtons[119]
      DYNmrSunLight.BUDYNinstallEnv.enabled = true
    )
  )

  on CKDYNshowCompass changed arg do LOCobj.show_compass = arg
  on SPDYNsunRadius   changed arg do LOCobj.compass_radius = arg
  on SPDYNnorthOffset changed arg do LOCobj.north_direction_deg = arg
  on SPDYNdistance    changed arg do LOCobj.sun_distance = arg
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCAAYIqATMW3pnkidjCxj73I7eKGdw4vXLa
-- oJwnBL9VD5GMpRySxn+mPbbtkPV7NdqP2WFE5uAjmODyD6+8BkCERYoNrSpeSQWl
-- NYOyZGPv+DsMUjEZeukAqMzuwiO3LZ9IQQUYANRIVc2QTixW1tLKFCSqMSd3P+Ma
-- k2xl7+UyDLRGXF2O6tfOSL2EYfpUOv/5uhDI0YoNVvryqD95sLmUvPZYhoPlISi2
-- jCmzaUA1HY817Y8j0KvnN6mc8yiadEfMTq+arTTSk9KDNSR240YCPpHMRnKc9mdT
-- 8IBBVjPEJlrDVDIYSr7E8S2o2vzBrFGdL+7Twgr5C6q13K8K0E/5
-- -----END-SIGNATURE-----