--
-- � Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNmrPhysicalSky ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCmapSize  = [166,40]
  local LOCpreviewBitmap
  local LOCrenderMap

  fn DYNFUNresetSky =
  (
    if (classOf environmentMap != Physical_Sun___Sky_Environment) then 
    (
      environmentMap = Physical_Sun___Sky_Environment()
    )
    UseEnvironmentMap = true

    DYNFUNresetEnvironmentMap()
    DYNmrPhysicalSky.DYNFUNdisplaySkyParams()
  )

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNdisableSkyControls =
  (
    for i in DYNmrPhysicalSky.controls do i.enabled = false
    DYNmrPhysicalSky.BUDYNreset.enabled = true
  )

  fn DYNFUNdisplaySkyParams =
  (
    if classof environmentMap == Physical_Sun___Sky_Environment then 
    (
      for i in DYNmrPhysicalSky.controls do i.enabled = true
      DYNmrPhysicalSky.CBDYNonOff.checked         = useEnvironmentMap

      if (environmentmap.sun_position_object != undefined) then 
      (
        DYNmrPhysicalSky.PKDYNsunWidget.text      = environmentMap.sun_position_object.Name
      )
      else
      (
        DYNmrPhysicalSky.PKDYNsunWidget.text      = DYNuiResourcesButtons[49]
      )

      DYNmrPhysicalSky.CBDYNsunEnabled.checked    = environmentMap.sun_enabled
      DYNmrPhysicalSky.LBDYNdiskIntensity.enabled = DYNmrPhysicalSky.SPDYNdiskIntensity.enabled = environmentMap.sun_enabled
      DYNmrPhysicalSky.LBDYNdiskSize.enabled      = DYNmrPhysicalSky.SPDYNdiskSize.enabled = environmentMap.sun_enabled
      DYNmrPhysicalSky.LBDYNglowIntensity.enabled = DYNmrPhysicalSky.SPDYNglowIntensity.enabled = environmentMap.sun_enabled

      DYNmrPhysicalSky.CODYNground.color          = environmentMap.ground_color
      DYNmrPhysicalSky.CODYNnight.color           = environmentMap.night_color
      DYNmrPhysicalSky.CODYNtint.color            = environmentMap.tint

      DYNmrPhysicalSky.SPDYNglobalIntensity.value = environmentMap.global_intensity
      DYNmrPhysicalSky.SPDYNdiskSize.value        = environmentMap.sun_disc_scale_percent
      DYNmrPhysicalSky.SPDYNglowIntensity.value   = environmentMap.sun_glow_intensity
      DYNmrPhysicalSky.SPDYNdiskIntensity.value   = environmentMap.sun_disc_intensity
      DYNmrPhysicalSky.SPDYNhaze.value            = environmentMap.haze
      DYNmrPhysicalSky.SPDYNhorHeight.value       = environmentMap.horizon_height_deg
      DYNmrPhysicalSky.SPDYNhorBlur.value         = environmentMap.horizon_blur_deg
      DYNmrPhysicalSky.SPDYNsaturation.value      = environmentMap.saturation

      DYNmrPhysicalSky.SPDYNskyIntensity.value    = environmentMap.sky_intensity
      DYNmrPhysicalSky.SPDYNnightIntensity.value  = environmentMap.night_intensity

      DYNmrPhysicalSky.SPDYNperezHoriz.value      = environmentMap.perez_diffuse_horizontal_illuminance
      DYNmrPhysicalSky.SPDYNperezNormal.value     = environmentMap.perez_direct_normal_illuminance

      DYNmrPhysicalSky.DDDYNpreset.selection      = environmentMap.illuminance_model + 1
      DYNmrPhysicalSky.LBDYNnightIntensity.enabled= DYNmrPhysicalSky.SPDYNnightIntensity.enabled= environmentMap.illuminance_model == 1
      DYNmrPhysicalSky.CODYNnight.enabled         = environmentMap.illuminance_model == 1
      DYNmrPhysicalSky.LBDYNperezHoriz.enabled    = DYNmrPhysicalSky.SPDYNperezHoriz.enabled   = environmentMap.illuminance_model == 2
      DYNmrPhysicalSky.LBDYNperezNormal.enabled   = DYNmrPhysicalSky.SPDYNperezNormal.enabled  = environmentMap.illuminance_model == 2
    )
    else
    (
      DYNFUNdisableSkyControls()
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  checkbox CBDYNonoff pos:[9,9] width:(DYNiniExplorerWidth - 51)

  groupbox GBDYNgroup01      width:(DYNiniExplorerWidth - 21) height:66 pos:[4,30]
  label LBDYNglobalIntensity pos:[13,52] width:95
  spinner SPDYNglobalIntensity pos:[(DYNiniExplorerWidth - 96),49] fieldwidth:60 range:[0,1000000.0,0] scale:0.01
  label LBDYNhaze            pos:[13,73] width:95
  spinner SPDYNhaze          pos:[(DYNiniExplorerWidth - 96),70] fieldwidth:60 range:[0.0,1.0,0.0]  scale:0.01

  groupbox GBDYNgroup02      pos:[4,102] width:(DYNiniExplorerWidth - 21) height:111
  checkbox CBDYNsunEnabled   pos:[13,122] width:158
  label LBDYNdiskIntensity   pos:[13,147] width:95
  label LBDYNdiskSize        pos:[13,168] width:95  
  label LBDYNglowIntensity   pos:[13,189] width:95
  spinner SPDYNdiskIntensity pos:[(DYNiniExplorerWidth - 96),146] fieldwidth:60 range:[0.0,1000000.0,0.0] scale:0.01
  spinner SPDYNdiskSize      pos:[(DYNiniExplorerWidth - 96),167] fieldwidth:60 range:[10,100,0] scale:1 type:#integer
  spinner SPDYNglowIntensity pos:[(DYNiniExplorerWidth - 96),188] fieldwidth:60 range:[0,1000000.0,0] scale:0.01

  groupbox GBDYNgroup07      pos:[4,219] width:(DYNiniExplorerWidth - 21) height:71
  pickbutton PKDYNsunWidget  pos:[13,238] width:(DYNiniExplorerWidth - 38) align:#center  filter:DYNFUNsunPositionerFilter
  button BUDYNcreateSun      pos:[13,260] width:(DYNiniExplorerWidth - 38) align:#center 

  groupbox GBDYNgroup04      pos:[4,296] width:(DYNiniExplorerWidth - 21) height:215
  label LBDYNskyIntensity    pos:[13,316] width:95
  spinner SPDYNskyIntensity  pos:[(DYNiniExplorerWidth - 96),315] fieldwidth:60 range:[0,1000000.0,0]    scale:0.01

  groupbox GBDYNgroup05      pos:[10,340] width:(DYNiniExplorerWidth - 33) height:164
  dropdownlist DDDYNpreset   pos:[19,361] width:(DYNiniExplorerWidth - 51) 

  label LBDYNnightIntensity  pos:[19,390] width:89
  spinner SPDYNnightIntensity pos:[(DYNiniExplorerWidth - 96),389] fieldwidth:30 range:[0,99999997952.0,0]    scale:0.01
  colorpicker CODYNnight ""  pos:[(DYNiniExplorerWidth - 56),387] fieldwidth:20 height:20

  label LBDYNperezHoriz      pos:[19,419] width:(DYNiniExplorerWidth - 51)
  spinner SPDYNperezHoriz    pos:[14,435] fieldwidth:(DYNiniExplorerWidth - 58)  range:[0,999999995904.0,0]    scale:0.01
  
  label LBDYNperezNormal     pos:[19,462] width:(DYNiniExplorerWidth - 51)
  spinner SPDYNperezNormal   pos:[14,478] fieldwidth:(DYNiniExplorerWidth - 58)  range:[0,999999995904.0,0]    scale:0.01

  groupbox GBDYNgroup03      pos:[4,517] width:(DYNiniExplorerWidth - 21) height:89 
  label LBDYNhorBlur         pos:[13,537] width:95
  spinner SPDYNhorBlur       pos:[(DYNiniExplorerWidth - 96),536] fieldwidth:60 range:[0,45.0,0]    scale:0.1
  label LBDYNhorHeight       pos:[13,558] width:95
  spinner SPDYNhorHeight     pos:[(DYNiniExplorerWidth - 96),557] fieldwidth:60 range:[-45,45,0]    scale:0.1
  label LBDYNground          pos:[13,579] width:95
  colorpicker CODYNground "" pos:[(DYNiniExplorerWidth - 98),578] fieldwidth:70 height:20

  groupbox GBDYNgroup06      pos:[4,612] width:(DYNiniExplorerWidth - 21) height:69 
  label LBDYNsaturation      pos:[13,632] width:95
  spinner SPDYNsaturation    pos:[(DYNiniExplorerWidth - 96),631] fieldwidth:60 range:[0,2,0]    scale:0.05
  label LBDYNtint            pos:[13,653] width:95
  colorpicker CODYNtint  ""  pos:[(DYNiniExplorerWidth - 98),652] fieldwidth:70 height:20

  button BUDYNreset          pos:[4,688] width:(DYNiniExplorerWidth - 21) align:#center 


  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNmrPhysicalSky open do
  (
    DYNmrPhysicalSky.title    = DYNuiRolloutNames[28]

    CBDYNonOff.text           = DYNuiResourcesLabels[664]
    BUDYNreset.text           = DYNuiResourcesButtons[13]

    GBDYNgroup01.text         = DYNuiResourcesGroups[79]
    GBDYNgroup02.text         = DYNuiResourcesGroups[80]
    GBDYNgroup03.text         = DYNuiResourcesGroups[81]
    GBDYNgroup04.text         = DYNuiResourcesGroups[82]
    GBDYNgroup05.text         = DYNuiResourcesGroups[151]
    GBDYNgroup06.text         = DYNuiResourcesGroups[152]
    GBDYNgroup07.text         = DYNuiResourcesGroups[153]

    CBDYNsunEnabled.text      = DYNuiResourcesLabels[674]
    LBDYNglobalIntensity.text = DYNuiResourcesLabels[665]
    LBDYNglowIntensity.text   = DYNuiResourcesLabels[253]
    LBDYNdiskSize.text        = DYNuiResourcesLabels[666]
    LBDYNhaze.text            = DYNuiResourcesLabels[255]
    LBDYNsaturation.text      = DYNuiResourcesLabels[259]
    LBDYNhorHeight.text       = DYNuiResourcesLabels[256]
    LBDYNhorBlur.text         = DYNuiResourcesLabels[667]
    LBDYNground.text          = DYNuiResourcesLabels[261]
    LBDYNdiskIntensity.text   = DYNuiResourcesLabels[668]
    LBDYNtint.text            = DYNuiResourcesLabels[669]
    LBDYNskyIntensity.text    = DYNuiResourcesLabels[39]
    LBDYNnightIntensity.text  = DYNuiResourcesLabels[319] + ":"
    LBDYNperezHoriz.text      = DYNuiResourcesLabels[670]
    LBDYNperezNormal.text     = DYNuiResourcesLabels[671]
    DDDYNpreset.items         = #(DYNuiResourcesLabels[672], DYNuiResourcesLabels[673], DYNuiResourcesLabels[675])
    PKDYNsunWidget.text       = DYNuiResourcesButtons[49]
    BUDYNcreateSun.text       = DYNuiResourcesButtons[121]

    DYNFUNdisplaySkyParams()
  )

  on DYNmrPhysicalSky close do
  (
  )

  on CODYNground          changed arg do (try (environmentMap.ground_color           = arg) catch (DYNFUNdisableSkyControls()))
  on CODYNnight           changed arg do (try (environmentMap.night_color            = arg) catch (DYNFUNdisableSkyControls()))
  on SPDYNglobalIntensity changed arg do (try (environmentMap.global_intensity       = arg) catch (DYNFUNdisableSkyControls()))
  on SPDYNdiskSize        changed arg do (try (environmentMap.sun_disc_scale_percent = arg) catch (DYNFUNdisableSkyControls()))
  on SPDYNglowIntensity   changed arg do (try (environmentMap.sun_glow_intensity     = arg) catch (DYNFUNdisableSkyControls()))
  on SPDYNhaze            changed arg do (try (environmentMap.haze                   = arg) catch (DYNFUNdisableSkyControls()))
  on SPDYNsaturation      changed arg do (try (environmentMap.saturation             = arg) catch (DYNFUNdisableSkyControls()))
  on SPDYNhorHeight       changed arg do (try (environmentMap.horizon_height_deg     = arg) catch (DYNFUNdisableSkyControls()))
  on SPDYNhorBlur         changed arg do (try (environmentMap.horizon_blur_deg       = arg) catch (DYNFUNdisableSkyControls()))
  on SPDYNdiskIntensity   changed arg do (try (environmentMap.sun_disc_intensity     = arg) catch (DYNFUNdisableSkyControls()))
  on CODYNtint            changed arg do (try (environmentMap.tint                   = arg) catch (DYNFUNdisableSkyControls()))

  on CBDYNsunEnabled      changed arg do 
  (
    try 
    (
      environmentMap.sun_enabled = arg
      LBDYNdiskIntensity.enabled = SPDYNdiskIntensity.enabled = arg 
      LBDYNdiskSize.enabled      = SPDYNdiskSize.enabled = arg 
      LBDYNglowIntensity.enabled = SPDYNglowIntensity.enabled = arg
    ) 
    catch (DYNFUNdisableSkyControls())
  )
   
  on SPDYNskyIntensity    changed arg do (try (environmentMap.sky_intensity          = arg) catch (DYNFUNdisableSkyControls()))
  on SPDYNnightIntensity  changed arg do (try (environmentMap.night_intensity        = arg) catch (DYNFUNdisableSkyControls()))

  on SPDYNperezHoriz      changed arg do (try (environmentMap.perez_diffuse_horizontal_illuminance = arg) catch (DYNFUNdisableSkyControls()))
  on SPDYNperezNormal     changed arg do (try (environmentMap.perez_direct_normal_illuminance = arg) catch (DYNFUNdisableSkyControls()))

  on CBDYNonOff       changed val do
  (
    useEnvironmentMap = val
    if val == false then DYNamite.dnSkyNode.forecolor = DYNFUNdnColor (DYNINIgreyedOutColor) else DYNamite.dnSkyNode.forecolor = DYNFUNdnColor (((colorMan.getColor #text) as color) * 255)
  )

  on DDDYNpreset selected arg do
  (
    try 
    (
      environmentMap.illuminance_model = arg - 1
      LBDYNnightIntensity.enabled = SPDYNnightIntensity.enabled = environmentMap.illuminance_model == 1
      CODYNnight.enabled          = environmentMap.illuminance_model == 1
      LBDYNperezHoriz.enabled     = SPDYNperezHoriz.enabled     = environmentMap.illuminance_model == 2
      LBDYNperezNormal.enabled    = SPDYNperezNormal.enabled    = environmentMap.illuminance_model == 2
    ) 
    catch (DYNFUNdisableSkyControls())
  )
  
  on BUDYNcreateSun pressed do 
  (
    try
    (
      local LOCnewSun = Sun_Positioner pos:objects.center
      environmentMap.sun_position_object = LOCnewSun
    )
    catch ()
    DYNFUNdisplaySkyParams()
  )

  on PKDYNsunWidget picked arg do
  (
    try (environmentMap.sun_position_object = arg) catch ()
    DYNFUNdisplaySkyParams()
  )

  on BUDYNreset pressed do
  (
    DYNFUNresetSky()
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCaFqJnYIJZX1BdSN/BtoxI49v2M0i2754l
-- 0AD6XysR6q0iKQuQTFbyJf9JDTsQUfvSyxz91rHz70ui3DG17EqOTnWQk2Km65wm
-- 8IUfwZRpXDlrstz06F49VInExP352LrbotgUmeRWy6fmeNo947ELyOlVEvwUJek2
-- pRA9ApZb2HZJchkZxk2+mz0i1urqCFQeasXWsK+xgLoWwgmP7YDbTavVdzoA55vn
-- 5/Bu1HTmPAF2Rbye9H0PvKRqVXclL/lL/WtE85ap9r2d68bosBEn0490MGU/tFI0
-- E1ltSKNmZJZwvyZP/T4Uolc9Hak8ZYGc3vKk7r3+EIBe7SF4NUse
-- -----END-SIGNATURE-----