--
-- � Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNmatEditor ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCchanList = #()
  local LOCmapSize  = [175,120]
  local LOCmatName

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNupdateMatPanel FUNselectedChannel =
  (
    local LOCsceneMats = sceneMaterials
    DYNmatEditor.LOCmatName = substring DYNamite.dnExplorer.selectedNode.name 2 -1
    if LOCsceneMats[DYNmatEditor.LOCmatName] != undefined then
    (
      DYNmatEditor.GBDYNgroup05.text         = DYNmatEditor.LOCmatName
      DYNmatEditor.LOCchanList               = (DYNFUNgetMatChannelNames LOCsceneMats[DYNmatEditor.LOCmatName] true false DYNINImatIDlimit)
      DYNmatEditor.MLDYNchanList.items       = DYNmatEditor.LOCchanList
      DYNmatEditor.LBDYNheading.text         = LOCsceneMats[DYNmatEditor.LOCmatName].name
      DYNmatEditor.SPDYNvehBody.value        = rootNode.DYNrootNodeStore.vehRayAmount
      DYNmatEditor.CKDYNvehBody.checked      = rootNode.DYNrootNodeStore.vehRayTrace
      if rootNode.DYNrootNodeStore.vehRayTrace then DYNmatEditor.SPDYNvehBody.enabled = true else DYNmatEditor.SPDYNvehBody.enabled = false
      if LOCsceneMats[DYNmatEditor.LOCmatName].count > 0 then
      (
        DYNmatEditor.BMDYNdiffMap.bitmap     = DYNFUNrenderMatMap (DYNiniExplorerWidth - 21) DYNmatEditor.LOCmapSize.y LOCsceneMats[DYNmatEditor.LOCmatName] FUNselectedChannel
        DYNmatEditor.MLDYNchanList.selection = FUNselectedChannel
      )
      DYNmatEditor.SPMATmarkBlur.value       = rootNode.DYNrootNodeStore.markBlur
      DYNmatEditor.MLDYNchanList.enabled     = true

      if DYNmatEditor.LOCmatName == DYNmatNameRails or DYNmatEditor.LOCmatName == DYNmatNameSurfaces or DYNmatEditor.LOCmatName == DYNmatNameVehicles or DYNmatEditor.LOCmatName == DYNmatNameBuildings then
      (
        DYNmatEditor.BUDYNaddChannel.enabled = true
      )
      else
      (
        DYNmatEditor.BUDYNaddChannel.enabled = false
      )
    )
    else
    (
      DYNmatEditor.MLDYNchanList.enabled = false
      DYNmatEditor.BUDYNaddChannel.enabled = false
    )

    if DYNmatEditor.LOCmatName == DYNmatNameVehicles then
    (
      DYNmatEditor.GBDYNgroup01.visible = true
      DYNmatEditor.CKDYNvehBody.visible = true
      DYNmatEditor.LBDYNvehBody.visible = true
      DYNmatEditor.SPDYNvehBody.visible = true
    )

    if DYNmatEditor.LOCmatName == DYNmatNameMarkings then
    (
      DYNmatEditor.GBDYNgroup04.visible = true
      DYNmatEditor.LBMATmarkBlur.visible = true
      DYNmatEditor.SPMATmarkBlur.visible = true
    )

    DYNmatEditor.CKDYNvehBody.enabled        = if LOCsceneMats[DYNmatNameVehicles] == undefined then false else true
    DYNmatEditor.LBDYNvehBody.enabled        = DYNmatEditor.SPDYNvehBody.enabled     = if LOCsceneMats[DYNmatNameVehicles] == undefined then false else true
    DYNmatEditor.LBMATmarkBlur.enabled       = DYNmatEditor.SPMATmarkBlur.enabled    = if LOCsceneMats[DYNmatNameMarkings] == undefined then false else true
    DYNmatEditor.BUDYNresetMaterial.enabled  = if DYNmatEditor.LOCmatName == DYNmatNameSurfaces or DYNmatEditor.LOCmatName == DYNmatNameVehicles or DYNmatEditor.LOCmatName == DYNmatNameRails then true else false
  )

  fn DYNFUNresetMaterial FUNmatName =
  (
    if FUNmatName == DYNmatNameSurfaces or FUNmatName == DYNmatNameVehicles or FUNmatName == DYNmatNameRails then
    (
      if (queryBox (FUNmatName + "\n\n" + DYNuiResourcesErrorsWarnings[26]) title:DYNuiResourcesTitlebars[2]) then
      (
        undo off
        (
          if sceneMaterials[FUNmatName] != undefined then
          (
            if FUNmatName == DYNmatNameSurfaces then
            (
              local LOColdMat = sceneMaterials[FUNmatName]; LOColdMat.name = "DynamiteTempMat"
              local LOCnewMat = DYNFUNmakeCivilViewSurfaces (DYNglobalMapsPath + DYNfolderNameSurfaceMaps + "\\")
              for i = 1 to objects.count do (if objects[i].material == LOColdMat then objects[i].material = LOCnewMat)
              if DYNmatEditor.open then DYNmatEditor.DYNFUNupdateMatPanel 1
            )
            if FUNmatName == DYNmatNameVehicles then
            (
              local LOColdMat = sceneMaterials[FUNmatName]; LOColdMat.name = "DynamiteTempMat"
              local LOCnewMat = DYNFUNmakeCivilViewVehicles (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameVehicleMaps + "\\")
              for i = 1 to objects.count do (if objects[i].material == LOColdMat then objects[i].material = LOCnewMat)
              if DYNmatEditor.open then DYNmatEditor.DYNFUNupdateMatPanel 1
            )
            if FUNmatName == DYNmatNameRails then
            (
              local LOColdMat = sceneMaterials[FUNmatName]; LOColdMat.name = "DynamiteTempMat"
              local LOCnewMat = DYNFUNmakeCivilViewRails (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameRailMaps + "\\")
              for i = 1 to objects.count do (if objects[i].material == LOColdMat then objects[i].material = LOCnewMat)
              if DYNmatEditor.open then DYNmatEditor.DYNFUNupdateMatPanel 1
            )
          )
        )
        DYNFUNnodeCreatedCallback()
      )
    )
    else
    (
      messagebox (FUNmatName + "\n\n" + DYNuiResourcesErrorsWarnings[25]) title:DYNuiResourcesTitlebars[2] beep:false
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  label   LBDYNheading       align:#center
  label   LBDYNchanList      align:#left pos:[4,26]
  listBox MLDYNchanList      pos:[4,41]  width:(DYNiniExplorerWidth - 21) height:6
  label   LBDYNdiffMap       align:#left pos:[4,134]
  bitmap  BMDYNdiffMap       pos:[4,150] width:(DYNiniExplorerWidth - 21) height:LOCmapSize.y pos:[3,100]

  groupBox GBDYNgroup05      pos:[4,276] width:(DYNiniExplorerWidth - 21) height:97
  button BUDYNaddChannel     pos:[13,295] width:(DYNiniExplorerWidth - 39)
  button BUDYNresetMaterial  pos:[13,319] width:(DYNiniExplorerWidth - 39)
  button BUDYNMaterialEditor pos:[13,343] width:(DYNiniExplorerWidth - 39)

  groupBox GBDYNgroup01      pos:[4,377] width:(DYNiniExplorerWidth - 21) height:61 visible:false
  checkbox CKDYNvehBody      pos:[13,396] width:(DYNiniExplorerWidth - 33) visible:false
  label LBDYNvehBody         pos:[13,417] visible:false
  spinner  SPDYNvehBody      type:#integer range:[0,100,0] align:#right pos:[(DYNiniExplorerWidth - 96),416] fieldwidth:60 visible:false

  groupBox GBDYNgroup04      pos:[4,377] width:(DYNiniExplorerWidth - 21) height:40 visible:false
  label    LBMATmarkBlur     pos:[13,397] visible:false align:#left
  spinner  SPMATmarkBlur     fieldwidth:60 type:#float range:[0.01,100.0,0.0] scale:0.05 pos:[(DYNiniExplorerWidth - 96),396] visible:false

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNmatEditor open do
  (
    DYNmatEditor.title       = DYNuiRolloutNames[8]
    GBDYNgroup01.text        = DYNuiResourcesGroups[30]
    GBDYNgroup04.text        = DYNuiResourcesGroups[31]
    LBDYNchanList.text       = DYNuiResourcesLabels[96]
    LBDYNdiffMap.text        = DYNuiResourcesLabels[97]
    CKDYNvehBody.text        = DYNuiResourcesLabels[98]
    LBDYNvehBody.text        = DYNuiResourcesLabels[99]
    LBMATmarkBlur.text       = DYNuiResourcesLabels[101]
    BUDYNaddChannel.text     = DYNuiResourcesButtons[45]
    BUDYNresetMaterial.text  = DYNuiResourcesButtons[46]
    BUDYNMaterialEditor.text = DYNuiResourcesButtons[47]

    DYNmatEditor.DYNFUNupdateMatPanel 1
  )

  on DYNmatEditor close do
  (
  )

  on SPMATmarkBlur entered do
  (
    local LOCsceneMats = sceneMaterials
    rootNode.DYNrootNodeStore.markBlur = SPMATmarkBlur.value
    if LOCsceneMats[DYNmatNameMarkings] != undefined then
    (
      for i = 1 to LOCsceneMats[DYNmatNameMarkings].count do
      (
        if classOf LOCsceneMats[DYNmatNameMarkings][i] == PhysicalMaterial  then (try (LOCsceneMats[DYNmatNameMarkings][i].cutout_map.coords.blur = rootNode.DYNrootNodeStore.markBlur) catch ())
        if classOf LOCsceneMats[DYNmatNameMarkings][i] == Arch___Design__mi then (try (LOCsceneMats[DYNmatNameMarkings][i].cutOut_map.coords.blur = rootNode.DYNrootNodeStore.markBlur) catch ())
        if classOf LOCsceneMats[DYNmatNameMarkings][i] == StandardMaterial  then (try (LOCsceneMats[DYNmatNameMarkings][i].opacityMap.coords.blur = rootNode.DYNrootNodeStore.markBlur) catch ())
      )
    )
  )

  on SPDYNvehBody entered do
  (
    local LOCsceneMats = sceneMaterials
    rootNode.DYNrootNodeStore.vehRayAmount = SPDYNvehBody.value
    if LOCsceneMats[DYNmatNameVehicles] != undefined then
    (
      for i = 1 to 9 do
      (
        try (LOCsceneMats[DYNmatNameVehicles][i].reflectionMapAmount = rootNode.DYNrootNodeStore.vehRayAmount) catch ()
      )
    )
  )

  on BUDYNaddChannel pressed do
  (
    if LOCmatName == DYNmatNameSurfaces or LOCmatName == DYNmatNameVehicles or LOCmatName == DYNmatNameBuildings or LOCmatName == DYNmatNameRails then
    (
      local LOCsceneMats = sceneMaterials
      if LOCsceneMats[LOCmatName] != undefined then
      (
        --- Select bitmap, then if selected folder was not standard country kit folder for this map type, ask if user wants to copy image to correct folder
        local LOCfilePath
        if LOCmatName == DYNmatNameSurfaces  then LOCfilePath = (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameSurfaceMaps + "\\")
        if LOCmatName == DYNmatNameVehicles  then LOCfilePath = (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameVehicleMaps + "\\")
        if LOCmatName == DYNmatNameBuildings then LOCfilePath = (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameBuildingMaps + "\\")
        if LOCmatName == DYNmatNameRails     then LOCfilePath = (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameRailMaps + "\\")
        local LOCnewMap = DYNFUNcopyFileToResourceKitPath (LOCfilePath + "*.gif") DYNuiResourcesTitlebars[13] DYNimageTypes 1

        --- Load selected bitmap file into selected material definition
        if LOCnewMap != undefined then
        (
          local LOCaddCnt = 0
          if LOCmatName == DYNmatNameRails then
          (
            local LOCaddCnt = DYNFUNaddRailMatChannel LOCsceneMats[LOCmatName] LOCnewMap false
          )
          else
          (
            if LOCmatName == DYNmatNameBuildings then
            (
              local LOCaddCnt = DYNFUNAddBuildingMatChannel LOCsceneMats[LOCmatName] LOCnewMap false
            )
            else
            (
              local LOCaddCnt = DYNFUNgeneralAddMatChannel LOCsceneMats[LOCmatName] LOCnewMap false
            )
          )

          DYNFUNnodeCreatedCallback()
          if LOCaddCnt > 0 then DYNFUNupdateMatPanel LOCaddCnt
        )
      )
    )
  )

  on BUDYNMaterialEditor pressed do
  (
    if sceneMaterials[LOCmatName] != undefined then
    (
      local LOCdefSlot = DYNamite.dnExplorer.selectedNode.tag as integer ; if classOf LOCdefSlot != integer then LOCdefSlot = 1
      medit.PutMtlToMtlEditor sceneMaterials[(substring DYNamite.dnExplorer.selectedNode.name 2 -1)] LOCdefSlot
      ActiveMeditSlot = LOCdefSlot
      max mtledit
    )
  )

  on CKDYNvehBody changed arg do
  (
    local LOCsceneMats = sceneMaterials
    rootNode.DYNrootNodeStore.vehRayTrace = arg
    if LOCsceneMats[DYNmatNameVehicles] != undefined then
    (
      if rootNode.DYNrootNodeStore.vehRayTrace then SPDYNvehBody.enabled = true else SPDYNvehBody.enabled = false
      for i = 1 to 9 do
      (
        try (LOCsceneMats[DYNmatNameVehicles][i].reflectionMapEnable = rootNode.DYNrootNodeStore.vehRayTrace) catch ()
      )
    )
  )

  on MLDYNchanList selected arg do
  (
    local LOCsceneMats = sceneMaterials
    BMDYNdiffMap.bitmap = DYNFUNrenderMatMap (DYNiniExplorerWidth - 21) LOCmapSize.y LOCsceneMats[LOCmatName] arg
  )

  on BUDYNresetMaterial pressed do
  (
    DYNFUNresetMaterial LOCmatName
  )
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAA+BwQfk41v/F4WkTwXJgB+t9LAXfvPYWf
-- bAQAbU0Ibi87VGAbtNLEs6szSzuHQNTpjeuYpo9dtJb5A/R0rlzXitcvCX5lqwBH
-- OblSOTAJapzqCUih9AhrzIrXOFY4nCEtxtVMg4K3fze+BoBx2gqyN+QCI8SGN47v
-- Dad45HdRMc1/rXFXbqvIzJwK9M4LDESVad43V8lEh5f3fORAT+p5NkUaudU10Ctl
-- z38M3yApGYE9nPNNWGsDNYtWE4t6q4fdsGFtOts5oU1r4AGqWpMjCNgBHKfOU2fQ
-- igf8RlT5pOObk18GB1baiKmzD3ys6l7p+DhHC84oY9382+0qPFzm
-- -----END-SIGNATURE-----