/*
***************************************************************************************************
***---------------------------------------------------------------------------------------------***
***--  Macroscript Library for Autodesk Civil View                                            --***
***--  � Copyright 2011 Autodesk, Inc. All rights reserved.                                   --***
***---------------------------------------------------------------------------------------------***
***************************************************************************************************
*/

macroscript MCR12dImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_12DIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenCveImportPanel 3
)
macroscript MCRbuildingObjects category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_BUILDINGOBJECTS_TOOLTIP~ silenterrors:true
(
  DYNFUNopenBuildingObjectsPanel()
)
macroscript MCRc3dImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_C3DIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenC3dImportPanel()
)
macroscript MCRchainageText category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_CHAINAGETEXT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenChainageTextTool()
)

macroScript MCRcreateSunPositioner category:~MACRO_CIVILVIEW_CATEGORY~ ButtonText:~MACRO_CREATESUNPOSITIONER_TOOLTIP~ tooltip:~MACRO_CREATESUNPOSITIONER_TOOLTIP~ icon:#("Systems",2)
(
  on execute do
  (
    --- We Need Command Panel to be open whilst doing this
    if not cui.commandPanelOpen then
    (
      local LOCtext = ~MACRO_CREATESUNPOSITIONER_QUERY01~
      LOCtext += "\n\n"
      LOCtext += ~MACRO_CREATESUNPOSITIONER_QUERY02~
      LOCtext += "\n\n"
      LOCtext += ~MACRO_CREATESUNPOSITIONER_QUERY03~
      local LOCanswer = QueryBox LOCtext title:~MACRO_CREATESUNPOSITIONER_TITLEBAR~ beep:false
      if LOCanswer then cui.commandPanelOpen = true
    )

    local LOCnodes = StartObjectCreation Sun_Positioner returnNewNodes:true
  )
  on isChecked return mcrUtils.IsCreating Sun_Positioner
)
macroscript MCRdrapeSpline category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DRAPESPLINE_TOOLTIP~ silenterrors:true
(
  DYNFUNopenDrapeSplineTool()
)
macroscript MCRdsimBearing category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DSIMBEARING_TOOLTIP~ silenterrors:true
(
  DYNFUNpickVPbearing()
)
macroscript MCRdsimImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DSIMIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenDsimImportPanel()
)
macroscript MCRdsimSubstitute category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DSIMSUBSTITUTE_TOOLTIP~ silenterrors:true
(
  DYNFUNopenDsimSubstitutePanel()
)
macroscript MCRdsimSurface category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DSIMSURFACE_TOOLTIP~ silenterrors:true
(
  DYNFUNopenDsimSurfacePanel()
)
macroscript MCRdxfImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_DXFIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenDxfImportPanel()
)
macroscript MCRexplorer category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_EXPLORER_TOOLTIP~ silenterrors:true
(
  if DYNmainFloater == undefined then DYNFUNopenExplorer()
)
macroscript MCRfeatureInterp category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_FEATUREINTERP_TOOLTIP~ silenterrors:true
(
  DYNFUNopenFeatureInterpPanel()
)
macroscript MCRgenioImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_GENIOIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenCveImportPanel 1
)
macroscript MCRgRailObjects category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_GRAILOBJECTS_TOOLTIP~ silenterrors:true
(
  DYNFUNopengRailObjectsPanel()
)
macroscript MCRimportMan category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_IMPORTMAN_TOOLTIP~ silenterrors:true
(
  DYNFUNopenImportManDialog()
)
macroscript MCRlandXMLimport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_LANDXMLIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenCveImportPanel 4
)
macroscript MCRmakeForest category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_MAKEFOREST_TOOLTIP~ silenterrors:true
(
  DYNFUNmakeForest()
)
macroscript MCRmxImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_MXIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenCveImportPanel 2
)
macroscript MCRobjectPlacer category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_OBJECTPLACER_TOOLTIP~ silenterrors:true
(
  DYNFUNopenObjectPlacerPanel()
)
macroscript MCRopenHelp category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_OPENHELP_TOOLTIP~ silenterrors:true
(
  DYNFUNopenHelp 13201 -- id_cv_civil_view_welcome 
)
macroscript MCRopenTutorials category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_OPENTUTORIALS_TOOLTIP~ silenterrors:true
(
  DYNFUNopenTutorials 13223 -- id_cv_tutorials
)
macroscript MCRplacedMan category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_PLACEDMAN_TOOLTIP~ silenterrors:true
(
  DYNFUNopenPlacedManDialog()
)
macroscript MCRPointBasedPlace category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_POINTBASEDPLACE_TOOLTIP~ silenterrors:true
(
  DYNFUNopenpointBasedPlaceTool()
)
macroscript MCRpreferences category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_PREFERENCES_TOOLTIP~ silenterrors:true
(
  DYNFUNopenPreferencesPanel 1
)
macroscript MCRproperties category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_PROPERTIES_TOOLTIP~ silenterrors:true
(
  DYNFUNopenPropertiesPanel()
)
macroscript MCRqparImport category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_QPARIMPORT_TOOLTIP~ silenterrors:true
(
  DYNFUNopenQparImportPanel()
)
macroscript MCRresourceMan category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_RESOURCEMAN_TOOLTIP~ silenterrors:true
(
  DYNFUNopenResourceManager 4 ""
)
macroscript MCRroadMarkings category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_ROADMARKINGS_TOOLTIP~ silenterrors:true
(
  DYNFUNopenRoadMarkingsPanel()
)
macroscript MCRsightTool category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_SIGHTTOOL_TOOLTIP~ silenterrors:true
(
  DYNFUNopenSightToolPanel()
)
macroscript MCRsplineMapper category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_SPLINEMAPPER_TOOLTIP~ silenterrors:true
(
  DYNFUNopenSplineMapperTool()
)
macroscript MCRsweptObjects category:~MACRO_CIVILVIEW_CATEGORY~ tooltip:~MACRO_SWEPTOBJECTS_TOOLTIP~ silenterrors:true
(
  DYNFUNopenSweptObjectsPanel()
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBk4l0wcXXwOYm+GFxpzmTgGGz4F+x3Joc1
-- oYhx/KfdteDHSz5PY8b66MlWXiyFR8Js9LscaEW0gGXgFLbsIN7QOF3tRWZrsZTl
-- hg1Om3gOG2Ob515rijh4pSY7h/VW0W3ZUmA+ZiczQcDjKv5P6hqX0GkB6oYc2jBw
-- 3MsatUHEQafgXjVb7ROGvw5A8BNWwVcjAOQ1AfrXpmmgBjEHs35SFtTw013JVtN9
-- q00TKwYngzjd8rfs2w0KQNpNZJboXScwvdp0IM18/SlR+k1A1lHdfwk2RaDlUSRZ
-- FR1vmQarWNKNIJ4ifzkbQLpstqY28GJ/KS1g2BsGqTdQNQ68YfI/
-- -----END-SIGNATURE-----