--
-- � Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNlightList ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCheader
  local LOClightMenu

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNinitialiseLightList FUNLightNode =
  (
    --- Always Select Light Node in Explorer Panel If LightList Rollout Is Open
    DYNamite.dnExplorer.selectedNode = FUNLightNode
    FUNLightNode.ensureVisible()

    --- Setup DotNET ListView
    DYNFUNdnListViewStyle DYNlightList.dnLights false true
    DYNlightList.dnLights.multiSelect        = false
    DYNlightList.dnLights.AllowColumnReorder = false
    DYNlightList.dnLights.sorting            = DYNdnSortOrderClass.none
    DYNlightList.dnLights.smallImageList     = DYNdnSmImageList
    local LOCcol1 = DYNlightList.dnLights.Columns.add DYNuiResourcesLvColumns[42] (DYNiniExplorerWidth - 129); LOCcol1.textAlign = DYNdnHorAlignClass.left
    local LOCcol2 = DYNlightList.dnLights.Columns.add DYNuiResourcesLvColumns[43]                          35; LOCcol2.textAlign = DYNdnHorAlignClass.center
    local LOCcol3 = DYNlightList.dnLights.Columns.add DYNuiResourcesLvColumns[44]                          50; LOCcol3.textAlign = DYNdnHorAlignClass.center
  )

  --- What To Do When A Specific Light Is Selected
  fn DYNFUNdisplayLightParams FUNlight =
  (
    if isValidNode FUNlight then
    (
      try (removeRollout DYNstdLight) catch ()
      try (removeRollout DYNsunLight) catch ()
      try (removeRollout DYNskyLight) catch ()
      try (removeRollout DYNsunLight) catch ()

      --- Update LightList Panel
      if DYNLightList.open then
      (
        DYNlightList.CPDYNwirecolor.color = FUNlight.wirecolor

        local LOClistItem = DYNFUNfindListViewItemByTag DYNlightList.dnLights (FUNlight.inode.handle as string)
        if LOClistItem != undefined then
        (
          LOClistItem.selected = true
          LOClistItem.ensureVisible()
        )
      )

      --- Display Light Parameters Panel For Selected Light
      if classOf FUNlight == IES_Sky or classOf FUNlight == SkyLight then
      (
        addrollout DYNsunLight DYNmainFloater rolledup:false
        DYNsunLight.DYNFUNskyParams FUNlight
      )

      if ClassOf FUNlight == omniLight or ClassOf FUNlight == targetSpot or \
         ClassOf FUNlight == TargetDirectionallight or ClassOf FUNlight == Target_Point or \
         ClassOf FUNlight == Target_Linear or ClassOf FUNlight == Target_Area or \
         ClassOf FUNlight == freeSpot or ClassOf FUNlight == Free_Area or \
         ClassOf FUNlight == Free_Linear or ClassOf FUNlight == Free_Point or \
         ClassOf FUNlight == Directionallight or ClassOf FUNlight == IES_Sun or \
         ClassOf FUNlight == miAreaLightomni or ClassOf FUNlight == miAreaLight then
      (
        addrollout DYNstdLight DYNmainFloater rolledup:false
        DYNstdLight.DYNFUNlightParams FUNlight
      )
    )
    DYNlightList.dnLights.refresh()
  )

  fn DYNFUNdisplayLights =
  (
    DYNlightList.dnLights.Items.clear()

    local LOClights  = (DYNFUNgetCivilViewCategorizedNodeArrays "nodes" false)[21]

    --- Remove sun positioner and items which exist in daylight assemblies
    local LOCexcludeList = DYNFUNgetDaylightMembers "nodes"
    for i in LOCexcludeList do (if findItem LOClights i > 0 then deleteItem LOClights (findItem LOClights i))

    ---DotNet Version
    local LOClistItemRange = #()
    DYNlightList.dnLights.beginUpdate()
    DYNlightList.dnLights.suspendLayout()
    for i in LOClights do
    (
      local LOClistItem      = dotNetObject "System.Windows.Forms.ListViewItem" i.name
      LOClistItem.ImageIndex = 25
      /*
      "lights.ico"      -- 25
      "sun.ico"         -- 26  -- 10 = "Sun.ico"
      "dirtarg.ico"     -- 27  -- 4  = "DirTarg.ico"
      "omni.ico"        -- 28  -- 7  = "Omni.ico"
      "AreaFree.ico"    -- 45  -- 1  = "AreaFree.ico"
      "AreaTarg.ico"    -- 46  -- 2  = "AreaTarg.ico"
      "DirFree.ico"     -- 47  -- 3  = "DirFree.ico"
      "LinFree.ico"     -- 48  -- 5  = "LinFree.ico"
      "LinTarg.ico"     -- 49  -- 6  = "LinTarg.ico"
      "SpotFree.ico"    -- 50  -- 8  = "SpotFree.ico"
      "SpotTarg.ico"    -- 51  -- 9  = "SpotTarg.ico"
      */
      if ClassOf i == omniLight              then LOClistItem.ImageIndex = 28
      if ClassOf i == targetSpot             then LOClistItem.ImageIndex = 51
      if ClassOf i == TargetDirectionallight then LOClistItem.ImageIndex = 27
      if ClassOf i == Target_Point           then LOClistItem.ImageIndex = 51
      if ClassOf i == Target_Linear          then LOClistItem.ImageIndex = 49
      if ClassOf i == Target_Area            then LOClistItem.ImageIndex = 46
      if ClassOf i == freeSpot               then LOClistItem.ImageIndex = 50
      if ClassOf i == Free_Area              then LOClistItem.ImageIndex = 45
      if ClassOf i == Free_Linear            then LOClistItem.ImageIndex = 48
      if ClassOf i == Free_Point             then LOClistItem.ImageIndex = 50
      if ClassOf i == Directionallight       then LOClistItem.ImageIndex = 47
      if ClassOf i == Skylight               then LOClistItem.ImageIndex = 26
      if ClassOf i == IES_Sun                then LOClistItem.ImageIndex = 26
      if ClassOf i == IES_Sky                then LOClistItem.ImageIndex = 26
      if ClassOf i == miAreaLightomni        then LOClistItem.ImageIndex = 45
      if ClassOf i == miAreaLight            then LOClistItem.ImageIndex = 45
      if ClassOf i == VRayLight              then LOClistItem.ImageIndex = 45
      if ClassOf i == VRaySun                then LOClistItem.ImageIndex = 26
      LOClistItem.tag        = i.inode.handle as string

      local LOCsubItem  = LOClistItem.SubItems.add ""
      if isProperty i #multiplier  then LOCsubItem.text = i.multiplier as string

      local LOCsubItem  = LOClistItem.SubItems.add ""
      if isProperty i.baseObject #castShadows then LOCsubItem.text = i.baseObject.castShadows as string

      append LOClistItemRange LOClistItem
    )
    DYNlightList.dnLights.Items.AddRange LOClistItemRange
    DYNlightList.dnLights.endUpdate()
    DYNlightList.dnLights.resumeLayout()
    DYNlightList.dnLights.refresh()

    DYNlightList.LBDYNtitle.text = DYNuiResourcesLabels[106] + " (" + (DYNlightList.dnLights.Items.count as string) + ")"

    --- Advanced Lighting Controls
    if classOf sceneRadiosity.radiosity == UndefinedClass then DYNlightList.DDDYNadvanced.selection = 1
    if classOf sceneRadiosity.radiosity == Light_Tracer   then DYNlightList.DDDYNadvanced.selection = 2
    if classOf sceneRadiosity.radiosity == Radiosity      then DYNlightList.DDDYNadvanced.selection = 3

    --- Set Up Advanced Lights List
    if (DYNFUNisVueOrScanlineProductionRenderer()) then
    (
      DYNlightList.DDDYNadvanced.enabled     = true
      DYNlightList.BUDYNadvancedEdit.enabled = (classOf sceneRadiosity.radiosity != undefinedClass)
    )
    else
    (
      DYNlightList.DDDYNadvanced.enabled     = false
      DYNlightList.BUDYNadvancedEdit.enabled = false
    )
  )

  fn DYNFUNupdateLightInstances FUNlight =
  (
    local LOCinstances
    Instancemgr.getInstances FUNlight &LOCinstances

    for i in LOCinstances do
    (
      if isValidNode i then
      (
      local LOClistItem = DYNFUNfindListViewItemByTag DYNlightList.dnLights (i.inode.handle as string)
      if LOClistItem != undefined then
      (
        LOClistItem.SubItems.Item[1].text = if isProperty i #multiplier  then (i.multiplier as string) else ""
        LOClistItem.SubItems.Item[2].text = if isProperty i.baseObject #castShadows then (i.baseObject.castShadows as string) else ""
      )
    )
  )
  )

  fn DYNFUNmsgPopupMenu =
  (
    DYNlightList.LOClightMenu = undefined
    if DYNlightList.dnLights.selectedItems.count > 0 then
    (
      rcmenu LOClightMenu
      (
        local LOCselNode
        local LOCselHandle

        menuItem  MNDYNrename     checked:false
        separator MNDYNseparate1
        menuItem  MNDYNremove     checked:false

        on LOClightMenu open do
        (
          MNDYNrename.text = DYNuiResourcesMenus[7]
          MNDYNremove.text = DYNuiResourcesMenus[10]
          LOCselNode       = try (maxOps.getNodeByHandle (DYNlightList.dnLights.selectedItems.item[0].tag as integer)) catch ()
        )

        on MNDYNrename picked do
        (
          local LOCnewName = DYNFUNdisplayEditText DYNuiResourcesTitlebars[14] DYNuiResourcesLabels[107] LOCselNode.name
          if LOCnewName != undefined and LOCnewName != "" then
          (
            LOCselNode.name = LOCnewName
            select LOCselNode
          )
          --- Also rename target object
          if (try (LOCselNode.target) catch ()) != undefined then
          (
            LOCselNode.target.name = LOCnewName + DYNuiResourcesNodeNames[2]
          )
        )

        on MNDYNremove    picked do
        (
          if (querybox (DYNuiResourcesQueries[1]) title:DYNuiResourcesTitlebars[2]) then
          (
            if isValidNode LOCselNode then delete LOCselNode
            DYNFUNnodeCreatedCallback()
            if DYNobjHandles[21].count > 0 then (select (maxOps.getNodeByHandle DYNobjHandles[21][1]))
          )
        )

      )
      registerRightClickMenu DYNlightList.LOClightMenu
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  label LBDYNtitle align:#left pos:[7,7]
  colorPicker CPDYNwirecolor height:11 width:15 pos:[(DYNiniExplorerWidth - 34),9]

  dotNetControl dnLights "System.Windows.Forms.ListView" height:130 width:(DYNiniExplorerWidth - 23) align:#center pos:[5,26]

  groupbox GBDYNgroup04 pos:[4,162] width:(DYNiniExplorerWidth - 21) height:45
  colorpicker CODYNambient "" color:ambientcolor height:18 pos:[10,182] width:(DYNiniExplorerWidth - 39)

  groupbox GBDYNgroup02 pos:[4,215] width:(DYNiniExplorerWidth - 21) height:50
  dropdownlist DDDYNadvanced width:(DYNiniExplorerWidth - 80) pos:[13,235]
  button BUDYNadvancedEdit width:42 pos:[(DYNiniExplorerWidth - 64),235]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNlightList open do
  (
    DYNlightList.title     = DYNuiRolloutNames[9]
    GBDYNgroup04.text      = DYNuiResourcesGroups[32]
    GBDYNgroup02.text      = DYNuiResourcesGroups[144]
    BUDYNadvancedEdit.text = DYNuiResourcesButtons[48]
    DDDYNadvanced.items    = #(DYNuiResourcesLabels[102], DYNuiResourcesLabels[103], DYNuiResourcesLabels[104])
    CODYNambient.text      = DYNuiResourcesLabels[105]
    DYNlightList.DYNFUNinitialiseLightList DYNamite.dnlgtNode
    DYNFUNdisplayLights()
  )

  on DYNlightList close do
  (
    dnLights.Items.clear()
  )

  on CODYNambient changed arg do (ambientcolor = arg; redrawViews())

  on dnLights MouseDown arg do
  (
    local LOCitem = dnLights.getItemAt arg.x arg.y

    if LOCitem != undefined then
    (
      if keyboard.controlPressed then
      (
        DYNFUNmsgPopupMenu()
        if LOClightMenu != undefined then popupMenu LOClightMenu
      )
      else
      (
        DYNremovePOLrefreshEnable = false
        local LOCselObj = maxOps.getNodeByHandle (LOCitem.tag as integer)
        if isValidNode LOCselObj then
        (
          select LOCselObj
        )
        else
        (
          DYNFUNdisplayLights()
        )
        DYNremovePOLrefreshEnable = true
      )
    )
  )

  on dnLights MouseUp arg do
  (
    if arg.button == DYNdnmouseClass.right then
    (
      DYNFUNmsgPopupMenu()
      if LOClightMenu != undefined then popupMenu LOClightMenu
    )
  )

  on dnLights ColumnClick arg do
  (
    if dnLights.sorting == DYNdnSortOrderClass.none       then
    (
      dnLights.sorting = DYNdnSortOrderClass.ascending
    )
    else
    (
      if dnLights.sorting == DYNdnSortOrderClass.ascending  then
      (
        dnLights.sorting = DYNdnSortOrderClass.descending
      )
      else
      (
        if dnLights.sorting == DYNdnSortOrderClass.descending then dnLights.sorting = DYNdnSortOrderClass.ascending
      )
    )
    if dnLights.selectedItems.count > 0 then dnLights.selectedItems.item[0].ensureVisible()
  )

  on CPDYNwirecolor changed arg do
  (
    if $ != undefined then
    (
      $.wirecolor = arg
    )
  )

  on DDDYNadvanced selected arg do
  (
    if arg == 1 then sceneRadiosity.radiosity = undefined
    if arg == 2 then sceneRadiosity.radiosity = light_tracer()
    if arg == 3 then sceneRadiosity.radiosity = radiosity()

    if DYNsunLight.open then
    (
      DYNsunLight.CKDYNskyCast.enabled      = (classOf sceneRadiosity.radiosity != Light_Tracer)
      DYNsunLight.SPDYNraysPerSamp.enabled  = (classOf sceneRadiosity.radiosity != Light_Tracer)
      DYNsunLight.SPDYNskyRayBias.enabled   = (classOf sceneRadiosity.radiosity != Light_Tracer)
      DYNsunLight.LBDYNraysPerSamp.enabled  = (classOf sceneRadiosity.radiosity != Light_Tracer)
      DYNsunLight.LBDYNskyRayBias.enabled   = (classOf sceneRadiosity.radiosity != Light_Tracer)
    )
    BUDYNadvancedEdit.enabled = (classOf sceneRadiosity.radiosity != undefinedClass)
  )

  on BUDYNadvancedEdit pressed do sceneRadiosity.showPanel()
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBEauIrPcVYVmpMf4l0jwdryBgC0TQYGmtS
-- RuudmHX+Bo4WIWs8HdrE/6J949tSqAf5h9PIIzydMfvtmcNczQWZEzMtetu9aBft
-- /cgQSqf4LE8iro+iBQuvrA6AHQNX4eiZXqBNbYBj2PoKe5tKHmdx1vOjiXRsrPd1
-- J6rBGbfvmEEMefjOeeQzHy81Afw3KhtgyoWUE1xOVQIymPrPkXypXLPOcG6hMi+d
-- yp3WKVLay9R9uNVWVYy0CwTvK6s0bOu9n1PzXTw4z803uQHg7gYvtCLA//al8SpP
-- tP0hOazY4fXPGFCQiLz/JoldZcNN0NyTYZpgUx/LaMCY1Ef0FguW
-- -----END-SIGNATURE-----