--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNforestParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj
  local LOCtreePath          = ""
  local LOCtreesArray = #()
  local LOCiniArraysUpdateRequired = true
  local LOCresourceKitMode   = 1

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNforestParams FUNobj =
  (
    DYNforestParams.LOCobj = FUNobj

    DYNforestParams.SPDYNheight.value      = FUNobj.heightlist[1]
    DYNforestParams.SPDYNwidth.value       = FUNobj.widthlist[1]
    DYNforestParams.SPDYNscalez.value      = FUNobj.scalezmax - FUNobj.scalezmin
    DYNforestParams.SPDYNscalex.value      = FUNobj.scalexmax - FUNobj.scalexmin
    DYNforestParams.CKDYNlockRatio.checked = FUNobj.scalelock
    DYNforestParams.SPDYNplanes.value      = FUNobj.tempidlist[1] + 1

    if FUNobj.scalelock == false then
    (
      DYNforestParams.SPDYNscalez.enabled = true
      DYNforestParams.LBDYNscalez.enabled = true
    )
    else
    (
      DYNforestParams.SPDYNscalez.enabled = false
      DYNforestParams.LBDYNscalez.enabled = false
    )

    if cameras.count == 0 then
    (
      DYNforestParams.CKDYNlookAt.enabled     = false
      DYNforestParams.DDDYNcamera.enabled     = false
      DYNforestParams.LBDYNcamera.enabled     = false
      DYNforestParams.CKDYNvisability.enabled = false
    )
    else
    (
      DYNforestParams.CKDYNlookAt.enabled     = true
      DYNforestParams.DDDYNcamera.enabled     = true
      DYNforestParams.LBDYNcamera.enabled     = true

      --- Gather List of Camera Objects ---
      local LOCcameraNameArray   = #()
      local LOCcameraHandleArray = #()
      for i = 1 to cameras.count do
      (
        if classof cameras[i] != TargetObject then
        (
          append LOCcameraNameArray   cameras[i].name
          append LOCcameraHandleArray cameras[i].inode.handle
        )
      )

      DYNforestParams.DDDYNcamera.items = LOCcameraNameArray

      if superclassof FUNobj.camera == camera then
      (
        local LOCcamHandle = FUNobj.camera.inode.handle
        DYNforestParams.DDDYNcamera.selection = findItem LOCcameraHandleArray LOCcamHandle
      )
      else
      (
        DYNforestParams.DDDYNcamera.selection = 0
      )
    )

    --- Other Camera Related Settings
    DYNforestParams.CKDYNlookAt.checked = FUNobj.camlook
    DYNforestParams.DDDYNcamera.enabled = FUNobj.camlook
    DYNforestParams.CKDYNvisability.enabled = true
    DYNforestParams.CKDYNvisability.checked = FUNobj.camlimit

    --- Activate Forest Pro specific options
    local LOCclassSwitch = classOf FUNobj == Forest_Pro_3
    DYNforestParams.PKDYNsplineExc.enabled         = LOCclassSwitch
    DYNforestParams.BUDYNsplineExcRemove.enabled   = LOCclassSwitch
    DYNforestParams.PKDYNsurface.enabled           = LOCclassSwitch
    DYNforestParams.BUDYNsurfaceRemove.enabled     = LOCclassSwitch
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupbox GBDYNgroup01 width:(DYNiniExplorerWidth - 21) height:86 pos:[4,7]
  pickbutton PKDYNsplineInc width:(DYNiniExplorerWidth - 39) height:20 pos:[13,22]  filter:DYNFUNclosedShapeFilter
  pickbutton PKDYNsplineExc width:(DYNiniExplorerWidth - 63) height:20 pos:[13,44]  filter:DYNFUNclosedShapeFilter
  button BUDYNsplineExcRemove DYNuiResourcesButtons[22] width:22 height:20 pos:[(DYNiniExplorerWidth - 48),44]
  pickbutton PKDYNsurface width:(DYNiniExplorerWidth - 63) height:20 pos:[13,66]  filter:DYNFUNgeometryFilter
  button BUDYNsurfaceRemove DYNuiResourcesButtons[22] width:22 height:20 pos:[(DYNiniExplorerWidth - 48),66]

  groupbox GBDYNgroup02 width:(DYNiniExplorerWidth - 21) height:87 pos:[4,97]
  checkbox CKDYNvisability  pos:[13,115] width:(DYNiniExplorerWidth - 39) align:#left
  checkbox CKDYNlookAt  pos:[13,136] width:(DYNiniExplorerWidth - 39) align:#left
  dropdownlist DDDYNcamera pos:[76,155] width:(DYNiniExplorerWidth - 105)
  label LBDYNcamera pos:[13,160] width:58

  groupbox GBDYNgroup03 width:(DYNiniExplorerWidth - 21) height:150 pos:[4,189]
  label LBDYNheight pos:[13,209] width:105
  label LBDYNwidth  pos:[13,230] width:105
  label LBDYNscalez pos:[13,251] width:105
  label LBDYNscalex pos:[13,272] width:105
  label LBDYNplanes pos:[13,293] width:105
  spinner SPDYNheight pos:[(DYNiniExplorerWidth - 96),206] type:#worldunits fieldwidth:60 range:[0,1000,0] scale:0.1
  spinner SPDYNwidth  pos:[(DYNiniExplorerWidth - 96),227] type:#worldunits fieldwidth:60 range:[0,1000,0] scale:0.1
  spinner SPDYNscalez pos:[(DYNiniExplorerWidth - 96),248] fieldwidth:60 range:[0,99,0] scale:1
  spinner SPDYNscalex pos:[(DYNiniExplorerWidth - 96),269] fieldwidth:60 range:[0,99,0] scale:1
  spinner SPDYNplanes pos:[(DYNiniExplorerWidth - 96),290] fieldwidth:60 range:[1,2,1] type:#integer
  checkbox CKDYNlockRatio  pos:[18,315] align:#left width:(DYNiniExplorerWidth - 39)

  groupbox GBDYNgroup04 width:(DYNiniExplorerWidth - 21) height:75 pos:[4,343]
  label LBDYNobjName pos:[13,362] width:(DYNiniExplorerWidth - 39)
  button BUDYNotherTypes width:(DYNiniExplorerWidth - 39) pos:[13,381]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNforestParams open do
  (
    DYNforestParams.title = DYNuiRolloutNames[26]
    LOCtreePath           = DYNcountryPath + DYNfolderNameObjLibs + "\\" + DYNfolderNameTrees + "\\"
    GBDYNgroup01.text     = DYNuiResourcesForest[1]
    GBDYNgroup02.text     = DYNuiResourcesForest[2]
    GBDYNgroup03.text     = DYNuiResourcesForest[3]
    GBDYNgroup04.text     = DYNuiResourcesForest[4]
    CKDYNvisability.text  = DYNuiResourcesForest[5]
    CKDYNlookAt.text      = DYNuiResourcesForest[6]
    PKDYNsplineInc.text   = DYNuiResourcesForest[7]
    PKDYNsplineExc.text   = DYNuiResourcesForest[8]
    PKDYNsurface.text     = DYNuiResourcesForest[9]
    LBDYNcamera.text      = DYNuiResourcesForest[10]
    LBDYNheight.text      = DYNuiResourcesForest[11]
    LBDYNwidth.text       = DYNuiResourcesForest[12]
    LBDYNscalez.text      = DYNuiResourcesForest[13]
    LBDYNscalex.text      = DYNuiResourcesForest[14]
    LBDYNplanes.text      = DYNuiResourcesForest[15]
    CKDYNlockRatio.text   = DYNuiResourcesForest[16]
    BUDYNotherTypes.text  = DYNuiResourcesForest[17]
    LOCiniArraysUpdateRequired = true
    DYNFUNforestParams selection[1]
  )

  on DYNforestParams close do
  (
    LOCtreesArray = #()
  )

  on COFORcolor1 changed val do LOCobj.color1 = val
  on COFORcolor2 changed val do LOCobj.color2 = val

  on SPDYNheight changed val do LOCobj.heightlist[1] = val
  on SPDYNwidth changed val do LOCobj.widthlist[1] = val
  on SPDYNscalez changed val do (LOCobj.scalezmin = 100 - (val); LOCobj.scalezmax = 100 + (val))
  on SPDYNscalex changed val do (LOCobj.scalexmin = 100 - (val); LOCobj.scalexmax = 100 + (val))
  on SPDYNplanes changed val do
  (
    LOCobj.tempidlist   = #(val-1)
    if (val-1) == 0 then LOCobj.tempnamelist = #(DYNuiResourcesForest[18])
    if (val-1) == 1 then LOCobj.tempnamelist = #(DYNuiResourcesForest[19])
  )

  on CKDYNvisability changed arg do LOCobj.camlimit = arg
  on CKDYNlookAt changed arg do
  (
    LOCobj.camlook = arg
    DDDYNcamera.enabled = arg
    if arg == true and DDDYNcamera.selection != 0 then LOCobj.camera = getNodeByName DDDYNcamera.selected
  )

  on DDDYNcamera selected arg do
  (
    LOCobj.camera = getNodeByName DDDYNcamera.selected
    LOCobj.camlook = true
  )

  on BUDYNsplineExcRemove pressed do LOCobj.splineexc = undefined
  on BUDYNsurfaceRemove   pressed do LOCobj.surface   = undefined

  on PKDYNsurface picked arg do
  (
    if DYNforestParams.open and arg != LOCobj do
    (
      LOCobj.surface = undefined
      LOCobj.surface = arg
    )
  )

  on CKDYNlockRatio changed arg do
  (
    LOCobj.scalelock = arg
    if arg == false then
    (
      SPDYNscalez.enabled = true
      LBDYNscalez.enabled = true

    )
    else
    (
      SPDYNscalez.enabled = false
      LBDYNscalez.enabled = false
    )
  )

  on PKDYNsplineInc picked arg do
  (
    if DYNforestParams.open do
    (
      LOCobj.splineInc = arg
    )
  )

  on PKDYNsplineExc picked arg do
  (
    if DYNforestParams.open and arg != LOCobj.splineInc do
    (
      LOCobj.splineExc = arg
    )
  )

  on BUDYNotherTypes pressed do
  (
    --- Update Main Object INI File AX Internal Arrays
    if LOCiniArraysUpdateRequired then
    (
      DYNobjectPlacer.DYNFUNmakeINIobjFileArrays()
      LOCiniArraysUpdateRequired = false
    )

    --- Display Tree Selection List
    local LOCnewFile = DYNFUNdisplayListBoxWithMapPreview DYNforestParams DYNuiResourcesLabels[57] "" 3 1 "" "" ""

    if LOCnewFile != "" then
    (
      if (findItem LOCtreesArray LOCnewFile) == 0 then
      (
        --- Update Current Tree Object With New Tree INI Definition
        local LOCsizeArray = DYNFUNobjectINIparams LOCnewFile 3 LOCresourceKitMode
        local LOCmatID = DYNFUNaddTreeMatChannel LOCobj.material LOCsizeArray false
        DYNFUNforestParams LOCobj
        DYNproperties.DYNFUNupdPropertiesPanel()
      )
      else
      (
        undo off
        (
          local LOCnewMatID = findItem LOCtreesArray LOCnewFile
          if LOCobj.baseObject.matID != LOCnewMatID then
          (
            LOCobj.baseObject.matID  = arg
            local LOCsizeArray = DYNFUNobjectINIparams LOCnewFile 3 LOCresourceKitMode
            SPDYNwidth.value   = LOCobj.baseObject.widthlist[1]  = LOCsizeArray[3]
            SPDYNheight.value  = LOCobj.baseObject.heightlist[1] = LOCsizeArray[4]
            SPDYNscalez.value  = DYNINItreeVariation as float; LOCobj.scalezmin = 100 - SPDYNscalez.value; LOCobj.scalezmax = 100 + SPDYNscalez.value
            SPDYNscalex.value  = DYNINItreeVariation as float; LOCobj.scalexmin = 100 - SPDYNscalex.value; LOCobj.scalexmax = 100 + SPDYNscalex.value
            if (getAppData LOCobj 421) == "Dynamite" then
            (
              setAppData LOCobj 423 (LOCobj.baseObject.matID as string)
            )
            DYNFUNforestParams LOCobj
            DYNproperties.DYNFUNupdPropertiesPanel()
          )
        )
      )
    )
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQB0Pg4V5ETBfEtC4yLegBmcBL87o6GkwGdD
-- Mbpvf5o9YGzyyfRoGRCVTRG3pbetw5Kp0oq14uMfvf3ihnIuKSh7e5noeMtBjqB+
-- DERYhcs+XgZutaM6UIQYuRDA1T/W0sVZ6n/jLfQKK9+XKkoonTk0T4EUxLgL4eV3
-- uz3Ev3j4P4+oqoz5t6s/0J9ShqWiZhlnnXZLzQ2/FnaW+DAtpZb0pof8VrM7hsuC
-- gDDdVRQwOCOfEWrGFkhEKYbbKlSKRdInwZDkJM/mSnzXEpXRzdIaJCj87qUqpvad
-- WqInqVkPpzaYwRDBpVDM7/jz3MNPYH234eKHS+8+KEii2wC3F/W2
-- -----END-SIGNATURE-----