--
-- � Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNexposure ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCexp
  local LOCspinStartValue
  local LOCundoState = on

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNsetupExpParams =
  (
    DYNexposure.LOCexp                        = SceneExposureControl.exposureControl
    DYNexposure.GBEXPgroup01.text             = DYNuiResourcesGroups[67]
    DYNexposure.GBEXPgroup02.text             = DYNuiResourcesGroups[22]
    DYNexposure.GBEXPgroup01.pos              = [4, 85]
    DYNexposure.GBEXPgroup02.pos.x            = 4
    DYNexposure.GBEXPgroup01.height           = 62
    DYNexposure.GBEXPgroup02.height           = 83
    DYNexposure.CODYNcolor.pos                = [2141,215]; DYNexposure.CODYNcolor.enabled       = false; DYNexposure.CODYNcolor.color       = color 255 255 255
    DYNexposure.CODYNcolorCustom.pos          = [2141,291]; DYNexposure.CODYNcolorCustom.enabled = false; DYNexposure.CODYNcolorCustom.color = color 255 255 255
    DYNexposure.SPEXPvalue.pos                = [2000,171]
    DYNexposure.SPEXPmidT.pos                 = [2000,192]
    DYNexposure.SPEXPscale.pos                = [2000,213]
    DYNexposure.SPEXPbright.pos               = [2000,103]
    DYNexposure.SPEXPcontr.pos                = [2000,124]
    DYNexposure.DDDYNpreset.pos.x             = 2088
    DYNexposure.RBDYNexpMode.pos.x            = 2019
    DYNexposure.LBEXPbright.pos               = [2019,104]
    DYNexposure.LBEXPcontr.pos                = [2019,125]

    DYNexposure.LBEXPvalue.pos                = [2019,172]
    DYNexposure.LBEXPmidT.pos                 = [2019,193]
    DYNexposure.LBEXPscale.pos                = [2019,214]
    DYNexposure.LBDYN1.pos                    = [2019,201]
    DYNexposure.LBDYN2.pos                    = [2019,228]
    DYNexposure.LBDYN3.pos                    = [2019,255]
    DYNexposure.DDDYN1.pos                    = [2088,197]
    DYNexposure.DDDYN2.pos                    = [2088,224]
    DYNexposure.DDDYN3.pos                    = [2088,251]
    DYNexposure.CBEXPcheck1.pos               = [2019,238]
    DYNexposure.CBEXPcheck2.pos               = [2019,258]
    DYNexposure.CBEXPcheck3.pos               = [2019,278]
    DYNexposure.CBEXPcheck4.pos               = [2019,298]
    DYNexposure.DDDYN1.items                  = #()
    DYNexposure.DDDYN2.items                  = #()
    DYNexposure.DDDYN3.items                  = #()
    DYNexposure.GBEXPgroup02.pos              = [4,153]
    DYNexposure.GBDYNgroup03.pos.x            = 2012
    DYNexposure.GBDYNgroup05.pos.x            = 2012
    DYNexposure.GBDYNgroup04.pos.x            = 2012
    DYNexposure.RBDYNphysicalMode.pos.x       = 2019
    DYNexposure.SPDYNphysicalScale.pos.x      = 2000
    DYNexposure.SPDYNwhitepoint.pos.x         = 2088

    DYNexposure.LBDYNhighlights.pos.x         = 2019
    DYNexposure.SPDYNhighlights.pos.x         = 2088
    DYNexposure.LBDYNmidtones.pos.x           = 2019
    DYNexposure.SPDYNmidtones.pos.x           = 2088
    DYNexposure.LBDYNshadows.pos.x            = 2019
    DYNexposure.SPDYNshadows.pos.x            = 2088
    DYNexposure.LBDYNsaturation.pos.x         = 2019
    DYNexposure.SPDYNsaturation.pos.x         = 2088
    DYNexposure.CBDYNvignetting.pos.x         = 2019
    DYNexposure.SPDYNvignetting.pos.x         = 2088
    DYNexposure.CBDYNusePhysicalCam.pos.x     = 2019
    DYNexposure.LBDYNevCompensation.pos.x     = 2019
    DYNexposure.SPDYNevCompensation.pos.x     = 2088
    DYNexposure.LBDYNexposureValue.pos.x      = 2019
    DYNexposure.LBDYNpreset.pos.x             = 2019
    DYNexposure.SPDYNexposureValue.pos.x      = 2088

    for i in DYNexposure.controls do i.enabled= true
    DYNexposure.DDDYN1.enabled                = false
    DYNexposure.DDDYN2.enabled                = false
    DYNexposure.DDDYN3.enabled                = false

    --- Populate List of Exposure Control Types
    local LOCexpTypeArray = #(DYNuiResourcesLabels[303], DYNuiResourcesLabels[304], DYNuiResourcesLabels[305], DYNuiResourcesLabels[306], DYNuiResourcesLabels[307], DYNuiResourcesLabels[308])
    DYNexposure.DDDYNexposures.items =  LOCexpTypeArray


    if DYNexposure.LOCexp != undefined then
    (
      local isKnownExposureType = false;

      --- For Linear Exposure Controls
      if classof DYNexposure.LOCexp == Linear_Exposure_Control then
      (
        isKnownExposureType = true;

        DYNamite.dnExposeNode.forecolor         = DYNFUNdnColor (if DYNexposure.LOCexp.active then (((colorMan.getColor #text) as color) * 255) else DYNINIgreyedOutColor)
        DYNexposure.CBEXPonOff.checked          = DYNexposure.LOCexp.active
        DYNexposure.CBEXPprocBG.checked         = DYNexposure.LOCexp.processBG

        DYNexposure.DDDYNexposures.selection  = 2
        DYNexposure.GBEXPgroup02.height       = 109
        DYNexposure.SPEXPvalue.pos            = [(DYNiniExplorerWidth - 39),171]
        DYNexposure.CODYNcolor.pos            = [(DYNiniExplorerWidth - 57),215]
        DYNexposure.LBEXPbright.pos           = [13,104]
        DYNexposure.LBEXPcontr.pos            = [13,125]
        DYNexposure.SPEXPbright.pos           = [(DYNiniExplorerWidth - 39),103]
        DYNexposure.SPEXPcontr.pos            = [(DYNiniExplorerWidth - 39),124]
        DYNexposure.SPEXPmidT.pos             = [2159,192]
        DYNexposure.LBEXPmidT.pos             = [2019,193]
        DYNexposure.SPEXPscale.pos            = [(DYNiniExplorerWidth - 39),192]
        DYNexposure.LBEXPscale.pos            = [13,193]
        DYNexposure.LBEXPvalue.pos            = [13,172]
        DYNexposure.CBEXPcheck1.pos           = [13,218]
        DYNexposure.CBEXPcheck2.pos           = [13,238]
        DYNexposure.LBEXPbright.text          = DYNuiResourcesLabels[281]
        DYNexposure.LBEXPcontr.text           = DYNuiResourcesLabels[282]
        DYNexposure.SPEXPbright.range         = [0,200,DYNexposure.LOCexp.brightness]
        DYNexposure.SPEXPcontr.range          = [0,100,DYNexposure.LOCexp.contrast]
        DYNexposure.SPEXPvalue.value          = DYNexposure.LOCexp.exposureValue
        DYNexposure.SPEXPmidT.value           = 0.01; DYNexposure.SPEXPmidT.enabled = false; DYNexposure.LBEXPmidT.enabled = false
        DYNexposure.SPEXPscale.value          = DYNexposure.LOCexp.physicalScale
        DYNexposure.CBEXPcheck1.checked       = DYNexposure.LOCexp.chromaticAdaptation
        DYNexposure.CBEXPcheck2.checked       = DYNexposure.LOCexp.colorDifferentiation
        DYNexposure.CODYNcolor.color          = DYNexposure.LOCexp.whiteColor
      )

      --- For Logarithmic Exposure Control
      if classof DYNexposure.LOCexp == Logarithmic_Exposure_Control then
      (
        isKnownExposureType = true;

        DYNamite.dnExposeNode.forecolor         = DYNFUNdnColor (if DYNexposure.LOCexp.active then (((colorMan.getColor #text) as color) * 255) else DYNINIgreyedOutColor)
        DYNexposure.CBEXPonOff.checked          = DYNexposure.LOCexp.active
        DYNexposure.CBEXPprocBG.checked         = DYNexposure.LOCexp.processBG

        DYNexposure.DDDYNexposures.selection  = 3
        DYNexposure.GBEXPgroup02.height       = 149
        DYNexposure.LBEXPbright.pos           = [13,104]
        DYNexposure.LBEXPcontr.pos            = [13,125]
        DYNexposure.SPEXPbright.pos           = [(DYNiniExplorerWidth - 39),103]
        DYNexposure.SPEXPcontr.pos            = [(DYNiniExplorerWidth - 39),124]
        DYNexposure.CODYNcolor.pos            = [(DYNiniExplorerWidth - 57),215]
        DYNexposure.SPEXPvalue.pos            = [2159,171]
        DYNexposure.SPEXPmidT.pos             = [(DYNiniExplorerWidth - 39),171]
        DYNexposure.SPEXPscale.pos            = [(DYNiniExplorerWidth - 39),192]
        DYNexposure.LBEXPvalue.pos            = [2019,172]
        DYNexposure.LBEXPmidT.pos             = [13,172]
        DYNexposure.LBEXPscale.pos            = [13,193]
        DYNexposure.CBEXPcheck1.pos           = [13,218]
        DYNexposure.CBEXPcheck2.pos           = [13,238]
        DYNexposure.CBEXPcheck3.pos           = [13,258]
        DYNexposure.CBEXPcheck4.pos           = [13,278]
        DYNexposure.LBEXPbright.text          = DYNuiResourcesLabels[281]
        DYNexposure.LBEXPcontr.text           = DYNuiResourcesLabels[282]
        DYNexposure.SPEXPbright.range         = [0,200,DYNexposure.LOCexp.brightness]
        DYNexposure.SPEXPcontr.range          = [0,100,DYNexposure.LOCexp.contrast]
        DYNexposure.SPEXPvalue.value          = 0; DYNexposure.SPEXPvalue.enabled = false; DYNexposure.LBEXPvalue.enabled = false
        DYNexposure.SPEXPmidT.value           = DYNexposure.LOCexp.midTones
        DYNexposure.SPEXPscale.value          = DYNexposure.LOCexp.physicalScale
        DYNexposure.CBEXPcheck1.checked       = DYNexposure.LOCexp.chromaticAdaptation
        DYNexposure.CBEXPcheck2.checked       = DYNexposure.LOCexp.colorDifferentiation
        DYNexposure.CBEXPcheck3.checked       = DYNexposure.LOCexp.indirectOnly
        DYNexposure.CBEXPcheck4.checked       = DYNexposure.LOCexp.exteriorDaylight
        DYNexposure.CODYNcolor.color          = DYNexposure.LOCexp.whiteColor
      )

      --- For Pseudo Color Exposure Control
      if classof DYNexposure.LOCexp == Pseudo_Color_Exposure_Control then
      (
        isKnownExposureType = true;

        DYNamite.dnExposeNode.forecolor         = DYNFUNdnColor (if DYNexposure.LOCexp.active then (((colorMan.getColor #text) as color) * 255) else DYNINIgreyedOutColor)
        DYNexposure.CBEXPonOff.checked          = DYNexposure.LOCexp.active
        DYNexposure.CBEXPprocBG.checked         = DYNexposure.LOCexp.processBG

        DYNexposure.DDDYNexposures.selection  = 4
        DYNexposure.GBEXPgroup02.height       = 126
        DYNexposure.CBEXPcheck1.pos           = [2019,238]
        DYNexposure.CODYNcolor.pos            = [2141,215]; DYNexposure.CODYNcolor.enabled = false
        DYNexposure.LBEXPbright.pos           = [13,104]
        DYNexposure.LBEXPcontr.pos            = [13,125]
        DYNexposure.SPEXPbright.pos           = [(DYNiniExplorerWidth - 39),103]
        DYNexposure.SPEXPcontr.pos            = [(DYNiniExplorerWidth - 39),124]
        DYNexposure.CBEXPcheck2.pos           = [2019,258]
        DYNexposure.SPEXPvalue.pos            = [2109,171]
        DYNexposure.SPEXPmidT.pos             = [2109,192]
        DYNexposure.SPEXPscale.pos            = [(DYNiniExplorerWidth - 39),171]
        DYNexposure.LBEXPvalue.pos            = [2019,172]
        DYNexposure.LBEXPmidT.pos             = [2019,193]
        DYNexposure.LBEXPscale.pos            = [13,172]
        DYNexposure.LBDYN1.pos                = [13,201]
        DYNexposure.LBDYN2.pos                = [13,228]
        DYNexposure.LBDYN3.pos                = [13,255]
        DYNexposure.DDDYN1.pos                = [(DYNiniExplorerWidth - 110),197]
        DYNexposure.DDDYN2.pos                = [(DYNiniExplorerWidth - 110),224]
        DYNexposure.DDDYN3.pos                = [(DYNiniExplorerWidth - 110),251]
        DYNexposure.GBEXPgroup01.text         = DYNuiResourcesGroups[93]
        DYNexposure.LBEXPbright.text          = DYNuiResourcesLabels[301]
        DYNexposure.LBEXPcontr.text           = DYNuiResourcesLabels[302]
        DYNexposure.SPEXPbright.range         = [0,200000,DYNexposure.LOCexp.minimum]
        DYNexposure.SPEXPcontr.range          = [0,200000,DYNexposure.LOCexp.maximum]
        DYNexposure.SPEXPvalue.value          = 0   ; DYNexposure.SPEXPvalue.enabled = false;  DYNexposure.LBEXPvalue.enabled = false
        DYNexposure.SPEXPmidT.value           = 0.01; DYNexposure.SPEXPmidT.enabled = false;   DYNexposure.LBEXPmidT.enabled = false
        DYNexposure.SPEXPscale.value          = DYNexposure.LOCexp.physicalScale
        DYNexposure.DDDYN1.items              = #(DYNuiResourcesLabels[318], DYNuiResourcesLabels[319])
        DYNexposure.DDDYN2.items              = #(DYNuiResourcesLabels[320], DYNuiResourcesLabels[321])
        DYNexposure.DDDYN3.items              = #(DYNuiResourcesLabels[322], DYNuiResourcesLabels[323])
        DYNexposure.DDDYN1.enabled            = true
        DYNexposure.DDDYN2.enabled            = true
        DYNexposure.DDDYN3.enabled            = true
        DYNexposure.DDDYN1.selection          = DYNexposure.LOCexp.quantity + 1
        DYNexposure.DDDYN2.selection          = DYNexposure.LOCexp.display + 1
        DYNexposure.DDDYN3.selection          = DYNexposure.LOCexp.scaleFunction + 1
      )

      --- For Automatic Exposure Control
      if classof DYNexposure.LOCexp == Automatic_Exposure_Control then
      (
        isKnownExposureType = true;

        DYNamite.dnExposeNode.forecolor         = DYNFUNdnColor (if DYNexposure.LOCexp.active then (((colorMan.getColor #text) as color) * 255) else DYNINIgreyedOutColor)
        DYNexposure.CBEXPonOff.checked          = DYNexposure.LOCexp.active
        DYNexposure.CBEXPprocBG.checked         = DYNexposure.LOCexp.processBG

        /*
        Sets a physical scale for exposure control to use. This is a light intensity value, in candelas. It can range from 0.0 to 200,000.0.
        The physical scale is factored into light multiplier values, and self-illumination, reflection, and refraction maps. Default=1500.0.
        Decreasing the physical scale dims the scene. Increasing the physical scale increases brightness,
        up to a scale value at which the scene grows no brighter.
        */
        DYNexposure.DDDYNexposures.selection  = 5
        DYNexposure.GBEXPgroup02.height       = 109
        DYNexposure.SPEXPvalue.pos            = [(DYNiniExplorerWidth - 39),171]
        DYNexposure.LBEXPbright.pos           = [13,104]
        DYNexposure.SPEXPbright.pos           = [(DYNiniExplorerWidth - 39),103]
        DYNexposure.SPEXPcontr.pos            = [(DYNiniExplorerWidth - 39),124]
        DYNexposure.LBEXPcontr.pos            = [13,125]
        DYNexposure.CODYNcolor.pos            = [(DYNiniExplorerWidth - 57),215]
        DYNexposure.SPEXPmidT.pos             = [2159,192]
        DYNexposure.LBEXPmidT.pos             = [2019,193]
        DYNexposure.LBEXPvalue.pos            = [13,172]
        DYNexposure.SPEXPscale.pos            = [(DYNiniExplorerWidth - 39),192]
        DYNexposure.LBEXPscale.pos            = [13,193]
        DYNexposure.CBEXPcheck1.pos           = [13,218]
        DYNexposure.CBEXPcheck2.pos           = [13,238]
        DYNexposure.LBEXPbright.text          = DYNuiResourcesLabels[281]
        DYNexposure.LBEXPcontr.text           = DYNuiResourcesLabels[282]
        DYNexposure.SPEXPbright.range         = [0,200,DYNexposure.LOCexp.brightness]
        DYNexposure.SPEXPcontr.range          = [0,100,DYNexposure.LOCexp.contrast]
        DYNexposure.SPEXPvalue.value          = DYNexposure.LOCexp.exposureValue
        DYNexposure.SPEXPmidT.value           = 0.01; DYNexposure.SPEXPmidT.enabled = false;   DYNexposure.LBEXPmidT.enabled = false
        DYNexposure.SPEXPscale.value          = DYNexposure.LOCexp.physicalScale
        DYNexposure.CBEXPcheck1.checked       = DYNexposure.LOCexp.chromaticAdaptation
        DYNexposure.CBEXPcheck2.checked       = DYNexposure.LOCexp.colorDifferentiation
        DYNexposure.CODYNcolor.color          = DYNexposure.LOCexp.whiteColor
      )

      --- For Physical Camera Exposure Control
      if classof DYNexposure.LOCexp == Physical_Camera_Exposure_Control then
      (
        isKnownExposureType = true;

        DYNamite.dnExposeNode.forecolor         = DYNFUNdnColor (if DYNexposure.LOCexp.active then (((colorMan.getColor #text) as color) * 255) else DYNINIgreyedOutColor)
        DYNexposure.CBEXPonOff.checked          = DYNexposure.LOCexp.active
        DYNexposure.CBEXPprocBG.checked         = DYNexposure.LOCexp.processBG

        DYNexposure.DDDYNexposures.selection  = 6

        DYNexposure.CODYNcolorCustom.pos      = [(DYNiniExplorerWidth - 97),291]; DYNexposure.CODYNcolorCustom.enabled = true;
        DYNexposure.GBEXPgroup01.text         = DYNuiResourcesGroups[150]
        DYNexposure.GBEXPgroup02.text         = DYNuiResourcesGroups[92]
        DYNexposure.GBEXPgroup01.pos          = [4, 197]
        DYNexposure.GBEXPgroup02.pos          = [4 ,410]
        DYNexposure.GBEXPgroup01.height       = 206
        DYNexposure.GBEXPgroup02.height       = 108
        DYNexposure.DDDYNpreset.pos.x         = 14
        DYNexposure.RBDYNexpMode.pos.x        = 13
        DYNexposure.SPDYNwhitepoint.pos.x     = (DYNiniExplorerWidth - 39)
        DYNexposure.LBDYNhighlights.pos.x     = 13
        DYNexposure.SPDYNhighlights.pos.x     = (DYNiniExplorerWidth - 39)
        DYNexposure.LBDYNmidtones.pos.x       = 13
        DYNexposure.SPDYNmidtones.pos.x       = (DYNiniExplorerWidth - 39)
        DYNexposure.LBDYNshadows.pos.x        = 13
        DYNexposure.SPDYNshadows.pos.x        = (DYNiniExplorerWidth - 39)
        DYNexposure.LBDYNsaturation.pos.x     = 13
        DYNexposure.SPDYNsaturation.pos.x     = (DYNiniExplorerWidth - 39)

        DYNexposure.CBDYNvignetting.pos.x     = 13
        DYNexposure.SPDYNvignetting.pos.x     = (DYNiniExplorerWidth - 39)

        DYNexposure.GBDYNgroup03.pos.x        = 4
        DYNexposure.GBDYNgroup05.pos.x        = 9
        DYNexposure.GBDYNgroup04.pos.x        = 4
        DYNexposure.RBDYNphysicalMode.pos.x   = 13
        DYNexposure.SPDYNphysicalScale.pos.x  = (DYNiniExplorerWidth - 39)

        DYNexposure.CBDYNusePhysicalCam.pos.x = 13
        DYNexposure.LBDYNevCompensation.pos.x = 13
        DYNexposure.SPDYNevCompensation.pos.x = (DYNiniExplorerWidth - 39)
        DYNexposure.LBDYNexposureValue.pos.x  = 13
        DYNexposure.LBDYNpreset.pos.x         = 16
        DYNexposure.SPDYNexposureValue.pos.x  = (DYNiniExplorerWidth - 39)

        DYNexposure.DDDYNpreset.selection     = DYNexposure.LOCexp.white_balance_illuminant + 1
        DYNexposure.RBDYNexpMode.state        = DYNexposure.LOCexp.white_balance_type + 1

        
        DYNexposure.LBDYNpreset.enabled       = if DYNexposure.LOCexp.white_balance_type == 0 then true else false
        DYNexposure.DDDYNpreset.enabled       = if DYNexposure.LOCexp.white_balance_type == 0 then true else false
        DYNexposure.SPDYNwhitepoint.enabled   = if DYNexposure.LOCexp.white_balance_type == 1 then true else false
        DYNexposure.CODYNcolorCustom.enabled  = if DYNexposure.LOCexp.white_balance_type == 2 then true else false

        DYNexposure.SPDYNhighlights.value     = DYNexposure.LOCexp.highlights
        DYNexposure.SPDYNmidtones.value       = DYNexposure.LOCexp.midtones
        DYNexposure.SPDYNshadows.value        = DYNexposure.LOCexp.shadows
        DYNexposure.SPDYNsaturation.value     = DYNexposure.LOCexp.saturation
        DYNexposure.SPDYNwhitepoint.value     = DYNexposure.LOCexp.white_balance_kelvin
        DYNexposure.CBDYNvignetting.checked   = DYNexposure.LOCexp.vignetting_enabled
        DYNexposure.SPDYNvignetting.enabled   = DYNexposure.LOCexp.vignetting_enabled
        DYNexposure.SPDYNvignetting.value     = DYNexposure.LOCexp.vignetting_amount
        DYNexposure.RBDYNphysicalMode.state   = DYNexposure.LOCexp.physical_scale_mode + 1
        DYNexposure.SPDYNphysicalScale.value  = DYNexposure.LOCexp.physical_scale
        DYNexposure.SPDYNphysicalScale.enabled= if DYNexposure.LOCexp.physical_scale_mode == 0 then false else true
        DYNexposure.CBDYNusePhysicalCam.checked= DYNexposure.LOCexp.use_physical_camera_controls
        DYNexposure.LBDYNevCompensation.enabled = DYNexposure.LOCexp.use_physical_camera_controls
        DYNexposure.SPDYNevCompensation.enabled = DYNexposure.LOCexp.use_physical_camera_controls
        DYNexposure.SPDYNevCompensation.value = DYNexposure.LOCexp.ev_compensation
        DYNexposure.SPDYNexposureValue.value  = DYNexposure.LOCexp.global_ev
        DYNexposure.CODYNcolorCustom.color    = DYNexposure.LOCexp.white_balance_custom
      )

      if isKnownExposureType == false then
      (
        for i in DYNexposure.controls do i.enabled = false
        DYNexposure.LBEXPbright.text            = DYNuiResourcesLabels[281]
        DYNexposure.LBEXPcontr.text             = DYNuiResourcesLabels[282]
        DYNexposure.SPEXPbright.range           = [0,200,0]
        DYNexposure.SPEXPcontr.range            = [0,100,0]
        DYNexposure.DDDYNexposures.enabled      = true
        DYNexposure.DDDYNexposures.selection    = 0 -- indeterminate selection
        DYNexposure.CBEXPonOff.checked          = false
        DYNamite.dnExposeNode.forecolor         = DYNFUNdnColor (DYNINIgreyedOutColor)
        DYNexposure.GBEXPgroup01.pos.x          = 2012
        DYNexposure.GBEXPgroup02.pos.x          = 2012
      )
    )

    if DYNexposure.LOCexp == undefined then
    (
      for i in DYNexposure.controls do i.enabled = false
      DYNexposure.LBEXPbright.text            = DYNuiResourcesLabels[281]
      DYNexposure.LBEXPcontr.text             = DYNuiResourcesLabels[282]
      DYNexposure.SPEXPbright.range           = [0,200,0]
      DYNexposure.SPEXPcontr.range            = [0,100,0]
      DYNexposure.DDDYNexposures.enabled      = true
      DYNexposure.DDDYNexposures.selection    = 1
      DYNexposure.CBEXPonOff.checked          = false
      DYNamite.dnExposeNode.forecolor         = DYNFUNdnColor (DYNINIgreyedOutColor)
      DYNexposure.GBEXPgroup01.pos.x          = 2012
      DYNexposure.GBEXPgroup02.pos.x          = 2012
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  dropdownlist DDDYNexposures align:#left width:(DYNiniExplorerWidth - 21) pos:[4,8]
  checkbox CBEXPonoff  align:#left pos:[4,41]
  checkbox CBEXPprocBG align:#left pos:[4,61]

  --- Std Controls
  groupbox GBEXPgroup01 width:(DYNiniExplorerWidth - 21) height:62 pos:[4,85]
  spinner SPEXPbright pos:[(DYNiniExplorerWidth - 96),103] fieldwidth:60 range:[0,200,0] scale:0.1 align:#left
  spinner SPEXPcontr  pos:[(DYNiniExplorerWidth - 96),124] fieldwidth:60 range:[0,100,0] scale:0.1 align:#left
  label LBEXPbright   pos:[13,104]  width:80 align:#left
  label LBEXPcontr    pos:[13,125]  width:80 align:#left

  groupbox GBEXPgroup02 width:(DYNiniExplorerWidth - 21) height:149 pos:[4,153]
  spinner SPEXPvalue  pos:[(DYNiniExplorerWidth - 96),171] fieldwidth:60 range:[-5,5,0]   scale:0.1 align:#left
  spinner SPEXPmidT   pos:[(DYNiniExplorerWidth - 96),192] fieldwidth:60 range:[0.01,20,0]   scale:0.1 align:#left
  spinner SPEXPscale  pos:[(DYNiniExplorerWidth - 96),213] fieldwidth:60 range:[0.001,200000,100] scale:10.0 align:#left
  label LBEXPvalue    pos:[13,172]  width:80 align:#left
  label LBEXPmidT     pos:[13,193]  width:80 align:#left
  label LBEXPscale    pos:[13,214]  width:80 align:#left
  colorpicker CODYNcolor fieldwidth:30 height:20 pos:[141,215]

  label LBDYN1 align:#left width:70 pos:[19,201]
  label LBDYN2 align:#left width:70 pos:[19,228]
  label LBDYN3 align:#left width:70 pos:[19,255]
  dropdownlist DDDYN1 align:#right width:85 pos:[(DYNiniExplorerWidth - 110),197]
  dropdownlist DDDYN2 align:#right width:85 pos:[(DYNiniExplorerWidth - 110),224]
  dropdownlist DDDYN3 align:#right width:85 pos:[(DYNiniExplorerWidth - 110),251]

  checkbox CBEXPcheck1 align:#left pos:[19,238]
  checkbox CBEXPcheck2 align:#left pos:[19,258]
  checkbox CBEXPcheck3 align:#left pos:[19,278]
  checkbox CBEXPcheck4 align:#left pos:[19,298]

  --- Physical Camera Exposure Control 
  groupbox     GBDYNgroup04          width:(DYNiniExplorerWidth - 21) height:106 pos:[4,85]
  checkbox     CBDYNusePhysicalCam   width:(DYNiniExplorerWidth - 51) align:#left height:40                            pos:[19,98]
  label        LBDYNevCompensation   width:94 align:#left height:40                                                    pos:[19,141]
  spinner      SPDYNevCompensation   type:#float   range:[-100,100,1.0]            fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),152]

  label        LBDYNexposureValue    width:94 align:#left                                                              pos:[19,217]
  spinner      SPDYNexposureValue    type:#float   range:[-100,100.0,1.0]            fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),216]

  groupbox     GBDYNgroup05          width:(DYNiniExplorerWidth - 31) height:125                                       pos:[9,240]
  radioButtons RBDYNexpMode          labels:#(DYNuiResourcesLabels[658], DYNuiResourcesLabels[659] + ":", DYNuiResourcesLabels[621] + ":") pos:[19,260] columns:1
  spinner      SPDYNwhitepoint       type:#float   range:[100.0,1000000000.0,6500.0]  fieldwidth:60 align:#left scale:0.05 pos:[(DYNiniExplorerWidth - 96),274]
  label        LBDYNpreset           width:94 align:#left                                                              pos:[19,314]
  dropdownlist DDDYNpreset           width:(DYNiniExplorerWidth - 41)                                                  pos:[19,330] 
  colorpicker CODYNcolorCustom       fieldwidth:70 height:20                                                           pos:[(DYNiniExplorerWidth - 96),291]

  checkbox     CBDYNvignetting       width:94 align:#left                                                              pos:[19,377]
  spinner      SPDYNvignetting       type:#float   range:[0.0,1000000000.0,0.0]           fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),376]

  label        LBDYNhighlights       width:94 align:#left                                                              pos:[19,430]
  spinner      SPDYNhighlights       type:#float   range:[0.0,1.0,0.25]           fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),429]
  label        LBDYNmidtones         width:94 align:#left                                                              pos:[19,451]
  spinner      SPDYNmidtones         type:#float   range:[0.1,4.0,1.0]            fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),450]
  label        LBDYNshadows          width:94 align:#left                                                              pos:[19,472]
  spinner      SPDYNshadows          type:#float   range:[0.0,1.0,0.2]            fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),471]
  label        LBDYNsaturation       width:94 align:#left                                                              pos:[19,493]
  spinner      SPDYNsaturation       type:#float   range:[0.0,5.0,1.0]            fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),492]

  groupbox     GBDYNgroup03          width:(DYNiniExplorerWidth - 21) height:62                                        pos:[4,526]
  radiobuttons RBDYNphysicalMode     labels:#(DYNuiResourcesLabels[661], DYNuiResourcesLabels[621] + ":")                    pos:[13,546] columns:1 
  spinner      SPDYNphysicalScale    type:#float   range:[0.001,200000.0,1500.0]  fieldwidth:60 align:#left scale:0.01 pos:[(DYNiniExplorerWidth - 96),563]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNexposure open do
  (
    DYNexposure.title          = DYNuiRolloutNames[33]

    DDDYNpreset.items          = #(
      DYNuiResourcesLabels[622], 
      DYNuiResourcesLabels[623], 
      DYNuiResourcesLabels[624], 
      DYNuiResourcesLabels[625], 
      DYNuiResourcesLabels[626], 
      DYNuiResourcesLabels[627], 
      DYNuiResourcesLabels[628], 
      DYNuiResourcesLabels[629], 
      DYNuiResourcesLabels[630], 
      DYNuiResourcesLabels[631], 
      DYNuiResourcesLabels[632], 
      DYNuiResourcesLabels[633], 
      DYNuiResourcesLabels[634], 
      DYNuiResourcesLabels[635], 
      DYNuiResourcesLabels[636], 
      DYNuiResourcesLabels[637], 
      DYNuiResourcesLabels[638], 
      DYNuiResourcesLabels[639], 
      DYNuiResourcesLabels[640], 
      DYNuiResourcesLabels[641], 
      DYNuiResourcesLabels[642], 
      DYNuiResourcesLabels[643], 
      DYNuiResourcesLabels[644], 
      DYNuiResourcesLabels[645], 
      DYNuiResourcesLabels[646], 
      DYNuiResourcesLabels[647], 
      DYNuiResourcesLabels[648], 
      DYNuiResourcesLabels[649], 
      DYNuiResourcesLabels[650], 
      DYNuiResourcesLabels[651], 
      DYNuiResourcesLabels[652], 
      DYNuiResourcesLabels[653], 
      DYNuiResourcesLabels[654], 
      DYNuiResourcesLabels[655], 
      DYNuiResourcesLabels[656], 
      DYNuiResourcesLabels[657]
    )

    GBEXPgroup01.text          = DYNuiResourcesGroups[67]
    GBEXPgroup02.text          = DYNuiResourcesGroups[22]
    GBDYNgroup03.text          = DYNuiResourcesGroups[90]
    GBDYNgroup04.text          = DYNuiResourcesGroups[149]
    GBDYNgroup05.text          = DYNuiResourcesLabels[660]

    LBEXPbright.text           = DYNuiResourcesLabels[281]
    LBEXPcontr.text            = DYNuiResourcesLabels[282]
    LBDYNshadows.text          = DYNuiResourcesLabels[283]
    LBDYNsaturation.text       = DYNuiResourcesLabels[259]
    LBDYN3.text                = DYNuiResourcesLabels[254]
    LBDYN1.text                = DYNuiResourcesLabels[284]
    LBDYN2.text                = DYNuiResourcesLabels[285]
    LBEXPvalue.text            = DYNuiResourcesLabels[286]
    LBEXPmidT.text             = DYNuiResourcesLabels[287]
    LBDYNmidtones.text         = DYNuiResourcesLabels[287]
    LBEXPscale.text            = DYNuiResourcesLabels[288]
    LBDYNhighlights.text       = DYNuiResourcesLabels[662]
    CBDYNvignetting.text       = DYNuiResourcesLabels[294]
    CBEXPonOff.text            = DYNuiResourcesLabels[295]
    CBEXPprocBG.text           = DYNuiResourcesLabels[296]
    CBEXPcheck1.text           = DYNuiResourcesLabels[297]
    CBEXPcheck2.text           = DYNuiResourcesLabels[298]
    CBEXPcheck3.text           = DYNuiResourcesLabels[299]
    CBEXPcheck4.text           = DYNuiResourcesLabels[300]
    CBDYNusePhysicalCam.text   = DYNuiResourcesLabels[618]
    LBDYNevCompensation.text   = DYNuiResourcesLabels[619] + ":"
    LBDYNexposureValue.text    = DYNuiResourcesLabels[620] + ":"
    LBDYNpreset.text           = DYNuiResourcesLabels[658] + ":"

    DYNFUNsetupExpParams()
  )

  on DDDYNexposures selected arg do
  (
    if arg == 1 then SceneExposureControl.exposureControl = undefined
    if arg == 2 then SceneExposureControl.exposureControl = Linear_Exposure_Control()
    if arg == 3 then SceneExposureControl.exposureControl = Logarithmic_Exposure_Control()
    if arg == 4 then SceneExposureControl.exposureControl = Pseudo_Color_Exposure_Control()
    if arg == 5 then SceneExposureControl.exposureControl = Automatic_Exposure_Control()
    if arg == 6 then SceneExposureControl.exposureControl = Physical_Camera_Exposure_Control()
    DYNFUNsetupExpParams()
  )

  on SPEXPbright changed arg do
  (
    if classOf LOCexp == Pseudo_Color_Exposure_Control then
    (
      LOCexp.minimum = arg
    )
    else
    (
      LOCexp.brightness = arg
    )
  )

  on SPEXPcontr changed arg do
  (
    if classOf LOCexp == Pseudo_Color_Exposure_Control then
    (
      LOCexp.maximum = arg
    )
    else
    (
      LOCexp.contrast = arg
    )
  )

  on SPEXPvalue changed arg do LOCexp.exposureValue          = arg
  on SPEXPmidT  changed arg do LOCexp.midTones               = arg
  on SPEXPscale changed arg do LOCexp.physicalScale          = arg

  on DDDYN1 selected arg do DYNexposure.LOCexp.quantity      = arg - 1
  on DDDYN2 selected arg do DYNexposure.LOCexp.display       = arg - 1
  on DDDYN3 selected arg do DYNexposure.LOCexp.scaleFunction = arg - 1

  on CBEXPonOff  changed val do (LOCexp.active = val; DYNamite.dnExposeNode.forecolor = DYNFUNdnColor (if LOCexp.active then (((colorMan.getColor #text) as color) * 255) else DYNINIgreyedOutColor))
  on CBEXPprocBG changed val do (LOCexp.ProcessBG            = val)
  on CBEXPcheck1 changed val do (LOCexp.chromaticAdaptation  = val)
  on CBEXPcheck2 changed val do (LOCexp.colorDifferentiation = val)
  on CBEXPcheck3 changed val do (LOCexp.indirectOnly         = val)
  on CBEXPcheck4 changed val do (LOCexp.exteriorDaylight     = val)

  on CODYNcolor  changed arg do (LOCexp.whiteColor = arg)

  on CODYNcolorCustom changed arg do (LOCexp.white_balance_custom = arg)

  on DDDYNpreset selected arg do
  (
    LOCexp.white_balance_illuminant = arg - 1
  )

  on RBDYNexpMode          changed arg do 
  (
    LOCexp.white_balance_type  = arg - 1
    CODYNcolorCustom.enabled   = if arg == 3 then true else false
    SPDYNwhitepoint.enabled    = if arg == 2 then true else false
    LBDYNpreset.enabled        = DDDYNpreset.enabled = if arg == 1 then true else false
  )

  on SPDYNhighlights       changed arg do LOCexp.highlights           = arg
  on SPDYNmidtones         changed arg do LOCexp.midtones             = arg
  on SPDYNshadows          changed arg do LOCexp.shadows              = arg
  on SPDYNsaturation       changed arg do LOCexp.saturation           = arg
  on SPDYNwhitepoint       changed arg do 
  (
    LOCexp.white_balance_kelvin = arg
  )
  on CBDYNvignetting       changed arg do (LOCexp.vignetting_enabled   = arg; SPDYNvignetting.enabled = if arg == 1 then true else false)
  on SPDYNvignetting       changed arg do LOCexp.vignetting_amount    = arg
  on RBDYNphysicalMode     changed arg do (LOCexp.physical_scale_mode = arg - 1; SPDYNphysicalScale.enabled = if arg == 1 then false else true)
  on SPDYNphysicalScale    changed arg do LOCexp.physical_scale       = arg
  on CBDYNusePhysicalCam   changed arg do 
  (
    LOCexp.use_physical_camera_controls = arg
    LBDYNevCompensation.enabled = arg
    SPDYNevCompensation.enabled = arg
  )
  on SPDYNevCompensation   changed arg do LOCexp.ev_compensation      = arg
  on SPDYNexposureValue    changed arg do LOCexp.global_ev            = arg
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQArXpdu2RaMz1d8AdIIDosSJ41Tq8NHryJV
-- pYkFa4BInlPlzo6S83L+Cb0BK4GxW108Shf3NxLGwiE/5xv+0cAwJ0+UK14NKy/9
-- Jo663NeSNMQ9rB8C/EjHAAKDyNATvOnHwyQW+wqG0Haw0Ap3bvMcZGEoI89hoqCt
-- JFW3Grgw6/ZR+Yi1uqyayKIGr/n9aSz82iLEI8l33bz5W6XyWiyKZiXd6XsOqLAc
-- 39Y+uFeHsFWgW97Qfsf9RxlnROQCb1NvJpy0SjM0prkStgFGOF4+wqN8dI4th4tz
-- vhjj7IcsCpXTpVJXoVUSA9dG00XL+HcYGlUosZCZwi0hem2ixf5F
-- -----END-SIGNATURE-----