--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNdrapeSpline ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCsurface
  local LOCshapes = #()

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNdrapeSplines FUNshapes FUNsurface FUNtype FUNlevel =
  (
    if FUNtype == 1 then
    (
      if isValidNode FUNsurface then
      (
        for a in FUNshapes do
        (
          if isValidNode a then
          (
            for i = 1 to (numSplines a) do
            (
              for ii = 1 to (numKnots a i) do
              (
                local LOCknt = getKnotPoint a i ii
                local LOCray = intersectRay LOCsurface (ray [LOCknt.x,LOCknt.y,9999.000] [0,0,-1])
                if LOCray != undefined then (try (setKnotPoint a i ii [LOCknt.x, LOCknt.y, LOCray.pos.z + FUNlevel]) catch ())
              )
            )
            updateShape a
          )
        )
      )
      else (messagebox (DYNuiResourcesErrorsWarnings[43]) title:DYNuiResourcesTitlebars[2])
    )
    else
    (
      for a in FUNshapes do
      (
        if isValidNode a then
        (
          for i = 1 to (numSplines a) do
          (
            for ii = 1 to (numKnots a i) do
            (
              local LOCknt = getKnotPoint a i ii
              try (setKnotPoint a i ii [LOCknt.x, LOCknt.y, FUNlevel]) catch ()
            )
          )
          updateShape a
        )
      )
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupBox GBDYNgroup00        pos:[11,7]    width:258 height:55
  radiobuttons RBDYNstyle      pos:[20,24]   labels:#(DYNuiResourcesLabels[330], DYNuiResourcesLabels[331])

  groupBox GBDYNgroup01        pos:[11,68]   width:258 height:190
  multilistBox MLDYNobjectList pos:[20,85]   width:239 height:8
  pickbutton PKDYNshapes       pos:[20,202]  width:239 filter:DYNFUNsplineShapeFilter
  button BUDYNshapes           pos:[20,227]  width:239

  groupBox GBDYNgroup02        pos:[11,264]  width:258 height:95

  pickbutton PKDYNsurface      pos:[20,281]  width:239 filter:DYNFUNgeometryFilter
  edittext EDDYNsurface        pos:[20,306]  width:239
  label LBDYNlevel             pos:[20,335]  width:175
  spinner SPDYNlevel ""        pos:[187,334] range:[-999.0,999.0,0.0] fieldwidth:60 type:#float

  button BUDYNokok             pos:[11,368]  width:72 height:22
  button BUDYNapply            pos:[104,368] width:72 height:22
  button BUDYNcanc             pos:[197,368] width:72 height:22

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNdrapeSpline open do
  (
    DYNdrapeSpline.title  = DYNuiRolloutNames[35]

    GBDYNgroup00.text     = DYNuiResourcesGroups[98]
    GBDYNgroup01.text     = DYNuiResourcesGroups[99]
    GBDYNgroup02.text     = DYNuiResourcesGroups[100]

    LBDYNlevel.text       = DYNuiResourcesLabels[329]

    BUDYNokok.text        = DYNuiResourcesButtons[1]
    BUDYNapply.text       = DYNuiResourcesButtons[2]
    BUDYNcanc.text        = DYNuiResourcesButtons[3]
    PKDYNshapes.text      = DYNuiResourcesButtons[64]
    BUDYNshapes.text      = DYNuiResourcesButtons[65]
    PKDYNsurface.text     = DYNuiResourcesButtons[63]
    EDDYNsurface.readOnly = true
  )

  on DYNdrapeSpline close do
  (
    DYNFUNonDialogClose()
  )

  on RBDYNstyle changed arg do
  (
    if arg == 1 then
    (
      PKDYNsurface.enabled = true
    )
    else
    (
      PKDYNsurface.enabled = false
      LOCsurface = undefined
      EDDYNsurface.text = ""
    )
  )

  on BUDYNshapes pressed do
  (
    local LOCselArray = selectByName title:DYNuiResourcesTitlebars[29] buttonText:DYNuiResourcesButtons[72] filter:DYNFUNsplineShapeFilter showHidden:false single:false

    if LOCselArray != undefined then
    (
      for i in LOCselArray do (if isValidNode i then append LOCshapes i)

      local LOCshapeNames = #()
      if LOCshapes.count > 0 then
      (
        for i in LOCshapes do
        (
          append LOCshapeNames i.name
        )
        MLDYNobjectList.items = LOCshapeNames
      )
    )
  )

  on PKDYNshapes picked arg do
  (
    if isValidNode arg then
    (
      append LOCshapes arg

      local LOCshapeNames = #()
      for i in LOCshapes do
      (
        append LOCshapeNames i.name
      )
      MLDYNobjectList.items = LOCshapeNames
    )
  )

  on PKDYNsurface picked arg do (if isValidNode arg then (LOCsurface = arg; EDDYNsurface.text = arg.name))

  on BUDYNokok  pressed do (DYNFUNdrapeSplines LOCshapes LOCsurface RBDYNstyle.state SPDYNlevel.value; destroyDialog DYNdrapeSpline)
  on BUDYNapply pressed do (DYNFUNdrapeSplines LOCshapes LOCsurface RBDYNstyle.state SPDYNlevel.value)
  on BUDYNcanc  pressed do (destroyDialog DYNdrapeSpline)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCMJnNJ4f2zG+HqWxt4178UgsRd+nS0Kklm
-- JW/bk1oikdVn+gQeL2fZCCyI9FDUnCTCOj7A029yvBdLk0xqTqEcmYT5t3jTrXds
-- P3EsOunaxk1WwsoEZcdzCqsMGBS4e3FSWhGFbBfUgfZKHSv+VXK259u6H37HX/qA
-- C6fHzupfnl0Pucc11/625eWRThyyWTSvjGfW3arsaits4GZ/gY5ez5AdLTuhN3b1
-- ydngWl6F7raa9OSKJBnNeEIpjJsU2WfR2ByILNSw4OaxNCeKtlnnWiN7RwzqBjDZ
-- 1mcRQq3E6XHoFmL5ULyhhPkGz9glC0ASX6CDbqZSjAkXRPazs2pD
-- -----END-SIGNATURE-----