--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNcveImport ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCconverter
  local LOCsourceFile                                         -- Holds path and name of selected mxModel file
  local LOCsourceFilePath                                     -- Initially holds scene directory for default folder in Open File Dialog, then is replaced by any selected directories
  local LOCobjectsAlreadyExist = false                        -- Used to check whether any objects already exist in the scene. If they do, a zoom extents will not be implemented
  local LOCrolloutTitle        = ""
  local LOCmodelLvMenu         = undefined
  local LOCelemLvMenu          = undefined
  local LOCtvMenu              = undefined
  local LOCallowItemCheck      = true

  --- SECTION 2 - LOCAL FUNCTIONS ---------------------------
  fn DYNFUNcountSelectedLandXMLelements FUNconverter =
  (
    local LOCcnt = 0

    -- CgPoints
    LOCcnt += FUNconverter.reader.Content.SelectedCgPoints.count

    -- Surface Meshes
    LOCcnt += FUNconverter.reader.Content.SelectedSurfaces.count

    -- Surface Breaklines
    for i = 1 to FUNconverter.surfaces.count do
    (
      LOCcnt += FUNconverter.surfaces.item[i-1].selectedBreaklines.count
    )

    LOCcnt -- return value
  )

  fn DYNFUNcreateLandXMLSurfaceListItem FUNsurface FUNtreeNodeID =
  (
    /*
    FUNtreeNodeID == "@" : Display breaklines and meshes
    FUNtreeNodeID == "#" : Display breaklines and meshes
    FUNtreeNodeID == "$" : Display meshes only
    FUNtreeNodeID == "!" : Display breaklines only
    */

    local LOClistItemRange = #()

    local LOCparent        = if FUNsurface.parent != undefined then FUNsurface.parent.name else ""

    -- add Mesh
    if FUNsurface.expectedFaceCount > 0 and FUNtreeNodeID != "!" then
    (
      local LOClistItem      = dotNetObject "System.Windows.Forms.ListViewItem" ""
    LOClistItem.imageIndex = 8
      if not FUNsurface.isUnavailable then
      (
    LOClistItem.tag        = FUNsurface
      )
      else
      (
        LOClistItem.forecolor = DYNFUNdnColor DYNINIgreyedOutColor
      )
    LOClistItem.checked    = FUNsurface.isSelected
      LOClistItem.SubItems.add (FUNsurface.name)
    LOClistItem.SubItems.add (DYNuiResourcesLabels[616])
    LOClistItem.SubItems.add (FUNsurface.expectedFaceCount as string)
    LOClistItem.SubItems.add (FUNsurface.expectedPointCount as string)
    append LOClistItemRange LOClistItem
    )

    -- add Breaklines
    if FUNtreeNodeID != "$" then
    (
      for i = 1 to FUNsurface.allBreaklines.count do
      (
        local LOCbreakline     = FUNsurface.allBreaklines.item[i-1]
        local LOClistItem      = dotNetObject "System.Windows.Forms.ListViewItem" LOCbreakline.name
      LOClistItem.imageIndex = 7
        if not LOCbreakline.isUnavailable then
        (
        LOClistItem.tag        = LOCbreakline
        )
        else
        (
          LOClistItem.forecolor = DYNFUNdnColor DYNINIgreyedOutColor
        )
        LOClistItem.checked    = LOCbreakline.isSelected
        LOClistItem.SubItems.add (FUNsurface.name)
      LOClistItem.SubItems.add (DYNuiResourcesLabels[617])
        LOClistItem.SubItems.add ("")
        LOClistItem.SubItems.add (LOCbreakline.points.count as string)
      append LOClistItemRange LOClistItem
    )
    )

    LOClistItemRange -- return value
  )

  fn DYNFUNcreateLandXMLcgPointsListItem FUNcgPoints =
  (
    local LOClistItemRange = #()

    -- add cgPoints
    if FUNcgPoints.expectedPointCount > 0 then
    (
      local LOCparent        = if FUNcgPoints.parent != undefined then FUNcgPoints.parent.name else ""
      local LOClistItem      = dotNetObject "System.Windows.Forms.ListViewItem" FUNcgPoints.name
      LOClistItem.imageIndex = 14
      if not FUNcgPoints.isUnavailable then
      (
      LOClistItem.tag        = FUNcgPoints
      )
      else
      (
        LOClistItem.forecolor = DYNFUNdnColor DYNINIgreyedOutColor
      )
      LOClistItem.checked    = FUNcgPoints.isSelected
      LOClistItem.SubItems.add (LOCparent)
      LOClistItem.SubItems.add (DYNuiResourcesLabels[615])
      LOClistItem.SubItems.add ("")
      LOClistItem.SubItems.add (FUNcgPoints.expectedPointCount as string)
      append LOClistItemRange LOClistItem
    )

    LOClistItemRange -- return value
  )


  fn DYNFUNselectCveElements FUNdnModels FUNdnStrings FUNstringPattern FUNstate FUNselectionType =
  (
    /*
    FUNselectionType:0 - Select/De-select All In All Models
    FUNselectionType:1 - Select/De-select All In Selected Model
    FUNselectionType:2 - Select/De-select By Name
    FUNselectionType:3 - Select/De-select By Type
    FUNselectionType:4 - Select/De-select Highlighted
    FUNselectionType:5 - Select/De-select By Sub-Ref
    */

    /*
    LOCconverter.SelectElementsByType(MxModel model, MxElementType elementType, string mask,  bool includeInvalidElements,  bool includeUnsupportedElements,  bool includeUnavailableElements,  bool flag)
    LOCconverter.SelectElementsByName(MxModel model, string mask,  bool includeInvalidElements,  bool includeUnsupportedElements,  bool includeUnavailableElements,  bool flag)
    LOCconverter.SelectElementsBySubRef(MxModel model, string mask,  bool includeInvalidElements,  bool includeUnsupportedElements,  bool includeUnavailableElements,  bool flag)
    LOCconverter.SelectAllElements(bool includeInvalidElements, bool includeUnsupportedElements, bool includeUnavailableElements, bool flag)
    */

    if FUNselectionType == 0 then
    (
      DYNcveImport.LOCconverter.selectAllElements false false false FUNstate
      if DYNcveImportMode == 3 then
      (
        if FUNstate then
        (
          for i = 1 to FUNdnModels.items.count do
          (
            DYNcveImport.dnModels.Items.item[i-1].tag.inheritSelection()
            DYNcveImport.dnModels.Items.item[i-1].tag.wrappedModel.isSelected = FUNstate
          )
        )
        else
        (
          for i = 1 to FUNdnModels.items.count do
          (
            DYNcveImport.LOCconverter.SelectElementsByName DYNcveImport.dnModels.Items.item[i-1].tag "*" false false false FUNstate
            DYNcveImport.dnModels.Items.item[i-1].tag.wrappedModel.isSelected = FUNstate
          )
        )

      )
      DYNcveImport.DYNFUNstringDisplayUpdate DYNcveImport.LOCconverter FUNdnModels.selectedItems.item[0].tag DYNcveImportMode
    )

    if FUNselectionType == 1 then
    (
      for i = 1 to FUNdnStrings.items.count do
      (
        FUNdnStrings.items.item[i - 1].checked = FUNstate
      )
    )

    if FUNselectionType == 2 then
    (
      for i = 1 to FUNdnStrings.items.count do
      (
        if (matchPattern FUNdnStrings.items.item[i - 1].text pattern:FUNstringPattern ignoreCase:true) then
        (
          FUNdnStrings.items.item[i - 1].checked = FUNstate
        )
      )
    )

    if FUNselectionType == 3 then
    (
      local LOCindex = if DYNcveImportMode == 3 then 1 else 2
      for i = 1 to FUNdnStrings.items.count do
      (
        if (matchPattern FUNdnStrings.items.item[i - 1].subitems.item[LOCindex].text pattern:FUNstringPattern ignoreCase:true) then
        (
          FUNdnStrings.items.item[i - 1].checked = FUNstate
        )
      )
    )

    if FUNselectionType == 4 then
    (
      for i = 1 to FUNdnStrings.selectedItems.count do
      (
        FUNdnStrings.selectedItems.item[i - 1].checked = FUNstate
      )
    )

    if FUNselectionType == 5 then
    (
      for i = 1 to FUNdnStrings.items.count do
      (
        if (matchPattern FUNdnStrings.items.item[i - 1].subitems.item[1].text pattern:FUNstringPattern ignoreCase:true) then
        (
          FUNdnStrings.items.item[i - 1].checked = FUNstate
        )
      )
    )
  )

  fn DYNFUNlandXMLobjectListDisplayUpdate FUNconverter FUNcurrentNode =
  (
    local LOCstringTypeList = #()
    local LOClistItemArray  = #()
    local LOCcurrentNodeID  = if FUNcurrentNode.name.count >= 1 then (subString FUNcurrentNode.name 1 1) else ""

    --- Clear Contents of ListView
    DYNcveImport.dnStrings.Items.clear()

    --- Create ListItems, filtering content based on looking selected dnTree treeview node

    -- If CgPoints Parent Node Or LandXML File Root Node Is Selected
    if FUNcurrentNode.name == "@|CgPoints" or FUNcurrentNode.name == "@|Drawing" then
    (
      for i = 1 to FUNconverter.cgPoints.count do (LOClistItemArray += (DYNFUNcreateLandXMLcgPointsListItem (FUNconverter.cgPoints.item[i-1])))
    )

    -- If Surface Parent Node Or LandXML File Root Node Is Selected
    if FUNcurrentNode.name == "@|Surfaces" or FUNcurrentNode.name == "@|Drawing" then
    (
      for i = 1 to FUNconverter.surfaces.count do (LOClistItemArray += (DYNFUNcreateLandXMLSurfaceListItem (FUNconverter.surfaces.item[i-1]) LOCcurrentNodeID))
    )

    -- If An Individual Surface Node Is Selected
    local LOCtreeViewNodeID = subString FUNcurrentNode.name 1 1
    if LOCtreeViewNodeID == "#" or LOCtreeViewNodeID == "$" or LOCtreeViewNodeID == "!" then
    (
      LOClistItemArray += (DYNFUNcreateLandXMLSurfaceListItem (FUNcurrentNode.tag) LOCcurrentNodeID)
    )

    --- Update ListView
    DYNcveImport.dnStrings.BeginUpdate()
    DYNcveImport.dnStrings.suspendLayout()
    DYNcveImport.LOCallowItemCheck = false

    DYNcveImport.dnStrings.Items.AddRange (LOClistItemArray)

    DYNcveImport.LOCallowItemCheck = true
    DYNcveImport.dnStrings.resumeLayout()
    DYNcveImport.dnStrings.refresh()
    DYNcveImport.dnStrings.endUpdate()

    --- Get List of UniqueStringTypes in the currently selected model
    local LOCuniqueElementTypes = #(DYNuiResourcesLabels[398], DYNuiResourcesLabels[615], DYNuiResourcesLabels[616], DYNuiResourcesLabels[617])
    for i in LOCuniqueElementTypes do (append LOCstringTypeList i)

    --- Update UI
    DYNcveImport.DDDYNobjectType.items     = LOCstringTypeList
    DYNcveImport.DDDYNobjectType.selection = 1
    DYNcveImport.dnProgress.value          = 0
    DYNcveImport.EDDYNobjectName.text      = "*"

    --- Finish Off Function
    DYNcveImport.dnStatus.text             = DYNuiResourcesStatusMessages[42]
  )


  fn DYNFUNstringDisplayUpdate FUNconverter FUNcurrentModel FUNcveMode =
  (
    local LOCstringTypeList = #()
    local LOClistItemArray  = #()

    --- Clear Contents of ListView
    DYNcveImport.dnStrings.Items.clear()

    --- Initiate String ListView
    LOClistItemArray = FUNconverter.GetElementListViewItems FUNcurrentModel true true true
    if LOClistItemArray != undefined then
    (
      DYNcveImport.dnStrings.BeginUpdate()
      DYNcveImport.dnStrings.suspendLayout()
      DYNcveImport.LOCallowItemCheck = false

      DYNcveImport.dnStrings.Items.AddRange (LOClistItemArray)

      DYNcveImport.LOCallowItemCheck = true
      DYNcveImport.dnStrings.resumeLayout()
      DYNcveImport.dnStrings.refresh()
      DYNcveImport.dnStrings.endUpdate()
    )

    --- Get List of UniqueStringTypes in the currently selected model
    /*
    ---------------------------------------------------------
    Dictionary<MxElementType, string>
    GetUniqueElementTypes(MxModel model,  bool includeInvalidElements,  bool includeUnsupportedElements,  bool includeUnavailableElements)
    ---------------------------------------------------------

      If for any reason there is not data, the result will be an EMPTY
      dictionary (e.g. result.Count == 0).

      This method takes a bool to indicate if invalid and unsupported
      items should be included in the results. This is required to keep
      the method uniform with the others. I can't tell whether you would
      want to get a list that includes invalid and unsupported items
      or not and even then, maybe you might at some point or not.

      NOTE: NULL IS RETURNED IF THERE ARE NO ELEMENTS IN THE MODEL

      dictionary = converter.GetUniqueElementTypes(a, b)
      for x = 0 to dictionary.Count
        pair = uniqueElementTypes.ElementAt(x);
        pair.Key holds the MxElementType
        pair.Value holds the string representation
    */

    local LOCuniqueElementTypes = FUNconverter.GetUniqueElementTypes FUNcurrentModel false false true -- last boolean is true because we want this list to include unavailable (previously imported) strings
    if LOCuniqueElementTypes != undefined then
    (
      if FUNcveMode == 3 then
      (
        for i in LOCuniqueElementTypes do (append LOCstringTypeList (FUNconverter.ToLocalizedName i.elementType))
      )
      else
      (
        for i in LOCuniqueElementTypes do (append LOCstringTypeList i.name)
      )
    /*
    Insert here the application of LandXML string types
          ~GLOB_LABEL_COGO_POINTS~, \               -- DYNuiResourcesLabels[615]
          ~GLOB_LABEL_SURFACE_TIN~, \               -- DYNuiResourcesLabels[616]
          ~GLOB_LABEL_SURFACE_BREAKLINES~ \         -- DYNuiResourcesLabels[617]
    */

    )

    --- Build List of Initial Characters in String Labels for display in drop down list
    insertItem DYNuiResourcesLabels[398] LOCstringTypeList 1                   -- Initialise model name array with "All Strings"

    DYNcveImport.DDDYNobjectType.items     = LOCstringTypeList
    DYNcveImport.DDDYNobjectType.selection = 1
    DYNcveImport.dnProgress.value          = 0
    DYNcveImport.EDDYNobjectName.text      = "*"

    --- Finish Off Function
    DYNcveImport.dnStatus.text          = DYNuiResourcesStatusMessages[42]
  )

  fn DYNFUNfullDisplayUpdate FUNconverter FUNcveImportMode FUNsourceFile =
  (
    local LOCoriginalStatusMessage = DYNcveImport.dnStatus.text
    DYNcveImport.dnStatus.text = DYNuiResourcesStatusMessages[2]

    DYNcveImport.dnModels.Items.clear()
    DYNcveImport.dnTree.nodes.clear()

    /*
       ------- MX MODEL PARAMETER LIST --------------------------------------------------------
      .ElementCount : <System.Int32>, read-only
      .ErrorCondition : <System.String>, read-only
      .FileOffset : <System.Int64>
      .InvalidElementCount : <System.Int32>, read-only
      .IsSelected : <System.Boolean>
      .IsValid : <System.Boolean>, read-only
      .Item[<System.Int32>index] : <Autodesk.CVE.Data.Mx.MxElement>, read-only
      .ListItem : <System.Windows.Forms.ListViewItem>
      .Name : <System.String>
      .OwnerChunkNumber : <System.Int32>
      .SelectedElementCount : <System.Int32>, read-only
      .Status : <Autodesk.CVE.Data.Mx.MxModelStatus>, read-only
      .StringIndexChunkNumber : <System.Int32>
      .TimeStamp : <System.Int32>
      .TimeStampString : <System.String>, read-only  (supports localization and culture)
      .UnsupportedElementCount : <System.Int32>, read-only
      .ValidSupportedElementCount : <System.Int32>, read-only

       ------- GENIO MODEL PARAMETER LIST --------------------------------------------------------
      .ElementCount : <System.Int32>, read-only
      .ErrorCondition : <System.String>, read-only
      .HasHorizontalAlignments : <System.Boolean>, read-only
      .HasOtherThanHorizontalAlignments : <System.Boolean>, read-only
      .InvalidElementCount : <System.Int32>, read-only
      .IsDeleteCreateWritten : <System.Boolean>
      .IsSelected : <System.Boolean>
      .IsValid : <System.Boolean>, read-only
      .Item[<System.Int32>index] : <Autodesk.CVE.Data.GenIO.GenioElement>, read-only
      .ListItem : <System.Windows.Forms.ListViewItem>
      .Name : <System.String>
      .Offset : <Autodesk.CVE.Data.GenIO.GenioFileOffset>, read-only
      .SelectedElementCount : <System.Int32>, read-only
      .Status : <Autodesk.CVE.Data.GenIO.GenioModelStatus>, read-only
      .UnsupportedElementCount : <System.Int32>, read-only
      .ValidSupportedElementCount : <System.Int32>, read-only

      Each model has a .Status property (type MxModelStatus) that is used for the C3D UI's and selection stuff. The status enums are:

         Empty,          /// The model has no elements.
         AllInvalid,     /// All elements in the model are invalid.
         AllUnsupported, /// All elements in the model are unsupported.
         Mixed,          /// The model contains one or more invalid and/or unsupported elements.
         ???,            /// The model contains elements that are all supported and valid.
    */


    /*
    ---------------------------------------------------------
    ListViewItem[] GetModelListViewItems
    (bool includeInvalidElements,  bool includeUnsupportedElements,  bool includeUnavailableElements,  bool includeInvalidModels)
    ---------------------------------------------------------

      This method takes a bool to indicate if invalid and unsupported
      items should be included in the results.

      This affects the element count field!
      The old behavior only used the valid-and-supported count.
      This will be the case if the parameter flag is false.

      If the parameter flag is true, the element count field
      represents *all* elements, regardless of their status.

      The includeInvalidModels flag will determine if models
      flagged as invalid are part of the returned results.

      Invalid models are colored with InvalidItemColor.

      NOTE: NULL IS RETURNED IF NO ARRAY COULD BE CREATED.
      NULL IS ALSO RETURNED IF THERE ARE NO MODELS

      The method has been augmented substantially to support
      pre- and post-filtering of the results. The first round
      of filtering would lead to NULL items in the array. The
      returned array will now be guaranteed to contain only
      the filtered results.

      The checked state is now also integrated. If IsSelected
      is true, the checked state of the LV will also be!
      HOWEVER: THERE IS NO TRI-STATE SUPPORT for models that
      only have a subset of elements selected.
      */

    if FUNcveImportMode == 4 then
    (
      if (FUNconverter.CgPoints.count + FUNconverter.Surfaces.count) > 0 then
      (
        --- Populate LandXML Tree View
        local LOCdnRootNode = DYNcveImport.dnTree.Nodes.add "@|Drawing" (FileNameFromPath (FUNsourceFile as string)) 40 40
        DYNcveImport.dnTree.selectedNode = LOCdnRootNode

        /*
          -- Dynamic Properties for LandXML mode only
          IList<string> Converter.SurfaceNames
          IList<string> Converter.SurfaceSelectionNames



          IList<LandXmlCgPoints> Converter.CgPoints
          IList<LandXmlSurface> Converter.Surfaces

        */

        local LOCcgPntNode  = DYNcveImport.dnTree.Nodes.item[0].nodes.add "@|CgPoints" (DYNuiResourcesLabels[615] + " [" + (FUNconverter.CgPoints.count as string) + "]") 14 14
        LOCcgPntNode.tag    = FUNconverter.CgPoints

        local LOCsurfsNode  = DYNcveImport.dnTree.Nodes.item[0].nodes.add "@|Surfaces" (DYNuiResourcesC3dObjectTypes[23] + " [" + (FUNconverter.Surfaces.count as string) + "]")  8  8
        LOCsurfsNode.tag    = FUNconverter.Surfaces

        for i = 1 to FUNconverter.CgPoints.count do
        (
          /*
            .AllCgPoints : <System.Collections.Generic.IList`1[Autodesk.CVE.Data.LandXml.LandXmlCgPoints]>, read-only
            .CgPoints : <System.Collections.Generic.List`1[Autodesk.CVE.Data.LandXml.LandXmlCgPoints]>
            .Code : <System.String>
            .Description : <System.String>
            .ElementType : <Autodesk.CVE.Data.LandXml.LandXmlElementType>, read-only
            .ExpectedPointCount : <System.Int32>
            .Features : <System.Collections.Generic.List`1[Autodesk.CVE.Data.LandXml.LandXmlFeature]>
            .HasPointReferences : <System.Boolean>, read-only
            .HasUnresolvedPointReferences : <System.Boolean>, read-only
            .IsRead : <System.Boolean>
            .IsSelected : <System.Boolean>
            .Name : <System.String>
            .Parent : <Autodesk.CVE.Data.LandXml.LandXmlElement>
            .Points : <System.Collections.Generic.List`1[Autodesk.CVE.Data.LandXml.LandXmlCgPoint]>
            .SelectedCgPoints : <System.Collections.Generic.IList`1[Autodesk.CVE.Data.LandXml.LandXmlCgPoints]>, read-only
            .SelectionName : <System.String>, read-only
            .XmlPath : <System.String>
          */
        )

        for i = 1 to FUNconverter.Surfaces.count do
        (
          /*
            .AllBoundaries : <System.Collections.Generic.IList`1[Autodesk.CVE.Data.LandXml.LandXmlBoundary]>, read-only
            .AllBreaklines : <System.Collections.Generic.IList`1[Autodesk.CVE.Data.LandXml.LandXmlBreakline]>, read-only
            .AllContours : <System.Collections.Generic.IList`1[Autodesk.CVE.Data.LandXml.LandXmlContour]>, read-only
            .AreBoundariesSelected : <System.Boolean>
            .AreContoursSelected : <System.Boolean>
            .Boundaries : <System.Collections.Generic.List`1[Autodesk.CVE.Data.LandXml.LandXmlBoundaries]>
            .Breaklines : <System.Collections.Generic.List`1[Autodesk.CVE.Data.LandXml.LandXmlBreaklines]>
            .Contours : <System.Collections.Generic.List`1[Autodesk.CVE.Data.LandXml.LandXmlContours]>
            .Description : <System.String>
            .DetectedBoundaries : <System.Boolean>
            .DetectedContours : <System.Boolean>
            .ElementType : <Autodesk.CVE.Data.LandXml.LandXmlElementType>, read-only
            .ExpectedFaceCount : <System.Int32>
            .ExpectedPointCount : <System.Int32>
            .Faces : <System.Collections.Generic.List`1[Autodesk.CVE.Data.LandXml.LandXmlSurfaceFace]>
            .Features : <System.Collections.Generic.List`1[Autodesk.CVE.Data.LandXml.LandXmlFeature]>
            .HasPointReferences : <System.Boolean>, read-only
            .HasUnresolvedPointReferences : <System.Boolean>, read-only
            .IsRead : <System.Boolean>
            .IsSelected : <System.Boolean>
            .Name : <System.String>
            .Parent : <Autodesk.CVE.Data.LandXml.LandXmlElement>
            .Points : <System.Collections.Generic.List`1[Autodesk.CVE.Data.LandXml.LandXmlSurfacePoint]>
            .SelectionName : <System.String>, read-only
            .SurfaceType : <System.String>
            .XmlPath : <System.String>
          */
          local LOCsurface        = FUNconverter.Surfaces.item[i - 1]
          local LOCsurfNode       = LOCsurfsNode.nodes.add ("#|" + ((i - 1) as string) + "|" + LOCsurface.name) LOCsurface.name 8 8
          LOCsurfNode.tag         = LOCsurface
          LOCsurfNode.toolTipText = LOCsurface.xmlPath
          if LOCsurface.description != "" then LOCsurfNode.toolTipText += "\n" + LOCsurface.description

          if LOCsurface.expectedFaceCount > 0 then
          (
            local LOCsurfMeshNode = LOCsurfNode.nodes.add ("$|" + ((i - 1) as string) + "|" + LOCsurface.name) (DYNuiResourcesLabels[616] + " [1]") 8 8
            LOCsurfMeshNode.tag   = LOCsurface
            LOCsurfMeshNode.toolTipText = LOCsurface.xmlPath
            if LOCsurface.description != "" then LOCsurfMeshNode.toolTipText += "\n" + LOCsurface.description
          )

          if LOCsurface.AllBreaklines.count > 0 then
          (
            local LOCsurfBreakLineNode = LOCsurfNode.nodes.add ("!|" + ((i - 1) as string) + "|" + LOCsurface.name) (DYNuiResourcesLabels[617] + " [" + (LOCsurface.AllBreaklines.count as string) + "]") 7 7
            LOCsurfBreakLineNode.tag   = LOCsurface
            LOCsurfBreakLineNode.toolTipText = LOCsurface.xmlPath
            if LOCsurface.description != "" then LOCsurfBreakLineNode.toolTipText += "\n" + LOCsurface.description
          )
        )

        --- Expand All Branches of TreeView
        LOCdnRootNode.expand()
        for i = 1 to LOCdnRootNode.nodes.count do (LOCdnRootNode.nodes.item[i-1].expand())
        LOCdnRootNode.ensureVisible()

        DYNcveImport.dnStatus.text = DYNuiResourcesStatusMessages[42]

        --- Populate Strings List View
        DYNcveImport.DYNFUNlandXMLobjectListDisplayUpdate FUNconverter LOCdnRootNode
      )
      else
      (
        DYNcveImport.dnStatus.text = DYNuiResourcesStatusMessages[41] -- No valid data found
      )
    )
    else
    (
      local LOClistItemArray = FUNconverter.GetModelListViewItems true true true true

      if LOClistItemArray != undefined then
      (
        --- Add File Last Modified Column Content for GENIO Files
        if FUNcveImportMode == 1 then
        (
          local LOCdateStamp = DYNFUNconvertGUPdate (DYNFUNgetFileModifyTime FUNsourceFile true)
          for i in LOClistItemArray do i.subItems.item[3].text = LOCdateStamp
        )

        --- Populate Models List View
        DYNcveImport.dnModels.Items.AddRange LOClistItemArray
        DYNcveImport.dnStatus.text = DYNuiResourcesStatusMessages[42]
        DYNcveImport.dnModels.Items.item[0].selected = true

        --- Populate Strings List View
        DYNcveImport.DYNFUNstringDisplayUpdate FUNconverter DYNcveImport.dnModels.SelectedItems.item[0].tag FUNcveImportMode
      )
      else
      (
        DYNcveImport.dnStatus.text = DYNuiResourcesStatusMessages[41] -- No valid data found
      )
    )

    DYNcveImport.dnProgress.value = 0
    setFocus DYNcveImport.BUDYNokok
  )

  fn DYNFUNdisplayErrorLog FUNcaption FUNbuildErrorLog FUNreadErrorLog =
  (
    ExeStr= ("rollout DYNrollout \"" + FUNcaption + "\"\n")
    ExeStr+=("(\n")

    ExeStr+=("  fn DYNFUNshowBuildErrors =\n")
    ExeStr+=("  (\n")
    ExeStr+=("    DYNrollout.dnLv.items.clear()\n")
    ExeStr+=("    local LOClistItemRange = #()\n")
    ExeStr+=("    DYNrollout.dnLv.beginUpdate()\n")
    for i = 1 to FUNbuildErrorLog.count do
    (
      local LOCimageIndex = if (FUNbuildErrorLog.item[i-1].Element.ElementType.toString()) == "MXTriangleString" then 8 else 7
      ExeStr+=("    local LOCdnListItem = dotNetObject \"System.Windows.Forms.ListViewItem\" \"" + FUNbuildErrorLog.item[i-1].Model.Name + "\"\n")
      ExeStr+=("    LOCdnListItem.imageIndex  = " + (LOCimageIndex as string) + "\n")
      ExeStr+=("    LOCdnListItem.SubItems.add \"" + FUNbuildErrorLog.item[i-1].Element.Name + "\"\n")
      ExeStr+=("    LOCdnListItem.SubItems.add \"" + FUNbuildErrorLog.item[i-1].Element.ElementType.toString() + "\"\n")
      ExeStr+=("    LOCdnListItem.SubItems.add \"" + (FUNbuildErrorLog.item[i-1].Element.cannotBuildReason as string) + "\"\n")
      ExeStr+=("    append LOClistItemRange LOCdnListItem\n")
    )
    ExeStr+=("    DYNrollout.dnLv.Items.AddRange LOClistItemRange\n")
    ExeStr+=("    DYNrollout.dnLv.endUpdate()\n")
    ExeStr+=("  )\n")

    ExeStr+=("  fn DYNFUNshowReadErrors =\n")
    ExeStr+=("  (\n")
    ExeStr+=("    DYNrollout.dnLv.items.clear()\n")
    ExeStr+=("    local LOClistItemRange = #()\n")
    ExeStr+=("    DYNrollout.dnLv.beginUpdate()\n")
    for i = 1 to FUNreadErrorLog.count do
    (
      local LOCimageIndex = if (FUNreadErrorLog.item[i-1].Element.ElementType.toString()) == "MXTriangleString" then 8 else 7
      ExeStr+=("    local LOCdnListItem = dotNetObject \"System.Windows.Forms.ListViewItem\" \"" + FUNreadErrorLog.item[i-1].Model.Name + "\"\n")
      ExeStr+=("    LOCdnListItem.imageIndex  = " + (LOCimageIndex as string) + "\n")
      ExeStr+=("    LOCdnListItem.SubItems.add \"" + FUNreadErrorLog.item[i-1].Element.Name + "\"\n")
      ExeStr+=("    LOCdnListItem.SubItems.add \"" + FUNreadErrorLog.item[i-1].Element.ElementType.toString() + "\"\n")
      ExeStr+=("    LOCdnListItem.SubItems.add \"" + (FUNreadErrorLog.item[i-1].Element.ErrorCondition as string) + "\"\n")
      ExeStr+=("    append LOClistItemRange LOCdnListItem\n")
    )
    ExeStr+=("    DYNrollout.dnLv.Items.AddRange LOClistItemRange\n")
    ExeStr+=("    DYNrollout.dnLv.endUpdate()\n")
    ExeStr+=("  )\n")

    ExeStr+=("  dotNetControl dnTabCtrl \"System.Windows.Forms.TabControl\"  height:23  width:700 pos:[12,12]\n")
    ExeStr+=("  dotNetControl dnLv \"System.Windows.Forms.ListView\"  width:700 height:350 pos:[12,37]\n")
    ExeStr+=("  button BUDYNokok width:85 pos:[627,394]\n")
    ExeStr+=("  on DYNrollout open do\n")
    ExeStr+=("  (\n")

    ExeStr+=("    BUDYNokok.text = DYNuiResourcesButtons[1]\n")
    ExeStr+=("    dnTabCtrl.tabpages.add (DYNuiResourcesLabels[399] + \" (\" + \"" + (FUNbuildErrorLog.count as string) + ")\")\n")
    ExeStr+=("    dnTabCtrl.tabpages.add (DYNuiResourcesLabels[400] + \" (\" + \"" + (FUNreadErrorLog.count as string)  + ")\")\n")

    ExeStr+=("    dnTabCtrl.padding.x = 6\n")

    ExeStr+=("    DYNFUNdnListViewStyle dnLv false true\n")
    ExeStr+=("    dnLv.sorting = DYNdnSortOrderClass.ascending\n")

    ExeStr+=("    dnLv.Columns.add DYNuiResourcesLvColumns[90] 175\n")
    ExeStr+=("    dnLv.Columns.add DYNuiResourcesLvColumns[86] 75\n")
    ExeStr+=("    dnLv.Columns.add DYNuiResourcesLvColumns[87] 125\n")
    ExeStr+=("    dnLv.Columns.add DYNuiResourcesLvColumns[91] 300\n")

    ExeStr+=("    dnLv.smallImageList = DYNdnSmImageList\n")
    if FUNbuildErrorLog.count > 0 then
    (
      ExeStr+=("    DYNrollout.DYNFUNshowBuildErrors()\n")
      ExeStr+=("    DYNrollout.dnTabCtrl.selectedIndex = 0\n")
    )
    else
    (
      ExeStr+=("    DYNrollout.DYNFUNshowReadErrors()\n")
      ExeStr+=("    DYNrollout.dnTabCtrl.selectedIndex = 1\n")
    )
    ExeStr+=("  )\n")
    ExeStr+=("  on dnTabCtrl mouseUp arg do\n")
    ExeStr+=("  (\n")
    ExeStr+=("    if dnTabCtrl.selectedTab.TabIndex == 0 then\n")
    ExeStr+=("    (\n")
    ExeStr+=("      DYNrollout.DYNFUNshowBuildErrors()\n")
    ExeStr+=("    )\n")
    ExeStr+=("    else\n")
    ExeStr+=("    (\n")
    ExeStr+=("      DYNrollout.DYNFUNshowReadErrors()\n")
    ExeStr+=("    )\n")
    ExeStr+=("  )\n")
    ExeStr+=("  on BUDYNokok pressed do (destroyDialog DYNrollout)\n")
    ExeStr+=(")\n")

    local DYNrollout = Execute ExeStr
    createDialog DYNrollout width:724 height:422 modal:true -- needs to be true in order to halt function here and wait for a response from the panel
  )

  fn DYNFUNimportCVEfileWrapper FUNconverter FUNsourceFile FUNfeatureInterp FUNsourceFilePath FUNobjectsAlreadyExist FUNprogressBar FUNstatusLabel FUNfeatureInterpStyle FUNcveImportMode =
  (
    local LOCnewArray  = #()
    local LOCyesSwitch = true

    local LOCfisStyle  = DYNfeatureInterp.DYNFUNfisStringToFullPath (FUNfeatureInterpStyle as string) -- (just in case returns as undefined)

    if (if FUNfeatureInterp then (DYNFUNfisPreFlight LOCfisStyle) else true) then
    (
      if not FUNfeatureInterp then (if not rootNode.DYNrootNodeStore.bool02 then (if not DYNFUNfeatureInterpQuery() then LOCyesSwitch = false))
      if LOCyesSwitch then
      (
        --- Continue with Import and Feature Interpretation
        DYNFUNremoveCSProllouts()        -- This must be carried first to prevent PositionControl rollout from having references to old objects.
        DYNFUNloadVSPnodeCallBacks false
        (
          actionMan.executeAction 0 "300" -- Ensure that MAX modify panel is NOT open

          --- Import File -----------------------------------------------------------
          FUNprogressBar.maximum = 400
          local LOCproceed = DYNFUNreadSelectedData FUNconverter FUNsourceFile FUNprogressBar FUNstatusLabel DYNcveImport.DYNFUNcveOnReadProgressEventForMx DYNcveImport.DYNFUNcveOnReadProgressEventFor12d DYNcveImport.DYNFUNcveOnReadProgressEventForXml DYNcveImport.DYNFUNcveOnTriangleOptimizationEvent FUNcveImportMode

          if LOCproceed then
          (
            local LOCYesNoCancel = DYNFUNsetGlobalShiftCoords (FUNconverter.ShiftX as integer) (FUNconverter.ShiftY as integer)
            if LOCYesNoCancel != #cancel then
            (
              LOCnewArray = DYNFUNimportCVEfile FUNconverter FUNsourceFile FUNprogressBar FUNstatusLabel DYNcveImport.DYNFUNcveOnConversionProgressEventForMx DYNcveImport.DYNFUNcveOnConversionProgressEventFor12d DYNcveImport.DYNFUNcveOnWriteProgressEvent DYNcveImport.DYNFUNcveOnWriteIndexProgressEvent DYNtempPath FUNcveImportMode
            )
          )

          --- Report Errors Where Applicable (does not apply to LandXML mode)
          if DYNcveBuildErrorArray.count > 0 or DYNcveReadErrorArray.count > 0 then
          (
            local LOCnumSelElems = if DYNcveImportMode == 3 then FUNconverter.ModelContainer.NumberOfSelectedElements else FUNconverter.reader.NumberOfSelectedElements

            local LOCqueryString = DYNFUNformatValueToString DYNuiResourcesErrorsWarnings[61] (DYNcveBuildErrorArray.count + DYNcveReadErrorArray.count)
            LOCqueryString += "\n\n"
            LOCqueryString += DYNuiResourcesQueries[34]

            if (querybox LOCqueryString title:DYNuiResourcesTitlebars[2]) then
            (
              DYNFUNdisplayErrorLog (DYNcveImport.LOCrolloutTitle + " - " + DYNuiResourcesTitlebars[33]) DYNcveBuildErrorArray DYNcveReadErrorArray
            )
          )

          FUNprogressBar.maximum = 100
          FUNprogressBar.value   = 0

          --- Check if File Imported, then process FIS style and set persistent paths
          if LOCproceed then
          (
            if FUNcveImportMode == 1 then rootNode.DYNrootNodeStore.genPath = FUNsourceFilePath
            if FUNcveImportMode == 2 then rootNode.DYNrootNodeStore.mfwPath = FUNsourceFilePath
            if FUNcveImportMode == 3 then rootNode.DYNrootNodeStore.twdPath = FUNsourceFilePath
            if FUNcveImportMode == 4 then rootNode.DYNrootNodeStore.xmlPath = FUNsourceFilePath

            -------- ATTEMPT FEATURE STYLE APPLICATION ------------------------------
            if FUNfeatureInterp then
            (
              FUNstatusLabel.text = DYNuiResourcesStatusMessages[17]
              DYNfeatureInterp.DYNFUNapplyFeatureInterpretationStyle LOCfisStyle LOCnewArray (DYNFUNgetLocalTime()) FUNprogressBar
            )

            FUNstatusLabel.text = DYNFUNformatValueToString DYNuiResourcesStatusMessages[3] LOCnewArray.count

            --- End Process
            if FUNobjectsAlreadyExist == false then (max tool zoomextents all; max tool zoomextents all)
          )
        )
        DYNFUNloadVSPnodeCallBacks true
        DYNFUNnodeCreatedCallback()
        DYNproperties.DYNFUNscreenSelectionToList()
        gc()
      )
    )
    LOCnewArray -- return value
  )


  fn DYNFUNcveOnModelFoundEvent e =
  (
     /*
      ---------------------------------------
      GENIO USEAGE NOTES
      ---------------------------------------
      Fired when a model is found during the scanning process
      Event of type Autodesk.CVE.Data.GenIO.GenioScanItemEventArgs provides:

        e.LineNumber (current line number that the model is found at)
        e.Name (the name of the model found)
        e.IsNew (whether the model has been found before, e.g. isNew = false means it's a continuation)

      ---------------------------------------
      MX (MODEL FILE) USEAGE NOTES
      ---------------------------------------
      Fired when a model is found during the scanning process
      Event of type Autodesk.CVE.Data.Mx.MxScanItemEventArgs provides:

        e.FileOffset (current file offset)
        e.Name (the name of the model found)
        e.TimeStampString (the timestamp string)

     */

     DYNcveImport.dnStatus.text = DYNuiResourcesStatusMessages[40] + " " + e.Name
  )

  fn DYNFUNcveOnElementFoundEvent e =
  (
     /*
      LANDXML USEAGE NOTES
      ---------------------------------------
      Autodesk.CVE.Data.LandXml.LandXmlScanItemEventArgs (core)
      Has just one string, Name.
     */
     DYNcveImport.dnStatus.text    = DYNuiResourcesStatusMessages[55] + " " + e.Name
  )


  fn DYNFUNcveOnScanProgressEvent e =
  (
     /*
      GENIO USEAGE NOTES
      ---------------------------------------
      Fired at intervals to provide progress info during the scanning process
      Event of type Autodesk.CVE.Data.GenIO.GenioProgressEventArgs provides:

        e.LineNumber (current line number)
        e.Percentage (the percentage of current progress 0..100)

      MX (MODEL FILE) USEAGE NOTES
      ---------------------------------------
      Fired at intervals to provide progress info during the scanning process
      Event of type Autodesk.CVE.Data.Mx.MxProgressEventArgs provides:

        e.FileOffset (current file offset)
        e.Percentage (the percentage of current progress 0..100)

      12D USEAGE NNOTES
      ---------------------------------------
      Fired at intervals to provide progress info during the scanning process
      Event of type Autodesk.CVE.Data.TwelveD.FormatParserProgressEventArgs provides:

        e.Line       (current line number)
        e.Column     (current column)
        e.Position   (the position in the "byte stream")
        e.Percentage (the percentage of current progress 0..100)
     */
     DYNcveImport.dnProgress.value = e.percentage
  )


  fn DYNFUNcveOnConversionProgressEventForMx e =
  (
     /*
     ----------------------------------------
     MX and GENIO USEAGE NOTES
     ----------------------------------------
     e.Percentage (int)
     e.NumElementsConverted (current # of elm's converted)
     e.Pair (a ModelElementPair, the current one converted)
     */
     DYNcveImport.dnStatus.text    = DYNuiResourcesStatusMessages[38] + " " + (e.Pair.Model.Name) + " / " + e.Pair.Element.Name
     DYNcveImport.dnProgress.value = e.percentage + 100.0
  )

  fn DYNFUNcveOnConversionProgressEventFor12d e =
  (
     /*
     Payload: Autodesk.CVE.Import.TwelveD.ConversionProgressEventArgs

     NOTE: THIS IS NOT A CORE EVENT (SEE NAMESPACE !!!)

     This can't be a core event because of the abstraction with the whole
     grouping issue in the 12D wrapper. Things have to be done by group so
     conversion progress is glued at the hip with group handling.

     Properties are:

     e.Percentage
     e.NumElementsConverted (current # of elm's converted)
     e.Group (StringElementGroup)

     StringElementGroup is an object in the wrapper. If you want to get
     to model name and group name you should use the following:

     -> Group.ElementWrappers[0].WrappedElement.ParentModel.Name
     -> Group.UpperCaseName
     */
     DYNcveImport.dnStatus.text    = DYNuiResourcesStatusMessages[38] + " " + (e.Group.ElementWrappers.item[0].WrappedElement.ParentModel.Name) + " / " + e.Group.UpperCaseName
     DYNcveImport.dnProgress.value = e.percentage + 100.0
  )


  fn DYNFUNcveOnReadProgressEventForMx e =
  (
     /*
      ---------------------------------------
      GENIO USEAGE NOTES
      ---------------------------------------
      Fired at intervals to provide progress info during the reading process
      Event of type Autodesk.CVE.Data.GenIO.GenioProgressEventArgs provides:

        e.LineNumber (current line number)
        e.ModelName (the name of the current model)
        e.ElementName (the name of the current element)
        e.Percentage (the percentage of current progress 0..100)

      ---------------------------------------
      MX (MODEL FILE) USEAGE NOTES
      ---------------------------------------
      Fired at intervals to provide progress info during the reading process
      Event of type Autodesk.CVE.Data.Mx.MxProgressEventArgs provides:

        e.FileOffset (current file offset)
        e.ModelName (the name of the current model)
        e.ElementName (the name of the current element)
        e.Percentage (the percentage of current progress 0..100)
     */

     DYNcveImport.dnStatus.text    = DYNuiResourcesStatusMessages[39] + " " + e.ModelName + " / " + e.ElementName
     DYNcveImport.dnProgress.value = e.percentage
  )

  fn DYNFUNcveOnReadProgressEventFor12d e =
  (
     /*
      Payload: Autodesk.CVE.Data.TwelveD.ReadProgressEventArgs which contains:

        e.Model (the name of the current model)
        e.Element (the name of the current element)
        e.Percentage (the percentage of current progress 0..100)

      Don't use the Model and Element. Only use the percentage property
      to update progress. Model and Element were omitted in the core since
      they served no purpose. But at this point I don't want to remove
      them from the core since it'd kick a few things down.
     */

     DYNcveImport.dnStatus.text    = DYNuiResourcesStatusMessages[37]
     DYNcveImport.dnProgress.value = e.percentage
  )

  fn DYNFUNcveOnReadProgressEventForXml e =
  (
     /*
      Payload: Autodesk.CVE.Data.LandXml.LandXmlSimpleProgressEventArgs (which contains:

        e.ProgressValue (int)
        e.ProcessMessage (string)
     */
     DYNcveImport.dnStatus.text    = DYNuiResourcesStatusMessages[37]
     DYNcveImport.dnProgress.value = e.ProgressValue
  )

  fn DYNFUNcveOnWriteProgressEvent e =
  (
    /*
    .Empty : <System.EventArgs>, read-only, static
    */
    DYNcveImport.dnProgress.value += 1
  )

  fn DYNFUNcveOnWriteIndexProgressEvent e =
  (
    /*
    .Empty : <System.EventArgs>, read-only, static
    */
    DYNcveImport.dnProgress.value += 1
  )

  fn DYNFUNcveOnTriangleOptimizationEvent e =
  (
     /*
      Fired at intervals to provide progress info during triangle optimization
      NOTE: (!!!) OptimizedTriangleReading must be TRUE for this event to ever be fired
      Event of type Autodesk.CVE.Data.Mx.MxTriangleOptimizerEventArgs provides:
      Event of type Autodesk.CVE.Data.GenIO.GenioTriangleOptimizerEventArgs provides:

        e.ModelName (the name of the current model)
        e.ElementName (the name of the current element)
        e.CurrentPoints (the number of points currently generated for the element)
        e.TotalPoints (the total number of points in the unoptimized element)
     */

     DYNcveImport.dnStatus.text    = DYNuiResourcesStatusMessages[36] + " " + e.ModelName + " / " + e.ElementName + " (" + (e.CurrentPoints as string) + " / " + (e.TotalPoints as string) + ")"
  )

  fn DYNFUNresizeCVEimporter FUNnewSize FUNcveImportMode =
  (
    if FUNnewSize.y < 225 then (FUNnewSize.y = 225; DYNcveImport.height = 225)
    if FUNnewSize.x < 995 then (FUNnewSize.x = 995; DYNcveImport.width  = 995)
    if FUNnewSize.x > 995 then (FUNnewSize.x = 995; DYNcveImport.width  = 995)

    if FUNcveImportMode == 4 then
    (
      DYNcveImport.dnModels.pos.x = DYNcveImport.width + 100
    )
    else
    (
      DYNcveImport.dnTree.pos.x = DYNcveImport.width + 100
    )

    DYNcveImport.dnsplitter.height      = FUNnewSize.y - 114
    DYNcveImport.BUDYNokok.pos.y        = FUNnewSize.y - 70
    DYNcveImport.BUDYNapply.pos.y       = FUNnewSize.y - 70
    DYNcveImport.BUDYNcanc.pos.y        = FUNnewSize.y - 70
    DYNcveImport.BUDYNopts.pos.y        = FUNnewSize.y - 70
    DYNcveImport.BUDYNhelp.pos.y        = FUNnewSize.y - 70
    DYNcveImport.dnProgress.pos.y       = FUNnewSize.y - 40
    DYNcveImport.dnStatus.pos.y         = FUNnewSize.y - 20
    DYNcveImport.CKDYNfeatureOn.pos.y   = FUNnewSize.y - 67
    DYNcveImport.DDDYNfeatureList.pos.y = FUNnewSize.y - 70
    DYNcveImport.BUDYNfeatureEdit.pos.y = FUNnewSize.y - 70
    DYNcveImport.BUDYNfeatureNew.pos.y  = FUNnewSize.y - 70
    DYNcveImport.dnSplitter.refresh()
    if FUNcveImportMode == 1 then (DYNdefRLsizeGEN = FUNnewSize)
    if FUNcveImportMode == 2 then (DYNdefRLsizeMXM = FUNnewSize)
    if FUNcveImportMode == 3 then (DYNdefRLsize12D = FUNnewSize)
    if FUNcveImportMode == 4 then (DYNdefRLsizeXML = FUNnewSize)
  )

  fn DYNFUNmakeTvMenu =
  (
    DYNcveImport.LOCtvMenu = undefined
    if DYNcveImport.dnTree.nodes.count > 0 then
    (
      rcmenu LOCtvMenu
      (
        menuItem  MNDYNcollapse  checked:false
        menuItem  MNDYNexpand    checked:false

        on LOCtvMenu open do
        (
          MNDYNcollapse.text  = DYNuiResourcesMenus[12]
          MNDYNexpand.text    = DYNuiResourcesMenus[13]

          if DYNcveImport.dnTree.selectedNode == undefined then
          (
            MNDYNcollapse.enabled = false
            MNDYNexpand.enabled   = false
          )
        )

        on MNDYNcollapse picked do
        (
          local LOCdnRootNode = DYNcveImport.dnTree.selectedNode

          LOCdnRootNode.collapse()
          for i = 1 to LOCdnRootNode.nodes.count do
          (
            local LOCitem1 = LOCdnRootNode.nodes.item[i-1]
            LOCitem1.collapse()
            for ii = 1 to LOCitem1.nodes.count do
            (
              local LOCitem2 = LOCitem1.nodes.item[ii-1]
              LOCitem2.collapse()
            )
          )
          DYNcveImport.dnTree.selectedNode.ensureVisible()
        )
        on MNDYNexpand picked   do
        (
          local LOCdnRootNode = DYNcveImport.dnTree.selectedNode

          LOCdnRootNode.expand()
          for i = 1 to LOCdnRootNode.nodes.count do
          (
            local LOCitem1 = LOCdnRootNode.nodes.item[i-1]
            LOCitem1.expand()
            for ii = 1 to LOCitem1.nodes.count do
            (
              local LOCitem2 = LOCitem1.nodes.item[ii-1]
              LOCitem2.expand()
            )
          )
          DYNcveImport.dnTree.selectedNode.ensureVisible()
        )
      )
    )
  )

  fn DYNFUNmakeModelLvMenu FUNlv =
  (
    DYNcveImport.LOCmodelLvMenu = undefined
    if DYNcveImport.dnModels.Items.count > 0 then
    (
      rcmenu LOCmodelLvMenu
      (
        menuItem  MNDYNselectAll1  checked:false
        menuItem  MNDYNselectNone1 checked:false
        separator MNDYNseparator1
        menuItem  MNDYNselectAll2  checked:false
        menuItem  MNDYNselectNone2 checked:false

        on LOCmodelLvMenu open do
        (
          MNDYNselectAll1.text  = DYNuiResourcesMenus[25]
          MNDYNselectNone1.text = DYNuiResourcesMenus[26]
          MNDYNselectAll2.text  = DYNuiResourcesMenus[27]
          MNDYNselectNone2.text = DYNuiResourcesMenus[28]
        )

        on MNDYNselectAll1  picked do (DYNcveImport.DYNFUNselectCveElements DYNcveImport.dnModels DYNcveImport.dnStrings "" true 1)
        on MNDYNselectNone1 picked do (DYNcveImport.DYNFUNselectCveElements DYNcveImport.dnModels DYNcveImport.dnStrings "" false 1)
        on MNDYNselectAll2  picked do (DYNcveImport.DYNFUNselectCveElements DYNcveImport.dnModels DYNcveImport.dnStrings "" true 0)
        on MNDYNselectNone2 picked do (DYNcveImport.DYNFUNselectCveElements DYNcveImport.dnModels DYNcveImport.dnStrings "" false 0)
      )
      registerRightClickMenu DYNcveImport.LOCmodelLvMenu
    )
  )


  fn DYNFUNmakeElemLvMenu FUNlv =
  (
    DYNcveImport.LOCelemLvMenu = undefined
    if DYNcveImport.dnStrings.Items.count > 0 then
    (
      local LOCexe = "rcmenu LOCelemLvMenu\n"
      LOCexe += "(\n"
      LOCexe += "  menuItem  MNDYNselectAll          checked:false\n"
      LOCexe += "  menuItem  MNDYNselectNone         checked:false\n"
      LOCexe += "  separator MNDYNseparator1\n"
      LOCexe += "  menuItem  MNDYNselectHighAll      checked:false\n"
      LOCexe += "  menuItem  MNDYNselectHighNone     checked:false\n"
      LOCexe += "  separator MNDYNseparator2\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesMenus[29] + "\"\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNselectTypeAll    checked:false\n"
      LOCexe += "    menuItem  MNDYNselectTypeNone   checked:false\n"
      LOCexe += "  )\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesMenus[30] + "\"\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNselectSubRefAll  checked:false\n"
      LOCexe += "    menuItem  MNDYNselectSubRefNone checked:false\n"
      LOCexe += "  )\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesMenus[31] + "\"\n"
      LOCexe += "  (\n"
      LOCexe += "    menuItem  MNDYNselectLabelAll   checked:false\n"
      LOCexe += "    menuItem  MNDYNselectLabelNone  checked:false\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on LOCelemLvMenu open do\n"
      LOCexe += "  (\n"
      LOCexe += "    MNDYNselectSubRefNone.enabled = MNDYNselectSubRefAll.enabled = if DYNcveImportMode == 1 or DYNcveImportMode == 2 then true else false\n"
      LOCexe += "    MNDYNselectAll.text           = DYNuiResourcesMenus[14]\n"
      LOCexe += "    MNDYNselectNone.text          = DYNuiResourcesMenus[15]\n"
      LOCexe += "    MNDYNselectHighAll.text       = DYNuiResourcesMenus[16]\n"
      LOCexe += "    MNDYNselectHighNone.text      = DYNuiResourcesMenus[17]\n"
      LOCexe += "    MNDYNselectTypeAll.text       = DYNuiResourcesMenus[18]\n"
      LOCexe += "    MNDYNselectTypeNone.text      = DYNuiResourcesMenus[19]\n"
      LOCexe += "    MNDYNselectSubRefAll.text     = DYNuiResourcesMenus[18]\n"
      LOCexe += "    MNDYNselectSubRefNone.text    = DYNuiResourcesMenus[19]\n"
      LOCexe += "    MNDYNselectLabelAll.text      = DYNuiResourcesMenus[18]\n"
      LOCexe += "    MNDYNselectLabelNone.text     = DYNuiResourcesMenus[19]\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNselectAll        picked do (DYNcveImport.DYNFUNselectCveElements DYNcveImport.dnModels DYNcveImport.dnStrings \"\" true 1)\n"
      LOCexe += "  on MNDYNselectNone       picked do (DYNcveImport.DYNFUNselectCveElements DYNcveImport.dnModels DYNcveImport.dnStrings \"\" false 1)\n"
      LOCexe += "  on MNDYNselectHighAll    picked do (DYNcveImport.DYNFUNselectCveElements DYNcveImport.dnModels DYNcveImport.dnStrings \"\" true 4)\n"
      LOCexe += "  on MNDYNselectHighNone   picked do (DYNcveImport.DYNFUNselectCveElements DYNcveImport.dnModels DYNcveImport.dnStrings \"\" false 4)\n"
      LOCexe += "  on MNDYNselectTypeAll    picked do (DYNcveImport.DYNFUNselectCveElements DYNcveImport.dnModels DYNcveImport.dnStrings DYNcveImport.dnStrings.selectedItems.item[0].SubItems.item[(if DYNcveImportMode == 3 then 1 else 2)].text true 3)\n"
      LOCexe += "  on MNDYNselectTypeNone   picked do (DYNcveImport.DYNFUNselectCveElements DYNcveImport.dnModels DYNcveImport.dnStrings DYNcveImport.dnStrings.selectedItems.item[0].SubItems.item[(if DYNcveImportMode == 3 then 1 else 2)].text false 3)\n"
      LOCexe += "  on MNDYNselectSubRefAll  picked do (DYNcveImport.DYNFUNselectCveElements DYNcveImport.dnModels DYNcveImport.dnStrings DYNcveImport.dnStrings.selectedItems.item[0].SubItems.item[1].text true 5)\n"
      LOCexe += "  on MNDYNselectSubRefNone picked do (DYNcveImport.DYNFUNselectCveElements DYNcveImport.dnModels DYNcveImport.dnStrings DYNcveImport.dnStrings.selectedItems.item[0].SubItems.item[1].text false 5)\n"
      LOCexe += "  on MNDYNselectLabelAll   picked do (DYNcveImport.DYNFUNselectCveElements DYNcveImport.dnModels DYNcveImport.dnStrings ((subString DYNcveImport.dnStrings.selectedItems.item[0].text 1 1) + \"*\") true 2)\n"
      LOCexe += "  on MNDYNselectLabelNone  picked do (DYNcveImport.DYNFUNselectCveElements DYNcveImport.dnModels DYNcveImport.dnStrings ((subString DYNcveImport.dnStrings.selectedItems.item[0].text 1 1) + \"*\") false 2)\n"
      LOCexe += ")\n"

      DYNcveImport.LOCelemLvMenu = Execute LOCexe

      registerRightClickMenu DYNcveImport.LOCelemLvMenu
    )
  )

  --- SECTION 3 - PANEL LAYOUT ------------------------------
  button BUABOdir width:155 height:20 pos:[8,9]

  dropdownlist DDDYNobjectType  pos:[170,9]  width:140 enabled:false
  button BUABOadd1 width:20 height:20 pos:[312,9] enabled:false iconName:"CivilView/SelectStrings" iconSize:[16,16]
  button BUABOrem1 width:20 height:20 pos:[335,9] enabled:false iconName:"CivilView/DeselectStrings" iconSize:[16,16]

  edittext EDDYNobjectName  pos:[358,11] enabled:false text:"*" width:140
  button BUABOadd2 width:20 height:20 pos:[502,9] enabled:false iconName:"CivilView/UseWildCard" iconSize:[16,16]
  button BUABOrem2 width:20 height:20 pos:[525,9] enabled:false iconName:"CivilView/DeselectWildCard" iconSize:[16,16]

  dotNetControl  dnSplitter "System.Windows.Forms.SplitContainer"  height:383 width:976 pos:[8,35]
  dotNetControl  dnModels   "System.Windows.Forms.ListView"        height:383 width:300 pos:[8,35]
  dotNetControl  dnStrings  "System.Windows.Forms.ListView"        height:383 width:300 pos:[328,35]
  dotNetControl  dnProgress "System.Windows.Forms.ProgressBar"     height:14  width:976 pos:[8,(dnSplitter.height + dnSplitter.pos.y + 39)]
  dotNetControl  dnStatus   "System.Windows.Forms.StatusBar"       height:20  width:987 pos:[8,(dnSplitter.height + dnSplitter.pos.y + 69)]
  dotNetControl  dnTree     "System.Windows.Forms.TreeView"        height:383 width:300 pos:[8,35]

  checkbox CKDYNfeatureOn        pos:[10 ,(dnSplitter.height + dnSplitter.pos.y + 9 + 3)]  width:150
  dropdownlist DDDYNfeatureList  pos:[165,(dnSplitter.height + dnSplitter.pos.y + 9)]  width:175 enabled:false
  button BUDYNfeatureEdit        pos:[343,(dnSplitter.height + dnSplitter.pos.y + 9)]  width:80  height:20
  button BUDYNfeatureNew         pos:[428,(dnSplitter.height + dnSplitter.pos.y + 9)]  width:80  height:20

  button BUDYNokok  width:80 pos:[(DYNdefRLsizeCVE.x - 432),(dnSplitter.height + dnSplitter.pos.y + 9)] height:20 enabled:false
  button BUDYNapply width:80 pos:[(DYNdefRLsizeCVE.x - 347),(dnSplitter.height + dnSplitter.pos.y + 9)] height:20 enabled:false
  button BUDYNcanc  width:80 pos:[(DYNdefRLsizeCVE.x - 262),(dnSplitter.height + dnSplitter.pos.y + 9)] height:20
  button BUDYNopts  width:80 pos:[(DYNdefRLsizeCVE.x - 177),(dnSplitter.height + dnSplitter.pos.y + 9)] height:20
  button BUDYNhelp  width:80 pos:[(DYNdefRLsizeCVE.x - 92), (dnSplitter.height + dnSplitter.pos.y + 9)] height:20

  --- SECTION 4 - ROLLOUTS EVENTS ---------------------------
  on DYNcveImport open do
  (
    clearSelection()
    gc()

    --- Set Titlebar Content Depending on File Format Mode Selected
    if DYNcveImportMode == 1 then LOCrolloutTitle        = DYNuiRolloutNames[43] -- Genio Import Mode
    if DYNcveImportMode == 2 then LOCrolloutTitle        = DYNuiRolloutNames[44] -- Model File Import Mode
    if DYNcveImportMode == 3 then LOCrolloutTitle        = DYNuiRolloutNames[45] -- 12d Ascii Import Mode
    if DYNcveImportMode == 4 then LOCrolloutTitle        = DYNuiRolloutNames[63] -- LandXML Import Mode
    DYNcveImport.title  = DYNcveImport.LOCrolloutTitle

    --- ----------------------
    LOCsourceFile         = undefined
    LOCsourceFilePath     = undefined

    --- Set Up Standard Items On Panel
    BUDYNopts.text      = DYNuiResourcesButtons[4]
    BUDYNokok.text      = DYNuiResourcesButtons[1]
    BUDYNapply.text     = DYNuiResourcesButtons[2]
    BUDYNcanc.text      = DYNuiResourcesButtons[3]
    BUDYNhelp.text      = DYNuiResourcesButtons[5]
    BUABOdir.caption    = DYNuiResourcesButtons[6]
    dnStatus.text       = DYNuiResourcesStatusMessages[16]

    --- Set Default Path for Files of each format supported
    if DYNcveImportMode == 1 then LOCsourceFilePath = rootNode.DYNrootNodeStore.genPath
    if DYNcveImportMode == 2 then LOCsourceFilePath = rootNode.DYNrootNodeStore.mfwPath
    if DYNcveImportMode == 3 then LOCsourceFilePath = rootNode.DYNrootNodeStore.twdPath
    if DYNcveImportMode == 4 then LOCsourceFilePath = rootNode.DYNrootNodeStore.xmlPath

    --- Check whether any objects already exist in the scene do decide whether a zoom extents is necessary
    if objects.count == 0 then LOCobjectsAlreadyExist = false else LOCobjectsAlreadyExist = true

    --- Set Up FIS Default
    DYNFUNsetUpFeatureInterpControls DYNcveImport

    --- Set Up LandXML Model TreeView
    DYNFUNdnTreeViewStyle dnTree
    dnTree.ImageList = DYNdnSmImageList
    dnTree.showNodeToolTips = true

    --- Set Up DotNet MOdels ListView
    DYNFUNdnListViewStyle dnModels false true
    dnModels.multiSelect         = false
    dnModels.AllowColumnReorder  = true
    dnModels.sorting             = DYNdnSortOrderClass.ascending
    local LOCcol1   = dnModels.Columns.add DYNuiResourcesLvColumns[90] 220
    local LOCcol2   = dnModels.Columns.add DYNuiResourcesLvColumns[83]  70  ; LOCcol2.textAlign = DYNdnHorAlignClass.center
    local LOCcol3   = dnModels.Columns.add DYNuiResourcesLvColumns[84]  90  ; LOCcol3.textAlign = DYNdnHorAlignClass.center
    local LOCcol4   = dnModels.Columns.add DYNuiResourcesLvColumns[85] 145  ; LOCcol4.textAlign = DYNdnHorAlignClass.center
    dnModels.smallImageList = DYNdnSmImageList

    --- Set Up Object List ListView Control
    DYNFUNdnListViewStyle dnStrings true true
    dnStrings.AllowColumnReorder = true
    dnStrings.smallImageList     = DYNdnSmImageList

    -- Set Up ListView Control for 12d Ascii File Import
    if DYNcveImportMode == 3 then
    (
      local LOCcol1 = dnStrings.Columns.add DYNuiResourcesLvColumns[86] 130
      local LOCcol2 = dnStrings.Columns.add DYNuiResourcesLvColumns[87] 130 ; LOCcol2.textAlign = DYNdnHorAlignClass.center
      local LOCcol3 = dnStrings.Columns.add DYNuiResourcesLvColumns[88]  90 ; LOCcol3.textAlign = DYNdnHorAlignClass.center
      local LOCcol4 = dnStrings.Columns.add ""                           40 ; LOCcol4.textAlign = DYNdnHorAlignClass.center
      dnStrings.sorting            = DYNdnSortOrderClass.ascending
    )

    -- Set Up ListView Control for LandXML File Import
    if DYNcveImportMode == 4 then
    (
      local LOCcol1 = dnStrings.Columns.add DYNuiResourcesLvColumns[55] 210
      local LOCcol2 = dnStrings.Columns.add DYNuiResourcesGroups[18]    180 ; LOCcol2.textAlign = DYNdnHorAlignClass.left
      local LOCcol3 = dnStrings.Columns.add DYNuiResourcesLvColumns[31] 120 ; LOCcol3.textAlign = DYNdnHorAlignClass.left
      local LOCcol4 = dnStrings.Columns.add DYNuiResourcesLvColumns[10]  65 ; LOCcol4.textAlign = DYNdnHorAlignClass.center
      local LOCcol5 = dnStrings.Columns.add DYNuiResourcesLvColumns[11]  65 ; LOCcol5.textAlign = DYNdnHorAlignClass.center
      dnStrings.sorting            = DYNdnSortOrderClass.ascending
    )

    -- Set Up ListView Control for MX based File Import (Model File and Genio)
    if DYNcveImportMode != 3 and DYNcveImportMode != 4 then
    (
      local LOCcol1 = dnStrings.Columns.add DYNuiResourcesLvColumns[86]  90
      local LOCcol2 = dnStrings.Columns.add DYNuiResourcesLvColumns[89]  60 ; LOCcol2.textAlign = DYNdnHorAlignClass.center
      local LOCcol3 = dnStrings.Columns.add DYNuiResourcesLvColumns[87] 180 ; LOCcol3.textAlign = DYNdnHorAlignClass.center
      local LOCcol4 = dnStrings.Columns.add ""                           60 ; LOCcol4.textAlign = DYNdnHorAlignClass.center
      dnStrings.sorting            = DYNdnSortOrderClass.ascending
    )

    --- Set Up DotNet Splitter Control
    dnsplitter.suspendLayout()
    dnsplitter.panel1.suspendLayout()
    dnsplitter.panel2.suspendLayout()
    dnsplitter.Orientation      = (dotNetClass "System.Windows.Forms.Orientation").Vertical
    dnsplitter.isSplitterFixed  = true

    if DYNcveImportMode == 4 then
    (
      -- Set Up Splitter Control for LandXML
      dnsplitter.splitterDistance = 301
      dnsplitter.backcolor        = DYNFUNdnColor (((colorMan.getColor #background) as color) * 255)
      dnSplitter.panel1.controls.add dnTree
      dnTree.dock = DYNdnDockClass.fill
      dnsplitter.panel1.resumeLayout()
    )
    else
    (
      -- Set Up Splitter Control for file formats other than LandXML
      dnsplitter.splitterDistance = 550
      dnsplitter.backcolor        = DYNFUNdnColor (((colorMan.getColor #background) as color) * 255)
      dnSplitter.panel1.controls.add dnModels
      dnModels.dock = DYNdnDockClass.fill
      dnsplitter.panel1.resumeLayout()
    )

    dnSplitter.panel2.controls.add dnStrings
    dnStrings.dock = DYNdnDockClass.fill
    dnsplitter.panel2.resumeLayout()

    dnsplitter.resumeLayout()
    dnsplitter.panel1.refresh()
    dnsplitter.panel2.refresh()

    ---- Resize Dialog According to which file format mode is selected
    if DYNcveImportMode == 1 then (DYNFUNresizeCVEimporter DYNdefRLsizeGEN DYNcveImportMode)
    if DYNcveImportMode == 2 then (DYNFUNresizeCVEimporter DYNdefRLsizeMXM DYNcveImportMode)
    if DYNcveImportMode == 3 then (DYNFUNresizeCVEimporter DYNdefRLsize12D DYNcveImportMode)
    if DYNcveImportMode == 4 then (DYNFUNresizeCVEimporter DYNdefRLsizeXML DYNcveImportMode)

    --- Load Prerequisite Settings and Components
    DYNFUNreadImportColorAndMatIdConfigFile()
    DYNFUNloadCVEImportComponents DYNbinPath DYNINIungpMatChan DYNINIgreyedOutColor

    --- Temporarily Disable Import Button for LandXML Mode
    /*
    if DYNcveImportMode == 4 then BUABOdir.enabled = false
    */
  )

  on DYNcveImport close do
  (
    --- Recycle the reader object (force disposal)
    if DYNdnGenioConverter != undefined then DYNdnGenioConverter.Recycle()
    if DYNdnMxConverter    != undefined then DYNdnMxConverter.Recycle()
    if DYNdn12dConverter   != undefined then DYNdn12dConverter.Recycle()
    if DYNdnXmlConverter   != undefined then DYNdnXmlConverter.Recycle()

    --- Clear Global VSP3D Object Arrays
    DYNmxPointStrings       = #()
    DYNmxShapeStrings       = #()
    DYNmxSurfaceStrings     = #()
    DYN12dPointStrings      = #()
    DYN12dShapeStrings      = #()
    DYN12dSurfaceStrings    = #()
    DYNxmlPointStrings      = #()
    DYNxmlShapeStrings      = #()
    DYNxmlSurfaceStrings    = #()
    DYNcveReadErrorArray    = #()
    DYNcveBuildErrorArray   = #()

    --- Other Items
    LOCsourceFile           = undefined
    LOCsourceFilePath       = undefined
    LOCstringTypeList       = #()

    dnModels.Items.clear()
    dnStrings.Items.clear()
    DYNFUNonDialogClose()
  )

  on BUABOdir pressed do
  (
    gc()
    local LOCtempSourceFile

    if DYNcveImportMode == 1 then LOCtempSourceFile = getOpenFileName caption:DYNuiResourcesTitlebars[5]  filename:LOCsourceFilePath types:DYNuiResourcesFileTypes[2]
    if DYNcveImportMode == 2 then LOCtempSourceFile = getOpenFileName caption:DYNuiResourcesTitlebars[6]  filename:LOCsourceFilePath types:DYNuiResourcesFileTypes[3]
    if DYNcveImportMode == 3 then LOCtempSourceFile = getOpenFileName caption:DYNuiResourcesTitlebars[7]  filename:LOCsourceFilePath types:DYNuiResourcesFileTypes[1]
    if DYNcveImportMode == 4 then LOCtempSourceFile = getOpenFileName caption:DYNuiResourcesTitlebars[46] filename:LOCsourceFilePath types:DYNuiResourcesFileTypes[4]

    if LOCtempSourceFile != undefined then
    (
      LOCsourceFile             = LOCtempSourceFile
      dnStatus.text             = DYNuiResourcesStatusMessages[2]
      DYNcveImport.title        = DYNcveImport.LOCrolloutTitle + " [" + (filenamefrompath LOCsourceFile) + "]"
      DDDYNobjectType.selection = 1
      EDDYNobjectName.text      = "*"

      --- Prepare UI by clearing ListView Contents and Displaying Filename in TitleBar, and Resetting DropDown Lists
      dnTree.Nodes.clear()
      dnModels.Items.clear()
      dnStrings.Items.clear()

      --- Scan Contents of Source File
      if DYNcveImportMode == 1 then -- for genio files
      (
        dnStrings.columns.item[3].text = ""
        LOCconverter = DYNdnGenioConverter
      )
      if DYNcveImportMode == 2 then -- for model files
      (
        dnStrings.columns.item[3].text = DYNuiResourcesLvColumns[32]
        LOCconverter = DYNdnMxConverter
      )
      if DYNcveImportMode == 3 then -- for 12d files
      (
        LOCconverter = DYNdn12dConverter
      )
      if DYNcveImportMode == 4 then -- for LandXML files
      (
        LOCconverter = DYNdnXmlConverter
      )

      local LOCpreLoadedStrings = DYNFUNcheckForImportedObjects() -- Make an array of strings which have already been imported into scene
      local LOCreadSuccess      = DYNFUNreadCVEfile LOCconverter LOCsourceFile LOCpreLoadedStrings DYNFUNcveOnModelFoundEvent DYNFUNcveOnScanProgressEvent DYNFUNcveOnElementFoundEvent DYNINIungpMatChan DYNINIgreyedOutColor DYNcveImportMode

      --- Display Contents of Source File in UI
      if LOCreadSuccess then
      (
        DYNcveImport.DYNFUNfullDisplayUpdate LOCconverter DYNcveImportMode LOCsourceFile
      )

      --- Set Remaining UI Items
      local LOCifSupportedDataFound = if DYNcveImportMode == 4 then dnStrings.Items.count > 0 else dnModels.Items.count > 0

      if LOCifSupportedDataFound then
      (
        DDDYNobjectType.enabled   = true
        EDDYNobjectName.enabled   = true
        BUABOadd1.enabled         = true
        BUABOrem1.enabled         = true
        BUABOadd2.enabled         = true
        BUABOrem2.enabled         = true
        BUDYNokok.enabled         = true
        BUDYNapply.enabled        = true
        LOCsourceFilePath         = LOCsourceFile
      )
      else
      (
        dnStatus.text             = DYNuiResourcesStatusMessages[16]
        LOCsourceFile             = undefined
        DYNcveImport.title        = DYNcveImport.LOCrolloutTitle
        DDDYNobjectType.enabled   = false
        EDDYNobjectName.enabled   = false
        BUABOadd1.enabled         = false
        BUABOrem1.enabled         = false
        BUABOadd2.enabled         = false
        BUABOrem2.enabled         = false
        BUDYNokok.enabled         = false
        BUDYNapply.enabled        = false
        if LOCreadSuccess then
        (
        messagebox DYNuiResourcesErrorsWarnings[21] title:DYNuiResourcesTitlebars[3]
      )
        else
        (
          messagebox DYNuiResourcesErrorsWarnings[20] title:DYNuiResourcesTitlebars[1]
        )
      )
      dnProgress.value = 0
    )
  )


  on BUABOadd1 pressed do
  (
    if DDDYNobjectType.selection == 1 then (DYNFUNselectCveElements dnModels dnStrings "" true 1) else (DYNFUNselectCveElements dnModels dnStrings DDDYNobjectType.selected true 3)
  )

  on BUABOrem1 pressed do
  (
    if DDDYNobjectType.selection == 1 then (DYNFUNselectCveElements dnModels dnStrings "" false 1) else (DYNFUNselectCveElements dnModels dnStrings DDDYNobjectType.selected false 3)
  )


  on BUABOadd2 pressed do
  (
    if EDDYNobjectname.text != "" then
    (
      if DDDYNobjectType.selection == 1 then
      (
        DYNFUNselectCveElements dnModels dnStrings EDDYNobjectname.text true 2
      )
      else
      (
        local LOCindex = if DYNcveImportMode == 3 then 1 else 2
        for i = 1 to dnStrings.items.count do
        (
          if (matchPattern dnStrings.items.item[i - 1].text pattern:EDDYNobjectname.text             ignoreCase:true) and \
             (matchPattern dnStrings.items.item[i - 1].subitems.item[LOCindex].text pattern:DDDYNobjectType.selected ignoreCase:true) then
          (
            dnStrings.items.item[i - 1].checked = true
          )
        )
      )
    )
    else
    (
      messagebox DYNuiResourcesErrorsWarnings[18] title:DYNuiResourcesTitlebars[3] beep:false
    )

  )

  on BUABOrem2 pressed do
  (
    if EDDYNobjectname.text != "" then
    (
      if DDDYNobjectType.selection == 1 then
      (
        DYNFUNselectCveElements dnModels dnStrings EDDYNobjectname.text false 2
      )
      else
      (
        for i = 1 to dnStrings.items.count do
        (
          local LOCindex = if DYNcveImportMode == 3 then 1 else 2
          if (matchPattern dnStrings.items.item[i - 1].text pattern:EDDYNobjectname.text             ignoreCase:true) and \
             (matchPattern dnStrings.items.item[i - 1].subitems.item[LOCindex].text pattern:DDDYNobjectType.selected ignoreCase:true) then
          (
            dnStrings.items.item[i - 1].checked = false
          )
        )
      )
    )
    else
    (
      messagebox DYNuiResourcesErrorsWarnings[18] title:DYNuiResourcesTitlebars[3] beep:false
    )
  )

  on dnTree MouseDown arg1 arg2 do
  (
    --- This Control Is Only Used during LandXML Import Mode
    local LOCnode = dnTree.getNodeAt arg2.x arg2.y
    if LOCnode != undefined then
    (
      dnTree.selectedNode = LOCnode
      DYNFUNlandXMLobjectListDisplayUpdate LOCconverter LOCnode
    )
  )

  on dnTree MouseUp arg1 arg2 do
  (
    if arg2.button == DYNdnmouseClass.right then
    (
      DYNFUNmakeTvMenu()
      if DYNcveImport.LOCtvMenu != undefined then popupMenu DYNcveImport.LOCtvMenu
    )
  )

  on dnModels ItemSelectionChanged arg do
  (
    --- This control is used for all file formats except LandXML
    if arg.isSelected then
    (
      DYNFUNstringDisplayUpdate LOCconverter arg.item.tag DYNcveImportMode
    )
  )

  on dnModels MouseUp arg do
  (
    --- This control is used for all file formats except LandXML
    if arg.button == DYNdnmouseClass.right then
    (
      DYNFUNmakeModelLvMenu dnModels
      if LOCmodelLvMenu != undefined then popupMenu LOCmodelLvMenu
    )
  )


  on dnStrings MouseUp arg do
  (
    if arg.button == DYNdnmouseClass.right then
    (
      DYNFUNmakeElemLvMenu dnStrings
      if LOCelemLvMenu != undefined then popupMenu LOCelemLvMenu
    )
  )

  on dnStrings ItemChecked arg do
  (
    if LOCallowItemCheck then
    (
      -- don't allow selection of unavailable/unsupported/invalid items which might be listed in the UI
      if arg.item.tag != undefined then
      (
          arg.item.tag.isSelected = arg.item.checked
        )
      else arg.item.checked = false
    )
  )

  on dnModels ColumnClick arg do
  (
    --- This control is used for all file formats except LandXML
    /* arg.column (to get to index of selected column) */
    if dnModels.sorting == DYNdnSortOrderClass.none       then
    (
      dnModels.sorting = DYNdnSortOrderClass.ascending
    )
    else
    (
      if dnModels.sorting == DYNdnSortOrderClass.ascending  then
      (
        dnModels.sorting = DYNdnSortOrderClass.descending
      )
      else
      (
        if dnModels.sorting == DYNdnSortOrderClass.descending then dnModels.sorting = DYNdnSortOrderClass.ascending
      )
    )
    if dnModels.selectedItems.count > 0 then dnModels.selectedItems.item[0].ensureVisible()
  )

  on dnStrings ColumnClick arg do
  (
    /* arg.column (to get to index of selected column) */
    if dnStrings.sorting == DYNdnSortOrderClass.none       then
    (
      dnStrings.sorting = DYNdnSortOrderClass.ascending
    )
    else
    (
      if dnStrings.sorting == DYNdnSortOrderClass.ascending  then
      (
        dnStrings.sorting = DYNdnSortOrderClass.descending
      )
      else
      (
        if dnStrings.sorting == DYNdnSortOrderClass.descending then dnStrings.sorting = DYNdnSortOrderClass.ascending
      )
    )
    if dnStrings.selectedItems.count > 0 then dnStrings.selectedItems.item[0].ensureVisible()
  )

  on DYNcveImport resized argPt2 do (DYNFUNresizeCVEimporter argPt2 DYNcveImportMode)
  on DYNcveImport moved argPt2 do
  (
    if DYNcveImportMode == 1 then DYNgenLUP = argPt2
    if DYNcveImportMode == 2 then DYNmxfLUP = argPt2
    if DYNcveImportMode == 3 then DYN12dLUP = argPt2
    if DYNcveImportMode == 4 then DYNxmlLUP = argPt2
  )

  on CKDYNfeatureOn changed arg do
  (
    DDDYNfeatureList.enabled = arg
    if DDDYNfeatureList.selection == 0 and DDDYNfeatureList.items.count > 0 then DDDYNfeatureList.selection = 1
    if arg then
    (
      local LOCtempArray = DYNFUNparsePARAMfile (DYNfeatureInterp.DYNFUNfisStringToFullPath DDDYNfeatureList.selected) "4001"
      if LOCtempArray.count == 0 then messagebox DYNuiResourcesErrorsWarnings[17] title:DYNuiResourcesTitlebars[2]
    )
  )

  on DDDYNfeatureList selected arg do
  (
    local LOCtempArray = DYNFUNparsePARAMfile (DYNfeatureInterp.DYNFUNfisStringToFullPath DDDYNfeatureList.selected) "4001"
    if LOCtempArray.count == 0 then messagebox DYNuiResourcesErrorsWarnings[17] title:DYNuiResourcesTitlebars[2]
  )

  on BUDYNfeatureNew pressed do (macros.run "Civil View" "MCRfeatureInterp")

  on BUDYNfeatureEdit pressed do
  (
    macros.run "Civil View" "MCRfeatureInterp"
    if DDDYNfeatureList.items.count > 0 and DDDYNfeatureList.selection > 0 then
    (
      DYNfeatureInterp.DYNFUNopenFeatureInterpStyle DDDYNfeatureList.selected 1
    )
  )

  on BUDYNapply pressed do
  (
    local LOCnumSelElems = 0
    case DYNcveImportMode of
    (
      1 : LOCnumSelElems = LOCconverter.reader.NumberOfSelectedElements
      2 : LOCnumSelElems = LOCconverter.reader.NumberOfSelectedElements
      3 : LOCnumSelElems = LOCconverter.ModelContainer.NumberOfSelectedElements
      4 : LOCnumSelElems = DYNFUNcountSelectedLandXMLelements LOCconverter
    )

    if LOCnumSelElems > 0 then
    (
      local LOCoutArray = DYNFUNimportCVEfileWrapper LOCconverter LOCsourceFile CKDYNfeatureOn.checked LOCsourceFilePath LOCobjectsAlreadyExist dnProgress dnStatus DDDYNfeatureList.selected DYNcveImportMode

      /*
        -------------------------------------------------------
        Converter.PrepareForReentry()
        -------------------------------------------------------
        This is a workaround because the cores don't really deal
        with a selection/read re-entry process without there being some work done to
        prepare for it.

        So, if you scan a file, show the UI, perform selection and conversion/writing,
        everything is still in memory (except the Vesper data which is destroyed after
        writing it). This includes the scan map and all the data that was read for
        elements that were selected.

        What this method *really* does is go through all models and elements and checks
        if the element IsSelected. If it IsSelected it will *clear* the data from the
        element and flags IsSelected to FALSE and IsValid to FALSE.
        This will effectively "kick out" the elements from the other methods in the
        converter. The scan map of those elements is *still* there (there is no such
        thing as actual deletion of that in the core's) but by forcing IsSelected and
        IsValid to false prevents you from "getting them".

        So before you do any re-entry selection-read-convert-write stuff you need to
        call this method. It should be safe to keep calling it prior to *each* re-entry
        to clean up the data that was generated and read during the reading process.
        It's sort of a little "sweeper" to get rid of the crap that shouldn't be present
        at a re-entry.

        Now, how you want to deal with this in the UI and how the interaction mechanism
        works, I don't know. I also don't know if you still want the items to be visible
        in the LV's or not, etc. but either way, this method is going to be crucial to
        the re-entry selection functionality. Whatever we need to do to facilitate that
        should be done inside this method and be called in the manner described above.
      */
      LOCconverter.PrepareForReentry()

      --- repopulate string list
      if DYNcveImportMode == 4 then
      (
        -- LandXML Only
        DYNFUNlandXMLobjectListDisplayUpdate LOCconverter dnTree.selectedNode
      )
      else
      (
        -- All Other Supported File Formats
        DYNFUNstringDisplayUpdate LOCconverter dnModels.selectedItems.item[0].tag DYNcveImportMode
      )
    )
    else (messagebox DYNuiResourcesErrorsWarnings[19] title:DYNuiResourcesTitlebars[3])
  )

  on BUDYNokok pressed do
  (
    local LOCnumSelElems = 0
    case DYNcveImportMode of
    (
      1 : LOCnumSelElems = LOCconverter.reader.NumberOfSelectedElements
      2 : LOCnumSelElems = LOCconverter.reader.NumberOfSelectedElements
      3 : LOCnumSelElems = LOCconverter.ModelContainer.NumberOfSelectedElements
      4 : LOCnumSelElems = DYNFUNcountSelectedLandXMLelements LOCconverter
    )

    if LOCnumSelElems > 0 then
    (
      local LOCoutArray = DYNFUNimportCVEfileWrapper LOCconverter LOCsourceFile CKDYNfeatureOn.checked LOCsourceFilePath LOCobjectsAlreadyExist dnProgress dnStatus DDDYNfeatureList.selected DYNcveImportMode
      destroyDialog DYNcveImport
    )
    else (messagebox DYNuiResourcesErrorsWarnings[19] title:DYNuiResourcesTitlebars[3])
  )

  on BUDYNopts pressed do
  (
    DYNFUNopenPreferencesPanel 6
  )

  on BUDYNcanc pressed do destroyDialog DYNcveImport

  on BUDYNhelp pressed do
  (
    case DYNcveImportMode of
    (
      1 : DYNFUNopenHelp 13216 -- id_cv_import_genio
      2 : DYNFUNopenHelp 13212 -- id_cv_import_mx
      3 : DYNFUNopenHelp 13211 -- id_cv_import_12d_ascii
      4 : DYNFUNopenHelp 13222 -- id_cv_import_landxml
      default : DYNFUNopenHelp 13201 -- id_cv_civil_view_welcome
    )
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAq4zd3ZL1DZCIPfkixTwbOLmNV4blgk1e3
-- p2hBUflhY5QjfgWv3EH5ARIKFygxyQ0relz094BYtsROPVoge2ndanVfDheCQfrq
-- FYd3DArk6aOZHfDzGNsTjkb5I7OyLC9hmlwui5HBYBzjrPLdBJJOYB9t73HevbU7
-- LV0lc19g0gb8A4PCiD3K5WlP+g9XYsrmO8OhMAObstBge549s9AkCOAuP0rDnHWQ
-- i0E6nDhkrPT9oJVal2N766bBN+iMu3U3umQ2HD8/c2dnyIZ+D2Mb5v2Ej6r6bSX6
-- lFv8M/yw5MR92ut9pg0zddr9hL9yBciGhNYLbrNODKu/W24Lx/xu
-- -----END-SIGNATURE-----