--- Function to Make VSP Surfaces Material
fn DYNFUNmakeCivilViewSurfaces FUNpath =
(
  local LOCmat

  --- Open CivilViewSurfaces Material Library File
  local LOCcivilViewSurfacesMatFile = "$matlibs\\" + DYNmatNameSurfaces + ".mat"
  local LOCcivilViewSurfacesMatLib  = loadTempMaterialLibrary LOCcivilViewSurfacesMatFile

  if doesFileExist LOCcivilViewSurfacesMatFile and LOCcivilViewSurfacesMatLib != undefined then
  (
    for i = 1 to LOCcivilViewSurfacesMatLib.count do
    (
      if LOCcivilViewSurfacesMatLib[i].name == DYNmatNameSurfaces and classOf LOCcivilViewSurfacesMatLib[i] == Multimaterial then LOCmat = LOCcivilViewSurfacesMatLib[i]
    )
  )

  --- If It Didn't Exist In The Material Library, Create A Fresh Material Now
  if LOCmat == undefined then
  (
    --- Create Material If Doesn't Already Exist
    LOCmat          = multiMaterial()
    LOCmat.name     = DYNmatNameSurfaces
    LOCmat.count    = 50

    --- Define Diffuse Maps Array
    local LOCdiffMaps   = #() ; LOCdiffMaps[50] = undefined
    LOCdiffMaps[1]  = FUNpath + "RoadwayAsphalt01.png"
    LOCdiffMaps[2]  = FUNpath + "RoadwayAsphalt01.png"
    LOCdiffMaps[3]  = FUNpath + "RoadwayAsphalt01.png"
    LOCdiffMaps[4]  = FUNpath + "RoadwayAsphalt01.png"
    LOCdiffMaps[5]  = FUNpath + "RoadwayAsphalt01.png"
    LOCdiffMaps[6]  = FUNpath + "Kerb.jpg"
    LOCdiffMaps[7]  = FUNpath + "AsphaltBasic.png"
    LOCdiffMaps[8]  = FUNpath + "RoadwayAsphalt02.png"
    LOCdiffMaps[9]  = FUNpath + "RoadwayAsphalt02.png"
    LOCdiffMaps[10] = FUNpath + "RoadwayAsphalt02.png"
    LOCdiffMaps[11] = FUNpath + "RoadwayAsphalt02.png"
    LOCdiffMaps[12] = FUNpath + "RoadwayAsphalt02.png"
    LOCdiffMaps[13] = FUNpath + "RoadwayConcrete01.png"
    LOCdiffMaps[14] = FUNpath + "RoadwayConcrete01.png"
    LOCdiffMaps[15] = FUNpath + "RoadwayConcrete01.png"
    LOCdiffMaps[16] = FUNpath + "RoadwayConcrete01.png"
    LOCdiffMaps[17] = FUNpath + "RoadwayConcrete01.png"
    LOCdiffMaps[18] = FUNpath + "AsphaltBasic.png"
    LOCdiffMaps[19] = FUNpath + "Red.Asphalt.png"
    LOCdiffMaps[20] = undefined -- ok
    LOCdiffMaps[21] = undefined -- ok
    LOCdiffMaps[22] = FUNpath + "Concrete.Cast-In-Place.Exposed Aggregate.Medium.jpg"
    LOCdiffMaps[23] = undefined -- ok
    LOCdiffMaps[24] = undefined -- ok
    LOCdiffMaps[25] = undefined -- ok
    LOCdiffMaps[26] = FUNpath + "Grass.jpg"
    LOCdiffMaps[27] = FUNpath + "Grass.jpg"
    LOCdiffMaps[28] = FUNpath + "Grass.jpg"
    LOCdiffMaps[29] = undefined -- ok
    LOCdiffMaps[30] = undefined -- ok
    LOCdiffMaps[31] = undefined -- ok
    LOCdiffMaps[32] = FUNpath + "gravel.jpg"
    LOCdiffMaps[33] = undefined -- ok
    LOCdiffMaps[34] = FUNpath + "Grass.jpg"
    LOCdiffMaps[35] = FUNpath + "SiteWork.Planting.Grass.StAugustine1.jpg"
    LOCdiffMaps[36] = FUNpath + "Sitework.Planting.Sand.jpg"
    LOCdiffMaps[37] = FUNpath + "Concrete.Cast-In-Place.Exposed Aggregate.Medium.jpg"
    LOCdiffMaps[38] = FUNpath + "Concrete.Cast-In-Place.Exposed Aggregate.Recessed.jpg"
    LOCdiffMaps[39] = FUNpath + "Asphalt.Zoab.png"
    LOCdiffMaps[40] = FUNpath + "Asphalt.Alt.png"
    LOCdiffMaps[41] = FUNpath + "Masonry.Stone.Granite.Square.Stacked.Polished.Grey.jpg"
    LOCdiffMaps[42] = FUNpath + "Sitework.Paving & Surfacing.Pavers.Terra Cotta.jpg"
    LOCdiffMaps[43] = FUNpath + "Brick_Herringbone_Red.jpg"
    LOCdiffMaps[44] = FUNpath + "Brick_Herringbone_Gray.jpg"
    LOCdiffMaps[45] = FUNpath + "Masonry.Unit Masonry.Brick.Modular.Herringbone.jpg"
    LOCdiffMaps[46] = FUNpath + "Sitework.Paving & Surfacing.Pavers.3.jpg"
    LOCdiffMaps[47] = FUNpath + "Paving.Flags.png"
    LOCdiffMaps[48] = FUNpath + "Masonry.Unit Masonry.Brick.Modular.Herringbone.1.jpg"
    LOCdiffMaps[49] = FUNpath + "Sitework.Paving & Surfacing.Cobble Stone.Heringbone.jpg"
    LOCdiffMaps[50] = FUNpath + "Concrete.Cast-In-Place.SandBlasted.jpg"

    --- Define Diffuse Maps Array
    local LOCbumpMaps   = #() ; LOCbumpMaps[50] = undefined
    LOCbumpMaps[34] = FUNpath + "SiteWork.Planting.Grass.StAugustine.Bump1.jpg"
    LOCbumpMaps[35] = FUNpath + "SiteWork.Planting.Grass.StAugustine.Bump1.jpg"
    LOCbumpMaps[36] = FUNpath + "Sitework.Planting.Sand.jpg"
    LOCbumpMaps[37] = FUNpath + "Concrete.Cast-In-Place.Exposed Aggregate.Medium.bump.jpg"
    LOCbumpMaps[38] = FUNpath + "Concrete.Cast-In-Place.Exposed Aggregate.Recessed.Bump.jpg"
    LOCbumpMaps[39] = FUNpath + "Asphalt.Zoab.Bump.png"
    LOCbumpMaps[40] = FUNpath + "Asphalt.Alt.Bump.png"
    LOCbumpMaps[41] = FUNpath + "Masonry.Stone.Granite.Square.Stacked.Polished.Grey.jpg"
    LOCbumpMaps[42] = FUNpath + "Sitework.Paving & Surfacing.Pavers.Terra Cotta.bump.jpg"
    LOCbumpMaps[43] = FUNpath + "Brick_Herringbone.bump.jpg"
    LOCbumpMaps[44] = FUNpath + "Brick_Herringbone.bump.jpg"
    LOCbumpMaps[45] = FUNpath + "Brick_Herringbone.bump.jpg"
    LOCbumpMaps[46] = FUNpath + "Sitework.Paving & Surfacing.Pavers.3.bump.jpg"
    LOCbumpMaps[47] = FUNpath + "Paving.Flags.Bump.png"
    LOCbumpMaps[48] = FUNpath + "Masonry.Unit Masonry.Brick.Modular.Herringbone.1.bump.jpg"
    LOCbumpMaps[49] = FUNpath + "Sitework.Paving & Surfacing.Cobble Stone.Heringbone.bump.jpg"
    LOCbumpMaps[50] = FUNpath + "Concrete.Cast-In-Place.SandBlasted.Bump.jpg"

    --- Define Opacity Maps Array
    local LOCopacMaps   = #() ; LOCopacMaps[50] = undefined
    LOCopacMaps[29] = FUNpath + "OpacityRailing.gif"
    LOCopacMaps[30] = FUNpath + "PedestrianRailing.png"

    --- Define Noise Map for Asphalt
    local LOCasphaltNoiseMap          = Noise()
    LOCasphaltNoiseMap.name           = DYNuiResourcesMaterialMaps[1]
    LOCasphaltNoiseMap.type           = 0 -- (0:Regular; 1:Fractal; 2:Turbulance)
    LOCasphaltNoiseMap.size           = 0.2
    LOCasphaltNoiseMap.color1         = color 170 153 153
    LOCasphaltNoiseMap.color2         = color   0   0   0
    LOCasphaltNoiseMap.phase          = 0.0
    LOCasphaltNoiseMap.levels         = 3.0
    LOCasphaltNoiseMap.thresholdLow   = 0.0
    LOCasphaltNoiseMap.thresholdHigh  = 1.0
    LOCasphaltNoiseMap.coords.blur    = 1.0

    --- Define Noise Map for Concrete
    local LOCconcreteNoiseMap         = Noise()
    LOCconcreteNoiseMap.name          = DYNuiResourcesMaterialMaps[2]
    LOCconcreteNoiseMap.type          = 1 -- (0:Regular; 1:Fractal; 2:Turbulance)
    LOCconcreteNoiseMap.size          = 0.5
    LOCconcreteNoiseMap.color1        = color 115 110 110
    LOCconcreteNoiseMap.color2        = color 255 255 255
    LOCconcreteNoiseMap.phase         = 0.0
    LOCconcreteNoiseMap.levels        = 1.0
    LOCconcreteNoiseMap.thresholdLow  = 0.0
    LOCconcreteNoiseMap.thresholdHigh = 1.0
    LOCconcreteNoiseMap.coords.blur   = 1.0

    --- Define Noise Map for Paving
    local LOCpavingNoiseMap           = Noise()
    LOCpavingNoiseMap.name            = DYNuiResourcesMaterialMaps[3]
    LOCpavingNoiseMap.type            = 1 -- (0:Regular; 1:Fractal; 2:Turbulance)
    LOCpavingNoiseMap.size            = 1.0
    LOCpavingNoiseMap.color1          = color  55  55  65
    LOCpavingNoiseMap.color2          = color 195 195 205
    LOCpavingNoiseMap.phase           = 0.0
    LOCpavingNoiseMap.levels          = 3.0
    LOCpavingNoiseMap.thresholdLow    = 0.2
    LOCpavingNoiseMap.thresholdHigh   = 0.8
    LOCpavingNoiseMap.coords.blur     = 1.0

    --- Define Noise Map for Grass
    local LOCgrassNoiseMap            = Noise()
    LOCgrassNoiseMap.name             = DYNuiResourcesMaterialMaps[4]
    LOCgrassNoiseMap.type             = 1 -- (0:Regular; 1:Fractal; 2:Turbulance)
    LOCgrassNoiseMap.size             = 2.5
    LOCgrassNoiseMap.color1           = color 122 129 81
    LOCgrassNoiseMap.color2           = color 47 51 23
    LOCgrassNoiseMap.phase            = 2.0
    LOCgrassNoiseMap.levels           = 1.0
    LOCgrassNoiseMap.thresholdLow     = 0.0
    LOCgrassNoiseMap.thresholdHigh    = 1.0
    LOCgrassNoiseMap.coords.blur      = 1.0

    LOCmat[1]  = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[1]  (color 250 250 250) LOCdiffMaps[1]  LOCbumpMaps[1]  LOCopacMaps[1]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCasphaltNoiseMap 10.0
    LOCmat[2]  = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[2]  (color 250 250 250) LOCdiffMaps[2]  LOCbumpMaps[2]  LOCopacMaps[2]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  2.0 0.0 0.25  LOCasphaltNoiseMap 10.0
    LOCmat[3]  = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[3]  (color 250 250 250) LOCdiffMaps[3]  LOCbumpMaps[3]  LOCopacMaps[3]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  3.0 0.0 0.0   LOCasphaltNoiseMap 10.0
    LOCmat[4]  = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[4]  (color 250 250 250) LOCdiffMaps[4]  LOCbumpMaps[4]  LOCopacMaps[4]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  4.0 0.0 0.125 LOCasphaltNoiseMap 10.0
    LOCmat[5]  = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[5]  (color 250 250 250) LOCdiffMaps[5]  LOCbumpMaps[5]  LOCopacMaps[5]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  5.0 0.0 0.0   LOCasphaltNoiseMap 10.0
    LOCmat[6]  = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[6]  (color 250 250 250) LOCdiffMaps[6]  LOCbumpMaps[6]  LOCopacMaps[6]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  5.0  1.0 0.0 0.0   LOCasphaltNoiseMap 10.0
    LOCmat[7]  = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[7]  (color 250 250 250) LOCdiffMaps[7]  LOCbumpMaps[7]  LOCopacMaps[7]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  2.0  2.0 0.0 0.0   LOCasphaltNoiseMap 10.0
    LOCmat[8]  = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[8]  (color 250 250 250) LOCdiffMaps[8]  LOCbumpMaps[8]  LOCopacMaps[8]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCasphaltNoiseMap 10.0
    LOCmat[9]  = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[9]  (color 250 250 250) LOCdiffMaps[9]  LOCbumpMaps[9]  LOCopacMaps[9]  1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  2.0 0.0 0.25  LOCasphaltNoiseMap 10.0
    LOCmat[10] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[10] (color 250 250 250) LOCdiffMaps[10] LOCbumpMaps[10] LOCopacMaps[10] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  3.0 0.0 0.0   LOCasphaltNoiseMap 10.0
    LOCmat[11] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[11] (color 250 250 250) LOCdiffMaps[11] LOCbumpMaps[11] LOCopacMaps[11] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  4.0 0.0 0.125 LOCasphaltNoiseMap 10.0
    LOCmat[12] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[12] (color 250 250 250) LOCdiffMaps[12] LOCbumpMaps[12] LOCopacMaps[12] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  5.0 0.0 0.0   LOCasphaltNoiseMap 10.0
    LOCmat[13] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[13] (color 250 250 250) LOCdiffMaps[13] LOCbumpMaps[13] LOCopacMaps[13] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCasphaltNoiseMap 10.0
    LOCmat[14] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[14] (color 250 250 250) LOCdiffMaps[14] LOCbumpMaps[14] LOCopacMaps[14] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  2.0 0.0 0.25  LOCasphaltNoiseMap 10.0
    LOCmat[15] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[15] (color 250 250 250) LOCdiffMaps[15] LOCbumpMaps[15] LOCopacMaps[15] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  3.0 0.0 0.0   LOCasphaltNoiseMap 10.0
    LOCmat[16] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[16] (color 250 250 250) LOCdiffMaps[16] LOCbumpMaps[16] LOCopacMaps[16] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  4.0 0.0 0.125 LOCasphaltNoiseMap 10.0
    LOCmat[17] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[17] (color 250 250 250) LOCdiffMaps[17] LOCbumpMaps[17] LOCopacMaps[17] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  5.0 0.0 0.0   LOCasphaltNoiseMap 10.0
    LOCmat[18] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[18] (color 250 250 250) LOCdiffMaps[18] LOCbumpMaps[18] LOCopacMaps[18] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  2.0  2.0 0.0 0.0   LOCasphaltNoiseMap 10.0
    LOCmat[19] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[19] (color 110  65  65) LOCdiffMaps[19] LOCbumpMaps[19] LOCopacMaps[19] 1.0 false 0.2 0.9  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  5.0  5.0 0.0 0.0   LOCasphaltNoiseMap 10.0
    LOCmat[20] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[20] (color  47 143 112) LOCdiffMaps[20] LOCbumpMaps[20] LOCopacMaps[20] 1.0 false 0.0 0.02 1.0 1.0 8 false 18 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   undefined 0.0
    LOCmat[21] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[21] (color  47 143 112) LOCdiffMaps[21] LOCbumpMaps[21] LOCopacMaps[21] 1.0 false 0.0 0.02 1.0 1.0 8 false 18 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   undefined 0.0
    LOCmat[22] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[22] (color 105 105 105) LOCdiffMaps[22] LOCbumpMaps[22] LOCopacMaps[22] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCconcreteNoiseMap 40.0
    LOCmat[23] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[23] (color 128 128 128) LOCdiffMaps[23] LOCbumpMaps[23] LOCopacMaps[23] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false 90.0 false  1.0  1.0 0.0 0.0   undefined 0.0
    LOCmat[24] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[24] (color 147  44  56) LOCdiffMaps[24] LOCbumpMaps[24] LOCopacMaps[24] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   undefined 0.0
    LOCmat[25] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[25] DYNINImarkingColor  LOCdiffMaps[25] LOCbumpMaps[25] LOCopacMaps[25] 1.0 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   undefined 0.0
    LOCmat[26] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[26] (color 100 185  80) LOCdiffMaps[26] LOCbumpMaps[26] LOCopacMaps[26] 1.0 false 0.2 1.0  0.0 1.0 8 false 25 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCgrassNoiseMap 40.0
    LOCmat[27] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[27] (color 100 185  80) LOCdiffMaps[27] LOCbumpMaps[27] LOCopacMaps[27] 1.0 false 0.2 1.0  0.0 1.0 8 false 25 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCgrassNoiseMap 50.0
    LOCmat[28] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[28] (color 100 185  80) LOCdiffMaps[28] LOCbumpMaps[28] LOCopacMaps[28] 1.0 false 0.2 1.0  0.0 1.0 8 false 25 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCgrassNoiseMap 60.0
    LOCmat[29] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[29] (color 210 210 210) LOCdiffMaps[29] LOCbumpMaps[29] LOCopacMaps[29] 0.5 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 true   0.0 true   1.0  5.0 0.0 0.0   undefined 0.0
    LOCmat[30] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[30] (color 210 210 210) LOCdiffMaps[30] LOCbumpMaps[30] LOCopacMaps[30] 0.5 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 true   0.0 true   1.0  8.0 0.0 0.0   undefined 0.0
    LOCmat[31] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[31] (color  75 110  70) LOCdiffMaps[31] LOCbumpMaps[31] LOCopacMaps[31] 0.6 false 0.2 1.0  0.0 1.0 8 false  0 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false 20.0 20.0 0.0 0.0   undefined 0.0
    LOCmat[32] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[32] (color 174 174 174) LOCdiffMaps[32] LOCbumpMaps[32] LOCopacMaps[32] 0.8 false 0.2 1.0  0.0 1.0 8 false 25 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  2.0  2.0 0.0 0.0   LOCgrassNoiseMap 30.0
    LOCmat[33] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[33] (color 130  95  85) LOCdiffMaps[33] LOCbumpMaps[33] LOCopacMaps[33] 1.0 false 0.2 1.0  0.0 1.0 8 false 25 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   undefined 0.0
    LOCmat[34] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[34] (color 100 185  80) LOCdiffMaps[34] LOCbumpMaps[34] LOCopacMaps[34] 1.0 false 0.2 1.0  0.0 1.0 8 false 40 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCgrassNoiseMap 25.0
    LOCmat[35] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[35] (color 100 185  80) LOCdiffMaps[35] LOCbumpMaps[35] LOCopacMaps[35] 1.0 false 0.2 1.0  0.0 1.0 8 false 40 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  4.0  4.0 0.0 0.0   LOCgrassNoiseMap 25.0
    LOCmat[36] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[36] (color 219 220 145) LOCdiffMaps[36] LOCbumpMaps[36] LOCopacMaps[36] 1.0 false 0.2 1.0  0.0 1.0 8 false 40 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  2.0  2.0 0.0 0.0   undefined /*LOCsandSmokeMap*/ 30.0
    LOCmat[37] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[37] (color 105 105 105) LOCdiffMaps[37] LOCbumpMaps[37] LOCopacMaps[37] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCconcreteNoiseMap 35.0
    LOCmat[38] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[38] (color 105 105 105) LOCdiffMaps[38] LOCbumpMaps[38] LOCopacMaps[38] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  1.0  1.0 0.0 0.0   LOCconcreteNoiseMap 25.0
    LOCmat[39] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[39] (color 185 175 175) LOCdiffMaps[39] LOCbumpMaps[39] LOCopacMaps[39] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  4.0  4.0 0.0 0.0   undefined 0.0
    LOCmat[40] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[40] (color 145 145 145) LOCdiffMaps[40] LOCbumpMaps[40] LOCopacMaps[40] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false  4.0  4.0 0.0 0.0   undefined 0.0
    LOCmat[41] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[41] (color 175 165 165) LOCdiffMaps[41] LOCbumpMaps[41] LOCopacMaps[41] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
    LOCmat[42] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[42] (color 175 165 165) LOCdiffMaps[42] LOCbumpMaps[42] LOCopacMaps[42] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
    LOCmat[43] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[43] (color 175 165 165) LOCdiffMaps[43] LOCbumpMaps[43] LOCopacMaps[43] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
    LOCmat[44] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[44] (color 175 165 165) LOCdiffMaps[44] LOCbumpMaps[44] LOCopacMaps[44] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
    LOCmat[45] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[45] (color 175 165 165) LOCdiffMaps[45] LOCbumpMaps[45] LOCopacMaps[45] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
    LOCmat[46] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[46] (color 175 165 165) LOCdiffMaps[46] LOCbumpMaps[46] LOCopacMaps[46] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
    LOCmat[47] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[47] (color 175 165 165) LOCdiffMaps[47] LOCbumpMaps[47] LOCopacMaps[47] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
    LOCmat[48] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[48] (color 175 165 165) LOCdiffMaps[48] LOCbumpMaps[48] LOCopacMaps[48] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0
    LOCmat[49] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[49] (color 175 165 165) LOCdiffMaps[49] LOCbumpMaps[49] LOCopacMaps[49] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false 20.0 20.0 0.0 0.0   LOCpavingNoiseMap 10.0
    LOCmat[50] = DYNFUNbuildPhysicalMaterial DYNuiResourcesSurfaceMaterial[50] (color 175 165 165) LOCdiffMaps[50] LOCbumpMaps[50] LOCopacMaps[50] 1.0 false 0.2 1.0  0.0 1.0 8 false 35 1.0 0.0 0 0.2 1.0 5.0 false  0.0 false 10.0 10.0 0.0 0.0   LOCpavingNoiseMap 10.0

    --- Extra Bits
    LOCmat.materiallist[31].base_color_map                   = checker()
    LOCmat.materiallist[31].base_color_map.coords.U_tiling   = 20.0
    LOCmat.materiallist[31].base_color_map.coords.V_tiling   = 20.0

    --- Paving Type 1 Channel (23)
    LOCmat.materialList[23].base_color_map                   = Bricks()
    LOCmat.materialList[23].base_color_map.brick_color       = color 130 125 119
    LOCmat.materialList[23].base_color_map.horizontal_count  = 12.0
    LOCmat.materialList[23].base_color_map.vertical_count    = 32.0
    LOCmat.materialList[23].base_color_map.color_variance    = 0.1
    LOCmat.materialList[23].base_color_map.fade_variance     = 0.1
    LOCmat.materialList[23].base_color_map.mortar_color      = color 72 66 54
    LOCmat.materialList[23].base_color_map.horizontal_gap    = 0.1
    LOCmat.materialList[23].base_color_map.vertical_gap      = 0.1
    LOCmat.materialList[23].base_color_map.lock_gap_symmetry = 1
    LOCmat.materialList[23].base_color_map.holes             = 0
    LOCmat.materialList[23].base_color_map.edge_roughness    = 5.0
    LOCmat.materialList[23].base_color_map.random_seed       = 41955
    LOCmat.materiallist[23].base_color_map.coords.W_angle    = 90.0
    LOCmat.materialList[23].base_color_map.tile_type         = 1 -- Running Bond
    LOCmat.materialList[23].bump_map                         = Bricks()
    LOCmat.materialList[23].bump_map.brick_color             = color 215 215 215
    LOCmat.materialList[23].bump_map.horizontal_count        = 12.0
    LOCmat.materialList[23].bump_map.vertical_count          = 32.0
    LOCmat.materialList[23].bump_map.color_variance          = 0.0
    LOCmat.materialList[23].bump_map.fade_variance           = 0.0
    LOCmat.materialList[23].bump_map.mortar_color            = color 44 37 23
    LOCmat.materialList[23].bump_map.horizontal_gap          = 0.1
    LOCmat.materialList[23].bump_map.vertical_gap            = 0.1
    LOCmat.materialList[23].bump_map.lock_gap_symmetry       = 1
    LOCmat.materialList[23].bump_map.holes                   = 0
    LOCmat.materialList[23].bump_map.edge_roughness          = 2.0
    LOCmat.materialList[23].bump_map.random_seed             = 41955
    LOCmat.materiallist[23].bump_map.coords.W_angle          = 90.0
    LOCmat.materialList[23].bump_map.tile_type               = 1 -- Running Bond

    --- Paving Type 2 Channel (24)
    LOCmat.materialList[24].base_color_map                   = Bricks()
    LOCmat.materialList[24].base_color_map.brick_color       = color 121 52 57
    LOCmat.materialList[24].base_color_map.horizontal_count  = 50.0
    LOCmat.materialList[24].base_color_map.vertical_count    = 35.0
    LOCmat.materialList[24].base_color_map.color_variance    = 0.1
    LOCmat.materialList[24].base_color_map.fade_variance     = 0.2
    LOCmat.materialList[24].base_color_map.mortar_color      = color 56 51 42
    LOCmat.materialList[24].base_color_map.horizontal_gap    = 0.1
    LOCmat.materialList[24].base_color_map.vertical_gap      = 0.1
    LOCmat.materialList[24].base_color_map.lock_gap_symmetry = 1
    LOCmat.materialList[24].base_color_map.holes             = 0
    LOCmat.materialList[24].base_color_map.edge_roughness    = 5.0
    LOCmat.materialList[24].base_color_map.random_seed       = 41955
    LOCmat.materialList[24].base_color_map.tile_type         = 1 -- Running Bond
    LOCmat.materialList[24].bump_map                         = Bricks()
    LOCmat.materialList[24].bump_map.brick_color             = color 215 215 215
    LOCmat.materialList[24].bump_map.horizontal_count        = 50.0
    LOCmat.materialList[24].bump_map.vertical_count          = 35.0
    LOCmat.materialList[24].bump_map.color_variance          = 0.0
    LOCmat.materialList[24].bump_map.fade_variance           = 0.0
    LOCmat.materialList[24].bump_map.mortar_color            = color 44 37 24
    LOCmat.materialList[24].bump_map.horizontal_gap          = 0.1
    LOCmat.materialList[24].bump_map.vertical_gap            = 0.1
    LOCmat.materialList[24].bump_map.lock_gap_symmetry       = 1
    LOCmat.materialList[24].bump_map.holes                   = 0
    LOCmat.materialList[24].bump_map.edge_roughness          = 2.0
    LOCmat.materialList[24].bump_map.random_seed             = 41955
    LOCmat.materialList[24].bump_map.tile_type               = 1 -- Running Bond

    local LOCwaterMult = 1.0
    case units.SystemType of
    (
      #Inches      : LOCwaterMult = 39.3700787
      #Feet        : LOCwaterMult = 3.2808399
      #Miles       : LOCwaterMult = 0.000621371192
      #Millimeters : LOCwaterMult = 1000.0
      #Centimeters : LOCwaterMult = 100.0
      #Meters      : LOCwaterMult = 1.0
      #Kilometers  : LOCwaterMult = 0.001
    )

    --- Define Bump Map for Calm Water
    LOCmat.materialList[20].bump_map                   = Noise()
    LOCmat.materialList[20].bump_map.name              = DYNuiResourcesMaterialMaps[6]
    LOCmat.materialList[20].bump_map.type              = 1 -- (0:Regular; 1:Fractal; 2:Turbulance)
    LOCmat.materialList[20].bump_map.size              = LOCwaterMult * 6.0
    LOCmat.materialList[20].bump_map.color1            = color 0 0 0
    LOCmat.materialList[20].bump_map.color2            = color 255 255 255
    LOCmat.materialList[20].bump_map.phase             = 0.0
    LOCmat.materialList[20].bump_map.levels            = 3.0
    LOCmat.materialList[20].bump_map.thresholdLow      = 0.0
    LOCmat.materialList[20].bump_map.thresholdHigh     = 1.0
    LOCmat.materialList[20].bump_map.coords.tiling     = [1,1,1]
    LOCmat.materialList[20].bump_map_amt               = 0.02
    
    --- Define Bump Map for Rough Water
    LOCmat.materialList[21].bump_map                   = Noise()
    LOCmat.materialList[21].bump_map.name              = DYNuiResourcesMaterialMaps[6]
    LOCmat.materialList[21].bump_map.type              = 1 -- (0:Regular; 1:Fractal; 2:Turbulance)
    LOCmat.materialList[21].bump_map.size              = LOCwaterMult * 12.0
    LOCmat.materialList[21].bump_map.color1            = color 0 0 0
    LOCmat.materialList[21].bump_map.color2            = color 255 255 255
    LOCmat.materialList[21].bump_map.phase             = 0.0
    LOCmat.materialList[21].bump_map.levels            = 3.0
    LOCmat.materialList[21].bump_map.thresholdLow      = 0.0
    LOCmat.materialList[21].bump_map.thresholdHigh     = 1.0
    LOCmat.materialList[21].bump_map.coords.tiling     = [2,1,1]
    LOCmat.materialList[21].bump_map_amt               = 0.04
    
    --- Set Names In MultiMaterial
    for i = 1 to LOCmat.count do
    (
      LOCmat.names[i] = LOCmat.materialList[i].name
    )

    --- Attempt to Save Material To Civil View Material Library
    local LOCmatLibrary = materialLibrary LOCmat
    local LOCsuccess    = saveTempMaterialLibrary LOCmatLibrary LOCcivilViewSurfacesMatFile
  )

  --- Show Texture Maps In Viewport
  if classOf LOCmat == Multimaterial then (for i = 1 to LOCmat.count do (DYNFUNshowTextureMap LOCmat i false on))

  --- Return Finished Material Value
  LOCmat -- return value
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCTrDTqzP5rj3ND5miBiEdKortCn6B7zH7J
-- YYwyJdw0LjpJ10iF+Q/vtG+S5AbHDW60hTn47h49ATTpZCY7eD23esAIKcPtepL6
-- ZOveotH8WgcfACM+OEfstiFlQZmeEHPj5vDfEjsKj8Jb+ZZRQvzyPTNxVg+pW2RP
-- 60FqsoDbqtOf4oARcfVKllbE4EPF+TQRQHcMA8UymzvfTKUCNsyVCpJfpwUWWnHo
-- Oz1TT5ds9b4A+RzzDqRVCnG/rn9ffdxcxHudxBA+FA+kOCVvyifbxMCLZvMIS57G
-- Bf345+ZbNtEZiawVONfs1YlhtJr0FSb3Qk05TXNPur51yxW4AVGp
-- -----END-SIGNATURE-----