--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNchainageText ""
(
  --- Local Variables
  local LOCobjHandles   = #()
  local LOCobjectSwitch = 6
  local LOCsurface

  --- Local Functions
  fn DYNFUNselectNewShape FUNshape =
  (
    if superclassof FUNshape == shape then
    (
      DYNFUNcheckIsSplineShape FUNshape

      DYNchainageText.PKDYNshape.object   = FUNshape
      DYNchainageText.EDDYNshapeName.text = FUNshape.name

      --- If C3d Alignment or Baseline, try to ascertain start station
      local LOCstartStation = getAppData FUNshape 426
      if classOf LOCstartStation == string then LOCstartStation = LOCstartStation as float
      if classOf LOCstartStation == float  then
      (
        DYNchainageText.SPDYNstartCh.value = LOCstartStation
      )
    )
    else
    (
      DYNchainageText.EDDYNshapeName.text = ""
      DYNchainageText.SPDYNstartCh.value  = 0.0
    )
  )

  --- Rollout Controls
  groupBox     GBDYNgroup01     pos:[15,15]   width:194 height:120
  pickButton   PKDYNshape       pos:[25,34]   width:174 filter:DYNFUNshapeFilter
  edittext EDDYNshapeName ""    pos:[25,60]   width:174 labelOnTop:true

  pickButton   PKDYNsurface     pos:[25,85]   width:155 filter:DYNFUNgeometryFilter
  button       BUDYNnoSurface   pos:[181,85]  width:18
  edittext EDDYNsurfaceName ""  pos:[25,111]  width:174 labelOnTop:true

  groupBox     GBDYNgroup02     pos:[15,143]  width:194 height:147
  label        LBDYNchainage    pos:[25,164]  width:90
  spinner      SPDYNchainage "" pos:[124,164] width:75  range:[1,10000,100] type:#integer scale:5
  label        LBDYNstartCh     pos:[25,184]  width:90
  spinner      SPDYNstartCh ""  pos:[124,184] width:75  range:[-999999,999999,0] scale:10
  label        LBDYNhorOff      pos:[25,204]  width:90
  spinner      SPDYNhorOff ""   pos:[124,204] width:75  range:[-100,100,0]
  label        LBDYNverOff      pos:[25,224]  width:90
  spinner      SPDYNverOff ""   pos:[124,224] width:75  range:[-100,100,0] type:#float scale:0.1
  label        LBDYNrotation    pos:[25,244]  width:90
  spinner      SPDYNrotation "" pos:[124,244] width:75  range:[-180,180,0] type:#integer scale:5
  label        LBDYNmultiply    pos:[25,264]  width:95
  spinner      SPDYNmultiply "" pos:[124,264] width:75  range:[-6,6,0] type:#integer

  groupBox     GBDYNgroup03     pos:[225,15]  width:194 height:275
  dropDownList DDDYNfont        pos:[235,36]  width:135 height:20
  checkbutton  CBDYNitalic      pos:[372,36]  width:18  height:20
  checkbutton  CBDYNunderline   pos:[391,36]  width:18  height:20
  label        LBDYNheight      pos:[235,68]  width:90
  spinner      SPDYNheight ""   pos:[334,68]  width:75  range:[-1000,1000,1]
  label        LBDYNextrude     pos:[235,88]  width:90
  spinner      SPDYNextrude ""  pos:[334,88]  width:75  range:[0,100,0.0] scale:0.01
  label        LBDYNkerning     pos:[235,108] width:90
  spinner      SPDYNkerning ""  pos:[334,108] width:75  range:[-1,1,0.0] scale:0.01
  label        LBDYNplaces      pos:[235,128] width:90
  spinner      SPDYNplaces ""   pos:[334,128] width:75  range:[0,6,1] type:#integer scale:1
  label        LBDYNpreText     pos:[235,156] width:90
  editText     EDDYNpreText ""  pos:[330,155] width:78
  label        LBDYNdecText     pos:[235,176] width:90
  editText     EDDYNdecText ""  pos:[330,175] width:78
  label        LBDYNsufText     pos:[235,196] width:90
  editText     EDDYNsufText ""  pos:[330,195] width:78
  radiobuttons RBDYNorient      pos:[235,230] width:175 height:40 columns:1 labels:#(DYNuiResourcesLabels[332], DYNuiResourcesLabels[333])

  groupBox     GBDYNgroup04     pos:[435,15]  width:194 height:275
  checkbox     CKDYNrender      pos:[445,36]  width:174 height:17 checked:true
  label        LBDYNvisible     pos:[445,61]  width:90
  spinner      SPDYNvisible ""  pos:[544,61]  width:75  range:[0,1,1] scale:0.01
  label        LBDYNcolor       pos:[445,85]  width:90
  colorPicker  CODYNcolor ""    pos:[541,85]  width:78  height:16 color:(color 195 195 255)
  checkbox     CKDYNfreeze      pos:[445,115] width:174 height:17
  checkbox     CKDYNboxMode     pos:[445,135] width:174 height:17 checked:false
  checkbox     CKDYNreceive     pos:[445,155] width:174 height:17 checked:true
  checkbox     CKDYNcast        pos:[445,175] width:174 height:17 checked:true
  checkbox     CKDYNreflections pos:[445,195] width:174 height:17 checked:true
  checkbox     CKDYNcollapse    pos:[445,225] width:174 height:17 checked:true
  checkbox     CKDYNsingleMesh  pos:[445,245] width:174 height:17 checked:false

  button       BUDYNokok        pos:[60,300]  width:90  height:22
  button       BUDYNapply       pos:[274,300] width:90  height:22
  button       BUDYNcanc        pos:[483,300] width:90  height:22

  dotNetControl  dnProgress "System.Windows.Forms.ProgressBar" pos:[15,331] width:613 height:14

  label        LBDYNstatus      pos:[15,351] width:613

  --- Rollout Control Events

  on DYNchainageText open do
  (
    DYNchainageText.title     = DYNuiRolloutNames[36]

    GBDYNgroup01.text         = DYNuiResourcesGroups[101]
    GBDYNgroup02.text         = DYNuiResourcesGroups[102]
    GBDYNgroup03.text         = DYNuiResourcesGroups[103]
    GBDYNgroup04.text         = DYNuiResourcesGroups[104]

    DDDYNfont.items           = DYNuiResourcesFontNames

    BUDYNokok.text            = DYNuiResourcesButtons[1]
    BUDYNapply.text           = DYNuiResourcesButtons[2]
    BUDYNcanc.text            = DYNuiResourcesButtons[3]
    PKDYNshape.text           = DYNuiResourcesButtons[20]
    PKDYNsurface.text         = DYNuiResourcesButtons[21]
    BUDYNnoSurface.text       = DYNuiResourcesButtons[22]
    CBDYNitalic.text          = DYNuiResourcesButtons[74]
    CBDYNunderline.text       = DYNuiResourcesButtons[75]

    LBDYNstatus.text          = DYNuiResourcesStatusMessages[21]

    EDDYNpreText.text         = DYNuiResourcesLabels[351]
    EDDYNdecText.text         = "."
    EDDYNsufText.text         = DYNuiResourcesLabels[352]
    LBDYNhorOff.text          = DYNuiResourcesLabels[1]
    LBDYNverOff.text          = DYNuiResourcesLabels[2]
    LBDYNrotation.text        = DYNuiResourcesLabels[12]
    LBDYNstartCh.text         = DYNuiResourcesLabels[9]
    LBDYNcolor.text           = DYNuiResourcesLabels[334]
    LBDYNchainage.text        = DYNuiResourcesLabels[335]
    LBDYNmultiply.text        = DYNuiResourcesLabels[336]
    LBDYNheight.text          = DYNuiResourcesLabels[337]
    LBDYNextrude.text         = DYNuiResourcesLabels[338]
    LBDYNkerning.text         = DYNuiResourcesLabels[339]
    LBDYNplaces.text          = DYNuiResourcesLabels[340]
    LBDYNpreText.text         = DYNuiResourcesLabels[341]
    LBDYNdecText.text         = DYNuiResourcesLabels[342]
    LBDYNsufText.text         = DYNuiResourcesLabels[343]
    LBDYNvisible.text         = DYNuiResourcesLabels[344]
    CKDYNboxMode.text         = DYNuiResourcesLabels[42]
    CKDYNcast.text            = DYNuiResourcesLabels[20]
    CKDYNrender.text          = DYNuiResourcesLabels[345]
    CKDYNfreeze.text          = DYNuiResourcesLabels[346]
    CKDYNreceive.text         = DYNuiResourcesLabels[347]
    CKDYNreflections.text     = DYNuiResourcesLabels[348]
    CKDYNcollapse.text        = DYNuiResourcesLabels[349]
    CKDYNsingleMesh.text      = DYNuiResourcesLabels[350]

    EDDYNshapeName.readOnly   = true
    EDDYNsurfaceName.readOnly = true

    --- Check to see if any shapes are selected when entering this panel
    if selection.count == 1 then
    (
      if DYNFUNshapeFilter selection[1] then
      (
        if queryBox (DYNuiResourcesQueries[43]) title:DYNuiResourcesTitlebars[3] then
        (
          DYNFUNselectNewShape selection[1]
        )
        else clearSelection()
      )
      else clearSelection()
    )
    else clearSelection()
  )

  on DYNchainageText close do
  (
    DYNFUNonDialogClose()
  )

  on PKDYNshape picked arg do
  (
    DYNFUNselectNewShape arg
  )

  on PKDYNsurface picked arg do
  (
    LOCsurface = arg
    EDDYNsurfaceName.text = arg.name
  )

  on BUDYNnoSurface pressed do
  (
    LOCsurface = undefined
    --PKDYNsurface.text = DYNuiResourcesButtons[73]
    EDDYNsurfaceName.text = ""
  )

  on CKDYNcollapse changed arg do
  (
    if not arg then CKDYNsingleMesh.checked = CKDYNsingleMesh.enabled = false
    if     arg then CKDYNsingleMesh.enabled = true
  )

  on BUDYNapply pressed do
  (
    if isValidNode PKDYNshape.object then
    (
      actionMan.executeAction 0 "300"
      DYNFUNremoveCSProllouts()
      DYNFUNloadVSPnodeCallBacks false
      (
        disableSceneRedraw()
        LBDYNstatus.text = DYNuiResourcesStatusMessages[4]

        --- Delete current group of objects placed last time Apply button was pressed
        if LOCobjHandles.count != 0 then
        (
          for i in LOCobjHandles do
          (
            local LOCobjHandleFound = findItem DYNobjHandles[i.x] i.y
            local LOCobjHandleNode  = maxOps.getNodeByHandle i.y
            if LOCobjHandleNode != undefined then (delete LOCobjHandleNode)
            if LOCobjHandleFound > 0         then (deleteItem DYNobjHandles[i.x] LOCobjHandleFound)
          )
        )

        LOCobjHandles = #()

        --- Create Master Text Object
        LOCmasterObject                     = text()
        LOCmasterObject.pos                 = PKDYNshape.object.pos
        LOCmasterObject.font                = DDDYNfont.selected
        LOCmasterObject.size                = SPDYNheight.value
        LOCmasterObject.kerning             = SPDYNkerning.value
        LOCmasterObject.steps               = 2
        LOCmasterObject.alignment           = 2
        LOCmasterObject.underline           = CBDYNunderline.checked
        LOCmasterObject.italic              = CBDYNitalic.checked

        if RBDYNorient.state == 2 then
        (
          LOCmasterObject.rotation.x_rotation = 90
          LOCmasterObject.rotation.z_rotation = 180
          resetTransform LOCmasterObject
        )

        --- Create Extrude Modifier
        local LOCextrudeMod        = extrude amount:SPDYNextrude.value
        LOCextrudeMod.segs         = 1
        LOCextrudeMod.capStart     = true
        LOCextrudeMod.capEnd       = true
        LOCextrudeMod.capType      = 1
        LOCextrudeMod.output       = 1
        LOCextrudeMod.useShapeIDs  = false
        LOCextrudeMod.matIDs       = false
        LOCextrudeMod.smooth       = false
        LOCextrudeMod.mapCoords    = false

        --- Get Length Of Spline
        local LOClength            = curveLength PKDYNshape.object 1
        local LOCDYNorientBool     = if RBDYNorient.state == 1 then true else false

        --- Build Station List
        local LOCstationList       = DYNFUNbuildSplineStationListFromIntervalAndStartStation SPDYNstartCh.value (SPDYNstartCh.value + LOClength) SPDYNchainage.value false

        --- Create TEXT Objects
        for i = 1 to LOCstationList.count do
        (
          local LOCcontroller
          local LOCobject     = copy LOCmasterObject
          dnProgress.value    = (i as float) / LOCstationList.count * 100.0
          LBDYNstatus.text    = DYNuiResourcesStatusMessages[23] + " [" + (i as string) + "/" + (LOCstationList.count as string) + "]..."

          --- Format Text
          local LOCbitChainage = abs (LOCstationList[i] - (LOCstationList[i] as integer)) as string
          local LOCabsChainage = (filterString LOCbitChainage ".")[2] as string
          local LOCbobChainage = subString LOCabsChainage 1 6
          while LOCbobChainage.count < 6 do LOCbobChainage = LOCbobChainage + "0"

          local LOCcurChainage = "000000" + ((LOCstationList[i] as integer) as string) + LOCbobChainage
          local LOCint = subString LOCcurChainage 1 (LOCcurChainage.count - 6 + SPDYNmultiply.value)
          local LOCdec = subString LOCcurChainage (LOCcurChainage.count + SPDYNmultiply.value - 5) -1
          if LOCdec.count > SPDYNplaces.value then
          (
            LOCdec = subString LOCdec 1 SPDYNplaces.value
          )
          else
          (
            for ii = LOCdec.count to (SPDYNplaces.value - 1) do LOCdec += "0"
          )

          LOCint                        = (LOCint as integer) as string
          LOCobject.text                = EDDYNpreText.text + LOCint + EDDYNdecText.text + LOCdec + EDDYNsufText.text

          --- Set Atrributes Of Text Geometry
          LOCobject.wirecolor           = CODYNcolor.color
          LOCobject.boxMode             = false
          LOCobject.castShadows         = CKDYNcast.checked; try (LOCobject.isGIoccluder = CKDYNcast.checked) catch ()
          LOCobject.receiveShadows      = CKDYNreceive.checked
          LOCobject.isFrozen            = CKDYNfreeze.checked
          LOCobject.secondaryVisibility = CKDYNreflections.checked
          LOCobject.renderable          = CKDYNrender.checked
          LOCobject.boxMode             = CKDYNboxMode.checked
          LOCobject.name                = uniqueName LOCobject.name
          LOCobject.visibility = bezier_float
          LOCobject.visibility.controller.value = SPDYNvisible.value

          --- Extrude
          addModifier LOCobject LOCextrudeMod
          if CKDYNcollapse.checked then collapseStack LOCobject

          --- Apply Scripted Position Controller
          DYNFUNapplyMaxTransform LOCobject PKDYNshape.object (100 * ((LOCstationList[i] - SPDYNstartCh.value) / LOClength)) SPDYNrotation.value SPDYNhorOff.value SPDYNverOff.value true LOCDYNorientBool LOCsurface 0.0 rootNode.DYNrootNodeStore.bakeSwitch 1
          LOCcontroller = LOCobject.transform.controller

          --- Adjust Road Marking Style
          if RBDYNorient.state == 1 then
          (
            LOCcontroller.vOffset       = SPDYNverOff.value + rootNode.DYNrootNodeStore.markVshift

            --- Fix problem whereby text appeared facing wrong way on road
            LOCobject.objectOffsetRot.z = 180
          )

          --- Update Controller for additional changes in above section
          DYNFUNmaxBakingControl #(LOCobject) true
          if LOCbakeSwitch == false then DYNFUNmaxBakingControl #(LOCobject) false

          --- Apply AppData
          DYNFUNgenObjAppData LOCobject LOCobjectSwitch "0" "" (DYNFUNgetLocalTime()) "" "" ""

          --- Add To Object Arrays
          append DYNchainageText.LOCobjHandles [LOCobjectSwitch,LOCobject.inode.handle]
          if not CKDYNsingleMesh.checked then
          (
            append DYNobjHandles[LOCobjectSwitch] LOCobject.inode.handle
          )
        )

        --- Optionally convert to single dumn mesh
        if CKDYNsingleMesh.checked then
        (
          local LOCmesh = editable_mesh pos:PKDYNshape.object.pos
          for i in DYNchainageText.LOCobjHandles do (attach LOCmesh (maxOps.getNodeByHandle i.y))
          update LOCmesh

          LOCmesh.wirecolor                   = CODYNcolor.color
          LOCmesh.boxMode                     = false
          LOCmesh.castShadows                 = CKDYNcast.checked; try (LOCmesh.isGIoccluder = CKDYNcast.checked) catch ()
          LOCmesh.receiveShadows              = CKDYNreceive.checked
          LOCmesh.isFrozen                    = CKDYNfreeze.checked
          LOCmesh.secondaryVisibility         = CKDYNreflections.checked
          LOCmesh.renderable                  = CKDYNrender.checked
          LOCmesh.boxMode                     = CKDYNboxMode.checked
          LOCmesh.visibility                  = bezier_float
          LOCmesh.visibility.controller.value = SPDYNvisible.value
          LOCmesh.name                        = DYNuiResourcesNodeNames[1] + PKDYNshape.object.name

          DYNchainageText.LOCobjHandles = #([18,LOCmesh.inode.handle])
          append DYNobjHandles[18] LOCmesh.inode.handle
        )

        dnProgress.value   = 100
        LBDYNstatus.text   = DYNuiResourcesStatusMessages[22]
        delete LOCmasterObject
        enableSceneRedraw(); completeRedraw()
        dnProgress.value   = 0
      )
      DYNFUNloadVSPnodeCallBacks true
      DYNFUNnodeCreatedCallback()
      DYNproperties.DYNFUNscreenSelectionToList()
    )
    else
    (
      messagebox (DYNuiResourcesErrorsWarnings[44]) title:DYNuiResourcesTitlebars[2]
    )
    gc()
  )

  on BUDYNokok pressed do
  (
    destroyDialog DYNchainageText
  )

  on BUDYNcanc pressed do
  (
    destroyDialog DYNchainageText
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQATsXIU34YwYx4BejP2XAzBkzE2guqAJnoS
-- ApP30q5qW85o1pTPX7KndJpoYpcoR1g1wmEkLgLPxZxaNhH5kbo1C8t5iaQwYF3k
-- +51W1UL7Gj1a3cETaM1xNbP7BO+0jpFdBBHKbLdmS71ti7jR/vEMkmfw2Nan2DGb
-- DyIg+291ayOn/aBhdeL6VnEKpJofFz5wVDJum059X8PsUfU4IjBix1lJi+MG5ShI
-- 6pRGneeG0Rwno7/Y8StX7Ek3F3ItEfTf41sAhaUbDXA6PCgC1DqSR6+iPHqUQzt/
-- 3FR01DObi33OxBGZRyu2iWyJO18ANq/ruVj5gQoo2dmEfH4qmm3N
-- -----END-SIGNATURE-----