--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNbuildingParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj
  local LOCobjMod1
  local LOCobjMod2
  local LOCmapSize  = [157,100]
  local LOCmatIDarray = #()
  local LOCbosPath
  local LOCbosStyle = ""
  local LOCresourceKitMode   = 1

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNbuildingParamsCallback =
  (
    local LOCnotifyParam = callbacks.notificationParam()
    if try (DYNbuildingParams.LOCobj == LOCnotifyParam[1]) catch (false) then
    (
      for i in DYNbuildingParams.controls do i.enabled = false
    )
  )

  --- Function To Display Building Parameters in Rollout
  fn DYNFUNbuildingParams FUNobj =
  (
    DYNbuildingParams.LOCobj                = FUNobj
    DYNbuildingParams.LOCobjMod1            = CVGetMod FUNobj DynBuilding

    DYNbuildingParams.LOCbosStyle           = getAppData FUNobj 424; if DYNbuildingParams.LOCbosStyle == undefined then DYNbuildingParams.LOCbosStyle = ""

    DYNbuildingParams.PKDYNparent.text      = try (FUNobj.parent.name) catch (DYNuiResourcesButtons[15])
    if DYNbuildingParams.LOCobjMod1 != undefined then
    (
      --- Create New UVWmap Modifier To Ensure That One Exists As Soon As Panel Opens
      DYNbuildingParams.LOCobjMod2       = (UVWmap realWorldMapSize:false)

      --- Check For Presence Of UVWmap Modifier On This Object And All Objects Using Instances Of DynBuilding Modifier
      local LOCinstances = DYNFUNnodesWithInstancesOfModifier DYNbuildingParams.LOCobjMod1

      /* First Pass Through All Objects With Instances Of DynBuilding Modifier To Grab UVW Modifier If Attached To Any Of Them (it should be attached to all of them!) */
      local LOCtempDivMod = (CVGetMod FUNobj Uvwmap)
      for i = 1 to LOCinstances.count do if LOCtempDivMod == undefined then
      (
        if (CVGetMod LOCinstances[i] Uvwmap) != undefined then LOCtempDivMod = (CVGetMod LOCinstances[i] Uvwmap)
      )
      if LOCtempDivMod != undefined then (DYNbuildingParams.LOCobjMod2 = LOCtempDivMod)
      DYNFUNupdateBuildingUVW DYNbuildingParams.LOCobjMod2 FUNobj DYNbuildingParams.LOCobjMod1.Xamount DYNbuildingParams.LOCobjMod1.Xfloors DYNbuildingParams.LOCobjMod1.XmapWidth DYNbuildingParams.LOCobjMod1.XmapType

      /* If any objects using Instances of primary DynBuilding modifier (including this one) do not have UVWmap modifier attached, re-attach an instance of UVWmap now */
      for i = 1 to LOCinstances.count do if (CVGetMod LOCinstances[i] Uvwmap) == undefined then
      (
        addmodifier LOCinstances[i] DYNbuildingParams.LOCobjMod2
      )

      --- Display Material Channel Names
      DYNbuildingParams.LOCmatIDarray = DYNFUNgetMatChannelNames FUNobj.material true true DYNINImatIDlimit
      DYNbuildingParams.DDDYNxWallMatIDs.items = DYNbuildingParams.LOCmatIDarray

      --- Display Params
      DYNbuildingParams.DDDYNxWallMatIDs.selection = DYNbuildingParams.LOCobjMod1.XwallMatIDs
      DYNbuildingParams.DDDYNxMapType.selection    = DYNbuildingParams.LOCobjMod1.XmapType
      DYNbuildingParams.SPDYNxMapWidth.enabled     = if DYNbuildingParams.DDDYNxMapType.selection <= 2 then true else false
      DYNbuildingParams.SPDYNbuildHeight.value     = DYNbuildingParams.LOCobjMod1.Xamount
      DYNbuildingParams.SPDYNnumFloors.value       = DYNbuildingParams.LOCobjMod1.Xfloors
      DYNbuildingParams.SPDYNfloorHeight.value     = DYNbuildingParams.LOCobjMod1.Xamount / DYNbuildingParams.LOCobjMod1.Xfloors
      DYNbuildingParams.SPDYNxMapWidth.value       = DYNbuildingParams.LOCobjMod1.XmapWidth

      DYNbuildingParams.LBDYNfile.text = FileNameFromPath DYNbuildingParams.LOCbosStyle

      --- Gather Instances Of This Modifier
      DYNFUNgatherNodesWithModInstances DYNbuildingParams LOCobjMod1

      --- Display Mapping Preview
      DYNbuildingParams.BMwallMap.bitmap     = DYNFUNrenderMatMap DYNbuildingParams.LOCmapSize.x DYNbuildingParams.LOCmapSize.y LOCobj.material DYNbuildingParams.LOCobjMod1.XwallMatIDs
    )
    else
    (
      for i in DYNbuildingParams.controls do i.enabled = false
      DYNbuildingParams.CBDYNlinked.checked     = false
      DYNbuildingParams.CBDYNlinked.text        = DYNuiResourcesButtons[37]
    )

  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupbox GBDYNgroup01   pos:[4,7]   width:(DYNiniExplorerWidth - 21) height:46
  pickbutton PKDYNparent align:#center width:(DYNiniExplorerWidth - 39) filter:DYNFUNclosedShapeFilter pos:[11,26]

  groupbox GBDYNgroup02   pos:[4,58]  width:(DYNiniExplorerWidth - 21) height:83
  label LBDYNbuildHeight width:105 pos:[13,77]
  label LBDYNnumFloors   width:105 pos:[13,98]
  label LBDYNfloorHeight width:105 pos:[13,119]
  spinner SPDYNbuildHeight "" fieldwidth:60 range:[-999999.9,999999.9,1]        type:#worldunits   align:#right scale:0.1 pos:[(DYNiniExplorerWidth - 96),77]
  spinner SPDYNnumFloors   "" fieldwidth:60 range:[1,1000,1]         scale:1    type:#integer align:#right                pos:[(DYNiniExplorerWidth - 96),98]
  spinner SPDYNfloorHeight "" fieldwidth:60 range:[-999.9,999.9,10]  scale:0.01 type:#worldunits   align:#right           pos:[(DYNiniExplorerWidth - 96),119]

  groupbox GBDYNgroup03   pos:[4,146] width:(DYNiniExplorerWidth - 21) height:240
  label        LBDYNXmapType align:#left pos:[13,165] width:(DYNiniExplorerWidth - 39)
  dropdownlist DDDYNXmapType  items:#() pos:[13,183] width:(DYNiniExplorerWidth - 39)
  label        LBDYNxWallMatIDs pos:[13,210] width:(DYNiniExplorerWidth - 39)
  dropdownlist DDDYNxWallMatIDs  items:#() pos:[13,228] width:(DYNiniExplorerWidth - 39)
  bitmap       BMwallMap width:LOCmapSize.x height:LOCmapSize.y pos:[13,255]
  label LBDYNxMapWidth width:105 pos:[13,364]
  spinner      SPDYNxMapWidth "" fieldwidth:60 range:[0.1,999.9,10] scale:0.1 type:#worldunits pos:[(DYNiniExplorerWidth - 96),364]

  groupBox GBDYNstyles pos:[4,391]   align:#left width:(DYNiniExplorerWidth - 21) height:78
  button BUDYNfile     pos:[(-14 + (DYNiniExplorerWidth * 0.197)),413] align:#center iconName:"CivilView/Open" width:28 height:28 tooltip:DYNuiResourcesTooltips[5] across:3
  button BUDYNsave     pos:[(-14 + (DYNiniExplorerWidth * 0.465)),413] align:#center iconName:"Common/Save" width:28 height:28 tooltip:DYNuiResourcesTooltips[6]
  button BUDYNreset    pos:[(-14 + (DYNiniExplorerWidth * 0.732)),413] align:#center iconName:"CivilView/Reset" width:28 height:28 tooltip:DYNuiResourcesTooltips[14]
  label  LBDYNfile     pos:[25,447]  align:#center width:(DYNiniExplorerWidth - 60)

  --- Parameter Instancing
  groupbox GBDYNgroup06   pos:[4,474]   width:(DYNiniExplorerWidth - 21) height:72
  checkbutton CBDYNlinked pos:[13,493]  width:(DYNiniExplorerWidth - 39) highlightColor:DYNINIhighlightColor
  pickbutton PKDYNlink    pos:[13,519]  width:(DYNiniExplorerWidth - 39) highlightColor:DYNINIhighlightColor filter:DYNFUNdynBuildingFilter



  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNbuildingParams open do
  (
    DYNbuildingParams.title = DYNuiRolloutNames[12]

    --- Add Callback To Detect If Spline Modifier Is Deleted While This Panel Is Open
    callbacks.removescripts id:#DYNbuildingParams
    callbacks.addscript #postModifierDeleted "DYNbuildingParams.DYNFUNbuildingParamsCallback()" id:#DYNbuildingParams

    --- Panel Details
    GBDYNgroup01.text       = DYNuiResourcesGroups[14]
    GBDYNgroup02.text       = DYNuiResourcesGroups[41]
    GBDYNgroup03.text       = DYNuiResourcesGroups[42]
    GBDYNgroup06.text       = DYNuiResourcesGroups[1]
    GBDYNstyles.text        = DYNuiResourcesGroups[43]

    PKDYNlink.text          = DYNuiResourcesButtons[24]

    LBDYNbuildHeight.text   = DYNuiResourcesLabels[139]
    LBDYNnumFloors.text     = DYNuiResourcesLabels[140]
    LBDYNfloorHeight.text   = DYNuiResourcesLabels[141]
    LBDYNxMapWidth.text     = DYNuiResourcesLabels[142]
    DDDYNxMapType.items     = #(DYNuiResourcesLabels[143], DYNuiResourcesLabels[144], DYNuiResourcesLabels[145], DYNuiResourcesLabels[146])
    LBDYNxWallMatIDs.text   = DYNuiResourcesLabels[147]
    LBDYNXmapType.text      = DYNuiResourcesLabels[148]

    LOCbosPath = DYNcountryPath + DYNlocalBosPath
    LBDYNfile.text = FileNameFromPath LOCbosStyle
  )

  on DYNbuildingParams close do
  (
    LOCobj = undefined
    callbacks.removescripts id:#DYNbuildingParams
  )

  on SPDYNbuildHeight      changed arg do
  (
    LOCobjMod1.Xamount      = arg; SPDYNfloorHeight.value = arg / LOCobjMod1.Xfloors
    DYNFUNupdateBuildingUVW LOCobjMod2 LOCobj arg LOCobjMod1.Xfloors LOCobjMod1.xMapWidth LOCobjMod1.XmapType
  )

  on SPDYNnumFloors      changed arg do
  (
    LOCobjMod1.Xfloors      = arg; LOCobjMod1.Xamount = SPDYNfloorHeight.value * arg; SPDYNbuildHeight.value = LOCobjMod1.Xamount
    DYNFUNupdateBuildingUVW LOCobjMod2 LOCobj LOCobjMod1.Xamount LOCobjMod1.Xfloors LOCobjMod1.xMapWidth LOCobjMod1.XmapType
  )

  on SPDYNfloorHeight  changed arg do
  (
    LOCobjMod1.Xamount      = arg * LOCobjMod1.Xfloors; SPDYNbuildHeight.value = LOCobjMod1.Xamount
    DYNFUNupdateBuildingUVW LOCobjMod2 LOCobj LOCobjMod1.Xamount LOCobjMod1.Xfloors LOCobjMod1.xMapWidth LOCobjMod1.XmapType
  )

  on SPDYNxMapWidth    changed arg do
  (
    LOCobjMod1.xMapWidth    = arg
    DYNFUNupdateBuildingUVW LOCobjMod2 LOCobj LOCobjMod1.Xamount LOCobjMod1.Xfloors LOCobjMod1.xMapWidth LOCobjMod1.XmapType
  )

  on DDDYNxWallMatIDs  selected arg do
  (
    LOCobjMod1.XwallMatIDs   = arg
    DYNFUNsetBuildingSplineMatID LOCobj arg

    local LOCinstances = DYNFUNgatherNodesWithModInstances DYNbuildingParams LOCobjMod1
    for i = 1 to LOCinstances.count do
    (
      DYNFUNsetBuildingSplineMatID LOCinstances[i] arg
    )

    BMwallMap.bitmap = DYNFUNrenderMatMap LOCmapSize.x LOCmapSize.y LOCobj.material arg
  )

  on DDDYNxMapType selected arg do
  (
    LOCobjMod1.XmapType = arg
    DYNFUNupdateBuildingUVW LOCobjMod2 LOCobj LOCobjMod1.Xamount LOCobjMod1.Xfloors LOCobjMod1.xMapWidth LOCobjMod1.XmapType
    SPDYNxMapWidth.enabled = if arg <= 2 then true else false
  )

  on PKDYNparent picked LOCnewParent do
  (
    if DYNbuildingParams.open do
    (
      undo off
      (
        if superClassOf LOCnewParent == shape then
        (
          DYNFUNloadVSPnodeCallBacks false
          (
            local LOColdObj = LOCobj
            local LOCobjArray = DYNFUNcreateBuild #(LOCnewParent) LOCbosStyle (DYNFUNgetLocalTime()) sceneMaterials SPDYNbuildHeight.value SPDYNnumFloors.value DDDYNxWallMatIDs.selection SPDYNxMapWidth.value DDDYNxMapType.selection false LOCobjMod1 LOCobjMod2 true
            if LOCobjArray.count > 0 then LOCobj = LOCobjArray[1]
            local LOCsuccessSwitch = DYNFUNapplyModifierInstance DynBuilding LOCobj LOColdObj true
            if LOCsuccessSwitch and isValidNode LOColdObj then delete LOColdObj
          )
          DYNFUNloadVSPnodeCallBacks true
          DYNFUNnodeCreatedCallback()
          if isValidNode LOCobj then select LOCobj else clearSelection()
        )
      )
    )
  )

  on BUDYNsave pressed do
  (
    local LOCbosStyleContents = #("", SPDYNbuildHeight.value, SPDYNnumFloors.value, DDDYNXmapType.selection, 0, SPDYNxMapWidth.value, "", "", "", DDDYNxWallMatIDs.selection)
    DYNbuildingObjects.DYNFUNsavebosfile #(LOCbosStyleContents) DYNbuildingParams
    if isValidNode LOCobj then select LOCobj else clearSelection()
  )

  on BUDYNfile pressed do
  (
    --- Ask user to select a Style from the filesystem
    local LOCtempFile = LOCbosStyle

    LOCtempFile = DYNFUNgetOpenFileName "BOS" LOCbosPath LOCresourceKitMode false
    LOCresourceKitMode = DYNfileSelectorKitMode

    if LOCtempFile != undefined then
    (
      if doesFileExist LOCtempFile and LOCtempFile != "" then
      (
        local LOCbosStyleContents = DYNFUNparsePARAMfile LOCtempFile "6001"
        if LOCbosStyleContents.count >= 1 then
        (
          DYNFUNmodifyBuild LOCobjMod1 LOCobjMod2 LOCbosStyleContents[1][2] LOCbosStyleContents[1][3] LOCbosStyleContents[1][10] LOCbosStyleContents[1][6] LOCbosStyleContents[1][4]

          if isValidNode LOCobj then (setAppData LOCobj 424 LOCtempFile)

          --- Update AppData for objects containing instances of this modifier
          local LOCinstances = DYNFUNnodesWithInstancesOfModifier LOCobjMod1
          for i = 1 to LOCinstances.count do (setAppData LOCinstances[i] 424 LOCtempFile)

          DYNFUNbuildingParams LOCobj
          LOCbosPath = LOCbosStyle
        )
      )
    )
    if isValidNode LOCobj then select LOCobj else clearSelection()
  )

  on BUDYNreset pressed do
  (
    if doesFileExist LOCbosStyle then
    (
      if (queryBox (DYNuiResourcesQueries[8]) beep:false) then
      (
        local LOCbosStyleContents = DYNFUNparsePARAMfile LOCtempFile "6001"
        if LOCbosStyleContents.count >= 1 then
        (
          DYNFUNmodifyBuild LOCobjMod1 LOCobjMod2 LOCbosStyleContents[1][2] LOCbosStyleContents[1][3] LOCbosStyleContents[1][10] LOCbosStyleContents[1][6] LOCbosStyleContents[1][4]

          if isValidNode LOCobj then (setAppData LOCobj 424 LOCbosStyle)

          --- Update AppData for objects containing instances of this modifier
          local LOCinstances = DYNFUNnodesWithInstancesOfModifier LOCobjMod1
          for i = 1 to LOCinstances.count do (setAppData LOCinstances[i] 424 LOCbosStyle)

          DYNFUNbuildingParams LOCobj
        )
      )
    )
    else
    (
      if (queryBox (DYNuiResourcesQueries[9]) beep:false) then
      (
        LOCbosStyle = ""
        DYNFUNmodifyBuild LOCobjMod1 LOCobjMod2 FUNheight FUNfloors FUNmatID FUNmapWidth FUNmapType

        if isValidNode LOCobj then (setAppData LOCobj 424 LOCbosStyle)

        --- Update AppData for objects containing instances of this modifier
        local LOCinstances = DYNFUNnodesWithInstancesOfModifier LOCobjMod1
        for i = 1 to LOCinstances.count do (setAppData LOCinstances[i] 424 LOCbosStyle)

        DYNFUNbuildingParams LOCobj
        LOCbosPath = DYNcountryPath + DYNlocalBosPath
      )
    )
    if isValidNode LOCobj then select LOCobj else clearSelection()
  )

  on CBDYNlinked changed arg do
  (
    if arg == false and (InstanceMgr.CanMakeModifiersUnique LOCobj (CVGetMod LOCobj DynBuilding) ) then
    (
      if (queryBox (DYNuiResourcesQueries[10]) title:DYNuiResourcesTitlebars[2]) then
      (
        InstanceMgr.makeModifiersUnique LOCobj (CVGetMod LOCobj DynBuilding) #prompt
        InstanceMgr.makeModifiersUnique LOCobj (CVGetMod LOCobj Uvwmap) #prompt
      )
      else CBDYNlinked.checked = true
    )
    DYNFUNbuildingParams LOCobj
  )

  on PKDYNlink picked arg do
  (
    DYNFUNapplyModifierInstance DynBuilding LOCobj arg true
    DYNFUNbuildingParams LOCobj
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAvQdgkaNi53oqKKmMAasoJWsB4yazlkaKs
-- KdHEyoQi4szFZQedRCJufaEQjWaV7HBo0orQ39xYNPAout2kWIzMcblbVoqkMywW
-- F0R41cuDdoIDS91DPwrB7pFhFVAh5/02yyeNP1qq9D8EyHoN8nHDjPhUHjkRzBkC
-- poaMqQq7hNHyOtimGB1VPf3UDTaML4zffE91kyiRJkO/0CbXxoumqeNiJutNSO9t
-- Z47tAG7Sa9+irVKEAnSpBbAgQDLTQr2RwIw3p3tIRqgkuniAu7RSpJRwbWYSnvxo
-- m7/F1sFcgbNgge5GAgUX8z4jTr+sru6GfJJhaSjLJDQO4yeTEIvZ
-- -----END-SIGNATURE-----