--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNatmosphere ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCfog
  local LOCspinStartValue
  local LOCundoState = on

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNsetupFogParams FUNfog =
  (
    DYNatmosphere.CBATMonOff.checked = isActive FUNfog
    DYNatmosphere.COATMcolor.color   = FUNfog.fog_color
    DYNatmosphere.SPATMnear.value    = FUNfog.near
    DYNatmosphere.SPATMfar.value     = FUNfog.far

    if FUNfog.fog_type == 1 then
    (
      DYNatmosphere.SPATMnear.enabled = false
      DYNatmosphere.SPATMfar.enabled = false
    )
    else
    (
      DYNatmosphere.SPATMnear.enabled = true
      DYNatmosphere.SPATMfar.enabled = true
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  checkbox    CBATMonoff    align:#left pos:[4,9]
  groupbox    GBATMgroup01  width:(DYNiniExplorerWidth - 21) height:56 pos:[4,31]
  colorpicker COATMcolor "" fieldwidth:(DYNiniExplorerWidth - 39) height:25 pos:[8,52]

  groupbox    GBATMgroup02  width:(DYNiniExplorerWidth - 21) height:70 pos:[4,93]
  spinner     SPATMnear     type:#float fieldwidth:60 range:[0,100,0]   scale:0.1 align:#left pos:[(DYNiniExplorerWidth - 96),113]
  spinner     SPATMfar      type:#float fieldwidth:60 range:[0,100,100] scale:0.1 align:#left pos:[(DYNiniExplorerWidth - 96),134]
  label       LBATMnear     width:95 align:#left pos:[13,116]
  label       LBATMfar      width:95 align:#left pos:[13,137]

  button      BUATMreset    width:(DYNiniExplorerWidth - 21) pos:[4,171]
  button      BUATMadvanced width:(DYNiniExplorerWidth - 21) pos:[4,196]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNatmosphere open do
  (
    DYNatmosphere.title = DYNuiRolloutNames[4]
    GBATMgroup01.text   = DYNuiResourcesGroups[4]
    GBATMgroup02.text   = DYNuiResourcesGroups[3]
    BUATMreset.text     = DYNuiResourcesButtons[13]
    BUATMadvanced.text  = DYNuiResourcesButtons[28]
    CBATMonOff.text     = DYNuiResourcesLabels[22]
    LBATMnear.text      = DYNuiResourcesLabels[23]
    LBATMfar.text       = DYNuiResourcesLabels[24]

    if numAtmospherics > 0 then
    (
      for i = 1 to numAtmospherics do
      (
        if (getAtmospheric i).name == DYNfogName then LOCfog = getAtmospheric i
      )
      if LOCfog == undefined then
      (
        LOCfog = fog()
        addAtmospheric LOCfog
        DYNFUNresetFogParams LOCfog
      )
    )
    else
    (
      LOCfog = fog()
      addAtmospheric LOCfog
      DYNFUNresetFogParams LOCfog
    )
    DYNFUNsetupFogParams LOCfog
    if (isActive LOCfog) == false then DYNamite.dnAtmosNode.forecolor = DYNFUNdnColor (DYNINIgreyedOutColor) else DYNamite.dnAtmosNode.forecolor = DYNFUNdnColor (((colorMan.getColor #text) as color) * 255)
  )

  on COATMcolor changed val do LOCfog.fog_color = val

  --- Spinner Near Fog Control
  on SPATMnear changed arg do (with undo label:DYNuiResourcesUndoLabels[1] LOCundoState LOCfog.near = arg)
  on SPATMnear buttonDown  do (LOCundoState = off; LOCspinStartValue = SPATMnear.value)
  on SPATMnear buttonUp    do
  (
    if LOCspinStartValue != SPATMnear.value then
    (
      with undo off LOCfog.near = LOCspinStartValue
      with undo label:DYNuiResourcesUndoLabels[1] on LOCfog.near = SPATMnear.value
    )
    LOCundoState = on
  )


  --- Spinner Far Fog Control
  on SPATMfar changed arg do (with undo label:DYNuiResourcesUndoLabels[1] LOCundoState LOCfog.far = arg)
  on SPATMfar buttonDown  do (LOCundoState = off; LOCspinStartValue = SPATMfar.value)
  on SPATMfar buttonUp    do
  (
    if LOCspinStartValue != SPATMfar.value then
    (
      with undo off LOCfog.far = LOCspinStartValue
      with undo label:DYNuiResourcesUndoLabels[1] on (LOCfog.far = SPATMfar.value)
    )
    LOCundoState = on
  )

  on CBATMonOff changed val do
  (
    setActive LOCfog val
    if (isActive LOCfog) == false then DYNamite.dnAtmosNode.forecolor = DYNFUNdnColor (DYNINIgreyedOutColor) else DYNamite.dnAtmosNode.forecolor = DYNFUNdnColor (((colorMan.getColor #text) as color) * 255)
  )

  on BUATMreset pressed do
  (
    DYNFUNresetFogParams LOCfog
    DYNFUNsetupFogParams LOCfog
  )

  on BUATMadvanced pressed do
  (
    editatmospheric LOCfog
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBPaTjf1SeMjFunBSqL93BiMnqamvMEe30I
-- 9h56CxoKVzYwy5ZDrYX7tZ7TxJzjfrfFx/oyNwlHe+7N64bTnYbwOLfCcyzo1gCb
-- DJlCk/SoGMc3CBR96/CKe6F2p/TtV03l8QibN4XY4VtYSTkoRFmNlcnjjcww1qcz
-- VS+dhTjeri27w7TXBHs2redrH3PpHKgP83oqA5/W52fEJ5LH19nb0LT+uxo8Nkxc
-- PCpLFysfw272Ebn5IUEBS7PDU/GBLFXES2zoWnkhQccWKfR2pyyfowRsHni3RMD0
-- 5YQ0C4HXxxBbyYeboEenSN7NDIKB6WHgmCQM7qQiSyIE2WfZ66Ty
-- -----END-SIGNATURE-----