/*
Name: Custom_Attributes_Presets

Originally created by: Paul Neale as PEN_Attribute_Holder plugin modifier
Company: PEN Productions Inc. http://paulneale.com
Purpose: For storing custom attributes and saving presets for them.

**************************************************************************
Adapted for inclusion in 3ds Max by Autodesk Inc.
Copyright (c) 2015 Autodesk, Inc.
All rights reserved.

These coded instructions, statements, and computer programs contain
unpublished proprietary information written by Autodesk, Inc., and are
protected by Federal copyright law. They may not be disclosed to third
parties or copied or duplicated in any form, in whole or in part, without
the prior written consent of Autodesk, Inc.
**************************************************************************
*/

global PENCopyPaste_vr = #()

CustomAttributesPresets = attributes Custom_Attributes_Presets
	attribID:#(0x1f4433d4, 0x363425fa)
	version:1
	initialRollupState:1
(
	--Locals
	local Names = #(), Values = #(), updatePresets_fn, presets_R
	
	parameters control_P 
	(
		presetName_str type:#stringTab tabSize:0 tabSizeVariable:true
		preset_str type:#stringTab tabSize:0 tabSizeVariable:true
	)
	parameters optionsP rollout:presets_R
	(
		rampOn type:#boolean ui:rampOn_Cb default:false animatable:false
	)
	
	----------------------------------------------Get the Ca definitions
	Fn getCaAttributes_fn =
	(
		caDefs = #()
		caSubs = #()

		local owner = (custAttributes.getOwner this)
		--Get the Defs
		caNum = (custAttributes.count owner)
		for x = 1 to caNum do
		(
			append caDefs (custAttributes.get owner x)
		)
		
		--Get the Ca's in the Defs
		for x = 1 to cadefs.count do
		(
			for y = 1 to caDefs[x].numsubs do
			(
				append caSubs caDefs[x][y]
			)
		)
		caSubs
	)
		
	-------------------------------------------------------adds a preset to the menu
	FN addPreset_fn =
	(
		local presetName = presets_R.presetName_et.text
		local ss = stringStream ""
		
		if presetName != "" do
		(
			ca = getCaAttributes_fn()
			format "%" "#(" to:ss
			if (ca.count == 0) then
			(
				format "%" ")" to:ss
			)
			else
			(
				for x = 1 to ca.count do
				(
					format "%" ca[x].value to:ss
					format "%" (if x == ca.count then (")")else (",")) to:ss
				)
			)
			append presetName_str presetName 
			append preset_str (ss as string)
		)
		presets_R.presetName_et.text = ""
		updatePresets_fn()
	)-- end addPreset_fn
	
	-----------------------------------------------------deletes a preset
	FN deletePreset_fn delNum =
	(
		local owner = (custAttributes.getOwner this)
		CNTobj = (refs.dependents owner)[1]
		
		deleteItem presetName_str delNum
		deleteItem preset_str delNum
		
		updatePresets_fn()
	)--end deletePreset_fn

	------------------------------------------------------saves presets to file
	FN savePre_fn =
	(
		local owner = (custAttributes.getOwner this)
		fileName = getsavefileName caption:~CUSTSTRING_PRESET_SAVE_PRESETS~ filename:(this.name + ".cps")\
			types:~CUSTSTRING_PRESET_CHARACTER_PRESETS_STORE~
	
		if fileName != undefined do							--Check for path
		(
			savedFile = createFile fileName					--Create the file
			close savedFile
			openedFile = openFile fileName mode:"a"
			
			for x = 1 to presetName_str.count do						--Format data to file
			(
				-- convert " to ' to prevent user from getting themselves into trouble on load
				-- note: DO NOT LOCALIZE Name/Value; these are part of the file format!
				format "%" "**Name> " to:openedFile
				format "%%%\n" "\"" (substituteString presetName_str[x] "\"" "'") "\"" to:openedFile
				format "%" "**Value> " to:openedFile
				format "%%%\n" "\"" (substituteString preset_str[x] "\"" "'") "\"" to:openedFile
			)
			close openedFile
		)
		
	)-- end savePre_fn

	-----------------------------------------------------load presets
	FN loadPre_fn =
	(
		presetName_str = #()
		preset_str = #()

		fileName = getopenfileName caption:~CUSTSTRING_PRESET_LOAD_PRESETS~ \
			types:~CUSTSTRING_PRESET_CHARACTER_PRESETS_STORE~
		
		if fileName != undefined do
		(
			openedFile = openFile fileName mode:"r"
			while (not (eof openedFile)) do
			(
				str = (readLine openedFile)
				-- note: DO NOT LOCALIZE Name/Value; these are part of the file format!
				if (filterString str ">")[1] == "**Name" do
				(
					-- 123456789
					-- **Name> ...
					append presetName_str (substituteString (substring str 9 -1) "\"" "")
				)
				if (filterString str ">")[1] == "**Value" do
				(
					-- 1234567890
					-- **Value> ...
					append preset_str (substituteString (substring str 10 -1) "\"" "")
				)
			)
			close openedFile
			
			updatePresets_fn()
		)
		
	)-- end loadPre_fn

	--------------------------------------------------------merge presets
	FN mergePre_fn =
	(
		fileName = getopenfileName caption:~CUSTSTRING_PRESET_MERGE_PRESETS~ \
			types:~CUSTSTRING_PRESET_CHARACTER_PRESETS_STORE~
		
		if fileName != undefined do
		(
			openedFile = openFile fileName mode:"r"
			while (not (eof openedFile)) do
			(
				str = (readLine openedFile)
				if (filterString str ">")[1] == "**Name" do
				(
					append presetName_str (filterString str ">\"")[2]
				)
				if (filterString str ">")[1] == "**Value" do
				(
					append preset_str (filterString str ">\"")[2]
				)
			)
			close openedFile
			
			updatePresets_fn()
		)
	
	)--end mergePre_fn

	------------------------------------------------Check for duplicate names
	Fn dupNameCheck_fn inStr =
	(
		isDup = false
		inStrUpper = (toUpper inStr)
		for x in presetName_str while not isDup do
		(
			if (toUpper x) == inStrUpper do
			(
				isDup = true
			)
		)
		if isDup == false then 
		(
			addPreset_fn()
		)else
		(
			messageBox ~CUSTSTRING_PRESET_DUPLICATE_NAME_ENTERED~ Title:~CUSTSTRING_PRESET_ERROR~
		)
	)

	-------------------------------------------------------- updates preset info
	FN updatePresets_fn =									
	(
		presetName_ar = #()
		for x in presetName_str do (append presetName_ar x)
		presets_R.presets_ddl.items = presetName_ar
		presets_R.presets_ddl.selection=1
	)--end updatePresets_fn 
	
	--Menus
	fn menus =
	(
		rcMenu menuBar
		(
			local modInst --Local instance of the scripted modifier
			menuItem addPreset ~CUSTSTRING_PRESET_ADD_PRESET~
			menuItem deletePreset ~CUSTSTRING_PRESET_DELETE_SELECTED_PRESET~
			menuItem clearPresets ~CUSTSTRING_PRESET_DELETE_ALL_PRESETS~
			menuItem savePreset ~CUSTSTRING_PRESET_SAVE_PRESETS~
			menuItem loadPreset ~CUSTSTRING_PRESET_LOAD_PRESETS~
			menuItem mergePreset ~CUSTSTRING_PRESET_MERGE_PRESETS~
			
			on addPreset picked do
			(
				modInst.dupNameCheck_fn modInst.presets_R.presetName_et.text
			)
			on deletePreset picked do
			(
				if queryBox ~CUSTSTRING_PRESET_QUERY_DELETE_SELECTED~ then
				(
					delNum = modInst.presets_R.presets_ddl.selection
					with MXSCallstackCaptureEnabled off try(modInst.deletePreset_fn delNum)catch()
				)
			)
			on clearPresets picked do
			(
				if queryBox ~CUSTSTRING_PRESET_QUERY_DELETE_ALL~ then
				(
					modInst.presetName_str = #()
					modInst.preset_str = #()
					modInst.presets_R.presets_ddl.items = #()
				)
			)
			on savePreset picked do
			(
				modInst.savePre_fn()
			)
			on loadPreset picked do
			(
				modInst.loadPre_fn()
			)
			on mergePreset picked do
			(
				modInst.mergePre_fn()
			)
			
			on menuBar open do
			(
				modInst=this
			)
		)
		menuBar --Return the menu
	)
		
	rollout presets_R ~CUSTSTRING_PRESET_ROLLOUT_CAPTION~
	(
		group ~CUSTSTRING_PRESET_MANAGE_PRESETS_CAPTION~
		(
			edittext presetName_et ~CUSTSTRING_PRESET_NAME_CAPTION~ fieldWidth:~CUSTSTRING_PRESET_NAME_WIDTH~ align:#left
			button optionsBt ~CUSTSTRING_PRESET_NAME_OPTIONS_CAPTION~ width:~CUSTSTRING_PRESET_NAME_OPTIONS_WIDTH~ pos:~CUSTSTRING_PRESET_NAME_OPTIONS_POSITION~ toolTip:~CUSTSTRING_PRESET_NAME_OPTIONS_TOOLTIP~
		)

		dropDownList presets_ddl ~CUSTSTRING_PRESET_DROPDOWN_CAPTION~
		slider rampCa_Sl ~CUSTSTRING_PRESET_RAMP_CAPTION~ range:[0,1,0] scale:.01 width:~CUSTSTRING_PRESET_RAMP_WIDTH~ --across:2
		checkButton rampOn_Cb "" highLightColor:[0,255,0] width:~CUSTSTRING_PRESET_RAMPON_WIDTH~ height:~CUSTSTRING_PRESET_RAMPON_HEIGHT~ offset:~CUSTSTRING_PRESET_RAMPON_OFFSET~ toolTip:~CUSTSTRING_PRESET_RAMPON_TOOLTIP~
		
		button keyAll_bt ~CUSTSTRING_PRESET_KEYALL_CAPTION~ width:~CUSTSTRING_PRESET_KEYALL_WIDTH~ height:~CUSTSTRING_PRESET_KEYALL_HEIGHT~ across:2 toolTip:~CUSTSTRING_PRESET_KEYALL_TOOLTIP~
		button resetall_bt ~CUSTSTRING_PRESET_RESETALL_CAPTION~ width:~CUSTSTRING_PRESET_RESETALL_WIDTH~ height:~CUSTSTRING_PRESET_RESETALL_HEIGHT~ toolTip:~CUSTSTRING_PRESET_RESETALL_TOOLTIP~
		
		button copyPose_bt ~CUSTSTRING_PRESET_COPY_CAPTION~ width:~CUSTSTRING_PRESET_COPY_WIDTH~ height:~CUSTSTRING_PRESET_COPY_HEIGHT~ across:2 toolTip:~CUSTSTRING_PRESET_COPY_TOOLTIP~
		button pastePose_bt ~CUSTSTRING_PRESET_PASTE_CAPTION~ width:~CUSTSTRING_PRESET_PASTE_WIDTH~ height:~CUSTSTRING_PRESET_PASTE_HEIGHT~ toolTip:~CUSTSTRING_PRESET_PASTE_TOOLTIP~
		
		on optionsBt pressed do
		(
			menuSys=menus()
			popUpMenu menuSys rollout:presets_R
		)

		on copyPose_bt pressed do
		(
			PENCopyPaste_vr = #()
			ca = getCaAttributes_fn()
			for x = 1 to ca.count do
			(
				with MXSCallstackCaptureEnabled off try(append PENCopyPaste_vr ca[x].value)catch()
			)
		)
		
		on pastePose_bt pressed do
		(
 			ca = getCaAttributes_fn()
			for x = 1 to ca.count do
			(
				with MXSCallstackCaptureEnabled off try(ca[x].value = PENCopyPaste_vr[x])catch()
			)
		)
		
		on keyAll_bt pressed do
		(
			ca = getCaAttributes_fn()
			for x = 1 to ca.count do
			(
				with MXSCallstackCaptureEnabled off try(ca[x].value = ca[x].value)catch()
			)
		)
		
		on resetAll_bt pressed do
		(
			ca = getCaAttributes_fn()
			for x = 1 to ca.count do
			(
				with MXSCallstackCaptureEnabled off try(ca[x].value = 0)catch()
			)
		)
		
		on presets_ddl selected i do
		(
			if rampOn_Cb.checked == false then
			(
				ca = getCaAttributes_fn()
				vals = (execute preset_str[i])
				for x = 1 to ca.count do
				(
					with MXSCallstackCaptureEnabled off try(ca[x].value = vals[x])catch()
				)
			)			
		)
		
		local curVals = #()
		on rampCa_Sl buttonDown do
		(
			ca = getCaAttributes_fn()
			for x in ca do
			(
				append curVals x.value
			)
		)
		on rampCa_Sl changed val do
		(
			ca = getCaAttributes_fn()
			vals = if presets_ddl.items.count > 0 then (execute preset_str[presets_ddl.selection])else("")
			for x = 1 to ca.count do
			(
				with MXSCallstackCaptureEnabled off try(ca[x].value = curVals[x] + ((vals[x] - curVals[x]) * val))catch()--
			)
		)
		on rampCa_Sl buttonUp do
		(
			rampCa_Sl.value = 0
			curVals = #()
		)
		
----------------------------------------------------------Save presets	
		on addPre_bt pressed do 		
		(
			dupNameCheck_fn presetName_et.text
		)
		on deletePre_bt pressed do
		(
			delNum = presets_ddl.selection
			with MXSCallstackCaptureEnabled off try(deletePreset_fn delNum)catch()
		)
		
		on savePre_bt pressed do
		(
			savePre_fn()
		)
		
		on loadPre_bt pressed do
		(
			loadPre_fn()
		)
		
		on mergePre_bt pressed do
		(
			mergePre_fn()
		)
		
		on presets_R open do
		(
			updatePresets_fn()
		)--end on open
		
	)-- end presets_R


	on update do
	(
		if version == 1 then
		(
			print ~CUSTSTRING_PRESET_VERSION_1_UPDATED~
		)
	)--end on update	

	fn rollouts = (#(presets_R))
)--end attributes

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAgdn4X1qwA2MMyJM8LNmKQljZ+MWrmvXkc
-- 8gWen2PorsVs/VHnt5lV/zY/HuOXlpSbx+i/P/olA2K1dLjl/QwKXnUibKYBLc2m
-- Ozl+r8UNeDVfLBzM/eK+rpoloVACG+Wqrlunnf3hgOv+6fMx6uap7IbTAn6ZeDzU
-- QkzUwFW7CSsXD+JYpkYMMBY2q/xML26s/XbxtjlIlkbt/Uctp30MIfbOmCx5O/DH
-- 76YjWGq8DbYdM1JZtnnCOYyMaoMPrVqkIqXVbfPat7PD4vnMllH/nhsGA9j1A0xe
-- 8YWIQq9aHKEQQhakfpJQkIk6D/pT5pSXicdMdE3pjxHSQArQ1meL
-- -----END-SIGNATURE-----