/*******************************************************************************
* Lists Styles in a max file
* Author: Attila Szabo
* Date: Nov.23.2006
*******************************************************************************/

/******************************************************************************
* Lists categories and styles to the Listener
*******************************************************************************/
MacroScript ListStylesASCII
	ButtonText:~LISTSTYLESASCII_BUTTONTEXT~
	Category:"DWG.Interop" 
	internalCategory:"DWG.Interop" 
	Tooltip:~LISTSTYLESASCII_TOOLTIP~ 
(
-- constants
strIndent = "  "

function ListStyle aStyle aStyleIndent = 
(
	format "%%\n" aStyleIndent aStyle.name
	
	components = #()
	aStyle.getComponents &components
	for i=1 to components.count do 
	(
		ListStyle components[i] (aStyleIndent + strIndent)
	)
)

function ListStyles aCategory aStyleIndent = 
(
	styles = #()
	aCategory.getStyles &styles
	for i=1 to styles.count do 
	(
		ListStyle styles[i] aStyleIndent
	)
)

function ListCategories = 
(
	format ~FORMATTED_CATEGORIES_CAPTION~ styleMgr.numCategories
	categories =#()
	styleMgr.GetCategories &categories
	for i=1 to categories.count do 
	(
		format "\n%\n" categories[i].name
		ListStyles categories[i] (strIndent + strIndent)
	)
)

function ListStyleMgr = 
(
	format ~FORMATTED_LIST_OF_STYLES_CAPTION~ (maxFilePath + "\\" + maxFileName)
	ListCategories()
)
	
On Execute Do 
(
	ListStyleMgr()
)

)


/*******************************************************************************
* Lists styles to a Tree View
********************************************************************************/
MacroScript ListStylesGUI
	ButtonText:~LISTSTYLESGUI_BUTTONTEXT~
	Category:"DWG.Interop" 
	internalCategory:"DWG.Interop" 
	Tooltip:~LISTSTYLESGUI_TOOLTIP~ 
(

-- indentation in pixels
kIndentation = 10
kRolloutWidth = 200
kRolloutHeight = 400

rollout theRollout ~ROLLOUT_ADT_STYLES_BROWSER~
(
-- Methods that fill in the tree view with ADT styles	
function AddStyle aTVNode aStyle = 
(
	newTVNode = aTVNode.Nodes.add aStyle.name 
	
	components = #()
	aStyle.getComponents &components
	for i=1 to components.count do 
	(
		AddStyle newTVNode components[i]
	)
)

function AddStyles aTVNode aCategory =
(
	styles = #()
	aCategory.getStyles &styles
	for i=1 to styles.count do 
	(
		AddStyle aTVNode styles[i] 
	)
)

function AddCategories aTVNode = 
(
	categories =#()
	styleMgr.GetCategories &categories
	for i=1 to categories.count do 
	(
		newTVNode = aTVNode.Nodes.add categories[i].name
		AddStyles newTVNode categories[i] 
	)
)

function AddStylesMgr aTreeView =
(
	AddCategories (aTreeView.Nodes.add ~ADT_STYLES~)
)


-- Tree view methods

dotNetControl theTreeView "TreeView" width: (kRolloutWidth-10) height: (kRolloutHeight-10) align:#center
	
function clearTreeView tv = 
(
	tv.Nodes.Clear()
)

function initTreeView tv =
(
	tv.Indent= kIndentation 
	--the default style already has root lines.
)

function FillTreeView aTreeView =
(
	clearTreeView aTreeView
	InitTreeView aTreeView 
	AddStylesMgr aTreeView
)

on theTreeView Click arg do 
(
	--First get the TreeView node below the mouse cursor
	--The arg argument has properties .x and .y with the current pos.
	--Use showProperties arg to see what is available...
	--We use the TreeView method GetNodeAt to see what was clicked:
	hitNode = theTreeView.GetNodeAt (dotNetObject "System.Drawing.Point" arg.x arg.y)
	if hitNode != undefined do --if a TreeView node was clicked,
	(
		-- do something
	)
)

on theRollout open do 
(
	FillTreeView theTreeView
)

on theRollout close do 
(
	callbacks.removeScripts #systemPostReset id:#systemPostResetID
	callbacks.removeScripts #systemPostNew id:#systemPostNewID
	callbacks.removeScripts #filePostOpen id:#filePostOpenID
	callbacks.removeScripts #postImport id:#postImportID
	callbacks.removeScripts #fileLinkPostAttach id:#fileLinkPostAttachID
)

) -- rollout

try 
(
  destroyDialog theRollout
  unRegisterViewWindow theRollout
)
catch()

createDialog theRollout kRolloutWidth kRolloutHeight
registerViewWindow theRollout
callbacks.addScript #systemPostReset "theRollout.FillTreeView theRollout.theTreeView" id:#systemPostResetID
callbacks.addScript #systemPostNew "theRollout.FillTreeView theRollout.theTreeView" id:#systemPostNewID
callbacks.addScript #filePostOpen "theRollout.FillTreeView theRollout.theTreeView" id:#filePostOpenID
callbacks.addScript #postImport "theRollout.FillTreeView theRollout.theTreeView" id:#postImportID
callbacks.addScript #fileLinkPostAttach "theRollout.FillTreeView theRollout.theTreeView" id:#fileLinkPostAttachID
)

-- EOF



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAl559wYFFFKq/LhDPGzWrDOkrnE3iFYUSE
-- TbryFZ5WCbBgqr/Wuy9kdAm0SfKKG58FlNnanRCP7Pbrwle0qZfs0Ft0fh4NBXQY
-- OefIv2GXzSBsh0Zxv78ndJ1X0fGiHeHInxcB/eXzoR+rRRak/o9vVp9sB56GFyY6
-- CdYu9wU4QfrV9C7nnhXUOio12cu7i9zRJmCawKfXg/TJPXYf+8pO/sQNG4gdstlg
-- U/qAVb6758VeBzmpFKXoFGwZcI+63/aqpK0340+u3eetl77a3iWlUynkBWty5UZ+
-- DM2wd/EeRUtKLceAazUA9tP+Gp0BRAiXK4WSjMCG97U8mqCbcGum
-- -----END-SIGNATURE-----