/******************************************************************************
 * The following code was generated by the mental mill(R)                     *
 * code generator gen_fx, build 138747.21028
 *                                                                            *
 * Portions Copyright (c) 1986-2011 mental images GmbH, Berlin, Germany.      *
 ******************************************************************************/

// Option settings:
//	annotation_map : default.axml
//	depth_test : false
//	depth_write : false
//	directx_version : 11
//	flip_tex2d_v : false
//	format : HLSL
//	fragment_shader_profile : ps_5_0
//	fx_header : #ifdef _MAX_...
//	generate_sampler_states : true
//	generate_texture_parameters : true
//	pass_annotations : string Script = "Draw=Buffer;";
//	screen_space_vertices : true
//	shader_name : max_exposure_photographic_1
//	shader_type : surface
//	technique_annotations : string Script = "Pass=P0;";
//	vertex_shader_profile : vs_5_0

#ifdef _MAX_
string ParamID = "0x003";
#endif

float Script : STANDARDSGLOBAL <
	string UIWidget = "none";
	string ScriptClass = "scene";
	string ScriptOutput = "color";
	string Script = "Technique=T0";
> = 0.8; // version #

struct State {
    float4 tex_coord[4];
    float3 position;
    float3 origin;
    float3 normal;
    float2 raster;
    float3 direction;
    float ray_length;
};

#ifndef __LIGHT_TYPES
#define __LIGHT_TYPES
//
// Values for the light_type parameter of light shaders
//
#define LIGHT_POINT    0
#define LIGHT_SPOT     1
#define LIGHT_INFINITE 2
#define LIGHT_PLANAR   3

#endif // __LIGHT_TYPES

#ifndef __LIGHT_ITERATOR_STRUCT
#define __LIGHT_ITERATOR_STRUCT
struct Light_iterator {
    float3 msl_point;
    float3 msl_direction;
    float  msl_distance;
    float  msl_dot_nl;
    float3 msl_contribution;
    float3 msl_raw_contribution;
    float3 msl_shadow;
    int    msl_count;
};
#endif // __LIGHT_ITERATOR_STRUCT

#ifndef __FLOAT2_CTOR
#define __FLOAT2_CTOR
float2 __float2_ctor(float v)
{
    return v.xx;
}

#endif // __FLOAT2_CTOR

#ifndef __FLOAT3_CTOR
#define __FLOAT3_CTOR
float3 __float3_ctor(float v)
{
    return v.xxx;
}

#endif // __FLOAT3_CTOR

#ifndef __FLOAT4_CTOR
#define __FLOAT4_CTOR
float4 __float4_ctor(float v)
{
    return v.xxxx;
}

#endif // __FLOAT4_CTOR

#ifndef __DIFFERENTIAL_SCALE
#define __DIFFERENTIAL_SCALE
uniform float __differential_scale = 1.0;

#endif // __DIFFERENTIAL_SCALE

#ifndef __RASTER_OFFSET
#define __RASTER_OFFSET
uniform float2 __raster_offset = float2(0,0);

#endif // __RASTER_OFFSET

int3 _coord_to_texel(float4 props, float2 coord)
{
    return int3(floor(props.xy * coord) + 0.5,0);
}

#ifndef __TEXTURE2D
#define __TEXTURE2D

float4 __tex2D(Texture2D <float4> tex, SamplerState smp, float2 coord)
{
    return tex.SampleGrad(smp, coord,
                   __differential_scale * ddx(coord),
                   __differential_scale * ddy(coord));
}

float4 __tex2D(Texture2D <float4> tex, SamplerState smp, float2 coord,float2 coord_dx, float2 coord_dy)
{
    return tex.SampleGrad(smp, coord, coord_dx, coord_dy);
}

float4 __tex2D(Texture2D <float4> tex, SamplerState smp, float4 props, float2 coord, float2 blur)
{
    return tex.SampleGrad(smp, coord,
                   __differential_scale * ddx(coord) * blur,
                   __differential_scale * ddy(coord) * blur);
}

float4 __tex2D(Texture2D <float4> tex, SamplerState smp, float4 props, float2 coord, float2 blur, int filter)
{
    if(filter == 6)
        return tex.Load(_coord_to_texel(props, coord));
    else
        return tex.SampleGrad(smp, coord,
                   __differential_scale * ddx(coord) * blur,
                   __differential_scale * ddy(coord) * blur);
}

float4 __tex2D(Texture2D <float4> tex, SamplerState smp, float4 props, float2 coord, float2 coord_dx, float2 coord_dy, float2 blur)
{
    return tex.SampleGrad(smp, coord,
                   coord_dx * blur,
                   coord_dy * blur);
}

float4 __tex2D(Texture2D <float4> tex, SamplerState smp, float4 props, float2 coord, float2 coord_dx, float2 coord_dy, float2 blur, int filter)
{
    if(filter == 6)
        return tex.Load(_coord_to_texel(props, coord));
    else
        return tex.SampleGrad(smp, coord,
                       coord_dx * blur,
                       coord_dy * blur);
}

#endif // __TEXTURE2D

#ifndef __MAKE_BASIS
#define __MAKE_BASIS
void __make_basis(const float3 n,const float3 u,const float3 v,out float3 t,out float3 b)
{
    // If u or v a 0, we could create NaNs, try to avoid this.
    float3 c = cross(u,n);
    if(dot(c,c) == 0.0) {
        c = cross(float3(0.0,1.0,0.0),n);
        if(dot(c,c) == 0.0) {
            c = cross(float3(1.0,0.0,0.0), n);
        }
    }
    b = normalize(c);
    t = cross(n,b);
    if(dot(b,v) < 0.0)
        b = -b;
}

#endif // __MAKE_BASIS

#ifndef __PERSPECTIVE_DIVIDE
#define __PERSPECTIVE_DIVIDE
float3 __perspective_divide(float4 pt)
{
    return pt.xyz / pt.w;
}

#endif // __PERSPECTIVE_DIVIDE

#ifndef __DEPENDENT_STATE
#define __DEPENDENT_STATE
void __update_state_origin_or_position(inout State state)
{
    state.direction = state.position - state.origin;
    state.ray_length = length(state.direction);
    state.direction = normalize(state.direction);
} 

#endif // __DEPENDENT_STATE

#ifndef __OBJECT_LABELS
#define __OBJECT_LABELS
uniform int __object_label = 0;
float4 _label_as_color()
{
    int n = __object_label;
    float4 c;
    c.a = float(n / 16777216);
    c.b = float((n % 16777216) / 65536);
    c.g = float((n % 65536) / 256);
    c.r = float(n % 256);
    c /= 255.0;
    return c;
} 

#endif // __OBJECT_LABELS

#ifndef __CLIP_PLANE
#define __CLIP_PLANE
uniform float4 __clip_plane = float4(1.0,1.0,0.0,0.0);

#endif // __CLIP_PLANE

#ifndef __BIT_COUNT
#define __BIT_COUNT
int __bit_count(uint a) {
    int res = 0;
    if (a >= 0x8000) { a -= 0x8000; ++res; }
    if (a >= 0x4000) { a -= 0x4000; ++res; }
    if (a >= 0x2000) { a -= 0x2000; ++res; }
    if (a >= 0x1000) { a -= 0x1000; ++res; }
    if (a >= 0x0800) { a -= 0x0800; ++res; }
    if (a >= 0x0400) { a -= 0x0400; ++res; }
    if (a >= 0x0200) { a -= 0x0200; ++res; }
    if (a >= 0x0100) { a -= 0x0100; ++res; }
    if (a >= 0x8000) { a -= 0x8000; ++res; }
    if (a >= 0x0040) { a -= 0x0040; ++res; }
    if (a >= 0x0020) { a -= 0x0020; ++res; }
    if (a >= 0x0010) { a -= 0x0010; ++res; }
    if (a >= 0x0008) { a -= 0x0008; ++res; }
    if (a >= 0x0004) { a -= 0x0004; ++res; }
    if (a >= 0x0002) { a -= 0x0002; ++res; }
    if (a >= 0x0001) {              ++res; }
    return res;
}
#endif // __BIT_COUNT


//
// The following are free parameters of the shader
// that should be set by the application at runtime.
//
Texture2D <float4> __msl_max_exposure_photographic_1_env_tex <
    string NodeName = "max_exposure_photographic_1";
    string UIMetaSLName = "env_tex";
    string parameter_source = "max_exposure_photographic_1";
	string UIName = "msl_max_exposure_photographic_1_env_tex";
	string ResourceName = "max_ToneOpLog.exr";
	string ResourceType = "2D";
>;

SamplerState __msl_max_exposure_photographic_1_env_tex_sampler {
	Filter = MIN_MAG_MIP_POINT;
	AddressU = Wrap;
	AddressV = Wrap;
	AddressW = Wrap;
};

float4 msl_max_exposure_photographic_1_env_tex_props;

bool msl_max_exposure_photographic_1_active
<
    string UIName = "Active";
    string NodeName = "max_exposure_photographic_1";
    string UIMetaSLName = "active";
    string parameter_source = "max_exposure_photographic_1";
> = true;
float msl_max_exposure_photographic_1_cm2_factor
<
    string UIName = "Cm2 Factor";
    float UIMin = 1.0f;
    float UIMax = 1000.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_exposure_photographic_1";
    string UIMetaSLName = "cm2_factor";
    string parameter_source = "max_exposure_photographic_1";
> = 1.0f;
float4 msl_max_exposure_photographic_1_whitepoint
<
    string UIName = "Whitepoint";
    string NodeName = "max_exposure_photographic_1";
    string UIMetaSLName = "whitepoint";
    string parameter_source = "max_exposure_photographic_1";
    string UIWidget = "Color";
> = {1.04287f,0.983863f,1.03358f,1.0f};
float msl_max_exposure_photographic_1_film_iso
<
    string UIName = "Film speed (ISO)";
    float UIMin = 1.0f;
    float UIMax = 1000.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_exposure_photographic_1";
    string UIMetaSLName = "film_iso";
    string parameter_source = "max_exposure_photographic_1";
> = 100.0f;
float msl_max_exposure_photographic_1_camera_shutter
<
    string UIName = "Shutter Speed";
    float UIMin = 0.0f;
    float UIMax = 1000.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_exposure_photographic_1";
    string UIMetaSLName = "camera_shutter";
    string parameter_source = "max_exposure_photographic_1";
> = 0.125f;
float msl_max_exposure_photographic_1_f_number
<
    string UIName = "Aperture (f-stop)";
    float UIMin = 1.0f;
    float UIMax = 100.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_exposure_photographic_1";
    string UIMetaSLName = "f_number";
    string parameter_source = "max_exposure_photographic_1";
> = 8.0f;
float msl_max_exposure_photographic_1_vignetting
<
    string UIName = "Vignetting";
    float UIMin = 0.0f;
    float UIMax = 10.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_exposure_photographic_1";
    string UIMetaSLName = "vignetting";
    string parameter_source = "max_exposure_photographic_1";
> = 0.0f;
float msl_max_exposure_photographic_1_crush_blacks
<
    string UIName = "Crush Blacks";
    float UIMin = 0.0f;
    float UIMax = 1.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_exposure_photographic_1";
    string UIMetaSLName = "crush_blacks";
    string parameter_source = "max_exposure_photographic_1";
> = 0.2f;
float msl_max_exposure_photographic_1_burn_highlights
<
    string UIName = "Highlights (Burn)";
    string NodeName = "max_exposure_photographic_1";
    string UIMetaSLName = "burn_highlights";
    string parameter_source = "max_exposure_photographic_1";
> = 0.25f;
float msl_max_exposure_photographic_1_saturation
<
    string UIName = "Color Saturation";
    float UIMin = 0.0f;
    float UIMax = 1.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_exposure_photographic_1";
    string UIMetaSLName = "saturation";
    string parameter_source = "max_exposure_photographic_1";
> = 1.0f;
float msl_max_exposure_photographic_1_gamma
<
    string UIName = "Gamma";
    float UIMin = 1.0f;
    float UIMax = 3.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string NodeName = "max_exposure_photographic_1";
    string UIMetaSLName = "gamma";
    string parameter_source = "max_exposure_photographic_1";
> = 2.2f;
/*
	max_exposure_photographic_1_active:
		bool msl_max_exposure_photographic_1_active = true
	max_exposure_photographic_1_burn_highlights:
		float msl_max_exposure_photographic_1_burn_highlights = 0.250000
	max_exposure_photographic_1_camera_shutter:
		float msl_max_exposure_photographic_1_camera_shutter = 0.125000
	max_exposure_photographic_1_cm2_factor:
		float msl_max_exposure_photographic_1_cm2_factor = 1.000000
	max_exposure_photographic_1_crush_blacks:
		float msl_max_exposure_photographic_1_crush_blacks = 0.200000
	max_exposure_photographic_1_f_number:
		float msl_max_exposure_photographic_1_f_number = 8.000000
	max_exposure_photographic_1_film_iso:
		float msl_max_exposure_photographic_1_film_iso = 100.000000
	max_exposure_photographic_1_gamma:
		float msl_max_exposure_photographic_1_gamma = 2.200000
	max_exposure_photographic_1_saturation:
		float msl_max_exposure_photographic_1_saturation = 1.000000
	max_exposure_photographic_1_vignetting:
		float msl_max_exposure_photographic_1_vignetting = 0.000000
	max_exposure_photographic_1_whitepoint:
		Color msl_max_exposure_photographic_1_whitepoint = float4(1.042870,0.983863,1.033580,1.000000)
 */


//
// The following are parameters representing
// non-varying state variables referenced by the shader.
// These should be set by the application at runtime.
//

float4x4 __ndc_to_camera : ProjectionInverse
<
    string UIWidget = "none";
>;
float4x4 __camera_to_ndc : Projection
<
    string UIWidget = "none";
>;
bool __orthographic : Orthographic= false;
float __focal_length : Focal_length= .5;
float __aperture : Aperture= 0.0;
float __aspect_ratio : Aspect_ratio= 1.0;
int __image_x_resolution : Image_x_resolution= 256;
int __image_y_resolution : Image_y_resolution= 256;
float4x4 __object_to_world : World
<
    string UIWidget = "none";
>;
float4x4 __camera_to_world : ViewInverse
<
    string UIWidget = "none";
>;
float4x4 __camera_to_raster
<
    string UIWidget = "none";
>;
float4x4 __ndc_to_raster;

//
// The following are parameters representing
// non-varying non-state variables referenced by the shader.
// These should be set by the application at runtime.
//
float4x4 __internal_to_light;
float4x4 __light_to_internal;
float4 __light_texture_coordinate[4];
float3 __light_texture_tangent_u[4];
float3 __light_texture_tangent_v[4];
float __wavelength_base[3];
float __wavelength_sample[3];
int __light_normal_mode;
float __light_scaling_factor;


//
// The App2vert structure defines the vertex attributes
// used by the vertex shader.
// The application should supply a vertex stream
// containing these elements.
//
struct App2vert
{
    float3 position : POSITION;
    float3 normal : NORMAL;
    float4 texcoord0 : TEXCOORD0;
    float4 texcoord1 : TEXCOORD1;
    float4 texcoord2 : TEXCOORD2;
    float4 texcoord3 : TEXCOORD3;
};

//
// The Vert2frag_out structure defines values output by the vertex shader.
//
struct Vert2frag_out
{
    float4 hpos : SV_Position;
    float4 tex_coord[4] : TEXCOORD0;
    float3 position : TEXCOORD4;
    float3 normal : TEXCOORD5;
};

//
// The Vert2frag_in structure defines values used by the fragment shader.
//
struct Vert2frag_in
{
    float4 hpos : SV_Position;
    float4 tex_coord[4] : TEXCOORD0;
    float3 position : TEXCOORD4;
    float3 normal : TEXCOORD5;
};

//
// This function is the main method of the vertex shader.
//
Vert2frag_out vertex_main(
    App2vert vs_in)
{
    Vert2frag_out vs_out;
    vs_out.position = mul(float4(vs_in.position,1.0),__ndc_to_camera).xyz;
    vs_out.hpos = float4(vs_in.position,1.0);
    vs_out.normal = mul((float3x3)__camera_to_ndc,vs_in.normal);
    vs_out.tex_coord[0] = vs_in.texcoord0;
    vs_out.tex_coord[1] = vs_in.texcoord1;
    vs_out.tex_coord[2] = vs_in.texcoord2;
    vs_out.tex_coord[3] = vs_in.texcoord3;
    return vs_out;
}

//
// Declaration of final output type. For MRT, this is a struct.
//
typedef float4 FS_OUT;

float max_exposure_photographic_X0000000_4029_30(
    inout State state,
    in float4 msl_X0000002,
    in float4 msl_X0000003)
{
    return ((msl_X0000002.r * msl_X0000003.r) + (msl_X0000002.g * msl_X0000003.g)) + (msl_X0000002.b * msl_X0000003.b);
}

int max_exposure_photographic_X0000001_4029_33(
    inout State state,
    inout float4 msl_X0000004,
    in float msl_X0000005,
    in float4 msl_X0000006,
    in float msl_X0000007,
    in float msl_X0000008,
    in float msl_X0000009,
    in float msl_X0000010,
    in float msl_X0000011,
    in float msl_X0000012,
    in float msl_X0000013,
    in float msl_X0000014,
    in float msl_X0000015,
    in float msl_X0000016,
    in int msl_X0000017,
    in int msl_X0000018,
    in float msl_X0000019,
    in float msl_X0000020)
{
    float3 msl_X0000021 = float3(0.0f,0.0f,0.0f);
    msl_X0000021.x = (((msl_X0000015 / float(msl_X0000017)) - 0.5f) * msl_X0000019);
    msl_X0000021.y = ((((msl_X0000016 / float(msl_X0000018)) - 0.5f) * msl_X0000019) / msl_X0000020);
    msl_X0000021.z = (__focal_length);
    msl_X0000021 = normalize(msl_X0000021);
    float msl_X0000022 = 1.0f;
    if(msl_X0000010 > 0.0f)
    {
        msl_X0000022 = pow(msl_X0000021.z,msl_X0000010);
    }
    float4 msl_X0000023 = msl_X0000006;
    if(msl_X0000023.r > 0.0f)
    {
        msl_X0000023.r = (1.0f / msl_X0000023.r);
    }
    else
    {
        msl_X0000023.r = 1.0f;
    }
    if(msl_X0000023.g > 0.0f)
    {
        msl_X0000023.g = (1.0f / msl_X0000023.g);
    }
    else
    {
        msl_X0000023.g = 1.0f;
    }
    if(msl_X0000023.b > 0.0f)
    {
        msl_X0000023.b = (1.0f / msl_X0000023.b);
    }
    else
    {
        msl_X0000023.b = 1.0f;
    }
    float4 msl_X0000024 = float4(0.212671f,0.715160f,0.072169f,0.0f);
    float msl_X0000025 = max_exposure_photographic_X0000000_4029_30(state,msl_X0000024,msl_X0000023);
    msl_X0000023.r /= msl_X0000025;
    msl_X0000023.g /= msl_X0000025;
    msl_X0000023.b /= msl_X0000025;
    float msl_X0000026 = 0.0f;
    float msl_X0000027 = 1.0f / msl_X0000008;
    if(msl_X0000007 > 0.0f)
    {
        msl_X0000026 = (((msl_X0000005 * 0.169811f) * (msl_X0000007 * msl_X0000027)) / ((15.4f * msl_X0000009) * msl_X0000009));
    }
    else
    {
        msl_X0000026 = msl_X0000005;
    }
    float msl_X0000028 = 1.0f / msl_X0000014;
    msl_X0000004.r = (((msl_X0000004.r * msl_X0000023.r) * msl_X0000026) * msl_X0000022);
    msl_X0000004.g = (((msl_X0000004.g * msl_X0000023.g) * msl_X0000026) * msl_X0000022);
    msl_X0000004.b = (((msl_X0000004.b * msl_X0000023.b) * msl_X0000026) * msl_X0000022);
    msl_X0000004.r = ((msl_X0000004.r * (1.0f + (msl_X0000004.r * msl_X0000012))) / (1.0f + msl_X0000004.r));
    msl_X0000004.g = ((msl_X0000004.g * (1.0f + (msl_X0000004.g * msl_X0000012))) / (1.0f + msl_X0000004.g));
    msl_X0000004.b = ((msl_X0000004.b * (1.0f + (msl_X0000004.b * msl_X0000012))) / (1.0f + msl_X0000004.b));
    float msl_X0000029 = max_exposure_photographic_X0000000_4029_30(state,msl_X0000024,msl_X0000004);
    float msl_X0000030 = 1.0f - msl_X0000013;
    msl_X0000004.r = ((msl_X0000004.r * msl_X0000013) + (msl_X0000029 * msl_X0000030));
    msl_X0000004.g = ((msl_X0000004.g * msl_X0000013) + (msl_X0000029 * msl_X0000030));
    msl_X0000004.b = ((msl_X0000004.b * msl_X0000013) + (msl_X0000029 * msl_X0000030));
    if(msl_X0000004.r < 0.0f)
    {
        msl_X0000004.r = 0.0f;
    }
    if(msl_X0000004.g < 0.0f)
    {
        msl_X0000004.g = 0.0f;
    }
    if(msl_X0000004.b < 0.0f)
    {
        msl_X0000004.b = 0.0f;
    }
    float msl_X0000031 = (msl_X0000011 * 2.0f) + 1.0f;
    float msl_X0000032 = pow(max_exposure_photographic_X0000000_4029_30(state,msl_X0000024,msl_X0000004),0.5f);
    msl_X0000030 = (1.0f - msl_X0000032);
    if(msl_X0000032 < 1.0f)
    {
        msl_X0000004.r = ((msl_X0000004.r * msl_X0000032) + (pow(msl_X0000004.r,msl_X0000031) * msl_X0000030));
        msl_X0000004.g = ((msl_X0000004.g * msl_X0000032) + (pow(msl_X0000004.g,msl_X0000031) * msl_X0000030));
        msl_X0000004.b = ((msl_X0000004.b * msl_X0000032) + (pow(msl_X0000004.b,msl_X0000031) * msl_X0000030));
    }
    msl_X0000004.r = pow(msl_X0000004.r,msl_X0000028);
    msl_X0000004.g = pow(msl_X0000004.g,msl_X0000028);
    msl_X0000004.b = pow(msl_X0000004.b,msl_X0000028);
    return 0;
}

int max_exposure_photographic_main_4029_13(
    inout State state,
    Texture2D <float4> __msl_env_tex, SamplerState __msl_env_tex_sampler, float4 msl_env_tex_props,
    float2 msl_texture_uv,
    bool msl_active,
    float msl_cm2_factor,
    float4 msl_whitepoint,
    float msl_film_iso,
    float msl_camera_shutter,
    float msl_f_number,
    float msl_vignetting,
    float msl_crush_blacks,
    float msl_burn_highlights,
    float msl_saturation,
    float msl_gamma,
    out float4 msl_result)
{
    {
        msl_result = float4(0.0f,0.0f,0.0f,0.0f);
        msl_result = __tex2D(__msl_env_tex,__msl_env_tex_sampler,msl_texture_uv);
        float msl_D3DX_16F_MAX = 6.550400e+004f;
        if(msl_result.r > msl_D3DX_16F_MAX)
        {
            msl_result.r = msl_D3DX_16F_MAX;
        }
        if(msl_result.g > msl_D3DX_16F_MAX)
        {
            msl_result.g = msl_D3DX_16F_MAX;
        }
        if(msl_result.b > msl_D3DX_16F_MAX)
        {
            msl_result.b = msl_D3DX_16F_MAX;
        }
        if(msl_active)
        {
            float4 msl_X0000040 = msl_result;
            max_exposure_photographic_X0000001_4029_33(state,msl_X0000040,msl_cm2_factor,msl_whitepoint,msl_film_iso,msl_camera_shutter,msl_f_number,msl_vignetting,msl_crush_blacks,msl_burn_highlights,msl_saturation,msl_gamma,(float2(state.raster.x,__image_y_resolution-1-state.raster.y)).x,(float2(state.raster.x,__image_y_resolution-1-state.raster.y)).y,(__image_x_resolution),(__image_y_resolution),(__aperture),(__aspect_ratio));
            msl_result = msl_X0000040;
        }
    }
    return 0;
}

//
// The following method is the root function of the shader graph
//
float4 max_exposure_photographic_1_eval(State state, out FS_OUT eval_out)
{
    // primary output: 
    float4 msl_result;
    max_exposure_photographic_main_4029_13(state,__msl_max_exposure_photographic_1_env_tex,__msl_max_exposure_photographic_1_env_tex_sampler,msl_max_exposure_photographic_1_env_tex_props,(state.tex_coord)[0].xy,msl_max_exposure_photographic_1_active,msl_max_exposure_photographic_1_cm2_factor,msl_max_exposure_photographic_1_whitepoint,msl_max_exposure_photographic_1_film_iso,msl_max_exposure_photographic_1_camera_shutter,msl_max_exposure_photographic_1_f_number,msl_max_exposure_photographic_1_vignetting,msl_max_exposure_photographic_1_crush_blacks,msl_max_exposure_photographic_1_burn_highlights,msl_max_exposure_photographic_1_saturation,msl_max_exposure_photographic_1_gamma,msl_result);
    eval_out = msl_result;
    return msl_result;
}

//
// This function is the main method of the fragment shader.
// It initializes the values in the state structure
// that are used by nodes in the shader graph
// and produces the final result of the shader.
//
FS_OUT fragment_main(
    Vert2frag_in fs_in) : SV_Target
{
    float3 raster = fs_in.hpos.xyz;
    State state;
    state.position = fs_in.position;
    state.normal = normalize(fs_in.normal);
    state.tex_coord = fs_in.tex_coord;
    state.raster = raster.xy;
    state.origin = __orthographic ? float3(state.position.x, state.position.y, 0) : 0;
    state.ray_length = __orthographic ? abs(state.position.z) : length(state.position);
    state.direction = __orthographic ? float3(0.0,0.0,-1.0) : state.position/state.ray_length;

    FS_OUT eval_out;  // multiple shader outputs
    float4 primary_out;  // primary shader output
    primary_out = max_exposure_photographic_1_eval(state,eval_out);
    FS_OUT fs_out;
    fs_out = primary_out;
    return fs_out;
}

//
// The following define the default technique and pass of the effect.
//
technique11 T0
<
    string Script = "Pass=P0;";
>
{
    pass P0
    <
    string Script = "Draw=Buffer;";
        >
        {
            SetVertexShader(CompileShader(vs_5_0,vertex_main()));
            SetPixelShader(CompileShader(ps_5_0,fragment_main()));
        }
    }

