/******************************************************************************
 * The following code was generated by the mental mill(R)                     *
 * code generator gen_fx, build 138747.21028
 *                                                                            *
 * Portions Copyright (c) 1986-2011 mental images GmbH, Berlin, Germany.      *
 ******************************************************************************/

// Option settings:
//	annotation_map : default.axml
//	depth_test : false
//	depth_write : false
//	directx_version : 9
//	flip_tex2d_v : false
//	format : HLSL
//	fragment_shader_profile : ps_3_0
//	fx_header : #ifdef _MAX_...
//	generate_sampler_states : true
//	generate_texture_parameters : true
//	pass_annotations : string Script = "Draw=Buffer;";
//	screen_space_vertices : true
//	shader_name : max_Gamma_Correction_Phen_1
//	shader_type : surface
//	technique_annotations : string Script = "Pass=P0;";
//	vertex_shader_profile : vs_3_0

#ifdef _MAX_
string ParamID = "0x003";
#endif

float Script : STANDARDSGLOBAL <
	string UIWidget = "none";
	string ScriptClass = "scene";
	string ScriptOutput = "color";
	string Script = "Technique=T0";
> = 0.8; // version #

struct State {
    float4 tex_coord[4];
    float3 position;
    float3 origin;
    float3 normal;
    float3 direction;
    float ray_length;
};

#ifndef __LIGHT_TYPES
#define __LIGHT_TYPES
//
// Values for the light_type parameter of light shaders
//
#define LIGHT_POINT    0
#define LIGHT_SPOT     1
#define LIGHT_INFINITE 2
#define LIGHT_PLANAR   3

#endif // __LIGHT_TYPES

#ifndef __LIGHT_ITERATOR_STRUCT
#define __LIGHT_ITERATOR_STRUCT
struct Light_iterator {
    float3 msl_point;
    float3 msl_direction;
    float  msl_distance;
    float  msl_dot_nl;
    float3 msl_contribution;
    float3 msl_raw_contribution;
    float3 msl_shadow;
    int    msl_count;
};
#endif // __LIGHT_ITERATOR_STRUCT

#ifndef __FLOAT2_CTOR
#define __FLOAT2_CTOR
float2 __float2_ctor(float v)
{
    return v.xx;
}

#endif // __FLOAT2_CTOR

#ifndef __FLOAT4_CTOR
#define __FLOAT4_CTOR
float4 __float4_ctor(float v)
{
    return v.xxxx;
}

#endif // __FLOAT4_CTOR

#ifndef __DIFFERENTIAL_SCALE
#define __DIFFERENTIAL_SCALE
uniform float __differential_scale = 1.0;

#endif // __DIFFERENTIAL_SCALE

#ifndef __RASTER_OFFSET
#define __RASTER_OFFSET
uniform float2 __raster_offset = float2(0,0);

#endif // __RASTER_OFFSET

#ifndef __GRID_SNAP_2D
#define __GRID_SNAP_2D

float2 _grid_snap(float4 props, float2 coord)
{
    return (floor(props.xy * coord) + 0.5) / props.xy;
}

#endif // __GRID_SNAP_2D

#ifndef __TEXTURE2D
#define __TEXTURE2D

float4 __tex2D(sampler2D tex, float2 coord)
{
    return tex2D(tex, coord,
                   __differential_scale * ddx(coord),
                   __differential_scale * ddy(coord));
}

float4 __tex2D(sampler2D tex, float2 coord,float2 coord_dx, float2 coord_dy)
{
    return tex2D(tex, coord, coord_dx, coord_dy);
}

float4 __tex2D(sampler2D tex, float4 props, float2 coord, float2 blur)
{
    return tex2D(tex, coord,
                   __differential_scale * ddx(coord) * blur,
                   __differential_scale * ddy(coord) * blur);
}

float4 __tex2D(sampler2D tex, float4 props, float2 coord, float2 blur, int filter)
{
    if(filter == 6)
        return tex2D(tex, _grid_snap(props, coord),
                       float2(0.0,0.0),
                       float2(0.0,0.0));
    else
        return tex2D(tex, coord,
                   __differential_scale * ddx(coord) * blur,
                   __differential_scale * ddy(coord) * blur);
}

float4 __tex2D(sampler2D tex, float4 props, float2 coord, float2 coord_dx, float2 coord_dy, float2 blur)
{
    return tex2D(tex, coord,
                   coord_dx * blur,
                   coord_dy * blur);
}

float4 __tex2D(sampler2D tex, float4 props, float2 coord, float2 coord_dx, float2 coord_dy, float2 blur, int filter)
{
    if(filter == 6)
        return tex2D(tex, _grid_snap(props, coord),
                       float2(0.0,0.0),
                       float2(0.0,0.0));
    else
        return tex2D(tex, coord,
                       coord_dx * blur,
                       coord_dy * blur);
}

#endif // __TEXTURE2D

#ifndef __MAKE_BASIS
#define __MAKE_BASIS
void __make_basis(const float3 n,const float3 u,const float3 v,out float3 t,out float3 b)
{
    // If u or v a 0, we could create NaNs, try to avoid this.
    float3 c = cross(u,n);
    if(dot(c,c) == 0.0) {
        c = cross(float3(0.0,1.0,0.0),n);
        if(dot(c,c) == 0.0) {
            c = cross(float3(1.0,0.0,0.0), n);
        }
    }
    b = normalize(c);
    t = cross(n,b);
    if(dot(b,v) < 0.0)
        b = -b;
}

#endif // __MAKE_BASIS

#ifndef __PERSPECTIVE_DIVIDE
#define __PERSPECTIVE_DIVIDE
float3 __perspective_divide(float4 pt)
{
    return pt.xyz / pt.w;
}

#endif // __PERSPECTIVE_DIVIDE

#ifndef __DEPENDENT_STATE
#define __DEPENDENT_STATE
void __update_state_origin_or_position(inout State state)
{
    state.direction = state.position - state.origin;
    state.ray_length = length(state.direction);
    state.direction = normalize(state.direction);
} 

#endif // __DEPENDENT_STATE

#ifndef __OBJECT_LABELS
#define __OBJECT_LABELS
uniform int __object_label = 0;
float4 _label_as_color()
{
    int n = __object_label;
    float4 c;
    c.a = float(n / 16777216);
    c.b = float((n % 16777216) / 65536);
    c.g = float((n % 65536) / 256);
    c.r = float(n % 256);
    c /= 255.0;
    return c;
} 

#endif // __OBJECT_LABELS

#ifndef __CLIP_PLANE
#define __CLIP_PLANE
uniform float4 __clip_plane = float4(1.0,1.0,0.0,0.0);

#endif // __CLIP_PLANE

#ifndef __BIT_COUNT
#define __BIT_COUNT
int __bit_count(uint a) {
    int res = 0;
    if (a >= 0x8000) { a -= 0x8000; ++res; }
    if (a >= 0x4000) { a -= 0x4000; ++res; }
    if (a >= 0x2000) { a -= 0x2000; ++res; }
    if (a >= 0x1000) { a -= 0x1000; ++res; }
    if (a >= 0x0800) { a -= 0x0800; ++res; }
    if (a >= 0x0400) { a -= 0x0400; ++res; }
    if (a >= 0x0200) { a -= 0x0200; ++res; }
    if (a >= 0x0100) { a -= 0x0100; ++res; }
    if (a >= 0x8000) { a -= 0x8000; ++res; }
    if (a >= 0x0040) { a -= 0x0040; ++res; }
    if (a >= 0x0020) { a -= 0x0020; ++res; }
    if (a >= 0x0010) { a -= 0x0010; ++res; }
    if (a >= 0x0008) { a -= 0x0008; ++res; }
    if (a >= 0x0004) { a -= 0x0004; ++res; }
    if (a >= 0x0002) { a -= 0x0002; ++res; }
    if (a >= 0x0001) {              ++res; }
    return res;
}
#endif // __BIT_COUNT

#ifndef __BIT_SUBSET
#define __BIT_SUBSET
bool __bit_subset(uint a, uint b)
 {
    if (a >= 0x8000) {
        if (b < 0x8000)
            return false;
        a -= 0x8000;
    }
    if (b >= 0x8000) b -= 0x8000;
    if (a >= 0x4000) {
        if (b < 0x4000)
            return false;
        a -= 0x4000;
    }
    if (b >= 0x4000) b -= 0x4000;
    if (a >= 0x2000) {
        if (b < 0x2000)
            return false;
        a -= 0x2000;
    }
    if (b >= 0x2000) b -= 0x2000;
    if (a >= 0x1000) {
        if (b < 0x1000)
            return false;
        a -= 0x1000;
    }
    if (b >= 0x1000) b -= 0x1000;
    if (a >= 0x0800) {
        if (b < 0x0800)
            return false;
        a -= 0x0800;
    }
    if (b >= 0x0800) b -= 0x0800;
    if (a >= 0x0400) {
        if (b < 0x0400)
            return false;
        a -= 0x0400;
    }
    if (b >= 0x0400) b -= 0x0400;
    if (a >= 0x0200) {
        if (b < 0x0200)
            return false;
        a -= 0x0200;
    }
    if (b >= 0x0200) b -= 0x0200;
    if (a >= 0x0100) {
        if (b < 0x0100)
            return false;
        a -= 0x0100;
    }
    if (b >= 0x0100) b -= 0x0100;
    if (a >= 0x0080) {
        if (b < 0x0080)
            return false;
        a -= 0x0080;
    }
    if (b >= 0x0080) b -= 0x0080;
    if (a >= 0x0040) {
        if (b < 0x0040)
            return false;
        a -= 0x0040;
    }
    if (b >= 0x0040) b -= 0x0040;
    if (a >= 0x0020) {
        if (b < 0x0020)
            return false;
        a -= 0x0020;
    }
    if (b >= 0x0020) b -= 0x0020;
    if (a >= 0x0010) {
        if (b < 0x0010)
            return false;
        a -= 0x0010;
    }
    if (b >= 0x0010) b -= 0x0010;
    if (a >= 0x0008) {
        if (b < 0x0008)
            return false;
        a -= 0x0008;
    }
    if (b >= 0x0008) b -= 0x0008;
    if (a >= 0x0004) {
        if (b < 0x0004)
            return false;
        a -= 0x0004;
    }
    if (b >= 0x0004) b -= 0x0004;
    if (a >= 0x0002) {
        if (b < 0x0002)
            return false;
        a -= 0x0002;
    }
    if (b >= 0x0002) b -= 0x0002;
    if (a >= 0x0001) {
        if (b < 0x0001)
            return false;
        a -= 0x0001;
    }
    if (b >= 0x0001) b -= 0x0001;
    return true;
}
#endif // __BIT_SUBSET

#ifndef __BIT_NOT
#define __BIT_NOT
int __bit_not(int a) {
    return 0xFFFF - a;
}
#endif // __BIT_NOT

#ifndef __BIT_AND
#define __BIT_AND
int __bit_and(uint a, uint b) {
    uint res = a;
    if (a >= 0x8000) {
        a -= 0x8000;
        if (b >= 0x8000) b -= 0x8000; else res -= 0x8000;
    } else if (b >= 0x8000) b -= 0x8000;
    if (a >= 0x4000) {
        a -= 0x4000;
        if (b >= 0x4000) b -= 0x4000; else res -= 0x4000;
    } else if (b >= 0x4000) b -= 0x4000;
    if (a >= 0x2000) {
        a -= 0x2000;
        if (b >= 0x2000) b -= 0x2000; else res -= 0x2000;
    } else if (b >= 0x2000) b -= 0x2000;
    if (a >= 0x1000) {
        a -= 0x1000;
        if (b >= 0x1000) b -= 0x1000; else res -= 0x1000;
    } else if (b >= 0x1000) b -= 0x1000;
    if (a >= 0x0800) {
        a -= 0x0800;
        if (b >= 0x0800) b -= 0x0800; else res -= 0x0800;
    } else if (b >= 0x0800) b -= 0x0800;
    if (a >= 0x0400) {
        a -= 0x0400;
        if (b >= 0x0400) b -= 0x0400; else res -= 0x0400;
    } else if (b >= 0x0400) b -= 0x0400;
    if (a >= 0x0200) {
        a -= 0x0200;
        if (b >= 0x0200) b -= 0x0200; else res -= 0x0200;
    } else if (b >= 0x0200) b -= 0x0200;
    if (a >= 0x0100) {
        a -= 0x0100;
        if (b >= 0x0100) b -= 0x0100; else res -= 0x0100;
    } else if (b >= 0x0100) b -= 0x0100;
    if (a >= 0x0080) {
        a -= 0x0080;
        if (b >= 0x0080) b -= 0x0080; else res -= 0x0080;
    } else if (b >= 0x0080) b -= 0x0080;
    if (a >= 0x0040) {
        a -= 0x0040;
        if (b >= 0x0040) b -= 0x0040; else res -= 0x0040;
    } else if (b >= 0x0040) b -= 0x0040;
    if (a >= 0x0020) {
        a -= 0x0020;
        if (b >= 0x0020) b -= 0x0020; else res -= 0x0020;
    } else if (b >= 0x0020) b -= 0x0020;
    if (a >= 0x0010) {
        a -= 0x0010;
        if (b >= 0x0010) b -= 0x0010; else res -= 0x0010;
    } else if (b >= 0x0010) b -= 0x0010;
    if (a >= 0x0008) {
        a -= 0x0008;
        if (b >= 0x0008) b -= 0x0008; else res -= 0x0008;
    } else if (b >= 0x0008) b -= 0x0008;
    if (a >= 0x0004) {
        a -= 0x0004;
        if (b >= 0x0004) b -= 0x0004; else res -= 0x0004;
    } else if (b >= 0x0004) b -= 0x0004;
    if (a >= 0x0002) {
        a -= 0x0002;
        if (b >= 0x0002) b -= 0x0002; else res -= 0x0002;
    } else if (b >= 0x0002) b -= 0x0002;
    if (a >= 0x0001) {
        a -= 0x0001;
        if (b >= 0x0001) b -= 0x0001; else res -= 0x0001;
    } else if (b >= 0x0001) b -= 0x0001;
    return res;
}
#endif // __BIT_AND

#ifndef __BIT_OR
#define __BIT_OR
int __bit_or(uint a, uint b) {
    uint res = a;
    if (a >= 0x8000) {
        a -= 0x8000;
        if (b >= 0x8000) b -= 0x8000;
    } else if (b >= 0x8000) { b -= 0x8000; res += 0x8000; }
    if (a >= 0x4000) {
        a -= 0x4000;
        if (b >= 0x4000) b -= 0x4000;
    } else if (b >= 0x4000) { b -= 0x4000; res += 0x4000; }
    if (a >= 0x2000) {
        a -= 0x2000;
        if (b >= 0x2000) b -= 0x2000;
    } else if (b >= 0x2000) { b -= 0x2000; res += 0x2000; }
    if (a >= 0x1000) {
        a -= 0x1000;
        if (b >= 0x1000) b -= 0x1000;
    } else if (b >= 0x1000) { b -= 0x1000; res += 0x1000; }
    if (a >= 0x0800) {
        a -= 0x0800;
        if (b >= 0x0800) b -= 0x0800;
    } else if (b >= 0x0800) { b -= 0x0800; res += 0x0800; }
    if (a >= 0x0400) {
        a -= 0x0400;
        if (b >= 0x0400) b -= 0x0400;
    } else if (b >= 0x0400) { b -= 0x0400; res += 0x0400; }
    if (a >= 0x0200) {
        a -= 0x0200;
        if (b >= 0x0200) b -= 0x0200;
    } else if (b >= 0x0200) { b -= 0x0200; res += 0x0200; }
    if (a >= 0x0100) {
        a -= 0x0100;
        if (b >= 0x0100) b -= 0x0100;
    } else if (b >= 0x0100) { b -= 0x0100; res += 0x0100; }
    if (a >= 0x0080) {
        a -= 0x0080;
        if (b >= 0x0080) b -= 0x0080;
    } else if (b >= 0x0080) { b -= 0x0080; res += 0x0080; }
    if (a >= 0x0040) {
        a -= 0x0040;
        if (b >= 0x0040) b -= 0x0040;
    } else if (b >= 0x0040) { b -= 0x0040; res += 0x0040; }
    if (a >= 0x0020) {
        a -= 0x0020;
        if (b >= 0x0020) b -= 0x0020;
    } else if (b >= 0x0020) { b -= 0x0020; res += 0x0020; }
    if (a >= 0x0010) {
        a -= 0x0010;
        if (b >= 0x0010) b -= 0x0010;
    } else if (b >= 0x0010) { b -= 0x0010; res += 0x0010; }
    if (a >= 0x0008) {
        a -= 0x0008;
        if (b >= 0x0008) b -= 0x0008;
    } else if (b >= 0x0008) { b -= 0x0008; res += 0x0008; }
    if (a >= 0x0004) {
        a -= 0x0004;
        if (b >= 0x0004) b -= 0x0004;
    } else if (b >= 0x0004) { b -= 0x0004; res += 0x0004; }
    if (a >= 0x0002) {
        a -= 0x0002;
        if (b >= 0x0002) b -= 0x0002;
    } else if (b >= 0x0002) { b -= 0x0002; res += 0x0002; }
    if (a >= 0x0001) {
        a -= 0x0001;
        if (b >= 0x0001) b -= 0x0001;
    } else if (b >= 0x0001) { b -= 0x0001; res += 0x0001; }
    return res;
}
#endif // __BIT_OR


//
// The following are free parameters of the shader
// that should be set by the application at runtime.
//
texture __msl_max_Gamma_Correction_Phen_1_texture <
    string description = "The texture from which colors will be sampled.";
    string NodeName = "max_Gamma_Correction_Phen_1";
    string UIMetaSLName = "Texture";
    string parameter_source = "max_Gamma_Correction_Phen_1";
	string UIName = "msl_max_Gamma_Correction_Phen_1_texture";
	string ResourceName = "default.dds";
	string ResourceType = "2D";
>;

sampler2D msl_max_Gamma_Correction_Phen_1_texture = sampler_state {
	Texture = <__msl_max_Gamma_Correction_Phen_1_texture>;
	MinFilter = Point;
	MagFilter = Point;
	MipFilter = Point;
	Filter = MIN_MAG_MIP_POINT;
};

float4 msl_max_Gamma_Correction_Phen_1_texture_props;

float msl_max_Gamma_Correction_Phen_1_GammaValue
<
    string UIName = "GammaValue";
    float UIMin = 0.0f;
    float UIMax = 1.0f;
    float UIStep = 0.01;
    string UIWidget = "slider";
    string description = "The R channel's value.";
    string NodeName = "max_Gamma_Correction_Phen_1";
    string UIMetaSLName = "GammaValue";
    string parameter_source = "max_Gamma_Correction_Phen_1";
> = 1.0f;
/*
	max_Gamma_Correction_Phen_1_GammaValue:
		float msl_max_Gamma_Correction_Phen_1_GammaValue = 1.000000
 */


//
// The following are parameters representing
// non-varying state variables referenced by the shader.
// These should be set by the application at runtime.
//

float4x4 __ndc_to_camera : ProjectionInverse
<
    string UIWidget = "none";
>;
float4x4 __camera_to_ndc : Projection
<
    string UIWidget = "none";
>;
bool __orthographic : Orthographic= false;
float4x4 __object_to_world : World
<
    string UIWidget = "none";
>;
float4x4 __camera_to_world : ViewInverse
<
    string UIWidget = "none";
>;

//
// The following are parameters representing
// non-varying non-state variables referenced by the shader.
// These should be set by the application at runtime.
//
float4x4 __internal_to_light;
float4x4 __light_to_internal;
float4 __light_texture_coordinate[4];
float3 __light_texture_tangent_u[4];
float3 __light_texture_tangent_v[4];
float __wavelength_base[3];
float __wavelength_sample[3];
int __light_normal_mode;
float __light_scaling_factor;


//
// The App2vert structure defines the vertex attributes
// used by the vertex shader.
// The application should supply a vertex stream
// containing these elements.
//
struct App2vert
{
    float3 position : POSITION;
    float3 normal : NORMAL;
    float4 texcoord0 : TEXCOORD0;
    float4 texcoord1 : TEXCOORD1;
    float4 texcoord2 : TEXCOORD2;
    float4 texcoord3 : TEXCOORD3;
};

//
// The Vert2frag_out structure defines values output by the vertex shader.
//
struct Vert2frag_out
{
    float4 hpos : POSITION;
    float4 tex_coord[4] : TEXCOORD0;
    float3 position : TEXCOORD4;
    float3 normal : TEXCOORD5;
};

//
// The Vert2frag_in structure defines values used by the fragment shader.
//
struct Vert2frag_in
{
    float4 hpos : POSITION1;
    float4 tex_coord[4] : TEXCOORD0;
    float3 position : TEXCOORD4;
    float3 normal : TEXCOORD5;
};

//
// This function is the main method of the vertex shader.
//
Vert2frag_out vertex_main(
    App2vert vs_in)
{
    Vert2frag_out vs_out;
    vs_out.position = mul(float4(vs_in.position,1.0),__ndc_to_camera).xyz;
    vs_out.hpos = float4(vs_in.position,1.0);
    vs_out.normal = mul((float3x3)__camera_to_ndc,vs_in.normal);
    vs_out.tex_coord[0] = vs_in.texcoord0;
    vs_out.tex_coord[1] = vs_in.texcoord1;
    vs_out.tex_coord[2] = vs_in.texcoord2;
    vs_out.tex_coord[3] = vs_in.texcoord3;
    return vs_out;
}

//
// Declaration of final output type. For MRT, this is a struct.
//
typedef float4 FS_OUT;

int max_Gamma_Correction_Phen_Texture_lookup_2d_main_4029_10(
    inout State state,
    sampler2D msl_texture, float4 msl_texture_props,
    int msl_texture_space,
    float2 msl_texture_uv,
    out float4 msl_result)
{
    msl_result = __tex2D(msl_texture,msl_texture_uv);
    return 0;
}

int max_Gamma_Correction_Phen_Conversion_floats_to_color_main_4029_15(
    inout State state,
    float msl_r,
    float msl_g,
    float msl_b,
    float msl_a,
    out float4 msl_result)
{
    msl_result = float4(msl_r,msl_g,msl_b,msl_a);
    return 0;
}

int max_Gamma_Correction_Phen_max_Color_gamma_main_4029_21(
    inout State state,
    float4 msl_color,
    float4 msl_gamma,
    out float4 msl_result)
{
    msl_result = pow(msl_color,(__float4_ctor(1.0f) / msl_gamma));
    return 0;
}

int max_Gamma_Correction_Phen_main_4029_3(
    inout State state,
    sampler2D msl_texture, float4 msl_texture_props,
    float msl_GammaValue,
    out float4 msl_result)
{
    {
        float4 msl_Texture_lookup_2d_1_result;
        max_Gamma_Correction_Phen_Texture_lookup_2d_main_4029_10(state,msl_texture,msl_texture_props,0,float2((state.tex_coord)[0].x,(state.tex_coord)[0].y),msl_Texture_lookup_2d_1_result);
        float4 msl_Conversion_floats_to_color_1_result;
        max_Gamma_Correction_Phen_Conversion_floats_to_color_main_4029_15(state,msl_GammaValue,msl_GammaValue,msl_GammaValue,1.0f,msl_Conversion_floats_to_color_1_result);
        float4 msl_max_Color_gamma_1_result;
        max_Gamma_Correction_Phen_max_Color_gamma_main_4029_21(state,msl_Texture_lookup_2d_1_result,msl_Conversion_floats_to_color_1_result,msl_max_Color_gamma_1_result);
        msl_result = msl_max_Color_gamma_1_result;
    }
    return 0;
}

//
// The following method is the root function of the shader graph
//
float4 max_Gamma_Correction_Phen_1_eval(State state, out FS_OUT eval_out)
{
    // primary output: 
    float4 msl_result;
    max_Gamma_Correction_Phen_main_4029_3(state,msl_max_Gamma_Correction_Phen_1_texture,msl_max_Gamma_Correction_Phen_1_texture_props,msl_max_Gamma_Correction_Phen_1_GammaValue,msl_result);
    eval_out = msl_result;
    return msl_result;
}

//
// This function is the main method of the fragment shader.
// It initializes the values in the state structure
// that are used by nodes in the shader graph
// and produces the final result of the shader.
//
FS_OUT fragment_main(
    Vert2frag_in fs_in) : COLOR
{
    State state;
    state.position = fs_in.position;
    state.normal = normalize(fs_in.normal);
    state.tex_coord = fs_in.tex_coord;
    state.origin = __orthographic ? float3(state.position.x, state.position.y, 0) : 0;
    state.ray_length = __orthographic ? abs(state.position.z) : length(state.position);
    state.direction = __orthographic ? float3(0.0,0.0,-1.0) : state.position/state.ray_length;

    FS_OUT eval_out;  // multiple shader outputs
    float4 primary_out;  // primary shader output
    primary_out = max_Gamma_Correction_Phen_1_eval(state,eval_out);
    FS_OUT fs_out;
    fs_out = primary_out;
    return fs_out;
}

//
// The following define the default technique and pass of the effect.
//
technique T0
<
    string Script = "Pass=P0;";
>
{
    pass P0
    <
    string Script = "Draw=Buffer;";
        >
        {
            VertexShader = compile vs_3_0 vertex_main();
            PixelShader  = compile ps_3_0 fragment_main();
        }
    }

