texture ColorTex; //ColorTex1 stores back buffer image
texture SrcTexture : InputTexture;
// Target size.
float2 fPixelSize : ViewportPixelSize < string UIWidget = "None"; >;

sampler2D Src = sampler_state
{
   Texture = (SrcTexture);
   MAGFILTER = POINT;
   MINFILTER = POINT;
   ADDRESSU = CLAMP;
   ADDRESSV = CLAMP;
   ADDRESSW = CLAMP;
};

struct VS_OUTPUT
{
   float4 pos       : POSITION0;
   float3 TexCoord  : TEXCOORD0;
};

VS_OUTPUT vs_main( float3 inPos: POSITION )
{
   VS_OUTPUT o;
   inPos.xy = sign( inPos.xy);
   o.pos = float4( inPos.xy, 0.0f, 1.0f);
   o.TexCoord.xy = (float2(o.pos.x, -o.pos.y) + 1.0f)/2.0f + 0.5f / fPixelSize;
   o.TexCoord.z    = 1.0;
   return o;
}

float4 ps_main(float2 texCoord : TEXCOORD0) : COLOR0
{
	return tex2D(Src, texCoord);
}

technique PassThrough
{
	pass Pass_1
	{
		CULLMODE = NONE;
		ZENABLE = FALSE;
		VertexShader = compile vs_3_0 vs_main();
		PixelShader = compile ps_3_0 ps_main();
	}
}