//**************************************************************************/
// Copyright (c) 2010 Autodesk, Inc.
// All rights reserved.
// 
// These coded instructions, statements, and computer programs contain
// unpublished proprietary information written by Autodesk, Inc., and are
// protected by Federal copyright law. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without
// the prior written consent of Autodesk, Inc.
//**************************************************************************/

// World-view-projection transformation.
float4x4 gWVPXf : WorldViewProjection < string UIWidget = "None"; >;

texture2D gRGBTexture;
texture2D gAlphaTexture;

sampler2D RGBSampler = sampler_state
{
    Texture = <gRGBTexture>;
};

sampler2D AlphaSampler = sampler_state
{
    Texture = <gAlphaTexture>;
};

struct VS_INPUT
{
    float4 Pos : POSITION;
    float3 UV : TEXCOORD0;
};

// Vertex shader output structure.
struct VS_TO_PS
{
    float4 HPos : POSITION;
    float3 UV : TEXCOORD0;
};

// Vertex shader.
VS_TO_PS VS_NPR(VS_INPUT In)
{
    VS_TO_PS Out;

    // Transform the position from object space to clip space for output.
    Out.HPos = mul(In.Pos, gWVPXf);

    // Pass the texture coordinates unchanged.
    Out.UV = In.UV;

    return Out;
}

// Pixel shader.
float4 PS_NPR(VS_TO_PS In) : COLOR0
{
    float4 rgb = tex2D(RGBSampler, In.UV);
    float4 alpha = tex2D(AlphaSampler, In.UV);

    return float4(rgb.rgb, alpha.a);
}

// The main technique.
technique Main
{
    pass p0
    {
#ifdef SHADER_MODEL_3
        VertexShader = compile vs_3_0 VS_NPR();
        PixelShader = compile ps_3_0 PS_NPR();
#else
        VertexShader = compile vs_2_0 VS_NPR();
        PixelShader = compile ps_2_0 PS_NPR();
#endif
    }
}

