import QtQuick 2.0
import com.autodesk.toolclips.qml 1.0
import "../Scripts/TCUtils.js" as TCUtils

/** \file SimpleTooltip.qml

A Simplified Tooltip which presents only the tool name and keyboard shortcut.

*/

TCStyledRectangle {
    id : root
    toolTipStyle: true
    arrowSize: ((targetRect.width > 0) && (targetRect.height > 0)) ? TCUtils.dpiScale(8) : 0
    radius : TCUtils.dpiScale(3)
    //shadowColor: "#32000000"
    shadowAreaSize : TCUtils.dpiScale(6)
    shadowOffsetX: TCUtils.dpiFloatScale(3)
    shadowOffsetY: TCUtils.dpiFloatScale(3)
    property int borderHorzMargin : TCUtils.dpiScale(8)
    property int borderVertMargin : TCUtils.dpiScale(5)
    property int borderTopMargin : borderVertMargin + ((arrowPos === Qt.TopEdge) ? arrowSize : 0)
    property int borderBottomMargin : borderVertMargin + ((arrowPos === Qt.BottomEdge) ? arrowSize : 0)
    property int borderLeftMargin : borderHorzMargin + ((arrowPos === Qt.LeftEdge) ? arrowSize : 0)
    property int borderRightMargin : borderHorzMargin + ((arrowPos === Qt.RightEdge) ? arrowSize : 0)
    property int shortcutSpacing : TCUtils.dpiScale(10)
    width : frame.width + borderLeftMargin + borderRightMargin + shadowAreaSize * 2
    height : frame.height + borderTopMargin + borderBottomMargin + shadowAreaSize * 2

    TitleShortcutText {
        id: frame
        x : root.borderLeftMargin + shadowAreaSize
        y : root.borderTopMargin + shadowAreaSize
        implicitWidth:  getTitleWidth()
    }
}
