--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, Conversion taking a param.
--Script ID that will append to destination
fn ScriptID = 
(
	""
)

--Return the name to be display for the source in the Scene Converter UI
fn DisplaySourceName =
(
	~MENTALRAY_PHOTO_EXP_CONTROL~
)

--Returns the source class of the super class id 
fn SourceSuperClassID =
(
	4480 --Tone operator
)

--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
	#(0x73317331L, 0x49154663L) --Mental Ray Photographic Exposure Control
)

--Return the name to be display for the destination in the Scene Converter UI - must be in the order than the destination class ids
fn DisplayDestinationName =
(
	~PHYS_CAM_EXP_CONTROL~
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
	4480 --Tone operator
)

--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
	#(0x27964a9bL, 0x2ea5376aL) --Physical Camera Exposure Control
)

--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
(
	local ret = false	
	local src = SourceClassID()
	
	if(source == undefined) do return false
	
	if(classof src[1] == Array) then
    (
		for cd in src do
		(
			if((cd as string) == (source.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((src as string) == (source.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)
--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
	local ret = false	
	local dest = DestinationClassID()

	if(destination == undefined) do return false
	
	if(classof dest[1] == Array) then
    (
		for cd in dest do
		(
			if((cd as string) == (destination.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((dest as string) == (destination.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Returns some information about this conversion script
fn AboutText =
(
	~ABOUT_TEXT~
)

--This internal function does the parameter mapping
fn ConvertFromSourceToDestination srcExpCtrl destExpCtrl =
(
	if((false == VerifySource srcExpCtrl) or (false == destExpCtrl)) do
	(
		return undefined
	)
	
	destExpCtrl.active = srcExpCtrl.active
	destExpCtrl.processBG = srcExpCtrl.processBG

	destExpCtrl.highlights = srcExpCtrl.burn_highlights
	if(srcExpCtrl.burn_highlights.controller != undefined) do destExpCtrl.highlights.controller = srcExpCtrl.burn_highlights.controller
	
	destExpCtrl.midtones = srcExpCtrl.midtones
	if(srcExpCtrl.midtones.controller != undefined) do destExpCtrl.midtones.controller = srcExpCtrl.midtones.controller
	
	destExpCtrl.shadows = srcExpCtrl.shadows
	if(srcExpCtrl.shadows.controller != undefined) do destExpCtrl.shadows.controller = srcExpCtrl.shadows.controller
	
	destExpCtrl.saturation = srcExpCtrl.saturation
	if(srcExpCtrl.saturation.controller != undefined) do destExpCtrl.saturation.controller = srcExpCtrl.saturation.controller
	
	if(0 != srcExpCtrl.physical_scale_mode) then --if physical scale is Physical Units
	(
		destExpCtrl.physical_scale_mode = 1 --Customed
		destExpCtrl.physical_scale = srcExpCtrl.physical_scale --I'm not sure if this is the same scale cd/m2 vs cd/RGB
		if(srcExpCtrl.physical_scale.controller != undefined) do destExpCtrl.physical_scale.controller = srcExpCtrl.physical_scale.controller
	)
	else -- 1 Unitless
	(
		destExpCtrl.physical_scale_mode = 0
	)
	
	--The following parameters does not exist in the physical camera exposure control, but will be add later
	--This assume the same structure as in the physical camera, may require some factoring when the parameter are added
	/*if(0 == srcExpCtrl.exposure_mode) then -- Exposure mode is mode "Exposure Value"
	(
		destExpCtrl.exposure_gain_type = 1 --Target --Not animatable, so no controller to copy
		destExpCtrl.exposure_value = srcExpCtrl.exposure_value
		if(srcExpCtrl.exposure_value.controller != undefined) do destExpCtrl.exposure_value.controller = srcExpCtrl.exposure_value.controller
	)
	else if(1 == srcExpCtrl.exposure_mode) do -- Exposure mode is mode "Photographic Exposure"
	(
		destExpCtrl.exposure_gain_type = 0 --Manual --Not animatable, so no controller to copy
		destExpCtrl.iso = srcExpCtrl.film_isoUI --Not sure, if I should be using film_iso or film_isoUI, using the UI because it is animatable
		if(srcExpCtrl.film_isoUI.controller != undefined) do destExpCtrl.iso.controller = srcExpCtrl.film_isoUI.controller
		destExpCtrl.shutter_unit_type = 0 --1 / seconds --Not animatable, so no controller to copy
		destExpCtrl.shutter_length_seconds = srcExpCtrl.shutter_speed
		if(srcExpCtrl.shutter_speed.controller != undefined) do destExpCtrl.shutter_length_seconds.controller = srcExpCtrl.shutter_speed.controller
		destExpCtrl.f_number = srcExpCtrl.f_stop
		if(srcExpCtrl.f_stop.controller != undefined) do destExpCtrl.f_number.controller = srcExpCtrl.f_stop.controller
	)
	
	destExpCtrl.white_balance_type = 1 --Temperature --Not animatable, so no controller to copy
	destExpCtrl.white_balance_kelvin = srcExpCtrl.whitepointKelvin
	if(srcExpCtrl.whitepointKelvin.controller != undefined) do destExpCtrl.white_balance_kelvin.controller = srcExpCtrl.whitepointKelvin.controller
	
	destExpCtrl.vignetting_amount = srcExpCtrl.vignetting
	if(srcExpCtrl.vignetting.controller != undefined) do destExpCtrl.vignetting_amount.controller = srcExpCtrl.vignetting.controller*/
	
	destExpCtrl
)

--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case the default parameters are loaded.
fn DefaultConversion source /*not used*/=
(
	local destExpCtrl = Physical_Camera_Exposure_Control use_global_ev:0 
	SceneExposureControl.exposureControl = destExpCtrl
	destExpCtrl	
)

--Main entry point from this script
--This function handles the node's creation
fn Conversion srcExpCtrl =
(
	if(false == VerifySource srcExpCtrl) do return undefined
	
	local destExpCtrl = Physical_Camera_Exposure_Control use_global_ev:0 
	
	ConvertFromSourceToDestination srcExpCtrl destExpCtrl
	
	SceneExposureControl.exposureControl = destExpCtrl
	
	--Missing parameters: global_ev and ev_compensation, assuming default value
		
	destExpCtrl	
)