--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, Conversion taking a param.
--Script ID that will append to destination
fn ScriptID = 
(
	""
)

--Return the name to be display for the source in the Scene Converter UI
fn DisplaySourceName =
(
	~MENTALRAY_AREA_LIGHT~
)
--Returns the source class of the super class id 
fn SourceSuperClassID =
(
	48 --Light
)
--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
	#(0x1b669L, 0x875c2L) --mr Area Light
)

--Return the name to be display for the destination in the Scene Converter UI - must be in the order than the destination class ids
fn DisplayDestinationName =
(
	~FREE_LIGHT~
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
	48 --Light
)
--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
	#(0x32375fccL, 0xb025cf0L) --Free_Light
)

--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
(
	local ret = false	
	local src = SourceClassID()
	
	if(source == undefined) do return false
	
	if(classof src[1] == Array) then
    (
		for cd in src do
		(
			if((cd as string) == (source.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((src as string) == (source.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)
--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
	local ret = false	
	local dest = DestinationClassID()

	if(destination == undefined) do return false
	
	if(classof dest[1] == Array) then
    (
		for cd in dest do
		(
			if((cd as string) == (destination.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((dest as string) == (destination.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Returns some information about this conversion script
fn AboutText =
(
	~ABOUT_TEXT~
)

--This internal function does the parameter mapping
fn ConvertFrom_miAreaLightToPhotometricFreeLight miAreaNode photometricLightNode =
(
	--Copy the name
	photometricLightNode.name = miAreaNode.name

	if ( false == VerifySource miAreaNode or 
		 false == VerifyDestination photometricLightNode
		) do
	(
		--Not the suitable nodes
		return undefined
	)
	
	--Copy the animation controller from one param to another
	if (undefined != miAreaNode.rgb.controller)do
	(
		photometricLightNode.rgbFilter.controller = miAreaNode.rgb.controller
	)
	
	photometricLightNode
)

--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case the default parameters are loaded.
fn DefaultConversion mrAreaLightNode=
(
	--Clone the node to get all the node's data : wirecolor, transform and controllers etc.  
	--to be duplicated to the new node
	
	local ar = #() --the maxOps.CloneNodes needs an array of nodes
	ar[1] = mrAreaLightNode
	
	--When you are cloning a light which has a target, the target will be cloned as well
	--That is what the actualNodesList contains, all cloned nodes from the node we provided.
	local actualNodesList = #()
	
	--The new cloned nodes
	local newNodesList 	 = #()
	
	--Clone our node
	local bRes = maxOps.CloneNodes ar actualNodeList:&actualNodesList newNodes:&newNodesList
	if (false == bRes)do return undefined --something went wrong
	
	--Create a dummy photometric light
	local photometricLight = Free_Light type:"Free_Point"
	
	newLight 				= newNodesList[1]
	print newLight
	print photometricLight
	newLight.name 		= photometricLight.name --copy its name
	newLight.baseobject = photometricLight.baseobject
	--Was there some extra nodes cloned ?
	if (newNodesList.count > 1)do
	(
		--Some target were created, so enable target in photometric light
		newLight.type = "Target_Point"
	)
	
	--Delete the dummy photometric light from the scene
	delete photometricLight
	
	--return the new created light node
	newLight
)

--Main entry point from this script
--This function handles the node's creation
fn Conversion mrAreaLightNode =
(
	if (false == VerifySource mrAreaLightNode )  do
	(
		--Not the suitable node
		return undefined
	)
	
	--Clone the node to get all the node's data : wirecolor, transform and controllers etc.  
	--to be duplicated to the new node
	
	local ar = #() --the maxOps.CloneNodes needs an array of nodes
	ar[1] = mrAreaLightNode
	
	--When you are cloning a light which has a target, the target will be cloned as well
	--That is what the actualNodesList contains, all cloned nodes from the node we provided.
	local actualNodesList = #()
	
	--The new cloned nodes
	local newNodesList 	 = #()
	
	--Clone our node
	local bRes = maxOps.CloneNodes ar actualNodeList:&actualNodesList newNodes:&newNodesList
	if (false == bRes)do return undefined --something went wrong
	
	--Create a dummy photometric light
	local photometricLight = Free_Light type:"Free_Point"

	--Call the parameters mapping function to convert
	ConvertFrom_miAreaLightToPhotometricFreeLight mrAreaLightNode photometricLight
	
	newLight 				= newNodesList[1]
	print newLight
	print photometricLight
	newLight.name 		= photometricLight.name --copy its name
	newLight.baseobject = photometricLight.baseobject
	--Was there some extra nodes cloned ?
	if (newNodesList.count > 1)do
	(
		--Some target were created, so enable target in photometric light
		newLight.type = "Target_Point"
	)
	
	--Delete the dummy photometric light from the scene
	delete photometricLight
	
	--return the new created light node
	newLight
)
