--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, Conversion taking a param.
--Script ID that will append to destination
fn ScriptID = 
(
	""
)

--Return the name to be display for the source in the Scene Converter UI
fn DisplaySourceName =
(
	#(~FREE_CAMERA~, ~TARGET_CAMERA~)
)

--Returns the source class of the super class id 
fn SourceSuperClassID =
(
	#(32, 32) --Camera
)

--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
	#(#(0x1001L, 0x0L)/*Free Camera*/, #(0x1002L, 0x0L)/*Target Camera*/)
)

--Return the name to be display for the destination in the Scene Converter UI - must be in the order than the destination class ids
fn DisplayDestinationName =
(
	~PHYSICAL_CAMERA~
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
	32 --Camera
)

--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
	#(0x46697218L, 0x28e8008dL) --Physical_Camera
)

--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
(
	local ret = false	
	local src = SourceClassID()
	
	if(source == undefined) do return false
	
	if(classof src[1] == Array) then
    (
		for cd in src do
		(
			if((cd as string) == (source.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((src as string) == (source.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
	local ret = false	
	local dest = DestinationClassID()

	if(destination == undefined) do return false
	
	if(classof dest[1] == Array) then
    (
		for cd in dest do
		(
			if((cd as string) == (destination.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((dest as string) == (destination.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Returns some information about this conversion script
fn AboutText =
(
	~ABOUT_TEXT~
)

--This internal function does the parameter mapping
fn ConvertFromLegacyCameraToPhysicalCamera legacyCamera physicalCamera =
(
	if ( false == VerifySource legacyCamera or 
		 false == VerifyDestination physicalCamera
		) do
	(
		--Not the suitable nodes
		return undefined
	)	
	physicalCamera.name = legacyCamera.name
	
	if(#target == (legacyCamera.type)) then
	(
		physicalCamera.targeted = true
		physicalCamera.target_distance = legacyCamera.target_distance
		if(legacyCamera.targetdistance.controller != undefined) do physicalCamera.target_distance.controller = legacyCamera.targetdistance.controller
	)
	else if(#free == (legacyCamera.type)) then
	(
		physicalCamera.targeted = false
		physicalCamera.target_distance = legacyCamera.target_distance
		if(legacyCamera.target_distance.controller != undefined) do physicalCamera.target_distance.controller = legacyCamera.target_distance.controller
	)
	else return undefined

	if(legacyCamera.fov.controller != undefined) do physicalCamera.fov.controller = legacyCamera.fov.controller
	physicalCamera.specify_fov = true
	physicalCamera.fov = legacyCamera.fov -- Copy the fov after the controller has been copied and specify_fov has been set
	
	physicalCamera.environment_near = legacyCamera.nearrange
	if(legacyCamera.nearrange.controller != undefined) do physicalCamera.environment_near.controller = legacyCamera.nearrange.controller
	physicalCamera.environment_far = legacyCamera.farrange	
	if(legacyCamera.farrange.controller != undefined) do physicalCamera.environment_far.controller = legacyCamera.farrange.controller
    
	
	physicalCamera.clip_near = legacyCamera.nearclip
	if(legacyCamera.nearclip.controller != undefined) do physicalCamera.clip_near.controller = legacyCamera.nearclip.controller
	physicalCamera.clip_far = legacyCamera.farclip
	if(legacyCamera.farclip.controller != undefined) do physicalCamera.clip_far.controller = legacyCamera.farclip.controller
	
	--There no controller for these variables
	physicalCamera.clip_on = legacyCamera.clipManually
	physicalCamera.horizon_on = legacyCamera.showHorizon
	physicalCamera.show_camera_cone = if(true ==  legacyCamera.showCone) then 1 else 0
	
	--MultipassEffect
	if(legacyCamera.mpassEnabled) do
	(
		if(isKindOf legacyCamera.mpassEffect Depth_of_FieldMPassCamEffect) then
        (
			physicalCamera.use_dof = true
			
			physicalCamera.specify_focus = if(legacyCamera.mpassEffect.useTargetDistance == true) then 0 else 1
			if(legacyCamera.mpassEffect.useTargetDistance.controller != undefined) do physicalCamera.specify_focus.controller =  legacyCamera.mpassEffect.useTargetDistance.controller
			
			physicalCamera.focus_distance = legacyCamera.mpassEffect.focalDepth
			if(legacyCamera.mpassEffect.focalDepth.controller != undefined) do physicalCamera.focus_distance.controller = legacyCamera.mpassEffect.focalDepth.controller
			
			physicalCamera.f_number = legacyCamera.mpassEffect.sampleRadius
			if(legacyCamera.mpassEffect.sampleRadius.controller != undefined) do physicalCamera.f_number.controller = legacyCamera.mpassEffect.sampleRadius.controller
			
		)
		else if(isKindOf legacyCamera.mpassEffect Depth_of_Field__mental_ray) then
		(
			physicalCamera.use_dof = true 
			physicalCamera.specify_focus = 0 --Assume that with mental ray, we always use target distance
			
			physicalCamera.f_number = legacyCamera.mpassEffect.f_stop
			if(legacyCamera.mpassEffect.f_stop.controller != undefined) do physicalCamera.f_number = legacyCamera.mpassEffect.f_stop.controller
		)
		else if(isKindOf legacyCamera.mpassEffect Motion_BlurMPassCamEffect) do
		(
			physicalCamera.motion_blur_enabled = true 
			physicalCamera.shutter_unit_type = 3 --frames
			
			physicalCamera.shutter_length_frames = legacyCamera.mpassEffect.duration
			if(legacyCamera.mpassEffect.duration.controller != undefined) do physicalCamera.shutter_length_frames.controller = legacyCamera.mpassEffect.duration.controller
		)
	)

	physicalCamera
)

--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case the default parameters are loaded.
fn DefaultConversion legacyCamera=
(
	--Clone the node to get all the node's data : wirecolor, transform and controllers etc.  
	--to be duplicated to the new node
	
	local ar = #() --the maxOps.CloneNodes needs an array of nodes
	ar[1] = legacyCamera
	
	--When you are cloning a light which has a target, the target will be cloned as well
	--That is what the actualNodesList contains, all cloned nodes from the node we provided.
	local actualNodesList = #()
	
	--The new cloned nodes
	local newNodesList 	 = #()
	
	--Clone our node
	local bRes = maxOps.CloneNodes ar actualNodeList:&actualNodesList newNodes:&newNodesList
	if (false == bRes)do return undefined --something went wrong
	
	--Create a Physical Camera	
	local physicalCamera = Physical_Camera targeted:off shutter_offset_enabled:false shutter_offset:0 use_dof:false motion_blur_enabled:false f_number:8.0 specify_focus:0 shutter_length:0.5
		
	newCamera			 = newNodesList[1]
	newCamera.name       = physicalCamera.name --copy its name
	newCamera.baseobject = physicalCamera.baseobject
	
	--Delete the dummy physical camera from the scene
	delete physicalCamera
	
	--return the new created camera node
	newCamera

)

--Main entry point from this script
--This function handles the node's creation
fn Conversion legacyCamera =
(
	if (false == VerifySource legacyCamera )  do
	(
		--Not the suitable node
		return undefined
	)
	
	--Clone the node to get all the node's data : wirecolor, transform and controllers etc.  
	--to be duplicated to the new node
	
	local ar = #() --the maxOps.CloneNodes needs an array of nodes
	ar[1] = legacyCamera
	
	--When you are cloning a light which has a target, the target will be cloned as well
	--That is what the actualNodesList contains, all cloned nodes from the node we provided.
	local actualNodesList = #()
	
	--The new cloned nodes
	local newNodesList 	 = #()
	
	--Clone our node
	local bRes = maxOps.CloneNodes ar actualNodeList:&actualNodesList newNodes:&newNodesList
	if (false == bRes)do return undefined --something went wrong
	
	--Create a Physical Camera	
	local physicalCamera = Physical_Camera targeted:off shutter_offset_enabled:false shutter_offset:0 use_dof:false motion_blur_enabled:false f_number:8.0 specify_focus:0 shutter_length:0.5
	
	--Call the parameters mapping function to convert
	ConvertFromLegacyCameraToPhysicalCamera legacyCamera physicalCamera
	
	newCamera			 = newNodesList[1]
	newCamera.name       = physicalCamera.name --copy its name
	newCamera.baseobject = physicalCamera.baseobject
	
	--Delete the dummy physical camera from the scene
	delete physicalCamera
	
	--return the new created camera node
	newCamera
)

