--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, Conversion taking a param.
--Script ID that will append to destination
fn ScriptID = 
(
	""
)

--Return the name to be display for the source in the Scene Converter UI
fn DisplaySourceName =
(
	#(~ADSK_MATERIAL~, ~ADSK_GENERIC~, ~ADSK_CERAMIC~, ~ADSK_CONCRETE~, ~ADSK_GLAZING~, ~ADSK_HARDWOOD~, ~ADSK_METAL~, ~ADSK_MASONRY~, ~ADSK_METALLIC_PAINT~, ~ADSK_MIRROR~, ~ADSK_PLASTIC_VINYL~, ~ADSK_SOLID_GLASS~, ~ADSK_STONE~, ~ADSK_WALL_PAINT~, ~ADSK_WATER~)
)

--Returns the source class of the super class id 
fn SourceSuperClassID =
(
	#(3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072) --Material
)
--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
	#(#(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L)) --Autodesk Material
)

fn SourceAutodeskMaterialBaseType =
(
	#(""/*Represent all base type*/, "Generic", "Ceramic", "Concrete", "Glazing", "Hardwood", "Metal", "Masonry", "Metallic Paint", "Mirror", "Plastic-Vinyl", "Solid Glass", "Stone", "Wall Paint", "Water")    
)

--Return the name to be display for the destination in the Scene Converter UI - must be in the order than the destination class ids
fn DisplayDestinationName =
(
	~STANDARD_MATERIAL~
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
	3072 --Material
)
--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
	#(0x2L, 0x0L) --Standard Material
)

--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
(
	local ret = false	
	local src = SourceClassID()
	
	if(source == undefined) do return false
	
	if(classof src[1] == Array) then
    (
		for cd in src do
		(
			if((cd as string) == (source.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((src as string) == (source.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)
--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
	local ret = false	
	local dest = DestinationClassID()

	if(destination == undefined) do return false
	
	if(classof dest[1] == Array) then
    (
		for cd in dest do
		(
			if((cd as string) == (destination.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((dest as string) == (destination.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Returns some information about this conversion script
fn AboutText =
(
	~ABOUT_TEXT~
)

--ConvertToGeneric property does not suffice, as it does a copy, we need to have the current texture map
--of the old material, and not just a copy, because the new map will not get converted (if there is rule for them).
fn ConvertToGenericAutodeskMaterial specific = 
(
    local genericMat = specific.ConvertToGeneric 
    local speProperties = getPropNames specific
    local genProperties = getPropNames genericMat
	
	for genProp in genProperties do
    (
        local genPropObj = getProperty genericMat genProp 
        
        if(genPropObj != undefined and (superclassof genPropObj) == textureMap) do
        (
            for speProp in speProperties do
            (                
                local spePropObj = getProperty specific speProp
                if(spePropObj != undefined and CompareTexture genPropObj spePropObj) do
                (
                    setProperty genericMat genProp spePropObj
                )
            )         
        )
    )
    genericMat
)

fn CompareTexture t1 t2 = 
(
	if (
		(superclassof t1 == textureMap) and (superclassof t2 == textureMap) and 
		(Classof t1 == Classof t2) 
	  )
	do
	(
		local same = true
		local properties = getPropNames t1
		for prop in properties do
		(
			local val1 = getProperty t1 prop 
			
			--check if the property exists on t2
			if  true ==  (IsProperty t2 prop) then
			(
				local val2 = getProperty t2 prop  
				if( (val1 as string) != (val2 as string)) do
				(
					return false
				)				
			)
			else
			(
				return false
			)					
		)			
		
		--they have the same properties with same values
		return true
	)
	
	false
)

fn ConvertAutodeskMetalicPaintToStandardMat autodeskMat stdMat = 
(
    stdMat.shaderType = 2--Metal
    
    if(autodeskMat.Metallic_Paint_Color_Option == 0) then --Use Color
    (
        stdMat.diffuse = autodeskMat.Metallic_Paint_Color
        stdMat.diffuseMapEnable = false
    )
    else if(autodeskMat.Metallic_Paint_Color_Option == 1) then --Use Map
    (
        stdMat.diffuseMapEnable = true
        stdMat.diffuseMap = autodeskMat.Metallic_Paint_Color_Map
        stdMat.diffuseMapAmount = autodeskMat.Metallic_Paint_Highlight_Spread
    )
    else if(autodeskMat.Metallic_Paint_Color_Option == 2) then --Use Color by object
    (
        --TODO get the color of the wiring
        stdMat.diffuse = autodeskMat.Metallic_Paint_Color
        stdMat.diffuseMapEnable = false
    )
    
    --Pearl
    if(autodeskMat.Pearl_Enable) then
    (
        stdMat.adLock = false
        --We don't have enough variable tied to the reflection to add another effect, except through a reflection map
        if(autodeskMat.Pearl_Type == 1) then --Chromatic
        (
   		   local c = autodeskMat.Metallic_Paint_Color
		   local pearl = (color ((pow (c.r / 300.0) 5) * 255) ((pow (c.g / 300.0) 5) * 255) ((pow (c.b / 300.0) 5) * 255) )
		   stdMat.ambient = pearl         
        )
        else --Color
        (
            stdMat.ambient = autodeskMat.Pearl_Color
            --Not converted pearl blend 
        )   
    )
    else
    (
        stdMat.specularLevel = 0
        stdMat.adLock = true
    )
    
    --Top Coat
    case autodeskMat.Top_Coat_Type of
    (
         0: -- Car Paint
        (            
            stdMat.glossiness = 80
            stdMat.specularLevel = 80
            
        )
        1: -- Chrome
        (
            stdMat.glossiness = 100
            stdMat.specularLevel = 100
        )
        2: -- Matte
        (
            stdMat.glossiness = 0
            stdMat.specularLevel = 100
        )
        3: -- Custom
        (        
            stdMat.glossiness = autodeskMat.Top_Coat_Glossiness
            stdMat.specularLevel = 100 - autodeskMat.Top_Coat_Angle_Falloff
        )   
    )
)

fn ConvertAutodeskGenericToStandardMat autodeskMat stdMat = 
(
    stdMat.shaderType = 5 --Phong
    stdMat.diffuse = autodeskMat.Generic_Color
    
    stdMat.diffuseMap = autodeskMat.Generic_Image
    stdMat.diffuseMapEnable = (autodeskMat.Generic_Image != undefined)
    stdMat.diffuseMapAmount = autodeskMat.Generic_Image_Fade

    stdMat.glossiness = autodeskMat.Generic_Glossiness
    stdMat.glossinessMap = autodeskMat.Generic_Glossiness_Map
    stdMat.glossinessMapEnable = (autodeskMat.Generic_Glossiness_Option == 1)
    stdMat.glossinessMapAmount = 100.0
    
    --autodeskMat.Generic_Highlights need to figure if we want to switch to Metal Shader

    if(autodeskMat.Reflectivity_Enable == true) then
    (
       stdMat.specularLevel = autodeskMat.Reflectivity_Oblique
    )
    else
    (
        stdMat.specularLevel = 0.0
    )
    
    if(autodeskMat.Transparency_Enable == true) then
    (
        stdMat.opacity = 100 - autodeskMat.Transparency_Amount
        
        stdMat.filterMap = autodeskMat.Transparency_Image
        stdMat.filterMapEnable = (autodeskMat.Transparency_Image != undefined)
        stdMat.filterMapAmount = autodeskMat.Transparency_Amount
        
        stdMat.ior = autodeskMat.Transparency_Refraction
        
        --Translucency not converted -- standard mat transparency Falloff maybe??        
    )
    else
    (
        stdMat.opacity = 100
        stdMat.ior = 1.5
    )
    
    if(autodeskMat.Self_Illumination_Enable) then
    (
        stdMat.selfIllumAmount = 100
        stdMat.useSelfIllumColor = (autodeskMat.Self_Illumination_Filter_Color_Option == 0)
        stdMat.selfIllumColor = autodeskMat.Self_Illumination_Filter_Color
        stdMat.selfIllumMap = autodeskMat.Self_Illumination_Filter_Color_Map
        stdMat.selfIllumMapEnable = (autodeskMat.Self_Illumination_Filter_Color_Option == 1)
        stdMat.selfIllumMapAmount = 100
        
        --Cannot convert luminance and color temperature
    )
    else
    (
        stdMat.selfIllumAmount = 0.0
        stdMat.selfIllumMapEnable = false
    )
    
    if(autodeskMat.Bump_Enable == true) then
    (
        stdMat.bumpMapEnable = true
        stdMat.bumpMap = autodeskMat.Bump_Image
        stdMat.bumpMapAmount = autodeskMat.Bump_Amount 
        
        --Bump Amount by map is not convertable
    )
    else
    (
        stdMat.bumpMapEnable = false
    )
    
    
    --Cutout map ambient occlusion and round corners not converted
    
    stdMat    
) 

--Internal function that does the parameter mapping
fn ConvertFrom_AutodeskToStdMat autodeskMat stdMat =
(
    if ( false == VerifySource autodeskMat or 
		 false == VerifyDestination stdMat
		) do
	(
		--Not the suitable nodes
		return undefined
	)
    
    case autodeskMat.basetype of
    (
        "Metallic Paint": 
			ConvertAutodeskMetalicPaintToStandardMat autodeskMat stdMat
        "Generic":
            ConvertAutodeskGenericToStandardMat autodeskMat stdMat        
        default : 
        (
            local genericMtl = ConvertToGenericAutodeskMaterial autodeskMat
            ConvertAutodeskGenericToStandardMat genericMtl stdMat 
        )
    )
    
	stdMat
)

--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case the default parameters are loaded.
fn DefaultConversion source /*not use*/ =
(
	--Create the dest material
	newMat = StandardMaterial shadertype:4

	newMat
)

--Main entry point from this script
--This function handles the material's creation
fn Conversion autodeskMat =
(
	if (false == VerifySource autodeskMat )  do
	(
		--Not the suitable node
		return undefined
	)
		
	--Create the dest material
	newMat = StandardMaterial shadertype:4
	
	--Call the parameters mapping function to convert
	ConvertFrom_AutodeskToStdMat autodeskMat newMat
	
    if (IsProperty autodeskMat "name") and (undefined != autodeskMat.name) and (String == classof autodeskMat.name)  and (IsProperty newMat "name") do
    (
        newMat.name = autodeskMat.name
    )
    
	--return the new material
	newMat
)
