--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, Conversion taking a param.
--Script ID that will append to destination
fn ScriptID = 
(
	""
)

--Return the name to be display for the source in the Scene Converter UI
fn DisplaySourceName =
(
	#(~ADSK_MATERIAL~, ~ADSK_GENERIC~, ~ADSK_CERAMIC~, ~ADSK_CONCRETE~, ~ADSK_GLAZING~, ~ADSK_HARDWOOD~, ~ADSK_METAL~, ~ADSK_MASONRY~, ~ADSK_METALLIC_PAINT~, ~ADSK_MIRROR~, ~ADSK_PLASTIC_VINYL~, ~ADSK_SOLID_GLASS~, ~ADSK_STONE~, ~ADSK_WALL_PAINT~, ~ADSK_WATER~)
)

--Returns the source class of the super class id 
fn SourceSuperClassID =
(
	#(3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072) --Material
)
--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
	#(#(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L)) --Autodesk Material
)

fn SourceAutodeskMaterialBaseType =
(
	#(""/*Represent all base type*/, "Generic", "Ceramic", "Concrete", "Glazing", "Hardwood", "Metal", "Masonry", "Metallic Paint", "Mirror", "Plastic-Vinyl", "Solid Glass", "Stone", "Wall Paint", "Water")    
)

--Return the name to be display for the destination in the Scene Converter UI - must be in the order than the destination class ids
fn DisplayDestinationName =
(
	~PHYSICAL_MATERIAL~
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
	3072 --Material
)
--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
	#(0x3d6b1cecL, 0xdeadc001L) --Physical Material
)


--ConvertToGeneric property does not suffice, as it does a copy, we need to have the current texture map
--of the old material, and not just a copy, because the new map will not get converted (if there is rule for them).
fn ConvertToGenericAutodeskMaterial specific = 
(
    local genericMat = specific.ConvertToGeneric 
    local speProperties = getPropNames specific
    local genProperties = getPropNames genericMat
	
	for genProp in genProperties do
    (
        local genPropObj = getProperty genericMat genProp 
        
        if(genPropObj != undefined and (superclassof genPropObj) == textureMap) do
        (
            for speProp in speProperties do
            (                
                local spePropObj = getProperty specific speProp
                if(spePropObj != undefined and CompareTexture genPropObj spePropObj) do
                (
                    setProperty genericMat genProp spePropObj
                )
            )         
        )
    )
    genericMat
)

fn CompareTexture t1 t2 = 
(
	if (
		(superclassof t1 == textureMap) and (superclassof t2 == textureMap) and 
		(Classof t1 == Classof t2) 
	  )
	do
	(
		local same = true
		local properties = getPropNames t1
		for prop in properties do
		(
			local val1 = getProperty t1 prop 
			
			--check if the property exists on t2
			if  true ==  (IsProperty t2 prop) then
			(
				local val2 = getProperty t2 prop  
				if( (val1 as string) != (val2 as string)) do
				(
					return false
				)				
			)
			else
			(
				return false
			)					
		)			
		
		--they have the same properties with same values
		return true
	)
	
	false
)

--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
(
	local ret = false	
	local src = SourceClassID()
	
	if(source == undefined) do return false
	
	if(classof src[1] == Array) then
    (
		for cd in src do
		(
			if((cd as string) == (source.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((src as string) == (source.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)
--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
	local ret = false	
	local dest = DestinationClassID()

	if(destination == undefined) do return false
	
	if(classof dest[1] == Array) then
    (
		for cd in dest do
		(
			if((cd as string) == (destination.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((dest as string) == (destination.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Returns some information about this conversion script
fn AboutText =
(
	~ABOUT_TEXT~
)

fn ConvertAutodeskMetalicPaintToPhysicalMat autodeskMat physMat=
(
    physMat.material_mode = 1
    if(autodeskMat.Metallic_Paint_Color_Option == 0) then --Use Color
    (
        physMat.base_color_map_on = false
        physMat.base_color = autodeskMat.Metallic_Paint_Color
        if(autodeskMat.Metallic_Paint_Color.controller != undefined) do physMat.base_color.controller = autodeskMat.Metallic_Paint_Color.controller        
    )
    else if(autodeskMat.Metallic_Paint_Color_Option == 1) then --Use Map
    (
        if(autodeskMat.Metallic_Paint_Color_Map != undefined) then
        (
            physMat.base_color_map_on = true
            physMat.base_color_map = autodeskMat.Metallic_Paint_Color_Map
        )
        else 
        (
            physMat.base_color_map_on = false
            physMat.base_color = autodeskMat.Metallic_Paint_Color
            if(autodeskMat.Metallic_Paint_Color.controller != undefined) do physMat.base_color.controller = autodeskMat.Metallic_Paint_Color.controller 
        )
    )
    else if(autodeskMat.Metallic_Paint_Color_Option == 2) do --Color by object 
    (
        physMat.base_color_map_on = false
		--physMat.base_color = object wiring color Need to figure how to obtain date 
    )
    physMat.metalness = autodeskMat.Metallic_Paint_Highlight_Spread / 100
    physMat.base_weight = 1.0
    physMat.trans_ior = 2.4     
    
    --Pearl
    if(autodeskMat.Pearl_Enable) then
    (
        physMat.roughness = 1.0 - (autodeskMat.Pearl_Amount / 100.0)
        if(autodeskMat.Pearl_Type == 1) then --Chromatic
        (
   		   local c = autodeskMat.Metallic_Paint_Color
		   local pearl = (color ((pow (c.r / 300.0) 5) * 255) ((pow (c.g / 300.0) 5) * 255) ((pow (c.b / 300.0) 5) * 255) )
		   physMat.refl_color = pearl         
        )
        else --Color
        (
            physMat.refl_color = autodeskMat.Pearl_Color
            physMat.reflectivity = 1 - (autodeskMat.Pearl_Blend / 100)
        )        
    )
    else
    (
        physMat.roughness = 1.0
    )

    --Top Coat
    physMat.coating = 1.0
    physMat.coat_color = color 255 255 255
    case autodeskMat.Top_Coat_Type of
    (
        0: -- Car Paint
        (            
            physMat.coat_roughness = 0.0 --Glossiness = 80
            physMat.coat_ior = 2.6 --Rough estimate   
        )
        1: -- Chrome
        (
            physMat.coat_roughness = 0.0
            physMat.coat_ior = 8.0 --Rough estimate
        )
        2: -- Matte
        (
            physMat.coat_roughness = 1.0
            physMat.coat_ior = 2.6 --Rough estimate   
        )
        3: -- Custom
        (        
            physMat.coat_roughness = 1.0 - (autodeskMat.Top_Coat_Glossiness/100)
            local ior = 13.5 * (1 - (autodeskMat.Top_Coat_Angle_Falloff/100)) - 0.1; --This is a linear extrapolation base on the above 2 values. This is not exact
            if(ior < 0) then 
            (
                ior = 0.0
            )
            else if(ior > 5) do
            (
                ior = 5.0
            ) 
            physMat.coat_ior = ior    
        )   
    )
    
    if(autodeskMat.Top_Coat_Finish == 1) do --Orange peel
    (
        --This does not exactly simulate orange peel, but it look similar
        local peel = Noise name:"Orange Peel" 
        peel.type = 0
        peel.size = 2.0
        
        physMat.coat_bump_map_on = true
        physMat.coat_bump_map = peel
        physMat.clearcoat_bump_map_amt = autodeskMat.Top_Coat_Amount / 100
    )
    
    physMat.coat_affect_color = 0.0
    physMat.coat_affect_roughness = 0.0
    
    --Feature not converted
    --Flake
    --Ambient Occlusion
    --Round Corners
    
    physMat     
)

fn ConvertAutodeskGlazingToPhysicalMat autodeskMat physMat = 
(    
    physMat.material_mode = 1
    physMat.base_color = (color 0 0 0 1.0)
    physMat.base_weight = 0
    physMat.transparency = 1.0
    
    --The formulas for the glaze color comes from Autodesk_Material.ms in the AMG config
    local glazecolor = (point3 1.0 1.0 1.0)
    case autodeskMat.Glazing_Color of (
        0: glazecolor = (point3 0.858 0.893 0.879)
        1: glazecolor = (point3 0.676 0.797 0.737)
        2: glazecolor = (point3 0.451 0.459 0.472)
        3: glazecolor = (point3 0.367 0.514 0.651)
        4: glazecolor = (point3 0.654 0.788 0.772)
        5: glazecolor = (point3 0.583 0.516 0.467)
        6: glazecolor = autodeskMat.Glazing_Custom_Color
    )
    
    local coeff = 1.0 / autodeskMat.Glazing_Sheets_of_Glass
	--glazecolor Should be a Point3 or a Color
	if (Color == classof glazecolor)then(
		glazecolor.r = pow glazecolor.r coeff
		glazecolor.g = pow glazecolor.g coeff
		glazecolor.b = pow glazecolor.b coeff
		physMat.trans_color = color (glazecolor.r*255) (glazecolor.g*255) (glazecolor.b*255) 
	)else
	if (Point3 == classof glazecolor)do(
		--Point3 == classof glazecolor
		glazecolor.x = pow glazecolor.x coeff
		glazecolor.y = pow glazecolor.y coeff
		glazecolor.z = pow glazecolor.z coeff
		physMat.trans_color = color (glazecolor.x*255) (glazecolor.y*255) (glazecolor.z*255) 
	)
    
    if(autodeskMat.Glazing_Custom_Color_Option == 1) then
    (
        physMat.trans_color_map = autodeskMat.Glazing_Custom_Color_Map
        physMat.trans_color_map_on = true
    )
    else
    (
        physMat.trans_color_map_on = false
    )
    
    physMat.trans_ior = 1.5 --guess

    physMat.anisotropy = 1.0
    physMat.metalness = 0.0   
    
    physMat.reflectivity = autodeskMat.Glazing_Reflectance / 100
    
    physMat.coat_affect_color = 0.0
    physMat.coat_affect_roughness = 0.0
)

fn ConvertAutodeskSolidGlassToPhysicalMat autodeskMat physMat = 
(
    --Insert code to convert Autodesk Solid Glass to Physical Material here
	physMat	
)

fn ConvertAutodeskGenericToPhysicalMat autodeskMat physMat =
(
    physMat.material_mode = 1
    physMat.base_color = autodeskMat.Generic_Color
    
    physMat.base_color_map_on = (autodeskMat.Generic_Image != undefined)
    physMat.base_color_map = autodeskMat.Generic_Image
	if(physMat.base_color_map_on == true) do
    (
        physMat.base_weight = autodeskMat.Generic_Image_Fade / 100 --Not sure if the base weight affect the diffuse image
    )

    if(autodeskMat.Generic_Highlights == true) then
    (
        physMat.metalness = 1.0
    )
    else
    (
        physMat.metalness = 0.0
    )

    physMat.coating = 0.0
    if(autodeskMat.Reflectivity_Enable == true) do
    (

        physMat.roughness_inv = true --Inverted because the map will be inverted and can't be inverted through code
        physMat.roughness = autodeskMat.Generic_Glossiness / 100
        physMat.roughness_map = autodeskMat.Generic_Glossiness_Map
        physMat.roughness_map_on = (autodeskMat.Generic_Glossiness_Option == 1)

        physMat.brdf_mode = false
        physMat.brdf_low = autodeskMat.Reflectivity_Direct / 100
        physMat.brdf_high = autodeskMat.Reflectivity_Oblique / 100
        physMat.brdf_curve = 5.0
    )
    
    if(autodeskMat.Transparency_Enable == true) then
    (
        physMat.transparency = autodeskMat.Transparency_Amount /100
        --I think the autodesk Translucency is the transparency depth, but I don't know how this translate 
        --This is a total guess, I am not sure if the image is related to the color or the weight? Assuming is the color
        physMat.trans_color_map = autodeskMat.Transparency_Translucency_Map
        physMat.trans_color_map_on = (autodeskMat.Transparency_Translucency_Option == 1)
    )
    else
    (
        physMat.transparency = 0.0
        physMat.trans_color_map_on = false
    )
    physMat.trans_ior = autodeskMat.Transparency_Refraction
    
    if(autodeskMat.Cutouts_Enable) then
    (
        physMat.cutout_map_on = true
        physMat.cutout_map = autodeskMat.Cutouts_Image
    )
    else
    (
        physMat.cutout_map_on = false
    )
    
    if(autodeskMat.Self_Illumination_Enable) then
    (
        physMat.emission = 1.0
        physMat.emit_color = autodeskMat.Self_Illumination_Filter_Color
        physMat.emit_color_map = autodeskMat.Self_Illumination_Filter_Color_Map
        physMat.emit_color_map_on = (autodeskMat.Self_Illumination_Filter_Color_Option == 1)
        physMat.emit_luminance = autodeskMat.Self_Illumination_Luminance
        physMat.emit_kelvin = autodeskMat.Self_Illumination_Color_Temperature
    )
    else
    (
        physMat.emission = 0.0
        physMat.emit_color_map_on = false
    )
    
    if(autodeskMat.Bump_Enable == true) then
    (
        physMat.bump_map_on = true
        physMat.bump_map = autodeskMat.Bump_Image
        physMat.bump_map_amt = autodeskMat.Bump_Amount / 100
        --Bump Amount by map is not convertable
    )
    else
    (
        physMat.bump_map_on = false
    )

    --Ambient occlusion and round corners not converted
    
    physMat.coat_affect_color = 0.0
    physMat.coat_affect_roughness = 0.0
) 

--Internal function that does the parameter mapping
fn ConvertFrom_AutodeskToPhysical autodeskMat physMat =
(
    if ( false == VerifySource autodeskMat or 
		 false == VerifyDestination physMat
		) do
	(
		--Not the suitable nodes
		return undefined
	)

    case autodeskMat.basetype of
    (
        "Metallic Paint": 
			ConvertAutodeskMetalicPaintToPhysicalMat autodeskMat physMat
        "Glazing": 
			ConvertAutodeskGlazingToPhysicalMat autodeskMat physMat
        /*"Solid Glass": 
			ConvertAutodeskSolidGlassToPhysicalMat autodeskMat physMat*/
        "Generic":
            ConvertAutodeskGenericToPhysicalMat autodeskMat physMat
        default : 
        (
            local genericMtl = ConvertToGenericAutodeskMaterial autodeskMat
            ConvertAutodeskGenericToPhysicalMat genericMtl physMat 
        )
    )	
	physMat
)

--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case the default parameters are loaded.
fn DefaultConversion source /*not use*/ =
(
	--Create the dest material
	newMat = PhysicalMaterial()
	newMat
)

--Main entry point from this script
--This function handles the material's creation
fn Conversion autodeskMat =
(
	if (false == VerifySource autodeskMat )  do
	(
		--Not the suitable node
		return undefined
	)
	
	--Create the dest material
	newMat = PhysicalMaterial()
	
	--Call the parameters mapping function to convert
	ConvertFrom_AutodeskToPhysical autodeskMat newMat
	
    if (IsProperty autodeskMat "name") and (undefined != autodeskMat.name) and (String == classof autodeskMat.name) do
    (
        newMat.name = autodeskMat.name
    )

	--return the new material
	newMat
)
