--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, Conversion taking a param.
--Script ID that will append to destination
fn ScriptID = 
(
	""
)

--Return the name to be display for the source in the Scene Converter UI
fn DisplaySourceName =
(
	~MRAY_ARCH_AND_DESIGN~
)

--Returns the source class of the super class id 
fn SourceSuperClassID =
(
	3072 --Material
)
--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
	#(0x70b05735L, 0x4a163654L) --Arch and Design Material
)

--Return the name to be display for the destination in the Scene Converter UI
fn DisplayDestinationName =
(
	#(~ADSK_GENERIC~, ~ADSK_CERAMIC~, ~ADSK_CONCRETE~, ~ADSK_GLAZING~, ~ADSK_HARDWOOD~, ~ADSK_METAL~, ~ADSK_MASONRY~, ~ADSK_METALLIC_PAINT~, ~ADSK_MIRROR~, ~ADSK_PLASTIC_VINYL~, ~ADSK_SOLID_GLASS~, ~ADSK_STONE~, ~ADSK_WALL_PAINT~, ~ADSK_WATER~)
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
	#(3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072, 3072) --Material
)
--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
	#(#(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L), #(0x1ed415e4L, 0x213daaf8L)) --Autodesk Material
)

fn DestinationAutodeskMaterialBaseType =
(
	#("Generic", "Ceramic", "Concrete", "Glazing", "Hardwood", "Metal", "Masonry", "Metallic Paint", "Mirror", "Plastic-Vinyl", "Solid Glass", "Stone", "Wall Paint", "Water")    
)

--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
(
	local ret = false	
	local src = SourceClassID()
	
	if(source == undefined) do return false
	
	if(classof src[1] == Array) then
    (
		for cd in src do
		(
			if((cd as string) == (source.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((src as string) == (source.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)
--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
	local ret = false	
	local dest = DestinationClassID()

	if(destination == undefined) do return false
	
	if(classof dest[1] == Array) then
    (
		for cd in dest do
		(
			if((cd as string) == (destination.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((dest as string) == (destination.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Returns some information about this conversion script
fn AboutText =
(
	~ABOUT_TEXT~
)


--Internal function that does the parameter mapping
fn ConvertFrom_ArchAndDesignToAutodesk Source Dest =
(
	if ( false == VerifySource Source or 
		 false == VerifyDestination Dest
		) do
	(
		--Not the suitable nodes
		return undefined
	)
	
	Dest
)

fn GetDefinitionFromBaseType baseType =
(
	--The generic material list below comes from the fat_materials_autodeskmaterial.ms. 
	--The list should probably be adjust when we the script parameters conversion is done.
	generic_materials = #(
	#("Generic"       , 0 , 0  ),
	#("Concrete"      , 1 , 10 ),
	#("Glazing"       , 3 , 20 ),
	#("Ceramic"       , 7 , 20 ),
	#("Hardwood"      , 9 , 20 ),
	#("Plastic-Vinyl" , 11, 15 ),
	#("Masonry"       , 19, 20 ),
	#("Metal"         , 22, 10 ),
	#("Solid Glass"   , 29, 10 ),
	#("Stone"         , 32, 10 ),
	#("Water"         , 33, 5  ),
	#("Metallic Paint", 34, 5  ),
	#("Mirror"        , 35, 5  ),
	#("Wall Paint"    , 36, 5  )
	)	
	
	local defId = #(-1,-1)
	for mat in generic_materials do
	(
		if(mat[1] == baseType) do
		(
			defId[1] = mat[2]
			defId[2] = mat[3]
		)
	)
	
	local defStr = undefined
	if(defId[1] != -1 and defId[2] != -1) do
	(
		defStr = AutodeskMaterialManager.GetDefinitionIdentifier defId[1] defId[2]
	)
	
	defStr
)	


--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case the default parameters are loaded.
fn DefaultConversion source /*not use*/ basetype =
(
	--Create the dest material
	local defStr = GetDefinitionFromBaseType (basetype as string)
	if(defStr == undefined) do return undefined --the base type given is invalid
	
	--Create the dest material
	newMat = AutodeskMaterialManager.CreateAutodeskMaterial defStr

	newMat
)

--Main entry point from this script
--This function handles the material's creation
fn Conversion archandDesignMat basetype =
(
	if (false == VerifySource archandDesignMat )  do
	(
		--Not the suitable node
		return undefined
	)
	
	--Create the dest material
	local defStr = GetDefinitionFromBaseType (basetype as string)
	if(defStr == undefined) do return undefined --the base type given is invalid
	
	newMat = AutodeskMaterialManager.CreateAutodeskMaterial defStr
	
	--Call the parameters mapping function to convert
	ConvertFrom_ArchAndDesignToAutodesk archandDesignMat newMat
	
	if (IsProperty archandDesignMat "name") and (undefined != archandDesignMat.name) and (String == classof archandDesignMat.name)  and (IsProperty newMat "name") do
	(
		newMat.name = archandDesignMat.name
	)

	--return the new material
	newMat
)