/*

  Macro_Scripts File
Purposes:  
    
	define actions for the viewport shading manager introduced in 3ds max 10

Revision History
	March 2007: Neil Hazzard
	created for 3ds MAX 10
*/

-- Macro Scripts for IViewportShadingMgr
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
--***********************************************************************************************
MacroScript Viewport_Shading_Display_Selected_Lights
            ButtonText:~VIEWPORT_SHADING_DISPLAY_SELECTED_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_DISPLAY_SELECTED_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_DISPLAY_SELECTED_LIGHTS_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.DisplayOnlySelectedLights()
)

MacroScript Viewport_Shading_Toggle_Selected_Lights
            ButtonText:~VIEWPORT_SHADING_TOGGLE_SELECTED_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_TOGGLE_SELECTED_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_TOGGLE_SELECTED_LIGHTS_TOOLTIP~ 
(
	on ischecked do 
	(
		if NitrousGraphicsManager.IsEnabled() ==true then
		(
			viewportViewSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			return (viewportViewSetting.AutoDisplaySelectedLightEnabled == true)
		)
		else
		(
			return IViewportShadingMgr.AutoDisplaySelLights
		)
	)
	on isEnabled do 
	(
		if NitrousGraphicsManager.IsEnabled() ==true then
		(
			viewportViewSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			bShaded = (viewportViewSetting.VisualStyleMode == #Shaded)
			bWireframe = (viewportViewSetting.VisualStyleMode == #Wireframe)
			bBoundingBox = (viewportViewSetting.VisualStyleMode == #BoundingBox)
			if bShaded or bWireframe or bBoundingBox then
				return false
			else
				return true
		)
		else
		(
			bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
			viewSettings = maxops.GetViewportShadingSettings()
			bHWEnabled = viewSettings.ActivateViewportShading
			return (bHWSupported == true and bHWEnabled == true)
		)
	)
	On Execute Do
	(
		if NitrousGraphicsManager.IsEnabled() ==true then
		(
			viewportViewSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			Try (viewportViewSetting.AutoDisplaySelectedLightEnabled = (not viewportViewSetting.AutoDisplaySelectedLightEnabled))
			catch()	
		)
		else
		(
			Try (IViewportShadingMgr.AutoDisplaySelLights  = (not IViewportShadingMgr.AutoDisplaySelLights ))	
			catch()
		)
	)
)

MacroScript Viewport_Shading_Lock_Selected_Lights
            ButtonText:~VIEWPORT_SHADING_LOCK_SELECTED_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_LOCK_SELECTED_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_LOCK_SELECTED_LIGHTS_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.LockSelectedLights true
	
	on isEnabled do 
	(
		if NitrousGraphicsManager.IsEnabled() ==true then
		(
			viewportViewSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			bShaded = (viewportViewSetting.VisualStyleMode == #Shaded)
			bWireframe = (viewportViewSetting.VisualStyleMode == #Wireframe)
			bBoundingBox = (viewportViewSetting.VisualStyleMode == #BoundingBox)
			if bShaded or bWireframe or bBoundingBox then
				return false
			else
				return true
		)
		else
		(
			bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
			viewSettings = maxops.GetViewportShadingSettings()
			bHWEnabled = viewSettings.ActivateViewportShading
			return (bHWSupported == true and bHWEnabled == true)
		)
	)	
)

MacroScript Viewport_Shading_Unlock_Selected_Lights
            ButtonText:~VIEWPORT_SHADING_UNLOCK_SELECTED_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_UNLOCK_SELECTED_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_UNLOCK_SELECTED_LIGHTS_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.LockSelectedLights false
	on isEnabled do 
	(
		if NitrousGraphicsManager.IsEnabled() ==true then
		(
			viewportViewSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			bShaded = (viewportViewSetting.VisualStyleMode == #Shaded)
			bWireframe = (viewportViewSetting.VisualStyleMode == #Wireframe)
			bBoundingBox = (viewportViewSetting.VisualStyleMode == #BoundingBox)
			if bShaded or bWireframe or bBoundingBox then
				return false
			else
				return true
		)
		else
		(
			bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
			viewSettings = maxops.GetViewportShadingSettings()
			bHWEnabled = viewSettings.ActivateViewportShading
			return (bHWSupported == true and bHWEnabled == true)
		)
	)	
)

MacroScript Viewport_Shading_Select_Illuminating_Lights
            ButtonText:~VIEWPORT_SHADING_SELECT_ILLUMINATING_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_SELECT_ILLUMINATING_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_SELECT_ILLUMINATING_LIGHTS_TOOLTIP~  
(
	On Execute Do IViewportShadingMgr.SelectIlluminatingLights()
	on isEnabled do 
	(
		bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
		viewSettings = maxops.GetViewportShadingSettings()
		bHWEnabled = viewSettings.ActivateViewportShading
		return (bHWSupported == true and bHWEnabled == true)
	)	
)

MacroScript Viewport_Shading_Select_Shadow_Casting_Lights
            ButtonText:~VIEWPORT_SHADING_SELECT_SHADOW_CASTING_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_SELECT_SHADOW_CASTING_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_SELECT_SHADOW_CASTING_LIGHTS_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.SelectShadowCastingLights()
	on isEnabled do 
	(
		bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
		viewSettings = maxops.GetViewportShadingSettings()
		bHWEnabled = viewSettings.ActivateViewportShading
		return (bHWSupported == true and bHWEnabled == true)
	)	
)

MacroScript Viewport_Shading_Enable_Shadows_Selected
            ButtonText:~VIEWPORT_SHADING_ENABLE_SHADOWS_SELECTED_BUTTONTEXT~
            category:~VIEWPORT_SHADING_ENABLE_SHADOWS_SELECTED_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_ENABLE_SHADOWS_SELECTED_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.CastShadowsSelectedOnly true
	on isEnabled do 
	(
		bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
		viewSettings = maxops.GetViewportShadingSettings()
		bHWEnabled = viewSettings.ActivateViewportShading
		return (bHWSupported == true and bHWEnabled == true)
	)	
)

MacroScript Viewport_Shading_Disable_Shadows_Selected
            ButtonText:~VIEWPORT_SHADING_DISABLE_SHADOWS_SELECTED_BUTTONTEXT~
            category:~VIEWPORT_SHADING_DISABLE_SHADOWS_SELECTED_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_DISABLE_SHADOWS_SELECTED_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.CastShadowsSelectedOnly false
	on isEnabled do 
	(
		bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
		viewSettings = maxops.GetViewportShadingSettings()
		bHWEnabled = viewSettings.ActivateViewportShading
		return (bHWSupported == true and bHWEnabled == true)
	)	
)

MacroScript Viewport_GPU_Diagnostics
            ButtonText:~VIEWPORT_GPU_DIAGNOSTICS_BUTTONTEXT~
            category:~VIEWPORT_GPU_DIAGNOSTICS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_GPU_DIAGNOSTICS_TOOLTIP~ 
(
	On Execute Do
	(
		if (classof(renderers.current) == mental_ray_iray_renderer) do
		(
			setListenerSelText renderers.current.hardwareReport
			setListenerSelText "\n\n"
		)
		-- Alwasy print the OGS diagnostics
		setListenerSelText OGSDiagnostics.hardwareReport

		if NitrousGraphicsManager.isEnabled() != true do
			IViewportShadingMgr.ReviewGPUDiagnostics()
	)
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBon0c4jUMHv+4U9yOMHrbY2C1uCQvIk41n
-- 4mPZ9TSyiAs1A3OaXXmXHjlhFqNtPw3dt5/LeS63zVdORFnDeslzm4kiwKMjmHks
-- Ot3AaUefy+xkfvWDq0p/KayidHeV3Oi6Jafoq+7icIvg+58PROwSLD73/puXGrc2
-- ZwKSnBPtlw79f76981J7gQIGNpPc2gBm+gH/XVHPEPzBvADdNtn3YucaQoZSR48k
-- jU3dapTGiSQh1zIeauKEHDny/43MjthfL//LGbkLrsMS6/2bp86Dwdmqm4vPmetg
-- pDYBuV1TGG0x0ul22Y+qAJLeNgKXth3Z2zIgr6490FEqSA3q/s8n
-- -----END-SIGNATURE-----