-- Macro Scripts File
-- Created:  10 december 2003
-- Version:  3ds MAX 7
-- Author:   Michaelson Britt
-- VertexPaint action items
--************************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

macroScript VertexPaint_IgnoreBackfacing
category:~VERTEXPAINT_IGNOREBACKFACING_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_IGNOREBACKFACING_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_IGNOREBACKFACING_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			m.ignoreBackfacing = not m.ignoreBackfacing
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		( (classof m) == VertexPaint )	
	)

	on isChecked do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			m.ignoreBackfacing
		)
		else false
	)
) --VertexPaint_IgnoreBackfacing

macroScript VertexPaint_MaskUnselected
category:~VERTEXPAINT_MASKUNSELECTED_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_MASKUNSELECTED_TOOLTIP~		--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_MASKUNSELECTED_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			m.hideUnselSubobjs = not m.hideUnselSubobjs
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		( (classof m) == VertexPaint )	
	)

	on isChecked do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			m.hideUnselSubobjs
		)
		else false
	)
) --VertexPaint_MaskUnselected

macroScript VertexPaint_LayerOpacityUp
category:~VERTEXPAINT_LAYEROPACITYUP_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_LAYEROPACITYUP_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_LAYEROPACITYUP_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local opacity = m.layerOpacity
			if( opacity>95 ) then m.layerOpacity = 100
			else m.layerOpacity = (opacity+5)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			(m.layerOpacity<100)
		)
		else false
	)
) --VertexPaint_LayerOpacityUp

macroScript VertexPaint_LayerOpacityDown
category:~VERTEXPAINT_LAYEROPACITYDOWN_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_LAYEROPACITYDOWN_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_LAYEROPACITYDOWN_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local opacity = m.layerOpacity
			if( opacity<5 ) then m.layerOpacity = 0
			else m.layerOpacity = (opacity-5)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			(m.layerOpacity>0)
		)
		else false
	)

) --VertexPaint_LayerOpacityDown


macroScript VertexPaint_PaintChannelUp
category:~VERTEXPAINT_PAINTCHANNELUP_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_PAINTCHANNELUP_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_PAINTCHANNELUP_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local channel = m.mapChannel
			if( channel < 99 ) do m.mapChannel = (channel+1)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			(m.mapChannel < 99)
		)
		else false
	)

) --VertexPaint_PaintChannelUp

macroScript VertexPaint_PaintChannelDown
category:~VERTEXPAINT_PAINTCHANNELDOWN_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_PAINTCHANNELDOWN_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_PAINTCHANNELDOWN_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local channel = m.mapChannel
			if( channel > -2 ) do m.mapChannel = (channel-1)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			(m.mapChannel > -2)
		)
		else false
	)

) --VertexPaint_PaintChannelDown

macroScript VertexPaint_DisplayChannelUp
category:~VERTEXPAINT_DISPLAYCHANNELUP_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_DISPLAYCHANNELUP_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_DISPLAYCHANNELUP_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local channel = t.mapDisplayChannel
			if( (not t.mapDisplayChannelLock) and (channel < 99) ) do
				t.mapDisplayChannel = (channel+1)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			local t = vertexPaintTool()
			((not t.mapDisplayChannelLock) and (t.mapDisplayChannel < 99))
		)
		else false
	)

) --VertexPaint_DisplayChannelUp

macroScript VertexPaint_DisplayChannelDown
category:~VERTEXPAINT_DISPLAYCHANNELDOWN_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_DISPLAYCHANNELDOWN_TOOLTIP~ --LOC_NOTES:localize this
buttontext:~VERTEXPAINT_DISPLAYCHANNELDOWN_BUTTONTEXT~			--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local channel = t.mapDisplayChannel
			if( (not t.mapDisplayChannelLock) and (channel > -2) ) do
				t.mapDisplayChannel = (channel-1)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			local t = vertexPaintTool()
			((not t.mapDisplayChannelLock) and (t.mapDisplayChannel > -2))
		)
		else false
	)

) --VertexPaint_DisplayChannelDown

macroScript VertexPaint_LockDisplayChannel
category:~VERTEXPAINT_LOCKDISPLAYCHANNEL_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_LOCKDISPLAYCHANNEL_TOOLTIP~ --LOC_NOTES:localize this
buttontext:~VERTEXPAINT_LOCKDISPLAYCHANNEL_BUTTONTEXT~			--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()		
			t.mapDisplayChannelLock = not t.mapDisplayChannelLock
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		( (classof m) == VertexPaint )
	)

	on isChecked do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			(vertexPaintTool()).mapDisplayChannelLock
		)
		else false
	)
) --VertexPaint_LockDisplayChannel

macroScript VertexPaint_BrushSizeUp
category:~VERTEXPAINT_BRUSHSIZEUP_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_BRUSHSIZEUP_TOOLTIP~		--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_BRUSHSIZEUP_BUTTONTEXT~					--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local size = t.brushSize
			if( size>0 ) do t.brushSize *= (6.0/5.0)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		( (classof m) == VertexPaint )
	)
) --VertexPaint_BrushSizeUp

macroScript VertexPaint_BrushSizeDown
category:~VERTEXPAINT_BRUSHSIZEDOWN_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_BRUSHSIZEDOWN_TOOLTIP~		--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_BRUSHSIZEDOWN_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local size = t.brushSize
			--if( size<... ) do --FIXME: should there be an upper limit?
				t.brushSize *= (5.0/6.0)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		( (classof m) == VertexPaint )
	)
) --VertexPaint_BrushSizeDown

macroScript VertexPaint_BrushOpacityUp
category:~VERTEXPAINT_BRUSHOPACITYUP_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_BRUSHOPACITYUP_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_BRUSHOPACITYUP_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local opacity = t.brushOpacity
			if( opacity>95 ) then t.brushOpacity = 100
			else t.brushOpacity = (opacity+5)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			((vertexPaintTool()).brushOpacity<100)
		)
		else false
	)
) --VertexPaint_BrushOpacityUp

macroScript VertexPaint_BrushOpacityDown
category:~VERTEXPAINT_BRUSHOPACITYDOWN_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_BRUSHOPACITYDOWN_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_BRUSHOPACITYDOWN_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local opacity = t.brushOpacity
			if( opacity<5 ) then t.brushOpacity = 0
			else t.brushOpacity = (opacity-5)
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			((vertexPaintTool()).brushOpacity>0)
		)
		else false
	)
) --VertexPaint_BrushOpacityDown

macroScript VertexPaint_MirrorMode
category:~VERTEXPAINT_MIRRORMODE_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_MIRRORMODE_TOOLTIP~			--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_MIRRORMODE_BUTTONTEXT~					--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			t.mirrorMode = not t.mirrorMode
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		( (classof m) == VertexPaint )
	)

	on isChecked do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			(vertexPaintTool()).mirrorMode
		)
		else false
	)
) --VertexPaint_MirrorMode

macroScript VertexPaint_MirrorModeAxis
category:~VERTEXPAINT_MIRRORMODEAXIS_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_MIRRORMODEAXIS_TOOLTIP~	--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_MIRRORMODEAXIS_BUTTONTEXT~				--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()		
			local axis = t.mirrorModeAxis
			if( axis==2 ) then t.mirrorModeAxis = 0
			else t.mirrorModeAxis = (axis+1) 
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		( (classof m) == VertexPaint )
	)
) --VertexPaint_MirrorModeAxis

macroScript VertexPaint_PaintMode
category:~VERTEXPAINT_PAINTMODE_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_PAINTMODE_TOOLTIP~			--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_PAINTMODE_BUTTONTEXT~					--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local mode = t.curPaintMode
			if( (mode==0) or (mode==2) or (mode==8) ) then
				t.curPaintMode = 1
			else if( mode==1 ) do
				t.curPaintMode = 0
			
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) then
		(
			local mode = (vertexPaintTool()).curPaintMode
			true
		)
		else false
	)

	on isChecked do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			((vertexPaintTool()).curPaintMode == 1)
		)
		else false
	)
) --VertexPaint_PaintMode

macroScript VertexPaint_PickMode
category:~VERTEXPAINT_PICKMODE_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_PICKMODE_TOOLTIP~			--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_PICKMODE_BUTTONTEXT~					--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local mode = t.curPaintMode
			if( (mode==0) or (mode==1) or (mode==2) or (mode==9) ) then
				t.curPaintMode = 8
			else if( mode==8 ) do
				t.curPaintMode = 0
			
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) then
		(
			local mode = (vertexPaintTool()).curPaintMode
			true
		)
		else false
	)

	on isChecked do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			((vertexPaintTool()).curPaintMode == 8)
		)
		else false
	)
) --VertexPaint_PickMode

macroScript VertexPaint_EraseMode
category:~VERTEXPAINT_ERASEMODE_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_ERASEMODE_TOOLTIP~			--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_ERASEMODE_BUTTONTEXT~						--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local mode = t.curPaintMode
			if( (mode==0) or (mode==1) or (mode==8) or (mode==9) ) then
				t.curPaintMode = 2
			else if( mode==2 ) do
				t.curPaintMode = 0
			
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) then
		(
			local mode = (vertexPaintTool()).curPaintMode
			true
		)
		else false
	)

	on isChecked do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then (
			((vertexPaintTool()).curPaintMode == 2)
		)
		else false
	)
) --VertexPaint_EraseMode

macroScript VertexPaint_BlurBrushMode
category:~VERTEXPAINT_BLURBRUSHMODE_CATEGORY~						--LOC_NOTES:localize this
internalCategory: "VertexPaint"				--LOC_NOTES: do not localize this
tooltip:~VERTEXPAINT_BLURBRUSHMODE_TOOLTIP~			--LOC_NOTES:localize this
buttontext:~VERTEXPAINT_BLURBRUSHMODE_BUTTONTEXT~						--LOC_NOTES:localize this
(
	on execute do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) do
		(
			local t = vertexPaintTool()
			local mode = t.curPaintMode
			if( (mode==0) or (mode==1) or (mode==2) or (mode==8) ) then
				t.curPaintMode = 9
			else if( mode==2 ) do
				t.curPaintMode = 0
			
		)
	) -- on execute
	
	on isEnabled do
	(
		local m = modPanel.GetCurrentObject()
		if( (classof m) == VertexPaint ) then
		(
			local mode = (vertexPaintTool()).curPaintMode
			true
		)
		else 
		(
			false
		)
	)

	on isChecked do
	(
		local m = modPanel.GetCurrentObject()
		if ( (classof m) == VertexPaint ) then
		(
			((vertexPaintTool()).curPaintMode == 9)
		)
		else 
		(
			false
		)
	)
) --VertexPaint_BlurBrushMode


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAtllWWM6TpV+d6rvXCe6OmudwA4f35gbmh
-- iHy/bAhYH/RHp3BKaMw6o2K170/GwEUmVp0g/hKhMMjnrTsxJc/g/PQqPL9sfOTT
-- tgq6/LkAfxY3oMhHLmjfcf6Fyf+kuxOIc+wUKw64jRXLUzchTiaCj1BcgcsCc6mk
-- lQ7CIauu3+Vfo/f6HH+U59JPfxnxHoUbSXoQ1Navw7B+Ap6r3F+T+luk4QCxUoLL
-- 3ilwuTSlBswdqtDIws8v6N6FdBYscEJYq8CGmFV9Pj8qcvmKnz3yij+9qrRptHzr
-- PXpJY4yGfQ4daRt+Hy5bCfUqqcve4QAplh1CXzg341Zf6pZLoxyO
-- -----END-SIGNATURE-----