/*
  
Macro Scripts File
Created:  24 mai 2003
Version:  3ds MAX 6
Author:   PF Breton

Macro Scripts that fires some Utilities
Purpose: Hooking up some of them from the Main menu

Revision History:
   24 mai 2003, initial implementation for 3ds max 6, pfbreton

   4 dec 2003, adding File Link Manager launcher for 3ds max 6 and  File Link Extension, pfbreton

	17 dec 2003, Pierre-Felix Breton, 
		added File Link Manager Launcher
		added Substitute Manager Launcher

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products
		
	17 march 2006, Pierre-Felix Breton
		added Publish to DWF command

Macro Scripts that fires some Utilities
Purpose: Hooking up some of them from the Main menu

*/
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

MacroScript Panoramic_Exporter
ButtonText:~PANORAMIC_EXPORTER_BUTTONTEXT~
category:~PANORAMIC_EXPORTER_CATEGORY~ 
internalCategory:"Render" 
Tooltip:~PANORAMIC_EXPORTER_TOOLTIP~ 
(
	try(
            max utility mode
	    utilitypanel.openutility Panorama_Exporter
		) catch()
)


MacroScript Color_Clip_Board
ButtonText:~COLOR_CLIP_BOARD_BUTTONTEXT~
category:~COLOR_CLIP_BOARD_CATEGORY~ 
internalCategory:"Tools" 
Tooltip:~COLOR_CLIP_BOARD_TOOLTIP~ 
(
	try (utilitypanel.openutility Color_Clipboard) catch()
)

MacroScript Assign_Vertex_Colors
ButtonText:~ASSIGN_VERTEX_COLORS_BUTTONTEXT~
category:~ASSIGN_VERTEX_COLORS_CATEGORY~ 
internalCategory:"Tools" 
Tooltip:~ASSIGN_VERTEX_COLORS_TOOLTIP~ 
(
	try (utilitypanel.openutility Assign_Vertex_Colors) catch()
)


MacroScript Perspective_Match
ButtonText:~PERSPECTIVE_MATCH_BUTTONTEXT~
category:~PERSPECTIVE_MATCH_CATEGORY~ 
internalCategory:"Tools" 
Tooltip:~PERSPECTIVE_MATCH_TOOLTIP~ 
(
	try (utilitypanel.openutility Perspective_Match) catch()
)


MacroScript Resource_Collector
ButtonText:~RESOURCE_COLLECTOR_BUTTONTEXT~
category:~RESOURCE_COLLECTOR_CATEGORY~ 
internalCategory:"File" 
Tooltip:~RESOURCE_COLLECTOR_TOOLTIP~ 
(
	try(
		max utility mode
		utilitypanel.openutility Resource_Collector
	) catch()
)

MacroScript Map_Path_Editor
ButtonText:~MAP_PATH_EDITOR_BUTTONTEXT~
category:~MAP_PATH_EDITOR_CATEGORY~ 
internalCategory:"File" 
Tooltip:~MAP_PATH_EDITOR_TOOLTIP~ 
(
	try(
		max utility mode
		utilitypanel.openutility Bitmap_Photometric_Paths
	) catch()
)


MacroScript Channel_Info
ButtonText:~CHANNEL_INFO_BUTTONTEXT~
category:~CHANNEL_INFO_CATEGORY~ 
internalCategory:"Tools" 
Tooltip:~CHANNEL_INFO_TOOLTIP~ 
(
	on execute do	(
		try(
			channelInfo.Dialog ()
		) catch()
	)
	on closeDialogs do (
		try (
			channelInfo.closeDialog()
		) catch ()
	)
	on isChecked return (
		try (
			channelInfo.IsChecked ()
		) catch ( false )
	)
)

MacroScript Launch_VMS
ButtonText:~LAUNCH_VMS_BUTTONTEXT~
Category:~LAUNCH_VMS_CATEGORY~ 
internalCategory:"MAX Script" 
Tooltip:~LAUNCH_VMS_TOOLTIP~ 
(
 vms = visualMS.CreateForm()
 vms.Open()
)

MacroScript Publish_To_DWF
ButtonText:~PUBLISH_TO_DWF_BUTTONTEXT~
category:~PUBLISH_TO_DWF_CATEGORY~ 
internalCategory:"File" 
Tooltip:~PUBLISH_TO_DWF_TOOLTIP~ 
(
		--------------------------------
		--Browse for file dialog
		--------------------------------
		 
		local strMyFile= ""
		strMyFile = getSaveFileName caption:~GETSAVEFILENAME_CAPTION~ \ --LOC NOtes: Localize this
							filename:((getdir #export) + "\\" + (getFilenameFile maxfilename) + ".dwf") \
							types:~DESIGN_WEB_FORMAT_TYPES_CAPTION~
		
		-- user canceled?			
		if (strMyFile!= undefined) then  					
		(
			exportFile strMyFile using:DWF_Exporter	
		)--end if
	
)--en publish to DWF


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBHX/xzI7S5B23Uc1N0hhH+Ue++mYkHQ5ye
-- 8+/qNGJeoefMFnrpY47DcvPdwh5eHQ8oy+/irFRL+UldrUqbSvlL59V0BzcEbbbB
-- nBGaA5/F1ZdhthsziaqNK4DiC0MbKp8LGttVauPzYXH5w7hQEQlj0XpCIb/fowqz
-- 7oP2F452jUsXUE+/ABF6wjBUOEAmz6EuwdwwYzmajdLy9nBC+735muEgwDB3otMl
-- 8L0QnETY1LmAZ+K1FHAf4L7j2NimEMSK9vl/N6RRs1JL0vEXxCDPkF9uPe4OxZ2p
-- 33uRxXmCkEsaIvI7iF+KJ6o2Hcrc1rVJ3vRNlwfgEdpW42IQSZ5B
-- -----END-SIGNATURE-----