/*
Macro_scripts for UVW Unwrap

Version: 3dsmax 9



Revision History:
		
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products
		moved functions and dialog definition into the /stdplug/stdscripts/modifier_uvwunwrap_dialog.ms
	
	28th august 2006, Pierre-Felix Breton
		minor updates to actions

*/




macroScript OpenUnwrapUI
	category:~OPENUNWRAPUI_CATEGORY~           
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~OPENUNWRAPUI_TOOLTIP~		
	silentErrors:TRUE

	
(

  unwrapModPKW = modpanel.getcurrentobject()
  xPKW =  unwrapModPKW.GetWindowX()
  yPKW =  unwrapModPKW.GetWindowY()
  hPKW =  unwrapModPKW.GetWindowH()
  if (hPKW==0) then
  	(
	yPKW = -10
	)  
  pPKW = Point2 xPKW (yPKW+hPKW)
  CreateDialog UnwrapUIDialog pos:pPKW style:#(#style_border)
  
  if (hPKW==0) then
  	(
	unwrapUIdialog.height = 0 
	)
  
)


macroScript MoveUnwrapUI
	category:~MOVEUNWRAPUI_CATEGORY~           
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~MOVEUNWRAPUI_TOOLTIP~	
	silentErrors:TRUE

	
(
  unwrapModPKW = modpanel.getcurrentobject()
  xPKW = unwrapModPKW .GetWindowX()
  yPKW = unwrapModPKW .GetWindowY()
  hPKW = unwrapModPKW .GetWindowH()
  
  if (hPKW==0) then  
  	(
	yPKW = -10
	)

  pPKW = Point2 xPKW (yPKW+hPKW)
  SetDialogPos UnwrapUIDialog pPKW
    
  if (hPKW==0) then
  	(
	unwrapUIdialog.height = 0 
	)
   else
    (
	if 	(UnwrapUIDialog.dash_options.state==TRUE) then
		(
		if (unwrapUIdialog.height != 163 ) then
			unwrapUIdialog.height = 163  
		)
	else 
		(
		if (unwrapUIdialog.height != 78 ) then
			unwrapUIdialog.height = 78  
		)
	unwrapUIdialog.UpdateUI()
	)
)


macroScript CloseUnwrapUI
	category:~CLOSEUNWRAPUI_CATEGORY~           
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~CLOSEUNWRAPUI_TOOLTIP~
	silentErrors:TRUE

	
(
  DestroyDialog UnwrapUIDialog
)


-----------------------------------------------------

macroScript UVWUnwrap_Stitch
	category:~UVWUNWRAP_STITCH_CATEGORY~
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~UVWUNWRAP_STITCH_TOOLTIP~
	buttontext:~UVWUNWRAP_STITCH_BUTTONTEXT~
(
	on execute do actionMan.executeAction 2077580866 "40043"  -- All Commands: Stitch
	on altExecute type do actionMan.executeAction 2077580866 "40044"  -- All Commands: Stitch Dialog	
)

macroScript UVWUnwrap_Sketch
	category:~UVWUNWRAP_SKETCH_CATEGORY~
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~UVWUNWRAP_SKETCH_TOOLTIP~
	buttontext:~UVWUNWRAP_SKETCH_BUTTONTEXT~
(
	on execute do actionMan.executeAction 2077580866 "40114"  -- All Commands: Sketch
	on altExecute type do actionMan.executeAction 2077580866 "40112"  -- All Commands: Sketch Dialog
)

macroScript UVWUnwrap_Pack
	category:~UVWUNWRAP_PACK_CATEGORY~
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~UVWUNWRAP_PACK_TOOLTIP~
	buttontext:~UVWUNWRAP_PACK_BUTTONTEXT~
(
	on execute do actionMan.executeAction 2077580866 "40074"  -- All Commands: Pack
	on altExecute type do actionMan.executeAction 2077580866 "40075"  -- All Commands: Pack Dialog
)

macroScript UVWUnwrap_Relax
	category:~UVWUNWRAP_RELAX_CATEGORY~
	internalCategory: "UVW Unwrap"  --do not localize
	toolTip:~UVWUNWRAP_RELAX_TOOLTIP~
	buttontext:~UVWUNWRAP_RELAX_BUTTONTEXT~
(
	on execute do actionMan.executeAction 2077580866 "40135"  -- All Commands: Relax
	on altExecute type do actionMan.executeAction 2077580866 "40136"  -- All Commands: Relax Dialog
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAeFVDYKtxcz10EQgxaxVhBg4pjnLCKr+O1
-- Pgnb4z1VbVBU2gHzgDDt2IRLen+fYUF0xpkYDX2Al1/kmzBqnXm2iWUW2qt/XRtR
-- TC6UTpiNOtfbVfPRbdo0yK8iTnlQLEMsHtR6uzkXqxuJUpIxh9ORJGoW8XQRbA/f
-- o4vdROQKP85mLffKZQwAOrOPn/xqh91PAmJSYVCWhZcAgk7ZHWAStxKRiWpx1Cn2
-- 3cTFzinhya2wPcNekpl4i/vIHXQVIzq7yZTCUGXX4fuvo44lzaKmJfEgHK4zC73f
-- RIT73xl1+A6u8+u/bSVXmFj4pxi7Xr86toVbtmx3Lxl3vHvFVL0w
-- -----END-SIGNATURE-----