/*
UI Scheme Macros

Revision History:

Oct 25 2001; Max 4 implementation

August 14 2003; Pierre-Felix Breton
	Max 6 modifications/refactoring of functions
	Added UI/Defaults switcher Macro
	Added localization comments and cleaned code comments


August 19 2003;Pierre-Felix Breton
	removed hardcoded refs to the 3dsmax.ini file
	
	
December 12 2003; Pierre-Felix Breton
	added product switcher: this macro file can be shared with all Discreet products
		
April 2006;  Chris Johnson
	removed activeX controls, and added .NET controls

October 2011: Joey Gaspe
	Adjusted to be Language Pack compliant
	
Nov.30 2012: Chengqing Zhou
	Added ui schemes and default settings from plug-ins installed via Exchange Store.

--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
*/

---------------------------------------------------------------------------------------------------
/*
CUI and Defaults switcher

Provide a choice to select the market specific toolbar and defaults settings.

Save this choice for subsequent launches by:
	-changing the 3dsmax.ini file to point to the desired defaults settings folder
	-saving a MaxStartUI.cui file and loading the desired CUI file set (this is identical to the Load Custom UI scheme command in MAX)


Dependencies:

--hardcoded dependency on the following folder/files names (all prefixed by the localized file directory):

	<langdir>\defaults\MAX\
	<langdir>\defaults\DesignVIZ\
	<langdir>\UI\DefaultUI.* (*.ui, *.cui, *.mnu, *.clr) etc
	<langdir>\UI\MaxstartUI.CUI\
	<langdir>\html\cui.defaults.switcher\*.html


-functions defined in the [maxinstall]/stdplugs/scripts/customUIschemes_functions.ms

*/
---------------------------------------------------------------------------------------------------


MacroScript CustomUISchemeDefaultsSwitcher
category:~CUSTOMUISCHEMEDEFAULTSSWITCHER_CATEGORY~ 
internalCategory:"Customize User Interface" 
tooltip:~CUSTOMUISCHEMEDEFAULTSSWITCHER_TOOLTIP~ 
ButtonText:~CUSTOMUISCHEMEDEFAULTSSWITCHER_BUTTONTEXT~
SilentErrors:(Debug != True)
(


	--decalres variables
	local rlt_main
	local rlt_size
	local axMargin
	local ctrlMargin
	local topUIMargin
	local botUIMargin
	local btnWidth
	local btnHeight
	local strWebDocPath
	local uiSchemePaths = #()
	local defaultSettingPaths = #()
-------------------------------------------------------------------------
--  getCUISchemesList 

-- function that parses the [maxinstall]\ui folder 
-- to obtain the list of ui schemes (defined by the *.ui extension)
-- returns an array containing the list of UI schemes
------------------------------------------------------------------------------
function getCUISchemesList = 
(
	uiSchemePaths = #()
	local arStrUISchemesFnames = #()
	local i, j
	arStrUISchemesFnames = getFiles (pathconfig.appendPath (getdir #UI) "*.ui")

	j = 0
	for i in arStrUISchemesFnames do
	(
		j = j + 1
		local strFname  = getFileNameFile i
		
		arStrUISchemesFnames[j] = strFname 
		uiSchemePaths[j] = getFileNamePath i
	)
	
	-- now check the ui schemes installed via Exchange Store.
	local customUISchemePath
	local customPathCount = ExchangeStorePackageManager.GetUISchemeCount()
	for pathIndex = 1 to customPathCount do
	(
		j = j + 1
		customUISchemePath = ExchangeStorePackageManager.GetUISchemeFullPath(pathIndex)
		arStrUISchemesFnames[j] = getFileNameFile customUISchemePath
		uiSchemePaths[j] = getFileNamePath customUISchemePath
	)
	
	--re arrange the list so the DefaultUIs we ship are always on top of the list (first in the array), to make this easier to non-educated users, as per design decision
	--if they disappear from the builds in next releases or renamed, theses lines of code will simply do nothing
	local intArIndex = 0
	local intOrder = 1
	intArIndex  = findItem arStrUISchemesFnames "DefaultUI" --LOC_NOTES: do not localize this
	if intArIndex  != 0 do 
	(
		deleteItem arStrUISchemesFnames intArIndex
		customUISchemePath = uiSchemePaths[intArIndex]
		deleteItem uiSchemePaths intArIndex
		insertItem "DefaultUI" arStrUISchemesFnames intOrder --LOC_NOTES: do not localize this
		insertItem customUISchemePath uiSchemePaths intOrder
		intOrder = intOrder + 1
	)

	intArIndex  = findItem arStrUISchemesFnames "ModularToolbarsUI" --LOC_NOTES: do not localize this
	if intArIndex  != 0 do 
	(
		deleteItem arStrUISchemesFnames intArIndex
		customUISchemePath = uiSchemePaths[intArIndex]
		deleteItem uiSchemePaths intArIndex		
		insertItem "ModularToolbarsUI" arStrUISchemesFnames intOrder --LOC_NOTES: do not localize this
		insertItem customUISchemePath uiSchemePaths intOrder
		intOrder = intOrder + 1
	)	
	
	intArIndex  = findItem arStrUISchemesFnames "ame-light" --LOC_NOTES: do not localize this
	if intArIndex  != 0 do 
	(
		deleteItem arStrUISchemesFnames intArIndex  
		customUISchemePath = uiSchemePaths[intArIndex]
		deleteItem uiSchemePaths intArIndex
		insertItem "ame-light" arStrUISchemesFnames intOrder --LOC_NOTES: do not localize this
		insertItem customUISchemePath uiSchemePaths intOrder
		intOrder = intOrder + 1
	)

	intArIndex  = findItem arStrUISchemesFnames "ame-dark" --LOC_NOTES: do not localize this
	if intArIndex  != 0 do 
	(
		deleteItem arStrUISchemesFnames intArIndex  
		customUISchemePath = uiSchemePaths[intArIndex]
		deleteItem uiSchemePaths intArIndex
		insertItem "ame-dark" arStrUISchemesFnames intOrder --LOC_NOTES: do not localize this
		insertItem customUISchemePath uiSchemePaths intOrder
		intOrder = intOrder + 1
	)		
	arStrUISchemesFnames --returns the array of string
	
)--end function

------------------------------------------------------------------------------------------
--IsValidDefaultDirectory

-- Check if the input directory has the necessary default setting components.
-- A default directory should contain "FactoryDefaults" inside it.

-- return false if the "FactoryDefaults" doesn't exist, otherwise return true.

-----------------------------------------------------------------------------------------
function IsValidDefaultDirectory inputDir =
(
	local factoryPath = pathconfig.AppendPath inputDir "\\FactoryDefaults"
	factoryPath = pathconfig.normalizePath factoryPath

	return (doesDirectoryExist factoryPath)
)
-------------------------------------------------------------------------------------------
--  getDefaultsList 

-- function that parses the [maxinstall]\defaults folder 
-- to obtain the list of defaults schemes (defined by foldersnames)

-- returns an array containing the of the Defaults names
-------------------------------------------------------------------------------------------
function getDefaultsList = 
(
	defaultSettingPaths = #()
	local arStrDefaultsFoldNames = #()
	local i, j
	local bValid
	local defaultsPath = pathconfig.AppendPath (getdir #maxroot) (Sysinfo.getMaxLanguage())[5]  
	defaultsPath = pathconfig.AppendPath defaultsPath "defaults\\*"
	
	arStrDefaultsFoldNames = getDirectories defaultsPath --LOC_NOTES: do not localize this

	--removes the path info from the folder names
	j = 0
	for i in arStrDefaultsFoldNames do
	(
		bValid = IsValidDefaultDirectory i
		if (bValid == true) then
		(
			j = j + 1
			defaultSettingPaths[j] = i
			i = pathconfig.stripPathToLeaf i
			arStrDefaultsFoldNames[j] = substituteString  i "\\" "" --we don't want "\\" displayed in the list box.
		)
	)
	
	-- now check the defaults installed via Exchange Store.
	local customDefaultPath
	local customPathCount = ExchangeStorePackageManager.GetDefaultSettingCount()
	for pathIndex = 1 to customPathCount do
	(
		customDefaultPath = ExchangeStorePackageManager.GetDefaultSettingFullPath(pathIndex)
		bValid = IsValidDefaultDirectory customDefaultPath
		if (bValid == true) then
		(
			j = j + 1
			defaultSettingPaths[j] = customDefaultPath
			customDefaultPath = pathconfig.stripPathToLeaf customDefaultPath
			arStrDefaultsFoldNames[j] = substituteString  customDefaultPath "\\" ""
		)
	)
	
	--re arrange the list so the Defaults we ship are always on top of the list (first in the array), to make this easier to non-educated users, as per design decision
	--if they disappear from the builds in next releases or renamed, theses lines of code will simply do nothing
	local intArIndex = 0
	local intOrder=1
	intArIndex  = findItem arStrDefaultsFoldNames "MAX" --LOC_NOTES: do not localize this

	if intArIndex  != 0 do 
	(
		deleteItem arStrDefaultsFoldNames intArIndex  
		customDefaultPath = defaultSettingPaths[intArIndex]
		deleteItem defaultSettingPaths intArIndex
		insertItem "Max" arStrDefaultsFoldNames intOrder --LOC_NOTES: do not localize this
		insertItem customDefaultPath defaultSettingPaths intOrder
		intOrder = intOrder + 1
	)
	

	intArIndex  = findItem arStrDefaultsFoldNames "DesignVIZ" --LOC_NOTES: do not localize this

	if intArIndex  != 0 do 
	(
		deleteItem arStrDefaultsFoldNames intArIndex  
		customDefaultPath = defaultSettingPaths[intArIndex]
		deleteItem defaultSettingPaths intArIndex
		insertItem "DesignVIZ" arStrDefaultsFoldNames intOrder --LOC_NOTES: do not localize this
		insertItem customDefaultPath defaultSettingPaths intOrder
		intOrder = intOrder + 1
	)
	
	
	arStrDefaultsFoldNames
	
)--end function

			
on execute do
(

	--init variables
	
	rlt_size       = point2 700 650
     axMargin       = 30
     ctrlMargin     = 30
     topUIMargin    = 110
     botUIMargin    = 50
     btnWidth       = 100
     btnHeight      = 25
     strWebDocPath  = (getdir #maxroot + (sysinfo.GetMaxLanguage())[5] + "\\html\\cui.defaults.switcher\\") -- LOC_Notes: do not localize this
	
	
	---------------------------------------------------------------------------------------------------------------
	-- Rollout UI
	---------------------------------------------------------------------------------------------------------------
	
	rollout rlt_main ~RLT_MAIN_CAPTION~ -- LOC_Notes: localize this
	(
		
		--ui section
		listbox lstBoxCUI ~LSTBOXCUI_CAPTION~ items:#() height:5 \ -- LOC_Notes: localize this
			pos:[(rlt_size.x/2 + ctrlMargin/2), ctrlMargin/2] \	
			width:(rlt_size.x/2 - ctrlMargin) 
		
		listbox lstBoxDefaults ~LSTBOXDEFAULTS_CAPTION~ items:#() height:5 \ -- LOC_Notes: localize this
			pos:[ctrlMargin/2, ctrlMargin/2] \
			width:(rlt_size.x/2 - ctrlMargin)
	
		dotNetControl wb "WebBrowser"  \ --LOC_Notes: do not localize this
			pos:[(axMargin/2),(axMargin/2 + topUIMargin)] \
			width:(rlt_size.x - axMargin) \
			height:(rlt_size.y-axMargin-topUIMargin-botUIMargin) 
	
		--ok cancel help buttons
		button btnCancelDialog ~BTNCANCELDIALOG_CAPTION~ width:btnWidth height:btnHeight \ -- LOC_Notes: localize this
			pos:[(rlt_size.x-ctrlMargin/2-btnWidth), (rlt_size.y-botUIMargin/2-btnHeight/2)] \
			enabled:true
	
		button btnOkDialog ~BTNOKDIALOG_CAPTION~ width:btnWidth height:btnHeight \ -- LOC_Notes: localize this
			pos:[(rlt_size.x-ctrlMargin-2*btnWidth), (rlt_size.y-botUIMargin/2-btnHeight/2)] \
			enabled:true
			
		button btnHelpDialog "<<" width:(btnWidth/2) height:btnHeight \ -- LOC_Notes: localize this
			pos:[(ctrlMargin/2), (rlt_size.y-botUIMargin/2-btnHeight/2)] \
			enabled:false
			
		--//////////////////////////////////////////////////////////////////////////////
	    --Rollout Events
	    --//////////////////////////////////////////////////////////////////////////////
	
		on rlt_main open do
		( 
			--sets the webpage welcome html file
			local startPage = (strWebDocPath + "index.html")
			if (doesFileExist startPage) == true then 
			(
				wb.navigate startPage --LOC_Notes: do not localize this
			)
			else
			(
				messagebox (~MSGBOX_FILE_DOES_NOT_EXIST_CAPTION~ + startPage)	
			)
			
			--populates the listboxes
			lstBoxCUI.items = getCUISchemesList()
			lstBoxDefaults.items = getDefaultsList()

			-- selects the first item in the CUI scheme list
			lstBoxCUI.selection = 1
			
			--selects the current set of defaults in the Defaults list
			--compares the list of items with the current defaults and highlight the currently active defaults set
			
				--extract the name of the defaults set from the defaults folder path
				local strCurrentDefaults
				local arStrSplitFoldNames = #() 
				arStrSplitFoldNames  = filterstring (getdir #defaults) "\\" 
				strCurrentDefaults = (arStrSplitFoldNames[arStrSplitFoldNames.count])
				
				--compares with the list
				local i
				local index = 0
				local j = 0
				for i in lstBoxDefaults.items do
				(
					j = j + 1
					if (matchpattern strCurrentDefaults  pattern:i ignorecase:true) do index = j
				)	
				lstBoxDefaults.selection = index
				
		)
		
		on rlt_main resized size do
		(
			--resizes the list box controls
			lstBoxDefaults.pos = [ctrlMargin/2, ctrlMargin/2 + 15]
			lstBoxCUI.pos = [(size.x/2 + ctrlMargin/2), ctrlMargin/2 + 15]
			
			lstBoxCUI.width = (size.x/2-ctrlMargin)
			lstBoxDefaults.width = (size.x/2-ctrlMargin)
			
			-- resize the browser control
			wb.width = (size.x - axMargin)
			wb.height = (size.y-axMargin-topUIMargin-botUIMargin)
			
			--repositions the Set/Cancel buttons
			btnCancelDialog.pos = [(size.x-ctrlMargin/2-btnWidth), (size.y-botUIMargin/2-btnHeight/2)]
			btnOkDialog.pos = [(size.x-ctrlMargin-2*btnWidth), (size.y-botUIMargin/2-btnHeight/2)]
			btnHelpDialog.pos = [ctrlMargin/2, (size.y-botUIMargin/2-btnHeight/2)]
			
		)
		
		on lstBoxDefaults selected item do
		(
			--set the webpage browser to show the corresponding html file for better explanations
			local strFldName = ""
			strFldName = (strWebDocPath + "defaults." + lstBoxDefaults.selected +".html") --LOC_Notes: do not localize this
			
			if (doesFileExist strFldName) == true
			then wb.navigate strFldName  --LOC_Notes: do not localize this
			else
				(
					if (doesFileExist (strWebDocPath + "defaults.unknown.entry.html") == true) do wb.navigate (strWebDocPath + "defaults.unknown.entry.html") --LOC_Notes: do not localize this
				)
			
			-- enables the set button only if the 2 list boxes are set to a given selection
			if (lstBoxCUI.selection != 0 and lstBoxDefaults.selection != 0) do btnHelpDialog.enabled = true
		)
		
		
		on lstBoxCUI selected item do
		(
			--set the webpage browser to show the corresponding html file for better explanations
			local strFldName = ""
			strFldName = (strWebDocPath + "ui." + lstBoxCUI.selected +".html") --LOC_Notes: do not localize this
			
			if (doesFileExist strFldName) == true
			then wb.navigate strFldName  --LOC_Notes: do not localize this
			else
				(
					if (doesFileExist (strWebDocPath + "ui.unknown.entry.html") == true) do wb.navigate (strWebDocPath + "ui.unknown.entry.html") --LOC_Notes: do not localize this
				)
			
			-- enables the set button only if the 2 list boxes are set to a given selection
			if (lstBoxCUI.selection != 0 and lstBoxDefaults.selection != 0) do btnHelpDialog.enabled = true
		)
		
		
		on btnCancelDialog pressed do destroyDialog(rlt_main)
		
		on btnHelpDialog pressed do 
		(
			--sets the webpage welcome html file
			if (doesFileExist (strWebDocPath + "index.html")) == true do wb.navigate (strWebDocPath + "index.html") --LOC_Notes: do not localize this
		)
		
		on btnOkDialog pressed do 
		( 		
			--loads the selected options as UI	
			if lstBoxCUI.selected != undefined do
			(
				local selectedCui = lstBoxCUI.selected + ".ui"
				local uiPath = uiSchemePaths[lstBoxCUI.selection]
				loadCUIScheme (pathconfig.appendPath uiPath selectedCui)
			)

			--loads selected options as Market defaults
			if lstBoxDefaults.selected != undefined do 
			(	
				local defaultsPath = defaultSettingPaths[lstBoxDefaults.selection]
				setIniSetting (GetMAXIniFile()) "Directories" "Defaults" defaultsPath --LOC_NOTES: do not localize this
				messagebox ~MSGBOX_DEF_SETTINGS_EFFECT_ON_RESTART_3DSMAX~ title:~MSGBOX_DEF_SETTINGS_EFFECT_ON_RESTART_3DSMAX_TITLE~ -- LOC_Notes: localize this
			)
	
			--finishes the job
			destroyDialog(rlt_main)
		)
			
	)--end rollout
	
	
	createDialog rlt_main rlt_size.x rlt_size.y \
					modal:false style:#(#style_resizing, #style_titlebar,  #style_border, #style_sysmenu)


)--end on execute

)--end macro



---------------------------------------------------------------------------------------------------
/*
LoadScheme

Allows users to load UI schemes and icon directories. 
The current design forces all UI files to be in the [maxinstall]/ui/ directory

This macro is dependant on:

-functions defined in the [maxinstall]/stdplugs/scripts/customUIschemes_functions.ms

*/
---------------------------------------------------------------------------------------------------


MacroScript LoadScheme 
	category:~LOADSCHEME_CATEGORY~ 
	internalCategory:"Customize User Interface" 
	tooltip:~LOADSCHEME_TOOLTIP~ 
	ButtonText:~LOADSCHEME_BUTTONTEXT~
	SilentErrors:(Debug != True)
	(
		
		on execute do
		(			
			-- Default Directory and Filename "DefaultUI"
			local DirectorySeed = pathconfig.AppendPath (getdir #UI) "DefaultUI.ui" --LOC_Notes: do not localize this
			
			-- Disable Esacpe Key
			local escapeBackup = EscapeEnable
			EscapeEnable = false
			
			--loads the UI scheme (function defined in the [maxinstall]/stdplugs/scripts/customUIschemes_functions.ms)			
			UIScheme_Filename = getOpenFilename filename:DirectorySeed caption:~LOADSCHEME_CAPTION~ \
				types:~SCHEME_FILE_TYPE_CAPTION~ --LOC_Notes: localize this
				
			If UIScheme_Filename != undefined do
			(	
				loadCUIScheme UIScheme_Filename
			
				-- Restore ESC Key
				EscapeEnabled = escapeBackup
			
				messagebox ~MSGBOX_UI_SCHEME_RESTART_3DSMAX~ title:~MSGBOX_UI_SCHEME_RESTART_3DSMAX_TITLE~ -- LOC_Notes: localize this
			)

			-- Restore ESC Key
			EscapeEnabled = escapeBackup

		)-- end execute

	)--end MacroScript LoadScheme





---------------------------------------------------------------------------------------------------
/*
SaveScheme
Allows users to save UI schemes and icon directories. 

The current design forces all UI files to be in the [maxinstall]/ui/ directory

This macro is dependant on:

-functions defined in the [maxinstall]/stdplugs/scripts/customUIschemes_functions.ms
*/
---------------------------------------------------------------------------------------------------



MacroScript SaveScheme
category:~SAVESCHEME_CATEGORY~ 
internalCategory:"Customize User Interface" 
tooltip:~SAVESCHEME_TOOLTIP~ 
ButtonText:~SAVESCHEME_BUTTONTEXT~
SilentErrors:(Debug != True)
(

local UIScheme_Directories_Names, UIScheme_Directories_Name, UIScheme_Bitmap_Preview, UIScheme_Filename
local defaultIcons
	
on execute do
(

	
		
		-------------------------------------
		-- Get filename from Save dialog
		-- known limitation:  there is no way to know if a given *.ui file is active or not
		-- because a UI scheme is split in multiple files, you can't tell if they are all loaded
		-- or not.  Our best luck is to assume that yes and rely on the current CUI file
		-------------------------------------
		local strfpath = cui.getConfigFile()
		local DirectorySeed =  getfilenamepath(strfpath) + getfilenamefile(strfpath) + ".ui"

		-------------------------------------
		-- are we using dark or light icons?
		-------------------------------------
		local iconsFolder = colorman.getIconFolder()
		local iconsFolderLeaf = pathconfig.stripPathToLeaf  iconsFolder
		local isDark = (stricmp iconsFolderLeaf "ICONSDARK")
		defaultIcons = 1
				
		if ( 0 == isDark ) do defaultIcons = 2
		
		-------------------------------------
		-- Set types of files to load
		-------------------------------------
		
		UIScheme_Filename = getSaveFilename filename:DirectorySeed \
			caption:~SAVESCHEME_CAPTION~ \ --LOC_Notes: localize this
			types:~INTERFACE_SCHEME_TYPES_CAPTION~ --LOC_Notes: localize this

		If UIScheme_Filename != undefined do
		(
			rollout SaveDialog ~SAVEDIALOG_CAPTION~ width:340 height:224 --LOC_Notes: localize this
			(
				local UIScheme_Icon_Setup, SaveSchemeName, UIScheme_IconRoll 
				button go ~BUTTON_GO_OK_CAPTION~ pos:[8,192] width:64 height:24 --LOC_Notes: localize this
				
				button BtnCancel ~BTNCANCEL_CAPTION~ pos:[268,192] width:64 height:24 --LOC_Notes: localize this
				checkbox ChkCUI ~CHKCUI_CAPTION~ pos:~CHKCUI_POSITION~ width:~CHKCUI_WIDTH~ height:16 checked:true --LOC_Notes: localize this
				button AllOptions ~ALLOPTIONS_CAPTION~ pos:~ALLOPTIONS_POSITION~ width:~ALLOPTIONS_WIDTH~ height:16 --LOC_Notes: localize this
				button BtnNone ~BTNNONE_CAPTION~ pos:~BTNNONE_POSITION~ width:~BTNNONE_WIDTH~ height:16 --LOC_Notes: localize this
				checkbox ChkKBD ~CHKKBD_CAPTION~ pos:~CHKKBD_POSITION~ width:~CHKKBD_WIDTH~ height:16 checked:true --LOC_Notes: localize this
				checkbox ChkMNU ~CHKMNU_CAPTION~ pos:~CHKMNU_POSITION~ width:144 height:16 checked:true --LOC_Notes: localize this
				checkbox ChkQOP ~CHKQOP_CAPTION~ pos:~CHKQOP_POSITION~ width:~CHKQOP_WIDTH~ height:16 checked:true --LOC_Notes: localize this
				checkbox ChkCLR ~CHKCLR_CAPTION~ pos:~CHKCLR_POSITION~ width:~CHKCLR_WIDTH~ height:16 checked:true --LOC_Notes: localize this
				
				radioButtons RadioIcon "" pos:[112,144] width:119 height:32 labels:#(~RADIOICON_CLASSIC~, ~RADIOICON_2D_BLACK_WHITE~) columns:1 default:defaultIcons --LOC_Notes: localize this
				label lbl3 ~LBL3_CAPTION~ pos:~LBL3_POSITION~ width:~LBL3_WIDTH~ height:16 --LOC_Notes: localize this
				
				
				on go pressed do
				(
					SaveSchemeName = GetFileNameFile UIScheme_Filename	
					SaveSchemePath = GetFileNamePath UIScheme_Filename
			
					if ChkMNU.state == true do MenuMan.saveMenuFile 		(SaveSchemePath + SaveSchemeName +".mnux")
					if ChkCLR.state == true do ColorMan.saveColorFIle 		(SaveSchemePath + SaveSchemeName +".clrx" )
					if ChkKBD.state == true do ActionMan.saveKeyboardFile 	(SaveSchemePath + SaveSchemeName +".kbdx" )
					if ChkCUI.state == true do Cui.saveConfigAs 			(SaveSchemePath + SaveSchemeName +".cuix")
					
					local Bpr = BrushPresetMgr
					if Bpr != undefined and
					   ChkCUI.state == true do Bpr.savePresetFile			(SaveSchemePath + SaveSchemeName +".bprx")
						
						----------------------------------------------------------------------------	
						-- Save CUI file as startup so your changes are loaded when restarting MAX
						----------------------------------------------------------------------------	
				
					if ChkCUI.state == true do cui.saveConfigAs ("MaxStartUI.cui") --LOC_Notes: do not localize this
						
						----------------------------------------------------------------------------	
						-- Saves Quad Colors into a MAXScript file in your UI directory with .qop extention
						----------------------------------------------------------------------------	
						
					if ChkQOP.state == true do SaveQuadClr SaveSchemePath SaveSchemeName ".qop" (UIScheme_Filename + " Scheme") --LOC_Notes: do not localize this
					
						----------------------------------------------------------------------------	
						-- Save a dat file that points to the right icon directory
						----------------------------------------------------------------------------	
	
					local strUIFilePath = (SaveSchemePath + SaveSchemeName + ".ui")
					local fAttrib = false
					if doesFileExist (strUIFilePath) do fAttrib = getFileAttribute strUIFilePath #readonly
					
					if RadioIcon.state == 1 do
						(
						if fAttrib == false 
						then 
						(
							UIScheme_Icon_Setup = CreateFile (strUIFilePath)
							Format "Icons" to:UIScheme_Icon_Setup --LOC_Notes: do not localize this
							Close UIScheme_Icon_Setup
						)
						else
						(
							local str = ~STR_ERROR_SAVING_SCHEME~ + strUIFilePath + ~STR_ERROR_SAVING_SCHEME_FOLDER_NOT_SAVED~ --LOC_NOTES: localize this
							messagebox str title:~MSGBOX_STR_ERROR_CAPTION~ --LOC_NOTES: localize this
						)-- end if UIScheme_Icon_Setup != undefined 
					)
					if RadioIcon.state == 2 do
					(
						if fAttrib == false 
						then 
						(
							UIScheme_Icon_Setup = CreateFile (strUIFilePath)
							Format "IconsDark" to:UIScheme_Icon_Setup --LOC_Notes: do not localize this
							Close UIScheme_Icon_Setup
						)
						else
						(
							local str = ~ERROR_SAVING~ + strUIFilePath +  ~FILE_MAY_BE_READ_ONLY_FOLDER_NOT_SAVED~ --LOC_NOTES: localize this
							messagebox str title:~MSGBOX_STR_ERROR~ --LOC_NOTES: localize this
						)
					)
					DestroyDialog SaveDialog
					
				)--end on go pressed
				
				on BtnCancel pressed do	DestroyDialog SaveDialog 

				on AllOptions pressed do
				(
						chkCUI.checked = true
						chkKBD.checked = true
						chkMNU.checked = true
						chkQOP.checked = true
						chkCLR.checked = true
				)--end on AllOptions pressed
				
				on BtnNone pressed do
				(
						chkCUI.checked = false
						chkKBD.checked = false
						chkMNU.checked = false
						chkQOP.checked = false
						chkCLR.checked = false
				)--end on BtnNone pressed
			)--end rollout
			
			CreateDialog SaveDialog 	
		
		)--If UIScheme_Filename != undefined
		
)--end on execute
)--end macro save scheme
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBNle2aHkgLPC0W7rnin5SGCMkev0MEyTxH
-- fUEPq43yK2nWyeZodoV+Q6ZvoZ+Zbq31fIXATyPKSCr1h3sNh4koM0eHkMbFRCX2
-- Wjh1PoLemANcmHC7MSAp1/dQWM3TYFq4hMVEjUCg+wcIOQpImjlOZnNTuynVVSE4
-- iMqzKUwokJTqVrtozGiYpu6I0l2wfLjicQm0pGpFwBIP6LjMCt4qscH0hbw+PhXD
-- XUpXI9siFe0lj5aUQN+/fmMSTBCMzTLGo1tCeQ2TwzWsBR2RRyWtYWi9ajJU/vtL
-- A+qcisOsM8Re4ZdaF8hb1ugbdoDbwLtdWhVFs1rIogxULqb0A7Ue
-- -----END-SIGNATURE-----