-- Macro Scripts File
--
-- Macro Scripts for Trajectories maxscript commands
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

MacroScript TrajTickFramesUnselected
	ButtonText:~TRAJ_TICKFRAMESUNSEL_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_TICKFRAMESUNSEL_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.unselTrajectoryDrawFrameTicks
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.unselTrajectoryDrawFrameTicks = NOT maxOps.unselTrajectoryDrawFrameTicks
	)
)

MacroScript TrajDrawKeysUnselected
	ButtonText:~TRAJ_DRAWKEYSUNSEL_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_DRAWKEYSUNSEL_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.unselTrajectoryDrawKeys
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.unselTrajectoryDrawKeys = NOT maxOps.unselTrajectoryDrawKeys
	)
)

MacroScript TrajDrawKeysSelected
	ButtonText:~TRAJ_DRAWKEYSSEL_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_DRAWKEYSSEL_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.selTrajectoryDrawKeys
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.selTrajectoryDrawKeys = NOT maxOps.selTrajectoryDrawKeys
	)
)

MacroScript TrajGradientPathSpeedColor
	ButtonText:~TRAJ_GRADIENTPATH_SPEED_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_GRADIENTPATH_SPEED_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.trajectoryPathGradation == #speed
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryPathGradation != #speed
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.trajectoryPathGradation = #speed
	)
)

MacroScript TrajGradientPathWireColor
	ButtonText:~TRAJ_GRADIENTPATH_WIRECOLOR_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_GRADIENTPATH_WIRECOLOR_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.trajectoryPathGradation == #wireColor
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryPathGradation != #wireColor
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.trajectoryPathGradation = #wireColor
	)
)

MacroScript TrajGradientPathUIColor
	ButtonText:~TRAJ_GRADIENTPATH_UICOLOR_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_GRADIENTPATH_UICOLOR_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.trajectoryPathGradation == #UIcolor
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryPathGradation != #UIcolor
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.trajectoryPathGradation = #UIcolor
	)
)

MacroScript TrajGradientPathNone
	ButtonText:~TRAJ_GRADIENTPATH_NONE_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_GRADIENTPATH_NONE_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.trajectoryPathGradation == #none
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryPathGradation != #none
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.trajectoryPathGradation = #none
	)
)

MacroScript TrajBreakSelectedTangent
	ButtonText:~TRAJ_BREAKTANGENT_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_BREAKTANGENT_TOOLTIP~
	SilentErrors:(Debug != True) 
(
 
	on isEnabled do
	(
		selection.count > 0
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.breakSelectedKeyTangent()
	)
)

MacroScript TrajUnifySelectedTangent
	ButtonText:~TRAJ_UNIFYTANGENT_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_UNIFYTANGENT_TOOLTIP~
	SilentErrors:(Debug != True) 
(
 
	on isEnabled do
	(
		selection.count > 0
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.UnifySelectedKeyTangent()
	)
)

MacroScript TrajSetToAutoSelectedTangent
	ButtonText:~TRAJ_SETTOAUTO_TANGENT_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_SETTOAUTO_TANGENT_TOOLTIP~
	SilentErrors:(Debug != True) 
(
 
	on isEnabled do
	(
		selection.count > 0
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.setSelectedKeyTangentToAuto()
	)
)

MacroScript ShowFullTrajectories
	ButtonText:~TRAJ_SHOWFULLTRAJECTORY_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_SHOWFULLTRAJECTORY_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isEnabled do
	(
		maxOps.trajectoryMode AND maxOps.TrimTrajectories
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.TrimTrajectories = false
	)
)

MacroScript TrimTrajectoriesWithFixedFrames
	ButtonText:~TRAJ_TRIMTRAJECTORY_FIXEDFRAMES_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_TRIMTRAJECTORY_FIXEDFRAMES_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isEnabled do
	(
		maxOps.trajectoryMode AND (NOT maxOps.TrimTrajectories OR NOT maxOps.FixedTrimRange)
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode 
	)
	 
	on execute do 
	(
		maxOps.TrimTrajectories = true
		maxOps.FixedTrimRange = true
	)
)

MacroScript TrimTrajectoriesWithMovingFrames
	ButtonText:~TRAJ_TRIMTRAJECTORY_MOVINGFRAMES_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_TRIMTRAJECTORY_MOVINGFRAMES_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isEnabled do
	(
		maxOps.trajectoryMode AND (NOT maxOps.TrimTrajectories OR maxOps.FixedTrimRange)
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode 
	)
	 
	on execute do 
	(
		maxOps.TrimTrajectories = true
		maxOps.FixedTrimRange = false
	)
)

MacroScript TrajDrawAllHandles
	ButtonText:~TRAJ_DRAWALLHANDLES_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_DRAWALLHANDLES_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.DrawAllHandles
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.DrawAllHandles = NOT maxOps.DrawAllHandles
	)
)

MacroScript TrajTickFramesSelected
	ButtonText:~TRAJ_TICKFRAMESSEL_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_TICKFRAMESSEL_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.SelTrajectoryDrawFrameTicks
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.SelTrajectoryDrawFrameTicks = NOT maxOps.SelTrajectoryDrawFrameTicks
	)
)

MacroScript TrajDrawGradientTicks
	ButtonText:~TRAJ_DRAWGRADIENTTICKS_TEXT~
	Category:~TRAJECTORY_CATEGORY~ 
	internalCategory:"Trajectories" 
	Tooltip:~TRAJ_DRAWGRADIENTTICKS_TOOLTIP~
	SilentErrors:(Debug != True) 
(
	on isChecked do
	(
		maxOps.DrawGradientTicks
	)
	 
	on isEnabled do
	(
		maxOps.trajectoryMode AND maxOps.SelTrajectoryDrawFrameTicks
	)
	 
	on isVisible do
	(
		maxOps.trajectoryMode
	)
	 
	on execute do 
	(
		maxOps.DrawGradientTicks = NOT maxOps.DrawGradientTicks
	)
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAEy89bFfvos/5sTPYso9JT7e06wAgoJ6uN
-- +wpHGvgA5pWqxXtQxW9/NfJikMivDZ2YMosuLlqBxRJhP6ISJcf8pPzn6d3C7WbJ
-- TRLBozvXDPmOxluZm1jV19+mf5tITGRyNJ1o+plIuq2dP+XYzqYLshPq5/ZEgPHA
-- UcjFSxaQuhDMwOC3+ZjAYFmaCBMR1VQ96vhfB7oLNGlM1ZYEW5/xh77kFk8GL+wJ
-- ECu0ywB5rJZOdJJKerUJVkvwxYCtrZV/LZzIT/7zEzOu8dpC3kRPAvBkwlN7zNwa
-- ZA9lW50se26YIod9WqT9Nd5vDSbHyttQ1SUjTlkvIjvZLfJcqY8F
-- -----END-SIGNATURE-----