/*
********************************************************************************
Macro Scripts for Trackview
Author:   Adam Felt

Revision History:
		11 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products
		consolidated the macro_collapsecontroller.mcr with the macro_trackview.mcr



Modify at your own risk
-- ********************************************************************************
*/

-- Animation Editor Launch Macros
-- ********************************************
macroScript LaunchFCurveEditor
	category:~LAUNCHFCURVEEDITOR_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~LAUNCHFCURVEEDITOR_TOOLTIP~
	buttonText:~LAUNCHFCURVEEDITOR_BUTTONTEXT~
	Icon:#("TrackViewTools",23)
(
	on execute do
	(
		-- Open the track view with the default layout
		local layoutName = trackviews.defaultCurveEditorLayout
		if layoutName.count == 0 do layoutName = ~TRACKVIEWS_OPEN_LAYOUTNAME_CAPTION~
		if  (trackviews.open ~TRACKVIEWS_OPEN_CAPTION~ layoutName:layoutName) == true then 
		(
			-- Set up the parameters for a fcurve editor
			if trackviews.current != undefined do
			(
				trackviews.current.setname ~TRACKVIEW_CURVE_EDITOR_CAPTION~
				trackviews.current.modifySubTree = false
			)
		)
		else (
			messageBox ~MSGBOX_TRACK_VIEW_WINDOW_COULD_NOT_BE_OPENED_CAPTION~ title:~MSGBOX_TRACK_VIEW_WINDOW_COULD_NOT_BE_OPENED_TITLE~
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
macroScript LaunchFCurveEditorClassic
	category:~LAUNCHFCURVEEDITOR_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~LAUNCHFCURVEEDITOR_CLASSIC_TOOLTIP~
	buttonText:~LAUNCHFCURVEEDITOR_CLASSIC_BUTTONTEXT~
	Icon:#("TrackViewTools",23)
	--need new icon! MZ TODO
(
	on execute do
	(
-- Open the track view
		if  (trackviews.open ~TRACKVIEWS_OPEN_CLASSIC_CAPTION~ layoutName:~TRACKVIEWS_OPEN_CLASSIC_LAYOUTNAME_CAPTION~) == true then 
		(
			-- Set up the parameters for a fcurve editor
			if trackviews.current != undefined do
			(
				trackviews.current.setname ~TRACKVIEW_CURVE_CLASSIC_EDITOR_CAPTION~
				trackviews.current.modifySubTree = false
			)
		)
		else (
			messageBox ~MSGBOX_TRACK_VIEW_WINDOW_COULD_NOT_BE_OPENED_CAPTION~ title:~MSGBOX_TRACK_VIEW_WINDOW_COULD_NOT_BE_OPENED_TITLE~
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
macroScript SwitchToFCurveEditor
	category:~SWITCHTOFCURVEEDITOR_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~SWITCHTOFCURVEEDITOR_TOOLTIP~
	buttonText:~SWITCHTOFCURVEEDITOR_BUTTONTEXT~
	--Icon:#("TrackViewTools",23)
(
	on execute do
	(
		if trackviews.current != undefined do
		(
			trackviews.current.setname ~TRACKVIEWS_CURRENT_SETNAME_BUTTONTEXT~
			trackviews.current.modifySubTree = false
			local layoutName = trackviews.defaultCurveEditorLayout
			if layoutName.count == 0 do layoutName = ~TRACKVIEWS_CURRENT_UI_LOADLAYOUT_CAPTION~
			trackviews.current.ui.loadLayout layoutName
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
macroScript SwitchToFCurveEditorClassic
	category:~SWITCHTOFCURVEEDITOR_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~SWITCHTOFCURVEEDITOR_CLASSIC_TOOLTIP~
	buttonText:~SWITCHTOFCURVEEDITOR_CLASSIC_BUTTONTEXT~
(
	on execute do
	(
		if trackviews.current != undefined do
		(
			trackviews.current.setname ~TRACKVIEWS_CURRENT_CLASSIC_SETNAME_BUTTONTEXT~
			trackviews.current.modifySubTree = false
			trackviews.current.ui.loadLayout ~TRACKVIEWS_CURRENT_CLASSIC_UI_LOADLAYOUT_CAPTION~
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
macroScript LaunchDopeSheetEditor
	category:~LAUNCHDOPESHEETEDITOR_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~LAUNCHDOPESHEETEDITOR_TOOLTIP~
	buttonText:~LAUNCHDOPESHEETEDITOR_BUTTONTEXT~
	Icon:#("TrackViewTools",13)
(
	on execute do
	(
		-- Open the track view
		if (trackviews.open ~TRACK_VIEW_DOPE_SHEET_CAPTION~ layoutName:~TRACK_VIEW_DOPE_SHEET_LAYOUTNAME~) == true then
		(
			-- Set up the parameters for a fcurve editor
			if trackviews.current != undefined do
			(
				trackviews.current.setname ~CURRENT_TRACK_VIEW_DOPE_SHEET_CAPTION~
				trackviews.current.modifySubTree = true
			)
		)
		else (
			messageBox ~MSGBOX_TRACK_VIEW_NOT_OPENED~ title:~MSGBOX_TRACK_VIEW_NOT_OPENED_TITLE~
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
macroScript SwitchDopeSheetEditor
	category:~SWITCHDOPESHEETEDITOR_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~SWITCHDOPESHEETEDITOR_TOOLTIP~
	buttonText:~SWITCHDOPESHEETEDITOR_BUTTONTEXT~
(
	on execute do
	(
		if trackviews.current != undefined do
		(
			trackviews.current.setname ~SWITCHDOPESHEETEDITOR_TRACK_VIEW_DOPE_SHEET~
			trackviews.current.modifySubTree = true
			trackviews.current.ui.loadLayout ~SWITCHDOPESHEETEDITOR_DOPE_SHEET_LAYOUT~
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
macroScript LaunchRangeEditor
	category:~LAUNCHRANGEEDITOR_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~LAUNCHRANGEEDITOR_TOOLTIP~
	buttonText:~LAUNCHRANGEEDITOR_BUTTONTEXT~
	Icon:#("TrackViewTools",21)
(
	on execute do
	(
		
-- Pop up the warning with no titlebar
		createdialog ConstWarning style:#(#style_border)

-- Open the track view
		CR_Edit= trackviews.open ~TRACKVIEWS_LAUNCHRANGEEDITOR~ layoutName:~CONTROLLER_RANGE_LAYOUT_LAYOUTNAME~
	
-- Set up the parameters for a controller editor	
		if trackviews.current != undefined do
		(
			trackviews.current.setname ~TRACK_VIEW_CONTROLLER_EDITOR~
			trackviews.current.modifySubTree = false
			trackviews.current.editmode = #positionranges
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
macroScript SwitchRangeEditor
	category:~SWITCHRANGEEDITOR_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~SWITCHRANGEEDITOR_TOOLTIP~
	buttonText:~SWITCHRANGEEDITOR_BUTTONTEXT~
(
	on execute do
	(
		if trackviews.current != undefined do
		(
			trackviews.current.ui.showKeyableIcons = true
			trackviews.current.setname ~SWITCHRANGEEDITOR_CAPTION~
			trackviews.current.modifySubTree = false
			trackviews.current.editmode = #positionranges
			trackviews.current.ui.loadLayout ~CONTROLLER_RANGE_LAYOUT_TRACKVIEWS_CURRENT_UI_LOADLAYOUT~
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
-- Curve Editor Macros
-- ********************************************
macroScript ShowNonselectedCurves
	category:~SHOWNONSELECTEDCURVES_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~SHOWNONSELECTEDCURVES_TOOLTIP~
	buttonText:~SHOWNONSELECTEDCURVES_BUTTONTEXT~
	Icon:#("TrackViewTools",62)
(
	on execute do
	(
		if trackviews.current != undefined do
		(
			trackviews.current.showNonSelCurves = true
			trackviews.current.freezeNonSelCurves = false
		)
	)
	On isChecked do
 	(
		if trackviews.current != undefined 
		then trackviews.current.showNonSelCurves
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript HideNonselectedCurves
	category:~HIDENONSELECTEDCURVES_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~HIDENONSELECTEDCURVES_TOOLTIP~
	buttonText:~HIDENONSELECTEDCURVES_BUTTONTEXT~
	Icon:#("TrackViewTools",64)
(
	on execute do
	(
		trackviews.current.showNonSelCurves = false
	)
	on isChecked do
 	(
		if trackviews.current != undefined 
		then not trackviews.current.showNonSelCurves
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript FreezeNonselectedCurves
	category:~FREEZENONSELECTEDCURVES_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~FREEZENONSELECTEDCURVES_TOOLTIP~
	buttonText:~FREEZENONSELECTEDCURVES_BUTTONTEXT~
	Icon:#("TrackViewTools",63)
(
	on execute do
	(
		if (trackviews.currenttrackview.freezeNonSelCurves) == true 
		then trackviews.currenttrackview.freezeNonSelCurves = false
		else trackviews.currenttrackview.freezeNonSelCurves = true
	)
	on isChecked do
 	(
		if trackviews.current != undefined 
		then trackviews.current.freezeNonSelCurves
		else false
	)
	on isEnabled do
 	(
		if trackviews.current != undefined 
		then trackviews.current.showNonSelCurves
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript ShowAllTangents
	category:~SHOWALLTANGENTS_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~SHOWALLTANGENTS_TOOLTIP~
	buttonText:~SHOWALLTANGENTS_BUTTONTEXT~
	iconName:"TrackView/Curves/AllTangents"
(
	on ischecked do
	(
		if trackviews.current != undefined 
		then ((trackviews.current.showTangents as string) == "all")
		else false
	)
	on execute do
	(
		if trackviews.current != undefined do
		(	
			if (trackviews.currenttrackview.showTangents as string) == "selected" or (trackviews.currenttrackview.showTangents as string) == "none" 
			then trackviews.currenttrackview.showTangents = #all
			else trackviews.currenttrackview.showTangents = #selected
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript ShowSelectedTangents
	category:~SHOWSELECTEDTANGENTS_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~SHOWSELECTEDTANGENTS_TOOLTIP~
	buttonText:~SHOWSELECTEDTANGENTS_BUTTONTEXT~
	Icon:#("TrackViewTools",77)
(
	on ischecked do
	(
		if trackviews.current != undefined 
		then ((trackviews.current.showTangents as string) == "selected")
		else false
	)
	on execute do
	(
		if trackviews.current != undefined do
		(	
			trackviews.current.showTangents = #selected
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript HideTangents
	category:~HIDETANGENTS_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~HIDETANGENTS_TOOLTIP~
	buttonText:~HIDETANGENTS_BUTTONTEXT~
	Icon:#("TrackViewTools",78)
(
	on ischecked do
	(
		if trackviews.current != undefined 
		then ((trackviews.current.showTangents as string) == "none")
		else false
	)
	on execute do
	(
		if trackviews.current != undefined do
		(	
			trackviews.current.showTangents = #all
		)
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript ShowFrozenKeys
	category:~SHOWFROZENKEYS_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~SHOWFROZENKEYS_TOOLTIP~
	buttonText:~SHOWFROZENKEYS_BUTTONTEXT~
(
	on execute do
	(
		if trackviews.current != undefined do
		(	
			trackviews.current.showFrozenKeys = not trackviews.current.showFrozenKeys
		)
	)
	on ischecked do
	(
		if trackviews.current != undefined 
		then trackviews.current.showFrozenKeys
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript InteractiveUpdate
	category:~INTERACTIVEUPDATE_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~INTERACTIVEUPDATE_TOOLTIP~
	buttonText:~INTERACTIVEUPDATE_BUTTONTEXT~
(
	on execute do
	(
		if trackviews.current != undefined do
		(	
			trackviews.currenttrackview.interactiveupdate = not trackviews.currenttrackview.interactiveupdate
			-- sync time and interactive update are mutually exclusive
			-- if you are turning on interactive update turn off sync time
			if trackviews.currenttrackview.interactiveupdate do
				trackviews.currenttrackview.syncTime = false
		)
	)
	on ischecked do
	(
		if trackviews.current != undefined 
		then trackviews.currenttrackview.interactiveupdate
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript SyncTime
	category:~SYNCTIME_CATEGORY~
    internalCategory:"Track View" 
	toolTip:~SYNCTIME_TOOLTIP~
	buttonText:~SYNCTIME_BUTTONTEXT~
(
	on execute do
	(
		if trackviews.current != undefined do
		(	
			trackviews.currenttrackview.syncTime = not trackviews.currenttrackview.syncTime
			-- sync time and interactive update are mutually exclusive
			-- if you are turning on sync time turn off interactive update
			if trackviews.currenttrackview.syncTime do
				trackviews.currenttrackview.interactiveupdate = false
		)
	)
	on ischecked do
	(
		if trackviews.current != undefined 
		then trackviews.currenttrackview.syncTime
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

-- UI Layout macros
-- ********************************************

macroScript TV_Load_Layout
            category:~TV_LOAD_LAYOUT_CATEGORY~ 
            internalCategory:"Track View" 
            tooltip:~TV_LOAD_LAYOUT_TOOLTIP~ 
            buttontext:~TV_LOAD_LAYOUT_BUTTONTEXT~ 
(
	rollout Layouts ~TV_LOAD_LAYOUT_ROLLOUT_CAPTION~ width:150 height:117
	(
		local tv
		
		dropdownList layoutList ~DROPDOWNLIST_LAYOUTS_CAPTION~ pos:[9,11] width:132 height:40
		button LoadLayout ~LOADLAYOUT_BUTTON~ pos:[37,77] width:72 height:24
		
		on Layouts open do
		(
			tv = trackviews.current.ui
			local ct = tv.LayoutCount()
			local items = #()			
			for i = 1 to ct do
			(
				append items (tv.getLayoutName i)
			)
			layoutList.items = items
		)
		on LoadLayout pressed do
		(
			tv.loadLayout layoutList.selected
		)
	)
	on execute do 
	(
		if trackviews.current != undefined do
		(
			createDialog Layouts parent:trackviews.current.ui.hwnd pos:[100,100]
		)
	)
	on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Save_Layout
            category:~TV_SAVE_LAYOUT_CATEGORY~ 
            internalCategory:"Track View" 
            tooltip:~TV_SAVE_LAYOUT_TOOLTIP~ 
            buttontext:~TV_SAVE_LAYOUT_BUTTONTEXT~ 
(
   
	rollout SaveLayouts ~SAVE_LAYOUTS_ROLLOUT_CAPTION~ width:162 height:108
	(
		editText LayoutName "" pos:[6,32] width:146 height:24
		label lbl1 ~LBL1_LAYOUT_NAME_CAPTION~ pos:[11,11] width:141 height:18
		button SaveLayout ~SAVELAYOUT_BUTTON~ pos:[41,68] width:75 height:27
		
		on SaveLayout pressed do
		(
			if LayoutName.text != "" then
			(
				trackviews.currenttrackview.ui.saveLayout (LayoutName.text)
			) else (
				MessageBox ~MSGBOX_YOU_MUST_PROVIDE~ title:~NO_LAYOUT_NAME~
			)
		)
	)
   on execute do 
   (
   		if trackviews.currenttrackview != undefined do
		(
			createDialog SaveLayouts parent:trackviews.currenttrackview.ui.hwnd pos:[100,100]
		)
   )
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Load_Menu_Bar
            category:~TV_LOAD_MENU_BAR_CATEGORY~ 
            internalCategory:"Track View" 
            tooltip:~TV_LOAD_MENU_BAR_TOOLTIP~ 
            buttontext:~TV_LOAD_MENU_BAR_BUTTONTEXT~ 
(
	rollout LoadMenuBar ~LOADMENUBAR_ROLLOUT~ width:248 height:108
	(
		button LoadMenu ~LOADMENU_BUTTON~ pos:[79,68] width:72 height:24
		dropDownList menuList ~MENULIST_CAPTION~ pos:[12,17] width:222 height:40
		on LoadMenuBar open do
		(
			tv = trackviews.currenttrackview.ui
			local ct = menuMan.numMenus()
			local items = #()			
			for i = 1 to ct do
			(
				if (menuMan.getMenu i).GetTitle() != "" do
				(
					append items ((menuMan.getMenu i).GetTitle())
				)
			)
			menuList.items = items
		)
		on LoadMenu pressed do
		(
			trackviews.currenttrackview.ui.menuBar = menuList.selected
		)
	)   
	on execute do 
	(
		if trackviews.currenttrackview != undefined do
		(
			createDialog LoadMenuBar parent:trackviews.currenttrackview.ui.hwnd pos:[100,100]
		)
	)
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Load_Controller_Quad_Menu
            category:~TV_LOAD_CONTROLLER_QUAD_MENU_CATEGORY~ 
            internalCategory:"Track View" 


            tooltip:~TV_LOAD_CONTROLLER_QUAD_MENU_TOOLTIP~ 
            buttontext:~TV_LOAD_CONTROLLER_QUAD_MENU_BUTTONTEXT~ 
(
	rollout LoadQuadMenu ~LOADQUADMENU_ROLLOUT~ width:248 height:108
	(
		button LoadMenu ~LOADMENU_BUTTONTEXT~ pos:[79,68] width:72 height:24
		dropDownList menuList ~MENULIST_DROPDOWN_CAPTION~ pos:[12,17] width:222 height:40
		on LoadQuadMenu open do
		(
			local ct = menuMan.numMenus()
			local items = #()			
			for i = 1 to ct do
			(
				if (menuMan.getMenu i).GetTitle() != "" do
				(
					append items ((menuMan.getMenu i).GetTitle())
				)
			)
			menuList.items = items
		)
		on LoadMenu pressed do
		(
			trackviews.current.ui.controllerQuadMenu = menuList.selected
		)
	)   
	on execute do 
	(
		if trackviews.current != undefined do
		(
			createDialog LoadQuadMenu parent:trackviews.current.ui.hwnd pos:[100,100]
		)
	)
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Load_Key_Quad_Menu
            category:~TV_LOAD_KEY_QUAD_MENU_CATEGORY~ 
            internalCategory:"Track View" 
            tooltip:~TV_LOAD_KEY_QUAD_MENU_TOOLTIP~ 
            buttontext:~TV_LOAD_KEY_QUAD_MENU_BUTTONTEXT~ 
(
	rollout LoadQuadMenu ~LOADQUADMENU_CAPTION~ width:248 height:108
	(
		button LoadMenu ~LOADMENU_LOAD_BUTTONTEXT~ pos:[79,68] width:72 height:24
		dropDownList menuList ~MENULIST_DROPDOWN_MENUS_CAPTION~ pos:[12,17] width:222 height:40
		on LoadQuadMenu open do
		(
			local ct = menuMan.numMenus()
			local items = #()			
			for i = 1 to ct do
			(
				if (menuMan.getMenu i).GetTitle() != "" do
				(
					append items ((menuMan.getMenu i).GetTitle())
				)
			)
			menuList.items = items
		)
		on LoadMenu pressed do
		(
			trackviews.current.ui.keyQuadMenu = menuList.selected
		)
	)   
	on execute do 
	(
		if trackviews.current != undefined do
		(
			createDialog LoadQuadMenu parent:trackviews.current.ui.hwnd pos:[100,100]
		)
	)
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Add_Toolbar
            category:~TV_ADD_TOOLBAR_CATEGORY~ 
            internalCategory:"Track View" 
            tooltip:~TV_ADD_TOOLBAR_TOOLTIP~ 
            buttontext:~TV_ADD_TOOLBAR_BUTTONTEXT~ 
(
	rollout AddToolbar ~ADD_TOOLBAR_ROLLOUT_TOOLTIP~ width:162 height:108
	(
		editText ToolbarName "" pos:[6,32] width:146 height:24
		label lbl1 ~LBL1_TOOLBAR_NAME~ pos:[11,11] width:141 height:18
		button Add ~ADD_BUTTON~ pos:[41,68] width:75 height:27
		
		on Add pressed do
		(
			if ToolbarName.text != "" then
			(
				trackviews.currenttrackview.ui.addToolbar (ToolbarName.text)
			) else (
				MessageBox ~MSGBOX_YOU_MUST_PROVIDE_A_NAME_FOR_THE_LAYOUT~ title:~MSGBOX_YOU_MUST_PROVIDE_A_NAME_FOR_THE_LAYOUT_TITLE~
			)
		)
	)
   on execute do 
   (
   		if trackviews.currenttrackview != undefined do
		(
			createDialog AddToolbar parent:trackviews.currenttrackview.ui.hwnd pos:[100,100]
		)
   )
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Delete_Toolbar
            category:~TV_DELETE_TOOLBAR_CATEGORY~ 
            internalCategory:"Track View" 
            tooltip:~TV_DELETE_TOOLBAR_TOOLTIP~ 
            buttontext:~TV_DELETE_TOOLBAR_BUTTONTEXT~ 
(
	rollout DeleteToolbar ~DELETE_TOOLBAR_TOOLTIP~ width:248 height:108
	(
		button Delete ~DELETE_BUTTONTEXT~ pos:[79,68] width:72 height:24
		dropDownList toolbarList ~TOOLBARLIST_CAPTION~ pos:[12,17] width:222 height:40
		on DeleteToolbar open do
		(
			tv = trackviews.currenttrackview.ui
			local ct = tv.toolbarCount()
			local items = #()			
			for i = 1 to ct do
			(
				append items (tv.getToolbarName i)
			)
			toolbarList.items = items
		)
		on Delete pressed do
		(
			if QueryBox ~QUERYBOX_CAPTION~ beep:false do
			(
				trackviews.currenttrackview.ui.DeleteToolbar toolbarList.selected
			)
		)
	)   
	on execute do 
	(
		if trackviews.current != undefined do
		(
			createDialog DeleteToolbar parent:trackviews.current.ui.hwnd pos:[100,100]
		)
	)
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

-- Provided as an example of how to toggle the display of a specific toolbar ("Name : Track View")
macroScript TV_Show_Hide_Name_Toolbar
            category:~TV_SHOW_HIDE_NAME_TOOLBAR_CATEGORY~ 
            internalCategory:"Track View" 
            tooltip:~TV_SHOW_HIDE_NAME_TOOLBAR_TOOLTIP~ 
            buttontext:~TV_SHOW_HIDE_NAME_TOOLBAR_BUTTONTEXT~ 
(
   on execute do 
   (
	   	if trackviews.currenttrackview != undefined do
		(
			if trackviews.currenttrackview.ui.isToolbarVisible ~TV_SHOW_HIDE_NAME_TOOLBAR_TOOLBAR_NAME~ then
				( trackviews.currenttrackview.ui.hideToolbar ~TV_SHOW_HIDE_NAME_TOOLBAR_TOOLBAR_NAME~ )
			else ( trackviews.currenttrackview.ui.showToolbar ~TV_SHOW_HIDE_NAME_TOOLBAR_TOOLBAR_NAME~ )
		)
   )
   on isChecked do
   (
	   	if trackviews.currenttrackview != undefined
		then (trackviews.currenttrackview.ui.isToolbarVisible ~TV_SHOW_HIDE_NAME_TOOLBAR_TOOLBAR_NAME~) 
		else false
	)
)

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Show_All_Toolbars
            category:~TV_SHOW_ALL_TOOLBARS_CATEGORY~ 
            internalCategory:"Track View" 
            tooltip:~TV_SHOW_ALL_TOOLBARS_TOOLTIP~ 
            buttontext:~TV_SHOW_ALL_TOOLBARS_BUTTONTEXT~ 
(
   on execute do 
   (
	   	if trackviews.currenttrackview != undefined do
		(
			trackviews.currenttrackview.ui.showAllToolbars()
		)
   )
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Hide_All_Toolbars
            category:~TV_HIDE_ALL_TOOLBARS_CATEGORY~ 
            internalCategory:"Track View" 
            tooltip:~TV_HIDE_ALL_TOOLBARS_TOOLTIP~ 
            buttontext:~TV_HIDE_ALL_TOOLBARS_BUTTONTEXT~ 
            -- Icon:#("TrackViewTools",0)
(
   on execute do
   (
	   	if trackviews.currenttrackview != undefined do
		(
			trackviews.currenttrackview.ui.hideAllToolbars()
		)
   )
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Show_Hide_Menu_Bar
            category:~TV_SHOW_HIDE_MENU_BAR_CATEGORY~ 
            internalCategory:"Track View" 
            tooltip:~TV_SHOW_HIDE_MENU_BAR_TOOLTIP~ 
            buttontext:~TV_SHOW_HIDE_MENU_BAR_BUTTONTEXT~ 
(
   on execute do
   (
	   	if trackviews.currenttrackview != undefined do
		(
			trackviews.currenttrackview.ui.showMenuBar = not trackviews.currenttrackview.ui.showMenuBar
		)
   )
   on isChecked do 
   (
 	   	if trackviews.current != undefined 
		then (trackviews.currenttrackview.ui.showMenuBar)
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Show_Hide_Scroll_Bars
            category:~TV_SHOW_HIDE_SCROLL_BARS_CATEGORY~ 
            internalCategory:"Track View" 
            tooltip:~TV_SHOW_HIDE_SCROLL_BARS_TOOLTIP~ 
            buttontext:~TV_SHOW_HIDE_SCROLL_BARS_BUTTONTEXT~
(
   on execute do
   (
	   	if trackviews.current != undefined do
		(
			trackviews.current.ui.showScrollBars = not trackviews.current.ui.showScrollBars
		)
   )
   on isChecked do 

   (
 	   	if trackviews.current != undefined 
		then (trackviews.currenttrackview.ui.showScrollBars)
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Show_Hide_Controller_Window
            category:~TV_SHOW_HIDE_CONTROLLER_WINDOW_CATEGORY~ 
            internalCategory:"Track View" 
            tooltip:~TV_SHOW_HIDE_CONTROLLER_WINDOW_TOOLTIP~ 
            buttontext:~TV_SHOW_HIDE_CONTROLLER_WINDOW_BUTTONTEXT~
(
   on execute do
   (
	   	if trackviews.currenttrackview != undefined do
		(
			trackviews.currenttrackview.ui.showTrackWindow = not trackviews.currenttrackview.ui.showTrackWindow
		)
   )
   on isChecked do 
   (
 	   	if trackviews.current != undefined 
		then (trackviews.currenttrackview.ui.showTrackWindow)
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Show_Hide_Key_Window
            category:~TV_SHOW_HIDE_KEY_WINDOW_CATEGORY~ 
            internalCategory:"Track View" 
            tooltip:~TV_SHOW_HIDE_KEY_WINDOW_TOOLTIP~ 
            buttontext:~TV_SHOW_HIDE_KEY_WINDOW_BUTTONTEXT~
(
   on execute do
   (
	   	if trackviews.currenttrackview != undefined do
		(
			trackviews.currenttrackview.ui.showKeyWindow = not trackviews.currenttrackview.ui.showKeyWindow
		)
   )
   on isChecked do 
   (
 	   	if trackviews.current != undefined 
		then (trackviews.currenttrackview.ui.showKeyWindow)
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript TV_Show_Hide_Time_Ruler
            category:~TV_SHOW_HIDE_TIME_RULER_CATEGORY~ 
            internalCategory:"Track View" 
            tooltip:~TV_SHOW_HIDE_TIME_RULER_TOOLTIP~ 
            buttontext:~TV_SHOW_HIDE_TIME_RULER_BUTTONTEXT~
(
   on execute do
   (
	   	if trackviews.currenttrackview != undefined do
		(
			trackviews.currenttrackview.ui.showTimeRuler = not trackviews.currenttrackview.ui.showTimeRuler
		)
   )
   on isChecked do 
   (
 	   	if trackviews.current != undefined 
		then (trackviews.currenttrackview.ui.showTimeRuler)
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
-- Display and Selection Filter macros
-- ************************************************
MacroScript ManualNavigation
	ButtonText:~MANUALNAVIGATION_BUTTONTEXT~ 
	Category:~MANUALNAVIGATION_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~MANUALNAVIGATION_TOOLTIP~ 
(
   	on execute do 
   	(
   		if trackviews.current != undefined do
		(
			trackviews.current.manualNavigation = not trackviews.current.manualNavigation
		)
	)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Expand_Children
	ButtonText:~AUTO_EXPAND_CHILDREN_BUTTONTEXT~ 
	Category:~AUTO_EXPAND_CHILDREN_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~AUTO_EXPAND_CHILDREN_TOOLTIP~ 
(
   	on execute do (trackviews.current.autoExpandChildren = not trackviews.current.autoExpandChildren)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoExpandChildren
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Expand_Selected_Only
	ButtonText:~AUTO_EXPAND_SELECTED_ONLY_BUTTONTEXT~ 
	Category:~AUTO_EXPAND_SELECTED_ONLY_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~AUTO_EXPAND_SELECTED_ONLY_TOOLTIP~ 
(
   	on execute do (trackviews.current.autoExpandSelectedOnly = not trackviews.current.autoExpandSelectedOnly)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoExpandSelectedOnly
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Expand_Transforms
	ButtonText:~AUTO_EXPAND_TRANSFORMS_BUTTONTEXT~ 
	Category:~AUTO_EXPAND_TRANSFORMS_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~AUTO_EXPAND_TRANSFORMS_TOOLTIP~ 
(
  	on execute do (trackviews.current.autoExpandTransforms = not trackviews.current.autoExpandTransforms)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoExpandTransforms
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Expand_XYZ
	ButtonText:~AUTO_EXPAND_XYZ_BUTTONTEXT~ 
	Category:~AUTO_EXPAND_XYZ_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~AUTO_EXPAND_XYZ_TOOLTIP~ 
(
   	on execute do (trackviews.current.autoExpandXYZ = not trackviews.current.autoExpandXYZ)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoExpandXYZ
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Expand_Objects
	ButtonText:~AUTO_EXPAND_OBJECTS_BUTTONTEXT~ 
	Category:~AUTO_EXPAND_OBJECTS_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~AUTO_EXPAND_OBJECTS_TOOLTIP~ 
(
   	on execute do (trackviews.current.autoExpandObjects = not trackviews.current.autoExpandObjects)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoExpandObjects
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************
MacroScript Auto_Expand_Modifiers
	ButtonText:~AUTO_EXPAND_MODIFIERS_BUTTONTEXT~ 
	Category:~AUTO_EXPAND_MODIFIERS_CATEGORY~ 
	internalCategory:"Animation Object" 
	Tooltip:~AUTO_EXPAND_MODIFIERS_TOOLTIP~ 
(
   	on execute do (trackviews.current.autoExpandModifiers = not trackviews.current.autoExpandModifiers)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoExpandModifiers
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Expand_Materials
	ButtonText:~AUTO_EXPAND_MATERIALS_BUTTONTEXT~ 
	Category:~AUTO_EXPAND_MATERIALS_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~AUTO_EXPAND_MATERIALS_TOOLTIP~ 
(
   	on execute do (trackviews.current.autoExpandMaterials = not trackviews.current.autoExpandMaterials)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoExpandMaterials
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Select_Animated
	ButtonText:~AUTO_SELECT_ANIMATED_BUTTONTEXT~ 
	Category:~AUTO_SELECT_ANIMATED_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~AUTO_SELECT_ANIMATED_TOOLTIP~ 
(
   	on execute do (trackviews.current.autoSelectAnimated = not trackviews.current.autoSelectAnimated)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoSelectAnimated
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Select_Position
	ButtonText:~AUTO_SELECT_POSITION_BUTTONTEXT~ 
	Category:~AUTO_SELECT_POSITION_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~AUTO_SELECT_POSITION_TOOLTIP~ 
(
   	on execute do (trackviews.current.autoSelectPosition = not trackviews.current.autoSelectPosition)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoSelectPosition
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Select_Rotation
	ButtonText:~AUTO_SELECT_ROTATION_BUTTONTEXT~ 
	Category:~AUTO_SELECT_ROTATION_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~AUTO_SELECT_ROTATION_TOOLTIP~ 
(
   	on execute do (trackviews.current.autoSelectRotation = not trackviews.current.autoSelectRotation)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoSelectRotation
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Select_Scale
	ButtonText:~AUTO_SELECT_SCALE_BUTTONTEXT~ 
	Category:~AUTO_SELECT_SCALE_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~AUTO_SELECT_SCALE_TOOLTIP~ 
(
  	on execute do (trackviews.current.autoSelectScale = not trackviews.current.autoSelectScale)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoSelectScale
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Auto_Select_XYZ
	ButtonText:~AUTO_SELECT_XYZ_BUTTONTEXT~ 
	Category:~AUTO_SELECT_XYZ_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~AUTO_SELECT_XYZ_TOOLTIP~ 
(
   	on execute do (trackviews.current.autoSelectXYZ = not trackviews.current.autoSelectXYZ)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoSelectXYZ
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript Auto_Scroll_To_Selected
            category:~AUTO_SCROLL_TO_SELECTED_CATEGORY~ 
            internalCategory:"Track View" 
            tooltip:~AUTO_SCROLL_TO_SELECTED_TOOLTIP~ 
            buttontext:~AUTO_SCROLL_TO_SELECTED_BUTTONTEXT~ 
(
   	on execute do (trackviews.current.autoScrollToSelected = not trackviews.current.autoScrollToSelected)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoScrollToSelected
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

macroScript Auto_Scroll_To_Root
            category:~AUTO_SCROLL_TO_ROOT_CATEGORY~ 
            internalCategory:"Track View" 
            tooltip:~AUTO_SCROLL_TO_ROOT_TOOLTIP~ 
            buttontext:~AUTO_SCROLL_TO_ROOT_BUTTONTEXT~ 
(
   	on execute do (trackviews.current.autoScrollToRoot = not trackviews.current.autoScrollToRoot)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.autoScrollToRoot
		else false
	)
	on isEnabled do 
	(
		if trackviews.current != undefined 
		then not trackviews.current.manualNavigation
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

-- R4 Trackview selected method
-- *************************************************
MacroScript TrackView_Selected
	ButtonText:~TRACKVIEW_SELECTED_BUTTONTEXT~ 
	Category:~TRACKVIEW_SELECTED_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~TRACKVIEW_SELECTED_TOOLTIP~ 
	Icon:#("TrackViewTools",23)
(
	fn TrackSel = 
	(
		
		TrackView.Open ~TRACKVIEW_OPEN_SELECTED_CAPTION~
		TrackView.setFilter ~TRACKVIEW_SETFILTER_CAPTION~ #modifiedObjects #SelectedObjects #curveX #curveY #curveZ #Objects #Hierarchy #Transforms #Position #Rotation #Scale #positionX #positionY #positionZ #rotationX #rotationY #rotationZ #scaleX #scaleY #scaleZ
		TrackView.zoomSelected ~TRACKVIEW_ZOOMSELECTED_CAPTION~
	)
	
	fn CloseTrackSel =
	(
		for t in 1 to Trackview.NumTrackViews() do
		(
			If Trackview.GetTrackviewName T == ~TRACKVIEW_GETTRACKVIEWNAME_CAPTION~ then
			(
				TrackView.Close ~TRACKVIEW_CLOSE_SELECTED_CAPTION~
 			)
			Else
			(
			)
		)
	)

	On IsVisible return selection.count != 0
	On IsEnabled return selection.count != 0
	On Execute do
	(
		(
			CloseTrackSel ()
			TrackSel ()
			TrackView.zoomSelected Selection[1].name
		)
	)

)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Toggle_Keyable_Icons
	ButtonText:~TOGGLE_KEYABLE_ICONS_BUTTONTEXT~ 
	Category:~TOGGLE_KEYABLE_ICONS_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~TOGGLE_KEYABLE_ICONS_TOOLTIP~ 
	iconName:"TrackView/DopeSheet/ShowKeyableIcons"
(
    on execute do (trackviews.current.ui.showKeyableIcons = not trackviews.current.ui.showKeyableIcons)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.ui.showKeyableIcons
		else false
	)
)--end macro



-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Toggle_Unlocked_Icons
	ButtonText:~TOGGLE_UNLOCKED_ICONS_BUTTONTEXT~ 
	Category:~TOGGLE_UNLOCKED_ICONS_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~TOGGLE_UNLOCKED_ICONS_TOOLTIP~ 
	Icon:#("TrackViewTools",117)
(
    on execute do (trackviews.current.ui.showUnlockedIcons = not trackviews.current.ui.showUnlockedIcons)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.ui.showUnlockedIcons
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Toggle_Custom_Icons
	ButtonText:~TOGGLE_CUSTOM_ICONS_BUTTONTEXT~ 
	Category:~TOGGLE_CUSTOM_ICONS_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~TOGGLE_CUSTOM_ICONS_TOOLTIP~ 
(
    on execute do (trackviews.current.ui.showCustomIcons = not trackviews.current.ui.showCustomIcons)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.ui.showCustomIcons
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Toggle_Modify_Children
	ButtonText:~TOGGLE_MODIFY_CHILDREN_BUTTONTEXT~ 
	Category:~TOGGLE_MODIFY_CHILDREN_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~TOGGLE_MODIFY_CHILDREN_TOOLTIP~ 
	iconName:"TrackView/DopeSheet/ModifyChildKeys"
(
    on execute do (trackviews.current.modifyChildren = not trackviews.current.modifyChildren)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.modifyChildren
		else false
	)
	on isVisible do 
	(
		if trackviews.current != undefined 
		then trackviews.current.editMode != #editFCurves
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Use_SoftSelect
	ButtonText:~USE_SOFTSELECT_BUTTONTEXT~ 
	Category:~USE_SOFTSELECT_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~USE_SOFTSELECT_TOOLTIP~ 
(
	on execute do 
	(
		if trackviews.current != undefined do
		( 
			trackviews.current.useSoftSelect = not trackviews.current.useSoftSelect
		)
	)
	on isChecked do 
	(
		if trackviews.current != undefined 
		then trackviews.current.useSoftSelect
		else false
	)
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript SoftSelect_Settings
	ButtonText:~SOFTSELECT_SETTINGS_BUTTONTEXT~ 
	Category:~SOFTSELECT_SETTINGS_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~SOFTSELECT_SETTINGS_TOOLTIP~ 
(
	on execute do 
	(
		tv = trackviews.current
		if tv != undefined do
		(
			tv.launchUtility ~TV_LAUNCHUTILITY_CAPTION~
		)
	)
	on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************

MacroScript Maximize_Trackbar
	ButtonText:~MAXIMIZE_TRACKBAR_BUTTONTEXT~ 
	Category:~MAXIMIZE_TRACKBAR_CATEGORY~ 
	internalCategory:"Track View" 
	Tooltip:~MAXIMIZE_TRACKBAR_TOOLTIP~ 
	IconName:"StatusBar/TrackBar/Maximize"
(
   on execute do with redraw off
   (
	   if timeslider.isvisible() == true then 
	   	(
			if (trackviews.open ~TRACKVIEWS_OPEN_TRACKBAR_CAPTION~ layoutName:~LAYOUTNAME_TRACKBAR_LAYOUT~ dock:#bottom height:170) do
			   (
		  	   maxIni = (GetMAXIniFile())--pfb removed hardcoded access to 3dsmax.ini		
			   iniState = getFileAttribute maxIni #readOnly
			   setFileAttribute maxIni #readOnly true
			   maxOps.trackbar.visible = false
			   timeSlider.SetVisible false
			   setFileAttribute maxIni #readOnly iniState
			   )
		)
		Else 
		(
 		   trackviews.close ~TRACKVIEWS_CLOSE_TRACKBAR_CAPTION~
		   maxIni = (GetMAXIniFile())--pfb : removed hardcoded access to 3dsmax.ini
		   iniState = getFileAttribute maxIni #readOnly
		   setFileAttribute maxIni #readOnly true
		   maxOps.trackbar.visible = true
		   timeSlider.SetVisible true
		   setFileAttribute maxIni #readOnly iniState
  		)
   )
   on isChecked return false
)--end macro

-------------------------------------------------------------------------------------------------------------
--***********************************************************************************************************


/*
/********************************************************************************
Macro Script to collapse the current trackview selection to keyframe controllers.
This will turn any procedural controller into a keyframed controller. 
Options:
Start Frame
End Frame
Samples (displayed in frames)
New Controller type
Add to new layer (keeps the original controller stored on a layer with a weight of 0)
Written by Discreet Staff (02/25/02)

Revision History:
		11 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macroscript file can be shared with all Discreet products



Modify at your own risk
-- ********************************************************************************
*/
macroScript collapseController
category:~COLLAPSECONTROLLER_CATEGORY~
internalCategory:"Track View" 
toolTip:~COLLAPSECONTROLLER_TOOLTIP~
buttonText:~COLLAPSECONTROLLER_BUTTONTEXT~
(
	on isEnabled do
	(
		local res = false
 		if trackviews.current != undefined do 
		(
			local parentTracks = #()
			local subNums = #()
			for i in 1 to trackviews.current.numSelTracks() while not res do
			(
				local p = trackviews.current.getParentOfSelected i
				-- if locked don't even put into list
				if p != undefined do
				(
					local subnum  = trackviews.current.getSelectedSubNum i
					local subanim = getsubAnim p subnum
					if lockedTracksMan.getlocked subanim p subnum true == false do
					(
						local tmpController
						if subanim != undefined do 
						(
							tmpController = subanim.controller
						)
						if (isController tmpController) == true do
						(
							if (classof tmpController != Biped_SubAnim and classof p != Biped_SubAnim) do res = true
						)
					)
				)
			)
		)
		res
	)
	
	on execute do
	(
		global rltCollapseControllerSetup, collapseController2Controller, collapseController2EulerController

		fn collapseController2EulerController ControllerFrom ControllerTo Start End Samples =
		(
			-- function handles everything in ticks, to ensure flexibility and precision
			local starttick = start*ticksPerFrame, endtick = end*ticksPerFrame, sampletick = samples*ticksPerFrame
			for i in starttick to endtick by sampletick do
			(
				t = ((i/ticksPerFrame) as time)
				tmpXKey = addNewKey controllerTo[1].controller t
				tmpXKey.value = at time t (QuatToEuler controllerFrom.value).x
				tmpYKey = addNewKey controllerTo[2].controller t
				tmpYKey.value = at time t (QuatToEuler controllerFrom.value).y
				tmpZKey = addNewKey controllerTo[3].controller t
				tmpZKey.value = at time t (QuatToEuler controllerFrom.value).z
				
			) -- end for
			controllerTo
		) -- end fn collapseController2EulerController
		
		fn collapseController2Controller ControllerFrom ControllerTo Start End Samples =
		(
			if (Classof controllerTo) == Euler_XYZ do
			(
				return (collapseController2EulerController ControllerFrom ControllerTo Start End Samples)
			) -- end if
			-- function handles everything in ticks, to ensure flexibility and precision
			local starttick = start*ticksPerFrame, endtick = end*ticksPerFrame, sampletick = samples*ticksPerFrame
			for i in starttick to endtick by sampletick do
			(
				tmpKey = addNewKey controllerTo ((i/ticksPerFrame) as time)
				tmpKey.value = at time ((i/ticksPerFrame) as time) controllerFrom.value
				
			) -- end for
			controllerTo
		) -- end fn collapseController2Controller
		
		rollout rltCollapseControllerSetup ~COLLAPSECONTROLLER_CAPTION~ width:~COLLAPSECONTROLLER_WIDTH~ height:171
		(
		
			spinner spnStart ~SPNSTART_FRAME_CAPTION~ pos:[28,7] width:111 height:16 range:[-100000,100000,0] fieldwidth:45
			spinner spnEnd ~SPNEND_FRAME_CAPTION~ pos:[31,28] width:108 height:16 range:[-100000,100000,100] fieldwidth:45
			spinner spnSamples ~SPNSAMPLES_CAPTION~ pos:[42,49] width:97 height:16 range:[0,1000,1] fieldwidth:45
			label lbSampleUnits ~LBSAMPLEUNITS_CAPTION~ pos:[146,50] width:~LBSAMPLEUNITS_WIDTH~ height:13
			radiobuttons rbType ~RBTYPE_COLLAPSE_TO_CAPTION~ pos:~RBTYPE_POSITION~ width:138 height:46 labels:#(~BEZIER_OR_EULER_CONTROLLER~, ~LINEAR_OR_TCB_CONTROLLER~) columns:1
			checkbox newLayer ~NEWLAYER_CAPTION~ pos:[15,119] width:~NEWLAYER_WIDTH~ height:15
			button btnOK ~BTNOK~ pos:[15,143] width:65 height:21 across:2
			button btnCancel ~BTNCANCEL~ pos:[83,143] width:65 height:21
				
			on rltCollapseControllerSetup open do
			(
				controllerRange = animationRange
				
				if trackviews.current != undefined AND trackviews.current.numSelTracks() == 1 do
				(
					local tmpController = trackviews.current.getSelected 1
					if (isController tmpController) == true do
					(
						controllerRange = getTimeRange tmpController
						-- There's a bug in PositionXYZ. It does not return the ranges from the children controllers, so it's very tough to collapse them...
						if (controllerRange.start as integer)/ticksPerFrame == -13421772 do controllerRange = animationRange
					)
				)
				
				spnStart.value = controllerRange.start
				spnEnd.value = controllerRange.end
				
			)
			on btnOK pressed do
			(
				if spnSamples.value == 0.0 do 
				(
					destroyDialog rltCollapseControllerSetup
					return()
				)
					
				local parentTracks = #()
				local subNums = #()
				for i in 1 to trackviews.current.numSelTracks() do
				(
					local p = trackviews.current.getParentOfSelected i
					
					-- if locked don't even put into list
					if p != undefined  do
					(
						local subnum  = trackviews.current.getSelectedSubNum i
					    local subanim = getsubAnim p subnum
						if lockedTracksMan.getlocked subanim p subnum true == false do
						(
							append parentTracks p
							append subNums (subnum)
						)
					)
				)
				
				for i in 1 to parentTracks.count do
				(
					local parentTrack = parentTracks[i]
					if parentTrack != undefined and classof parentTrack != Biped_SubAnim do
					(	
						local subAnimNum = subNums[i]
						local subAnim = getSubAnim parentTrack subAnimNum
						local oldController
						if subAnim != undefined do
 							oldController = subAnim.controller
						-- superclassof Biped_SubAnim incorrectly reports FloatController, exclude
						if (classof oldController == Biped_SubAnim) do oldController = undefined 
						local listController = undefined
						local newController = undefined
						case superClassof oldController of
						(
							PositionController:
							(
								case rbType.state of
								(
									1:	newController = Bezier_Position()
									2:	newController = Linear_Position()
								)
								if newLayer.checked == true and (classof parentTrack) != Position_List do
									( listController = Position_List() )
							)
							FloatController:
							(
								case rbType.state of
								(
									1:	newController = Bezier_Float()
									2:	newController = Linear_Float()
								)
								if newLayer.checked == true and (classof parentTrack) != Float_List do
									( listController = Float_List() )
							)
							Point3Controller:
							(
								case rbType.state of
								(
									1:	newController = Bezier_Point3()
									2:	newController = Bezier_Point3()
								)
								if newLayer.checked == true and (classof parentTrack) != Point3_List do
									( listController = Point3_List() )
							)
							RotationController:
							(
								case rbType.state of
								(
									1:	newController = Euler_XYZ()
									2:	newController = TCB_Rotation()
								)
								if newLayer.checked == true and (classof parentTrack) != Rotation_List do
									( listController = Rotation_List() )
							)
							ScaleController:
							(
								case rbType.state of
								(
									1:	newController = Bezier_Scale()
									2:	newController = Linear_Scale()
								)
								if newLayer.checked == true and (classof parentTrack) != Scale_List do
									( listController = Scale_List() )
							)
						) -- end superclass case
						if newController != undefined do try
						(
							Undo ~UNDO_COLLAPSECONTROLLER_CAPTION~ On 
							(
								if newLayer.checked == true then 
								(						
									local index = 0
									if listController == undefined then 
									(
										listController = parentTrack
										index = subAnimNum
									)
									else 
									(
										subAnim.controller = listController
										index = listController.count
									)
										
									listController.weights[index].value = 0.0
									listController.setName index ((listController.getName index) + ~LISTCONTROLLER_SETNAME_INDEX~)
									listController[listController.count+1].controller = newController
									listController.setActive listController.count
								)
								else 
								(
									subAnim.controller = newController
								)
								newController = collapseController2Controller oldController newController spnStart.value spnEnd.value spnSamples.value
							)
						)
						catch(format ~FORMAT_FAILURE_REPLACING_SUBANIM_CAPTION~ i parentTrack oldController )
					)
				)
				destroyDialog rltCollapseControllerSetup
			)
			on btnCancel pressed do
				destroyDialog rltCollapseControllerSetup
		)
		
		if trackviews.current != undefined then
		(
			createDialog rltCollapseControllerSetup modal:false parent:trackviews.current.ui.hwnd
		)
		else
		(
			createDialog rltCollapseControllerSetup modal:false
		)
			
	) -- end Execute

) -- end Macro




/*
/********************************************************************************
Macro Script to enable an animation layer over the trackview selection.
Written by Michael Zyracki (03/15/06)




Modify at your own risk
-- ********************************************************************************
*/
macroScript enableAnimLayer
category:~ENABLEANIMLAYER_CATEGORY~
internalCategory:"Track View" 
toolTip:~ENABLEANIMLAYER_TOOLTIP~
buttonText:~ENABLEANIMLAYER_BUTTONTEXT~
(
	on isEnabled do
	(
		local res = false
 		if trackviews.current != undefined do 
		(
			local parentTracks = #()
			local subNums = #()
			for i in 1 to trackviews.current.numSelTracks() while not res do
			(
				local p = (trackviews.current.getParentOfSelected i)
				if p != undefined do 
				(
					local subAnimNum = (trackviews.current.getSelectedSubNum i)
					local subAnim = getSubAnim p subAnimNum
					if(AnimLayerManager.canEnableLayer subAnim p subAnimNum) == true do res = true
				)
			)
		)
		res
	)
	
	on execute do
	(
		if trackviews.current != undefined do 
		(
			for i in 1 to trackviews.current.numSelTracks() do
			(
				local p = (trackviews.current.getParentOfSelected i)
				if p != undefined do 
				(
					local sub = (trackviews.current.getSelectedSubNum i)
					local ani = getSubAnim p sub
					AnimLayerManager.enableLayer ani p sub
				)
			)
			
		)
			
	) -- end Execute

) -- end Macro




/********************************************************************************
Macro Script to save animation from the trackview selection.
Written by Michael Zyracki (10/25/06)

Modify at your own risk
-- ********************************************************************************
*/

macroScript saveAnimationTrackView
category:~SAVEANIMATIONTRACKVIEW_CATEGORY~
internalCategory:"Track View" 
toolTip:~SAVEANIMATIONTRACKVIEW_TOOLTIP~
buttonText:~SAVEANIMATIONTRACKVIEW_BUTTONTEXT~
(
	on isEnabled do
	(
		(trackviews.current != undefined and (trackviews.current.numSelTracks() > 0))
	)
	
	on execute do
	(
		if trackviews.current != undefined do 
		(
			local anims = #()
			local parentTracks = #()
			local subNums = #()
			for i in 1 to trackviews.current.numSelTracks() do
			(
				local p = (trackviews.current.getParentOfSelected i)
				if p != undefined do 
				(
					append anims (trackviews.current.getSelected i)
					append parentTracks p
					append subNums (trackviews.current.getSelectedSubNum i)
				)
			)
			loadSaveAnimation.saveAnimationDlgFromAnims anims parentTracks subNums
		)
			
	) -- end Execute

) -- end Macro



/********************************************************************************
Macro Script to load animation into the trackview selection.
Written by Michael Zyracki (10/25/06)

Modify at your own risk
-- ********************************************************************************
*/

macroScript loadAnimationTrackView
category:~LOADANIMATIONTRACKVIEW_CATEGORY~
internalCategory:"Track View" 
toolTip:~LOADANIMATIONTRACKVIEW_TOOLTIP~
buttonText:~LOADANIMATIONTRACKVIEW_BUTTONTEXT~
(
	on isEnabled do
	(
		(trackviews.current != undefined and (trackviews.current.numSelTracks() > 0))
	)
	
	on execute do
	(
	
		if trackviews.current != undefined do 
		(
			local anims = #()
			local parentTracks = #()
			local subNums = #()
			for i in 1 to trackviews.current.numSelTracks() do
			(
				local p = (trackviews.current.getParentOfSelected i)
				if p != undefined do 
				(
					append anims (trackviews.current.getSelected i)
					append parentTracks p
					append subNums (trackviews.current.getSelectedSubNum i)
				)
			)
			loadSaveAnimation.loadAnimationDlgFromAnims anims parentTracks subNums
		)
			
	) -- end Execute

) -- end Macro



/********************************************************************************
Macro Script to set locks on tracks.
Written by Michael Zyracki (08/05/08)

Modify at your own risk
-- ********************************************************************************
*/

macroScript lockTracksTrackView 
category:~LOCKTRACKSTRACKVIEW_CATEGORY~
internalCategory:"Track View" 
toolTip:~LOCKTRACKSTRACKVIEW_TOOLTIP~
buttonText:~LOCKTRACKSTRACKVIEW_BUTTONTEXT~
(
	on isEnabled do
	(
		(trackviews.current != undefined and (trackviews.current.numSelTracks() > 0))
	)
	
	on execute do
	(
	
		if trackviews.current != undefined do 
		(
			local anims = #()
			local parentTracks = #()
			local subNums = #()
			for i in 1 to trackviews.current.numSelTracks() do
			(
				local p = (trackviews.current.getParentOfSelected i)
				if p != undefined do 
				(
					append anims (trackviews.current.getSelected i)
					append parentTracks p
					append subNums (trackviews.current.getSelectedSubNum i)
				)
			)
			lockedTracksMan.SetLocks true anims parentTracks subNums true
		)
			
	) -- end Execute

) -- end Macro

/********************************************************************************
Macro Script to turn off locks on tracks.
Written by Michael Zyracki (08/05/08)

Modify at your own risk
-- ********************************************************************************
*/

macroScript unLockTracksTrackView
category:~UNLOCKTRACKSTRACKVIEW_CATEGORY~
internalCategory:"Track View" 
toolTip:~UNLOCKTRACKSTRACKVIEW_TOOLTIP~
buttonText:~UNLOCKTRACKSTRACKVIEW_BUTTONTEXT~
(
	on isEnabled do
	(
		(trackviews.current != undefined and (trackviews.current.numSelTracks() > 0))
	)
	
	on execute do
	(
	
		if trackviews.current != undefined do 
		(
			local anims = #()
			local parentTracks = #()
			local subNums = #()
			for i in 1 to trackviews.current.numSelTracks() do
			(
				local p = (trackviews.current.getParentOfSelected i)
				if p != undefined do 
				(
					append anims (trackviews.current.getSelected i)
					append parentTracks p
					append subNums (trackviews.current.getSelectedSubNum i)
				)
			)
			lockedTracksMan.SetLocks false anims parentTracks subNums false
		)
			
	) -- end Execute

) -- end Macro



/********************************************************************************
Macro Script to turn override locks on tracks
Written by Michael Zyracki (08/31/08)

Modify at your own risk
-- ********************************************************************************
*/

macroScript overrideLocksTrackView
category:~OVERRIDELOCKSTRACKVIEW_CATEGORY~
internalCategory:"Track View" 
toolTip:~OVERRIDELOCKSTRACKVIEW_TOOLTIP~
buttonText:~OVERRIDELOCKSTRACKVIEW_BUTTONTEXT~
(

	on isChecked do 
	(
		lockedTracksMan.unLockOverride
		
	)
		
	on execute do
	(
		lockedTracksMan.unLockOverride = not lockedTracksMan.unLockOverride
	
					
	) -- end Execute

) -- end Macro


/********************************************************************************
Macro Script to Expose component tracks from Track View.
Written by Richard Laperriere (08/09/20)

Modify at your own risk
-- ********************************************************************************
*/

macroScript exposeTracksTrackView 
category:~EXPOSETRACKSTRACKVIEW_CATEGORY~
internalCategory:"Track View" 
toolTip:~EXPOSETRACKSTRACKVIEW_TOOLTIP~
buttonText:~EXPOSETRACKSTRACKVIEW_BUTTONTEXT~
(
	on isEnabled do
	(
		(trackviews.current != undefined and (trackviews.current.numSelTracks() > 0))
	)
	
	on execute do
	(
	
		if trackviews.current != undefined do 
		(
			local anims = #()
			for i in 1 to trackviews.current.numSelTracks() do
			(
				append anims (trackviews.current.getSelected i)
			)
			lockedTracksMan.SetExposedUI true anims
		)
			
	) -- end Execute

) -- end Macro

/********************************************************************************
Macro Script to Unexpose/conceal component tracks from Track View.
Written by Richard Laperriere (08/09/20)

Modify at your own risk
-- ********************************************************************************
*/

macroScript Conceal
category:~CONCEAL_CATEGORY~
internalCategory:"Track View" 
toolTip:~CONCEAL_TOOLTIP~
buttonText:~CONCEAL_BUTTONTEXT~
(
	on isEnabled do
	(
		(trackviews.current != undefined and (trackviews.current.numSelTracks() > 0))
	)
	
	on execute do
	(
	
		if trackviews.current != undefined do 
		(
			local anims = #()
			for i in 1 to trackviews.current.numSelTracks() do
			(
				append anims (trackviews.current.getSelected i)
			)
			lockedTracksMan.SetExposedUI false anims
		)
			
	) -- end Execute

) -- end Macro


/********************************************************************************
Macro Script to unlock leaves
Written by Michael Zyracki

Modify at your own risk
-- ********************************************************************************
*/



macroScript UnlockLeaves
category:~UNLOCKLEAVES_CATEGORY~
internalCategory:"Track View" 
toolTip:~UNLOCKLEAVES_TOOLTIP~
buttonText:~UNLOCKLEAVES_BUTTONTEXT~
(
	
	on isEnabled do
	(
		(trackviews.current != undefined and (trackviews.current.numSelTracks() > 0))
	)
	
	on execute do
	(
	
		if trackviews.current != undefined do 
		(
			local anims = #()
			local parentTracks = #()
			local subNums = #()
			for i in 1 to trackviews.current.numSelTracks() do
			(
				local p = (trackviews.current.getParentOfSelected i)
				if p != undefined do 
				(
					append anims (trackviews.current.getSelected i)
					append parentTracks p
					append subNums (trackviews.current.getSelectedSubNum i)
				)
			)
			lockedTracksMan.UnlockChildren anims parentTracks subNums
		)
			
	) -- end Execute


) -- end Macro


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAeOYduegdPnArIkGDkueNE/d22uam4OLCU
-- +tp1I6U1AdY5IBnNLRNdMyoDmr8YHsZ4cVfTl8v0WS+ngb6ZMF2DAPV/hhD0pDPT
-- 9rAi3lzPdzjisfDdxtNfTlD2u6pcw/Cfyxbo2L0CnAvKpB4RYh9vuhHh9zgGvy0k
-- bm51eqDytKsbDKvfeBYebB8xk4B6wyWUu/Kz687B4lqBMCvCIBDQQwQAVdeHr8ml
-- TnX2JNGf6ysSI74ACEeDSKj444N+E12xbgNOf2zCjI1D8+zKaMu5mSOmlPvohQz5
-- 3EP2lIrz6IWKocaIKXYfs4ww2XHWL38gkSjsnnY9dPnOqkWJKwLB
-- -----END-SIGNATURE-----