--//////////////////////////////////////////////////////////////////////////////////////////////////////
/*


Create/set project struture  macro

	by pfbreton, David Cunningham, 2006, 3ds max 9
	
	1.	User invokes the Set Project Folder command.
	2.	He his provided with a Browse for Folder dialog and selects a folder.
	3.  The current Path Configuration are backup'ed in the current working folder
	4.	The working directory is changed to the selected directory.
	5.	If the folder contains a *.mxp file, the first *.mxp file is loaded.
	6.	If not, a warning message is displayed

*/
--//////////////////////////////////////////////////////////////////////////////////////////////////////
macroScript SetProjectFolder
	category:~SETPROJECTFOLDER_CATEGORY~ 			-- LOC Notes: Localize this 
	internalCategory:"Tools" 
	tooltip:~SETPROJECTFOLDER_TOOLTIP~				-- LOC Notes: Localize this 
	ButtonText:~SETPROJECTFOLDER_BUTTONTEXT~ 			-- LOC Notes: Localize this 
	icon:#("SetProjectFolder", 1)
(
	-- following 2 variables must be global. They are set by the c++ code that implements pathConfig.doProjectSetupStepsUsingDirectory
	global _SetProjectFolder_macro_option_promptUser
	global _SetProjectFolder_macro_option_newFolder
	On Execute Do	
	(
		--------------------------------
		--Browse for folder dialog
		--------------------------------
		local strMyFolder= ""
		local strCurrProjectFolder = pathconfig.getCurrentProjectFolder()
		if( _SetProjectFolder_macro_option_promptUser == undefined  or  -- the value hasn't been defined, default to prompt user
			_SetProjectFolder_macro_option_promptUser == true) then
		(
			strMyFolder = getSavePath caption:~SETPROJECTFOLDER_CAPTION~ \
								 initialDir:(strCurrProjectFolder) -- LOC Notes: Localize this 
		)
		else
		(
			-- we use the global value set from within the app
			strMyFolder = _SetProjectFolder_macro_option_newFolder
		)
		-- always default to prompt the user
		_SetProjectFolder_macro_option_promptUser = true

		--user selected a valid folder
		if (strMyFolder != undefined) and (strMyFolder != "") then  
		(		
			-----------------------------------------------
			--does a selected folder contains *.mxp files?
			-----------------------------------------------
			doesFolderExist = doesFileExist strMyFolder allowDirectory:true
			if(doesFolderExist and pathconfig.IsProjectFolder(strMyFolder)) then 
			(
				-----------------------------------------------
				-- backup the current config paths settings in the current working folder 
				-- to not lose possible modifications that might have been done
				-- before switching the working folder
				-----------------------------------------------
				pathconfig.SaveTo(pathconfig.getCurrentProjectFolderPath())

				pathconfig.setCurrentProjectFolder strMyFolder
			
				arStrFnames = getfiles (strMyFolder + "\\*.mxp") -- LOC Notes: Do Not Localize this 
			
				--Warns the user about the fact that the folder contains 
				--more than one *.mxp file: assumes that the first found is used.
				if (arStrFnames.count != 1) then
				(
					if (GetQuietMode() == false) then
					(
						messagebox (~FOLDER_CONTAINS_MORE_THAN_ONE_CONFIG_FILE_CAPTION~ + arStrFnames[1] + ~WILL_BE_USED_TO_DETERMINE_YOUR_PATHS_CONFIGURATION_CAPTION~) title:~SET_PROJECT_FOLDER_TITLE~ beep:false -- LOC Notes: Localize this 
					)
				)
				
				--loads the MXP file
				pathconfig.load(arStrFnames[1])
			)
			else
			(
				------------------------------------------------------------------
				--No MXP file exists.
				------------------------------------------------------------------
				if (GetQuietMode() == false) then
				(		
					messagebox (~FOLDER_DOES_NOT_CONTAIN_PROJECT~) title:~FOLDER_NAME_INVALID_TITLE~ beep:false -- LOC Notes: Localize this 
				)
			)
		) 
		else if (strMyFolder == "") then
		(
			--user selected an invalide folder
			if (GetQuietMode() == false) then
			(			
				messagebox (~FOLDER_NAME_IS_INVALID_CAPTION~) title:~FOLDER_NAME_IS_INVALID_TITLE~ beep:false -- LOC Notes: Localize this 
			)
		)
		-- user canceled, do nothing.	
	)
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAGrAo1ah1EkVf0+msC3JVT+kj1CSBUPZHh
-- yA+ib6tYH3TtpfgcDNwW+867X/eiTCFpObCoxbNDnaIqcctaTr7QBvXrcXEaXSQo
-- KamK/Za0SvqhftewaQlAqYuC+MnGj/zzo3z4ehYdEewr+LGrq1MBHkyFvCBIn0Zv
-- aXfM2YN9zA07yZgkS1l5lRxWCsPq82pgwnEBEJ//mJQRpIXgyoSe7wtZFrEcGkX0
-- H+jF7Hgu/UcFndI+PFaUUGQhQe//SpWNp7YvpoJ7dD5Bg3vKq5RSziLyoo2NCkB1
-- FthOeu1qQWNFN428J797PjDy9URTIpvlGoLOETs3zhBvxET5WZCa
-- -----END-SIGNATURE-----