macroScript SESelectChildren
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_SELECT_CHILDREN_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_SELECT_CHILDREN~ --LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)
	
	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.SelectChildren()
	)
)

macroScript SEExpandAll
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_EXPAND_ALL_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_EXPAND_ALL~ --LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.ExpandAll()
	)
)

macroScript SEExpandSelected
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_EXPAND_SELECTED_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_EXPAND_SELECTED~ --LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.ExpandSelected()
	)
)

macroScript SECollapseAll
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_COLLAPSE_ALL_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_COLLAPSE_ALL~ --LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.CollapseAll()
	)
)

macroScript SECollapseSelected
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_COLLAPSE_SELECTED_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_COLLAPSE_SELECTED~ --LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.CollapseSelected()
	)
)

macroScript SERemoveEmptyLayers
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_CLEAR_EMPTY_LAYERS_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_CLEAR_EMPTY_LAYERS~ --LOC_NOTES: localize this
(	
	on isVisible do	(	
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
		)
	
	on isEnabled do 	(	
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
		)

	on execute do
	(
		local xx
		local nbDeleted = 0
		local message = ""
		rootLayers = for i = 1 to layermanager.count where (xx = layermanager.getlayer (i-1); xx.getparent() == undefined) collect xx
		for layer in rootLayers do (nbdeleted += layermanager.deleteLayerHierarchy layer.name)
		
		if (nbDeleted == 0) then 
			message = ~SEQ_NO_LAYER_CLEARED~
		
		if (nbDeleted == 1) then
			message = nbDeleted as string + ~SEQ_ONE_LAYER_CLEARED~
		
		if (nbDeleted > 1) then
			message = nbDeleted as string + ~SEQ_MULTI_LAYERS_CLEARED~
			
		TipSystem.ShowTip 5000 message 0.5 0.5 (SceneExplorerManager.GetActiveExplorerHwnd())
	)
)

macroScript SEDeleteLayerAndChildren
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEC_DELETE_ALL_CHILD_TT~ --LOC_NOTES: localize this
	ButtonText:~SEC_DELETE_ALL_CHILD~ --LOC_NOTES: localize this
(	
	fn IsLayer item = ( classof item == Base_LayerBase_Layer)
	fn getAllLayerNodes layer layerArray nodeArray =
	(
		if(layer==undefined) then return false
		--get nodes from current layer
		layerObj = iLayerManager.getLayerObject layer.name
		nodes = refs.dependents layerObj
			join nodeArray nodes
			append layerArray layer
		
		--recursively get nodes for children layers
			for i=1 to layer.getNumChildren() do(
				getAllLayerNodes (layer.GetChild i ) layerArray nodeArray
			)
		)
	on isVisible do	(	
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
		)
	
	on isEnabled do 	(	
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
		)

	on execute do
	(
		local	sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		local layers=#()
		local layerNodes=#()
		--get all layers and nodes on these layers
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (isLayer item) then
			(
				getAllLayerNodes item layers layerNodes
			)
			else
			(
				append layerNodes item
			)
		)
		
		--delete all layer nodes (note that it's possible that layerNodes contain duplicates but this is handled via isValidNode)
		for objectnode in layerNodes where (isValidNode objectnode ) do 
			(
				delete objectnode
			)
				
		--delete all layers (they should be empty now)
		for layer in layers do (layermanager.deleteLayerHierarchy layer.name)

	)
)

macroScript SESelectObjectFromSelectedLayer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_SELECT_OBJECT_FROM_LAYERS_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_SELECT_OBJECT_FROM_LAYERS~ --LOC_NOTES: localize this
(	
	fn IsLayer item = ( classof item == Base_LayerBase_Layer)
	
	on isVisible do	(	
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
		)
	
	on isEnabled do 	(	
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		layerSelected = false
		if (sceneExplorerInstance != undefined) then
			for item in sceneExplorerInstance.selectedItems() where (isLayer item) do 
			(
				layerSelected = true
				exit
			)

		return layerSelected 
		)

	on execute do
	(
		local	sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (isLayer item) then
			(
				item.select true
			)
		)
	)
)

macroScript SEInvertFilters
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_INVERT_FILTERS_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_INVERT_FILTERS~ --LOC_NOTES: localize this

(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.InvertDisplay()
	)
)

macroScript SERename
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_RENAME_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_RENAME~ --LOC_NOTES: localize this
(	
	fn IsLayer item = ( classof item == Base_LayerBase_Layer)
	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		
		local hasLayers = false
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (IsLayer item) then
			(		
				if (SceneExplorerManager.IsDefaultLayer item) or item.hasSceneXRefNodesInHierarchy() then
				(
					return false;
				)
				hasLayers = true
			)
		)
			
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count == 1 or (count > 1 and not hasLayers) )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance != undefined) do
		(
			if (sceneExplorerInstance.SelectedItemCount() > 1) then
				macros.run "Tools" "RenameObjects"
			else
				sceneExplorerInstance.Rename()		
		)
	)
)

macroScript SEUnlink
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_UNLINK_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_UNLINK~ --LOC_NOTES: localize this

(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined or sceneExplorerInstance.IsLayerView()) then return false
		local count = sceneExplorerInstance.SelectedItemCount onlyMaxNodes:true
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.Unlink()
	)
)

macroScript SEDelete
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_DELETE_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_DELETE~ --LOC_NOTES: localize this
(	
	fn IsLayer item = ( classof item == Base_LayerBase_Layer)
	
	on isVisible do	
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)	
	
	on isEnabled do 	
	(		
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local selectedItems = sceneExplorerInstance.SelectedItems()
		
		local hasDeletableLayers = false
		local hasNonDeletableLayers = false
		local hasNodes = false
		for item in selectedItems while not hasNonDeletableLayers do 
		(
			if (IsLayer item) then 
			(
				if item.canDelete() then
					hasDeletableLayers = true
				else
					hasNonDeletableLayers = true
			)
			else
				hasNodes = true
		)		
		return (hasNodes or hasDeletableLayers) and not hasNonDeletableLayers
	)
	
	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		local selectedNodes = #()
		local selectedLayers = #()
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (IsLayer item) then 
			(
				if item.canDelete() then
					append selectedLayers item
			)
			else			
			(
				append selectedNodes item
			)
		)
		if (selectedNodes.Count > 0) then
		(
			delete selectedNodes
		)
		for layer in selectedLayers do 
		(
			LayerManager.deleteLayerByName layer.name
		)
	)
)

macroScript SECreateLayer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_CREATE_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_CREATE~ --LOC_NOTES: localize this
(	
	fn IsLayer item = ( classof item == Base_LayerBase_Layer)
	
	on isVisible do	
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)	
	
	on isEnabled do 	
	(		
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (IsLayer item) then
			(		
				if (SceneExplorerManager.IsDefaultLayer item) or item.hasSceneXRefNodesInHierarchy() then
				(
					return false;
				)				
			)
		)
		
		return true;
	)
	
	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.CreateNewLayer()
	)
)

macroScript SEProperties
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_PROPERTIES_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_PROPERTIES~ --LOC_NOTES: localize this
(	
	fn IsLayer item = ( classof item == Base_LayerBase_Layer)
	
	on isVisible do	
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)	
	
	on isEnabled do 	
	(		
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local selectedItems = sceneExplorerInstance.SelectedItems()
		valid = (	(sceneExplorerInstance != undefined) and ( selectedItems.Count > 0) )

		local nodeCount = 0
		local layerCount = 0
			
		for item in selectedItems while valid do 
		(
			if (IsLayer item) then 
			(
				layerCount += 1
			)
			else
			(
			    nodeCount += 1
			)
			if  ((nodeCount > 0) and (layerCount>0)) then
			(
				valid = false
			)
		)		
		return valid;
	)
	
	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		
		local nodeCount = 0
		local layerCount = 0
		local selectedLayers = #()
			
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (IsLayer item) then 
			(
				append selectedLayers item
				layerCount += 1
			)
			else
			(
			    nodeCount += 1
			)
		)		
		if  ((nodeCount > 0) and (layerCount>0)) then
		(
			return false
		)
		if  (nodeCount > 0) then
		(
			actionMan.executeAction 0 "40022" 
		)
		else
		(	
			layerManager.layerPropDialog selectedLayers
		)
	)
)

macroScript SEUnnest
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_UNNEST_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_UNNEST~ --LOC_NOTES: localize this
(	
	fn IsLayer item = ( classof item == Base_LayerBase_Layer)
	
	on isVisible do	
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (	sceneExplorerInstance != undefined )
	)	
	
	on isEnabled do 	
	(		
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined or not sceneExplorerInstance.IsLayerView()) then return false
		local selectedItems = sceneExplorerInstance.SelectedItems()
		valid = (	(sceneExplorerInstance != undefined) and ( selectedItems.Count > 0) )

		local layerCount = 0
		local parentCount = 0
			
		for item in selectedItems do 
		(
			if (IsLayer item) then 
			(
				if (SceneExplorerManager.IsDefaultLayer item) or item.hasSceneXRefNodesInHierarchy() then
				(
					valid = false
				)
				if (item.GetParent() != undefined) then
				(
					parentCount += 1
				)
				layerCount += 1
			)
		)
		
		return (valid and (layerCount > 0) and (parentCount > 0))
	)
	
	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
			
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (IsLayer item) then 
			(
				if (item.GetParent() != undefined) then
				(
					if not ((SceneExplorerManager.IsDefaultLayer item) or item.hasSceneXRefNodesInHierarchy() ) then
					(			
						item.SetParent undefined
					)
				)				
			)
		)					
	)
)

macroScript SEMakeDefault
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_MAKEDEFAULT_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_MAKEDEFAULT~ --LOC_NOTES: localize this
(	
	fn findExplorerIndex explo =
	(
		local index = -1
		for i = 1 to SceneExplorerManager.GetExplorerCount() do (
			local scnExpl = SceneExplorerManager.getexplorer (SceneExplorerManager.GetExplorerName i)
			if (scnExpl == explo) do
				index = i
		)
		index
	)

	on isVisible do	
	(
		return (SceneExplorerManager.GetActiveExplorer() != undefined)
	)	
	
	on isEnabled do 	
	(		
		return (SceneExplorerManager.GetActiveExplorer() != undefined)
	)
	
	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
					
		local cfgpath = pathConfig.GetDir #plugcfg
		cfgpath = pathConfig.appendPath cfgpath "ExplorerConfig\SceneExplorer"
		local fileName = "Default" + sceneExplorerInstance.Name + ".ini"
		local cfgfile = pathConfig.appendPath cfgpath fileName

		local fName = getSaveFileName filename:cfgfile caption:~SEQ_MAKEDEFAULT_TT~ types:~INI_FILES_TYPES~ historyCategory:~SEQ_MAKEDEFAULT~
		if fName != undefined then
		(
			SceneExplorerManager.SaveExplorerConfiguration sceneExplorerInstance.Name fName
		)
	)
)

macroScript SEFindSelected
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_FIND_SELECTED_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_FIND_SELECTED~ --LOC_NOTES: localize this

(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.FindSelected()
	)
)

macroScript SESelectLayerOfSelection
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_FIND_LAYER_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_FIND_LAYER~ --LOC_NOTES: localize this

(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		sceneExplorerInstance.SelectLayerOfSelection()
	)
)


macroScript SEUnfreezeSelected
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"		--LOC_NOTES: do not localize this
	toolTip:~SEQ_UNFREEZE_SELECTED_TT~		--LOC_NOTES: localize this
	ButtonText:~SEQ_UNFREEZE_SELECTED_TT~	--LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false

		local nodesToSelect = #()		
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (item.isfrozen) then (
				item.isfrozen = false
				if IsvalidNode item then append nodesToSelect item
			)
		)					
		-- resynch scene selection with explorer selection
		if nodesToSelect.count != 0 do selectmore nodesToSelect 	
	)
)

macroScript SEUnhideSelected
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"	--LOC_NOTES: do not localize this
	toolTip:~SEQ_UNHIDE_SELECTED_TT~	--LOC_NOTES: localize this
	ButtonText:~SEQ_UNHIDE_SELECTED_TT~	--LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		
		local nodesToSelect = #()		
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (item.ishidden) then (
				item.ishidden = false
				if IsvalidNode item then append nodesToSelect item
			)
		)					
		-- resynch scene selection with explorer selection
		if nodesToSelect.count != 0 do selectmore nodesToSelect 	
	)
)

macroScript SEFreezeSelected
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_FREEZE_SELECTED_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_FREEZE_SELECTED~ --LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
				
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			item.isfrozen = true
		)					
		-- unselect the now frozen objects in the scene
		sceneExplorerInstance.PushSelectionToScene()
	)
)

macroScript SEHideSelected
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_HIDE_SELECTED_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_HIDE_SELECTED~ --LOC_NOTES: localize this
(	
	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local count = sceneExplorerInstance.SelectedItemCount()
		return ( count > 0 )
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
				
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			item.ishidden = true
		)
		-- unselect the now hidden objects in the scene
		sceneExplorerInstance.PushSelectionToScene()
	)
)

macroScript SEAddNewLayer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_ADD_NEW_LAYER_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_ADD_NEW_LAYER~ --LOC_NOTES: localize this
(	
	fn IsLayer item = ( classof item == Base_LayerBase_Layer)

	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)
	
	on isEnabled do 	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
				
		local newLayer = LayerManager.newLayer()
		for item in sceneExplorerInstance.SelectedItems() do 
		(
			if (IsLayer item) then
			(
				if not item.hasSceneXRefNodesInHierarchy()  then
					item.setparent newLayer
			)
			else
			(		
				newLayer.addnode item 
			)
		)
	)
)

macroScript SEMergeLayers
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer" --LOC_NOTES: do not localize this
	toolTip:~SEQ_MERGE_LAYERS_TT~ --LOC_NOTES: localize this
	ButtonText:~SEQ_MERGE_LAYERS~ --LOC_NOTES: localize this
(	
	fn IsLayer item = ( classof item == Base_LayerBase_Layer)

	fn transferLayerContent fromLayer toLayer = (
		-- first step: transfer the nodes
		local fromLayerNodes = #()
		fromLayer.nodes &fromLayerNodes
		for node in fromLayerNodes do
			toLayer.addnode node

		-- second step: transfer child layers
		local toLayerIntf = getInterface toLayer.layerAsRefTarg "LayerProperties"
		if (toLayerIntf != undefined) then (
			local childLayerCount = fromLayer.getNumChildren()
			for i = childLayerCount to 1 by -1 do
			(
				local item = fromLayer.getChild i
				if (item != undefined) do (
					local fromChildLayerIntf = getInterface item.layerAsRefTarg "LayerProperties"
					if (fromChildLayerIntf != undefined and fromChildLayerIntf != toLayerIntf) do (
						fromChildLayerIntf.setparent toLayerIntf
					)
				)
			)
		)
	)

	on isVisible do	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		return (sceneExplorerInstance != undefined)
	)
	
	on isEnabled do 	(
		-- need two layers selected in the active explorer
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false
		local layerCount = 0
		local selectedItems = sceneExplorerInstance.SelectedItems()
		local selCount = selectedItems.Count
		for i = selCount to 1 by -1 do
		(
			local item = selectedItems[i]
			if (IsLayer item) then (
				layerCount += 1
				-- last layer selected (the first we hit here, is the merged into layer
				if (layerCount != 1) then 
				(
					-- can't merge from layer containing scene xref nodes
					if item.HasSceneXRefNodesInHierarchy() then return false
				)
			)
		)
		return (layerCount >= 2)
	)

	on execute do
	(
		local sceneExplorerInstance = SceneExplorerManager.GetActiveExplorer()
		if (sceneExplorerInstance == undefined) then return false

		-- find out the last layer selected
		local mergedIntoLayer = undefined
		local rename = true
		local selectedItems = sceneExplorerInstance.SelectedItems()
		local selCount = selectedItems.Count
		for i = selCount to 1 by -1 while (mergedIntoLayer == undefined) do
		(
			if (IsLayer (selectedItems[i])) then (
				mergedIntoLayer = selectedItems[i]
			)
		)
		if (mergedIntoLayer == undefined) then return false
		-- default layer cannot be renamed
		rename = (SceneExplorerManager.IsDefaultLayer mergedIntoLayer == false) and not mergedIntoLayer.HasSceneXRefNodesInHierarchy()

		-- go through selected layers, transfering content to the mergedIntoLayer
		for item in selectedItems do 
		(
			if (IsLayer item) then (
				if (item != mergedIntoLayer and not item.HasSceneXRefNodesInHierarchy()) then (
					-- if a layer to be merged is current then make the merging layer current
					-- this allows deleting it
					if (item.current) then
						mergedIntoLayer.current = true

					transferLayerContent item mergedIntoLayer
						-- the default layer cannot be deleted so that will leave several layers selected
						-- and we can't predict which one will be put in rename mode.  Skip renaming in that case.
					if (SceneExplorerManager.IsDefaultLayer item) then
						rename = false
					else
						layermanager.deleteLayerByName item.name
				)
			)
			else (
				-- if we have a node selected, we can't predict which explorer node will be affected by the Rename()
				rename = false
			)
		)

		if (rename) then (
			-- wait until layer deletion has finished refreshing the scene explorers 
			-- before using Rename mode
			windows.processPostedMessages()
			sceneExplorerInstance.Rename()
		)
	)
)

macroScript SESceneExplorer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"	--LOC_NOTES: do not localize this
	toolTip:~SE_SCENE_EXPLORER_TT~		--LOC_NOTES: localize this
	ButtonText:~SE_SCENE_EXPLORER~		--LOC_NOTES: localize this
 	iconName:"MainUI/ToggleSceneExplorer"	--LOC_NOTES: do not localize this
(	
	on isChecked do 	(
		sceneexplorermanager.ExplorerIsOpen ~SE_SCENE_EXPLORER_NAME~
	)

	on execute do
	(
		if sceneexplorermanager.ExplorerExists ~SE_SCENE_EXPLORER_NAME~ then 
		(
			if (not sceneexplorermanager.ExplorerIsOpen ~SE_SCENE_EXPLORER_NAME~) then
				sceneexplorermanager.OpenExplorer ~SE_SCENE_EXPLORER_NAME~
		)
		else
		(
			sceneexplorermanager.CreateExplorerFromDefault ~SE_SCENE_EXPLORER_NAME~
		)
	)

	on closeDialogs do
	(
		if (sceneexplorermanager.ExplorerIsOpen ~SE_SCENE_EXPLORER_NAME~ and not sceneexplorermanager.IsExplorerInViewport ~SE_SCENE_EXPLORER_NAME~) then
			sceneexplorermanager.CloseExplorer ~SE_SCENE_EXPLORER_NAME~
	)
)

macroScript SELayerExplorer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"	--LOC_NOTES: do not localize this
	toolTip:~SE_LAYER_EXPLORER_TT~		--LOC_NOTES: localize this
	ButtonText:~SE_LAYER_EXPLORER~		--LOC_NOTES: localize this
 	iconName:"MainUI/ToggleLayerExplorer"	--LOC_NOTES: do not localize this
(	
	on isChecked do 	(
		sceneexplorermanager.ExplorerIsOpen ~SE_LAYER_EXPLORER_NAME~
	)

	on execute do
	(
		if sceneexplorermanager.ExplorerExists ~SE_LAYER_EXPLORER_NAME~ then 
		(
			if (not sceneexplorermanager.ExplorerIsOpen ~SE_LAYER_EXPLORER_NAME~) then
				sceneexplorermanager.OpenExplorer ~SE_LAYER_EXPLORER_NAME~
		)
		else
		(
			sceneexplorermanager.CreateExplorerFromDefault ~SE_LAYER_EXPLORER_NAME~
		)
	)

	on closeDialogs do
	(
		if (sceneexplorermanager.ExplorerIsOpen ~SE_LAYER_EXPLORER_NAME~ and not sceneexplorermanager.IsExplorerInViewport ~SE_LAYER_EXPLORER_NAME~) then
			sceneexplorermanager.CloseExplorer ~SE_LAYER_EXPLORER_NAME~
	)
)

macroScript SEContainerExplorer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"	--LOC_NOTES: do not localize this
	toolTip:~SE_CONTAINER_EXPLORER_TT~		--LOC_NOTES: localize this
	ButtonText:~SE_CONTAINER_EXPLORER~		--LOC_NOTES: localize this
(	
	on isChecked do 	(
		sceneexplorermanager.ExplorerIsOpen ~SE_CONTAINER_EXPLORER_NAME~
	)

	on execute do
	(
		if sceneexplorermanager.ExplorerExists ~SE_CONTAINER_EXPLORER_NAME~ then 
		(
			if (not sceneexplorermanager.ExplorerIsOpen ~SE_CONTAINER_EXPLORER_NAME~) then
				sceneexplorermanager.OpenExplorer ~SE_CONTAINER_EXPLORER_NAME~
		)
		else
		(
			sceneexplorermanager.CreateExplorerFromDefault ~SE_CONTAINER_EXPLORER_NAME~
		)
	)

	on closeDialogs do
	(
		if (sceneexplorermanager.ExplorerIsOpen ~SE_CONTAINER_EXPLORER_NAME~) then
			sceneexplorermanager.CloseExplorer ~SE_CONTAINER_EXPLORER_NAME~
	)
)

macroScript SEDynamicsExplorer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"	--LOC_NOTES: do not localize this
	toolTip:~SE_DYNAMICS_EXPLORER_TT~		--LOC_NOTES: localize this
	ButtonText:~SE_DYNAMICS_EXPLORER~		--LOC_NOTES: localize this
(	
	on isChecked do 	(
		sceneexplorermanager.ExplorerIsOpen ~SE_DYNAMICS_EXPLORER_NAME~
	)

	on execute do
	(
		if sceneexplorermanager.ExplorerExists ~SE_DYNAMICS_EXPLORER_NAME~ then 
		(
			if (not sceneexplorermanager.ExplorerIsOpen ~SE_DYNAMICS_EXPLORER_NAME~) then
				sceneexplorermanager.OpenExplorer ~SE_DYNAMICS_EXPLORER_NAME~
		)
		else
		(
			sceneexplorermanager.CreateExplorerFromDefault ~SE_DYNAMICS_EXPLORER_NAME~
		)
	)

	on closeDialogs do
	(
		if (sceneexplorermanager.ExplorerIsOpen ~SE_DYNAMICS_EXPLORER_NAME~) then
			sceneexplorermanager.CloseExplorer ~SE_DYNAMICS_EXPLORER_NAME~
	)
)

macroScript SELightExplorer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"	--LOC_NOTES: do not localize this
	toolTip:~SE_LIGHT_EXPLORER_TT~		--LOC_NOTES: localize this
	ButtonText:~SE_LIGHT_EXPLORER~		--LOC_NOTES: localize this
(	
	on isChecked do 	(
		sceneexplorermanager.ExplorerIsOpen ~SE_LIGHT_EXPLORER_NAME~
	)

	on execute do
	(
		if sceneexplorermanager.ExplorerExists ~SE_LIGHT_EXPLORER_NAME~ then 
		(
			if (not sceneexplorermanager.ExplorerIsOpen ~SE_LIGHT_EXPLORER_NAME~) then
				sceneexplorermanager.OpenExplorer ~SE_LIGHT_EXPLORER_NAME~
		)
		else
		(
			sceneexplorermanager.CreateExplorerFromDefault ~SE_LIGHT_EXPLORER_NAME~
		)
	)

	on closeDialogs do
	(
		if (sceneexplorermanager.ExplorerIsOpen ~SE_LIGHT_EXPLORER_NAME~) then
			sceneexplorermanager.CloseExplorer ~SE_LIGHT_EXPLORER_NAME~
	)
)

macroScript SEMissingPluginExplorer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"	--LOC_NOTES: do not localize this
	toolTip:~SE_MISSINGPLUGIN_EXPLORER_TT~		--LOC_NOTES: localize this
	ButtonText:~SE_MISSINGPLUGIN_EXPLORER~		--LOC_NOTES: localize this
(	
	on isChecked do 	(
		sceneexplorermanager.ExplorerIsOpen ~SE_MISSINGPLUGIN_EXPLORER_NAME~
	)

	on execute do
	(
		if sceneexplorermanager.ExplorerExists ~SE_MISSINGPLUGIN_EXPLORER_NAME~ then 
		(
			if (not sceneexplorermanager.ExplorerIsOpen ~SE_MISSINGPLUGIN_EXPLORER_NAME~) then
				sceneexplorermanager.OpenExplorer ~SE_MISSINGPLUGIN_EXPLORER_NAME~
		)
		else
		(
			sceneexplorermanager.CreateExplorerFromDefault ~SE_MISSINGPLUGIN_EXPLORER_NAME~
		)
	)

	on closeDialogs do
	(
		if (sceneexplorermanager.ExplorerIsOpen ~SE_MISSINGPLUGIN_EXPLORER_NAME~) then
			sceneexplorermanager.CloseExplorer ~SE_MISSINGPLUGIN_EXPLORER_NAME~
	)
)

macroScript SERevitPropertyExplorer
	category:~SCENEEXPLORER_GROUP~
	internalCategory: "Scene Explorer"	--LOC_NOTES: do not localize this
	toolTip:~SE_REVITPROPERTY_EXPLORER_TT~		--LOC_NOTES: localize this
	ButtonText:~SE_REVITPROPERTY_EXPLORER~		--LOC_NOTES: localize this
(	
	on isChecked do 	(
		sceneexplorermanager.ExplorerIsOpen ~SE_REVITPROPERTY_EXPLORER_NAME~
	)

	on execute do
	(
		if sceneexplorermanager.ExplorerExists ~SE_REVITPROPERTY_EXPLORER_NAME~ then 
		(
			if (not sceneexplorermanager.ExplorerIsOpen ~SE_REVITPROPERTY_EXPLORER_NAME~) then
				sceneexplorermanager.OpenExplorer ~SE_REVITPROPERTY_EXPLORER_NAME~
		)
		else
		(
			sceneexplorermanager.CreateExplorerFromDefault ~SE_REVITPROPERTY_EXPLORER_NAME~
		)
	)

	on closeDialogs do
	(
		if (sceneexplorermanager.ExplorerIsOpen ~SE_REVITPROPERTY_EXPLORER_NAME~) then
			sceneexplorermanager.CloseExplorer ~SE_REVITPROPERTY_EXPLORER_NAME~
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCLKM3QdtcZeyRadul2NOwUbmpSuY7RNwl4
-- arth/wahxuZfGqlxAPBM7PyJMmcp1DANa7KF3McRpGY6+p7UyGVa5AWJifjCXHUw
-- Hr7HsBKC656CPRktSbXnit+BTzsTr/KCUtOUHaGAgYOILbWJMA6+h1VCq4BaYwsH
-- njm2q9qkMfvVKY6lVrv5//iCLrOnUhpi2bUH1xKfUPxRn4yJSPQNKkpnAm6nF3d8
-- RYCxbrIkCj6MuW6WirLEvrKSFPxosvvEFh+kCo18CzSoivy7lcRmi6Dk4mtzBbOm
-- Ju7RHtMeImKkZxn2uXN/0bedEPXIe7Q6d0Xls8WtEAzqspmn9IIe
-- -----END-SIGNATURE-----