-- Macro Scripts File
-- Created:  Aug 23, 1999
-- Modified: May 23, 2003
-- Render to Print 2.6
-- Version: 3dsmax 6
-- Author: Alexander Esppeschit Bicalho [discreet]
--***********************************************************************************************

/* 

Note to Localization:

Script is ready for localization and follows the Guidelines
The paper sizes show up in the array definition at the end of the script
In order to add paper sizes, either edit the PrintWiz.INI or delete it and add the 
paper definition to the script as exemplified below:

	append PaperFormats #("MyPaper",2,22.4,31.7,187)
	Where the array elements are: #(<name>,<Units>,<Width>,<Height>,<DPI>)
	Units of 1 = mm, units of 2 = Inches

History
	July 16th 2004, Pierre-Felix Breton
		fixed some render resolution refreshing issues.

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

	Version 2.6  -- removed dependency from PrintWiz.INI. The script now creates it upon startup.

*/

MacroScript RenderToPrint
	category:~RENDERTOPRINT_CATEGORY~ 
	internalCategory:"Render" 
	tooltip:~RENDERTOPRINT_TOOLTIP~
	buttonText:~RENDERTOPRINT_BUTTONTEXT~
(
global rcalc_floater, rcalc_rollout

	/* Localize ON */
	
	local rcalc_txt01 = ~RCALC_TXT01_CAPTION~
	local rcalc_txt02 = " Kb" -- I don't think the Kilobytes symbol should be localized, but just in case...
	
	/* Localize OFF */

	local printWizIni = getDir #plugCFG + "\\printwiz.ini" -- do not localize unless you rename paths or filenames
	
	
-- Functions to make the bitmaps

fn makeLandScapeBmp =
(
	mybmp = bitmap 150 100
	bgColor = ((colorman.getcolor #window)*255) as color
	fgColor = ((colorman.getcolor #window_text)*255) as color
	bgColorRow = #()
	for i in 0 to 149 do append bgColorRow bgColor
	for i in 0 to 99 do setpixels mybmp [0,i] bgColorRow
	fgColorRow = #()
	for i in 1 to 100 do append fgColorRow fgColor
	setpixels mybmp [20,20] fgColorRow
	setpixels mybmp [20,21] fgColorRow
	setpixels mybmp [30,20] fgColorRow
	setpixels mybmp [30,21] fgColorRow
	setpixels mybmp [20,80] fgColorRow
	setpixels mybmp [20,79] fgColorRow
	for i in 20 to 80 do setPixels mybmp [20,i] #(fgColor,fgColor)
	for i in 20 to 70 do setPixels mybmp [129,i] #(fgColor,fgColor)
	for i in 71 to 80 do setPixels mybmp [120,i] #(fgColor,fgColor)
	fgColorRow = #()
	for i in 1 to 10 do append fgColorRow fgColor
	setpixels mybmp [120,70] fgColorrow
	setpixels mybmp [120,71] fgColorrow
	for i in 1 to 9 do setPixels mybmp [119+i,80-i] #(fgColor,fgColor,fgColor)
	mybmp
)

fn makePortraitBmp =
(
	mybmp = bitmap 150 100
	bgColor = ((colorman.getcolor #window)*255) as color
	fgColor = ((colorman.getcolor #window_text)*255) as color
	bgColorRow = #()
	for i in 0 to 149 do append bgColorRow bgColor
	for i in 0 to 99 do setpixels mybmp [0,i] bgColorRow
	fgColorRow = #()
	for i in 1 to 40 do append fgColorRow fgColor
	setpixels mybmp [50,15] fgColorRow
	setpixels mybmp [50,16] fgColorRow
	setpixels mybmp [60,15] fgColorRow
	setpixels mybmp [60,16] fgColorRow
	setpixels mybmp [50,85] fgColorRow
	setpixels mybmp [50,84] fgColorRow
	for i in 15 to 85 do setPixels mybmp [50,i] #(fgColor,fgColor)
	for i in 15 to 75 do setPixels mybmp [99,i] #(fgColor,fgColor)
	for i in 76 to 85 do setPixels mybmp [90,i] #(fgColor,fgColor)
	fgColorRow = #()
	for i in 1 to 10 do append fgColorRow fgColor
	setpixels mybmp [90,75] fgColorrow
	setpixels mybmp [90,76] fgColorrow
	for i in 1 to 9 do setPixels mybmp [89+i,85-i] #(fgColor,fgColor,fgColor)
	mybmp
)

-- function to set the renderer data

fn setRenderData CW CH DP ALPHA COMPRESS SAVE FNAME =
(
	previousRendSceneState = renderSceneDialog.isopen()
	if renderSceneDialog.isopen() do renderSceneDialog.close()
	renderHeight = CH
	renderWidth = CW
	renderPixelAspect = 1.0
	rendtimeType = 1
	try(
		tif.setDpi DP
		if ALPHA then tif.setAlpha #true else tif.setAlpha #false
		if COMPRESS then tif.setCompression #packbits else tif.setCompression #none
		)
	catch()
	rendSaveFile = SAVE
	rendOutputFileName = FNAME
	if previousRendSceneState do renderSceneDialog.open() 
)

-- function to calculate the settings based on the DPI

fn rcalc fnunit CW CH DP FHL FWL FSS =
( 
	multi = case fnunit.state of 
	( 
		1: 25.4 as float
		2: 1 as float
	)
	CCW = (CW*DP/multi) as integer
	CCH = (CH*DP/multi) as integer
	fsize = (CCH*CCW*3/1024) as integer
	FSS.text = rcalc_txt01 + (fsize as string) + rcalc_txt02
	FHL.value = CCH
	FWL.value = CCW
	if CCW > CCH then rcalc_rollout.rbOrient.state = 2 else rcalc_rollout.rbOrient.state = 1
	if rcalc_rollout.rbOrient.state == 1 then
		(
		try(rcalc_rollout.bmpOrient.bitmap = makePortraitbmp())
		catch()
		)
		else
		(
		try(rcalc_rollout.bmpOrient.bitmap = makeLandscapeBmp())
		catch()
		)
	
)

-- Function to read value (numbers) out of INI files

fn getIniValue iniFile Key Arg =
(
	str = getIniSetting iniFile Key Arg
	if str != "" do readValue (Str as stringStream)
)

-- function to make integers into two digit strings

fn twoDigit i = 
(
	if i < 10 and i >= 0 then ("0" + (i as string)) else (i as string)
)


try(destroyDialog rcalc_rollout) catch()

-- Rollout

rollout rcalc_rollout ~RCALC_ROLLOUT_CAPTION~ width:350 height:~RCALC_ROLLOUT_HEIGHT~
(
	
	local pName = #(), pWidth = #(), pHeight = #(), pDPI = #(), pUnit = #()
	
	group ~PAPER_SIZE_GROUP~
	(
		
		-- List of paper sizes
		
		dropdownlist paper items:#(~CUSTOM~) width:120
		
		-- Units definition
		
		label CU ~CHOOSE_UNIT~ align:#left 
		radiobuttons rbUnit labels:#(~MM~, ~INCHES~) align:#left
		
		-- Some typical DPI presets
		
		label CD ~CHOOSE_DPI_VALUE~ align:#left offset:[0,5]
		button dpi_72 "72 " width:33 align:#left
		button dpi_150 "150" width:33 pos:(dpi_72.pos + [35,0])
		button dpi_300 "300" width:33 pos:(dpi_72.pos + [70,0])
		button dpi_600 "600" width:33 pos:(dpi_72.pos + [105,0])
		
		radiobuttons rbOrient labels:#(~PORTRAIT~,~LANDSCAPE~) width:140 align:#right offset:~RBORIENT_OFFSET~
		bitmap bmpOrient width:150 height:100 align:#right checked:true
		
		-- Spinner for the definition of the paper size. They're disabled if you pick a predefined paper size.
		
		spinner spnW ~SPNW_CAPTION~ type:#float range:[0,10000,(((renderwidth as float) /300.0)*25.4)] scale:0.1 fieldwidth:50 offset:~SPNW_OFFSET~
		spinner spnH ~PAPER_HEIGHT_CAPTION~ type:#float range:[0,10000,(((renderheight as float) /300.0)*25.4)] scale:0.1 fieldwidth:50 offset:~SPNH_OFFSET~
		spinner DPI ~DPI~ type:#integer range:[0,1200,300] fieldwidth:~DPI_FIELDWIDTH~ offset:~DPI_OFFSET~
		
		label IS "" align:#right offset:~LABEL_IS_OFFSET~
		spinner spnWL ~SPNWL_IMAGE_WIDTH_CAPTION~ type:#integer range:[0,100000,640] align:#right fieldwidth:50 
		spinner spnHL ~SPNHL_IMAGE_HEIGHT~ type:#integer range:[0,100000,480] align:#right fieldwidth:50 
		
		label lbFS ~LBFS_UNCOMPRESSED_FILE_SIZE~ align:#right offset:~LBFS_OFFSET~
	)
	
	group ~RENDERING_GROUP~
	(
		checkbox chkSave ~CHKSAVE_FILE~
		button btnSave ~BTNSAVE_BUTTONTEXT~ offset:~BTNSAVE_OFFSET~ align:#left height:18 width:~BTNSAVE_WIDTH~
		editText edFname "" enabled:false width:~EDFNAME_WIDTH~ align:#right height:16 offset:[0,-22]
		checkbox chkAlpha ~CHKALPHA_SAVE_ALPHA_CHANNEL~ across:2
		checkbox chkCompress ~COMPRESS_FILE~
		button btnRender ~RENDER_SETUP_BUTTONTEXT~ align:#left width:160 -- AB: VIZR change
		button btnQR ~RENDER_CAPTION~ offset:[0,-26] width:160 align:#right -- AB: VIZR change
		-- button btnRNR "Region Net Render" align:#right offset:[0,-26] width:106 -- AB: VIZR change
	)

	on btnQR pressed do 
	(	
		setRenderData spnWL.value spnHL.value DPI.value chkAlpha.checked chkCompress.checked chkSave.checked edFname.text
		destroyDialog rcalc_rollout
		max quick render
	)
	
	on btnRender pressed do 
	(
		setRenderData spnWL.value spnHL.value DPI.value chkAlpha.checked chkCompress.checked chkSave.checked edFname.text
		destroyDialog rcalc_rollout
		renderSceneDialog.open()
	)

	-- Portrait and Landscape flip
	
	on rbOrient changed state do
	(
		if rbOrient.state == 1 then			(
			try(bmpOrient.bitmap = makePortraitBmp())
			catch()
			TMP = spnW.value
			spnW.value = spnH.value
			spnH.value = TMP
			rcalc rbUnit spnW.value spnH.value DPI.value spnHL spnWL lbFS
			)
			else
			(
			try(bmpOrient.bitmap = makeLandscapeBmp())
			catch()
		 	TMP = spnW.value
			spnW.value = spnH.value
			spnH.value = TMP
			rcalc rbUnit spnW.value spnH.value DPI.value spnHL spnWL lbFS
			)
			renderheight = spnHL.value
			renderwidth = spnWL.value

	)

	on spnWL changed val do
	(
		multi = case rbUnit.state of 
				( 
				1: 25.4 as float
				2: 1 as float
				)
		renderwidth = spnWL.value
		spnw.range = [0,10000,(spnWL.value as float )/dpi.value*multi]
		spnh.range = [0,10000,(spnHL.value as float)/dpi.value*multi]
		renderheight = spnHL.value
		renderwidth = spnWL.value

	)

	on spnHL changed val do
	(
		multi = case rbUnit.state of 
				( 
				1: 25.4 as float
				2: 1 as float
				)
		renderheight = spnHL.value
		spnw.range = [0,10000,(spnWL.value as float )/dpi.value*multi]
		spnh.range = [0,10000,(spnHL.value as float)/dpi.value*multi]
		renderheight = spnHL.value
		renderwidth = spnWL.value

	)


	on dpi_72 pressed do 
	(
		dpi.value = 72
		rcalc rbUnit spnW.value spnH.value DPI.value spnHL spnWL lbFS
		renderheight = spnHL.value
		renderwidth = spnWL.value

	)
	
	on dpi_150 pressed do 
	(
		dpi.value = 150
		rcalc rbUnit spnW.value spnH.value DPI.value spnHL spnWL lbFS
		renderheight = spnHL.value
		renderwidth = spnWL.value

	)
	
	on dpi_300 pressed do 
	(
		dpi.value = 300
		rcalc rbUnit spnW.value spnH.value DPI.value spnHL spnWL lbFS
		renderheight = spnHL.value
		renderwidth = spnWL.value

	)
	
	on dpi_600 pressed do 
	(
		dpi.value = 600
		rcalc rbUnit spnW.value spnH.value DPI.value spnHL spnWL lbFS
		renderheight = spnHL.value
		renderwidth = spnWL.value

	)
	
--   This is where the Paper size dropdownlist is evaluated.
--   Basically, it disables the spinners, and sets the paper size and width, in inches for A-F sizes
--   and mm for A0-A5 sizes. Automatically, it sets a predefined DPI value, so it can reach a moreless
--   optimum value for Ploted output files.

-- These values are read from an external INI file.

	on paper selected i do
	(
		if i == 1 then
		(
			spnW.enabled = spnH.enabled = spnWL.enabled = spnHL.enabled = true
		)
		else
		(
			spnW.enabled = spnH.enabled = spnWL.enabled = spnHL.enabled = false
			if rbOrient.state == 2 then
			(
				spnW.value = pWidth[i-1]
				spnH.value = pHeight[i-1]
			)
			else
			(
				spnH.value = pWidth[i-1]
				spnW.value = pHeight[i-1]
			)
			DPI.value = pDPI[i-1]
			rbUnit.state = pUnit[i-1]
			rcalc rbUnit spnW.value spnH.value DPI.value spnHL spnWL lbFS
		)
		renderheight = spnHL.value
		renderwidth = spnWL.value

	)

	on rbUnit changed state do 
	(
		multi = case rbUnit.state of 
			( 
			1: 25.4 as float
			2: 1 as float
			)
		spnw.range = [0,10000,(spnWL.value as float)/dpi.value*multi]
		spnh.range = [0,10000,(spnHL.value as float)/dpi.value*multi]
	)
	
	-- spinner changed values triggers
	
	on spnH changed val do 
	(
		rcalc rbUnit spnW.value spnH.value DPI.value spnHL spnWL lbFS
		renderheight = spnHL.value
	)
	
	on spnW changed val do 
	(
		rcalc rbUnit spnW.value spnH.value DPI.value spnHL spnWL lbFS
		renderwidth = spnWL.value
	)
	
	on DPI changed val do rcalc rbUnit spnW.value spnH.value DPI.value spnHL spnWL lbFS
	
	-- Set the Filename (only TIFF supports DPI information)
	
	on btnSave pressed do
	(
		/* Note to Localization: the following string shows up in the Select File dialog */
	
		fname = getSaveFileName caption:~SELECT_TIFF_FILE_CAPTION~ types:~TIFF_FILE_TYPES~
		if fname != undefined do
		(
			edFname.text = fname
			chkSave.checked = true
			chkSave.enabled = (edFname.text != "")
		)
	)
	
	-- Prepare the UI and load Renderer defaults when open
	
	on rcalc_rollout open do
	(
		if renderSceneDialog.isopen() do
		(
			--renderSceneDialog.commit() line removed because of redundant code :  close already handles this
			renderSceneDialog.close()
		)
		spnWL.value = renderWidth
		spnHL.value = renderHeight
		chkSave.checked = rendSaveFile
		if rendOutputFileName != "" do
			edFname.text = 	(getfilenamePath rendOutputFileName) + \
							(getfilenameFile rendOutputFileName) + ".tif"
		chkSave.enabled = (edFname.text != "")
		try(
			chkAlpha.checked = (tif.getAlpha() == #true)
			chkCompress.checked = (tif.getCompression() == #packbits)
			DPI.value = tif.getDPI()
			)
		catch()
		
		--reads the system units and assigns the right defaults value
		case units.systemtype of
		(
			#inches:rbUnit.state = 2
			#feet:rbUnit.state = 2
			#miles:rbUnit.state = 2
				
			#millimeters:rbUnit.state = 1
			#centimeters:rbUnit.state = 1
			#meters:rbUnit.state = 1
			#kilometers:rbUnit.state = 1
			default:rbUnit.state = 2
		)
		
		multi = case rbUnit.state of 
			( 
			1: 25.4 as float
			2: 1 as float
			)
		spnw.range = [0,10000,(spnWL.value as float)/dpi.value*multi]
		spnh.range = [0,10000,(spnHL.value as float)/dpi.value*multi]
		rcalc rbUnit spnW.value spnH.value DPI.value spnHL spnWL lbFS
		
		ddownItems = paper.items

		-- Read INI File
		
		
		nformats = getIniValue printWizIni "General" "NumberOfFormats" -- do not Localize
		
		/* Note to Localization - the following strings are the ones from the list of paper sizes */
		
		if nFormats == undefined do
		(
			PaperFormats = #()
			append PaperFormats #(~PAPERFORMATS_ELEVEN_BY_EIGHT_POINT_FIVE_INCHES~,2,11,8.5,300)
			append PaperFormats #(~PAPERFORMAT_SEVENTEEN_BY_ELEVEN_INCHES~,2,17,11,200)
			append PaperFormats #(~PAPERFORMAT_TWENTY_TWO_BY_SEVENTEEN_INCHES~,2,22,17,150)
			append PaperFormats #(~PAPERFORMAT_THIRTY_FOUR_BY_TWENTY_TWO_INCHES~,2,34,22,100)
			append PaperFormats #(~PAPERFORMAT_FOURTY_FOUR_BY_THIRTY_FOUR_INCHES~,2,44,34,75)
			append PaperFormats #("A0 - 1189x841mm",1,1189,841,75)
			append PaperFormats #("A1 - 841x594mm",1,841,594,100)
			append PaperFormats #("A2 - 594x420mm",1,594,420,150)
			append PaperFormats #("A3 - 420x297mm",1,420,297,200)
			append PaperFormats #("A4 - 297x210mm",1,297,210,300)
			append PaperFormats #("A5 - 210x148mm",1,210,148,300)
			append PaperFormats #(~LETTER~,2,11,8.5,300)
			append PaperFormats #(~LEGAL~,2,14,8.5,300)
			append PaperFormats #(~TABLOID~,2,17,11,200)

			/* Do NOT Localize START */

			setIniSetting printWizIni "General" "NumberOfFormats" (PaperFormats.count as string)
			setINISetting printWizIni "General" "DialogPos" "[500,210]"

			for i in 1 to PaperFormats.count do
			(
				x = twoDigit i
				setIniSetting printWizIni ("Format" + x) "Name" 	PaperFormats[i][1]
				setIniSetting printWizIni ("Format" + x) "Unit"		(PaperFormats[i][2] as string)
				setIniSetting printWizIni ("Format" + x) "Width"	(PaperFormats[i][3] as string)
				setIniSetting printWizIni ("Format" + x) "Height"	(PaperFormats[i][4] as string)
				setIniSetting printWizIni ("Format" + x) "DPI"		(PaperFormats[i][5] as string)
			)
			nFormats = PaperFormats.count
		)

		for i in 1 to nformats do
		(
			x = twoDigit i
			append pName	(getIniSetting printWizIni ("Format" + x) "Name")
			append ddownItems pname[i]
			append pWidth	(getIniValue printWizIni ("Format" + x)   "Width")
			append pHeight 	(getIniValue printWizIni ("Format" + x)   "Height")
			append pDPI 	(getIniValue printWizIni ("Format" + x)   "DPI")
			append pUnit	(getIniValue printWizIni ("Format" + x)   "Unit")
		)
		
		/* Do NOT Localize END */
		
		paper.items = ddownItems
		
	)
	
	on rcalc_rollout close do
	(
		dialogPos = getDialogPos rcalc_rollout
		setIniSetting printWizIni ~GENERAL~ ~DIALOGPOS~ (dialogpos as string)
	)

)
--end rollout
dialogPos = execute(getIniSetting printWizIni "General" "DialogPos")
if classof dialogPos == Point2 then
	createDialog rcalc_rollout pos:dialogPos modal:true
	else createDialog rcalc_rollout modal:true
)
--end Macro


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBbm7nr5/9Lj3OA258G/hsjLeyAB4cvWU6h
-- ylDP8YZRkjELMujqj7RYPvLQ2uOXqIxxUKnhJKFk4bt26jRMhA5xYbPx9vcwTIF4
-- y5Jm8Iq4BAhQ3RbKjB6JLaevCzVEzRkVpNgmbj82Gynhr3pdFfshTfsIW02A1anh
-- IhTucQOU9PhHSYOGdabO1ChBOzymO0lqDpA5MvJRkVYqBPrYVAclbVd9wDJFMUxe
-- 84geGBSNDRu7KWgTh6ypkQjtlx45CtFI48b4chTKGHmliekLB6h2rsWUXkR8qPdt
-- 1DdGZUcR8tFZBxazfkVvc2s8Zn7B/3+Sk+OnqASwZfnloXzkfDQh
-- -----END-SIGNATURE-----