--------------------------------------------------------------------------------------------
-- Render Button Menu Items Actions 
--------------------------------------------------------------------------------------------

--------------------------------------
-- Active Shade Mode
--------------------------------------
MacroScript RenderButtonMenu_Switch_To_ActiveShade_Mode
internalCategory:"Render" 
category:~RENDERBUTTONMENU_CATEGORY~ 
ButtonText:~RENDERBUTTONMENU_SWITCHTO_ACTIVESHADE_MODE_BUTTONTEXT~
Tooltip:~RENDERBUTTONMENU_SWITCHTO_ACTIVESHADE_MODE_TOOLTIP~ 

(
	on execute do
	(
        --call this before changing the render settings for UI consistency		
        maxOps.rendUseIterative = false
        renderers.target = "local"
		renderers.renderDialogMode = #activeShade
		--~RENDERBUTTON_CAPTION_ACTIVESHADE~
	)

 	on ischecked return (renderers.renderDialogMode == #activeShade)
)--end macro

--------------------------------------
-- Production Rendering  Mode
--------------------------------------
MacroScript RenderButtonMenu_Switch_To_Production_Mode
internalCategory:"Render" 
category:~RENDERBUTTONMENU_CATEGORY~ 
ButtonText:~RENDERBUTTONMENU_SWITCHTO_PRODUCTION_MODE_BUTTONTEXT~
Tooltip:~RENDERBUTTONMENU_SWITCHTO_PRODUCTION_MODE_TOOLTIP~ 

(
	on execute do
	(
		rendUseNet = false --enforce the net render flag to off when executed. 
		maxOps.rendUseIterative = false
		renderers.target = "local"
		renderers.renderDialogMode = #production
		--~RENDERBUTTON_CAPTION_PRODUCTION~
	)

	on ischecked return (renderers.renderDialogMode == #production AND maxOps.rendUseIterative == false AND rendUseNet == false AND renderers.target == "local") 
)--end macro


--------------------------------------
--  Iterative Rendering Mode
--------------------------------------
MacroScript RenderButtonMenu_Switch_To_Iterative_Mode
internalCategory:"Render" 
category:~RENDERBUTTONMENU_CATEGORY~ 
ButtonText:~RENDERBUTTONMENU_SWITCHTO_ITERATIVE_MODE_BUTTONTEXT~
Tooltip:~RENDERBUTTONMENU_SWITCHTO_ITERATIVE_MODE_TOOLTIP~ 

(
	on execute do
	(
		rendUseNet = false --enforce the net render flag to off when executed. 
		maxOps.rendUseIterative = true
		renderers.target = "local"
		renderers.renderDialogMode = #production
	)
	
	on ischecked return  (renderers.renderDialogMode == #production AND maxOps.rendUseIterative == true AND rendUseNet == false )	
)--end macro


--------------------------------------
--  Network Rendering
--------------------------------------
MacroScript RenderButtonMenu_Submit_to_Network_Rendering
internalCategory:"Render" 
category:~RENDERBUTTONMENU_CATEGORY~ 
ButtonText:~RENDERBUTTONMENU_SUBMIT_TO_NETWORK_RENDER_BUTTONTEXT~
Tooltip:~RENDERBUTTONMENU_SUBMIT_TO_NETWORK_RENDER_TOOLTIP~ 

(
	on execute do
	(
		--Modifications have to be done with render dialog closed
		renderSceneDialog.close()

		--switch to production renderer if we were not in that mode and store the old mode
		-- before switching
		oldTarget 			 = renderers.target
		oldmode 			 = renderers.renderDialogMode
		oldUseIterativeValue = maxOps.rendUseIterative

		if (oldTarget != "local")do
		(
			renderers.target = "local"
		)

		if (oldmode != #production) do
		(
			renderers.renderDialogMode = #production
		)

		if (oldUseIterativeValue != false)do
		(
			maxOps.rendUseIterative = false
		)
		
		--enable net render
		oldUseNetValue = rendUseNet
		rendUseNet     = true
		--Simulate press render button in render dialog
		max quick render

		--Reset everything back to previous state
		rendUseNet 				= oldUseNetValue
		maxOps.rendUseIterative = oldUseIterativeValue
		renderers.target 		= oldTarget
		if (oldmode != #production) do
		(
			renderers.renderDialogMode = oldmode
		)
		renderSceneDialog.open()
	)
)--end macro


--------------------------------------
-- Cloud Rendering  Mode
--------------------------------------
MacroScript RenderButtonMenu_Switch_To_Cloud_Mode
internalCategory:"Render" 
category:~RENDERBUTTONMENU_CATEGORY~ 
ButtonText:~RENDERBUTTONMENU_SWITCHTO_CLOUD_MODE_BUTTONTEXT~
Tooltip:~RENDERBUTTONMENU_SWITCHTO_CLOUD_MODE_TOOLTIP~ 

(
	on execute do
	(
		rendUseNet = false --enforce the net render flag to off when executed. 
		maxOps.rendUseIterative = false
		renderers.renderDialogMode = #production
		--~RENDERBUTTON_CAPTION_PRODUCTION~
		renderers.target = "cloud"
	)

	on ischecked return (renderers.renderDialogMode == #production AND maxOps.rendUseIterative == false AND rendUseNet == false AND renderers.target == "cloud") 
)--end macro

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBp5+XiS2OAnn2Tz/ydgIRy8zLv3XtSR9DS
-- A8nUlzn5No6A3cHa81YcRVcquXH0cFdWiig9MdQQz3NyCYH7+7Ra7BPPDpoFv979
-- xf7h6RJSjAooasHVhOZpAXoiSsSnTSXbkP+2qBEdBBRLUmxOesEi0RU7PVo04Lzk
-- q+uUt4bsjN8+Iacmx7cpomJaAO/HlDgAGRZnXLC3vNCG0ldmreejrs2nPWmZsO1N
-- tofnrI1ztLtB1nw1leu5hMqKZgowLmVPdlYET297BhFah6tg+WKkb+yK5WE8QZmU
-- zwoOHIysU5OYe491Dn2s2otvMP4mZAcVB5dJYSlicJsJuEjxtFJZ
-- -----END-SIGNATURE-----