/*
Macro_Scripts File
Purposes:  
    
	define action for each creatable System object to hook up to the create main menu (or quads)
	defines macros for Quads

Revision History

	2 aug 2004, Pierre-Felix Breton
		added 3ds max r7 objects

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products


	26 Mai 2003: Pierre-felix Breton
	created for 3ds MAX 6

*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

-----------------------------------------------------------------------------------------
-- Day Light System
-----------------------------------------------------------------------------------------

macroScript DayLight 
category:~DAYLIGHT_CATEGORY~
internalCategory:"Lights and Cameras"
ButtonText:~DAYLIGHT_SYSTEM_BUTTONTEXT~
tooltip:~DAYLIGHT_SYSTEM_TOOLTIP~ 
icon:#("Systems",2)
(
	on execute do 
	 	(
			StartObjectCreation Daylight
		)
     on isChecked return mcrUtils.IsCreating Daylight
)


macroScript SunLight 
category:~LIGHTS_AND_CAMERAS_CATEGORY~
internalCategory:"Lights and Cameras"
ButtonText:~SUNLIGHT_SYSTEM_BUTTONTEXT~
tooltip:~SUNLIGHT_SYSTEM_TOOLTIP~ 
(
     on execute do 
	 	(
			StartObjectCreation Sunlight
		)
     on isChecked return mcrUtils.IsCreating Sunlight
)


-----------------------------------------------------------------------------------------
macroScript RingArray
            category:~OBJECTS_SYSTEMS_CATEGORY~ 
            internalCategory:"Objects Systems" 
            tooltip:~RING_ARRAY_TOOLTIP~ 
            buttontext:~RING_ARRAY_BUTTONTEXT~ 
            --Icon:#("SW_GeoDef",7)
(
    on execute do StartObjectCreation Ring_Array 
    on isChecked return mcrUtils.IsCreating Ring_Array
)

-----------------------------------------------------------------------------------------
macroScript Biped
            category:~BIPED_OBJECTS_SYSTEMS_CATEGORY~ 
            internalCategory:"Objects Systems" 
            tooltip:~BIPED_TOOLTIP~ 
            buttontext:~BIPED_BUTTONTEXT~ 
            --Icon:#("SW_GeoDef",7)
(
    on execute do StartObjectCreation bipedSystem
    on isChecked return mcrUtils.IsCreating bipedSystem
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQALPekBqZQrzvolOI9Z9v1B6oJWm3DFA1TC
-- Eytc9xRPlU5fpsG1njVu6QxCsoa5cVxXKXoWdzviEU03bsxgyUnEo1kSjUFiPwWb
-- 5c3fTahV20KIM/zLqft62R7kXtDrtb8MRzcB1ltqwuPicjdXzVxHkIhPFsx4Oqrd
-- X3QRYYGVsdxV4NKEM8BQm9c3m8zU0s4RkgamXNtSgvvcLxQHOW4ruh3mUgPj7us8
-- pUGcB7ER9LB3dCf4aUehHzpKPVlkwIrioPJwtTuQjjhHxGGEXbBneHZgSB1uTj4j
-- 9zQWTKxeGRtSKV1ALhIcy6fvBuSYWJU2qOzUxnPbtM82AReZO0pC
-- -----END-SIGNATURE-----