/*
Macro_Scripts File
Purposes:  
    
	define action for each creatable Spacewarp object to hook up to the create main menu (or quads)
	defines macros for Quads

Revision History

	2 aug 2004, Pierre-Felix Breton
		added 3ds max r7 objects

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

	26 Mai 2003: Pierre-felix Breton
	created for 3ds MAX 6
	
	28 jan 1999: Frank Delise
	created

*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

-----------------------------------------------------------------------------------------
macroScript SpaceBend 
            category:~SPACEBEND_CATEGORY~
            internalCategory:"Objects Space Warps" 
            tooltip:~SPACEBEND_TOOLTIP~
            buttontext:~SPACEBEND_BUTTONTEXT~
            Icon:#("SW_ModBased",1)
(
    on execute do StartObjectCreation SpaceBend
    on isChecked return mcrUtils.IsCreating SpaceBend
)
-----------------------------------------------------------------------------------------
macroScript SpaceTaper 
            category:~SPACETAPER_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~SPACETAPER_TOOLTIP~ 
            buttontext:~SPACETAPER_BUTTONTEXT~ 
            Icon:#("SW_ModBased",2)
(
    on execute do StartObjectCreation SpaceTaper
    on isChecked return mcrUtils.IsCreating SpaceTaper
)
-----------------------------------------------------------------------------------------
macroScript SpaceNoise 
            category:~SPACENOISE_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~SPACENOISE_TOOLTIP~ 
            buttontext:~SPACENOISE_BUTTONTEXT~ 
            Icon:#("SW_ModBased",3)
(
    on execute do StartObjectCreation SpaceNoise
    on isChecked return mcrUtils.IsCreating SpaceNoise
)
-----------------------------------------------------------------------------------------
macroScript SpaceTwist 
            category:~SPACETWIST_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~SPACETWIST_TOOLTIP~ 
            buttontext:~SPACETWIST_BUTTONTEXT~ 
            Icon:#("SW_ModBased",4)
(
    on execute do StartObjectCreation SpaceTwist
    on isChecked return mcrUtils.IsCreating SpaceTwist
)
-----------------------------------------------------------------------------------------
macroScript SpaceSkew 
            category:~SPACESKEW_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~SPACESKEW_TOOLTIP~ 
            buttontext:~SPACESKEW_BUTTONTEXT~ 
            Icon:#("SW_ModBased",5)
(
    on execute do StartObjectCreation SpaceSkew
    on isChecked return mcrUtils.IsCreating SpaceSkew
)
-----------------------------------------------------------------------------------------
macroScript SpaceStretch 
            category:~SPACESTRETCH_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~SPACESTRETCH_TOOLTIP~ 
            buttontext:~SPACESTRETCH_BUTTONTEXT~ 
            Icon:#("SW_ModBased",6)
(
    on execute do StartObjectCreation SpaceStretch
    on isChecked return mcrUtils.IsCreating SpaceStretch
)
-----------------------------------------------------------------------------------------
macroScript Ripple 
            category:~RIPPLE_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~RIPPLE_TOOLTIP~ 
            buttontext:~RIPPLE_BUTTONTEXT~ 
            Icon:#("SW_GeoDef",6)
(
    on execute do StartObjectCreation SpaceRipple
    on isChecked return mcrUtils.IsCreating SpaceRipple
)

-----------------------------------------------------------------------------------------
macroScript FFD_Cyl 
            category:~FFD_CYL_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~FFD_CYL_TOOLTIP~ 
			ButtonText:~FFD_CYL_BUTTONTEXT~
            Icon:#("SW_GeoDef",5)
(
    on execute do StartObjectCreation SpaceFFDCyl
    on isChecked return mcrUtils.IsCreating SpaceFFDCyl
)

-----------------------------------------------------------------------------------------
macroScript FFD_Box 
            category:~FFD_BOX_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~FFD_BOX_TOOLTIP~
			ButtonText:~FFD_BOX_BUTTONTEXT~
            Icon:#("SW_GeoDef",1)
(
    on execute do StartObjectCreation SpaceFFDBox
    on isChecked return mcrUtils.IsCreating SpaceFFDBox
)
-----------------------------------------------------------------------------------------
macroScript Motor 
            category:~MOTOR_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~MOTOR_TOOLTIP~ 
            buttontext:~MOTOR_BUTTONTEXT~ 
            Icon:#("SW_PartDyn",3)
(
    on execute do StartObjectCreation Motor
    on isChecked return mcrUtils.IsCreating Motor
)
-----------------------------------------------------------------------------------------
macroScript Pbomb 
            category:~PBOMB_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~PBOMB_TOOLTIP~ 
            buttontext:~PBOMB_BUTTONTEXT~ 
            Icon:#("SW_PartDyn",4)
(
    on execute do StartObjectCreation PBomb 
    on isChecked return mcrUtils.IsCreating PBomb 
)
-----------------------------------------------------------------------------------------
macroScript Push 
            category:~PUSH_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~PUSH_TOOLTIP~ 
            buttontext:~PUSH_BUTTONTEXT~ 
            Icon:#("SW_PartDyn",5)
(
    on execute do StartObjectCreation PushSpaceWarp 
    on isChecked return mcrUtils.IsCreating PushSpaceWarp 
)

-----------------------------------------------------------------------------------------
macroScript Vortex 
            category:~VORTEX_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~VORTEX_TOOLTIP~ 
            buttontext:~VORTEX_BUTTONTEXT~ 
            --Icon:#("SW_PartDyn",5)
(
    on execute do StartObjectCreation Vortex 
    on isChecked return mcrUtils.IsCreating Vortex 
)

-----------------------------------------------------------------------------------------
macroScript Drag 
            category:~DRAG_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~DRAG_TOOLTIP~ 
            buttontext:~DRAG_BUTTONTEXT~ 
            --Icon:#("SW_PartDyn",5)
(
    on execute do StartObjectCreation Drag 
    on isChecked return mcrUtils.IsCreating Drag 
)
-----------------------------------------------------------------------------------------
macroScript SDynaFlect 
            category:~SDYNAFLECT_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~SDYNAFLECT_TOOLTIP~ 
            buttontext:~SDYNAFLECT_BUTTONTEXT~ 
            Icon:#("SW_DynInt",2)
(
    on execute do StartObjectCreation SDynaFlect
    on isChecked return mcrUtils.IsCreating SDynaFlect
)
-----------------------------------------------------------------------------------------
macroScript PDynaFlect 
            category:~PDYNAFLECT_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~PDYNAFLECT_TOOLTIP~ 
            buttontext:~PDYNAFLECT_BUTTONTEXT~ 
            Icon:#("SW_DynInt",3)
(
    on execute do StartObjectCreation PDynaFlect 
    on isChecked return mcrUtils.IsCreating PDynaFlect 
)
-----------------------------------------------------------------------------------------
macroScript UDynaFlect 
            category:~UDYNAFLECT_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~UDYNAFLECT_TOOLTIP~ 
            buttontext:~UDYNAFLECT_BUTTONTEXT~ 
            Icon:#("SW_DynInt",4)
(
    on execute do StartObjectCreation UDynaFlect 
    on isChecked return mcrUtils.IsCreating UDynaFlect 
)

-----------------------------------------------------------------------------------------
macroScript POmniFlect 
            category:~POMNIFLECT_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~POMNIFLECT_TOOLTIP~ 
            buttontext:~POMNIFLECT_BUTTONTEXT~ 
            Icon:#("SW_PartOnly",1)
(
    on execute do StartObjectCreation POmniFlect 
    on isChecked return mcrUtils.IsCreating POmniFlect 
)

-----------------------------------------------------------------------------------------
macroScript SOmniFlect 
            category:~SOMNIFLECT_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~SOMNIFLECT_TOOLTIP~ 
            buttontext:~SOMNIFLECT_BUTTONTEXT~ 
            Icon:#("SW_PartOnly",5)
(
    on execute do StartObjectCreation SOmniFlect 
    on isChecked return mcrUtils.IsCreating SOmniFlect 
)

-----------------------------------------------------------------------------------------
macroScript UOmniFlect 
            category:~UOMNIFLECT_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~UOMNIFLECT_TOOLTIP~ 
            buttontext:~UOMNIFLECT_BUTTONTEXT~ 
            Icon:#("SW_PartOnly",2)
(
    on execute do StartObjectCreation UOmniFlect 
    on isChecked return mcrUtils.IsCreating UOmniFlect 
)
-----------------------------------------------------------------------------------------
macroScript SDeflector 
            category:~SDEFLECTOR_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~SDEFLECTOR_TOOLTIP~ 
            buttontext:~SDEFLECTOR_BUTTONTEXT~ 
            Icon:#("SW_PartOnly",6)
(
    on execute do StartObjectCreation SDeflector 
    on isChecked return mcrUtils.IsCreating SDeflector 
)
-----------------------------------------------------------------------------------------
macroScript UDeflector 
            category:~UDEFLECTOR_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~UDEFLECTOR_TOOLTIP~ 
            buttontext:~UDEFLECTOR_BUTTONTEXT~ 
            Icon:#("SW_PartOnly",7)
(
    on execute do StartObjectCreation UDeflector 
    on isChecked return mcrUtils.IsCreating UDeflector 
)


-----------------------------------------------------------------------------------------
macroScript Wave 
            category:~WAVE_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~WAVE_TOOLTIP~ 
            buttontext:~WAVE_BUTTONTEXT~ 
            Icon:#("SW_GeoDef",2)
(
    on execute do StartObjectCreation SpaceWave 
    on isChecked return mcrUtils.IsCreating SpaceWave 
)

-----------------------------------------------------------------------------------------
macroScript Gravity 
            category:~GRAVITY_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~GRAVITY_TOOLTIP~ 
            buttontext:~GRAVITY_BUTTONTEXT~ 
            Icon:#("SW_PartDyn",1)
(
    on execute do StartObjectCreation Gravity 
    on isChecked return mcrUtils.IsCreating Gravity 
)

-----------------------------------------------------------------------------------------
macroScript Wind 
            category:~WIND_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~WIND_TOOLTIP~ 
            buttontext:~WIND_BUTTONTEXT~ 
            Icon:#("SW_PartDyn",2)
(
    on execute do StartObjectCreation Wind 
    on isChecked return mcrUtils.IsCreating Wind 
)

-----------------------------------------------------------------------------------------
macroScript Displace 
            category:~DISPLACE_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~DISPLACE_TOOLTIP~ 
            buttontext:~DISPLACE_BUTTONTEXT~ 
            Icon:#("SW_GeoDef",3)
(
    on execute do StartObjectCreation SpaceDisplace 
    on isChecked return mcrUtils.IsCreating SpaceDisplace 
)

-----------------------------------------------------------------------------------------
macroScript Deflector 
            category:~DEFLECTOR_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~DEFLECTOR_TOOLTIP~ 
            buttontext:~DEFLECTOR_BUTTONTEXT~ 
            Icon:#("SW_Partonly",4)
(
    on execute do StartObjectCreation Deflector 
    on isChecked return mcrUtils.IsCreating Deflector 
)

-----------------------------------------------------------------------------------------
macroScript Bomb  
            category:~BOMB_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~BOMB_TOOLTIP~ 
            buttontext:~BOMB_BUTTONTEXT~ 
            Icon:#("SW_GeoDef",4)
(
    on execute do StartObjectCreation Bomb 
    on isChecked return mcrUtils.IsCreating Bomb 
)

-----------------------------------------------------------------------------------------
macroScript Path_Follow 
            category:~PATH_FOLLOW_CATEGORY~
            internalCategory:"Objects Space Warps" 
            tooltip:~PATH_FOLLOW_TOOLTIP~ 
            buttontext:~PATH_FOLLOW_BUTTONTEXT~ 
            Icon:#("SW_Partonly",3)
(
    on execute do StartObjectCreation Path_Follow
    on isChecked return mcrUtils.IsCreating Path_Follow
)
-----------------------------------------------------------------------------------------
macroScript SpaceConform 
            category:~SPACECONFORM_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~SPACECONFORM_TOOLTIP~ 
            buttontext:~SPACECONFORM_BUTTONTEXT~ 
            Icon:#("SW_GeoDef",7)
(
    on execute do StartObjectCreation ConformSpacewarp 
    on isChecked return mcrUtils.IsCreating ConformSpacewarp 
)

-----------------------------------------------------------------------------------------
macroScript Vector_Field
            category:~VECTOR_FIELD_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~VECTOR_FIELD_TOOLTIP~ 
            buttontext:~VECTOR_FIELD_BUTTONTEXT~ 
            --Icon:#("SW_GeoDef",7)
(
    on execute do StartObjectCreation Vector_Field 
    on isChecked return mcrUtils.IsCreating Vector_Field
)

-----------------------------------------------------------------------------------------
macroScript MaxMotionField
            category:~MAXMOTIONFIELD_CATEGORY~ 
            internalCategory:"Objects Space Warps" 
            tooltip:~MAXMOTIONFIELD_TOOLTIP~ 
            buttontext:~MAXMOTIONFIELD_BUTTONTEXT~ 
(
    on execute do StartObjectCreation MaxMotionField 
    on isChecked return mcrUtils.IsCreating MaxMotionField
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBgAmoClz9Q81bue6E9hPe6Z3dzznr6YyGi
-- FidGYagxQFL+sOy+TY/AGXZ9rCaai1prQ2uZvXK/YKjUh85lWRwHAGjQJ7orMflQ
-- P8yNo95DeKRKSBK+O8x/WH9Gn3YgeJ93k4JhEAo9zgayCV1Yg/Al6+aqm+co+G8r
-- NaUIfntejpOBb/6iXbboWr971GQdj+D2n1Ti30fCyXARo0dt9vsM3267lwVtCK7L
-- URYxGT9pLwhZQsTPwIc3i3kwboFKVYeb/e/67kQH2I8buH3dAkvX67wdPUvS6lVn
-- L1L7dm3iMOCvs6fHNsXaLceZm2/m/EBDyMy1+YYMD4wDr0MhqNh4
-- -----END-SIGNATURE-----