/*

  Macro_Scripts File
Purposes:  
    
	define action for each creatable Shape object to hook up to the create main menu (or quads)


Revision History
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

	26 Mai 2003: Pierre-felix Breton
	created for 3ds MAX 6
	
	Nov 17 1999: Frank Delise
	created
*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

----------------------------------------------------------
macroScript Lines 
            category:~LINES_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~LINES_TOOLTIP~ 
            buttontext:~LINES_BUTTONTEXT~ 
            Icon:#("Splines",1)
(
   on execute do StartObjectCreation Line
   on isChecked return (mcrUtils.IsCreating Line)
)
----------------------------------------------------------
macroScript Circle 
            category:~CIRCLE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~CIRCLE_TOOLTIP~ 
            buttontext:~CIRCLE_BUTTONTEXT~ 
            Icon:#("Splines",2)
(
   on execute do StartObjectCreation Circle 
   on isChecked return (mcrUtils.IsCreating Circle)
)
----------------------------------------------------------
macroScript Arc 
            category:~ARC_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~ARC_TOOLTIP~ 
            buttontext:~ARC_BUTTONTEXT~ 
            Icon:#("Splines",3)
(
   on execute do StartObjectCreation Arc
   on isChecked return (mcrUtils.IsCreating Arc)
)
----------------------------------------------------------
macroScript Ngon 
            category:~NGON_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~NGON_TOOLTIP~ 
            buttontext:~NGON_BUTTONTEXT~ 
            Icon:#("Splines",4)
(
   on execute do StartObjectCreation Ngon
   on isChecked return (mcrUtils.IsCreating Ngon)
)
----------------------------------------------------------
macroScript Text 
            category:~TEXT_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~TEXT_TOOLTIP~ 
            buttontext:~TEXT_BUTTONTEXT~ 
            Icon:#("Splines",5)
(
   on execute do StartObjectCreation Text 
   on isChecked return (mcrUtils.IsCreating Text)
)
----------------------------------------------------------
macroScript Rectangle 
            category:~RECTANGLE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~RECTANGLE_TOOLTIP~ 
            buttontext:~RECTANGLE_BUTTONTEXT~ 
            Icon:#("Splines",7)
(
   on execute do StartObjectCreation Rectangle 
   on isChecked return (mcrUtils.IsCreating Rectangle)
)
----------------------------------------------------------
macroScript Ellipse 
            category:~ELLIPSE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~ELLIPSE_TOOLTIP~ 
            buttontext:~ELLIPSE_BUTTONTEXT~ 
            Icon:#("Splines",8)
(
   on execute do StartObjectCreation Ellipse 	
   on isChecked return (mcrUtils.IsCreating Ellipse)
)
----------------------------------------------------------
macroScript Donut 
            category:~DONUT_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~DONUT_TOOLTIP~ 
            buttontext:~DONUT_BUTTONTEXT~ 
            Icon:#("Splines",9)
(
   on execute do StartObjectCreation Donut 
   on isChecked return (mcrUtils.IsCreating Donut)
)
----------------------------------------------------------
macroScript Star 
            category:~STAR_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~STAR_TOOLTIP~ 
            buttontext:~STAR_BUTTONTEXT~ 
            Icon:#("Splines",10)
(
   on execute do StartObjectCreation Star 
   on isChecked return (mcrUtils.IsCreating Star)
)
----------------------------------------------------------
macroScript Helix 
            category:~HELIX_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~HELIX_TOOLTIP~ 
            buttontext:~HELIX_BUTTONTEXT~ 
            Icon:#("Splines",11)
(
   on execute do StartObjectCreation Helix 
   on isChecked return (mcrUtils.IsCreating Helix)
)

----------------------------------------------------------
macroScript Section 
            category:~SECTION_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~SECTION_TOOLTIP~ 
            buttontext:~SECTION_BUTTONTEXT~ 
            Icon:#("Splines",6)
(
   on execute do StartObjectCreation Section 
   on isChecked return (mcrUtils.IsCreating Section)
)

----------------------------------------------------------
macroScript Egg 
            category:~EGG_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~EGG_TOOLTIP~ 
            buttontext:~EGG_BUTTONTEXT~ 
            Icon:#("Splines",9)
(
   on execute do StartObjectCreation Egg 
   on isChecked return (mcrUtils.IsCreating Egg)
)

----------------------------------------------------------
macroScript WRectangle
            category:~WRECTANGLE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~WRECTANGLE_TOOLTIP~ 
            buttontext:~WRECTANGLE_BUTTONTEXT~ 
(
   on execute do StartObjectCreation WalledRectangle
   on isChecked return (mcrUtils.IsCreating WalledRectangle)
)

----------------------------------------------------------
macroScript Angle
            category:~ANGLE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~ANGLE_TOOLTIP~ 
            buttontext:~ANGLE_BUTTONTEXT~ 
(
   on execute do StartObjectCreation Angle
   on isChecked return (mcrUtils.IsCreating Angle)
)

----------------------------------------------------------
macroScript WideFlange
            category:~WIDEFLANGE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~WIDEFLANGE_TOOLTIP~ 
            buttontext:~WIDEFLANGE_BUTTONTEXT~ 
(
   on execute do StartObjectCreation WideFlange
   on isChecked return (mcrUtils.IsCreating WideFlange)
)

----------------------------------------------------------
macroScript Channel
            category:~CHANNEL_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~CHANNEL_TOOLTIP~ 
            buttontext:~CHANNEL_BUTTONTEXT~ 
(
   on execute do StartObjectCreation Channel
   on isChecked return (mcrUtils.IsCreating Channel)
)

----------------------------------------------------------
macroScript Tee
            category:~TEE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~TEE_TOOLTIP~ 
            buttontext:~TEE_BUTTONTEXT~ 
(
   on execute do StartObjectCreation Tee
   on isChecked return (mcrUtils.IsCreating Tee)
)

----------------------------------------------------------
macroScript StartNewShapeLock
            category:~STARTNEWSHAPELOCK_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~STARTNEWSHAPELOCK_TOOLTIP~
            ButtonText:~STARTNEWSHAPELOCK_BUTTONTEXT~ 
(
	On Execute Do	
	(
		Try
		(
			if maxOps.startNewShapeLock == true then 
			(
				maxOps.startNewShapeLock = false
			) else (
				maxOps.startNewShapeLock = true
			)
		)
		Catch() 
	)
        on isChecked return (maxOps.startNewShapeLock)
)
----------------------------------------------------------
macroScript StartNewShape
            category:~STARTNEWSHAPE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~STARTNEWSHAPE_TOOLTIP~
            ButtonText:~STARTNEWSHAPE_BUTTONTEXT~ 
(
	on execute do (Try( maxOps.startNewShape() ) Catch() )
)

----------------------------------------------------------
macroScript FreehandSpline 
            category:~FREEHANDSPLINE_CATEGORY~ 
            internalCategory:"Objects Shapes" 
            tooltip:~FREEHANDSPLINE_TOOLTIP~ 
            buttontext:~FREEHANDSPLINE_BUTTONTEXT~ 
(
   on execute do StartObjectCreation FreehandSpline
   on isChecked return (mcrUtils.IsCreating FreehandSpline)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCHHn/9AXCC9HC33LpD5xiCeLiGe6EIOmNJ
-- 2qmmAU+4UKHb7KYZ3AWZTvtLvrzhWi5upA47TgnA+hpCRUoXkdaaqWuWQLpAq5Y8
-- zfqudLtO3Q5hfZswDnHzl10UFIhluTQv2BLCOJETjckRe2lL5kN7UN2sGSwOTgx1
-- aUureSBi/ckzbS+Ue0XPrUf20bEmmV7qTvTbYq8ZZNCpVCH8jOCqiOkzXQ490N5D
-- SpOLlVXcr6rt0vgBrVKbQTSoAHFLojKOayXZqI25DKo7nJNkiDMAalijU2L81+zU
-- 1UdS6+1e7a5885Gaf+CWidL9v9W53UPFMULFovdWG550pZgNXxtY
-- -----END-SIGNATURE-----