-- Macro_Scripts File
-- Purpose:  define action for each creatable Particles Systems objects to hook up to the create main menu (or quads)

/*
Revision History

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

	24 Mai 2003: Pierre-felix Breton
	created for 3ds MAX 6
	
	Nov 17 1998: Frank Delise
	created
*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

---------------------------------------------------------------------------
macroScript PFFindTarget
            category:~PFFINDTARGET_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFFINDTARGET_TOOLTIP~ 
            buttontext:~PFFINDTARGET_BUTTONTEXT~ 
            --Icon:#("Particles",3)
(
    on execute do StartObjectCreation Find_Target
    on isChecked return mcrUtils.IsCreating Find_Target
)

---------------------------------------------------------------------------
macroScript PFSpeedByIcon
            category:~PFSPEEDBYICON_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFSPEEDBYICON_TOOLTIP~ 
            buttontext:~PFSPEEDBYICON_BUTTONTEXT~ 
            --Icon:#("Particles",3)
(
    on execute do StartObjectCreation SpeedByIcon
    on isChecked return mcrUtils.IsCreating SpeedByIcon
)

---------------------------------------------------------------------------
macroScript PFParticlePaint
            category:~PFPARTICLEPAINT_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFPARTICLEPAINT_TOOLTIP~ 
            buttontext:~PF_PARTICLEPAINT_BUTTONTEXT~
(
    on execute do StartObjectCreation Particle_Paint
    on isChecked return mcrUtils.IsCreating Particle_Paint
)

---------------------------------------------------------------------------
macroScript PFBirthTexture
            category:~PFBIRTHTEXTURE_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFBIRTHTEXTURE_TOOLTIP~ 
            buttontext:~PFBIRTHTEXTURE_BUTTONTEXT~ 
(
    on execute do StartObjectCreation Birth_Texture
    on isChecked return mcrUtils.IsCreating Birth_Texture
)

---------------------------------------------------------------------------
macroScript PFInitialState
            category:~PFINITIALSTATE_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFINITIALSTATE_TOOLTIP~ 
            buttontext:~PFINITIALSTATE_BUTTONTEXT~ 
(
    on execute do StartObjectCreation Initial_State
    on isChecked return mcrUtils.IsCreating Initial_State
)

---------------------------------------------------------------------------
macroScript PFGroupSelect
            category:~PFGROUPSELECT_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PFGROUPSELECT_TOOLTIP~ 
            buttontext:~PFGROUPSELECT_BUTTONTEXT~ 
(
    on execute do StartObjectCreation Group_Select
    on isChecked return mcrUtils.IsCreating Group_Select
)

---------------------------------------------------------------------------
macroScript PFSource
            category:~PFSOURCE_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~PFSOURCE_TOOLTIP~ 
            buttontext:~PFSOURCE_BUTTONTEXT~ 
            --Icon:#("Particles",3)
(
    on execute do StartObjectCreation PF_Source
    on isChecked return mcrUtils.IsCreating PF_Source
)
---------------------------------------------------------------------------
macroScript PArray
            category:~PARRAY_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~PARRAY_TOOLTIP~ 
            buttontext:~PARRAY_BUTTONTEXT~ 
            Icon:#("Particles",3)
(
    on execute do StartObjectCreation PArray
    on isChecked return mcrUtils.IsCreating PArray
)
---------------------------------------------------------------------------
macroScript PCloud
            category:~PCLOUD_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~PCLOUD_TOOLTIP~ 
            buttontext:~PCLOUD_BUTTONTEXT~ 
            Icon:#("Particles",6)
(
    on execute do StartObjectCreation PCloud 
    on isChecked return mcrUtils.IsCreating PCloud
)
---------------------------------------------------------------------------
macroScript Blizzard
            category:~BLIZZARD_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~BLIZZARD_TOOLTIP~ 
            buttontext:~BLIZZARD_BUTTONTEXT~ 
            Icon:#("Particles",5)
(
    on execute do StartObjectCreation Blizzard 
    on isChecked return mcrUtils.IsCreating Blizzard
)
---------------------------------------------------------------------------
macroScript SuperSpray
            category:~SUPERSPRAY_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~SUPERSPRAY_TOOLTIP~
			buttontext:~SUPERSPRAY_BUTTONTEXT~ 
            Icon:#("Particles",2)
(
    on execute do StartObjectCreation SuperSpray 
    on isChecked return mcrUtils.IsCreating SuperSpray
)
---------------------------------------------------------------------------
macroScript Spray
            category:~SPRAY_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~SPRAY_TOOLTIP~ 
            buttontext:~SPRAY_BUTTONTEXT~ 
            Icon:#("Particles",1)
(
    on execute do StartObjectCreation Spray
    on isChecked return mcrUtils.IsCreating Spray
)
---------------------------------------------------------------------------
macroScript Snow
            category:~SNOW_CATEGORY~ 
            internalCategory:"Objects Particle Systems" 
            tooltip:~SNOW_TOOLTIP~ 
            buttontext:~SNOW_BUTTONTEXT~ 
            Icon:#("Particles",4)
(
    on execute do StartObjectCreation Snow 
    on isChecked return mcrUtils.IsCreating Snow
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQB7GuBXLr+AN/lUqxbruqlXt7NKtZz3/2PB
-- oCGv7sjgG9O+O/isgl2Mn3jmFixY/oBci3//WRmCMrC+MibKlbGjvWTwxosIOOCv
-- 1+JQnlxHL4D1kqE8kOdCb/VizMADNlHjO+GSh8DDe+dE0fDJmoKjL/bEP5bo270I
-- +exuFbCwf7LVOCj57rduBNDVjJeELbOE0JoM4mW6dBnYRZRJAl2sY7WGNbD5jMcB
-- RL5tVkAzingDYJXidmYiOBsAec8mOFK2P/mMAkBdwObeLVX7AtICkJe9wc8/DGZ4
-- iMz4QL3CAIbwsDLYgAhKNGaxLH1NqfK/TI531Ea2FkFMxz3G+O0M
-- -----END-SIGNATURE-----