-- Macro_Scripts File
-- Purpose:  define action for each creatable Nurbs surfaces and curves objects to hook up to the create main menu (or quads)

/*
Revision History

	22 Jan 2004, Pierre-Felix Breton
		
	
	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

	
	24 Mai 2003: Pierre-felix Breton
	created for 3ds MAX 6
*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

--------------------------------------------------------------------------------------------

--------------------------------------------------------------------------------------------
macroScript Point_Surf 
            category:~OBJECTS_NURBS_CATEGORY~ 
            internalCategory:"Objects NURBS" 
			tooltip:~POINT_SURFACE_TOOLTIP~ 
			ButtonText:~POINT_SURFACE_BUTTONTEXT~
            icon:#("NURBSSurface",1)
(
	on execute do (Try(StartObjectCreation Point_Surf) Catch () )
        on isChecked return (mcrUtils.IsCreating Point_Surf)
)

--------------------------------------------------------------------------------------------
macroScript CV_Surf 
            category:~CV_SURF_OBJECTS_NURBS_CATEGORY~ 
            internalCategory:"Objects NURBS" 
            tooltip:~CV_SURFACE_TOOLTIP~
			ButtonText:~CV_SURFACE_BUTTONTEXT~ 
            icon:#("NURBSSurface",2)
(
	on execute do (Try(StartObjectCreation NURBSSurf) Catch())
        on isChecked return (mcrUtils.IsCreating NURBSSurf)
)

--------------------------------------------------------------------------------------------
macroScript Point_Curve 
            category:~POINT_CURVE_OBJECTS_NURBS_CATEGORY~ 
            internalCategory:"NObjects NURBSURBS" 
            tooltip:~POINT_CURVE_TOOLTIP~ 
            buttontext:~POINT_CURVE_BUTTONTEXT~ 
            Icon:#("NURBScurve",1)
(
   on execute do StartObjectCreation Point_Curve
   on isChecked return mcrUtils.IsCreating Point_Curve
)

--------------------------------------------------------------------------------------------
macroScript CV_Curve 
            category:~CV_CURVE_OBJECTS_NURBS_CATEGORY~ 
            internalCategory:"Objects NURBS" 
            tooltip:~CV_CURVE_TOOLTIP~ 
            buttontext:~CV_CURVE_BUTTONTEXT~ 
            Icon:#("NURBScurve",2)
(
   on execute do StartObjectCreation CV_Curve
   on isChecked return mcrUtils.IsCreating CV_Curve 
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCWvk7w6XweVnc9rZfPCCHArGfSuNU8MpQf
-- 9ndAbwGOpqG7wjStW9roiIxLsnZmgKIUSx+v2Zwb3qp2+mE9gA5IQ0Co/C4AXQY8
-- 668ZuWJo9h42IiogmNtT6WUwydeYJWWRLE06lKP7A+1/LBWn9seNL8q5YxAGbIGz
-- OaDHo0vaWChp7ml2ri66JUp5xBcQrbufM92RPDv33+uIspT375uFQtF8Z+cdClUB
-- r47br1xVAlT8CZjvpH32iT2P0DOCGV715b9NFpVkSmwirlnQonAp65tXrqv5lXMQ
-- +BhSm53rLlZj6zWjcNz7OcLludcwfouj5N+QKcmSKWy74CA1vLVP
-- -----END-SIGNATURE-----