/*
Macro_Scripts File
Purposes:  
    
	define action for each creatable Helper object to hook up to the create main menu (or quads)
	defines macros for Quads

Revision History

	Nov 7th, 2007, Pierre-Felix Breton
		Adding LightMeter Object creation tool

	2 aug 2004, Pierre-Felix Breton
		added character studio helpers and new math helper

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

	26 Mai 2003: Pierre-felix Breton
		created for 3ds MAX 6


*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK



------------------------------------------------------------------------------
macroScript Dummy 
            category:~DUMMY_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~DUMMY_TOOLTIP~
			ButtonText:~DUMMY_BUTTONTEXT~ 
            Icon:#("Helpers",1)
(
    on execute do StartObjectCreation Dummy
    on isChecked return mcrUtils.IsCreating Dummy 
)
------------------------------------------------------------------------------
macroScript Point 
            category:~POINT_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~POINT_TOOLTIP~ 
			ButtonText:~POINT_BUTTONTEXT~
            Icon:#("Helpers",2)
(
    on execute do StartObjectCreation Point
    on isChecked return mcrUtils.IsCreating Point 
)
------------------------------------------------------------------------------
macroScript Protractor 
            category:~PROTRACTOR_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~PROTRACTOR_TOOLTIP~
			ButtonText:~PROTRACTOR_BUTTONTEXT~ 
            Icon:#("Helpers",3)
(
    on execute do StartObjectCreation Protractor
    on isChecked return mcrUtils.IsCreating Protractor
)
------------------------------------------------------------------------------
macroScript Grid 
            category:~GRID_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~GRID_TOOLTIP~
			ButtonText:~GRID_BUTTONTEXT~ 
            Icon:#("Helpers",4)
(
    on execute do StartObjectCreation Grid
    on isChecked return mcrUtils.IsCreating Grid 
)


macroScript ActivateGrid 
            category:~ACTIVATEGRID_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~ACTIVATEGRID_TOOLTIP~
			ButtonText:~ACTIVATEGRID_BUTTONTEXT~ 

(
	On IsEnabled Return (if activegrid != $ do true)
	On IsVisible Return Filters.Is_Grid $

	On Execute Do Try(ActiveGrid = $)Catch()
)
macroScript ActivateHomeGrid 
            category:~ACTIVATEHOMEGRID_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~ACTIVATEHOMEGRID_TOOLTIP~
			ButtonText:~ACTIVATEHOMEGRID_BUTTONTEXT~ 
(
	On IsEnabled Return (if activegrid != undefined do true)
	On IsVisible Return Filters.Is_Grid $

	On Execute Do Try(max activate home grid)Catch()
)

--**********************************************************

------------------------------------------------------------------------------
macroScript Tape 
            category:~TAPE_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~TAPE_TOOLTIP~
			ButtonText:~TAPE_BUTTONTEXT~ 
            Icon:#("Helpers",5)
(
    on execute do StartObjectCreation Tape
    on isChecked return mcrUtils.IsCreating Tape 
)


------------------------------------------------------------------------------
macroScript Compass 
            category:~COMPASS_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~COMPASS_TOOLTIP~
			ButtonText:~COMPASS_BUTTONTEXT~ 
            Icon:#("Helpers",6)
(
    on execute do StartObjectCreation Compass
    on isChecked return mcrUtils.IsCreating Compass 
)


------------------------------------------------------------------------------
macroScript Boxgizmo
            category:~BOXGIZMO_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~BOXGIZMO_TOOLTIP~
			ButtonText:~BOXGIZMO_BUTTONTEXT~ 
            Icon:#("AtmosApp",1)
(
    on execute do StartObjectCreation BoxGizmo
    on isChecked return mcrUtils.IsCreating BoxGizmo 
)


------------------------------------------------------------------------------
macroScript CylGizmo 
            category:~CYLGIZMO_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~CYLGIZMO_TOOLTIP~
			ButtonText:~CYLGIZMO_BUTTONTEXT~ 
            Icon:#("AtmosApp",2)
(
    on execute do StartObjectCreation CylGizmo
    on isChecked return mcrUtils.IsCreating CylGizmo 
)


------------------------------------------------------------------------------
macroScript SphereGizmo 
            category:~SPHEREGIZMO_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~SPHEREGIZMO_TOOLTIP~
			ButtonText:~SPHEREGIZMO_BUTTONTEXT~ 
            Icon:#("AtmosApp",3)
(
    on execute do StartObjectCreation SphereGizmo
    on isChecked return mcrUtils.IsCreating SphereGizmo 
)


------------------------------------------------------------------------------
macroScript CamPoint 
            category:~CAMPOINT_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~CAMPOINT_TOOLTIP~
			ButtonText:~CAMPOINT_BUTTONTEXT~ 
            Icon:#("CamP",1)
(
    on execute do StartObjectCreation CamPoint
    on isChecked return mcrUtils.IsCreating CamPoint 
)


------------------------------------------------------------------------------
macroScript ManipConeAngle 
            category:~MANIPCONEANGLE_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~MANIPCONEANGLE_TOOLTIP~
			ButtonText:~MANIPCONEANGLE_BUTTONTEXT~ 
(
    on execute do StartObjectCreation Cone_Angle
    on isChecked return mcrUtils.IsCreating Cone_Angle
)

------------------------------------------------------------------------------
macroScript ManipPlaneAngle 
            category:~MANIPPLANEANGLE_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~MANIPPLANEANGLE_TOOLTIP~
			ButtonText:~MANIPPLANEANGLE_BUTTONTEXT~ 
(
    on execute do StartObjectCreation Plane_Angle
    on isChecked return mcrUtils.IsCreating Plane_Angle
)

------------------------------------------------------------------------------
macroScript ManipSlider 
            category:~MANIPSLIDER_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~MANIPSLIDER_TOOLTIP~
			ButtonText:~MANIPSLIDER_BUTTONTEXT~ 
(
    on execute do StartObjectCreation sliderManipulator
    on isChecked return mcrUtils.IsCreating sliderManipulator
)

------------------------------------------------------------------------------
macroScript VRMLAnchor 
            category:~VRMLANCHOR_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~VRMLANCHOR_TOOLTIP~
			ButtonText:~VRMLANCHOR_BUTTONTEXT~ 
(
    on execute do StartObjectCreation anchor
    on isChecked return mcrUtils.IsCreating anchor
)

------------------------------------------------------------------------------
macroScript VRMLAudioClip 
            category:~VRMLAUDIOCLIP_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~VRMLAUDIOCLIP_TOOLTIP~
			ButtonText:~VRMLAUDIOCLIP_BUTTONTEXT~ 
(
    on execute do StartObjectCreation audioclip
    on isChecked return mcrUtils.IsCreating audioclip
)
------------------------------------------------------------------------------
macroScript VRMLBackground 
            category:~VRMLBACKGROUND_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~VRMLBACKGROUND_TOOLTIP~
			ButtonText:~VRMLBACKGROUND_BUTTONTEXT~ 
(
    on execute do StartObjectCreation background
    on isChecked return mcrUtils.IsCreating background
)

------------------------------------------------------------------------------
macroScript VRMLBillboard 
            category:~VRMLBILLBOARD_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~VRMLBILLBOARD_TOOLTIP~
			ButtonText:~VRMLBILLBOARD_BUTTONTEXT~ 
(
    on execute do StartObjectCreation billboard
    on isChecked return mcrUtils.IsCreating billboard
)

------------------------------------------------------------------------------
macroScript VRMLFog 
            category:~VRMLFOG_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~VRMLFOG_TOOLTIP~
			ButtonText:~VRMLFOG_BUTTONTEXT~ 
(
    on execute do StartObjectCreation foghelper
    on isChecked return mcrUtils.IsCreating foghelper
)

------------------------------------------------------------------------------
macroScript VRMLInline 
            category:~VRMLINLINE_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~VRMLINLINE_TOOLTIP~
			ButtonText:~VRMLINLINE_BUTTONTEXT~ 
(
    on execute do StartObjectCreation inline
    on isChecked return mcrUtils.IsCreating inline
)

------------------------------------------------------------------------------
macroScript VRMLLOD 
            category:~VRMLLOD_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~VRMLLOD_TOOLTIP~
			ButtonText:~VRMLLOD_BUTTONTEXT~ 
(
    on execute do StartObjectCreation lod
    on isChecked return mcrUtils.IsCreating lod
)

------------------------------------------------------------------------------
macroScript VRMLNavInfo 
            category:~VRMLNAVINFO_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~VRMLNAVINFO_TOOLTIP~
			ButtonText:~VRMLNAVINFO_BUTTONTEXT~ 
(
    on execute do StartObjectCreation NavInfo
    on isChecked return mcrUtils.IsCreating NavInfo
)

------------------------------------------------------------------------------
macroScript VRMLProxSensor 
            category:~VRMLPROXSENSOR_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~VRMLPROXSENSOR_TOOLTIP~
			ButtonText:~VRMLPROXSENSOR_BUTTONTEXT~ 
(
    on execute do StartObjectCreation ProxSensor
    on isChecked return mcrUtils.IsCreating ProxSensor
)

------------------------------------------------------------------------------
macroScript VRMLSound 
            category:~VRMLSOUND_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~VRMLSOUND_TOOLTIP~
			ButtonText:~VRMLSOUND_BUTTONTEXT~ 
(
    on execute do StartObjectCreation Sound
    on isChecked return mcrUtils.IsCreating Sound
)

------------------------------------------------------------------------------
macroScript VRMLTimeSensor 
            category:~VRMLTIMESENSOR_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~VRMLTIMESENSOR_TOOLTIP~
			ButtonText:~VRMLTIMESENSOR_BUTTONTEXT~ 
(
    on execute do StartObjectCreation TimeSensor
    on isChecked return mcrUtils.IsCreating TimeSensor
)

------------------------------------------------------------------------------
macroScript VRMLTouchSensor 
            category:~VRMLTOUCHSENSOR_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~VRMLTOUCHSENSOR_TOOLTIP~
			ButtonText:~VRMLTOUCHSENSOR_BUTTONTEXT~ 
(
    on execute do StartObjectCreation TouchSensor
    on isChecked return mcrUtils.IsCreating TouchSensor
)


------------------------------------------------------------------------------
macroScript Character_Studio_Delegate 
            category:~CHARACTER_STUDIO_DELEGATE_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~CHARACTER_STUDIO_DELEGATE_TOOLTIP~
			ButtonText:~CHARACTER_STUDIO_DELEGATE_BUTTONTEXT~ 
(
    on execute do StartObjectCreation Delegate
    on isChecked return mcrUtils.IsCreating Delegate
)
------------------------------------------------------------------------------
macroScript Character_Studio_Crowd
            category:~CHARACTER_STUDIO_CROWD_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~CHARACTER_STUDIO_CROWD_TOOLTIP~
			ButtonText:~CHARACTER_STUDIO_CROWD_BUTTONTEXT~ 
(
    on execute do StartObjectCreation Crowd
    on isChecked return mcrUtils.IsCreating Crowd
)

------------------------------------------------------------------------------
macroScript ExposeTM
            category:~EXPOSETM_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~EXPOSETM_TOOLTIP~
			ButtonText:~EXPOSETM_BUTTONTEXT~ 
(
    on execute do StartObjectCreation ExposeTm
    on isChecked return mcrUtils.IsCreating ExposeTm
)

------------------------------------------------------------------------------
macroScript Container
            category:~CONTAINER_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~CONTAINER_TOOLTIP~
			ButtonText:~CONTAINER_BUTTONTEXT~ 
(
    on execute do StartObjectCreation Container
    on isChecked return mcrUtils.IsCreating Container
)

------------------------------------------------------------------------------
-- CAT entities
macroScript CATParent
            category:~CATOBJECTS_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~CATPARENT_TOOLTIP~
			ButtonText:~CATPARENT_BUTTONTEXT~ 
(
    on execute do StartObjectCreation CATParent
    on isChecked return mcrUtils.IsCreating CATParent
)

macroScript CATMuscle
            category:~CATOBJECTS_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~CATMUSCLE_TOOLTIP~
			ButtonText:~CATMUSCLE_BUTTONTEXT~ 
(
    on execute do StartObjectCreation CATMuscle
    on isChecked return mcrUtils.IsCreating CATMuscle
)

macroScript CATMuscleStrand
            category:~CATOBJECTS_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~CATSTRAND_TOOLTIP~
			ButtonText:~CATSTRAND_BUTTONTEXT~ 
(
    on execute do StartObjectCreation Muscle_Strand
    on isChecked return mcrUtils.IsCreating Muscle_Strand
)

macroScript InfluenceHelper
            category:~INFLUENCEHELPER_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~INFLUENCEHELPER_TOOLTIP~
			ButtonText:~INFLUENCEHELPER_BUTTONTEXT~ 
(
    on execute do StartObjectCreation InfluenceHelper
    on isChecked return mcrUtils.IsCreating InfluenceHelper
)

macroScript ArrowHelper
            category:~ARROWHELPER_CATEGORY~ 
            internalCategory:"Objects Helpers" 
            tooltip:~ARROWHELPER_TOOLTIP~
			ButtonText:~ARROWHELPER_BUTTONTEXT~ 
(
    on execute do StartObjectCreation ArrowHelper
    on isChecked return mcrUtils.IsCreating ArrowHelper
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEA5dK+WnG5bDemPmWVSBRBgw
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTcwODA0MDAwMDAwWhcNMTgwODA0MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBALPR50hy1FkrWOBmP+sGXfKWFUpFAKB9OLDlN3Uj
-- 94WBLdHje+wsBav/AOL1Ben4qOa74PWpJHTJd8jph4MSGhKZE3oFNPyAVXCVhUAj
-- qlLaYQXkHDWMeyz+y7FWX4oK1B1H+SNVcnc2+kAB0bEIT4VAIvQcyva41ThpVGzP
-- XZM/JKDDpA6tocMQ3935UAjHYuvoOADEkFt5O/lEWzPTz0aQkVLGiD18rgFxuSw+
-- Uz2jyuDZZ5lyNBQRF+K4cu8fle9uL2WqbaO7koHz76dkJrNW9wAmkdGCdfj3MQo+
-- OD4O5JjSMYHEcmjVbHyo+ZK/BIVykApxc0tfN2HRJSuHlG0CAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBALfg
-- FRNU3/Np7SJ5TRs8s8tPnOTd4D5We+stLCuQ0I1kjVIyiIY+Z3cQz2AB9x8VXuYF
-- LcXnT6Rc1cMYJtlTyB7Z7EZkfxQmFgc4chVfnguTpPqUtfo3QMT/S1+QIdYfIbk1
-- dSvFBmZwRGatmGbn2h7HGiIgNqQaO6TD7Fx9TEJPwIiiCK8F3b4ENpYQHlgH3OAd
-- CRLa1IWPfeA03yF3PIq8+NhLsngw1FNm9+C6UOM3mf3jHwxTrbt4ooIZstjPA4PU
-- G16FkhJg7l2RCDR6sE9iT7FMCsO6tAHX3pS8afFyNyEVfgJVKfzohdDOj+XQLkzp
-- c9v3Xoh1gTIPCte7VPsxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQDl0r5acblsN6Y+ZZVIFEGDANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQCd8LRBCLVBAgc5n9NQSgyF+PfzPMNlXvS8
-- UKph0OEsM4efLWw/IPaJF9DVJEYl4maNhzA0LGTIfwlDFZd75gydeIQDscpH+M6R
-- LEU7dgKuA4+dETI8610crEG/Q7snbC1ieKJZxbELIoV7AAydQTLPjz4+Sgqgv9za
-- W3t2ve8U32g4ugDLBCkvjZke13xthqmd4RwunyZObqJAZr42yEmTUezAwwfpnxoE
-- O+Opj2VDcocPNMrQeU/+1TqiaRtA8ka/7AlHEoMBxcIv0h0ejD43JbR5af9otYAd
-- cXi+LmkX6/US3leVVNn6plox3hAmOfPcxLn3u+8uMZNx0XfpZ0KZ
-- -----END-SIGNATURE-----